<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddLabelToExtraValuesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('extra_values', function (Blueprint $table) {
            $table->string('label')->nullable()->after('value'); // Add 'label' column
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('extra_values', function (Blueprint $table) {
            $table->dropColumn('label'); // Remove 'label' column on rollback
        });
    }
}
