<?php
declare(strict_types=1);

namespace App\Services\EmailSettingService;

use App\Helpers\ResponseError;
use App\Models\EmailSetting;
use App\Models\EmailSubscription;
use App\Models\EmailTemplate;
use App\Models\Gallery;
use App\Models\Order;
use App\Models\Settings;
use App\Models\Translation;
use App\Models\User;
use App\Services\CoreService;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Exception;
use Illuminate\Support\Facades\Cache;
use Log;
use PHPMailer\PHPMailer\PHPMailer;
use Storage;
use Throwable;
use View;

class EmailSendService extends CoreService
{
    /**
     * @return string
     */
    protected function getModelClass(): string
    {
        return EmailSetting::class;
    }

    public function sendSubscriptions(EmailTemplate $emailTemplate): array
    {
        $mail = new PHPMailer(true);

        try {
            $emailSetting = $emailTemplate->emailSetting;

            $mail->CharSet = 'UTF-8';

            // Настройки SMTP
            /*$mail->isSMTP();
            $mail->SMTPAuth     = $emailSetting->smtp_auth;
            $mail->SMTPDebug    = $emailSetting->smtp_debug;*/

            $mail->Host         = $emailSetting->host;
            $mail->Port         = $emailSetting->port;
            $mail->Username     = $emailSetting->from_to;
            $mail->Password     = $emailSetting->password;
            $mail->SMTPSecure   = PHPMailer::ENCRYPTION_STARTTLS;
 $mail->SMTPDebug = 3; // Set to 2 or 3 for detailed debug output
$mail->Debugoutput = function ($str, $level) {
    Log::info("SMTP Debug $level: $str");
};

            $mail->SMTPOptions  = $emailSetting->ssl ?: [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                ]
            ];
            // От кого
            $mail->setFrom($emailSetting->from_to, $emailSetting->from_site);

            // Кому

            foreach (EmailSubscription::where('active', true)->get() as $subscribe) {

                /** @var EmailSubscription $subscribe */
                $email = data_get($subscribe->user, 'email');

                if (!empty($email)) {
                    $mail->addAddress($email, data_get($subscribe->user, 'firstname', 'User'));
                }

            }

            // Тема письма
            $mail->Subject = $emailTemplate->subject;

            // Тело письма
            $mail->isHTML();
            $mail->Body    = $emailTemplate->body; // <p><strong>«Hello, world!» </strong></p>
            $mail->AltBody = $emailTemplate->alt_body; // Hello, world!

            // Приложение
            foreach ($emailTemplate->galleries as $gallery) {
                /** @var Gallery $gallery */
                try {
                    $mail->addAttachment(request()->getHttpHost() . '/storage/' . $gallery->path);
                } catch (Throwable) {
                    Log::error($mail->ErrorInfo);
                }
            }

            $mail->send();
            return [
                'status' => true,
                'code' => ResponseError::NO_ERROR,
            ];

        } catch (Exception) {
            Log::error($mail->ErrorInfo);
            return [
                'message'   => $mail->ErrorInfo,
                'status'    => false,
                'code'      => ResponseError::ERROR_504,
            ];
        }
    }

    // public function sendVerify(User $user): array
    // {
    //     $emailTemplate = EmailTemplate::where('type', EmailTemplate::TYPE_VERIFY)->first();

    //     $mail = $this->emailBaseAuth($emailTemplate, $user);

    //     try {

    //         $mail->Subject  = data_get($emailTemplate, 'subject', 'Verify your email address');

    //         $default        = 'Please enter code for verify your email: $verify_code';
    //         $body           = data_get($emailTemplate, 'body', $default);
    //         $altBody        = data_get($emailTemplate, 'alt_body', $default);

    //         $mail->Body     = str_replace('$verify_code', $user->verify_token, $body);
    //         $mail->AltBody  = str_replace('$verify_code', $user->verify_token, $altBody);

    //         if (!empty(data_get($emailTemplate, 'galleries'))) {
    //             foreach ($emailTemplate->galleries as $gallery) {
    //                 /** @var Gallery $gallery */
    //                 try {
    //                     $mail->addAttachment(request()->getHttpHost() . '/storage/' . $gallery->path);
    //                 } catch (Throwable) {
    //                     Log::error($mail->ErrorInfo);
    //                 }
    //             }
    //         }

    //         $mail->send();

    //         return [
    //             'status' => true,
    //             'code' => ResponseError::NO_ERROR,
    //         ];
    //     } catch (Exception $e) {
    //         Log::error('ErrorInfo', [
    //             $mail->ErrorInfo
    //         ]);
    //         $this->error($e);
    //         return [
    //             'message'   => $mail->ErrorInfo,
    //             'status'    => false,
    //             'code'      => ResponseError::ERROR_504,
    //         ];
    //     }
    // }
    
    public function sendVerify(User $user): array
    {
        $emailTemplate = EmailTemplate::where('type', EmailTemplate::TYPE_VERIFY)->first();
    
        $mail = $this->emailBaseAuth($emailTemplate, $user);
        $from = $mail->From;
        $fromName = $mail->FromName;
        $host = $mail->Host;
        $password = $mail->Password;
         $port = $mail->Port;
    
        $mail->SMTPDebug = 3; // Debug for detailed output
        $mail->isSMTP(); 
        $mail->Debugoutput = function ($str, $level) {
            Log::info("SMTP Debug $level: $str");
        };
    
        // SMTP Configuration
        $mail->Host       = $host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $from; // Replace with actual username
        $mail->Password   = $password; // Use environment variable for better security
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; 
        $mail->Port       = $port;
        $mail->Timeout    = 30;
    
        try {
            $mail->Subject = data_get($emailTemplate, 'subject', 'Verify your email address');
    
            $default  = 'Please enter code for verify your email: $verify_code';
            $body     = data_get($emailTemplate, 'body', $default);
            $altBody  = data_get($emailTemplate, 'alt_body', $default);
    
            $mail->Body    = str_replace('$verify_code', $user->verify_token, $body);
            $mail->AltBody = str_replace('$verify_code', $user->verify_token, $altBody);
    
            if (!empty(data_get($emailTemplate, 'galleries'))) {
                foreach ($emailTemplate->galleries as $gallery) {
                    try {
                        $attachmentPath = request()->getHttpHost() . '/storage/' . $gallery->path;
                        $mail->addAttachment($attachmentPath);
                        Log::info("Attachment added: $attachmentPath");
                    } catch (Throwable $e) {
                        Log::error("Error adding attachment: {$e->getMessage()}");
                    }
                }
            }
    
            Log::info('Preparing to send email', [
                'SMTP Host' => $mail->Host,
                'SMTP Port' => $mail->Port,
                'From'      => $mail->From,
                'To'        => implode(', ', array_column($mail->getToAddresses(), 0)),
                'Subject'   => $mail->Subject,
                'Body'      => $mail->Body,
            ]);
    
            $mail->send();
            Log::info('Mail sent successfully');
            return [
                'status' => true,
                'code'   => ResponseError::NO_ERROR,
            ];
    
        } catch (Exception $e) {
            Log::error('Error while sending email', [
                'ErrorInfo' => $mail->ErrorInfo,
                'Exception' => $e->getMessage(),
            ]);
            return [
                'message' => 'Email sending failed: ' . $e->getMessage(),
                'status'  => false,
                'code'    => ResponseError::ERROR_504,
            ];
        }
    }



    public function sendEmailPasswordReset(User $user, $str): array
    {
        $emailTemplate = EmailTemplate::where('type', EmailTemplate::TYPE_VERIFY)->first();

        $mail = $this->emailBaseAuth($emailTemplate, $user);
           $from = $mail->From;
        $fromName = $mail->FromName;
        $host = $mail->Host;
        $password = $mail->Password;
         $port = $mail->Port;
    
        $mail->SMTPDebug = 3; // Debug for detailed output
        $mail->isSMTP(); 
        $mail->Debugoutput = function ($str, $level) {
            Log::info("SMTP Debug $level: $str");
        };
    
        // SMTP Configuration
        $mail->Host       = $host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $from; // Replace with actual username
        $mail->Password   = $password; // Use environment variable for better security
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; 
        $mail->Port       = $port;
        $mail->Timeout    = 30;

        try {

            $mail->Subject  = data_get($emailTemplate, 'subject', 'Reset password');

            $default        = 'Please enter code for reset your password: $verify_code';
            $body           = data_get($emailTemplate, 'body', $default);
            $altBody        = data_get($emailTemplate, 'alt_body', $default);

            $mail->Body     = str_replace('$verify_code', $str, $body);
            $mail->AltBody  = str_replace('$verify_code', $str, $altBody);

            if (!empty(data_get($emailTemplate, 'galleries'))) {
                foreach ($emailTemplate->galleries as $gallery) {
                    /** @var Gallery $gallery */
                    try {
                        $mail->addAttachment(request()->getHttpHost() . '/storage/' . $gallery->path);
                    } catch (Throwable) {
                        Log::error($mail->ErrorInfo);
                    }
                }
            }
       Log::info('Preparing to send email forgot', [
                'SMTP Host' => $mail->Host,
                'SMTP Port' => $mail->Port,
                'From'      => $mail->From,
                'To'        => implode(', ', array_column($mail->getToAddresses(), 0)),
                'Subject'   => $mail->Subject,
                'Body'      => $mail->Body,
            ]);
            $mail->send();

            return [
                'status' => true,
                'code' => ResponseError::NO_ERROR,
            ];
        } catch (Exception $e) {
            Log::error('ErrorInfo', [
                $mail->ErrorInfo
            ]);
            $this->error($e);
            return [
                'message'   => $mail->ErrorInfo,
                'status'    => false,
                'code'      => ResponseError::ERROR_504,
            ];
        }
    }

    /**
     * @param Order $order
     * @return array
     */
    public function sendOrder(Order $order): array
    {
        Pdf::setOption(['dpi' => 150, 'defaultFont' => 'sans-serif']);

        $titleKey = "order.email.invoice.$order->status.title";
        $title    = Translation::where(['locale' => $this->language, 'key' => $titleKey])->first()?->value ?? $titleKey;
        $logo     = Settings::where('key', 'logo')->first()?->value;
        $fileName = null;
        $host     = request()->getSchemeAndHttpHost();

        if ($logo) {

            $id   = auth('sanctum')->id() ?? "0001";
            $ext  = strtolower(preg_replace("#.+\.([a-z]+)$#i", "$1", $logo));
            $unix = now()->unix();

            $fileName = "$id-$unix.$ext";

            Storage::put("public/images/$fileName", file_get_contents($logo));
        }

        $pdf = View::make(
            'order-email-invoice',
            [
                'order' => $order,
                'lang'  => $this->language,
                'title' => $title,
                'logo'  => $fileName ? "$host/storage/images/$fileName" : '',
            ]
        )->render();

        try {
            $mail           = $this->emailBaseAuth(EmailSetting::first(), $order->user);
            $mail->Subject  = $title;
            $mail->Body     = $pdf;
            $mail->addCustomHeader('MIME-Version', '1.0');
            $mail->addCustomHeader('Content-type', 'text/html;charset=UTF-8');
            $mail->send();

            Storage::delete(storage_path("images/$fileName"));

            return [
                'status' => true,
                'code'   => ResponseError::NO_ERROR,
            ];
        } catch (Exception $e) {
            $this->error($e);
            return [
                'message' => $e->getMessage(), //$mail->ErrorInfo,
                'status'  => false,
                'code'    => ResponseError::ERROR_504,
            ];
        }
    }

    public function emailBaseAuth(?EmailTemplate $emailTemplate, User $user): PHPMailer
    {

        /** @var EmailSetting $emailSetting */
        $emailSetting = $emailTemplate?->emailSetting ?? EmailSetting::first();

        $mail = new PHPMailer(true);
        $mail->isHTML();
        $mail->CharSet = 'UTF-8';
        $mail->isSMTP();
        $mail->SMTPAuth     = true;
        $mail->SMTPDebug    = $emailSetting->smtp_debug;
        $mail->Host         = 'smtp-relay.brevo.com';
//       if ($emailSetting->port === 465) {
//     $mail->Port       = 465;
//     $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Implicit SSL/TLS
// } else {
    // Covers port 587 or any STARTTLS port like 2525
    $mail->Port       =587;
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // STARTTLS protocol
    $mail->SMTPAutoTLS = true;                          // Enables opportunistic upgrade
//}

        $mail->Username     ='9065e7001@smtp-brevo.com';
        $mail->Password     ='4mYRpzaqrjLBbJOC';
        // $mail->SMTPSecure   = PHPMailer::ENCRYPTION_STARTTLS;
      $mail->SMTPOptions = $emailSetting->ssl;

        if (!Cache::get('rjkcvd.ewoidfh') || data_get(Cache::get('rjkcvd.ewoidfh'), 'active') != 1) {
            abort(403);
        }

        try {

            $mail->setFrom('noreply@premfashions.com', 'Premfashions');
            $mail->addAddress($user->email, $user->name_or_email);

        } catch (Throwable $e) {
            Log::error($mail->ErrorInfo);
            $this->error($e);
        }

        return $mail;
    }
    
    //old
    //   public function emailBaseAuth(?EmailTemplate $emailTemplate, User $user): PHPMailer
    // {

    //     /** @var EmailSetting $emailSetting */
    //     $emailSetting = $emailTemplate?->emailSetting ?? EmailSetting::first();

    //     $mail = new PHPMailer(true);
    //     $mail->isHTML();
    //     $mail->CharSet = 'UTF-8';
    //     /*$mail->isSMTP();
    //     $mail->SMTPAuth     = $emailSetting->smtp_auth;
    //     $mail->SMTPDebug    = $emailSetting->smtp_debug;*/
    //     $mail->Host         = $emailSetting->host;
    //     $mail->Port         = $emailSetting->port;
    //     $mail->Username     = $emailSetting?->from_to;
    //     $mail->Password     = $emailSetting?->password;
    //     $mail->SMTPSecure   = PHPMailer::ENCRYPTION_STARTTLS;
    //     $mail->SMTPOptions  = data_get($emailSetting, 'ssl.ssl.verify_peer') ? $emailSetting->ssl : [
    //         'ssl' => [
    //             'verify_peer' => false,
    //             'verify_peer_name' => false,
    //             'allow_self_signed' => true
    //         ]
    //     ];

    //     if (!Cache::get('rjkcvd.ewoidfh') || data_get(Cache::get('rjkcvd.ewoidfh'), 'active') != 1) {
    //         abort(403);
    //     }

    //     try {

    //         $mail->setFrom($emailSetting->from_to, $emailSetting->from_site);
    //         $mail->addAddress($user->email, $user->name_or_email);

    //     } catch (Throwable $e) {
    //         Log::error($mail->ErrorInfo);
    //         $this->error($e);
    //     }

    //     return $mail;
    // }
}
