<?php
declare(strict_types=1);

namespace App\Http\Controllers\API\v1\Dashboard\Admin;

use App\Helpers\ResponseError;
use App\Http\Requests\TermCondition\StoreRequest;
use App\Models\TermCondition;
use App\Services\TermService\TermService;
use Illuminate\Http\JsonResponse;

class TermsController extends AdminBaseController
{

    public function __construct(private TermService $service)
    {
        parent::__construct();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreRequest $request
     * @return JsonResponse
     */
    public function store(StoreRequest $request): JsonResponse
    {
        $termCondition = $this->service->create($request->validated());

        if (!data_get($termCondition, 'status')) {
            return $this->onErrorResponse(['code' => ResponseError::ERROR_501]);
        }

        return $this->successResponse(
            __('errors.' . ResponseError::RECORD_WAS_SUCCESSFULLY_CREATED, locale: $this->language),
            $termCondition
        );
    }

    /**
     * Display the specified resource.
     *
     * @return JsonResponse
     */
public function show(): JsonResponse
{
    $locale = request('lang', 'en'); // fallback to 'en'

    $termCondition = TermCondition::with(['translations' => function ($query) use ($locale) {
        $query->where('locale', $locale);
    }])->first();

    if (!$termCondition || $termCondition->translations->isEmpty()) {
        return $this->onErrorResponse([
            'code' => ResponseError::ERROR_404,
            'message' => "Item's not found."
        ]);
    }

    return $this->successResponse(
        __('errors.' . ResponseError::NO_ERROR, locale: $locale),
        $termCondition
    );
}



    /**
     * @return JsonResponse
     */
    public function dropAll(): JsonResponse
    {
        $this->service->dropAll();

        return $this->successResponse(
            __('errors.' . ResponseError::RECORD_WAS_SUCCESSFULLY_DELETED, locale: $this->language),
            []
        );
    }
}
