<?php
declare(strict_types=1);

namespace App\Helpers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log; // Import the Log facade

class TokenHelper
{
    /**
     * Verify the MSG91 access token
     *
     * @param string $accessToken
     * @return bool
     */
    public static function verifyAccessToken(string $accessToken): bool
    {
        $authKey = "277152AZSOrwk6YD67b2d42dP1";

        try {
            $response = Http::post('https://control.msg91.com/api/v5/widget/verifyAccessToken', [
                'authkey' => $authKey,
                'access-token' => $accessToken,
            ]);

            // Get the response data
            $data = $response->json();

            // Log the entire response data
            Log::info('MSG91 Token Verification Response:', $data);

            // Check if the response status is success
            return isset($data['type']) && $data['type'] === 'success';

        } catch (\Exception $e) {
            // Log any exceptions that occur during the request
            Log::error('MSG91 Token Verification Error:', [
                'message' => $e->getMessage(),
                'access_token' => $accessToken,
            ]);

            return false; // Return false on error
        }
    }
}