/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `ads_package_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_package_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ads_package_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `button_text` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_package_translations_ads_package_id_locale_unique` (`ads_package_id`,`locale`),
  KEY `ads_package_translations_locale_index` (`locale`),
  CONSTRAINT `ads_package_translations_ads_package_id_foreign` FOREIGN KEY (`ads_package_id`) REFERENCES `ads_packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ads_package_translations` WRITE;
/*!40000 ALTER TABLE `ads_package_translations` DISABLE KEYS */;
INSERT INTO `ads_package_translations` VALUES (1,1,'en','Game','Game APP',NULL),(2,2,'en','cutton shirt','cutton shirt',NULL),(3,3,'en','Exclusive Diwali Sale – Limited Time Offer!','Grab the best deals on electronics, fashion, and more this festive season. Don’t miss out—shop now and save big!',NULL);
/*!40000 ALTER TABLE `ads_package_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ads_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Активный',
  `type` varchar(255) NOT NULL DEFAULT 'main' COMMENT 'Где будет выходить',
  `time_type` varchar(255) NOT NULL DEFAULT 'day' COMMENT 'Тип времени рекламы: минут,час,день,недель,месяц,год',
  `time` smallint(6) NOT NULL COMMENT 'Время',
  `price` double NOT NULL DEFAULT 0,
  `product_limit` smallint(6) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `position_page` smallint(6) NOT NULL DEFAULT 1 COMMENT 'На какой странице будет выходить',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ads_packages` WRITE;
/*!40000 ALTER TABLE `ads_packages` DISABLE KEYS */;
INSERT INTO `ads_packages` VALUES (1,1,'main_left_banner','minute',1,122,NULL,'2025-01-22 02:17:05','2025-01-22 02:17:05',1),(2,1,'standard','hour',3,100,NULL,'2025-02-05 04:31:52','2025-02-05 04:31:52',1),(3,1,'standard','month',8,100,NULL,'2025-02-05 23:59:01','2025-02-05 23:59:01',1);
/*!40000 ALTER TABLE `ads_packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `area_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `area_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `area_translations_area_id_locale_unique` (`area_id`,`locale`),
  KEY `area_translations_locale_index` (`locale`),
  CONSTRAINT `area_translations_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `area_translations` WRITE;
/*!40000 ALTER TABLE `area_translations` DISABLE KEYS */;
INSERT INTO `area_translations` VALUES (1,1,'en','Vinobnagara');
/*!40000 ALTER TABLE `area_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `areas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `areas_region_id_foreign` (`region_id`),
  KEY `areas_country_id_foreign` (`country_id`),
  KEY `areas_city_id_foreign` (`city_id`),
  CONSTRAINT `areas_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `areas_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `areas_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `areas` WRITE;
/*!40000 ALTER TABLE `areas` DISABLE KEYS */;
INSERT INTO `areas` VALUES (1,1,1,1,1);
/*!40000 ALTER TABLE `areas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assign_shop_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assign_shop_tags` (
  `shop_tag_id` bigint(20) unsigned NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  KEY `assign_shop_tags_shop_tag_id_foreign` (`shop_tag_id`),
  KEY `assign_shop_tags_shop_id_foreign` (`shop_id`),
  CONSTRAINT `assign_shop_tags_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `assign_shop_tags_shop_tag_id_foreign` FOREIGN KEY (`shop_tag_id`) REFERENCES `shop_tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assign_shop_tags` WRITE;
/*!40000 ALTER TABLE `assign_shop_tags` DISABLE KEYS */;
INSERT INTO `assign_shop_tags` VALUES (2,501);
/*!40000 ALTER TABLE `assign_shop_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `backup_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `path` varchar(191) DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backup_histories_created_by_foreign` (`created_by`),
  CONSTRAINT `backup_histories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `backup_histories` WRITE;
/*!40000 ALTER TABLE `backup_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banner_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `banner_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `banner_id` bigint(20) unsigned NOT NULL,
  `interval` double NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `banner_products_product_id_foreign` (`product_id`),
  KEY `banner_products_banner_id_foreign` (`banner_id`),
  CONSTRAINT `banner_products_banner_id_foreign` FOREIGN KEY (`banner_id`) REFERENCES `banners` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `banner_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banner_products` WRITE;
/*!40000 ALTER TABLE `banner_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `banner_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banner_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `banner_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `banner_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `button_text` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `banner_translations_banner_id_locale_unique` (`banner_id`,`locale`),
  KEY `banner_translations_locale_index` (`locale`),
  CONSTRAINT `banner_translations_banner_id_foreign` FOREIGN KEY (`banner_id`) REFERENCES `banners` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banner_translations` WRITE;
/*!40000 ALTER TABLE `banner_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `banner_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `banners` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(191) DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'banner',
  `img` varchar(191) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `clickable` tinyint(1) NOT NULL DEFAULT 1,
  `input` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `banners_type_index` (`type`),
  KEY `banners_shop_id_foreign` (`shop_id`),
  CONSTRAINT `banners_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banners` WRITE;
/*!40000 ALTER TABLE `banners` DISABLE KEYS */;
/*!40000 ALTER TABLE `banners` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `blog_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `blog_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `short_desc` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `blog_translations_blog_id_locale_unique` (`blog_id`,`locale`),
  KEY `blog_translations_locale_index` (`locale`),
  CONSTRAINT `blog_translations_blog_id_foreign` FOREIGN KEY (`blog_id`) REFERENCES `blogs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `blog_translations` WRITE;
/*!40000 ALTER TABLE `blog_translations` DISABLE KEYS */;
INSERT INTO `blog_translations` VALUES (1,1,'en','🎉 Diwali Dhamaka Sale – Biggest Festive Discounts','depavali offerCelebrate Diwali with unbeatable off','<p>Light up your Diwali with amazing deals! 🪔 Enjoy big discounts on fashion, electronics, and more. Shop now and save big this festive season! 🎉🔥</p>'),(2,2,'en','Tips for Smart Online Shopping','Discover simple ways to save money and shop safely online.','<p>Learn the best tips for smart online shopping—find great deals, compare prices, and ensure secure payments. Shop smarter and safer today!</p>');
/*!40000 ALTER TABLE `blog_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `blogs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT 1,
  `published_at` date DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(191) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_user_id_foreign` (`user_id`),
  KEY `blogs_uuid_index` (`uuid`),
  KEY `blogs_type_index` (`type`),
  CONSTRAINT `blogs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
INSERT INTO `blogs` VALUES (1,'11c418ba-da7a-4d8c-9ddb-36a2e0c70b55',103,2,NULL,1,NULL,0,0,0,'2025-02-05 04:19:58','2025-02-05 04:19:58'),(2,'802c391a-6374-4807-b1c1-47e2e9623535',103,1,NULL,1,'https://premfashion.webschedio.in/storage/images/blogs/103-17388174242300.webp',0,0,0,'2025-02-05 23:20:36','2025-02-05 23:20:36');
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bonuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bonuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `stock_id` bigint(20) unsigned DEFAULT NULL,
  `bonus_quantity` int(11) NOT NULL,
  `bonus_stock_id` bigint(20) unsigned DEFAULT NULL,
  `value` int(11) NOT NULL,
  `type` enum('count','sum') NOT NULL,
  `expired_at` datetime NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bonuses_shop_id_foreign` (`shop_id`),
  KEY `bonuses_stock_id_foreign` (`stock_id`),
  KEY `bonuses_bonus_stock_id_foreign` (`bonus_stock_id`),
  CONSTRAINT `bonuses_bonus_stock_id_foreign` FOREIGN KEY (`bonus_stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bonuses_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bonuses_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bonuses` WRITE;
/*!40000 ALTER TABLE `bonuses` DISABLE KEYS */;
/*!40000 ALTER TABLE `bonuses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `brands` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `title` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_shop_id_foreign` (`shop_id`),
  KEY `brands_uuid_index` (`uuid`),
  CONSTRAINT `brands_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,'jockey-0','c427f4c0-fb63-4b98-938c-ab86c26096bb','Jockey',1,'https://premfashion.webschedio.in/storage/images/brands/103-17397909454063.webp',NULL,'2025-02-05 03:17:44','2025-02-17 05:46:39');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `career_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `career_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `career_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address`)),
  PRIMARY KEY (`id`),
  UNIQUE KEY `career_translations_career_id_locale_unique` (`career_id`,`locale`),
  KEY `career_translations_locale_index` (`locale`),
  CONSTRAINT `career_translations_career_id_foreign` FOREIGN KEY (`career_id`) REFERENCES `careers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `career_translations` WRITE;
/*!40000 ALTER TABLE `career_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `career_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `careers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `careers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `location` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`location`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `careers_category_id_foreign` (`category_id`),
  CONSTRAINT `careers_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `careers` WRITE;
/*!40000 ALTER TABLE `careers` DISABLE KEYS */;
/*!40000 ALTER TABLE `careers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cart_detail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cart_detail_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cart_detail_id` bigint(20) unsigned NOT NULL,
  `stock_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `price` double DEFAULT NULL,
  `bonus` tinyint(1) NOT NULL DEFAULT 0,
  `discount` double NOT NULL DEFAULT 0,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_detail_products_cart_detail_id_foreign` (`cart_detail_id`),
  KEY `cart_detail_products_stock_id_foreign` (`stock_id`),
  KEY `cart_detail_products_parent_id_foreign` (`parent_id`),
  CONSTRAINT `cart_detail_products_cart_detail_id_foreign` FOREIGN KEY (`cart_detail_id`) REFERENCES `cart_details` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_detail_products_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `cart_details` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_detail_products_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cart_detail_products` WRITE;
/*!40000 ALTER TABLE `cart_detail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `cart_detail_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cart_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cart_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `user_cart_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `shop_tax` double DEFAULT NULL,
  `total_price` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_details_shop_id_foreign` (`shop_id`),
  KEY `cart_details_user_cart_id_foreign` (`user_cart_id`),
  KEY `cart_details_discount_index` (`discount`),
  KEY `cart_details_shop_tax_index` (`shop_tax`),
  KEY `cart_details_total_price_index` (`total_price`),
  CONSTRAINT `cart_details_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_details_user_cart_id_foreign` FOREIGN KEY (`user_cart_id`) REFERENCES `user_carts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cart_details` WRITE;
/*!40000 ALTER TABLE `cart_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cart_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `carts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` bigint(20) unsigned NOT NULL,
  `total_price` double DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `rate` double NOT NULL DEFAULT 1,
  `group` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `carts_owner_id_foreign` (`owner_id`),
  KEY `carts_currency_id_foreign` (`currency_id`),
  KEY `carts_region_id_foreign` (`region_id`),
  KEY `carts_country_id_foreign` (`country_id`),
  KEY `carts_city_id_foreign` (`city_id`),
  KEY `carts_area_id_foreign` (`area_id`),
  CONSTRAINT `carts_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `carts_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `carts_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `carts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `carts_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `carts_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `carts` WRITE;
/*!40000 ALTER TABLE `carts` DISABLE KEYS */;
INSERT INTO `carts` VALUES (1,102,2222.11,1,2,1,1,1,NULL,1,0,'2025-01-22 23:58:42','2025-01-28 04:35:44'),(33,103,2171.5,1,2,1,1,1,NULL,1,0,'2025-02-18 02:56:04','2025-03-26 00:53:02'),(96,162,0,1,2,1,1,1,NULL,1,0,'2025-06-18 06:24:23','2025-06-18 06:59:08');
/*!40000 ALTER TABLE `carts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `keywords` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `type` tinyint(4) NOT NULL DEFAULT 1,
  `input` int(11) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `age_limit` smallint(6) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_shop_id_foreign` (`shop_id`),
  KEY `categories_uuid_index` (`uuid`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `category_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_translations_category_id_locale_unique` (`category_id`,`locale`),
  KEY `category_translations_locale_index` (`locale`),
  CONSTRAINT `category_translations_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `category_translations` WRITE;
/*!40000 ALTER TABLE `category_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `category_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cities_region_id_foreign` (`region_id`),
  KEY `cities_country_id_foreign` (`country_id`),
  CONSTRAINT `cities_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `cities_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,1,1,1);
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `city_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `city_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `city_translations_city_id_locale_unique` (`city_id`,`locale`),
  KEY `city_translations_locale_index` (`locale`),
  CONSTRAINT `city_translations_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `city_translations` WRITE;
/*!40000 ALTER TABLE `city_translations` DISABLE KEYS */;
INSERT INTO `city_translations` VALUES (1,1,'en','Shivamogga');
/*!40000 ALTER TABLE `city_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `img` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL COMMENT 'iso2',
  PRIMARY KEY (`id`),
  KEY `countries_region_id_foreign` (`region_id`),
  CONSTRAINT `countries_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,1,1,'https://flagcdn.com/224x168/in.png','ind');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `country_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `country_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_translations_country_id_locale_unique` (`country_id`,`locale`),
  KEY `country_translations_locale_index` (`locale`),
  CONSTRAINT `country_translations_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `country_translations` WRITE;
/*!40000 ALTER TABLE `country_translations` DISABLE KEYS */;
INSERT INTO `country_translations` VALUES (1,1,'en','INDIA');
/*!40000 ALTER TABLE `country_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `coupon_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `coupon_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coupon_translations_coupon_id_locale_unique` (`coupon_id`,`locale`),
  KEY `coupon_translations_locale_index` (`locale`),
  CONSTRAINT `coupon_translations_coupon_id_foreign` FOREIGN KEY (`coupon_id`) REFERENCES `coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `coupon_translations` WRITE;
/*!40000 ALTER TABLE `coupon_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `coupon_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('fix','percent') NOT NULL DEFAULT 'fix',
  `qty` int(11) NOT NULL DEFAULT 0,
  `price` double NOT NULL DEFAULT 0,
  `expired_at` datetime NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `for` varchar(255) NOT NULL DEFAULT 'total_price',
  `shop_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coupons_name_shop_id_unique` (`name`,`shop_id`),
  KEY `coupons_shop_id_foreign` (`shop_id`),
  KEY `coupons_name_index` (`name`),
  CONSTRAINT `coupons_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `coupons` WRITE;
/*!40000 ALTER TABLE `coupons` DISABLE KEYS */;
INSERT INTO `coupons` VALUES (1,'DIWALI2025','fix',4,150,'2025-02-28 00:00:00',NULL,'delivery_fee',501,'2025-02-06 01:50:16','2025-02-12 01:42:19'),(4,'New User','fix',0,100,'2025-02-28 00:00:00',NULL,'total_price',501,'2025-02-17 02:04:22','2025-02-17 06:08:50');
/*!40000 ALTER TABLE `coupons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `symbol` varchar(255) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `rate` double(9,2) NOT NULL DEFAULT 1.00,
  `position` enum('before','after') NOT NULL DEFAULT 'after',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (2,'₹','INR',1.00,'after',1,1,'2024-12-30 00:58:25','2025-01-22 05:21:37');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_point_closed_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `delivery_point_closed_dates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_point_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_point_closed_dates_delivery_point_id_foreign` (`delivery_point_id`),
  CONSTRAINT `delivery_point_closed_dates_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_point_closed_dates` WRITE;
/*!40000 ALTER TABLE `delivery_point_closed_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_point_closed_dates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_point_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `delivery_point_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_point_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `delivery_point_translations_delivery_point_id_locale_unique` (`delivery_point_id`,`locale`),
  KEY `delivery_point_translations_locale_index` (`locale`),
  CONSTRAINT `delivery_point_translations_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_point_translations` WRITE;
/*!40000 ALTER TABLE `delivery_point_translations` DISABLE KEYS */;
INSERT INTO `delivery_point_translations` VALUES (5,2,'en','shivamogga',NULL);
/*!40000 ALTER TABLE `delivery_point_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_point_working_days`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `delivery_point_working_days` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_point_id` bigint(20) unsigned NOT NULL,
  `day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') NOT NULL,
  `from` varchar(5) NOT NULL DEFAULT '9:00',
  `to` varchar(5) NOT NULL DEFAULT '21:00',
  `disabled` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_point_working_days_delivery_point_id_foreign` (`delivery_point_id`),
  CONSTRAINT `delivery_point_working_days_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_point_working_days` WRITE;
/*!40000 ALTER TABLE `delivery_point_working_days` DISABLE KEYS */;
INSERT INTO `delivery_point_working_days` VALUES (22,2,'monday','01:00','23:00',0,'2025-06-18 06:36:08','2025-06-18 06:36:08'),(23,2,'tuesday','01:00','23:00',0,'2025-06-18 06:36:08','2025-06-18 06:36:08'),(24,2,'wednesday','01:00','23:00',0,'2025-06-18 06:36:08','2025-06-18 06:36:08'),(25,2,'thursday','01:00','23:00',0,'2025-06-18 06:36:08','2025-06-18 06:36:08'),(26,2,'friday','01:00','23:00',0,'2025-06-18 06:36:08','2025-06-18 06:36:08'),(27,2,'saturday','01:00','23:00',0,'2025-06-18 06:36:08','2025-06-18 06:36:08'),(28,2,'sunday','01:00','23:00',0,'2025-06-18 06:36:08','2025-06-18 06:36:08');
/*!40000 ALTER TABLE `delivery_point_working_days` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `delivery_points` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned NOT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `price` double NOT NULL DEFAULT 0,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`address`)),
  `location` varchar(255) NOT NULL,
  `fitting_rooms` int(11) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_points_region_id_foreign` (`region_id`),
  KEY `delivery_points_country_id_foreign` (`country_id`),
  KEY `delivery_points_city_id_foreign` (`city_id`),
  KEY `delivery_points_area_id_foreign` (`area_id`),
  CONSTRAINT `delivery_points_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_points_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_points_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `delivery_points_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_points` WRITE;
/*!40000 ALTER TABLE `delivery_points` DISABLE KEYS */;
INSERT INTO `delivery_points` VALUES (2,1,1,1,1,1,0,'{\"en\":\"Durgigudi, WHPC+J65, Nehru Rd, Mission Compound, Shivamogga, Karnataka 577201, India\"}','{\"latitude\":13.9364215406255897988785363850183784961700439453125,\"longitude\":75.5705376272761242262276937253773212432861328125}',1,'https://backstore.premfashions.com/storage/images/products/103-17452296854711.webp',0,0,0,'2025-02-06 06:57:42','2025-06-18 06:35:58');
/*!40000 ALTER TABLE `delivery_points` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_price_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `delivery_price_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_price_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `delivery_price_translations_delivery_price_id_locale_unique` (`delivery_price_id`,`locale`),
  KEY `delivery_price_translations_locale_index` (`locale`),
  CONSTRAINT `delivery_price_translations_delivery_price_id_foreign` FOREIGN KEY (`delivery_price_id`) REFERENCES `delivery_prices` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_price_translations` WRITE;
/*!40000 ALTER TABLE `delivery_price_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_price_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `delivery_prices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `price` double NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_prices_region_id_foreign` (`region_id`),
  KEY `delivery_prices_country_id_foreign` (`country_id`),
  KEY `delivery_prices_city_id_foreign` (`city_id`),
  KEY `delivery_prices_area_id_foreign` (`area_id`),
  KEY `delivery_prices_shop_id_foreign` (`shop_id`),
  CONSTRAINT `delivery_prices_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_prices` WRITE;
/*!40000 ALTER TABLE `delivery_prices` DISABLE KEYS */;
INSERT INTO `delivery_prices` VALUES (4,10,1,1,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `delivery_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `deliveryman_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `deliveryman_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned NOT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `type_of_technique` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `online` tinyint(1) NOT NULL DEFAULT 0,
  `location` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`location`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `deliveryman_settings_user_id_unique` (`user_id`),
  KEY `deliveryman_settings_region_id_foreign` (`region_id`),
  KEY `deliveryman_settings_country_id_foreign` (`country_id`),
  KEY `deliveryman_settings_city_id_foreign` (`city_id`),
  KEY `deliveryman_settings_area_id_foreign` (`area_id`),
  CONSTRAINT `deliveryman_settings_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `deliveryman_settings` WRITE;
/*!40000 ALTER TABLE `deliveryman_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `deliveryman_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `digital_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `digital_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `digital_files_product_id_foreign` (`product_id`),
  CONSTRAINT `digital_files_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `digital_files` WRITE;
/*!40000 ALTER TABLE `digital_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `digital_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `type` enum('fix','percent') NOT NULL,
  `price` double NOT NULL,
  `start` date NOT NULL DEFAULT '2024-12-30',
  `end` date DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_shop_id_foreign` (`shop_id`),
  CONSTRAINT `discounts_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `smtp_auth` tinyint(1) NOT NULL DEFAULT 1,
  `smtp_debug` tinyint(1) NOT NULL DEFAULT 0,
  `host` varchar(92) NOT NULL,
  `port` int(11) NOT NULL DEFAULT 465,
  `password` varchar(255) DEFAULT NULL,
  `from_to` varchar(255) DEFAULT NULL,
  `from_site` varchar(255) DEFAULT NULL,
  `ssl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`ssl`)),
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_settings` WRITE;
/*!40000 ALTER TABLE `email_settings` DISABLE KEYS */;
INSERT INTO `email_settings` VALUES (1,1,0,'smtp-relay.brevo.com',587,'4mYRpzaqrjLBbJOC','noreply@premfashions.com','Premfashions','{\"ssl\":{\"verify_peer\":false,\"verify_peer_name\":false,\"allow_self_signed\":true}}',1,'2024-12-30 00:58:40','2025-02-03 02:41:03'),(2,1,0,'smtp.gmail.com',465,'4pm14EC095','sunilshetty004@gmail.com','premfashion','{\"ssl\":{\"verify_peer\":false,\"verify_peer_name\":false,\"allow_self_signed\":true}}',1,'2024-12-30 00:58:40','2025-02-03 03:00:49');
/*!40000 ALTER TABLE `email_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_subscriptions_user_id_foreign` (`user_id`),
  CONSTRAINT `email_subscriptions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_subscriptions` WRITE;
/*!40000 ALTER TABLE `email_subscriptions` DISABLE KEYS */;
INSERT INTO `email_subscriptions` VALUES (22,162,1,'2025-03-25 03:41:28','2025-03-25 03:41:28'),(33,176,1,'2025-06-25 12:29:07','2025-06-25 12:29:07');
/*!40000 ALTER TABLE `email_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_setting_id` bigint(20) unsigned NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `alt_body` text NOT NULL,
  `status` tinyint(4) NOT NULL,
  `send_to` datetime NOT NULL,
  `type` varchar(50) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_templates_email_setting_id_foreign` (`email_setting_id`),
  CONSTRAINT `email_templates_email_setting_id_foreign` FOREIGN KEY (`email_setting_id`) REFERENCES `email_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_templates` WRITE;
/*!40000 ALTER TABLE `email_templates` DISABLE KEYS */;
INSERT INTO `email_templates` VALUES (1,2,'Stay Updated with Our Latest Offers & News!','<p>Get the latest updates on exclusive offers, product launches, and exciting news delivered straight to your inbox. Don’t miss out on special deals and seasonal promotions—subscribe now!</p>','Stay connected! Get exclusive deals and updates from us in your inbox.',0,'2025-02-07 12:09:36','subscribe','2025-02-06 01:09:53','2025-02-06 01:09:53');
/*!40000 ALTER TABLE `email_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `extra_group_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `extra_group_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extra_group_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `extra_group_translations_extra_group_id_locale_unique` (`extra_group_id`,`locale`),
  KEY `extra_group_translations_locale_index` (`locale`),
  CONSTRAINT `extra_group_translations_extra_group_id_foreign` FOREIGN KEY (`extra_group_id`) REFERENCES `extra_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `extra_group_translations` WRITE;
/*!40000 ALTER TABLE `extra_group_translations` DISABLE KEYS */;
INSERT INTO `extra_group_translations` VALUES (1,1,'en','Color'),(2,2,'en','Text');
/*!40000 ALTER TABLE `extra_group_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `extra_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `extra_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `extra_groups_shop_id_foreign` (`shop_id`),
  CONSTRAINT `extra_groups_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `extra_groups` WRITE;
/*!40000 ALTER TABLE `extra_groups` DISABLE KEYS */;
INSERT INTO `extra_groups` VALUES (1,'color',1,NULL),(2,'text',1,NULL);
/*!40000 ALTER TABLE `extra_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `extra_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `extra_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extra_group_id` bigint(20) unsigned NOT NULL,
  `value` varchar(191) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `extra_values_extra_group_id_foreign` (`extra_group_id`),
  CONSTRAINT `extra_values_extra_group_id_foreign` FOREIGN KEY (`extra_group_id`) REFERENCES `extra_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `extra_values` WRITE;
/*!40000 ALTER TABLE `extra_values` DISABLE KEYS */;
INSERT INTO `extra_values` VALUES (6,2,'M','M',1),(7,2,'L','L',1),(64,2,'X','X',1),(65,2,'XL','XL',1),(66,2,'XXL','XXL',1);
/*!40000 ALTER TABLE `extra_values` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `faq_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `faq_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `question` text NOT NULL,
  `answer` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `faq_translations_faq_id_locale_unique` (`faq_id`,`locale`),
  KEY `faq_translations_locale_index` (`locale`),
  CONSTRAINT `faq_translations_faq_id_foreign` FOREIGN KEY (`faq_id`) REFERENCES `faqs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `faq_translations` WRITE;
/*!40000 ALTER TABLE `faq_translations` DISABLE KEYS */;
INSERT INTO `faq_translations` VALUES (1,1,'en','How can I track my order?','You can track your order by logging into your account and clicking on the \"My Orders\" section. You\'ll find real-time updates and tracking details for your shipment.');
/*!40000 ALTER TABLE `faq_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `faqs_uuid_index` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'0e2d661f-b8ae-4323-ae5a-39ed10bcf691','web',1,'2025-02-06 05:14:03','2025-02-06 05:14:03');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `loadable_type` varchar(255) NOT NULL,
  `loadable_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `mime` varchar(255) DEFAULT NULL,
  `size` varchar(255) DEFAULT NULL,
  `preview` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_loadable_type_loadable_id_index` (`loadable_type`,`loadable_id`),
  KEY `galleries_loadable_id_index` (`loadable_id`),
  KEY `galleries_loadable_type_index` (`loadable_type`)
) ENGINE=InnoDB AUTO_INCREMENT=525 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invitations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invitations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `role` varchar(255) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invitations_shop_id_foreign` (`shop_id`),
  KEY `invitations_user_id_foreign` (`user_id`),
  CONSTRAINT `invitations_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invitations_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10003 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invitations` WRITE;
/*!40000 ALTER TABLE `invitations` DISABLE KEYS */;
/*!40000 ALTER TABLE `invitations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `landing_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `landing_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`data`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `landing_pages` WRITE;
/*!40000 ALTER TABLE `landing_pages` DISABLE KEYS */;
INSERT INTO `landing_pages` VALUES (1,'welcome','{\"title\":{\"en\":\"Welcome to the Ultimate Shopping Experience!\"},\"description\":{\"en\":\"Explore exclusive deals, premium products, and a hassle-free shopping experience. Shop now to enjoy fast delivery, secure payments, and unbeatable offers!\"},\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/languages\\/103-17388427712408.webp\",\"features\":[{\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/languages\\/103-17388428329609.webp\",\"title\":{\"en\":\"Fast & Reliable Delivery\"},\"description\":{\"en\":\"Get your orders delivered quickly and safely, right to your doorstep, with real-time tracking.\"}},{\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/languages\\/103-17388428571923.webp\",\"title\":{\"en\":\"Secure Payment Options\"},\"description\":{\"en\":\"Shop with confidence using our encrypted and trusted payment gateways. Your security is our priority.\"}},{\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/languages\\/103-17388429126264.webp\",\"title\":{\"en\":\"Exclusive Discounts & Offers\"},\"description\":{\"en\":\"Enjoy special discounts, seasonal offers, and loyalty rewards on every purchase.\"}}]}','2025-02-06 06:25:19','2025-02-06 06:25:19');
/*!40000 ALTER TABLE `landing_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `backward` tinyint(1) NOT NULL DEFAULT 0,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `languages_locale_unique` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en',0,1,1,'https://premfashion.webschedio.in/storage/images/languages/103-17385658571328.webp');
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `likes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `likes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `likable_type` varchar(255) NOT NULL,
  `likable_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `likes_likable_type_likable_id_index` (`likable_type`,`likable_id`),
  KEY `likes_likable_id_index` (`likable_id`),
  KEY `likes_likable_type_index` (`likable_type`),
  KEY `likes_user_id_foreign` (`user_id`),
  CONSTRAINT `likes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `likes` WRITE;
/*!40000 ALTER TABLE `likes` DISABLE KEYS */;
INSERT INTO `likes` VALUES (1,'App\\Models\\Product',1,103,'2025-02-03 02:43:56','2025-02-03 02:43:56'),(2,'App\\Models\\Product',6,103,'2025-02-03 02:43:56','2025-02-03 02:43:56'),(36,'App\\Models\\Product',1,162,'2025-06-14 16:12:50','2025-06-14 16:12:50');
/*!40000 ALTER TABLE `likes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `meta_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) DEFAULT NULL,
  `model_id` int(11) DEFAULT NULL,
  `model_type` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `h1` varchar(255) DEFAULT NULL,
  `seo_text` text DEFAULT NULL,
  `canonical` varchar(255) DEFAULT NULL,
  `robots` varchar(255) DEFAULT NULL,
  `change_freq` varchar(10) DEFAULT NULL,
  `priority` varchar(10) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `meta_tags` WRITE;
/*!40000 ALTER TABLE `meta_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `meta_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_04_02_193005_create_translations_table',1),(2,'2014_10_12_000000_create_users_table',1),(3,'2014_10_12_100000_create_password_resets_table',1),(4,'2019_08_19_000000_create_failed_jobs_table',1),(5,'2019_12_14_000001_create_personal_access_tokens_table',1),(6,'2022_02_22_171401_create_regions_table',1),(7,'2022_02_22_185642_create_languages_table',1),(8,'2022_02_22_185742_create_currencies_table',1),(9,'2022_02_22_192557_create_shops_table',1),(10,'2022_02_22_193407_create_categories_table',1),(11,'2022_02_22_193424_create_category_translations_table',1),(12,'2022_02_22_201116_create_permission_tables',1),(13,'2022_02_24_184818_create_galleries_table',1),(14,'2022_03_28_231708_create_sessions_table',1),(15,'2022_03_29_163004_create_meta_tags_table',1),(16,'2022_04_06_181958_create_brands_table',1),(17,'2022_04_15_020426_create_invitations_table',1),(18,'2022_05_26_183627_create_discounts_table',1),(19,'2022_05_26_191654_create_units_table',1),(20,'2022_05_26_192700_create_unit_translations_table',1),(21,'2022_05_27_164617_create_products_table',1),(22,'2022_05_30_171811_create_product_translations_table',1),(23,'2022_05_30_172012_create_product_properties_table',1),(24,'2022_05_31_200710_create_settings_table',1),(25,'2022_06_08_170500_create_extra_groups_table',1),(26,'2022_06_08_170501_create_extra_group_translations_table',1),(27,'2022_06_08_170502_create_extra_values_table',1),(28,'2022_06_17_203506_create_jobs_table',1),(29,'2022_07_16_170220_create_reviews_table',1),(30,'2022_07_16_171208_create_banners_table',1),(31,'2022_07_16_171223_create_banner_translations_table',1),(32,'2022_07_16_171350_create_backup_histories_table',1),(33,'2022_08_03_160502_create_blogs_table',1),(34,'2022_08_03_162247_create_faqs_table',1),(35,'2022_08_06_190654_create_transactions_table',1),(36,'2022_08_06_193757_create_wallets_table',1),(37,'2022_08_06_193823_create_wallet_histories_table',1),(38,'2022_08_06_213956_create_payments_table',1),(39,'2022_08_16_182348_create_term_conditions_table',1),(40,'2022_08_16_212847_create_sms_gateways_table',1),(41,'2022_08_19_190851_create_social_providers_table',1),(42,'2022_09_22_184827_create_likes_table',1),(43,'2022_09_24_072905_create_points_table',1),(44,'2022_09_24_072925_create_user_points_table',1),(45,'2022_10_22_063552_create_delivery_prices_table',1),(46,'2022_10_22_103545_create_delivery_points_table',1),(47,'2022_10_22_150040_create_delivery_point_translations_table',1),(48,'2022_11_10_085115_create_privacy_policies_table',1),(49,'2022_11_10_085352_create_privacy_policy_translations_table',1),(50,'2022_11_16_150240_create_stocks_table',1),(51,'2022_11_17_085547_create_carts_table',1),(52,'2022_11_17_090130_create_user_carts_table',1),(53,'2022_11_17_124705_create_cart_details_table',1),(54,'2022_11_25_113042_create_bonuses_table',1),(55,'2022_12_04_074133_create_stories_table',1),(56,'2022_12_04_122819_create_order_statuses_table',1),(57,'2022_12_05_064109_create_tags_table',1),(58,'2022_12_08_073731_create_email_settings_table',1),(59,'2022_12_09_072831_create_email_subscriptions_table',1),(60,'2022_12_13_053448_create_email_templates_table',1),(61,'2022_12_15_132244_create_shop_payments_table',1),(62,'2022_12_17_110940_create_shop_working_days',1),(63,'2022_12_19_061554_create_shop_closed_dates_table',1),(64,'2023_01_06_061829_create_deliveryman_settings_table',1),(65,'2023_01_12_064505_create_notifications_table',1),(66,'2023_01_12_065959_create_notification_user_table',1),(67,'2023_01_16_112952_create_payouts_table',1),(68,'2023_02_03_083653_create_banner_products_table',1),(69,'2023_02_05_072041_create_referrals_table',1),(70,'2023_02_05_072121_create_referral_translations_table',1),(71,'2023_02_10_101432_create_shop_tags_table',1),(72,'2023_02_10_101440_create_shop_tag_translations_table',1),(73,'2023_02_10_101633_create_assign_shop_tags_table',1),(74,'2023_02_22_110323_create_payment_process_table',1),(75,'2023_03_02_051806_create_payment_payloads_table',1),(76,'2023_03_02_084934_create_sms_payloads_table',1),(77,'2023_03_16_095644_create_shop_galleries_table',1),(78,'2023_03_24_110631_create_shop_deliveryman_settings',1),(79,'2023_04_03_115648_create_user_activities_table',1),(80,'2023_04_10_111219_create_careers_table',1),(81,'2023_04_10_131050_create_pages_table',1),(82,'2023_04_10_181845_create_model_logs_table',1),(83,'2023_04_27_095435_create_landing_pages_table',1),(84,'2023_05_02_064049_create_push_notifications_table',1),(85,'2023_06_16_101732_create_digital_files',1),(86,'2023_06_16_111315_create_user_digital_files',1),(87,'2023_06_19_071130_create_ads_packages_table',1),(88,'2023_06_20_065025_create_shop_socials_table',1),(89,'2023_08_10_064800_create_request_models_table',1),(90,'2023_08_18_134022_create_parcel_order_settings_table',1),(91,'2023_08_20_030743_create_parcel_options_table',1),(92,'2023_08_20_044222_create_parcel_orders_table',1),(93,'2023_08_23_143728_create_subscriptions_table',1),(94,'2023_08_24_031349_create_shop_subscriptions_table',1),(95,'2023_08_30_130611_create_shop_locations_table',1),(96,'2023_09_30_041936_create_warehouses_table',1),(97,'2023_09_30_042251_create_warehouse_translations_table',1),(98,'2023_10_11_091541_add_slug_in_products_table_categories_table_shops_table_brands_table',1),(99,'2023_10_14_101126_add_column_in_ads_package_translations_table',1),(100,'2023_10_16_085931_change_product_id_in_stories_table',1),(101,'2023_10_19_135405_add_preview_column_in_galleries_table',1),(102,'2023_10_21_090641_add_shop_id_in_banners_table',1),(103,'2023_11_06_053856_add_columns_to_users_table',1),(104,'2023_11_07_112025_add_position_page_in_ads_packages_table',1),(105,'2023_11_09_102909_add_deleted_at_in_products_table',1),(106,'2023_11_20_111156_add_desc_column_in_term_condition_translations',1),(107,'2023_11_27_094054_create_user_address_table',1),(108,'2023_11_28_031337_change_delivery_date_in_parcel_orders_table',1),(109,'2023_12_04_085626_add_delivery_type_column_in_shops_table',1),(110,'2023_12_05_052704_create_delivery_price_translations_table',1),(111,'2023_12_07_064250_remigrate_orders_table',1),(112,'2023_12_25_071344_change_column_in_term_condition_translations',1),(113,'2024_01_03_121707_create_order_status_notes_table',1),(114,'2024_01_04_091028_create_wholesale_prices_table',1),(115,'2024_01_30_102545_change_my_referral_column_in_users_table',1),(116,'2024_02_07_095342_set_null_in_orders_table',1),(117,'2024_07_18_104243_add_email_send_status_in_shops_table',1),(118,'2024_07_25_081222_add_otp_column_in_orders_table',1),(119,'2024_09_25_121420_add_img_column_in_banner_translations_table',1),(120,'2024_09_28_095958_add_discount_column_in_cart_details_table',1),(121,'2025_06_19_172802_add_label_to_extra_values_table',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\Models\\User',102),(1,'App\\Models\\User',108),(1,'App\\Models\\User',109),(1,'App\\Models\\User',110),(1,'App\\Models\\User',111),(1,'App\\Models\\User',112),(1,'App\\Models\\User',113),(1,'App\\Models\\User',114),(1,'App\\Models\\User',115),(1,'App\\Models\\User',116),(1,'App\\Models\\User',117),(1,'App\\Models\\User',118),(1,'App\\Models\\User',119),(1,'App\\Models\\User',121),(1,'App\\Models\\User',122),(1,'App\\Models\\User',124),(1,'App\\Models\\User',125),(1,'App\\Models\\User',126),(1,'App\\Models\\User',127),(1,'App\\Models\\User',128),(1,'App\\Models\\User',129),(1,'App\\Models\\User',130),(1,'App\\Models\\User',131),(1,'App\\Models\\User',132),(1,'App\\Models\\User',133),(1,'App\\Models\\User',134),(1,'App\\Models\\User',135),(1,'App\\Models\\User',136),(1,'App\\Models\\User',137),(1,'App\\Models\\User',138),(1,'App\\Models\\User',139),(1,'App\\Models\\User',140),(1,'App\\Models\\User',141),(1,'App\\Models\\User',142),(1,'App\\Models\\User',143),(1,'App\\Models\\User',144),(1,'App\\Models\\User',145),(1,'App\\Models\\User',146),(1,'App\\Models\\User',147),(1,'App\\Models\\User',148),(1,'App\\Models\\User',149),(1,'App\\Models\\User',150),(1,'App\\Models\\User',151),(1,'App\\Models\\User',152),(1,'App\\Models\\User',153),(1,'App\\Models\\User',154),(1,'App\\Models\\User',155),(1,'App\\Models\\User',156),(1,'App\\Models\\User',157),(1,'App\\Models\\User',158),(1,'App\\Models\\User',159),(1,'App\\Models\\User',160),(1,'App\\Models\\User',161),(1,'App\\Models\\User',162),(1,'App\\Models\\User',163),(1,'App\\Models\\User',164),(1,'App\\Models\\User',165),(1,'App\\Models\\User',166),(1,'App\\Models\\User',167),(1,'App\\Models\\User',168),(1,'App\\Models\\User',169),(1,'App\\Models\\User',170),(1,'App\\Models\\User',171),(1,'App\\Models\\User',172),(1,'App\\Models\\User',173),(1,'App\\Models\\User',174),(1,'App\\Models\\User',175),(1,'App\\Models\\User',176),(11,'App\\Models\\User',107),(12,'App\\Models\\User',105),(13,'App\\Models\\User',106),(13,'App\\Models\\User',120),(13,'App\\Models\\User',123),(21,'App\\Models\\User',104),(99,'App\\Models\\User',103);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'log',
  PRIMARY KEY (`id`),
  KEY `model_logs_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1418 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_logs` WRITE;
/*!40000 ALTER TABLE `model_logs` DISABLE KEYS */;
INSERT INTO `model_logs` VALUES (1,'App\\Models\\Category',1,'{\"keywords\":\"main\",\"type\":1,\"uuid\":\"623e0098-b1f8-4edd-bbdc-5288e541504b\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":1}','2024-12-30 00:58:25',NULL,'category_created'),(2,'App\\Models\\Category',2,'{\"keywords\":\"sub_main\",\"type\":2,\"uuid\":\"6accfd58-b88a-4c7c-be31-dce72ff8a807\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":2}','2024-12-30 00:58:25',NULL,'category_created'),(3,'App\\Models\\Category',3,'{\"keywords\":\"child\",\"type\":3,\"uuid\":\"433f8bfa-dc8e-4f4b-b160-b081fe752e63\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":3}','2024-12-30 00:58:25',NULL,'category_created'),(4,'App\\Models\\Category',4,'{\"keywords\":\"career\",\"type\":10,\"uuid\":\"1d00777f-725c-4366-9495-18efd6c7d6ef\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":4}','2024-12-30 00:58:25',NULL,'category_created'),(5,'App\\Models\\User',102,'{\"id\":102,\"uuid\":\"927f4e5b-dfe0-4162-8577-905485165a93\",\"firstname\":\"User\",\"lastname\":\"User\",\"email\":\"user@githubit.com\",\"phone\":\"998911902595\",\"birthday\":\"1993-12-30\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:40.927986Z\",\"password\":\"$2y$10$8Awe1ckoG.grG9B2zTkhoeq6mUylikbpJsPlApX1EwOlz2ymDjshC\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"7N102ATP\"}','2024-12-30 00:58:41',NULL,'user_created'),(6,'App\\Models\\User',103,'{\"id\":103,\"uuid\":\"22ab0041-ab87-4fcf-920a-14a05876dff6\",\"firstname\":\"Owner\",\"lastname\":\"Owner\",\"email\":\"owner@githubit.com\",\"phone\":\"998911902696\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.002267Z\",\"password\":\"$2y$10$O9ejE4dh5GcsnVnwE\\/Enyu8N8BQ8\\/PdzdKkYbnWbGFxY58v6IB\\/HW\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"OI103HPI\"}','2024-12-30 00:58:41',NULL,'user_created'),(7,'App\\Models\\User',104,'{\"id\":104,\"uuid\":\"4040fad0-5d08-4c6f-8f3d-cecef65eaff6\",\"firstname\":\"Manager\",\"lastname\":\"Manager\",\"email\":\"manager@githubit.com\",\"phone\":\"998911902616\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.065125Z\",\"password\":\"$2y$10$hpC\\/OjlT1OrZ8eQxpfW.jumb3NZ1dH2AiVXaqTsLn72W1f.XNnsJy\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"MK104LRZ\"}','2024-12-30 00:58:41',NULL,'user_created'),(8,'App\\Models\\User',105,'{\"id\":105,\"uuid\":\"5d10d939-2bdf-4f70-a6eb-148bdca3a946\",\"firstname\":\"Moderator\",\"lastname\":\"Moderator\",\"email\":\"moderator@githubit.com\",\"phone\":\"998911902116\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.127977Z\",\"password\":\"$2y$10$6prJ49UbLks5N8EWi6A37ORfFdRomyJI87xmOFXRQ6ROkR8FbrIey\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"SL105CIZ\"}','2024-12-30 00:58:41',NULL,'user_created'),(9,'App\\Models\\User',106,'{\"id\":106,\"uuid\":\"cf526659-9e7a-4311-80f1-61ad3737bd44\",\"firstname\":\"Delivery\",\"lastname\":\"Delivery\",\"email\":\"delivery@githubit.com\",\"phone\":\"998911912116\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.190907Z\",\"password\":\"$2y$10$p44L30ngdt.gQY8DEV5vgOlGOccCmiOXPIlkj7P9.yn80nTEWLwYi\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"EU106MFJ\"}','2024-12-30 00:58:41',NULL,'user_created'),(10,'App\\Models\\User',107,'{\"id\":107,\"uuid\":\"baa92065-258b-47c1-8c42-e5ef15051ba2\",\"firstname\":\"sellers\",\"lastname\":\"sellers\",\"email\":\"sellers@githubit.com\",\"phone\":\"998911902691\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.253762Z\",\"password\":\"$2y$10$pmk0UKRnNe\\/2Q6MdOMDIv.WZ1xtk.ozsiobWKa4NhomDIwj5PJ5V.\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"GG107RVQ\"}','2024-12-30 00:58:41',NULL,'user_created'),(11,'App\\Models\\Shop',501,'{\"user_id\":107,\"uuid\":\"7ccbbec5-d239-4897-a0e0-9d0c25609060\",\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"phone\":\"+1234566\",\"open\":1,\"background_img\":\"url.webp\",\"logo_img\":\"url.webp\",\"status\":\"approved\",\"status_note\":\"approved\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"type\":1,\"updated_at\":\"2024-12-30 06:28:41\",\"created_at\":\"2024-12-30 06:28:41\",\"id\":501}','2024-12-30 00:58:41',NULL,'shop_created'),(12,'App\\Models\\User',108,'{\"email\":\"sunilshetty004@gmail.com\",\"firstname\":\"sunilshetty004@gmail.com\",\"ip_address\":\"127.0.0.1\",\"uuid\":\"d92c4f37-51e2-4d9c-9b2a-ec82b830e529\",\"my_referral\":\"VIF9YBWF\",\"updated_at\":\"2024-12-30 07:10:10\",\"created_at\":\"2024-12-30 07:10:10\",\"id\":108}','2024-12-30 01:40:11',NULL,'user_created'),(13,'App\\Models\\User',108,'{\"uuid\":\"d92c4f37-51e2-4d9c-9b2a-ec82b830e529\"}','2024-12-30 01:40:11',NULL,'user_updated'),(14,'App\\Models\\User',109,'{\"email\":\"sunilshetty@gmail.com\",\"firstname\":\"sunilshetty@gmail.com\",\"ip_address\":\"122.162.169.180\",\"uuid\":\"8135ea64-2d77-48de-bf72-889775c2a05e\",\"my_referral\":\"TSKCDQQ9\",\"updated_at\":\"2025-01-03 06:40:48\",\"created_at\":\"2025-01-03 06:40:48\",\"id\":109}','2025-01-03 01:10:48',NULL,'user_created'),(15,'App\\Models\\User',109,'{\"uuid\":\"8135ea64-2d77-48de-bf72-889775c2a05e\"}','2025-01-03 01:10:48',NULL,'user_updated'),(16,'App\\Models\\User',108,'{\"ip_address\":\"127.0.0.1\"}','2025-01-03 01:11:31',NULL,'user_updated'),(17,'App\\Models\\User',108,'{\"verify_token\":\"542611\"}','2025-01-03 01:11:31',NULL,'user_updated'),(18,'App\\Models\\User',108,'{\"verify_token\":\"886491\"}','2025-01-03 01:14:49',NULL,'user_updated'),(19,'App\\Models\\User',108,'{\"verify_token\":\"886689\"}','2025-01-03 01:17:14',NULL,'user_updated'),(20,'App\\Models\\User',108,'{\"verify_token\":\"886834\"}','2025-01-03 01:38:50',NULL,'user_updated'),(21,'App\\Models\\User',108,'{\"verify_token\":\"888130\"}','2025-01-03 01:44:01',NULL,'user_updated'),(22,'App\\Models\\Shop',501,'{\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"verify\":0}','2025-01-22 01:23:14',103,'shop_updated'),(23,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"phone\":\"+1234566\",\"visibility\":1,\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\"}','2025-01-22 01:24:00',103,'shop_updated'),(24,'App\\Models\\Shop',501,'{\"slug\":null,\"lat_long\":\"{\\\"latitude\\\":-69.3453324000000037585778045468032360076904296875,\\\"longitude\\\":69.3453324000000037585778045468032360076904296875}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":\"1\"}','2025-01-22 01:24:00',103,'shop_updated'),(25,'App\\Models\\Shop',501,'{\"lat_long\":\"{\\\"latitude\\\":-69.3453324000000037585778045468032360076904296875,\\\"longitude\\\":69.3453324000000037585778045468032360076904296875}\",\"background_img\":\"url.webp\",\"logo_img\":\"url.webp\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":\"1\"}','2025-01-22 01:24:00',103,'shop_updated'),(26,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2024-12-30 06:28:41\",\"phone_verified_at\":null}','2025-01-22 01:24:17',103,'user_updated'),(27,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"phone\":\"1234566\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":1}','2025-01-22 01:25:15',103,'shop_updated'),(28,'App\\Models\\Shop',501,'{\"slug\":\"branch-title-501\",\"lat_long\":\"{\\\"latitude\\\":-69.3453324000000037585778045468032360076904296875,\\\"longitude\\\":69.3453324000000037585778045468032360076904296875}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":\"2\"}','2025-01-22 01:25:15',103,'shop_updated'),(29,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2025-01-22 06:54:17\",\"phone_verified_at\":\"2025-01-22 06:54:17\"}','2025-01-22 01:25:33',103,'user_updated'),(30,'App\\Models\\Category',5,'{\"keywords\":\"men\",\"type\":1,\"active\":\"1\",\"input\":\"123\",\"uuid\":\"873403ab-d5ed-4d2b-a954-94fb1f9c6365\",\"updated_at\":\"2025-01-22 06:59:30\",\"created_at\":\"2025-01-22 06:59:30\",\"id\":5}','2025-01-22 01:29:30',103,'category_created'),(31,'App\\Models\\Category',5,'{\"active\":\"1\",\"input\":\"123\",\"uuid\":\"873403ab-d5ed-4d2b-a954-94fb1f9c6365\"}','2025-01-22 01:29:30',103,'category_updated'),(32,'App\\Models\\Category',5,'{\"active\":\"1\",\"input\":\"123\",\"uuid\":\"873403ab-d5ed-4d2b-a954-94fb1f9c6365\"}','2025-01-22 01:29:30',103,'category_updated'),(33,'App\\Models\\Category',5,'{\"status\":\"pending\"}','2025-01-22 01:29:59',103,'category_updated'),(34,'App\\Models\\Product',1,'{\"uuid\":\"6bc6a184-5ff9-4c0f-84da-bba42a55697a\"}','2025-01-22 01:32:01',103,'product_updated'),(35,'App\\Models\\Product',1,'{\"uuid\":\"6bc6a184-5ff9-4c0f-84da-bba42a55697a\"}','2025-01-22 01:32:01',103,'product_updated'),(36,'App\\Models\\Product',1,'{\"min_price\":0,\"max_price\":0}','2025-01-22 01:32:31',103,'product_updated'),(37,'App\\Models\\Product',1,'{\"status\":\"pending\",\"status_note\":null}','2025-01-22 01:32:57',103,'product_updated'),(38,'App\\Models\\User',103,'{\"birthday\":\"1990-12-31\",\"firebase_token\":null}','2025-01-22 01:53:20',103,'user_updated'),(39,'App\\Models\\Product',2,'{\"uuid\":\"411ab7e8-8a2e-481f-a495-7d1ea3259599\"}','2025-01-22 02:06:42',103,'product_updated'),(40,'App\\Models\\Product',2,'{\"uuid\":\"411ab7e8-8a2e-481f-a495-7d1ea3259599\"}','2025-01-22 02:06:42',103,'product_updated'),(41,'App\\Models\\Product',2,'{\"min_price\":0,\"max_price\":0}','2025-01-22 02:07:18',103,'product_updated'),(42,'App\\Models\\Product',2,'{\"status\":\"pending\",\"status_note\":null}','2025-01-22 04:17:14',103,'product_updated'),(43,'App\\Models\\Category',6,'{\"keywords\":\"women\",\"type\":1,\"active\":\"1\",\"input\":\"12\",\"uuid\":\"a1990c1a-c78c-43e1-b3a6-434e9ce98ed3\",\"updated_at\":\"2025-01-22 10:15:38\",\"created_at\":\"2025-01-22 10:15:38\",\"id\":6}','2025-01-22 04:45:38',103,'category_created'),(44,'App\\Models\\Category',6,'{\"active\":\"1\",\"input\":\"12\",\"uuid\":\"a1990c1a-c78c-43e1-b3a6-434e9ce98ed3\"}','2025-01-22 04:45:38',103,'category_updated'),(45,'App\\Models\\Category',6,'{\"active\":\"1\",\"input\":\"12\",\"uuid\":\"a1990c1a-c78c-43e1-b3a6-434e9ce98ed3\"}','2025-01-22 04:45:38',103,'category_updated'),(46,'App\\Models\\Category',6,'{\"status\":\"pending\"}','2025-01-22 04:47:46',103,'category_updated'),(47,'App\\Models\\Category',7,'{\"keywords\":\"lehanga\",\"parent_id\":\"6\",\"type\":2,\"active\":\"1\",\"uuid\":\"d828962b-4e5e-4f95-9cd7-c46575729cdb\",\"updated_at\":\"2025-01-22 10:25:16\",\"created_at\":\"2025-01-22 10:25:16\",\"id\":7}','2025-01-22 04:55:16',103,'category_created'),(48,'App\\Models\\Category',7,'{\"active\":\"1\",\"uuid\":\"d828962b-4e5e-4f95-9cd7-c46575729cdb\"}','2025-01-22 04:55:16',103,'category_updated'),(49,'App\\Models\\Category',7,'{\"active\":\"1\",\"uuid\":\"d828962b-4e5e-4f95-9cd7-c46575729cdb\"}','2025-01-22 04:55:16',103,'category_updated'),(50,'App\\Models\\Category',7,'{\"status\":\"pending\"}','2025-01-22 04:56:32',103,'category_updated'),(51,'App\\Models\\Category',8,'{\"keywords\":\"saree\",\"parent_id\":\"6\",\"type\":2,\"active\":\"1\",\"uuid\":\"b39f2625-caf1-4a5f-927d-aa41315ed4b4\",\"updated_at\":\"2025-01-22 10:28:36\",\"created_at\":\"2025-01-22 10:28:36\",\"id\":8}','2025-01-22 04:58:36',103,'category_created'),(52,'App\\Models\\Category',8,'{\"active\":\"1\",\"uuid\":\"b39f2625-caf1-4a5f-927d-aa41315ed4b4\"}','2025-01-22 04:58:36',103,'category_updated'),(53,'App\\Models\\Category',8,'{\"active\":\"1\",\"uuid\":\"b39f2625-caf1-4a5f-927d-aa41315ed4b4\"}','2025-01-22 04:58:36',103,'category_updated'),(54,'App\\Models\\Category',9,'{\"keywords\":\"tops\",\"parent_id\":\"6\",\"type\":2,\"active\":\"1\",\"uuid\":\"44692715-1e96-445e-9068-7a2f76ac6855\",\"updated_at\":\"2025-01-22 10:29:12\",\"created_at\":\"2025-01-22 10:29:12\",\"id\":9}','2025-01-22 04:59:12',103,'category_created'),(55,'App\\Models\\Category',9,'{\"active\":\"1\",\"uuid\":\"44692715-1e96-445e-9068-7a2f76ac6855\"}','2025-01-22 04:59:12',103,'category_updated'),(56,'App\\Models\\Category',9,'{\"active\":\"1\",\"uuid\":\"44692715-1e96-445e-9068-7a2f76ac6855\"}','2025-01-22 04:59:12',103,'category_updated'),(57,'App\\Models\\Category',8,'{\"status\":\"pending\"}','2025-01-22 05:00:24',103,'category_updated'),(58,'App\\Models\\Category',9,'{\"status\":\"pending\"}','2025-01-22 05:00:32',103,'category_updated'),(59,'App\\Models\\Category',10,'{\"keywords\":\"jeans\",\"parent_id\":\"5\",\"type\":2,\"active\":\"1\",\"uuid\":\"f3a3e311-2e4a-4e3f-9f73-d279ee82f382\",\"updated_at\":\"2025-01-22 10:34:13\",\"created_at\":\"2025-01-22 10:34:13\",\"id\":10}','2025-01-22 05:04:13',103,'category_created'),(60,'App\\Models\\Category',10,'{\"active\":\"1\",\"uuid\":\"f3a3e311-2e4a-4e3f-9f73-d279ee82f382\"}','2025-01-22 05:04:13',103,'category_updated'),(61,'App\\Models\\Category',10,'{\"active\":\"1\",\"uuid\":\"f3a3e311-2e4a-4e3f-9f73-d279ee82f382\"}','2025-01-22 05:04:13',103,'category_updated'),(62,'App\\Models\\Category',11,'{\"keywords\":\"shirts\",\"parent_id\":\"5\",\"type\":2,\"active\":\"1\",\"uuid\":\"1d1c178d-d3b7-4e1e-9308-7761ddc99daf\",\"updated_at\":\"2025-01-22 10:35:20\",\"created_at\":\"2025-01-22 10:35:20\",\"id\":11}','2025-01-22 05:05:20',103,'category_created'),(63,'App\\Models\\Category',11,'{\"active\":\"1\",\"uuid\":\"1d1c178d-d3b7-4e1e-9308-7761ddc99daf\"}','2025-01-22 05:05:20',103,'category_updated'),(64,'App\\Models\\Category',11,'{\"active\":\"1\",\"uuid\":\"1d1c178d-d3b7-4e1e-9308-7761ddc99daf\"}','2025-01-22 05:05:20',103,'category_updated'),(65,'App\\Models\\Category',12,'{\"keywords\":\"kurtas\",\"parent_id\":\"5\",\"type\":2,\"active\":\"1\",\"uuid\":\"566c71ba-c0d9-4beb-9c68-c813dc91ed56\",\"updated_at\":\"2025-01-22 10:35:46\",\"created_at\":\"2025-01-22 10:35:46\",\"id\":12}','2025-01-22 05:05:46',103,'category_created'),(66,'App\\Models\\Category',12,'{\"active\":\"1\",\"uuid\":\"566c71ba-c0d9-4beb-9c68-c813dc91ed56\"}','2025-01-22 05:05:46',103,'category_updated'),(67,'App\\Models\\Category',12,'{\"active\":\"1\",\"uuid\":\"566c71ba-c0d9-4beb-9c68-c813dc91ed56\"}','2025-01-22 05:05:46',103,'category_updated'),(68,'App\\Models\\Category',12,'{\"status\":\"pending\"}','2025-01-22 05:06:21',103,'category_updated'),(69,'App\\Models\\Category',11,'{\"status\":\"pending\"}','2025-01-22 05:06:28',103,'category_updated'),(70,'App\\Models\\Category',10,'{\"status\":\"pending\"}','2025-01-22 05:06:56',103,'category_updated'),(71,'App\\Models\\Product',2,'{\"category_id\":5,\"tax\":1,\"status_note\":\"\"}','2025-01-22 05:08:08',103,'product_updated'),(72,'App\\Models\\Product',1,'{\"category_id\":5,\"tax\":1,\"age_limit\":12,\"status_note\":\"\"}','2025-01-22 05:09:14',103,'product_updated'),(73,'App\\Models\\Product',3,'{\"uuid\":\"ea1666cf-a59f-4c4d-bfbd-252b88dad8da\"}','2025-01-22 05:10:31',103,'product_updated'),(74,'App\\Models\\Product',3,'{\"uuid\":\"ea1666cf-a59f-4c4d-bfbd-252b88dad8da\"}','2025-01-22 05:10:31',103,'product_updated'),(75,'App\\Models\\Product',4,'{\"uuid\":\"f3e8d33d-7133-4dc8-8850-89b96b454ce1\"}','2025-01-22 05:10:41',103,'product_updated'),(76,'App\\Models\\Product',4,'{\"uuid\":\"f3e8d33d-7133-4dc8-8850-89b96b454ce1\"}','2025-01-22 05:10:41',103,'product_updated'),(77,'App\\Models\\Product',4,'[]','2025-01-22 05:11:12',103,'product_deleted'),(78,'App\\Models\\Product',3,'{\"min_price\":0,\"max_price\":0}','2025-01-22 05:11:46',103,'product_updated'),(79,'App\\Models\\Product',5,'{\"uuid\":\"340aedc7-4729-4203-a9d0-5bd5728a3910\"}','2025-01-22 05:16:44',103,'product_updated'),(80,'App\\Models\\Product',5,'{\"uuid\":\"340aedc7-4729-4203-a9d0-5bd5728a3910\"}','2025-01-22 05:16:45',103,'product_updated'),(81,'App\\Models\\Product',3,'{\"status\":\"pending\",\"status_note\":null}','2025-01-22 05:17:00',103,'product_updated'),(82,'App\\Models\\Product',5,'{\"min_price\":0,\"max_price\":0}','2025-01-22 05:17:34',103,'product_updated'),(83,'App\\Models\\Product',5,'{\"status\":\"pending\",\"status_note\":null}','2025-01-22 05:18:04',103,'product_updated'),(84,'App\\Models\\User',110,'{\"email\":\"akshayka@webschedio.in\",\"firstname\":\"akshayka@webschedio.in\",\"ip_address\":\"122.167.255.240\",\"uuid\":\"fca0b96e-aab7-4b47-83a5-707d33a95151\",\"my_referral\":\"XG4RMY4O\",\"updated_at\":\"2025-01-22 11:40:23\",\"created_at\":\"2025-01-22 11:40:23\",\"id\":110}','2025-01-22 06:10:23',NULL,'user_created'),(85,'App\\Models\\User',110,'{\"uuid\":\"fca0b96e-aab7-4b47-83a5-707d33a95151\"}','2025-01-22 06:10:23',NULL,'user_updated'),(86,'App\\Models\\User',102,'{\"birthday\":\"1993-12-30\",\"firebase_token\":null}','2025-01-22 07:12:39',102,'user_updated'),(87,'App\\Models\\Product',6,'{\"uuid\":\"6fd8d0b2-0dc0-4f3c-be2a-0662e635e1fa\"}','2025-01-22 07:16:02',103,'product_updated'),(88,'App\\Models\\Product',6,'{\"uuid\":\"6fd8d0b2-0dc0-4f3c-be2a-0662e635e1fa\"}','2025-01-22 07:16:02',103,'product_updated'),(89,'App\\Models\\Product',6,'{\"min_price\":0,\"max_price\":0}','2025-01-22 07:17:12',103,'product_updated'),(90,'App\\Models\\Product',6,'{\"status\":\"pending\",\"status_note\":null}','2025-01-22 07:17:47',103,'product_updated'),(91,'App\\Models\\Product',7,'{\"uuid\":\"007c1f64-d45c-41d0-8dbe-a45c85382a2d\"}','2025-01-22 07:34:32',103,'product_updated'),(92,'App\\Models\\Product',7,'{\"uuid\":\"007c1f64-d45c-41d0-8dbe-a45c85382a2d\"}','2025-01-22 07:34:32',103,'product_updated'),(93,'App\\Models\\Product',8,'{\"uuid\":\"1ce986d6-1969-4c7a-a3d5-65e73f719b50\"}','2025-01-22 07:35:46',103,'product_updated'),(94,'App\\Models\\Product',8,'{\"uuid\":\"1ce986d6-1969-4c7a-a3d5-65e73f719b50\"}','2025-01-22 07:35:46',103,'product_updated'),(95,'App\\Models\\Product',9,'{\"uuid\":\"c392c424-a375-46f8-9585-622a29cd8b6e\"}','2025-01-22 07:37:24',103,'product_updated'),(96,'App\\Models\\Product',9,'{\"uuid\":\"c392c424-a375-46f8-9585-622a29cd8b6e\"}','2025-01-22 07:37:24',103,'product_updated'),(97,'App\\Models\\Product',10,'{\"uuid\":\"7baec747-9d63-49d5-9d49-72f4cb9bc02f\"}','2025-01-23 04:35:23',103,'product_updated'),(98,'App\\Models\\Product',10,'{\"uuid\":\"7baec747-9d63-49d5-9d49-72f4cb9bc02f\"}','2025-01-23 04:35:23',103,'product_updated'),(99,'App\\Models\\Product',11,'{\"uuid\":\"e00ecd7d-afb2-4fc1-ab33-0aca77226669\"}','2025-01-23 04:37:48',103,'product_updated'),(100,'App\\Models\\Product',11,'{\"uuid\":\"e00ecd7d-afb2-4fc1-ab33-0aca77226669\"}','2025-01-23 04:37:48',103,'product_updated'),(101,'App\\Models\\Product',12,'{\"uuid\":\"43868473-02be-4043-9e0c-861e4b013fd5\"}','2025-01-28 02:05:41',103,'product_updated'),(102,'App\\Models\\Product',12,'{\"uuid\":\"43868473-02be-4043-9e0c-861e4b013fd5\"}','2025-01-28 02:05:41',103,'product_updated'),(103,'App\\Models\\Product',13,'{\"uuid\":\"7397d217-b938-4566-914e-3dd4d72e2d6c\"}','2025-01-28 02:29:00',103,'product_updated'),(104,'App\\Models\\Product',13,'{\"uuid\":\"7397d217-b938-4566-914e-3dd4d72e2d6c\"}','2025-01-28 02:29:00',103,'product_updated'),(105,'App\\Models\\Product',14,'{\"uuid\":\"640dc10c-59db-46af-9fd1-79dd9b1835db\"}','2025-01-28 03:46:44',103,'product_updated'),(106,'App\\Models\\Product',14,'{\"uuid\":\"640dc10c-59db-46af-9fd1-79dd9b1835db\"}','2025-01-28 03:46:44',103,'product_updated'),(107,'App\\Models\\Product',15,'{\"uuid\":\"4cdbb49a-9fbe-40df-b032-572447d23e78\"}','2025-01-28 03:50:22',103,'product_updated'),(108,'App\\Models\\Product',15,'{\"uuid\":\"4cdbb49a-9fbe-40df-b032-572447d23e78\"}','2025-01-28 03:50:22',103,'product_updated'),(109,'App\\Models\\Product',16,'{\"uuid\":\"06cb27ca-3974-462d-ae63-4001f945b64e\"}','2025-01-28 03:53:34',103,'product_updated'),(110,'App\\Models\\Product',16,'{\"uuid\":\"06cb27ca-3974-462d-ae63-4001f945b64e\"}','2025-01-28 03:53:34',103,'product_updated'),(111,'App\\Models\\Product',17,'{\"uuid\":\"73acf4c8-9241-45e9-a965-e0f155714c4b\"}','2025-01-28 04:34:59',103,'product_updated'),(112,'App\\Models\\Product',17,'{\"uuid\":\"73acf4c8-9241-45e9-a965-e0f155714c4b\"}','2025-01-28 04:34:59',103,'product_updated'),(113,'App\\Models\\Product',18,'{\"uuid\":\"be8e6162-822e-4aa5-9741-c14f79680759\"}','2025-01-28 04:39:26',103,'product_updated'),(114,'App\\Models\\Product',18,'{\"uuid\":\"be8e6162-822e-4aa5-9741-c14f79680759\"}','2025-01-28 04:39:26',103,'product_updated'),(115,'App\\Models\\Product',12,'{\"min_price\":0,\"max_price\":0}','2025-01-28 05:06:14',103,'product_updated'),(116,'App\\Models\\Product',14,'{\"tax\":10,\"min_qty\":1,\"max_qty\":1}','2025-01-28 05:08:02',103,'product_updated'),(117,'App\\Models\\Product',14,'{\"min_price\":0,\"max_price\":0}','2025-01-28 05:08:16',103,'product_updated'),(118,'App\\Models\\Product',14,'{\"status\":\"pending\",\"status_note\":null}','2025-01-28 05:08:43',103,'product_updated'),(119,'App\\Models\\Product',19,'{\"uuid\":\"5251f8c2-b149-4085-8a90-f8da692984ea\"}','2025-01-28 05:33:16',103,'product_updated'),(120,'App\\Models\\Product',19,'{\"uuid\":\"5251f8c2-b149-4085-8a90-f8da692984ea\"}','2025-01-28 05:33:16',103,'product_updated'),(121,'App\\Models\\Product',20,'{\"uuid\":\"23002fd9-7fdc-4da9-acf7-fef11045f381\"}','2025-01-28 05:48:34',103,'product_updated'),(122,'App\\Models\\Product',20,'{\"uuid\":\"23002fd9-7fdc-4da9-acf7-fef11045f381\"}','2025-01-28 05:48:34',103,'product_updated'),(123,'App\\Models\\Product',21,'{\"uuid\":\"9d1e7b05-fb98-4f83-84f8-a00220628bb1\"}','2025-01-28 07:08:57',103,'product_updated'),(124,'App\\Models\\Product',21,'{\"uuid\":\"9d1e7b05-fb98-4f83-84f8-a00220628bb1\"}','2025-01-28 07:08:57',103,'product_updated'),(125,'App\\Models\\Product',22,'{\"uuid\":\"caf3e6df-0754-4279-aa83-b33529b4ce12\"}','2025-01-28 07:12:23',103,'product_updated'),(126,'App\\Models\\Product',22,'{\"uuid\":\"caf3e6df-0754-4279-aa83-b33529b4ce12\"}','2025-01-28 07:12:23',103,'product_updated'),(127,'App\\Models\\Product',23,'{\"uuid\":\"65096bc5-58ec-4c9c-8c63-9e2a4ca47813\"}','2025-01-28 07:13:52',103,'product_updated'),(128,'App\\Models\\Product',23,'{\"uuid\":\"65096bc5-58ec-4c9c-8c63-9e2a4ca47813\"}','2025-01-28 07:13:52',103,'product_updated'),(129,'App\\Models\\Product',24,'{\"uuid\":\"f5f445e8-2819-4298-9e8b-836ba9ee5e97\"}','2025-01-28 07:16:42',103,'product_updated'),(130,'App\\Models\\Product',24,'{\"uuid\":\"f5f445e8-2819-4298-9e8b-836ba9ee5e97\"}','2025-01-28 07:16:42',103,'product_updated'),(131,'App\\Models\\Product',25,'{\"uuid\":\"b30d555b-76a7-459b-9e99-1efcf540672e\"}','2025-01-28 07:23:52',103,'product_updated'),(132,'App\\Models\\Product',25,'{\"uuid\":\"b30d555b-76a7-459b-9e99-1efcf540672e\"}','2025-01-28 07:23:53',103,'product_updated'),(133,'App\\Models\\Product',26,'{\"uuid\":\"c38a761a-4b36-4374-b14e-6a426a2cde20\"}','2025-01-28 07:24:14',103,'product_updated'),(134,'App\\Models\\Product',26,'{\"uuid\":\"c38a761a-4b36-4374-b14e-6a426a2cde20\"}','2025-01-28 07:24:14',103,'product_updated'),(135,'App\\Models\\Product',27,'{\"uuid\":\"609ac0d8-7687-4fb8-8dfb-aef673deaf7e\"}','2025-01-28 07:26:36',103,'product_updated'),(136,'App\\Models\\Product',27,'{\"uuid\":\"609ac0d8-7687-4fb8-8dfb-aef673deaf7e\"}','2025-01-28 07:26:36',103,'product_updated'),(137,'App\\Models\\Product',28,'{\"uuid\":\"e694e181-3025-48d0-b031-c0d9ce9f5ef5\"}','2025-02-03 02:02:19',103,'product_updated'),(138,'App\\Models\\Product',28,'{\"uuid\":\"e694e181-3025-48d0-b031-c0d9ce9f5ef5\"}','2025-02-03 02:02:19',103,'product_updated'),(139,'App\\Models\\Product',28,'{\"active\":0}','2025-02-03 02:03:03',103,'product_updated'),(140,'App\\Models\\Product',28,'{\"min_price\":0,\"max_price\":0}','2025-02-03 02:04:24',103,'product_updated'),(141,'App\\Models\\Product',28,'{\"status\":\"pending\",\"status_note\":null}','2025-02-03 02:05:52',103,'product_updated'),(142,'App\\Models\\Product',28,'{\"tax\":5,\"active\":1,\"status_note\":\"\"}','2025-02-03 02:06:25',103,'product_updated'),(143,'App\\Models\\Product',28,'{\"active\":0}','2025-02-03 02:07:48',103,'product_updated'),(144,'App\\Models\\User',111,'{\"email\":\"voj8899@gmail.com\",\"firstname\":\"voj8899@gmail.com\",\"ip_address\":\"122.162.170.150\",\"uuid\":\"218ab18b-f725-46c1-adc4-7f5a52fe914b\",\"my_referral\":\"7CYUULYU\",\"updated_at\":\"2025-02-03 07:38:39\",\"created_at\":\"2025-02-03 07:38:39\",\"id\":111}','2025-02-03 02:08:39',NULL,'user_created'),(145,'App\\Models\\User',111,'{\"uuid\":\"218ab18b-f725-46c1-adc4-7f5a52fe914b\"}','2025-02-03 02:08:39',NULL,'user_updated'),(146,'App\\Models\\Product',28,'{\"min_price\":250,\"max_price\":250}','2025-02-03 02:28:22',103,'product_updated'),(147,'App\\Models\\Product',28,'{\"max_price\":280}','2025-02-03 02:28:44',103,'product_updated'),(148,'App\\Models\\User',108,'{\"ip_address\":\"122.162.169.180\"}','2025-02-03 02:41:53',NULL,'user_updated'),(149,'App\\Models\\User',108,'{\"verify_token\":\"888441\"}','2025-02-03 02:41:53',NULL,'user_updated'),(150,'App\\Models\\User',112,'{\"email\":\"sunilshetty004@gmail.com\",\"firstname\":\"sunilshetty004@gmail.com\",\"ip_address\":\"122.162.170.150\",\"uuid\":\"a7cb7297-b797-4b5c-b404-e02a2282b21d\",\"my_referral\":\"D4EBHHYN\",\"updated_at\":\"2025-02-03 08:29:04\",\"created_at\":\"2025-02-03 08:29:04\",\"id\":112}','2025-02-03 02:59:04',NULL,'user_created'),(151,'App\\Models\\User',112,'{\"uuid\":\"a7cb7297-b797-4b5c-b404-e02a2282b21d\"}','2025-02-03 02:59:04',NULL,'user_updated'),(152,'App\\Models\\User',113,'{\"email\":\"anuppligade@gmail.com\",\"firstname\":\"anuppligade@gmail.com\",\"ip_address\":\"122.162.170.150\",\"uuid\":\"4041613b-9c46-49aa-a6be-369b3191967c\",\"my_referral\":\"T0PGSTDD\",\"updated_at\":\"2025-02-03 09:16:40\",\"created_at\":\"2025-02-03 09:16:40\",\"id\":113}','2025-02-03 03:46:40',NULL,'user_created'),(153,'App\\Models\\User',113,'{\"uuid\":\"4041613b-9c46-49aa-a6be-369b3191967c\"}','2025-02-03 03:46:40',NULL,'user_updated'),(154,'App\\Models\\User',103,'{\"birthday\":\"1990-12-31\",\"firebase_token\":\"[]\"}','2025-02-03 05:33:53',103,'user_updated'),(155,'App\\Models\\Product',29,'{\"uuid\":\"b0fe122a-9e94-405f-a5ed-892767dc2ff2\"}','2025-02-03 06:00:15',103,'product_updated'),(156,'App\\Models\\Product',29,'{\"uuid\":\"b0fe122a-9e94-405f-a5ed-892767dc2ff2\"}','2025-02-03 06:00:15',103,'product_updated'),(157,'App\\Models\\Product',30,'{\"uuid\":\"a27b7057-31ce-44e2-aee3-ea835002547e\"}','2025-02-03 06:11:25',103,'product_updated'),(158,'App\\Models\\Product',30,'{\"uuid\":\"a27b7057-31ce-44e2-aee3-ea835002547e\"}','2025-02-03 06:11:25',103,'product_updated'),(159,'App\\Models\\User',113,'{\"ip_address\":\"122.162.170.150\"}','2025-02-03 12:00:12',NULL,'user_updated'),(160,'App\\Models\\User',113,'{\"verify_token\":\"574200\"}','2025-02-03 12:00:12',NULL,'user_updated'),(161,'App\\Models\\User',114,'{\"email\":\"prajwalsanu007@gmail.com\",\"firstname\":\"prajwalsanu007@gmail.com\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"bccdc05c-91c6-44d9-83b9-c8120fa47c53\",\"my_referral\":\"MWPOQA3J\",\"updated_at\":\"2025-02-04 09:48:40\",\"created_at\":\"2025-02-04 09:48:40\",\"id\":114}','2025-02-04 04:18:40',NULL,'user_created'),(162,'App\\Models\\User',114,'{\"uuid\":\"bccdc05c-91c6-44d9-83b9-c8120fa47c53\"}','2025-02-04 04:18:40',NULL,'user_updated'),(163,'App\\Models\\User',112,'{\"ip_address\":\"122.162.170.150\"}','2025-02-04 04:23:37',NULL,'user_updated'),(164,'App\\Models\\User',112,'{\"verify_token\":\"571344\"}','2025-02-04 04:23:37',NULL,'user_updated'),(165,'App\\Models\\Product',31,'{\"uuid\":\"f6ff1929-866e-4b1f-8f53-014f6d331d53\"}','2025-02-04 05:21:35',103,'product_updated'),(166,'App\\Models\\Product',31,'{\"uuid\":\"f6ff1929-866e-4b1f-8f53-014f6d331d53\"}','2025-02-04 05:21:35',103,'product_updated'),(167,'App\\Models\\User',112,'{\"verify_token\":\"662817\"}','2025-02-04 05:38:27',NULL,'user_updated'),(168,'App\\Models\\Product',32,'{\"uuid\":\"5bc79cb9-9a8a-4b0b-8d53-5b38a9cd4259\"}','2025-02-04 05:46:59',103,'product_updated'),(169,'App\\Models\\Product',32,'{\"uuid\":\"5bc79cb9-9a8a-4b0b-8d53-5b38a9cd4259\"}','2025-02-04 05:46:59',103,'product_updated'),(170,'App\\Models\\Product',33,'{\"uuid\":\"b77fb102-0bd6-4d92-b936-c428412477c0\"}','2025-02-04 05:47:38',103,'product_updated'),(171,'App\\Models\\Product',33,'{\"uuid\":\"b77fb102-0bd6-4d92-b936-c428412477c0\"}','2025-02-04 05:47:38',103,'product_updated'),(172,'App\\Models\\User',112,'{\"verify_token\":\"667307\"}','2025-02-04 05:47:39',NULL,'user_updated'),(173,'App\\Models\\User',112,'{\"verify_token\":\"667859\"}','2025-02-04 05:51:31',NULL,'user_updated'),(174,'App\\Models\\User',112,'{\"verify_token\":\"668091\"}','2025-02-04 05:54:30',NULL,'user_updated'),(175,'App\\Models\\User',112,'{\"verify_token\":\"668270\"}','2025-02-04 05:57:16',NULL,'user_updated'),(176,'App\\Models\\User',112,'{\"verify_token\":\"668436\"}','2025-02-04 06:01:00',NULL,'user_updated'),(177,'App\\Models\\User',112,'{\"verify_token\":\"668660\"}','2025-02-04 06:01:39',NULL,'user_updated'),(178,'App\\Models\\User',112,'{\"verify_token\":\"668699\"}','2025-02-04 06:02:35',NULL,'user_updated'),(179,'App\\Models\\User',112,'{\"verify_token\":\"668755\"}','2025-02-04 06:03:37',NULL,'user_updated'),(180,'App\\Models\\User',112,'{\"verify_token\":\"668817\"}','2025-02-04 06:15:45',NULL,'user_updated'),(181,'App\\Models\\User',114,'{\"verify_token\":\"662520\"}','2025-02-04 06:20:30',NULL,'user_updated'),(182,'App\\Models\\User',114,'{\"verify_token\":\"669830\"}','2025-02-04 06:21:16',NULL,'user_updated'),(183,'App\\Models\\User',114,'{\"verify_token\":\"669876\"}','2025-02-04 06:29:55',NULL,'user_updated'),(184,'App\\Models\\User',114,'{\"verify_token\":\"670395\"}','2025-02-04 06:30:21',NULL,'user_updated'),(185,'App\\Models\\User',114,'{\"verify_token\":\"670421\"}','2025-02-04 06:31:48',NULL,'user_updated'),(186,'App\\Models\\User',112,'{\"verify_token\":\"669545\"}','2025-02-04 06:38:41',NULL,'user_updated'),(187,'App\\Models\\User',112,'{\"verify_token\":\"670921\"}','2025-02-04 06:44:44',NULL,'user_updated'),(188,'App\\Models\\User',112,'{\"verify_token\":\"671284\"}','2025-02-04 06:48:58',NULL,'user_updated'),(189,'App\\Models\\User',112,'{\"verify_token\":\"671538\"}','2025-02-04 06:54:36',NULL,'user_updated'),(190,'App\\Models\\User',112,'{\"verify_token\":\"671875\"}','2025-02-04 06:57:55',NULL,'user_updated'),(191,'App\\Models\\User',112,'{\"verify_token\":\"672075\"}','2025-02-04 07:00:08',NULL,'user_updated'),(192,'App\\Models\\User',112,'{\"verify_token\":\"672208\"}','2025-02-04 07:02:01',NULL,'user_updated'),(193,'App\\Models\\User',112,'{\"verify_token\":\"672321\"}','2025-02-04 07:04:15',NULL,'user_updated'),(194,'App\\Models\\User',112,'{\"verify_token\":\"672455\"}','2025-02-04 07:05:42',NULL,'user_updated'),(195,'App\\Models\\User',112,'{\"verify_token\":\"672542\"}','2025-02-04 07:09:00',NULL,'user_updated'),(196,'App\\Models\\User',112,'{\"verify_token\":\"672740\"}','2025-02-04 07:16:52',NULL,'user_updated'),(197,'App\\Models\\User',112,'{\"verify_token\":\"673212\"}','2025-02-04 07:18:37',NULL,'user_updated'),(198,'App\\Models\\User',112,'{\"verify_token\":\"673317\"}','2025-02-04 07:20:25',NULL,'user_updated'),(199,'App\\Models\\User',112,'{\"verify_token\":\"673425\"}','2025-02-04 07:30:00',NULL,'user_updated'),(200,'App\\Models\\User',112,'{\"verify_token\":\"674000\"}','2025-02-04 07:34:11',NULL,'user_updated'),(201,'App\\Models\\User',112,'{\"verify_token\":\"674251\"}','2025-02-04 07:37:02',NULL,'user_updated'),(202,'App\\Models\\User',112,'{\"verify_token\":\"674422\"}','2025-02-04 07:40:24',NULL,'user_updated'),(203,'App\\Models\\User',112,'{\"verify_token\":\"674624\"}','2025-02-04 07:43:11',NULL,'user_updated'),(204,'App\\Models\\User',112,'{\"email_verified_at\":null}','2025-02-04 07:43:26',NULL,'user_updated'),(205,'App\\Models\\User',112,'{\"firstname\":\"sunilshetty004@gmail.com\",\"lastname\":null,\"password\":null}','2025-02-04 07:44:01',NULL,'user_updated'),(206,'App\\Models\\User',114,'{\"verify_token\":\"670508\"}','2025-02-04 07:46:11',NULL,'user_updated'),(207,'App\\Models\\User',114,'{\"email_verified_at\":null}','2025-02-04 07:46:48',NULL,'user_updated'),(208,'App\\Models\\User',114,'{\"firstname\":\"prajwalsanu007@gmail.com\",\"lastname\":null,\"password\":null}','2025-02-04 07:47:29',NULL,'user_updated'),(209,'App\\Models\\User',115,'{\"email\":\"akshaykgowda0011@gmail.com\",\"firstname\":\"akshaykgowda0011@gmail.com\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"e95c5543-406b-460b-9834-b62bd253b01f\",\"my_referral\":\"MJ5YOJG7\",\"updated_at\":\"2025-02-04 13:20:14\",\"created_at\":\"2025-02-04 13:20:14\",\"id\":115}','2025-02-04 07:50:14',NULL,'user_created'),(210,'App\\Models\\User',115,'{\"uuid\":\"e95c5543-406b-460b-9834-b62bd253b01f\"}','2025-02-04 07:50:14',NULL,'user_updated'),(211,'App\\Models\\User',115,'{\"email_verified_at\":null}','2025-02-04 07:51:08',NULL,'user_updated'),(212,'App\\Models\\User',115,'{\"firstname\":\"akshaykgowda0011@gmail.com\",\"lastname\":null,\"password\":null}','2025-02-04 07:51:44',NULL,'user_updated'),(213,'App\\Models\\User',116,'{\"email\":\"sunilkumarshetty004@gmail.com\",\"firstname\":\"sunilkumarshetty004@gmail.com\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"7e51fd24-2452-4451-a397-f9ff6cfb607b\",\"my_referral\":\"XGL6LLYU\",\"updated_at\":\"2025-02-05 04:57:11\",\"created_at\":\"2025-02-05 04:57:11\",\"id\":116}','2025-02-04 23:27:11',NULL,'user_created'),(214,'App\\Models\\User',116,'{\"uuid\":\"7e51fd24-2452-4451-a397-f9ff6cfb607b\"}','2025-02-04 23:27:11',NULL,'user_updated'),(215,'App\\Models\\User',116,'{\"email_verified_at\":null}','2025-02-04 23:30:18',NULL,'user_updated'),(216,'App\\Models\\User',116,'{\"firstname\":\"sunilkumarshetty004@gmail.com\",\"lastname\":null,\"phone\":null,\"password\":null}','2025-02-04 23:31:04',116,'user_updated'),(217,'App\\Models\\User',116,'{\"firebase_token\":null}','2025-02-04 23:31:10',116,'user_updated'),(218,'App\\Models\\User',117,'{\"email\":\"sunilshetty@webschedio.in\",\"firstname\":\"sunilshetty@webschedio.in\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"21f1be67-256d-4199-9f4a-44ed00433233\",\"my_referral\":\"JBWASTR2\",\"updated_at\":\"2025-02-05 05:11:21\",\"created_at\":\"2025-02-05 05:11:21\",\"id\":117}','2025-02-04 23:41:21',NULL,'user_created'),(219,'App\\Models\\User',117,'{\"uuid\":\"21f1be67-256d-4199-9f4a-44ed00433233\"}','2025-02-04 23:41:21',NULL,'user_updated'),(220,'App\\Models\\User',117,'{\"verify_token\":\"732281\"}','2025-02-04 23:43:18',NULL,'user_updated'),(221,'App\\Models\\User',117,'{\"verify_token\":\"732398\"}','2025-02-04 23:44:52',NULL,'user_updated'),(222,'App\\Models\\User',113,'{\"ip_address\":\"171.61.178.35\"}','2025-02-04 23:58:28',NULL,'user_updated'),(223,'App\\Models\\User',113,'{\"verify_token\":\"603812\"}','2025-02-04 23:58:28',NULL,'user_updated'),(224,'App\\Models\\User',113,'{\"email_verified_at\":null}','2025-02-04 23:58:51',NULL,'user_updated'),(225,'App\\Models\\User',117,'{\"verify_token\":\"732492\"}','2025-02-04 23:59:48',NULL,'user_updated'),(226,'App\\Models\\User',117,'{\"verify_token\":\"733388\"}','2025-02-05 00:01:21',NULL,'user_updated'),(227,'App\\Models\\User',117,'{\"verify_token\":\"733481\"}','2025-02-05 00:02:44',NULL,'user_updated'),(228,'App\\Models\\User',117,'{\"verify_token\":\"733564\"}','2025-02-05 00:12:13',NULL,'user_updated'),(229,'App\\Models\\User',117,'{\"verify_token\":\"734133\"}','2025-02-05 00:17:04',NULL,'user_updated'),(230,'App\\Models\\User',118,'{\"email\":\"sunilshetty@webschedio.in\",\"firstname\":\"sunilshetty@webschedio.in\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"7b501036-f881-42e0-a68b-f059696aec11\",\"my_referral\":\"ZXCJGJMA\",\"updated_at\":\"2025-02-05 06:00:22\",\"created_at\":\"2025-02-05 06:00:22\",\"id\":118}','2025-02-05 00:30:22',NULL,'user_created'),(231,'App\\Models\\User',118,'{\"uuid\":\"7b501036-f881-42e0-a68b-f059696aec11\"}','2025-02-05 00:30:22',NULL,'user_updated'),(232,'App\\Models\\User',118,'{\"verify_token\":\"735222\"}','2025-02-05 00:34:25',NULL,'user_updated'),(233,'App\\Models\\User',118,'{\"verify_token\":\"735465\"}','2025-02-05 00:38:45',NULL,'user_updated'),(234,'App\\Models\\User',116,'{\"phone\":\"973947449\",\"firebase_token\":\"[null,\\\"cagLXfguRyyH90shgq_MZE:APA91bFfvxw-CUwimKnXex9ZzuUm7haXMFa6mp-GW-sIA6xWS8NL25MMA9mnI7E8VdiAxT2K9I9cM14HlGXLapTGTZyKH_t2u90H2iSup7hS8HPgXwHwCls\\\"]\"}','2025-02-05 00:41:19',116,'user_updated'),(235,'App\\Models\\User',119,'{\"email\":\"anuppligade@gmail.com\",\"firstname\":\"anuppligade@gmail.com\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"f87f7cee-d7b7-4040-9a35-22cb7de149d9\",\"my_referral\":\"7AH0HZKR\",\"updated_at\":\"2025-02-05 06:13:33\",\"created_at\":\"2025-02-05 06:13:33\",\"id\":119}','2025-02-05 00:43:33',NULL,'user_created'),(236,'App\\Models\\User',119,'{\"uuid\":\"f87f7cee-d7b7-4040-9a35-22cb7de149d9\"}','2025-02-05 00:43:33',NULL,'user_updated'),(237,'App\\Models\\User',119,'{\"email_verified_at\":null}','2025-02-05 00:43:49',NULL,'user_updated'),(238,'App\\Models\\User',119,'{\"firstname\":\"anuppligade@gmail.com\",\"lastname\":null,\"password\":null}','2025-02-05 00:44:20',NULL,'user_updated'),(239,'App\\Models\\Product',33,'[]','2025-02-05 00:55:56',103,'product_deleted'),(240,'App\\Models\\Product',32,'[]','2025-02-05 00:56:03',103,'product_deleted'),(241,'App\\Models\\Product',31,'[]','2025-02-05 00:56:09',103,'product_deleted'),(242,'App\\Models\\Product',30,'[]','2025-02-05 00:56:17',103,'product_deleted'),(243,'App\\Models\\Product',29,'[]','2025-02-05 00:56:35',103,'product_deleted'),(244,'App\\Models\\Category',13,'{\"keywords\":\"Traditinal\",\"parent_id\":\"12\",\"type\":3,\"active\":\"1\",\"input\":\"1\",\"uuid\":\"f2b82467-a74f-4050-b31a-01133a5c766f\",\"updated_at\":\"2025-02-05 06:34:09\",\"created_at\":\"2025-02-05 06:34:09\",\"id\":13}','2025-02-05 01:04:09',103,'category_created'),(245,'App\\Models\\Category',13,'{\"active\":\"1\",\"input\":\"1\",\"uuid\":\"f2b82467-a74f-4050-b31a-01133a5c766f\"}','2025-02-05 01:04:09',103,'category_updated'),(246,'App\\Models\\Category',13,'{\"active\":\"1\",\"input\":\"1\",\"uuid\":\"f2b82467-a74f-4050-b31a-01133a5c766f\"}','2025-02-05 01:04:09',103,'category_updated'),(247,'App\\Models\\Product',34,'{\"uuid\":\"e6196bf8-3d6c-46ff-bea6-20286d80ff78\"}','2025-02-05 01:07:02',103,'product_updated'),(248,'App\\Models\\Product',34,'{\"uuid\":\"e6196bf8-3d6c-46ff-bea6-20286d80ff78\"}','2025-02-05 01:07:02',103,'product_updated'),(249,'App\\Models\\Product',34,'{\"min_price\":0,\"max_price\":0}','2025-02-05 01:10:57',103,'product_updated'),(250,'App\\Models\\Product',35,'{\"uuid\":\"6ed8a031-e030-4006-836e-b2ec8c6223e4\"}','2025-02-05 01:17:05',103,'product_updated'),(251,'App\\Models\\Product',35,'{\"uuid\":\"6ed8a031-e030-4006-836e-b2ec8c6223e4\"}','2025-02-05 01:17:05',103,'product_updated'),(252,'App\\Models\\Product',36,'{\"uuid\":\"7e95f944-f1c9-41dc-a11b-0c21f46aafb1\"}','2025-02-05 01:22:10',103,'product_updated'),(253,'App\\Models\\Product',36,'{\"uuid\":\"7e95f944-f1c9-41dc-a11b-0c21f46aafb1\"}','2025-02-05 01:22:10',103,'product_updated'),(254,'App\\Models\\Product',37,'{\"uuid\":\"47ddd83a-eb0b-4561-b7a6-dc57b96450b6\"}','2025-02-05 01:25:11',103,'product_updated'),(255,'App\\Models\\Product',37,'{\"uuid\":\"47ddd83a-eb0b-4561-b7a6-dc57b96450b6\"}','2025-02-05 01:25:11',103,'product_updated'),(256,'App\\Models\\User',112,'{\"firebase_token\":null}','2025-02-05 02:14:40',112,'user_updated'),(257,'App\\Models\\Order',1000,'{\"user_id\":115,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"address\":\"{\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"121\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":12.9274339454120674730575046851299703121185302734375,\\\"longitude\\\":77.6289322753906532170731225050985813140869140625}}\",\"delivery_price_id\":2,\"total_price\":0,\"commission_fee\":0,\"type\":2,\"shop_id\":501,\"parent_id\":null,\"otp\":1156,\"note\":null,\"updated_at\":\"2025-02-05 07:47:25\",\"created_at\":\"2025-02-05 07:47:25\",\"id\":1000}','2025-02-05 02:17:25',103,'order_created'),(258,'App\\Models\\Product',14,'[]','2025-02-05 02:17:25',103,'product_updated'),(259,'App\\Models\\Order',1000,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"address\":\"{\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"121\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":12.9274339454120674730575046851299703121185302734375,\\\"longitude\\\":77.6289322753906532170731225050985813140869140625}}\"}','2025-02-05 02:17:25',103,'order_updated'),(260,'App\\Models\\User',115,'{\"o_count\":0,\"o_sum\":0}','2025-02-05 02:17:25',103,'user_updated'),(261,'App\\Models\\Order',1001,'{\"user_id\":115,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"address\":\"{\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"121\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":12.9274339454120674730575046851299703121185302734375,\\\"longitude\\\":77.6289322753906532170731225050985813140869140625}}\",\"delivery_price_id\":2,\"total_price\":0,\"commission_fee\":0,\"type\":2,\"shop_id\":501,\"parent_id\":null,\"otp\":6661,\"note\":null,\"updated_at\":\"2025-02-05 07:49:11\",\"created_at\":\"2025-02-05 07:49:11\",\"id\":1001}','2025-02-05 02:19:11',103,'order_created'),(262,'App\\Models\\Product',14,'[]','2025-02-05 02:19:11',103,'product_updated'),(263,'App\\Models\\Order',1001,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"address\":\"{\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"121\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":12.9274339454120674730575046851299703121185302734375,\\\"longitude\\\":77.6289322753906532170731225050985813140869140625}}\"}','2025-02-05 02:19:11',103,'order_updated'),(264,'App\\Models\\User',115,'{\"o_count\":1,\"o_sum\":5475}','2025-02-05 02:19:11',103,'user_updated'),(265,'App\\Models\\User',112,'{\"firebase_token\":\"[null,\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\"]\"}','2025-02-05 02:30:44',112,'user_updated'),(266,'App\\Models\\User',112,'{\"password\":\"$2y$10$.BIF452CLmf1WMGb5zPzMuXqBeg2hiA2bx6Z9yRiARyLi88A7JM9m\",\"firebase_token\":\"[null,\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"d4uvka-HTX2qV5KVHHoSKr:APA91bGcO6DPtR5bjCZVy4mk_ngwLFOUsVJc868ALbeQKzFWoHKUSkmOFq4MGLOOluI-FIXmF5VS2HpEaYMMPDjhsRbKUZPfCVblJflhK5o1u6Ivgk-iXjY\\\"]\"}','2025-02-05 02:38:39',112,'user_updated'),(267,'App\\Models\\User',112,'{\"firebase_token\":\"[null,\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"d4uvka-HTX2qV5KVHHoSKr:APA91bGcO6DPtR5bjCZVy4mk_ngwLFOUsVJc868ALbeQKzFWoHKUSkmOFq4MGLOOluI-FIXmF5VS2HpEaYMMPDjhsRbKUZPfCVblJflhK5o1u6Ivgk-iXjY\\\"]\"}','2025-02-05 02:44:23',112,'user_updated'),(268,'App\\Models\\Category',13,'{\"status\":\"pending\"}','2025-02-05 02:50:47',103,'category_updated'),(269,'App\\Models\\Category',14,'{\"keywords\":\"Ram raj\",\"parent_id\":\"5\",\"type\":2,\"active\":\"1\",\"uuid\":\"4895280a-50b4-4b70-931b-ffc09489318b\",\"updated_at\":\"2025-02-05 08:22:01\",\"created_at\":\"2025-02-05 08:22:01\",\"id\":14}','2025-02-05 02:52:01',103,'category_created'),(270,'App\\Models\\Category',14,'{\"active\":\"1\",\"uuid\":\"4895280a-50b4-4b70-931b-ffc09489318b\"}','2025-02-05 02:52:01',103,'category_updated'),(271,'App\\Models\\Category',14,'{\"active\":\"1\",\"uuid\":\"4895280a-50b4-4b70-931b-ffc09489318b\"}','2025-02-05 02:52:01',103,'category_updated'),(272,'App\\Models\\Category',14,'{\"status\":\"pending\"}','2025-02-05 02:53:13',103,'category_updated'),(273,'App\\Models\\User',112,'{\"firebase_token\":\"{\\\"1\\\":\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\"}\"}','2025-02-05 02:55:40',112,'user_updated'),(274,'App\\Models\\User',120,'{\"email\":\"a@gmail.com\",\"phone\":\"7026656213\",\"lastname\":\"shetty\",\"birthday\":\"2007-02-01\",\"firstname\":\"narayan\",\"gender\":\"male\",\"password\":\"$2y$10$9KDylsTAa5DhpeWj7wRrEOOXE2NJOFVZhHenxBbq37p05YO8d8XFW\",\"email_verified_at\":\"2025-02-05T08:29:15.527780Z\",\"phone_verified_at\":\"2025-02-05T08:29:15.527791Z\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"8dfaef47-b7b3-4cfd-ac89-f0b161a62340\",\"my_referral\":\"I4G0REUB\",\"updated_at\":\"2025-02-05 08:29:15\",\"created_at\":\"2025-02-05 08:29:15\",\"id\":120}','2025-02-05 02:59:15',103,'user_created'),(275,'App\\Models\\User',120,'{\"birthday\":\"2007-02-01\",\"email_verified_at\":\"2025-02-05T08:29:15.527780Z\",\"phone_verified_at\":\"2025-02-05T08:29:15.527791Z\",\"uuid\":\"8dfaef47-b7b3-4cfd-ac89-f0b161a62340\"}','2025-02-05 02:59:15',103,'user_updated'),(276,'App\\Models\\Category',15,'{\"keywords\":\"iphone\",\"type\":1,\"active\":\"1\",\"input\":\"1\",\"uuid\":\"d38c61b4-ebe2-4fca-a974-7ad5febacadd\",\"updated_at\":\"2025-02-05 08:37:35\",\"created_at\":\"2025-02-05 08:37:35\",\"id\":15}','2025-02-05 03:07:35',103,'category_created'),(277,'App\\Models\\Category',15,'{\"active\":\"1\",\"input\":\"1\",\"uuid\":\"d38c61b4-ebe2-4fca-a974-7ad5febacadd\"}','2025-02-05 03:07:35',103,'category_updated'),(278,'App\\Models\\Category',15,'{\"active\":\"1\",\"input\":\"1\",\"uuid\":\"d38c61b4-ebe2-4fca-a974-7ad5febacadd\"}','2025-02-05 03:07:35',103,'category_updated'),(279,'App\\Models\\Category',15,'{\"status\":\"pending\"}','2025-02-05 03:08:14',103,'category_updated'),(280,'App\\Models\\Brand',1,'{\"active\":\"1\",\"title\":\"iphone\",\"slug\":\"iphone-0\",\"uuid\":\"c427f4c0-fb63-4b98-938c-ab86c26096bb\",\"updated_at\":\"2025-02-05 08:47:44\",\"created_at\":\"2025-02-05 08:47:44\",\"id\":1}','2025-02-05 03:17:44',103,'brand_created'),(281,'App\\Models\\Brand',1,'{\"active\":\"1\",\"uuid\":\"c427f4c0-fb63-4b98-938c-ab86c26096bb\"}','2025-02-05 03:17:44',103,'brand_updated'),(282,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"d4uvka-HTX2qV5KVHHoSKr:APA91bGcO6DPtR5bjCZVy4mk_ngwLFOUsVJc868ALbeQKzFWoHKUSkmOFq4MGLOOluI-FIXmF5VS2HpEaYMMPDjhsRbKUZPfCVblJflhK5o1u6Ivgk-iXjY\\\"]\"}','2025-02-05 05:05:10',112,'user_updated'),(283,'App\\Models\\User',111,'{\"ip_address\":\"122.162.170.150\"}','2025-02-05 05:07:24',NULL,'user_updated'),(284,'App\\Models\\User',111,'{\"verify_token\":\"568319\"}','2025-02-05 05:07:24',NULL,'user_updated'),(285,'App\\Models\\User',111,'{\"email_verified_at\":null}','2025-02-05 05:07:59',NULL,'user_updated'),(286,'App\\Models\\User',111,'{\"firstname\":\"voj8899@gmail.com\",\"lastname\":null,\"phone\":null,\"password\":\"$2y$10$O9ejE4dh5GcsnVnwE\\/Enyu8N8BQ8\\/PdzdKkYbnWbGFx...\"}','2025-02-05 05:10:10',111,'user_updated'),(287,'App\\Models\\User',111,'{\"firebase_token\":null}','2025-02-05 05:10:13',111,'user_updated'),(288,'App\\Models\\User',111,'{\"phone\":\"9986809661\",\"firebase_token\":\"[null,\\\"d4uvka-HTX2qV5KVHHoSKr:APA91bGcO6DPtR5bjCZVy4mk_ngwLFOUsVJc868ALbeQKzFWoHKUSkmOFq4MGLOOluI-FIXmF5VS2HpEaYMMPDjhsRbKUZPfCVblJflhK5o1u6Ivgk-iXjY\\\"]\"}','2025-02-05 05:12:32',111,'user_updated'),(289,'App\\Models\\User',111,'{\"firebase_token\":\"[null,\\\"d4uvka-HTX2qV5KVHHoSKr:APA91bGcO6DPtR5bjCZVy4mk_ngwLFOUsVJc868ALbeQKzFWoHKUSkmOFq4MGLOOluI-FIXmF5VS2HpEaYMMPDjhsRbKUZPfCVblJflhK5o1u6Ivgk-iXjY\\\"]\"}','2025-02-05 05:12:47',111,'user_updated'),(290,'App\\Models\\User',111,'{\"firebase_token\":\"[]\"}','2025-02-05 05:13:48',111,'user_updated'),(291,'App\\Models\\User',111,'{\"firebase_token\":\"[\\\"d4uvka-HTX2qV5KVHHoSKr:APA91bGcO6DPtR5bjCZVy4mk_ngwLFOUsVJc868ALbeQKzFWoHKUSkmOFq4MGLOOluI-FIXmF5VS2HpEaYMMPDjhsRbKUZPfCVblJflhK5o1u6Ivgk-iXjY\\\"]\"}','2025-02-05 05:14:17',111,'user_updated'),(292,'App\\Models\\User',121,'{\"email\":\"sunilshetty@webschedio.in\",\"firstname\":\"sunilshetty@webschedio.in\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"d162bedd-a5ad-4a88-b096-dca15b5f9e8a\",\"my_referral\":\"A3ZGSNLN\",\"updated_at\":\"2025-02-05 11:09:54\",\"created_at\":\"2025-02-05 11:09:54\",\"id\":121}','2025-02-05 05:39:54',NULL,'user_created'),(293,'App\\Models\\User',121,'{\"uuid\":\"d162bedd-a5ad-4a88-b096-dca15b5f9e8a\"}','2025-02-05 05:39:54',NULL,'user_updated'),(294,'App\\Models\\User',121,'{\"email_verified_at\":null}','2025-02-05 05:40:31',NULL,'user_updated'),(295,'App\\Models\\User',121,'{\"firstname\":\"sunilshetty@webschedio.in\",\"lastname\":null,\"phone\":null,\"password\":null}','2025-02-05 05:41:30',121,'user_updated'),(296,'App\\Models\\User',121,'{\"firebase_token\":null}','2025-02-05 05:41:44',121,'user_updated'),(297,'App\\Models\\User',121,'{\"firebase_token\":\"[null,\\\"eBCIldGMSS6Qn6GN5sdLfI:APA91bHzew3lkwuB80mVhWn4bhZ2KnltxHrMMt2I86aoyOxCWOMXpGEiAJvytOaCA7rX3O-HlktScWM_jzpxGKIQmjRVhOWtaYtlVEOC3hsMUFeHIiRLG8Q\\\"]\"}','2025-02-05 05:42:17',121,'user_updated'),(298,'App\\Models\\User',121,'{\"firebase_token\":\"[]\"}','2025-02-05 05:43:00',121,'user_updated'),(299,'App\\Models\\User',121,'{\"phone\":\"9741374788\",\"firebase_token\":\"[\\\"eBCIldGMSS6Qn6GN5sdLfI:APA91bHzew3lkwuB80mVhWn4bhZ2KnltxHrMMt2I86aoyOxCWOMXpGEiAJvytOaCA7rX3O-HlktScWM_jzpxGKIQmjRVhOWtaYtlVEOC3hsMUFeHIiRLG8Q\\\"]\"}','2025-02-05 06:36:51',121,'user_updated'),(300,'App\\Models\\User',122,'{\"email\":\"a2@gmail.com\",\"phone\":\"7026856213\",\"lastname\":\"bhatt\",\"birthday\":\"2007-02-01\",\"firstname\":\"ragvendra\",\"gender\":\"male\",\"password\":\"$2y$10$X.6RehIoNprpi1NX5XO2VOGao\\/.G0KOLDJBxEjJDC1xBc6I\\/Lv5TO\",\"email_verified_at\":\"2025-02-06T06:32:23.135130Z\",\"phone_verified_at\":\"2025-02-06T06:32:23.135140Z\",\"ip_address\":\"122.167.131.110\",\"uuid\":\"335c30f0-da1c-456b-a4a1-bbb2204023a9\",\"my_referral\":\"KZ8EIDI5\",\"updated_at\":\"2025-02-06 06:32:23\",\"created_at\":\"2025-02-06 06:32:23\",\"id\":122}','2025-02-06 01:02:23',103,'user_created'),(301,'App\\Models\\User',122,'{\"birthday\":\"2007-02-01\",\"email_verified_at\":\"2025-02-06T06:32:23.135130Z\",\"phone_verified_at\":\"2025-02-06T06:32:23.135140Z\",\"uuid\":\"335c30f0-da1c-456b-a4a1-bbb2204023a9\"}','2025-02-06 01:02:23',103,'user_updated'),(302,'App\\Models\\Order',1002,'{\"cart_id\":3,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-06 12:17\",\"address_id\":4,\"delivery_price_id\":2,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":4956,\"updated_at\":\"2025-02-06 06:47:22\",\"created_at\":\"2025-02-06 06:47:22\",\"id\":1002}','2025-02-06 01:17:22',119,'order_created'),(303,'App\\Models\\Product',6,'[]','2025-02-06 01:17:22',119,'product_updated'),(304,'App\\Models\\Product',1,'[]','2025-02-06 01:17:22',119,'product_updated'),(305,'App\\Models\\Product',3,'[]','2025-02-06 01:17:22',119,'product_updated'),(306,'App\\Models\\Order',1002,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-06 01:17:22',119,'order_updated'),(307,'App\\Models\\User',119,'{\"o_count\":0,\"o_sum\":0}','2025-02-06 01:17:22',119,'user_updated'),(308,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\"]\"}','2025-02-06 07:22:43',112,'user_updated'),(309,'App\\Models\\Order',1003,'{\"cart_id\":4,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-02-06 18:25\",\"delivery_point_id\":2,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5927,\"updated_at\":\"2025-02-06 12:55:13\",\"created_at\":\"2025-02-06 12:55:13\",\"id\":1003}','2025-02-06 07:25:13',112,'order_created'),(310,'App\\Models\\Product',1,'[]','2025-02-06 07:25:13',112,'product_updated'),(311,'App\\Models\\Order',1003,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-06 07:25:13',112,'order_updated'),(312,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\"]\",\"o_count\":0,\"o_sum\":0}','2025-02-06 07:25:13',112,'user_updated'),(313,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\"]\"}','2025-02-06 07:30:42',112,'user_updated'),(314,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\"]\"}','2025-02-06 07:33:06',112,'user_updated'),(315,'App\\Models\\User',123,'{\"email\":\"a0@gmail.com\",\"phone\":\"7026656210\",\"lastname\":\"agowda\",\"birthday\":\"2007-02-01\",\"firstname\":\"akshay\",\"gender\":\"male\",\"password\":\"$2y$10$kRa6PNMcJMMSjwBrabKQzOgOx8IumuT8dwsyfMDV1kmbo6yTWkQIG\",\"email_verified_at\":\"2025-02-07T06:04:31.404947Z\",\"phone_verified_at\":\"2025-02-07T06:04:31.404956Z\",\"ip_address\":\"122.167.17.99\",\"uuid\":\"25224ac8-2e73-4e0e-9861-86f71fae85ac\",\"my_referral\":\"ZJGRTIO1\",\"updated_at\":\"2025-02-07 06:04:31\",\"created_at\":\"2025-02-07 06:04:31\",\"id\":123}','2025-02-07 00:34:31',103,'user_created'),(316,'App\\Models\\User',123,'{\"birthday\":\"2007-02-01\",\"email_verified_at\":\"2025-02-07T06:04:31.404947Z\",\"phone_verified_at\":\"2025-02-07T06:04:31.404956Z\",\"uuid\":\"25224ac8-2e73-4e0e-9861-86f71fae85ac\"}','2025-02-07 00:34:31',103,'user_updated'),(317,'App\\Models\\User',123,'{\"birthday\":\"2007-02-01\",\"email_verified_at\":\"2025-02-07 06:04:31\",\"phone_verified_at\":\"2025-02-07 06:04:31\"}','2025-02-07 00:35:01',103,'user_updated'),(318,'App\\Models\\User',123,'{\"birthday\":\"2007-02-01\",\"email_verified_at\":\"2025-02-07 06:05:01\",\"phone_verified_at\":\"2025-02-07 06:05:01\"}','2025-02-07 00:35:39',103,'user_updated'),(319,'App\\Models\\User',106,'{\"firstname\":\"Delivery\",\"lastname\":\"Delivery\",\"email\":\"delivery@githubit.com\",\"phone\":\"998911912116\",\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2024-12-30 06:28:41\",\"phone_verified_at\":null}','2025-02-07 00:38:42',103,'user_updated'),(320,'App\\Models\\User',106,'{\"birthday\":\"2007-02-01\",\"email_verified_at\":\"2025-02-07T06:08:42.239076Z\",\"phone_verified_at\":\"2025-02-07T06:08:42.239085Z\",\"img\":null}','2025-02-07 00:38:42',103,'user_updated'),(321,'App\\Models\\Product',3,'{\"category_id\":12,\"tax\":0,\"max_qty\":1,\"status_note\":\"\"}','2025-02-07 01:25:10',103,'product_updated'),(322,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\"]\"}','2025-02-07 01:53:09',112,'user_updated'),(323,'App\\Models\\Order',1004,'{\"cart_id\":5,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-02-07 13:05\",\"delivery_point_id\":2,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9015,\"updated_at\":\"2025-02-07 07:36:00\",\"created_at\":\"2025-02-07 07:36:00\",\"id\":1004}','2025-02-07 02:06:00',112,'order_created'),(324,'App\\Models\\Product',5,'[]','2025-02-07 02:06:00',112,'product_updated'),(325,'App\\Models\\Order',1004,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-07 02:06:00',112,'order_updated'),(326,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\"]\",\"o_count\":1,\"o_sum\":3022}','2025-02-07 02:06:00',112,'user_updated'),(327,'App\\Models\\User',112,'{\"phone\":null,\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\"]\"}','2025-02-07 02:20:07',112,'user_updated'),(328,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\"]\"}','2025-02-07 04:43:48',112,'user_updated'),(329,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\"]\"}','2025-02-07 04:44:03',112,'user_updated'),(334,'App\\Models\\Order',1006,'{\"user_id\":123,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"address\":\"{\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"121\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":12.9274339454120674730575046851299703121185302734375,\\\"longitude\\\":77.6289322753906532170731225050985813140869140625}}\",\"phone\":\"7026656210\",\"delivery_price_id\":4,\"total_price\":0,\"commission_fee\":0,\"type\":2,\"shop_id\":501,\"parent_id\":null,\"otp\":4310,\"note\":null,\"updated_at\":\"2025-02-07 10:55:27\",\"created_at\":\"2025-02-07 10:55:27\",\"id\":1006}','2025-02-07 05:25:27',103,'order_created'),(335,'App\\Models\\Product',1,'[]','2025-02-07 05:25:27',103,'product_updated'),(336,'App\\Models\\Product',14,'[]','2025-02-07 05:25:27',103,'product_updated'),(337,'App\\Models\\Order',1006,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"address\":\"{\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"121\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":12.9274339454120674730575046851299703121185302734375,\\\"longitude\\\":77.6289322753906532170731225050985813140869140625}}\"}','2025-02-07 05:25:27',103,'order_updated'),(338,'App\\Models\\User',123,'{\"birthday\":\"2007-02-01\",\"o_count\":0,\"o_sum\":0}','2025-02-07 05:25:27',103,'user_updated'),(339,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\"]\"}','2025-02-07 05:37:53',112,'user_updated'),(340,'App\\Models\\Order',1007,'{\"cart_id\":7,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-07 16:58\",\"address_id\":6,\"delivery_price_id\":4,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8890,\"updated_at\":\"2025-02-07 11:28:56\",\"created_at\":\"2025-02-07 11:28:56\",\"id\":1007}','2025-02-07 05:58:56',112,'order_created'),(341,'App\\Models\\Product',1,'[]','2025-02-07 05:58:56',112,'product_updated'),(342,'App\\Models\\Order',1007,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-07 05:58:56',112,'order_updated'),(343,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\"]\",\"o_count\":2,\"o_sum\":12024}','2025-02-07 05:58:56',112,'user_updated'),(344,'App\\Models\\User',112,'{\"lastname\":\"SHETTY\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\"]\"}','2025-02-07 06:02:57',112,'user_updated'),(345,'App\\Models\\User',112,'{\"lastname\":\"SHETTY g\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\"]\"}','2025-02-07 06:08:26',112,'user_updated'),(349,'App\\Models\\Order',1009,'{\"user_id\":121,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"address\":\"{\\\"address\\\":\\\"S\\\\\\/O ashok kk kerekodi thirthahalli tq, shimoga\\\",\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"21\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":\\\"41.40132639704341\\\",\\\"longitude\\\":\\\"69.21079476953123\\\",\\\"address\\\":\\\"S\\\\\\/O ashok kk kerekodi thirthahalli tq, shimoga\\\"}}\",\"phone\":\"805047101\",\"delivery_price_id\":4,\"total_price\":0,\"commission_fee\":0,\"type\":2,\"shop_id\":501,\"parent_id\":null,\"otp\":3246,\"note\":null,\"updated_at\":\"2025-02-07 11:54:07\",\"created_at\":\"2025-02-07 11:54:07\",\"id\":1009}','2025-02-07 06:24:07',103,'order_created'),(350,'App\\Models\\Product',14,'[]','2025-02-07 06:24:07',103,'product_updated'),(351,'App\\Models\\Order',1009,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"address\":\"{\\\"address\\\":\\\"S\\\\\\/O ashok kk kerekodi thirthahalli tq, shimoga\\\",\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"21\\\",\\\"zip_code\\\":\\\"577422\\\",\\\"location\\\":{\\\"latitude\\\":\\\"41.40132639704341\\\",\\\"longitude\\\":\\\"69.21079476953123\\\",\\\"address\\\":\\\"S\\\\\\/O ashok kk kerekodi thirthahalli tq, shimoga\\\"}}\"}','2025-02-07 06:24:07',103,'order_updated'),(352,'App\\Models\\User',121,'{\"firebase_token\":\"[\\\"eBCIldGMSS6Qn6GN5sdLfI:APA91bHzew3lkwuB80mVhWn4bhZ2KnltxHrMMt2I86aoyOxCWOMXpGEiAJvytOaCA7rX3O-HlktScWM_jzpxGKIQmjRVhOWtaYtlVEOC3hsMUFeHIiRLG8Q\\\"]\",\"o_count\":0,\"o_sum\":0}','2025-02-07 06:24:07',103,'user_updated'),(353,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\"]\"}','2025-02-07 06:24:28',112,'user_updated'),(357,'App\\Models\\Order',1011,'{\"user_id\":120,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"address\":\"{\\\"address\\\":\\\"udipalya kanakapura main road 1st cross Bangalore\\\",\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"1\\\",\\\"zip_code\\\":\\\"560082\\\",\\\"location\\\":{\\\"latitude\\\":\\\"41.349801\\\",\\\"longitude\\\":\\\"69.2519935\\\",\\\"address\\\":\\\"udipalya kanakapura main road 1st cross Bangalore\\\"}}\",\"phone\":\"7026656213\",\"delivery_price_id\":4,\"total_price\":0,\"commission_fee\":0,\"type\":2,\"shop_id\":501,\"parent_id\":null,\"otp\":7111,\"note\":null,\"updated_at\":\"2025-02-07 11:59:53\",\"created_at\":\"2025-02-07 11:59:53\",\"id\":1011}','2025-02-07 06:29:53',103,'order_created'),(358,'App\\Models\\Product',2,'[]','2025-02-07 06:29:53',103,'product_updated'),(359,'App\\Models\\Order',1011,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"address\":\"{\\\"address\\\":\\\"udipalya kanakapura main road 1st cross Bangalore\\\",\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"1\\\",\\\"zip_code\\\":\\\"560082\\\",\\\"location\\\":{\\\"latitude\\\":\\\"41.349801\\\",\\\"longitude\\\":\\\"69.2519935\\\",\\\"address\\\":\\\"udipalya kanakapura main road 1st cross Bangalore\\\"}}\"}','2025-02-07 06:29:53',103,'order_updated'),(360,'App\\Models\\User',120,'{\"birthday\":\"2007-02-01\",\"o_count\":0,\"o_sum\":0}','2025-02-07 06:29:53',103,'user_updated'),(361,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"fvcar5OmQBSvvjHMD-Ybx-:APA91bEkIqQw33xsGmDql1dJp7uwKUzPU23ZIKD4KbnzLdn7ZBuXf6J5BoomsgviE7DZy7Lya0FgaFmOlX6IrdAnzooGxwZtujCxG4NZik9afWYMyWZKXEU\\\"]\"}','2025-02-07 07:39:05',112,'user_updated'),(362,'App\\Models\\Order',1011,'{\"type\":\"2\",\"status\":\"new\",\"address\":\"{\\\"address\\\":\\\"udipalya kanakapura main road 1st cross Bangalore\\\",\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"1\\\",\\\"zip_code\\\":\\\"560082\\\",\\\"location\\\":{\\\"latitude\\\":\\\"41.349801\\\",\\\"longitude\\\":\\\"69.2519935\\\",\\\"address\\\":\\\"udipalya kanakapura main road 1st cross Bangalore\\\"}}\"}','2025-02-09 11:16:04',103,'order_updated'),(363,'App\\Models\\Order',1007,'{\"type\":\"2\",\"status\":\"new\"}','2025-02-09 23:30:36',103,'order_updated'),(364,'App\\Models\\User',119,'{\"birthday\":null}','2025-02-10 00:08:52',119,'user_updated'),(365,'App\\Models\\Order',1012,'{\"user_id\":123,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"address\":\"{\\\"address\\\":\\\"gopala padma talkies governament school behind 1st cross shimoga\\\",\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"1\\\",\\\"zip_code\\\":\\\"577204\\\",\\\"location\\\":{\\\"latitude\\\":\\\"41.349801\\\",\\\"longitude\\\":\\\"69.2519935\\\",\\\"address\\\":\\\"gopala padma talkies governament school behind 1st cross shimoga\\\"}}\",\"phone\":\"7026656210\",\"delivery_price_id\":4,\"total_price\":0,\"commission_fee\":0,\"type\":2,\"shop_id\":501,\"parent_id\":null,\"otp\":7065,\"note\":null,\"updated_at\":\"2025-02-10 06:16:31\",\"created_at\":\"2025-02-10 06:16:31\",\"id\":1012}','2025-02-10 00:46:31',103,'order_created'),(366,'App\\Models\\Product',14,'[]','2025-02-10 00:46:31',103,'product_updated'),(367,'App\\Models\\Order',1012,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"address\":\"{\\\"address\\\":\\\"gopala padma talkies governament school behind 1st cross shimoga\\\",\\\"country_id\\\":1,\\\"city_id\\\":1,\\\"street_house_number\\\":\\\"1\\\",\\\"zip_code\\\":\\\"577204\\\",\\\"location\\\":{\\\"latitude\\\":\\\"41.349801\\\",\\\"longitude\\\":\\\"69.2519935\\\",\\\"address\\\":\\\"gopala padma talkies governament school behind 1st cross shimoga\\\"}}\"}','2025-02-10 00:46:31',103,'order_updated'),(368,'App\\Models\\User',123,'{\"birthday\":\"2007-02-01\",\"o_count\":1,\"o_sum\":8247}','2025-02-10 00:46:31',103,'user_updated'),(369,'App\\Models\\Order',1013,'{\"user_id\":122,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"phone\":\"7026856213\",\"delivery_point_id\":2,\"total_price\":0,\"commission_fee\":0,\"type\":2,\"shop_id\":501,\"parent_id\":null,\"otp\":4089,\"note\":null,\"updated_at\":\"2025-02-10 06:51:48\",\"created_at\":\"2025-02-10 06:51:48\",\"id\":1013}','2025-02-10 01:21:48',103,'order_created'),(370,'App\\Models\\Product',14,'[]','2025-02-10 01:21:48',103,'product_updated'),(371,'App\\Models\\Order',1013,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-10 01:21:48',103,'order_updated'),(372,'App\\Models\\User',122,'{\"birthday\":\"2007-02-01\",\"o_count\":0,\"o_sum\":0}','2025-02-10 01:21:48',103,'user_updated'),(373,'App\\Models\\User',124,'{\"email\":\"yashbharadwajk@webschedio.in\",\"firstname\":\"yashbharadwajk@webschedio.in\",\"ip_address\":\"122.162.162.15\",\"uuid\":\"419bc3aa-b5e1-44d5-b86e-b2bcff133253\",\"my_referral\":\"MRBRZDPQ\",\"updated_at\":\"2025-02-10 09:15:46\",\"created_at\":\"2025-02-10 09:15:46\",\"id\":124}','2025-02-10 03:45:46',NULL,'user_created'),(374,'App\\Models\\User',124,'{\"uuid\":\"419bc3aa-b5e1-44d5-b86e-b2bcff133253\"}','2025-02-10 03:45:46',NULL,'user_updated'),(375,'App\\Models\\User',124,'{\"email_verified_at\":null}','2025-02-10 03:46:39',NULL,'user_updated'),(376,'App\\Models\\User',124,'{\"firstname\":\"yashbharadwajk@webschedio.in\",\"lastname\":null,\"password\":null}','2025-02-10 03:47:55',NULL,'user_updated'),(377,'App\\Models\\User',125,'{\"email\":\"anuppligadesss@gmail.com\",\"firstname\":\"anuppligadesss@gmail.com\",\"ip_address\":\"122.162.162.15\",\"uuid\":\"2865dc3f-69c0-4b4c-a274-3bbaf5e7cafa\",\"my_referral\":\"STSQDBQN\",\"updated_at\":\"2025-02-10 09:42:05\",\"created_at\":\"2025-02-10 09:42:05\",\"id\":125}','2025-02-10 04:12:05',NULL,'user_created'),(378,'App\\Models\\User',125,'{\"uuid\":\"2865dc3f-69c0-4b4c-a274-3bbaf5e7cafa\"}','2025-02-10 04:12:05',NULL,'user_updated'),(379,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\"]\"}','2025-02-10 05:08:58',112,'user_updated'),(380,'App\\Models\\Order',1013,'{\"type\":\"2\",\"rate\":1,\"location\":null,\"address\":null,\"delivery_date\":null}','2025-02-10 05:17:05',103,'order_updated'),(381,'App\\Models\\Product',14,'[]','2025-02-10 05:17:05',103,'product_updated'),(382,'App\\Models\\Order',1013,'{\"type\":\"2\",\"total_price\":6227,\"commission_fee\":0,\"location\":\"{\\\"latitude\\\":12.9013321468522139667811643448658287525177001953125,\\\"longitude\\\":77.5870468994140907170731225050985813140869140625}\",\"address\":\"{\\\"address\\\":\\\"WH2P+GRC, 21st Main Rd, 5th Phase, Ayodya Nagar, J P Nagar Phase 5, J. P. Nagar, Bengaluru, Karnataka 560078, India\\\",\\\"office\\\":null,\\\"house\\\":null,\\\"floor\\\":null}\"}','2025-02-10 05:17:05',103,'order_updated'),(383,'App\\Models\\User',122,'{\"birthday\":\"2007-02-01\",\"o_count\":1,\"o_sum\":6227}','2025-02-10 05:17:05',103,'user_updated'),(384,'App\\Models\\Order',1013,'{\"type\":\"2\",\"rate\":1,\"location\":\"{\\\"latitude\\\":12.9013321468522139667811643448658287525177001953125,\\\"longitude\\\":77.5870468994140907170731225050985813140869140625}\",\"address\":\"{\\\"address\\\":\\\"WH2P+GRC, 21st Main Rd, 5th Phase, Ayodya Nagar, J P Nagar Phase 5, J. P. Nagar, Bengaluru, Karnataka 560078, India\\\",\\\"office\\\":null,\\\"house\\\":null,\\\"floor\\\":null}\",\"delivery_date\":\"2025-02-28 16:00:00\"}','2025-02-10 05:19:05',103,'order_updated'),(385,'App\\Models\\Product',14,'[]','2025-02-10 05:19:05',103,'product_updated'),(386,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\"]\"}','2025-02-10 05:32:59',112,'user_updated'),(387,'App\\Models\\Order',1013,'{\"type\":\"2\",\"rate\":1,\"location\":\"{\\\"latitude\\\":12.9013321468522139667811643448658287525177001953125,\\\"longitude\\\":77.5870468994140907170731225050985813140869140625}\",\"address\":\"{\\\"address\\\":\\\"WH2P+GRC, 21st Main Rd, 5th Phase, Ayodya Nagar, J P Nagar Phase 5, J. P. Nagar, Bengaluru, Karnataka 560078, India\\\",\\\"office\\\":null,\\\"house\\\":null,\\\"floor\\\":null}\",\"delivery_date\":\"2025-02-28 20:00:00\"}','2025-02-10 06:18:55',103,'order_updated'),(388,'App\\Models\\Product',14,'[]','2025-02-10 06:18:55',103,'product_updated'),(389,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\"]\"}','2025-02-10 23:55:07',112,'user_updated'),(390,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\"]\"}','2025-02-11 00:02:54',112,'user_updated'),(391,'App\\Models\\Order',1014,'{\"cart_id\":10,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-02-11 11:16\",\"address_id\":8,\"delivery_point_id\":2,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8170,\"updated_at\":\"2025-02-11 05:46:20\",\"created_at\":\"2025-02-11 05:46:20\",\"id\":1014}','2025-02-11 00:16:20',112,'order_created'),(392,'App\\Models\\Product',1,'[]','2025-02-11 00:16:20',112,'product_updated'),(393,'App\\Models\\Product',28,'[]','2025-02-11 00:16:20',112,'product_updated'),(394,'App\\Models\\Order',1014,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-11 00:16:20',112,'order_updated'),(395,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\"]\",\"o_count\":3,\"o_sum\":15046}','2025-02-11 00:16:20',112,'user_updated'),(396,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\"]\"}','2025-02-11 00:35:08',112,'user_updated'),(397,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\"]\"}','2025-02-11 00:50:02',112,'user_updated'),(398,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\"]\"}','2025-02-11 01:42:57',112,'user_updated'),(399,'App\\Models\\Order',1015,'{\"cart_id\":6,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-02-11 17:55\",\"delivery_point_id\":2,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2164,\"updated_at\":\"2025-02-11 12:25:54\",\"created_at\":\"2025-02-11 12:25:54\",\"id\":1015}','2025-02-11 06:55:54',119,'order_created'),(400,'App\\Models\\Product',1,'[]','2025-02-11 06:55:54',119,'product_updated'),(401,'App\\Models\\Product',28,'[]','2025-02-11 06:55:54',119,'product_updated'),(402,'App\\Models\\Order',1015,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-11 06:55:54',119,'order_updated'),(403,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"o_count\":1,\"o_sum\":3625}','2025-02-11 06:55:55',119,'user_updated'),(404,'App\\Models\\Order',1016,'{\"cart_id\":13,\"shop_id\":501,\"user_id\":124,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-02-12 11:01\",\"delivery_point_id\":2,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5200,\"updated_at\":\"2025-02-12 05:31:52\",\"created_at\":\"2025-02-12 05:31:52\",\"id\":1016}','2025-02-12 00:01:52',124,'order_created'),(405,'App\\Models\\Product',5,'[]','2025-02-12 00:01:52',124,'product_updated'),(406,'App\\Models\\Order',1016,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 00:01:52',124,'order_updated'),(407,'App\\Models\\User',124,'{\"o_count\":0,\"o_sum\":0}','2025-02-12 00:01:52',124,'user_updated'),(408,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":2}','2025-02-12 00:15:12',103,'shop_updated'),(409,'App\\Models\\User',107,'{\"firstname\":\"sellers\",\"lastname\":\"sellers\",\"email\":\"sellers@githubit.com\",\"phone\":\"998911902691\",\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2025-01-22 06:55:33\",\"phone_verified_at\":\"2025-01-22 06:55:33\",\"password\":\"$2y$10$pmk0UKRnNe\\/2Q6MdOMDIv.WZ1xtk.ozsiobWKa4NhomDIwj5PJ5V.\"}','2025-02-12 00:17:45',103,'user_updated'),(410,'App\\Models\\Order',1017,'{\"cart_id\":14,\"shop_id\":501,\"user_id\":124,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-12 11:19\",\"address_id\":22,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2312,\"updated_at\":\"2025-02-12 05:49:14\",\"created_at\":\"2025-02-12 05:49:14\",\"id\":1017}','2025-02-12 00:19:14',124,'order_created'),(411,'App\\Models\\Product',28,'[]','2025-02-12 00:19:14',124,'product_updated'),(412,'App\\Models\\Order',1017,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 00:19:14',124,'order_updated'),(413,'App\\Models\\User',124,'{\"o_count\":1,\"o_sum\":9002}','2025-02-12 00:19:14',124,'user_updated'),(414,'App\\Models\\Order',1017,'{\"type\":\"1\",\"status\":\"new\"}','2025-02-12 00:21:20',103,'order_updated'),(415,'App\\Models\\Order',1017,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-02-12 00:23:26',103,'order_updated'),(416,'App\\Models\\Order',1017,'{\"type\":\"1\",\"status\":\"ready\"}','2025-02-12 00:23:51',103,'order_updated'),(417,'App\\Models\\Order',1017,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-02-12 00:24:21',103,'order_updated'),(418,'App\\Models\\Category',15,'{\"keywords\":\"iphone\",\"input\":1}','2025-02-12 00:37:38',103,'category_updated'),(419,'App\\Models\\Category',15,'{\"slug\":\"iphone-15\",\"input\":\"11\",\"active\":\"1\"}','2025-02-12 00:37:38',103,'category_updated'),(420,'App\\Models\\Product',38,'{\"uuid\":\"f57be567-76a1-4f11-b354-5791e3e5479a\"}','2025-02-12 01:01:27',103,'product_updated'),(421,'App\\Models\\Product',38,'{\"uuid\":\"f57be567-76a1-4f11-b354-5791e3e5479a\"}','2025-02-12 01:01:27',103,'product_updated'),(422,'App\\Models\\Product',39,'{\"uuid\":\"8411ef14-3e0f-4217-aa90-40d798d996f5\"}','2025-02-12 01:01:37',103,'product_updated'),(423,'App\\Models\\Product',39,'{\"uuid\":\"8411ef14-3e0f-4217-aa90-40d798d996f5\"}','2025-02-12 01:01:37',103,'product_updated'),(424,'App\\Models\\Product',38,'{\"min_price\":0,\"max_price\":0}','2025-02-12 01:02:43',103,'product_updated'),(425,'App\\Models\\Product',38,'{\"status\":\"pending\",\"status_note\":null}','2025-02-12 01:03:02',103,'product_updated'),(426,'App\\Models\\Category',15,'{\"parent_id\":0,\"type\":1}','2025-02-12 01:06:47',103,'category_updated'),(427,'App\\Models\\Category',1,'{\"status\":\"pending\"}','2025-02-12 01:08:24',103,'category_updated'),(428,'App\\Models\\Category',1,'{\"input\":null}','2025-02-12 01:09:02',103,'category_updated'),(429,'App\\Models\\Category',1,'{\"slug\":null,\"input\":\"11\",\"active\":\"1\"}','2025-02-12 01:09:02',103,'category_updated'),(430,'App\\Models\\Category',1,'{\"input\":\"11\",\"img\":null,\"active\":\"1\"}','2025-02-12 01:09:02',103,'category_updated'),(431,'App\\Models\\Product',24,'[]','2025-02-12 01:20:00',103,'product_deleted'),(432,'App\\Models\\Product',23,'[]','2025-02-12 01:20:08',103,'product_deleted'),(433,'App\\Models\\Product',22,'[]','2025-02-12 01:20:14',103,'product_deleted'),(434,'App\\Models\\Product',21,'[]','2025-02-12 01:20:21',103,'product_deleted'),(435,'App\\Models\\Product',20,'[]','2025-02-12 01:20:26',103,'product_deleted'),(436,'App\\Models\\Product',19,'[]','2025-02-12 01:20:30',103,'product_deleted'),(437,'App\\Models\\Product',12,'[]','2025-02-12 01:20:47',103,'product_deleted'),(438,'App\\Models\\Product',13,'[]','2025-02-12 01:20:52',103,'product_deleted'),(439,'App\\Models\\Product',14,'{\"tax\":10,\"min_qty\":19,\"status_note\":\"\"}','2025-02-12 01:21:08',103,'product_updated'),(440,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-12 01:40:40',112,'user_updated'),(441,'App\\Models\\Order',1018,'{\"cart_id\":16,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-12 12:42\",\"address_id\":20,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":4761,\"updated_at\":\"2025-02-12 07:12:19\",\"created_at\":\"2025-02-12 07:12:19\",\"id\":1018}','2025-02-12 01:42:19',112,'order_created'),(442,'App\\Models\\Product',2,'[]','2025-02-12 01:42:19',112,'product_updated'),(443,'App\\Models\\Product',5,'[]','2025-02-12 01:42:19',112,'product_updated'),(444,'App\\Models\\Order',1018,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"coupon_price\":null}','2025-02-12 01:42:19',112,'order_updated'),(445,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\",\"o_count\":3,\"o_sum\":15277}','2025-02-12 01:42:19',112,'user_updated'),(446,'App\\Models\\Shop',501,'{\"tax\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":1}','2025-02-12 01:44:21',107,'shop_updated'),(447,'App\\Models\\Order',1019,'{\"cart_id\":17,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-12 12:47\",\"address_id\":21,\"delivery_price_id\":4,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9939,\"updated_at\":\"2025-02-12 07:17:58\",\"created_at\":\"2025-02-12 07:17:58\",\"id\":1019}','2025-02-12 01:47:58',112,'order_created'),(448,'App\\Models\\Product',14,'[]','2025-02-12 01:47:58',112,'product_updated'),(449,'App\\Models\\Order',1019,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 01:47:58',112,'order_updated'),(450,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\",\"o_count\":4,\"o_sum\":25251.110000000000582076609134674072265625}','2025-02-12 01:47:58',112,'user_updated'),(451,'App\\Models\\Order',1019,'{\"type\":\"2\",\"status\":\"new\"}','2025-02-12 01:48:38',107,'order_updated'),(452,'App\\Models\\Order',1019,'{\"type\":\"2\",\"status\":\"accepted\"}','2025-02-12 01:48:50',107,'order_updated'),(453,'App\\Models\\Order',1019,'{\"type\":\"2\",\"status\":\"ready\"}','2025-02-12 01:50:57',107,'order_updated'),(454,'App\\Models\\Order',1019,'{\"type\":\"2\",\"status\":\"on_a_way\"}','2025-02-12 01:51:19',107,'order_updated'),(455,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"firebase_token\":null}','2025-02-12 02:03:45',107,'user_updated'),(456,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":2}','2025-02-12 02:06:46',103,'shop_updated'),(457,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2025-02-12 05:47:45\",\"phone_verified_at\":\"2025-02-12 05:47:45\",\"password\":\"$2y$10$rFNDyTsEx0ZDa4q5Y5mVTO8fwmhqTVNSU061Lq2O6.qWB0OPT7D3K\",\"firebase_token\":\"[]\"}','2025-02-12 02:07:31',103,'user_updated'),(458,'App\\Models\\Order',1020,'{\"cart_id\":12,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-12 13:11\",\"address_id\":18,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2730,\"updated_at\":\"2025-02-12 07:41:12\",\"created_at\":\"2025-02-12 07:41:12\",\"id\":1020}','2025-02-12 02:11:12',119,'order_created'),(459,'App\\Models\\Product',3,'[]','2025-02-12 02:11:12',119,'product_updated'),(460,'App\\Models\\Order',1020,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 02:11:12',119,'order_updated'),(461,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"o_count\":1,\"o_sum\":3253}','2025-02-12 02:11:12',119,'user_updated'),(462,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-12 02:28:47',112,'user_updated'),(463,'App\\Models\\User',112,'{\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-12 02:31:23',112,'user_updated'),(464,'App\\Models\\User',112,'{\"birthday\":null,\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-12 02:41:56',112,'user_updated'),(465,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"img\":null,\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-12 02:42:58',112,'user_updated'),(466,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-12 02:46:17',112,'user_updated'),(467,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-12 02:47:23',112,'user_updated'),(468,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/users\\/112-17393479772855.webp\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-12 02:49:10',112,'user_updated'),(469,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/users\\/112-17393483492027.webp\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-12 02:54:06',112,'user_updated'),(470,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-12 06:10:54',112,'user_updated'),(471,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-12 06:22:35',112,'user_updated'),(472,'App\\Models\\Order',1021,'{\"cart_id\":18,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-12 17:23\",\"address_id\":20,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1408,\"updated_at\":\"2025-02-12 11:53:13\",\"created_at\":\"2025-02-12 11:53:13\",\"id\":1021}','2025-02-12 06:23:13',112,'order_created'),(473,'App\\Models\\Product',1,'[]','2025-02-12 06:23:13',112,'product_updated'),(474,'App\\Models\\Product',38,'[]','2025-02-12 06:23:13',112,'product_updated'),(475,'App\\Models\\Order',1021,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 06:23:13',112,'order_updated'),(476,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\",\"o_count\":5,\"o_sum\":26528.110000000000582076609134674072265625}','2025-02-12 06:23:13',112,'user_updated'),(477,'App\\Models\\Order',1022,'{\"cart_id\":20,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-12 17:26\",\"address_id\":8,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2276,\"updated_at\":\"2025-02-12 11:56:13\",\"created_at\":\"2025-02-12 11:56:13\",\"id\":1022}','2025-02-12 06:26:13',112,'order_created'),(478,'App\\Models\\Product',38,'[]','2025-02-12 06:26:14',112,'product_updated'),(479,'App\\Models\\Order',1022,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 06:26:14',112,'order_updated'),(480,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\",\"o_count\":6,\"o_sum\":31906.43999999999869032762944698333740234375}','2025-02-12 06:26:14',112,'user_updated'),(481,'App\\Models\\Order',1021,'{\"type\":\"1\",\"status\":\"new\"}','2025-02-12 06:29:55',103,'order_updated'),(482,'App\\Models\\Order',1021,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-02-12 06:30:33',103,'order_updated'),(483,'App\\Models\\Order',1021,'{\"type\":\"1\",\"status\":\"ready\"}','2025-02-12 06:31:43',103,'order_updated'),(484,'App\\Models\\Order',1021,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-02-12 06:31:59',103,'order_updated'),(485,'App\\Models\\Product',1,'{\"o_count\":7,\"od_count\":7}','2025-02-12 06:33:34',103,'product_updated'),(486,'App\\Models\\Product',38,'{\"o_count\":2,\"od_count\":2}','2025-02-12 06:33:34',103,'product_updated'),(487,'App\\Models\\Order',1023,'{\"cart_id\":21,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-02-13 10:27\",\"address_id\":21,\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5234,\"updated_at\":\"2025-02-13 04:57:27\",\"created_at\":\"2025-02-13 04:57:27\",\"id\":1023}','2025-02-12 23:27:27',112,'order_created'),(488,'App\\Models\\Product',1,'[]','2025-02-12 23:27:27',112,'product_updated'),(489,'App\\Models\\Order',1023,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 23:27:27',112,'order_updated'),(490,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\",\"o_count\":7,\"o_sum\":35264.7699999999967985786497592926025390625}','2025-02-12 23:27:27',112,'user_updated'),(491,'App\\Models\\Order',1024,'{\"cart_id\":22,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-13 10:31\",\"address_id\":20,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2612,\"updated_at\":\"2025-02-13 05:01:05\",\"created_at\":\"2025-02-13 05:01:05\",\"id\":1024}','2025-02-12 23:31:05',112,'order_created'),(492,'App\\Models\\Product',38,'[]','2025-02-12 23:31:05',112,'product_updated'),(493,'App\\Models\\Order',1024,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 23:31:05',112,'order_updated'),(494,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\",\"o_count\":8,\"o_sum\":38286.7699999999967985786497592926025390625}','2025-02-12 23:31:05',112,'user_updated'),(495,'App\\Models\\Order',1025,'{\"cart_id\":23,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-13 10:40\",\"address_id\":18,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8931,\"updated_at\":\"2025-02-13 05:10:23\",\"created_at\":\"2025-02-13 05:10:23\",\"id\":1025}','2025-02-12 23:40:23',119,'order_created'),(496,'App\\Models\\Product',1,'[]','2025-02-12 23:40:23',119,'product_updated'),(497,'App\\Models\\Order',1025,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-12 23:40:23',119,'order_updated'),(498,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"o_count\":2,\"o_sum\":4510}','2025-02-12 23:40:23',119,'user_updated'),(499,'App\\Models\\Order',1022,'{\"type\":\"1\",\"status\":\"new\"}','2025-02-13 00:03:43',103,'order_updated'),(500,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"img\":null}','2025-02-13 00:03:47',119,'user_updated'),(501,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-13 00:06:53',112,'user_updated'),(502,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"firebase_token\":null}','2025-02-13 00:07:37',119,'user_updated'),(503,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/users\\/119-17394248196709.webp\",\"firebase_token\":\"[null,\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-13 00:08:21',119,'user_updated'),(504,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"firebase_token\":\"[null,\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-13 00:12:23',119,'user_updated'),(505,'App\\Models\\User',126,'{\"email\":\"keshavkolle@gmail.com\",\"firstname\":\"keshavkolle@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"85fd8ff4-aed8-4539-b0dc-aea3242cedd4\",\"my_referral\":\"5J3RVQRK\",\"updated_at\":\"2025-02-13 06:15:08\",\"created_at\":\"2025-02-13 06:15:08\",\"id\":126}','2025-02-13 00:45:08',NULL,'user_created'),(506,'App\\Models\\User',126,'{\"uuid\":\"85fd8ff4-aed8-4539-b0dc-aea3242cedd4\"}','2025-02-13 00:45:08',NULL,'user_updated'),(507,'App\\Models\\User',126,'{\"verify_token\":\"427308\"}','2025-02-13 00:46:40',NULL,'user_updated'),(508,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"password\":\"$2y$10$a\\/HEuyfwmToyY2ni9D\\/HyO5xiybE4idSnYmOkqfq\\/jnn9vv1HXmAe\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-13 01:13:56',112,'user_updated'),(509,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-13 01:17:00',112,'user_updated'),(510,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-13 01:17:04',112,'user_updated'),(511,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-13 01:18:10',112,'user_updated'),(512,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"password\":\"$2y$10$33jWunEyumTlzomX6fYid.tDuetcljS5lencFCv6AK5pRu0ri5Aey\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-13 01:18:28',112,'user_updated'),(513,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"dmvz_b_rRSqzWGfsU3ltBK:APA91bFHTqr6KqJAc2-5w-acmYigMKCKAjufUhNZ5mwNzlTeRQRhaMJ7x5H39JbFebwjeXv-Ceb6zEevf6A51RcHhPCSbsvaLkjfyGSBxzm2ElZ4X2L6tVs\\\"]\"}','2025-02-13 01:18:49',112,'user_updated'),(514,'App\\Models\\Product',40,'{\"uuid\":\"38f15eb1-3013-4d82-b7d2-61416f56f94b\"}','2025-02-13 01:35:42',103,'product_updated'),(515,'App\\Models\\Product',40,'{\"uuid\":\"38f15eb1-3013-4d82-b7d2-61416f56f94b\"}','2025-02-13 01:35:42',103,'product_updated'),(516,'App\\Models\\Product',40,'{\"min_price\":0,\"max_price\":0}','2025-02-13 01:36:35',103,'product_updated'),(517,'App\\Models\\Product',40,'{\"status\":\"pending\",\"status_note\":null}','2025-02-13 01:37:25',103,'product_updated'),(518,'App\\Models\\User',127,'{\"email\":\"sunilkumarshetty@gmail.com\",\"firstname\":\"sunilkumarshetty@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"144c5bc4-bb8e-4b2a-a2eb-20834683457b\",\"my_referral\":\"XJEUQWSK\",\"updated_at\":\"2025-02-13 07:28:10\",\"created_at\":\"2025-02-13 07:28:10\",\"id\":127}','2025-02-13 01:58:10',NULL,'user_created'),(519,'App\\Models\\User',127,'{\"uuid\":\"144c5bc4-bb8e-4b2a-a2eb-20834683457b\"}','2025-02-13 01:58:10',NULL,'user_updated'),(520,'App\\Models\\User',128,'{\"email\":\"sunilsheetty004@gmail.com\",\"firstname\":\"sunilsheetty004@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"67a24067-246c-485e-904b-ed10b93d4af6\",\"my_referral\":\"PJDY7M2Z\",\"updated_at\":\"2025-02-13 07:54:14\",\"created_at\":\"2025-02-13 07:54:14\",\"id\":128}','2025-02-13 02:24:14',NULL,'user_created'),(521,'App\\Models\\User',128,'{\"uuid\":\"67a24067-246c-485e-904b-ed10b93d4af6\"}','2025-02-13 02:24:14',NULL,'user_updated'),(522,'App\\Models\\User',129,'{\"email\":\"sunilshedetty004@gmail.com\",\"firstname\":\"sunilshedetty004@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"912c7959-a179-4554-bcbb-8bd5c65ab701\",\"my_referral\":\"FIUKFNKZ\",\"updated_at\":\"2025-02-13 07:55:39\",\"created_at\":\"2025-02-13 07:55:39\",\"id\":129}','2025-02-13 02:25:39',NULL,'user_created'),(523,'App\\Models\\User',129,'{\"uuid\":\"912c7959-a179-4554-bcbb-8bd5c65ab701\"}','2025-02-13 02:25:40',NULL,'user_updated'),(524,'App\\Models\\User',128,'{\"verify_token\":\"433254\"}','2025-02-13 02:32:04',NULL,'user_updated'),(525,'App\\Models\\User',128,'{\"verify_token\":\"433724\"}','2025-02-13 02:37:37',NULL,'user_updated'),(526,'App\\Models\\User',128,'{\"verify_token\":\"434057\"}','2025-02-13 02:55:31',NULL,'user_updated'),(527,'App\\Models\\User',128,'{\"verify_token\":\"435131\"}','2025-02-13 02:56:03',NULL,'user_updated'),(528,'App\\Models\\User',128,'{\"verify_token\":\"435163\"}','2025-02-13 03:24:59',NULL,'user_updated'),(529,'App\\Models\\User',128,'{\"verify_token\":\"436899\"}','2025-02-13 03:51:11',NULL,'user_updated'),(530,'App\\Models\\User',130,'{\"email\":\"anuppligade@gmai.com\",\"firstname\":\"anuppligade@gmai.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"0945e6da-4032-4664-8c3f-2deb9015ae5d\",\"my_referral\":\"XOM7UPYP\",\"updated_at\":\"2025-02-13 09:32:14\",\"created_at\":\"2025-02-13 09:32:14\",\"id\":130}','2025-02-13 04:02:14',NULL,'user_created'),(531,'App\\Models\\User',130,'{\"uuid\":\"0945e6da-4032-4664-8c3f-2deb9015ae5d\"}','2025-02-13 04:02:14',NULL,'user_updated'),(532,'App\\Models\\Order',1026,'{\"cart_id\":24,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-13 15:29\",\"address_id\":18,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8874,\"updated_at\":\"2025-02-13 09:59:30\",\"created_at\":\"2025-02-13 09:59:30\",\"id\":1026}','2025-02-13 04:29:30',119,'order_created'),(533,'App\\Models\\Product',2,'[]','2025-02-13 04:29:30',119,'product_updated'),(534,'App\\Models\\Order',1026,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-13 04:29:30',119,'order_updated'),(535,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"firebase_token\":\"[]\",\"o_count\":3,\"o_sum\":7532}','2025-02-13 04:29:30',119,'user_updated'),(536,'App\\Models\\Order',1026,'{\"type\":\"1\",\"status\":\"new\"}','2025-02-13 04:30:26',119,'order_updated'),(537,'App\\Models\\Order',1027,'{\"cart_id\":25,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-13 15:35\",\"address_id\":26,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5560,\"updated_at\":\"2025-02-13 10:06:00\",\"created_at\":\"2025-02-13 10:06:00\",\"id\":1027}','2025-02-13 04:36:00',119,'order_created'),(538,'App\\Models\\Product',40,'[]','2025-02-13 04:36:00',119,'product_updated'),(539,'App\\Models\\Order',1027,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-13 04:36:00',119,'order_updated'),(540,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"firebase_token\":\"[]\",\"o_count\":4,\"o_sum\":9656.110000000000582076609134674072265625}','2025-02-13 04:36:00',119,'user_updated'),(541,'App\\Models\\User',128,'{\"verify_token\":\"438471\"}','2025-02-13 04:41:04',NULL,'user_updated'),(542,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$qR1uHMmvvT32ljRkhEz0QeGEUZQpTa0GnxqFSoSImkFNBy6WMeROq\",\"firebase_token\":\"[]\"}','2025-02-13 04:42:29',119,'user_updated'),(543,'App\\Models\\User',131,'{\"email\":\"yashbharadwajk@gmail.com\",\"firstname\":\"yashbharadwajk@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"635e3cb8-a3ac-40d3-a8a0-9feeeaa819e1\",\"my_referral\":\"MA5HFXMT\",\"updated_at\":\"2025-02-14 05:26:57\",\"created_at\":\"2025-02-14 05:26:57\",\"id\":131}','2025-02-13 23:56:57',NULL,'user_created'),(544,'App\\Models\\User',131,'{\"uuid\":\"635e3cb8-a3ac-40d3-a8a0-9feeeaa819e1\"}','2025-02-13 23:56:57',NULL,'user_updated'),(545,'App\\Models\\User',131,'{\"verify_token\":\"510817\"}','2025-02-14 00:09:25',NULL,'user_updated'),(546,'App\\Models\\User',132,'{\"email\":\"anupp@gmail.com\",\"firstname\":\"anupp@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"fd92c3f1-7a49-47a1-b0a2-d598d8a40bb5\",\"my_referral\":\"7CGOEQMU\",\"updated_at\":\"2025-02-14 05:50:49\",\"created_at\":\"2025-02-14 05:50:49\",\"id\":132}','2025-02-14 00:20:49',NULL,'user_created'),(547,'App\\Models\\User',132,'{\"uuid\":\"fd92c3f1-7a49-47a1-b0a2-d598d8a40bb5\"}','2025-02-14 00:20:49',NULL,'user_updated'),(548,'App\\Models\\User',133,'{\"email\":\"anuppligadese@gmail.com\",\"firstname\":\"anuppligadese@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"809b2d5d-b3d1-4114-9eeb-860e68ca6403\",\"my_referral\":\"JOGIS1SQ\",\"updated_at\":\"2025-02-14 06:37:46\",\"created_at\":\"2025-02-14 06:37:46\",\"id\":133}','2025-02-14 01:07:46',NULL,'user_created'),(549,'App\\Models\\User',133,'{\"uuid\":\"809b2d5d-b3d1-4114-9eeb-860e68ca6403\"}','2025-02-14 01:07:46',NULL,'user_updated'),(550,'App\\Models\\User',131,'{\"verify_token\":\"511565\"}','2025-02-14 01:08:54',NULL,'user_updated'),(551,'App\\Models\\User',131,'{\"email_verified_at\":null}','2025-02-14 01:09:29',NULL,'user_updated'),(552,'App\\Models\\User',131,'{\"password\":null}','2025-02-14 01:12:54',131,'user_updated'),(553,'App\\Models\\User',134,'{\"email\":\"anups@gmail.com\",\"firstname\":\"anups@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"005fb5b5-3fe2-4ac2-8f9d-f8b0ec02b189\",\"my_referral\":\"DQAFJ7RO\",\"updated_at\":\"2025-02-14 07:39:58\",\"created_at\":\"2025-02-14 07:39:58\",\"id\":134}','2025-02-14 02:09:58',NULL,'user_created'),(554,'App\\Models\\User',134,'{\"uuid\":\"005fb5b5-3fe2-4ac2-8f9d-f8b0ec02b189\"}','2025-02-14 02:09:58',NULL,'user_updated'),(555,'App\\Models\\User',135,'{\"email\":\"anup@gmail.com\",\"firstname\":\"anup@gmail.com\",\"ip_address\":\"122.177.120.10\",\"uuid\":\"ec19ef11-db65-434c-ba86-2829c845950e\",\"my_referral\":\"MVLZ6AKQ\",\"updated_at\":\"2025-02-14 07:44:33\",\"created_at\":\"2025-02-14 07:44:33\",\"id\":135}','2025-02-14 02:14:33',NULL,'user_created'),(556,'App\\Models\\User',135,'{\"uuid\":\"ec19ef11-db65-434c-ba86-2829c845950e\"}','2025-02-14 02:14:33',NULL,'user_updated'),(557,'App\\Models\\User',135,'{\"ip_address\":\"122.177.120.10\"}','2025-02-17 00:54:04',NULL,'user_updated'),(558,'App\\Models\\User',135,'{\"verify_token\":\"519073\"}','2025-02-17 00:54:04',NULL,'user_updated'),(559,'App\\Models\\User',136,'{\"email\":\"anuppligadess@gmail.com\",\"firstname\":\"anuppligadess@gmail.com\",\"ip_address\":\"106.214.52.199\",\"uuid\":\"c471385b-32d4-4ff7-9f04-b3b33005193b\",\"my_referral\":\"U0YZAZRQ\",\"updated_at\":\"2025-02-17 07:04:03\",\"created_at\":\"2025-02-17 07:04:03\",\"id\":136}','2025-02-17 01:34:03',NULL,'user_created'),(560,'App\\Models\\User',136,'{\"uuid\":\"c471385b-32d4-4ff7-9f04-b3b33005193b\"}','2025-02-17 01:34:04',NULL,'user_updated'),(561,'App\\Models\\User',137,'{\"email\":\"anuppligades@gmail.com\",\"firstname\":\"anuppligades@gmail.com\",\"ip_address\":\"106.214.52.199\",\"uuid\":\"c059f800-207a-4eac-b068-cb8a0b0811da\",\"my_referral\":\"ABQKSHZY\",\"updated_at\":\"2025-02-17 07:07:46\",\"created_at\":\"2025-02-17 07:07:46\",\"id\":137}','2025-02-17 01:37:46',NULL,'user_created'),(562,'App\\Models\\User',137,'{\"uuid\":\"c059f800-207a-4eac-b068-cb8a0b0811da\"}','2025-02-17 01:37:46',NULL,'user_updated'),(563,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-17 02:19:30',112,'user_updated'),(564,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"password\":\"$2y$10$zZPQ9tRsBh5UqRwUR2Tljuh0EZT0wFkKVzGftxCRnk82noB7\\/5OLG\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"eiRaXnp-QxCoOBMeFWV--9:APA91bG2ofiIuzPEh_W445tm_BI0hFlcYlHMBvIXvLCiq5bm_h8kRJfxLX01kHys1CUf4IobTnFsbpU6M5n2mZlgQ8D9r-UmHa_rR3wwc5IFgRB-wz334sk\\\"]\"}','2025-02-17 02:19:48',112,'user_updated'),(565,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"eiRaXnp-QxCoOBMeFWV--9:APA91bG2ofiIuzPEh_W445tm_BI0hFlcYlHMBvIXvLCiq5bm_h8kRJfxLX01kHys1CUf4IobTnFsbpU6M5n2mZlgQ8D9r-UmHa_rR3wwc5IFgRB-wz334sk\\\"]\"}','2025-02-17 04:16:07',112,'user_updated'),(566,'App\\Models\\Order',1028,'{\"cart_id\":26,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-17 15:49\",\"address_id\":27,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9414,\"updated_at\":\"2025-02-17 10:19:08\",\"created_at\":\"2025-02-17 10:19:08\",\"id\":1028}','2025-02-17 04:49:08',119,'order_created'),(567,'App\\Models\\Product',2,'[]','2025-02-17 04:49:08',119,'product_updated'),(568,'App\\Models\\Product',3,'[]','2025-02-17 04:49:08',119,'product_updated'),(569,'App\\Models\\Order',1028,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-17 04:49:08',119,'order_updated'),(570,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"firebase_token\":\"[]\",\"o_count\":5,\"o_sum\":10809.610000000000582076609134674072265625}','2025-02-17 04:49:08',119,'user_updated'),(571,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-17 05:09:19',112,'user_updated'),(572,'App\\Models\\Order',1029,'{\"cart_id\":28,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-02-17 16:10\",\"address_id\":21,\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8299,\"updated_at\":\"2025-02-17 10:40:54\",\"created_at\":\"2025-02-17 10:40:54\",\"id\":1029}','2025-02-17 05:10:54',112,'order_created'),(573,'App\\Models\\Product',2,'[]','2025-02-17 05:10:54',112,'product_updated'),(574,'App\\Models\\Product',1,'[]','2025-02-17 05:10:54',112,'product_updated'),(575,'App\\Models\\Product',38,'[]','2025-02-17 05:10:54',112,'product_updated'),(576,'App\\Models\\Product',40,'[]','2025-02-17 05:10:54',112,'product_updated'),(577,'App\\Models\\Product',28,'[]','2025-02-17 05:10:54',112,'product_updated'),(578,'App\\Models\\Product',14,'[]','2025-02-17 05:10:54',112,'product_updated'),(579,'App\\Models\\Order',1029,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-17 05:10:54',112,'order_updated'),(580,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\",\"o_count\":9,\"o_sum\":41645.0999999999985448084771633148193359375}','2025-02-17 05:10:54',112,'user_updated'),(581,'App\\Models\\Shop',501,'{\"tax\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":1}','2025-02-17 05:18:12',107,'shop_updated'),(582,'App\\Models\\Order',1030,'{\"cart_id\":29,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-17 16:23\",\"address_id\":28,\"delivery_price_id\":4,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1253,\"updated_at\":\"2025-02-17 10:53:49\",\"created_at\":\"2025-02-17 10:53:49\",\"id\":1030}','2025-02-17 05:23:49',112,'order_created'),(583,'App\\Models\\Product',5,'[]','2025-02-17 05:23:49',112,'product_updated'),(584,'App\\Models\\Order',1030,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-17 05:23:49',112,'order_updated'),(585,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\",\"o_count\":10,\"o_sum\":48803.0400000000008731149137020111083984375}','2025-02-17 05:23:49',112,'user_updated'),(586,'App\\Models\\Category',1,'{\"slug\":\"main-1\",\"input\":\"11\",\"active\":\"1\"}','2025-02-17 05:35:27',103,'category_updated'),(587,'App\\Models\\Category',16,'{\"keywords\":\"Innerwear\",\"parent_id\":\"5\",\"type\":2,\"active\":\"1\",\"input\":\"20\",\"uuid\":\"c5e1b8c8-9428-4841-9193-9095e6542199\",\"updated_at\":\"2025-02-17 11:12:56\",\"created_at\":\"2025-02-17 11:12:56\",\"id\":16}','2025-02-17 05:42:56',103,'category_created'),(588,'App\\Models\\Category',16,'{\"active\":\"1\",\"input\":\"20\",\"uuid\":\"c5e1b8c8-9428-4841-9193-9095e6542199\"}','2025-02-17 05:42:56',103,'category_updated'),(589,'App\\Models\\Category',16,'{\"active\":\"1\",\"input\":\"20\",\"uuid\":\"c5e1b8c8-9428-4841-9193-9095e6542199\"}','2025-02-17 05:42:56',103,'category_updated'),(590,'App\\Models\\User',137,'{\"verify_token\":\"776066\"}','2025-02-17 05:45:25',NULL,'user_updated'),(591,'App\\Models\\User',137,'{\"verify_token\":\"790925\"}','2025-02-17 05:45:33',NULL,'user_updated'),(592,'App\\Models\\User',135,'{\"verify_token\":\"773444\"}','2025-02-17 05:46:03',NULL,'user_updated'),(593,'App\\Models\\User',135,'{\"verify_token\":\"790963\"}','2025-02-17 05:46:13',NULL,'user_updated'),(594,'App\\Models\\User',135,'{\"verify_token\":\"790973\"}','2025-02-17 05:46:19',NULL,'user_updated'),(595,'App\\Models\\Brand',1,'{\"slug\":\"iphone-0\",\"title\":\"iphone\"}','2025-02-17 05:46:39',103,'brand_updated'),(596,'App\\Models\\Brand',1,'{\"active\":\"1\",\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/brands\\/103-17387452602688.webp\"}','2025-02-17 05:46:39',103,'brand_updated'),(597,'App\\Models\\User',137,'{\"verify_token\":\"790933\"}','2025-02-17 05:47:34',NULL,'user_updated'),(598,'App\\Models\\User',137,'{\"verify_token\":\"791054\"}','2025-02-17 05:50:00',NULL,'user_updated'),(599,'App\\Models\\Product',41,'{\"uuid\":\"d521732e-9add-418a-a849-550f22e268b8\"}','2025-02-17 05:50:33',103,'product_updated'),(600,'App\\Models\\Product',41,'{\"uuid\":\"d521732e-9add-418a-a849-550f22e268b8\"}','2025-02-17 05:50:34',103,'product_updated'),(601,'App\\Models\\Product',41,'{\"min_price\":0,\"max_price\":0}','2025-02-17 05:52:17',103,'product_updated'),(602,'App\\Models\\User',137,'{\"verify_token\":\"791200\"}','2025-02-17 05:52:56',NULL,'user_updated'),(603,'App\\Models\\Product',41,'{\"status\":\"pending\",\"status_note\":null}','2025-02-17 05:54:00',103,'product_updated'),(604,'App\\Models\\User',137,'{\"verify_token\":\"791376\"}','2025-02-17 05:57:08',NULL,'user_updated'),(605,'App\\Models\\Product',41,'{\"min_price\":125}','2025-02-17 06:00:08',103,'product_updated'),(606,'App\\Models\\Order',1031,'{\"cart_id\":30,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-17 17:08\",\"address_id\":28,\"delivery_price_id\":4,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9522,\"updated_at\":\"2025-02-17 11:38:50\",\"created_at\":\"2025-02-17 11:38:50\",\"id\":1031}','2025-02-17 06:08:50',112,'order_created'),(607,'App\\Models\\Product',41,'[]','2025-02-17 06:08:50',112,'product_updated'),(608,'App\\Models\\Order',1031,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1,\"coupon_price\":null}','2025-02-17 06:08:50',112,'order_updated'),(609,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\",\"o_count\":9,\"o_sum\":51193.7099999999991268850862979888916015625}','2025-02-17 06:08:50',112,'user_updated'),(610,'App\\Models\\Category',16,'{\"status\":\"pending\"}','2025-02-17 06:10:22',103,'category_updated'),(611,'App\\Models\\Category',10,'[]','2025-02-17 06:10:37',103,'category_deleted'),(612,'App\\Models\\Category',11,'[]','2025-02-17 06:10:37',103,'category_deleted'),(613,'App\\Models\\Category',14,'[]','2025-02-17 06:10:37',103,'category_deleted'),(614,'App\\Models\\Category',12,'{\"status\":\"published\"}','2025-02-17 06:11:27',103,'category_updated'),(615,'App\\Models\\Order',1032,'{\"cart_id\":31,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-17 17:12\",\"address_id\":28,\"delivery_price_id\":4,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2953,\"updated_at\":\"2025-02-17 11:42:58\",\"created_at\":\"2025-02-17 11:42:58\",\"id\":1032}','2025-02-17 06:12:58',112,'order_created'),(616,'App\\Models\\Product',41,'[]','2025-02-17 06:12:58',112,'product_updated'),(617,'App\\Models\\Order',1032,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-17 06:12:58',112,'order_updated'),(618,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\",\"o_count\":10,\"o_sum\":52247.2099999999991268850862979888916015625}','2025-02-17 06:12:58',112,'user_updated'),(619,'App\\Models\\User',137,'{\"verify_token\":\"791628\"}','2025-02-17 06:19:25',NULL,'user_updated'),(620,'App\\Models\\Category',1,'{\"input\":\"11\",\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/categories\\/103-17393423282984.webp\",\"active\":\"1\"}','2025-02-17 06:20:13',103,'category_updated'),(621,'App\\Models\\Category',15,'{\"keywords\":\"Suits,suits\"}','2025-02-17 06:22:11',103,'category_updated'),(622,'App\\Models\\Category',15,'{\"slug\":\"suits-15\",\"input\":\"11\",\"active\":\"1\"}','2025-02-17 06:22:11',103,'category_updated'),(623,'App\\Models\\Category',15,'{\"input\":\"11\",\"img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/categories\\/103-17387446294179.webp\",\"active\":\"1\"}','2025-02-17 06:22:11',103,'category_updated'),(624,'App\\Models\\Category',9,'{\"input\":null}','2025-02-17 06:23:25',103,'category_updated'),(625,'App\\Models\\User',137,'{\"verify_token\":\"792965\"}','2025-02-17 06:24:16',NULL,'user_updated'),(626,'App\\Models\\Product',26,'[]','2025-02-17 06:25:31',103,'product_deleted'),(627,'App\\Models\\Product',27,'[]','2025-02-17 06:25:31',103,'product_deleted'),(628,'App\\Models\\Product',28,'[]','2025-02-17 06:25:31',103,'product_deleted'),(629,'App\\Models\\Product',34,'[]','2025-02-17 06:25:31',103,'product_deleted'),(630,'App\\Models\\Product',35,'[]','2025-02-17 06:25:31',103,'product_deleted'),(631,'App\\Models\\Product',36,'[]','2025-02-17 06:25:31',103,'product_deleted'),(632,'App\\Models\\Product',37,'[]','2025-02-17 06:25:31',103,'product_deleted'),(633,'App\\Models\\Product',38,'[]','2025-02-17 06:25:31',103,'product_deleted'),(634,'App\\Models\\Product',40,'[]','2025-02-17 06:25:31',103,'product_deleted'),(635,'App\\Models\\Product',9,'[]','2025-02-17 06:25:49',103,'product_deleted'),(636,'App\\Models\\Product',10,'[]','2025-02-17 06:25:49',103,'product_deleted'),(637,'App\\Models\\Product',11,'[]','2025-02-17 06:25:49',103,'product_deleted'),(638,'App\\Models\\Product',14,'[]','2025-02-17 06:25:49',103,'product_deleted'),(639,'App\\Models\\Product',15,'[]','2025-02-17 06:25:49',103,'product_deleted'),(640,'App\\Models\\Product',16,'[]','2025-02-17 06:25:49',103,'product_deleted'),(641,'App\\Models\\Product',17,'[]','2025-02-17 06:25:49',103,'product_deleted'),(642,'App\\Models\\Product',18,'[]','2025-02-17 06:25:49',103,'product_deleted'),(643,'App\\Models\\Product',25,'[]','2025-02-17 06:25:49',103,'product_deleted'),(644,'App\\Models\\User',137,'{\"verify_token\":\"793256\"}','2025-02-17 06:31:54',NULL,'user_updated'),(645,'App\\Models\\Order',1033,'{\"cart_id\":32,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-17 18:18\",\"address_id\":28,\"delivery_price_id\":4,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2538,\"updated_at\":\"2025-02-17 12:48:41\",\"created_at\":\"2025-02-17 12:48:41\",\"id\":1033}','2025-02-17 07:18:41',112,'order_created'),(646,'App\\Models\\Product',41,'[]','2025-02-17 07:18:41',112,'product_updated'),(647,'App\\Models\\Product',41,'{\"o_count\":1,\"od_count\":1}','2025-02-17 07:18:41',112,'product_updated'),(648,'App\\Models\\Order',1033,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-17 07:18:41',112,'order_updated'),(649,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\",\"o_count\":11,\"o_sum\":53400.7099999999991268850862979888916015625}','2025-02-17 07:18:41',112,'user_updated'),(650,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\"}','2025-02-17 07:44:37',112,'user_updated'),(651,'App\\Models\\User',137,'{\"verify_token\":\"793714\"}','2025-02-17 23:28:55',NULL,'user_updated'),(652,'App\\Models\\User',137,'{\"verify_token\":\"854735\"}','2025-02-17 23:46:17',NULL,'user_updated'),(653,'App\\Models\\User',137,'{\"verify_token\":\"855777\"}','2025-02-18 00:48:11',NULL,'user_updated'),(654,'App\\Models\\User',137,'{\"verify_token\":\"859491\"}','2025-02-18 03:50:32',NULL,'user_updated'),(655,'App\\Models\\User',137,'{\"verify_token\":\"870432\"}','2025-02-18 04:05:00',NULL,'user_updated'),(656,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-02-18 04:41:32',112,'user_updated'),(657,'App\\Models\\Order',1034,'{\"cart_id\":35,\"shop_id\":501,\"user_id\":112,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-02-20 14:16\",\"address_id\":28,\"delivery_price_id\":4,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":6578,\"updated_at\":\"2025-02-20 08:46:50\",\"created_at\":\"2025-02-20 08:46:50\",\"id\":1034}','2025-02-20 03:16:50',112,'order_created'),(658,'App\\Models\\Product',41,'[]','2025-02-20 03:16:50',112,'product_updated'),(659,'App\\Models\\Order',1034,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-02-20 03:16:50',112,'order_updated'),(660,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\",\"o_count\":12,\"o_sum\":54705.7099999999991268850862979888916015625}','2025-02-20 03:16:50',112,'user_updated'),(661,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"caoEQ1CtQp-GL_qbkBzCp6:APA91bGjH2-zFKKMVg2t9YOOPt0S1DDisP3ku3CbEgnHVQct3q_6ew_JS_846_s2PxLIJCzqXe_sPvhsbAb2n483M55HStb498qpZb-Ulf-laIyIqZ56dx8\\\"]\"}','2025-02-20 03:18:38',112,'user_updated'),(662,'App\\Models\\User',138,'{\"phone\":\"9741374744\",\"email\":\"sunilshetty0080@gmail.com\",\"referral\":null,\"active\":1,\"phone_verified_at\":\"2025-02-28T10:48:13.498247Z\",\"firstname\":\"sunil\",\"lastname\":\"shetty004\",\"gender\":\"male\",\"password\":\"$2y$10$jTXlngn79of94ZJrIACFwOe\\/D0tDC0k.gwxLdcLQUVZbN6HM5glTy\",\"uuid\":\"a10db321-c2b1-4250-b9a7-4919aa379f99\",\"my_referral\":\"EFHAXH0Z\",\"updated_at\":\"2025-02-28 10:48:13\",\"created_at\":\"2025-02-28 10:48:13\",\"id\":138}','2025-02-28 05:18:13',NULL,'user_created'),(663,'App\\Models\\User',138,'{\"firebase_token\":null}','2025-02-28 05:19:55',138,'user_updated'),(664,'App\\Models\\User',138,'{\"firebase_token\":\"[null,\\\"eWUZFUz2Qt6uWMszIKaj0h:APA91bGqTlZwLmMXmlekyxN_-GtWOVhaQa6NtpZzVBZjLFHMuOBo7OY8T4UR2k98DhhbOLzlj_tURU_vLX3JQhYCsIqWALmTrqNrWOEdBVa7WdhI2WuAPww\\\"]\"}','2025-02-28 05:20:05',138,'user_updated'),(665,'App\\Models\\User',139,'{\"email\":\"akshaykgowda0011@gmail.com\",\"firstname\":\"akshaykgowda0011@gmail.com\",\"ip_address\":\"182.65.72.67\",\"uuid\":\"3fb820d2-0042-4361-aaa9-cb97365b2736\",\"my_referral\":\"S20P79OJ\",\"updated_at\":\"2025-02-28 10:53:28\",\"created_at\":\"2025-02-28 10:53:28\",\"id\":139}','2025-02-28 05:23:28',NULL,'user_created'),(666,'App\\Models\\User',139,'{\"uuid\":\"3fb820d2-0042-4361-aaa9-cb97365b2736\"}','2025-02-28 05:23:28',NULL,'user_updated'),(667,'App\\Models\\User',139,'{\"email_verified_at\":null}','2025-02-28 05:24:08',NULL,'user_updated'),(668,'App\\Models\\User',139,'{\"firstname\":\"akshaykgowda0011@gmail.com\",\"lastname\":null,\"phone\":null,\"password\":null}','2025-02-28 05:24:47',139,'user_updated'),(669,'App\\Models\\User',139,'{\"firebase_token\":null}','2025-02-28 05:24:49',139,'user_updated'),(670,'App\\Models\\User',139,'{\"firebase_token\":\"[null,\\\"eWUZFUz2Qt6uWMszIKaj0h:APA91bGqTlZwLmMXmlekyxN_-GtWOVhaQa6NtpZzVBZjLFHMuOBo7OY8T4UR2k98DhhbOLzlj_tURU_vLX3JQhYCsIqWALmTrqNrWOEdBVa7WdhI2WuAPww\\\"]\"}','2025-02-28 05:26:37',139,'user_updated'),(671,'App\\Models\\User',138,'{\"password\":\"$2y$10$jTXlngn79of94ZJrIACFwOe\\/D0tDC0k.gwxLdcLQUVZbN6HM5glTy\",\"firebase_token\":\"[]\"}','2025-03-03 02:18:39',NULL,'user_updated'),(672,'App\\Models\\User',138,'{\"firebase_token\":\"[]\"}','2025-03-03 02:18:44',138,'user_updated'),(673,'App\\Models\\User',138,'{\"firebase_token\":\"[\\\"fAMrFFFHQyWLNOGCJv5HOy:APA91bEAF1Otut2e54ob03nzJM30E-gOD22aMXid3SG3I2BleWEU8qjsJiO9k0Z1icl6fLG3aGe8kG-0Yrx_qet0RWXK0NpYpEXNgu1Wu30CTphKbLUJ9P0\\\"]\"}','2025-03-03 02:19:47',138,'user_updated'),(674,'App\\Models\\User',138,'{\"firebase_token\":\"[]\"}','2025-03-03 02:20:15',138,'user_updated'),(675,'App\\Models\\User',138,'{\"firebase_token\":\"[\\\"fAMrFFFHQyWLNOGCJv5HOy:APA91bEAF1Otut2e54ob03nzJM30E-gOD22aMXid3SG3I2BleWEU8qjsJiO9k0Z1icl6fLG3aGe8kG-0Yrx_qet0RWXK0NpYpEXNgu1Wu30CTphKbLUJ9P0\\\"]\"}','2025-03-03 02:20:24',138,'user_updated'),(676,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\"]\"}','2025-03-03 03:45:05',112,'user_updated'),(677,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"password\":\"$2y$10$c3MWB4RHnGgwXUgsxaQL3OI9SdvU.VF5E6Y03JwDq1odk7ZrW2diO\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"fAMrFFFHQyWLNOGCJv5HOy:APA91bEAF1Otut2e54ob03nzJM30E-gOD22aMXid3SG3I2BleWEU8qjsJiO9k0Z1icl6fLG3aGe8kG-0Yrx_qet0RWXK0NpYpEXNgu1Wu30CTphKbLUJ9P0\\\"]\"}','2025-03-03 03:45:20',112,'user_updated'),(678,'App\\Models\\User',112,'{\"birthday\":\"2025-02-12\",\"firebase_token\":\"[\\\"dEZioxkGRXOa1BbGBKIu24:APA91bGO4PYL3MRboEGRFSsS2R8OegmUep0XW0oK-HNlkXrkDAI_ECSquJ3_T29o2CVZwRFxxPTAqHLZnczAhEfZjzMkowuuHx5yUnNZedZ50u4rwTc2s3A\\\",\\\"fTTMXNH7QE-KbBNFOtWCwJ:APA91bH3-HiWdxxZvlQKWa0615CmIdB1ExFhEhXkmSSFg-IgKX_kD0t7R3zlBENZoCFUkAEraTT65NOLjRpBKTx8m0NU1mibR-Lcq5EIVUaoVBo0yzWWwX0\\\",\\\"fss36m_UTzKfebXUSnlQDb:APA91bF_XGJiphGt6n3MED2N7J0dEo-clFA8WAnxPURT_cohd7T2cj-7_SoXXG9_vquQ5l4Jk6RlwOiWGgRgdW1lb4Dfb7b1BySPDlxTzREanFEK-8TiTy4\\\",\\\"ckhFw5sNTQOrCJ-hn-GN_r:APA91bEY_fNM7aX9OIRSFijGcDGG2QDKwoutGxDVHjoZpsU5JKXj4q0nRryWakQWm-Xr0nvuUVkHiFHIuFigre3VFRxeo7D1p1-o0StSPmFy_n0iFbuQyuU\\\",\\\"eGlnQwF7SRSplyunJ2E6TX:APA91bG8e2dNHUNE0pxYamc-m2fv8YQ2OKXLSIKhdHPjsoUxEuRrSFBCaxQMgV1BYtw3XE9_oyxV2Ja2KgebA_AqBo_ejZkGe_M-bgXjBJDTe2dwVe3p0c8\\\",\\\"eMTA2BxLSQi3CWq_QU66Uo:APA91bHhjmY7mn5VHJ2hTdstiqHtEH0su9Ju_V19C_WsZ1v2ouDVSnkr4SAk2UVBFHncx1gPu3l_Kwh-TlF3l4wNu_nXaURm7DPAD9Q-WesgCaskshS1BCs\\\",\\\"dSvbRZtSRHSz_7Dqfz5BUy:APA91bFQs9aTUfdnadeARK-ShY_lS5LzahWobNS4y22dw01Yg3f0OwkUogEzqTI38bQOEVdbBdtK1W_2oi6H5nCAvpkz8jJ3X1vT0TmyZFnrAnaHrkh12Ss\\\",\\\"efAT935URqG1thUOTPcpVR:APA91bEOmcleNq7rWNqcTqerwFbZlaXpz41wz-0ldDVNqbl0OXh9XAgB9ePRzv2PENl-JeHbPuucVrsFOeATPIaRWYfupIoM2jj68JWmYKhnBkIWPTV2Yt8\\\",\\\"f01VHBPgRne4vi19XWihx1:APA91bFb01sZ9BDCwvXQUrtAhTE9_XMMVDmWCtPKsywsAntW7FrQ1KgwRkDKRvoeuJjJACGevV54946EciqYcRtycVcUBRSuRUO--Ipcp2i9yrFdjZqy5A4\\\",\\\"dDauxpa9QEiQhi36hx1tBs:APA91bFCV1Til6k5okUD9Er8nBW8FicPYjJQskhzIIHdL-LG0zaOmt8ABnZrJwRQIAGulwWQCKhYhVhYLFinIPxFMhsXdomx6krd3qgr3LjZXJ69Th3c378\\\",\\\"fNG2P56hQNS-2MgVjqb0mq:APA91bHneMTqWhaRGYthwCk1ea0Wt6xN4zFq367pPDHmlQi9p3PxZa9K3sCqQgU_F-kMcNebm1eRLOxYyASrNIFTaujtHO7BV8V3jZ_mSnJ17viKdsK6XkU\\\",\\\"fAMrFFFHQyWLNOGCJv5HOy:APA91bEAF1Otut2e54ob03nzJM30E-gOD22aMXid3SG3I2BleWEU8qjsJiO9k0Z1icl6fLG3aGe8kG-0Yrx_qet0RWXK0NpYpEXNgu1Wu30CTphKbLUJ9P0\\\"]\"}','2025-03-03 03:55:14',112,'user_updated'),(679,'App\\Models\\User',135,'{\"ip_address\":\"106.214.52.199\"}','2025-03-03 04:03:30',NULL,'user_updated'),(680,'App\\Models\\User',135,'{\"verify_token\":\"790979\"}','2025-03-03 04:03:30',NULL,'user_updated'),(681,'App\\Models\\User',137,'{\"ip_address\":\"106.214.52.199\"}','2025-03-03 06:15:08',NULL,'user_updated'),(682,'App\\Models\\User',137,'{\"verify_token\":\"871300\"}','2025-03-03 06:15:08',NULL,'user_updated'),(683,'App\\Models\\User',137,'{\"verify_token\":\"002308\"}','2025-03-03 06:18:12',NULL,'user_updated'),(684,'App\\Models\\User',140,'{\"email\":\"anuppligadse@gmail.com\",\"firstname\":\"anuppligadse@gmail.com\",\"ip_address\":\"223.190.230.106\",\"uuid\":\"26d585dc-e462-4c04-8c1a-ddf9f6a35467\",\"my_referral\":\"HQKVVLRV\",\"updated_at\":\"2025-03-03 11:56:23\",\"created_at\":\"2025-03-03 11:56:23\",\"id\":140}','2025-03-03 06:26:23',NULL,'user_created'),(685,'App\\Models\\User',140,'{\"uuid\":\"26d585dc-e462-4c04-8c1a-ddf9f6a35467\"}','2025-03-03 06:26:23',NULL,'user_updated'),(686,'App\\Models\\User',137,'{\"ip_address\":\"223.190.230.106\"}','2025-03-03 08:26:46',NULL,'user_updated'),(687,'App\\Models\\User',137,'{\"verify_token\":\"002492\"}','2025-03-03 08:26:46',NULL,'user_updated'),(688,'App\\Models\\User',141,'{\"email\":\"anuppligadeh@gmail.com\",\"firstname\":\"anuppligadeh@gmail.com\",\"ip_address\":\"122.167.28.167\",\"uuid\":\"87e39aff-301f-4f04-a5d9-b6483aaf7887\",\"my_referral\":\"WZSFN61C\",\"updated_at\":\"2025-03-03 17:12:19\",\"created_at\":\"2025-03-03 17:12:19\",\"id\":141}','2025-03-03 11:42:19',NULL,'user_created'),(689,'App\\Models\\User',141,'{\"uuid\":\"87e39aff-301f-4f04-a5d9-b6483aaf7887\"}','2025-03-03 11:42:19',NULL,'user_updated'),(690,'App\\Models\\User',142,'{\"email\":\"anup@webschedio.in\",\"firstname\":\"anup@webschedio.in\",\"ip_address\":\"223.190.230.106\",\"uuid\":\"e2379547-f86c-405e-9746-23223ba07829\",\"my_referral\":\"9WPPG9TM\",\"updated_at\":\"2025-03-04 05:51:57\",\"created_at\":\"2025-03-04 05:51:57\",\"id\":142}','2025-03-04 00:21:57',NULL,'user_created'),(691,'App\\Models\\User',142,'{\"uuid\":\"e2379547-f86c-405e-9746-23223ba07829\"}','2025-03-04 00:21:57',NULL,'user_updated'),(692,'App\\Models\\User',142,'{\"verify_token\":\"067517\"}','2025-03-04 03:51:21',NULL,'user_updated'),(693,'App\\Models\\User',142,'{\"verify_token\":\"080081\"}','2025-03-04 03:55:50',NULL,'user_updated'),(694,'App\\Models\\User',142,'{\"verify_token\":\"080350\"}','2025-03-04 04:00:13',NULL,'user_updated'),(695,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$1WyzaF0DpvKwAP3xhp\\/8deCSIiQIxK1nA0w8XexHB\\/UhDUHo0E7r6\",\"firebase_token\":\"[]\"}','2025-03-04 04:25:54',NULL,'user_updated'),(696,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$gvT\\/TspLFkru.2nOqW3JJ.2QW8JgRys9oKpOOfigT3FaMemc8mVOG\",\"firebase_token\":\"[]\"}','2025-03-04 04:26:28',NULL,'user_updated'),(697,'App\\Models\\User',143,'{\"phone\":\"9986809661\",\"email\":null,\"referral\":\"anuppligade@gmail.com\",\"active\":1,\"phone_verified_at\":\"2025-03-04T10:30:34.243491Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$XGO0eIORGG1MKhow7s\\/nQePNfiTnbXZDa2uCrLAX17ujiJYYDybDm\",\"uuid\":\"164ed2e3-fbb2-42db-84a6-f6b1126ac472\",\"my_referral\":\"QJC3HZNV\",\"updated_at\":\"2025-03-04 10:30:34\",\"created_at\":\"2025-03-04 10:30:34\",\"id\":143}','2025-03-04 05:00:34',NULL,'user_created'),(698,'App\\Models\\User',142,'{\"verify_token\":\"080613\"}','2025-03-04 06:02:04',NULL,'user_updated'),(699,'App\\Models\\User',142,'{\"verify_token\":\"087924\"}','2025-03-04 06:09:32',NULL,'user_updated'),(700,'App\\Models\\User',142,'{\"verify_token\":\"088372\"}','2025-03-04 06:16:01',NULL,'user_updated'),(701,'App\\Models\\User',144,'{\"phone\":\"7259231760\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-03-05T09:54:01.332927Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$gKKB.1dVlv3.hVRpxQvCuejCKTFi2rmi2Eus918aCYOBtRaZ8w2\\/6\",\"uuid\":\"cd7e8962-9b82-4397-986d-1afc94d708f2\",\"my_referral\":\"LADFEMKE\",\"updated_at\":\"2025-03-05 09:54:01\",\"created_at\":\"2025-03-05 09:54:01\",\"id\":144}','2025-03-05 04:24:01',NULL,'user_created'),(702,'App\\Models\\User',145,'{\"phone\":\"9741449257\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-03-05T11:36:11.378311Z\",\"firstname\":\"yash\",\"lastname\":\"k\",\"gender\":\"male\",\"password\":\"$2y$10$sxSPVinQIHCNQ9CqH65GoOUlRj99Oa9JgYv7kJizyL2GrL3ct9aQC\",\"uuid\":\"8f373df1-5152-443f-be71-84aec65d6543\",\"my_referral\":\"8GKLZS6G\",\"updated_at\":\"2025-03-05 11:36:11\",\"created_at\":\"2025-03-05 11:36:11\",\"id\":145}','2025-03-05 06:06:11',NULL,'user_created'),(703,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$PNBxRlD0u5vaTBjEJ81w.eIlDPQOjcH0DME\\/aWK0BJf6K1ucjd4uy\",\"firebase_token\":\"[]\"}','2025-03-05 08:41:10',119,'user_updated'),(704,'App\\Models\\User',146,'{\"phone\":\"8105339814\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-03-05T14:22:33.510987Z\",\"firstname\":\"sumith\",\"lastname\":\"j\",\"gender\":\"male\",\"password\":\"$2y$10$nPfB0xFN7guRz\\/KxCf1DyuYu6LzHzVy1qpM8mtrlVFZ8wG\\/qmA0my\",\"uuid\":\"5f29189f-a097-449c-90f1-15713b31e627\",\"my_referral\":\"PIZANKRH\",\"updated_at\":\"2025-03-05 14:22:33\",\"created_at\":\"2025-03-05 14:22:33\",\"id\":146}','2025-03-05 08:52:33',NULL,'user_created'),(705,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$HaNa1kym.VbqvV6btePtqOskByNDZdzbZrayWrz6LT2qqkOX7BX8S\",\"firebase_token\":\"[]\"}','2025-03-05 09:27:49',119,'user_updated'),(706,'App\\Models\\User',142,'{\"ip_address\":\"223.190.230.106\"}','2025-03-05 11:53:20',NULL,'user_updated'),(707,'App\\Models\\User',142,'{\"verify_token\":\"088761\"}','2025-03-05 11:53:20',NULL,'user_updated'),(708,'App\\Models\\User',142,'{\"verify_token\":\"195400\"}','2025-03-05 12:03:38',NULL,'user_updated'),(709,'App\\Models\\User',142,'{\"verify_token\":\"196018\"}','2025-03-05 12:12:51',NULL,'user_updated'),(710,'App\\Models\\User',142,'{\"verify_token\":\"196571\"}','2025-03-05 12:37:26',NULL,'user_updated'),(711,'App\\Models\\User',142,'{\"verify_token\":\"198046\"}','2025-03-05 12:46:11',NULL,'user_updated'),(712,'App\\Models\\User',142,'{\"email_verified_at\":null}','2025-03-05 12:57:48',NULL,'user_updated'),(713,'App\\Models\\User',137,'{\"ip_address\":\"122.167.28.167\"}','2025-03-05 13:12:41',NULL,'user_updated'),(714,'App\\Models\\User',137,'{\"verify_token\":\"010206\"}','2025-03-05 13:12:41',NULL,'user_updated'),(715,'App\\Models\\User',147,'{\"email\":\"prakashrligadi@gmail.com\",\"firstname\":\"prakashrligadi@gmail.com\",\"ip_address\":\"122.173.140.213\",\"uuid\":\"738a8c6d-3363-4264-86f1-ddfe6a6c55b4\",\"my_referral\":\"CTKAKIWV\",\"updated_at\":\"2025-03-05 18:48:54\",\"created_at\":\"2025-03-05 18:48:54\",\"id\":147}','2025-03-05 13:18:54',NULL,'user_created'),(716,'App\\Models\\User',147,'{\"uuid\":\"738a8c6d-3363-4264-86f1-ddfe6a6c55b4\"}','2025-03-05 13:18:54',NULL,'user_updated'),(717,'App\\Models\\User',147,'{\"email_verified_at\":null}','2025-03-05 13:19:14',NULL,'user_updated'),(718,'App\\Models\\User',148,'{\"phone\":\"9480287584\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-03-05T18:56:49.104904Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$9nSHTPg6sT8hJtWj8wT\\/5uQNIuefUm20RkoyCKlaFXLdYHtqUCo.i\",\"uuid\":\"3b73d40d-7d88-4e8c-a860-5ee0ca986dad\",\"my_referral\":\"BVVS4A8S\",\"updated_at\":\"2025-03-05 18:56:49\",\"created_at\":\"2025-03-05 18:56:49\",\"id\":148}','2025-03-05 13:26:49',NULL,'user_created'),(719,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$gGLnAh.jMDkWoYrSOuSCO.cvLenIxFDhxLcHAR0Guy7tO.zqZMXKy\",\"firebase_token\":\"[]\"}','2025-03-05 13:29:32',119,'user_updated'),(720,'App\\Models\\User',149,'{\"email\":\"anuppd@gmail.com\",\"firstname\":\"anuppd@gmail.com\",\"ip_address\":\"122.173.140.213\",\"uuid\":\"3b2af125-01b0-4e01-bfe1-f86ff901e4f6\",\"my_referral\":\"BR4SA65J\",\"updated_at\":\"2025-03-05 19:12:54\",\"created_at\":\"2025-03-05 19:12:54\",\"id\":149}','2025-03-05 13:42:54',NULL,'user_created'),(721,'App\\Models\\User',149,'{\"uuid\":\"3b2af125-01b0-4e01-bfe1-f86ff901e4f6\"}','2025-03-05 13:42:54',NULL,'user_updated'),(722,'App\\Models\\User',137,'{\"verify_token\":\"200161\"}','2025-03-05 13:43:09',NULL,'user_updated'),(723,'App\\Models\\User',137,'{\"verify_token\":\"201989\"}','2025-03-05 13:43:53',NULL,'user_updated'),(724,'App\\Models\\User',137,'{\"verify_token\":\"202033\"}','2025-03-05 13:44:30',NULL,'user_updated'),(725,'App\\Models\\User',137,'{\"verify_token\":\"202070\"}','2025-03-05 13:49:07',NULL,'user_updated'),(726,'App\\Models\\User',137,'{\"verify_token\":\"202347\"}','2025-03-05 13:51:58',NULL,'user_updated'),(727,'App\\Models\\User',137,'{\"verify_token\":\"202518\"}','2025-03-05 13:57:02',NULL,'user_updated'),(728,'App\\Models\\User',137,'{\"verify_token\":\"202822\"}','2025-03-05 14:01:21',NULL,'user_updated'),(729,'App\\Models\\User',137,'{\"verify_token\":\"203081\"}','2025-03-05 14:04:46',NULL,'user_updated'),(730,'App\\Models\\User',150,'{\"email\":\"shobhaprakashligadi@gmail.com\",\"firstname\":\"shobhaprakashligadi@gmail.com\",\"ip_address\":\"122.173.140.213\",\"uuid\":\"15cbe648-a2d3-4e0b-87c5-b31d8ccdf287\",\"my_referral\":\"CXYBJBQ4\",\"updated_at\":\"2025-03-05 19:55:06\",\"created_at\":\"2025-03-05 19:55:06\",\"id\":150}','2025-03-05 14:25:06',NULL,'user_created'),(731,'App\\Models\\User',150,'{\"uuid\":\"15cbe648-a2d3-4e0b-87c5-b31d8ccdf287\"}','2025-03-05 14:25:06',NULL,'user_updated'),(732,'App\\Models\\User',150,'{\"email_verified_at\":null}','2025-03-05 14:25:22',NULL,'user_updated'),(733,'App\\Models\\User',151,'{\"email\":\"anushp36@gmail.com\",\"firstname\":\"anushp36@gmail.com\",\"ip_address\":\"122.173.140.213\",\"uuid\":\"ff2c531f-fe67-4a8b-a0d3-2fb45b4c9917\",\"my_referral\":\"NWLDPFNZ\",\"updated_at\":\"2025-03-05 20:20:03\",\"created_at\":\"2025-03-05 20:20:03\",\"id\":151}','2025-03-05 14:50:03',NULL,'user_created'),(734,'App\\Models\\User',151,'{\"uuid\":\"ff2c531f-fe67-4a8b-a0d3-2fb45b4c9917\"}','2025-03-05 14:50:04',NULL,'user_updated'),(735,'App\\Models\\User',151,'{\"email_verified_at\":null}','2025-03-05 14:50:25',NULL,'user_updated'),(736,'App\\Models\\User',151,'{\"firstname\":\"anushp36@gmail.com\",\"lastname\":null,\"password\":null}','2025-03-05 14:51:02',NULL,'user_updated'),(737,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$S0V57YB1Q21XghexI.8A4ekPaGVNtAVmwWgxmPKx.MHwJigZ5JHmG\",\"firebase_token\":\"[]\"}','2025-03-05 23:33:33',119,'user_updated'),(738,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$PxQGLq8CCPwhnGMsfhsD..WN\\/l8u1fw\\/uV\\/I.PnXPcuVibtaWMtE2\",\"firebase_token\":\"[]\"}','2025-03-06 00:24:02',119,'user_updated'),(739,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$Zzgcqx7WdjOhqsGnheap2epHhtwmQmqgVdTVQFrotXSwBIEV01Whm\",\"firebase_token\":\"[]\"}','2025-03-06 00:34:44',119,'user_updated'),(740,'App\\Models\\User',144,'{\"password\":\"$2y$10$gKKB.1dVlv3.hVRpxQvCuejCKTFi2rmi2Eus918aCYOBtRaZ8w2\\/6\"}','2025-03-06 02:10:40',NULL,'user_updated'),(741,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$QksqZbx8lBngB5oNoPCP1Ow\\/0ijpR7\\/nFGQ0y\\/sHVjdb3JKDEYWAq\",\"firebase_token\":\"[]\"}','2025-03-06 02:17:56',119,'user_updated'),(742,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$32JVaz.aqZ2O7uXPhhVFjeL48vdF.X4onZjnaK.aGoz8SuiH39o6m\",\"firebase_token\":\"[]\"}','2025-03-06 02:38:12',119,'user_updated'),(743,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$2swSevAxk3isnOAk8LYb2eauCx6cO6vUSn0G\\/J\\/awRkoo.8vwhxZu\",\"firebase_token\":\"[]\"}','2025-03-06 03:50:18',119,'user_updated'),(744,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$tfgUWPbOWtfk\\/qb1dww7du\\/HZCCfnQdyxNyuG8sbWdKXdl3GbDkAe\",\"firebase_token\":\"[]\"}','2025-03-06 03:51:33',119,'user_updated'),(745,'App\\Models\\User',143,'{\"password\":\"$2y$10$XGO0eIORGG1MKhow7s\\/nQePNfiTnbXZDa2uCrLAX17ujiJYYDybDm\"}','2025-03-06 06:18:15',119,'user_updated'),(746,'App\\Models\\User',144,'{\"password\":\"$2y$10$nEgD1dtE4wSIQO76pKza4ejmvdE7HnVkZC5DGgw5xQJbqquaufsUu\"}','2025-03-06 06:19:54',NULL,'user_updated'),(747,'App\\Models\\User',144,'{\"password\":\"$2y$10$NyIWWqL\\/h9NblZnHk6X3\\/.Q9OvqSuF3\\/fzwxqGbZdyVmOZS0uwM\\/K\"}','2025-03-06 06:20:59',NULL,'user_updated'),(748,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$3dMP\\/xbc\\/.lif9udRBk6oevQsgEMtE9vRi84cgijwnH4M5Na1ML.u\",\"firebase_token\":\"[]\"}','2025-03-06 06:38:40',119,'user_updated'),(749,'App\\Models\\User',152,'{\"email\":\"anup@webschedio.in\",\"firstname\":\"anup@webschedio.in\",\"ip_address\":\"106.212.169.40\",\"uuid\":\"b5295df7-925d-4bb3-b685-3d47c03323d6\",\"my_referral\":\"OE8ATIFA\",\"updated_at\":\"2025-03-07 05:17:17\",\"created_at\":\"2025-03-07 05:17:17\",\"id\":152}','2025-03-06 23:47:17',NULL,'user_created'),(750,'App\\Models\\User',152,'{\"uuid\":\"b5295df7-925d-4bb3-b685-3d47c03323d6\"}','2025-03-06 23:47:17',NULL,'user_updated'),(751,'App\\Models\\User',153,'{\"phone\":\"7259231760\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-03-07T05:22:51.321660Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$GRYaK\\/HpKZp94XI41JKOuOWIMIdl5JtSzhtGr5JCx0NeNkFLhIgMa\",\"uuid\":\"51a29ffc-c081-40e4-84d9-b561acbd6698\",\"my_referral\":\"33KVJDBM\",\"updated_at\":\"2025-03-07 05:22:51\",\"created_at\":\"2025-03-07 05:22:51\",\"id\":153}','2025-03-06 23:52:51',NULL,'user_created'),(752,'App\\Models\\User',152,'{\"verify_token\":\"324637\"}','2025-03-06 23:53:43',NULL,'user_updated'),(753,'App\\Models\\User',152,'{\"email_verified_at\":null}','2025-03-06 23:54:05',NULL,'user_updated'),(754,'App\\Models\\User',154,'{\"email\":\"anup@webschedio.in\",\"firstname\":\"anup@webschedio.in\",\"ip_address\":\"106.212.169.40\",\"uuid\":\"df48da5e-9ddb-4078-982e-dfe8025c7060\",\"my_referral\":\"2PG9HFDU\",\"updated_at\":\"2025-03-07 05:38:51\",\"created_at\":\"2025-03-07 05:38:51\",\"id\":154}','2025-03-07 00:08:51',NULL,'user_created'),(755,'App\\Models\\User',154,'{\"uuid\":\"df48da5e-9ddb-4078-982e-dfe8025c7060\"}','2025-03-07 00:08:51',NULL,'user_updated'),(756,'App\\Models\\User',154,'{\"email_verified_at\":null}','2025-03-07 00:09:20',NULL,'user_updated'),(757,'App\\Models\\User',155,'{\"phone\":\"9986809661\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-03-07T05:43:54.033419Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$e\\/8hxvELnMrKQzqy2.Ldz.XQyLn0j11gxbWazAPb5gSTyFwLD7HFa\",\"uuid\":\"fb73835d-92df-4a52-a8dc-ab243c6307e9\",\"my_referral\":\"MSOU79XX\",\"updated_at\":\"2025-03-07 05:43:54\",\"created_at\":\"2025-03-07 05:43:54\",\"id\":155}','2025-03-07 00:13:54',NULL,'user_created'),(758,'App\\Models\\User',156,'{\"email\":\"yashbharadwajk@gmail.com\",\"firstname\":\"yashbharadwajk@gmail.com\",\"ip_address\":\"106.212.169.40\",\"uuid\":\"7e3062f3-bc50-401e-8913-4a852d3f1b5f\",\"my_referral\":\"QMGLH1NJ\",\"updated_at\":\"2025-03-07 05:46:00\",\"created_at\":\"2025-03-07 05:46:00\",\"id\":156}','2025-03-07 00:16:00',NULL,'user_created'),(759,'App\\Models\\User',156,'{\"uuid\":\"7e3062f3-bc50-401e-8913-4a852d3f1b5f\"}','2025-03-07 00:16:00',NULL,'user_updated'),(760,'App\\Models\\User',156,'{\"verify_token\":\"326360\"}','2025-03-07 00:20:50',NULL,'user_updated'),(761,'App\\Models\\User',156,'{\"email_verified_at\":null}','2025-03-07 00:21:23',NULL,'user_updated'),(762,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$Plryw8uBX9UFJhGHLwR7k.7DpCGO6od7OSCmgTJhq507VVyWWoxoq\",\"firebase_token\":\"[]\"}','2025-03-07 01:00:08',119,'user_updated'),(763,'App\\Models\\User',157,'{\"phone\":\"7259231760\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-03-25T05:12:39.460573Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$Rn9cyKQe9VkMB54gTLiyVeKJD7\\/apwO2S5vx.2ES1KcRZvS\\/Avlh.\",\"uuid\":\"626e167a-fec6-42dd-ba66-6819979e2056\",\"my_referral\":\"4FTJTKGN\",\"updated_at\":\"2025-03-25 05:12:39\",\"created_at\":\"2025-03-25 05:12:39\",\"id\":157}','2025-03-24 23:42:39',NULL,'user_created'),(764,'App\\Models\\User',157,'{\"password\":\"$2y$10$Rn9cyKQe9VkMB54gTLiyVeKJD7\\/apwO2S5vx.2ES1KcRZvS\\/Avlh.\"}','2025-03-24 23:45:38',NULL,'user_updated'),(765,'App\\Models\\User',158,'{\"email\":\"sunilkumarshetty004@gmail.com\",\"firstname\":\"sunilkumarshetty004@gmail.com\",\"ip_address\":\"106.212.164.53\",\"uuid\":\"e4411e7f-c717-4112-bc55-b3a617d2f8fb\",\"my_referral\":\"8NLNCQHL\",\"updated_at\":\"2025-03-25 08:24:46\",\"created_at\":\"2025-03-25 08:24:46\",\"id\":158}','2025-03-25 02:54:46',NULL,'user_created'),(766,'App\\Models\\User',158,'{\"uuid\":\"e4411e7f-c717-4112-bc55-b3a617d2f8fb\"}','2025-03-25 02:54:46',NULL,'user_updated'),(767,'App\\Models\\User',159,'{\"email\":\"sunilshetty004@gmail.com\",\"firstname\":\"sunilshetty004@gmail.com\",\"ip_address\":\"106.212.164.53\",\"uuid\":\"9e3acaa5-4bfc-4a0b-893e-58de75482719\",\"my_referral\":\"NR00EPRM\",\"updated_at\":\"2025-03-25 08:29:36\",\"created_at\":\"2025-03-25 08:29:36\",\"id\":159}','2025-03-25 02:59:36',NULL,'user_created'),(768,'App\\Models\\User',159,'{\"uuid\":\"9e3acaa5-4bfc-4a0b-893e-58de75482719\"}','2025-03-25 02:59:36',NULL,'user_updated'),(769,'App\\Models\\User',159,'{\"email_verified_at\":null}','2025-03-25 03:00:10',NULL,'user_updated'),(770,'App\\Models\\User',159,'{\"firstname\":\"sunilshetty004@gmail.com\",\"lastname\":null,\"phone\":null,\"password\":null}','2025-03-25 03:00:52',159,'user_updated'),(771,'App\\Models\\User',159,'{\"firebase_token\":null}','2025-03-25 03:01:05',159,'user_updated'),(772,'App\\Models\\User',160,'{\"email\":\"sunilshetty004@gmail.com\",\"firstname\":\"sunilshetty004@gmail.com\",\"ip_address\":\"106.212.164.53\",\"uuid\":\"7ec240ec-f26c-49d4-a53f-48dd35045637\",\"my_referral\":\"RBI93YU8\",\"updated_at\":\"2025-03-25 08:31:50\",\"created_at\":\"2025-03-25 08:31:50\",\"id\":160}','2025-03-25 03:01:50',NULL,'user_created'),(773,'App\\Models\\User',160,'{\"uuid\":\"7ec240ec-f26c-49d4-a53f-48dd35045637\"}','2025-03-25 03:01:50',NULL,'user_updated'),(774,'App\\Models\\User',160,'{\"email_verified_at\":null}','2025-03-25 03:02:06',NULL,'user_updated'),(775,'App\\Models\\User',160,'{\"firstname\":\"sunilshetty004@gmail.com\",\"lastname\":null,\"password\":null}','2025-03-25 03:02:39',NULL,'user_updated'),(776,'App\\Models\\User',161,'{\"email\":\"sunilshetty004@gmail.com\",\"firstname\":\"sunilshetty004@gmail.com\",\"ip_address\":\"106.212.164.53\",\"uuid\":\"9e6f1166-1110-4cdf-986e-8feb9f52065a\",\"my_referral\":\"L1ZVTOTE\",\"updated_at\":\"2025-03-25 08:33:50\",\"created_at\":\"2025-03-25 08:33:50\",\"id\":161}','2025-03-25 03:03:50',NULL,'user_created'),(777,'App\\Models\\User',161,'{\"uuid\":\"9e6f1166-1110-4cdf-986e-8feb9f52065a\"}','2025-03-25 03:03:50',NULL,'user_updated'),(778,'App\\Models\\User',161,'{\"email_verified_at\":null}','2025-03-25 03:04:10',NULL,'user_updated'),(779,'App\\Models\\User',156,'{\"firstname\":\"yashbharadwajk@gmail.com\",\"lastname\":null,\"password\":null}','2025-03-25 03:05:24',NULL,'user_updated'),(780,'App\\Models\\User',161,'{\"firstname\":\"sunilshetty004@gmail.com\",\"lastname\":null,\"password\":null}','2025-03-25 03:05:41',NULL,'user_updated'),(781,'App\\Models\\User',162,'{\"phone\":\"9741374744\",\"email\":\"s@gmail.com\",\"referral\":null,\"active\":1,\"phone_verified_at\":\"2025-03-25T09:11:28.570361Z\",\"firstname\":\"SUnil\",\"lastname\":\"shetty\",\"gender\":\"male\",\"password\":\"$2y$10$zbuTAMZCGt0hqElOPg4qd.S8F53N43hwbXWJxZ.uTm6lse\\/m6xdc6\",\"uuid\":\"b05519fa-7252-4ee1-9783-e249390b6b23\",\"my_referral\":\"LCNAHCQY\",\"updated_at\":\"2025-03-25 09:11:28\",\"created_at\":\"2025-03-25 09:11:28\",\"id\":162}','2025-03-25 03:41:28',NULL,'user_created'),(782,'App\\Models\\User',162,'{\"firebase_token\":null}','2025-03-25 03:41:55',162,'user_updated'),(783,'App\\Models\\User',163,'{\"email\":\"sowmyasa25@gmail.com\",\"firstname\":\"sowmyasa25@gmail.com\",\"ip_address\":\"106.212.164.53\",\"uuid\":\"da516851-a2a3-47a2-9350-1bd2383b300c\",\"my_referral\":\"74JOUQIN\",\"updated_at\":\"2025-03-25 09:26:27\",\"created_at\":\"2025-03-25 09:26:27\",\"id\":163}','2025-03-25 03:56:27',NULL,'user_created'),(784,'App\\Models\\User',163,'{\"uuid\":\"da516851-a2a3-47a2-9350-1bd2383b300c\"}','2025-03-25 03:56:27',NULL,'user_updated'),(785,'App\\Models\\User',164,'{\"email\":\"lavanyan9901@gmail.com\",\"firstname\":\"lavanyan9901@gmail.com\",\"ip_address\":\"106.212.164.53\",\"uuid\":\"4a67e8a3-e776-40fd-a6e3-bd308793ea30\",\"my_referral\":\"6QKMPLIZ\",\"updated_at\":\"2025-03-25 09:32:37\",\"created_at\":\"2025-03-25 09:32:37\",\"id\":164}','2025-03-25 04:02:37',NULL,'user_created'),(786,'App\\Models\\User',164,'{\"uuid\":\"4a67e8a3-e776-40fd-a6e3-bd308793ea30\"}','2025-03-25 04:02:37',NULL,'user_updated'),(787,'App\\Models\\User',164,'{\"email_verified_at\":null}','2025-03-25 04:04:09',NULL,'user_updated'),(788,'App\\Models\\User',164,'{\"firstname\":\"lavanyan9901@gmail.com\",\"lastname\":null,\"password\":null}','2025-03-25 04:04:41',NULL,'user_updated'),(789,'App\\Models\\User',164,'{\"password\":\"$2y$10$zluSudKChzIMcTU7qEcX6uwYNGkApeTD9vlsxVKgjQjFDhjbdsTD2\"}','2025-03-25 04:09:40',NULL,'user_updated'),(790,'App\\Models\\User',165,'{\"email\":\"marketing@webschedio.in\",\"firstname\":\"marketing@webschedio.in\",\"ip_address\":\"106.212.164.53\",\"uuid\":\"41c93a9e-98d7-4ee9-83b1-8433c9b0ff81\",\"my_referral\":\"2S1XYA9O\",\"updated_at\":\"2025-03-25 09:42:10\",\"created_at\":\"2025-03-25 09:42:10\",\"id\":165}','2025-03-25 04:12:10',NULL,'user_created'),(791,'App\\Models\\User',165,'{\"uuid\":\"41c93a9e-98d7-4ee9-83b1-8433c9b0ff81\"}','2025-03-25 04:12:10',NULL,'user_updated'),(792,'App\\Models\\User',165,'{\"email_verified_at\":null}','2025-03-25 04:12:56',NULL,'user_updated'),(793,'App\\Models\\User',165,'{\"firstname\":\"marketing@webschedio.in\",\"lastname\":null,\"password\":null}','2025-03-25 04:13:54',NULL,'user_updated'),(794,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$fjMhoUJp3oJFixB9V.FhkuRNx0NIy9XMzCaWzYEpytsZXfkt3fjjC\",\"firebase_token\":\"[]\"}','2025-03-25 04:29:14',119,'user_updated'),(795,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":2}','2025-03-25 04:29:45',103,'shop_updated'),(796,'App\\Models\\Order',1035,'{\"cart_id\":41,\"shop_id\":501,\"user_id\":161,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-03-25 15:31\",\"address_id\":33,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2407,\"updated_at\":\"2025-03-25 10:01:23\",\"created_at\":\"2025-03-25 10:01:23\",\"id\":1035}','2025-03-25 04:31:23',161,'order_created'),(797,'App\\Models\\Product',5,'[]','2025-03-25 04:31:23',161,'product_updated'),(798,'App\\Models\\Order',1035,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-03-25 04:31:23',161,'order_updated'),(799,'App\\Models\\User',161,'{\"o_count\":0,\"o_sum\":0}','2025-03-25 04:31:24',161,'user_updated'),(800,'App\\Models\\Order',1036,'{\"cart_id\":42,\"shop_id\":501,\"user_id\":119,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-03-25 15:31\",\"address_id\":17,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":7988,\"updated_at\":\"2025-03-25 10:01:31\",\"created_at\":\"2025-03-25 10:01:31\",\"id\":1036}','2025-03-25 04:31:31',119,'order_created'),(801,'App\\Models\\Product',5,'[]','2025-03-25 04:31:31',119,'product_updated'),(802,'App\\Models\\Order',1036,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-03-25 04:31:31',119,'order_updated'),(803,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"firebase_token\":\"[]\",\"o_count\":6,\"o_sum\":13188.719999999999345163814723491668701171875}','2025-03-25 04:31:31',119,'user_updated'),(804,'App\\Models\\Order',1035,'{\"type\":\"1\",\"status\":\"new\"}','2025-03-25 04:33:23',103,'order_updated'),(805,'App\\Models\\Order',1037,'{\"cart_id\":40,\"shop_id\":501,\"user_id\":165,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-03-25 15:33\",\"address_id\":32,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":6863,\"updated_at\":\"2025-03-25 10:03:53\",\"created_at\":\"2025-03-25 10:03:53\",\"id\":1037}','2025-03-25 04:33:53',165,'order_created'),(806,'App\\Models\\Product',5,'[]','2025-03-25 04:33:53',165,'product_updated'),(807,'App\\Models\\Order',1037,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-03-25 04:33:53',165,'order_updated'),(808,'App\\Models\\User',165,'{\"o_count\":0,\"o_sum\":0}','2025-03-25 04:33:53',165,'user_updated'),(809,'App\\Models\\User',162,'{\"firebase_token\":\"[null,\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\"]\"}','2025-03-25 04:53:52',162,'user_updated'),(810,'App\\Models\\Order',1038,'{\"cart_id\":39,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-03-25 15:55\",\"address_id\":34,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":6574,\"updated_at\":\"2025-03-25 10:25:47\",\"created_at\":\"2025-03-25 10:25:47\",\"id\":1038}','2025-03-25 04:55:47',162,'order_created'),(811,'App\\Models\\Product',41,'[]','2025-03-25 04:55:47',162,'product_updated'),(812,'App\\Models\\Order',1038,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-03-25 04:55:47',162,'order_updated'),(813,'App\\Models\\User',162,'{\"firebase_token\":\"[null,\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\"]\",\"o_count\":0,\"o_sum\":0}','2025-03-25 04:55:47',162,'user_updated'),(814,'App\\Models\\User',162,'{\"firebase_token\":\"[null,\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\"]\"}','2025-03-26 01:19:20',162,'user_updated'),(815,'App\\Models\\User',162,'{\"firebase_token\":\"{\\\"1\\\":\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\"}\"}','2025-03-26 01:22:13',162,'user_updated'),(816,'App\\Models\\User',161,'{\"firebase_token\":null}','2025-04-08 07:04:42',161,'user_updated'),(817,'App\\Models\\User',119,'{\"birthday\":\"2025-02-10\",\"password\":\"$2y$10$iFMYURlY1BIGMf3IrJA5\\/ekQuLXtTs8AoFcv7MC22X6T\\/KU1eqX6G\",\"firebase_token\":\"[]\"}','2025-04-08 07:45:11',119,'user_updated'),(818,'App\\Models\\User',166,'{\"email\":\"anuppligades@gmail.com\",\"firstname\":\"anuppligades@gmail.com\",\"ip_address\":\"106.200.216.20\",\"uuid\":\"3aa9035f-05a0-4eaf-b236-01334f01a26e\",\"my_referral\":\"ZMQEQUJA\",\"updated_at\":\"2025-04-09 06:31:37\",\"created_at\":\"2025-04-09 06:31:37\",\"id\":166}','2025-04-09 01:01:37',NULL,'user_created'),(819,'App\\Models\\User',166,'{\"uuid\":\"3aa9035f-05a0-4eaf-b236-01334f01a26e\"}','2025-04-09 01:01:37',NULL,'user_updated'),(820,'App\\Models\\User',157,'{\"password\":\"$2y$10$W2NOUiS0aWTNHoNRgS9Pd.1rdEfTzuUUvlHWBAvYdkf\\/mRWLCX6U2\"}','2025-04-09 04:37:46',NULL,'user_updated'),(821,'App\\Models\\User',157,'{\"password\":\"$2y$10$GK9uPnW.iDmOj48QByWFq.U1uGnIpMFtt3cWPqDfgOMcZQEKo7ctq\"}','2025-04-09 23:34:53',NULL,'user_updated'),(822,'App\\Models\\Order',1039,'{\"cart_id\":38,\"shop_id\":501,\"user_id\":157,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-04-10 10:35\",\"address_id\":31,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8717,\"updated_at\":\"2025-04-10 05:05:58\",\"created_at\":\"2025-04-10 05:05:58\",\"id\":1039}','2025-04-09 23:35:58',157,'order_created'),(823,'App\\Models\\Product',3,'[]','2025-04-09 23:35:58',157,'product_updated'),(824,'App\\Models\\Product',41,'[]','2025-04-09 23:35:58',157,'product_updated'),(825,'App\\Models\\Order',1039,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-04-09 23:35:58',157,'order_updated'),(826,'App\\Models\\User',157,'{\"o_count\":0,\"o_sum\":0}','2025-04-09 23:35:58',157,'user_updated'),(827,'App\\Models\\User',157,'{\"password\":\"$2y$10$LJFIrmaMBTIAAgSg8SoBAunfYj.YTOhVRUgSDKy5vnzo3Dyk2m1TG\"}','2025-04-09 23:36:57',NULL,'user_updated'),(828,'App\\Models\\User',167,'{\"phone\":\"7026656213\",\"email\":null,\"referral\":\"owner@githubit.com\",\"active\":1,\"phone_verified_at\":\"2025-04-10T05:46:00.089529Z\",\"firstname\":\"Sunil\",\"lastname\":\"Chandra Bose\",\"gender\":\"male\",\"password\":\"$2y$10$Jb6ZjZB7rwqRA8DX\\/c0jxeIwR\\/KK1Wzvb2AXwx0AQbFTreJg9m4.W\",\"uuid\":\"1df69ba6-b0e8-4983-bb7f-ad7a2cac23b9\",\"my_referral\":\"BLWPZZ90\",\"updated_at\":\"2025-04-10 05:46:00\",\"created_at\":\"2025-04-10 05:46:00\",\"id\":167}','2025-04-10 00:16:00',NULL,'user_created'),(829,'App\\Models\\User',168,'{\"phone\":\"9986809661\",\"email\":null,\"referral\":\"9986809661\",\"active\":1,\"phone_verified_at\":\"2025-04-10T06:30:42.803351Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$LrEvysqGDjwiEtrOeG8yHu0OpAM1.wgwR1ucKbSlOJTbXdc9R6KcW\",\"uuid\":\"72d2c2f9-0eb8-4a7c-bad5-2539e8f1fc11\",\"my_referral\":\"C27ALXEB\",\"updated_at\":\"2025-04-10 06:30:42\",\"created_at\":\"2025-04-10 06:30:42\",\"id\":168}','2025-04-10 01:00:42',NULL,'user_created'),(830,'App\\Models\\User',169,'{\"phone\":\"9986809661\",\"email\":null,\"referral\":null,\"active\":1,\"phone_verified_at\":\"2025-04-10T06:46:22.828418Z\",\"firstname\":\"anup\",\"lastname\":\"9986809661\",\"gender\":\"male\",\"password\":\"$2y$10$J3yUIJPqmw.oGUCKwKmG7On0MCMg0JBa\\/UZfqW6uuwdl3PztPS29W\",\"uuid\":\"47101fbc-bdae-44d0-955a-c161bb1ce656\",\"my_referral\":\"WAKRHFMJ\",\"updated_at\":\"2025-04-10 06:46:22\",\"created_at\":\"2025-04-10 06:46:22\",\"id\":169}','2025-04-10 01:16:22',NULL,'user_created'),(831,'App\\Models\\User',157,'{\"password\":\"$2y$10$E151Qp79VO0UW9O6aP9uWOx9AnVin21W.mtSM2wb9lF\\/jGnLghJ5.\"}','2025-04-10 01:19:56',NULL,'user_updated'),(832,'App\\Models\\User',169,'{\"password\":\"$2y$10$J3yUIJPqmw.oGUCKwKmG7On0MCMg0JBa\\/UZfqW6uuwdl3PztPS29W\"}','2025-04-10 01:32:03',NULL,'user_updated'),(833,'App\\Models\\User',170,'{\"phone\":\"9986809661\",\"email\":null,\"referral\":null,\"active\":1,\"phone_verified_at\":\"2025-04-10T07:37:19.513497Z\",\"firstname\":\"anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$FIfhjLJyExB3uj6A4Iu06OqP8iQBMcUolhx6Txg0J9nYjwqcd2JNu\",\"uuid\":\"8977f6b3-e947-4ca1-b91c-0360def6c279\",\"my_referral\":\"CC3HC3UA\",\"updated_at\":\"2025-04-10 07:37:19\",\"created_at\":\"2025-04-10 07:37:19\",\"id\":170}','2025-04-10 02:07:19',NULL,'user_created'),(834,'App\\Models\\User',171,'{\"email\":\"vinayakaanvekar98@gmail.com\",\"firstname\":\"vinayakaanvekar98@gmail.com\",\"ip_address\":\"223.190.193.91\",\"uuid\":\"c5bf1388-7650-48ee-9e4a-6339890fb205\",\"my_referral\":\"JVNJKAFR\",\"updated_at\":\"2025-04-10 10:17:59\",\"created_at\":\"2025-04-10 10:17:59\",\"id\":171}','2025-04-10 04:47:59',NULL,'user_created'),(835,'App\\Models\\User',171,'{\"uuid\":\"c5bf1388-7650-48ee-9e4a-6339890fb205\"}','2025-04-10 04:47:59',NULL,'user_updated'),(836,'App\\Models\\User',171,'{\"verify_token\":\"280279\"}','2025-04-10 04:52:18',NULL,'user_updated'),(837,'App\\Models\\User',171,'{\"email_verified_at\":null}','2025-04-10 04:52:35',NULL,'user_updated'),(838,'App\\Models\\User',171,'{\"firstname\":\"vinayakaanvekar98@gmail.com\",\"lastname\":null,\"password\":null}','2025-04-10 04:53:07',NULL,'user_updated'),(839,'App\\Models\\Order',1040,'{\"cart_id\":47,\"shop_id\":501,\"user_id\":171,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-04-10 15:55\",\"address_id\":42,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":7769,\"updated_at\":\"2025-04-10 10:25:45\",\"created_at\":\"2025-04-10 10:25:45\",\"id\":1040}','2025-04-10 04:55:45',171,'order_created'),(840,'App\\Models\\Product',41,'[]','2025-04-10 04:55:45',171,'product_updated'),(841,'App\\Models\\Order',1040,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-04-10 04:55:45',171,'order_updated'),(842,'App\\Models\\User',171,'{\"o_count\":0,\"o_sum\":0}','2025-04-10 04:55:45',171,'user_updated'),(843,'App\\Models\\User',171,'{\"firebase_token\":null}','2025-04-10 04:57:51',171,'user_updated'),(844,'App\\Models\\Order',1041,'{\"cart_id\":48,\"shop_id\":501,\"user_id\":171,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-04-10 15:58\",\"address_id\":42,\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5908,\"updated_at\":\"2025-04-10 10:28:26\",\"created_at\":\"2025-04-10 10:28:26\",\"id\":1041}','2025-04-10 04:58:26',171,'order_created'),(845,'App\\Models\\Product',41,'[]','2025-04-10 04:58:26',171,'product_updated'),(846,'App\\Models\\Order',1041,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-04-10 04:58:26',171,'order_updated'),(847,'App\\Models\\User',171,'{\"firebase_token\":\"[null,\\\"crWx8Xp-R1ytReSwN7A3PZ:APA91bEsWAxFMh0uIqHfFYBKtTNeRgQt-aS0zNuLUVP3gm2HMZ1-I8QzARzppyYsDruAVQEufmp-gzvxbDqtsK27RDPCV9MgKs1yfMNPC4s0qMrAWK6oRrk\\\"]\",\"o_count\":1,\"o_sum\":1153.5}','2025-04-10 04:58:26',171,'user_updated'),(848,'App\\Models\\Order',1042,'{\"cart_id\":49,\"shop_id\":501,\"user_id\":171,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-04-10 16:07\",\"address_id\":42,\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9514,\"updated_at\":\"2025-04-10 10:37:40\",\"created_at\":\"2025-04-10 10:37:40\",\"id\":1042}','2025-04-10 05:07:40',171,'order_created'),(849,'App\\Models\\Product',41,'[]','2025-04-10 05:07:40',171,'product_updated'),(850,'App\\Models\\Order',1042,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-04-10 05:07:40',171,'order_updated'),(851,'App\\Models\\User',171,'{\"firebase_token\":\"[null,\\\"crWx8Xp-R1ytReSwN7A3PZ:APA91bEsWAxFMh0uIqHfFYBKtTNeRgQt-aS0zNuLUVP3gm2HMZ1-I8QzARzppyYsDruAVQEufmp-gzvxbDqtsK27RDPCV9MgKs1yfMNPC4s0qMrAWK6oRrk\\\"]\",\"o_count\":2,\"o_sum\":2307}','2025-04-10 05:07:40',171,'user_updated'),(852,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\"]\"}','2025-04-10 05:47:56',162,'user_updated'),(853,'App\\Models\\User',157,'{\"password\":\"$2y$10$rLGyG88WTfbUnsXBW1sqU.DMfR2L2HVEMPuNVXjo7LCjZXeFQabyS\"}','2025-04-11 00:02:01',NULL,'user_updated'),(854,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\"]\"}','2025-04-21 04:08:50',162,'user_updated'),(855,'App\\Models\\Order',1043,'{\"cart_id\":43,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-04-21 15:52\",\"address_id\":41,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":3318,\"updated_at\":\"2025-04-21 10:22:31\",\"created_at\":\"2025-04-21 10:22:31\",\"id\":1043}','2025-04-21 04:52:31',162,'order_created'),(856,'App\\Models\\Product',41,'[]','2025-04-21 04:52:31',162,'product_updated'),(857,'App\\Models\\Product',1,'[]','2025-04-21 04:52:31',162,'product_updated'),(858,'App\\Models\\Order',1043,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-04-21 04:52:31',162,'order_updated'),(859,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\"]\",\"o_count\":1,\"o_sum\":1153.5}','2025-04-21 04:52:31',162,'user_updated'),(860,'App\\Models\\Order',1044,'{\"cart_id\":52,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-04-21 17:22\",\"address_id\":41,\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1064,\"updated_at\":\"2025-04-21 11:52:54\",\"created_at\":\"2025-04-21 11:52:54\",\"id\":1044}','2025-04-21 06:22:54',162,'order_created'),(861,'App\\Models\\Product',41,'[]','2025-04-21 06:22:54',162,'product_updated'),(862,'App\\Models\\Order',1044,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-04-21 06:22:54',162,'order_updated'),(863,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\"]\",\"o_count\":2,\"o_sum\":4327}','2025-04-21 06:22:54',162,'user_updated'),(864,'App\\Models\\Order',1044,'{\"type\":\"1\",\"status\":\"new\"}','2025-04-22 01:37:02',103,'order_updated'),(865,'App\\Models\\Order',1044,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-04-22 01:38:14',103,'order_updated'),(866,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":1}','2025-05-05 06:41:24',103,'shop_updated'),(867,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2025-02-12 07:37:31\",\"phone_verified_at\":\"2025-02-12 07:37:31\",\"firebase_token\":\"[]\"}','2025-05-05 06:43:13',103,'user_updated'),(868,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":2}','2025-05-05 06:45:12',103,'shop_updated'),(869,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2025-05-05 12:13:13\",\"phone_verified_at\":\"2025-05-05 12:13:13\",\"firebase_token\":\"[]\"}','2025-05-05 06:51:17',103,'user_updated'),(870,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":1}','2025-05-05 06:52:24',103,'shop_updated'),(871,'App\\Models\\Shop',501,'{\"lat_long\":\"{\\\"latitude\\\":-69.3453324000000037585778045468032360076904296875,\\\"longitude\\\":69.3453324000000037585778045468032360076904296875}\",\"background_img\":\"https:\\/\\/premfashion.webschedio.in\\/storage\\/images\\/shops\\/background\\/103-17375288284147.webp\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":\"2\"}','2025-05-05 06:52:24',103,'shop_updated'),(872,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2025-05-05 12:21:17\",\"phone_verified_at\":\"2025-05-05 12:21:17\",\"password\":\"$2y$10$naX7EfkjSWSQ7wBT0SMdTurJ5zaoSnVMsl8rAsdTFzjFU0pebIU4i\",\"firebase_token\":\"[]\"}','2025-05-05 06:53:03',103,'user_updated'),(873,'App\\Models\\Shop',501,'{\"tax\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":2}','2025-05-05 06:56:17',107,'shop_updated'),(874,'App\\Models\\Order',1044,'{\"type\":\"1\",\"status\":\"ready\"}','2025-05-09 01:27:57',103,'order_updated'),(875,'App\\Models\\Order',1044,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-05-09 01:28:19',103,'order_updated'),(876,'App\\Models\\Order',1043,'{\"type\":\"1\",\"status\":\"new\"}','2025-05-09 01:29:12',103,'order_updated'),(877,'App\\Models\\Shop',501,'{\"tax\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":1}','2025-05-09 01:46:55',107,'shop_updated'),(878,'App\\Models\\Shop',501,'{\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"open\":1,\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\"}','2025-05-09 01:55:06',107,'shop_updated'),(879,'App\\Models\\Shop',501,'{\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"open\":0,\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\"}','2025-05-09 01:55:12',107,'shop_updated'),(880,'App\\Models\\Order',1045,'{\"cart_id\":53,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-05-09 13:05\",\"delivery_point_id\":2,\"type\":2,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9036,\"updated_at\":\"2025-05-09 07:35:14\",\"created_at\":\"2025-05-09 07:35:14\",\"id\":1045}','2025-05-09 02:05:14',162,'order_created'),(881,'App\\Models\\Product',5,'[]','2025-05-09 02:05:14',162,'product_updated'),(882,'App\\Models\\Product',41,'[]','2025-05-09 02:05:14',162,'product_updated'),(883,'App\\Models\\Order',1045,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"delivery_date\":\"2025-05-09 13:05:00\",\"otp\":9036}','2025-05-09 02:05:14',162,'order_updated'),(884,'App\\Models\\Product',5,'{\"o_count\":8,\"od_count\":8}','2025-05-09 02:05:14',162,'product_updated'),(885,'App\\Models\\Order',1045,'{\"type\":\"2\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-05-09 02:05:14',162,'order_updated'),(886,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\"]\",\"o_count\":3,\"o_sum\":5480.5}','2025-05-09 02:05:14',162,'user_updated'),(887,'App\\Models\\Shop',501,'{\"tax\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":2}','2025-05-09 02:09:17',107,'shop_updated'),(888,'App\\Models\\Order',1045,'{\"type\":\"2\",\"status\":\"new\"}','2025-05-09 02:11:12',107,'order_updated'),(889,'App\\Models\\User',172,'{\"email\":\"sunilkumarshetty004@gmail.com\",\"firstname\":\"sunilkumarshetty004@gmail.com\",\"ip_address\":\"122.167.18.198\",\"uuid\":\"1e955bdc-6a11-411f-a4c0-3b1a997184db\",\"my_referral\":\"PRRKNDTP\",\"updated_at\":\"2025-05-09 07:43:55\",\"created_at\":\"2025-05-09 07:43:55\",\"id\":172}','2025-05-09 02:13:55',NULL,'user_created'),(890,'App\\Models\\User',172,'{\"uuid\":\"1e955bdc-6a11-411f-a4c0-3b1a997184db\"}','2025-05-09 02:13:55',NULL,'user_updated'),(891,'App\\Models\\User',172,'{\"email_verified_at\":null}','2025-05-09 02:14:50',NULL,'user_updated'),(892,'App\\Models\\User',172,'{\"firstname\":\"sunilkumarshetty004@gmail.com\",\"lastname\":null,\"password\":null}','2025-05-09 02:15:12',NULL,'user_updated'),(893,'App\\Models\\Order',1046,'{\"cart_id\":54,\"shop_id\":501,\"user_id\":172,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-05-12 15:26\",\"address_id\":43,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2764,\"updated_at\":\"2025-05-12 09:56:24\",\"created_at\":\"2025-05-12 09:56:24\",\"id\":1046}','2025-05-12 04:26:24',172,'order_created'),(894,'App\\Models\\Product',41,'[]','2025-05-12 04:26:24',172,'product_updated'),(895,'App\\Models\\Order',1046,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-05-12 04:26:24',172,'order_updated'),(896,'App\\Models\\User',172,'{\"o_count\":0,\"o_sum\":0}','2025-05-12 04:26:24',172,'user_updated'),(897,'App\\Models\\Order',1045,'{\"type\":\"2\",\"status\":\"accepted\"}','2025-05-12 06:17:57',107,'order_updated'),(898,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"password\":\"$2y$10$J2Oc4p.uYsTGUpXtKTuBAeN3k6\\/lAfZfrNyZjjHgWBbwnNSIL09p2\",\"firebase_token\":\"[]\"}','2025-06-02 01:36:58',107,'user_updated'),(899,'App\\Models\\Order',1047,'{\"cart_id\":55,\"shop_id\":501,\"user_id\":107,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-02 12:38\",\"address_id\":44,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":7226,\"updated_at\":\"2025-06-02 07:08:04\",\"created_at\":\"2025-06-02 07:08:04\",\"id\":1047}','2025-06-02 01:38:04',107,'order_created'),(900,'App\\Models\\Product',41,'[]','2025-06-02 01:38:04',107,'product_updated'),(901,'App\\Models\\Order',1047,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-02 01:38:04',107,'order_updated'),(902,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"firebase_token\":\"[]\",\"o_count\":0,\"o_sum\":0}','2025-06-02 01:38:04',107,'user_updated'),(903,'App\\Models\\Order',1047,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-02 01:41:43',107,'order_updated'),(904,'App\\Models\\User',162,'{\"password\":\"$2y$10$zbuTAMZCGt0hqElOPg4qd.S8F53N43hwbXWJxZ.uTm6lse\\/m6xdc6\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\"]\"}','2025-06-06 12:48:37',NULL,'user_updated'),(905,'App\\Models\\User',173,'{\"phone\":\"9019641307\",\"email\":null,\"referral\":null,\"active\":1,\"phone_verified_at\":\"2025-06-09T14:12:36.844520Z\",\"firstname\":\"jagadish\",\"lastname\":\"B\",\"gender\":\"male\",\"password\":\"$2y$10$JlnguUyCd852Z7ej6t2Yw.TMq7J6TOTSVAPWHGRYyASHLCYpKKbPG\",\"uuid\":\"76203cc7-ce9c-4d17-9aa9-991e1d676532\",\"my_referral\":\"HVAHEORX\",\"updated_at\":\"2025-06-09 14:12:36\",\"created_at\":\"2025-06-09 14:12:36\",\"id\":173}','2025-06-09 14:12:36',NULL,'user_created'),(906,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\"]\"}','2025-06-14 15:15:17',162,'user_updated'),(907,'App\\Models\\Order',1048,'{\"cart_id\":56,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-14 20:53\",\"address_id\":41,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1197,\"updated_at\":\"2025-06-14 15:23:11\",\"created_at\":\"2025-06-14 15:23:11\",\"id\":1048}','2025-06-14 15:23:11',162,'order_created'),(908,'App\\Models\\Product',5,'[]','2025-06-14 15:23:11',162,'product_updated'),(909,'App\\Models\\Order',1048,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-14 15:23:11',162,'order_updated'),(910,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":4,\"o_sum\":14634}','2025-06-14 15:23:11',162,'user_updated'),(911,'App\\Models\\Order',1048,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-14 15:24:21',103,'order_updated'),(912,'App\\Models\\Order',1049,'{\"cart_id\":57,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-14 21:41\",\"address_id\":45,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2096,\"updated_at\":\"2025-06-14 16:11:12\",\"created_at\":\"2025-06-14 16:11:12\",\"id\":1049}','2025-06-14 16:11:12',162,'order_created'),(913,'App\\Models\\Product',5,'[]','2025-06-14 16:11:12',162,'product_updated'),(914,'App\\Models\\Order',1049,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-14 16:11:12',162,'order_updated'),(915,'App\\Models\\User',162,'{\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":5,\"o_sum\":23636}','2025-06-14 16:11:12',162,'user_updated'),(916,'App\\Models\\User',103,'{\"birthday\":\"1990-12-31\",\"password\":\"$2y$10$O9ejE4dh5GcsnVnwE\\/Enyu8N8BQ8\\/PdzdKkYbnWbGFxY58v6IB\\/HW\",\"firebase_token\":\"[\\\"de2p883ERUaAS1ff_jD8_5:APA91bGOqasjvnyHS1Q3VpTgXQT3Joz2isHcc_31psgYaXYpQU5Qi7c2_Z7eFOhqIoB7Hl8wYmfvEf_1_KAHKetrfIG8mKorIUffPWDH0HT31zZ9ozIOcW4\\\"]\"}','2025-06-16 07:56:20',103,'user_updated'),(917,'App\\Models\\User',103,'{\"firstname\":\"Owner\",\"lastname\":\"Owner\",\"email\":\"owner@githubit.com\",\"phone\":\"998911902696\",\"birthday\":\"1990-12-31\",\"password\":\"$2y$10$QijN.WQ3kulobb2ejoOgxOVIo8tN14SkNjxnYn2yBJILdr6V4pA9W\",\"firebase_token\":\"[\\\"de2p883ERUaAS1ff_jD8_5:APA91bGOqasjvnyHS1Q3VpTgXQT3Joz2isHcc_31psgYaXYpQU5Qi7c2_Z7eFOhqIoB7Hl8wYmfvEf_1_KAHKetrfIG8mKorIUffPWDH0HT31zZ9ozIOcW4\\\"]\"}','2025-06-16 08:26:08',103,'user_updated'),(918,'App\\Models\\User',103,'{\"birthday\":\"1990-12-31\",\"img\":null,\"firebase_token\":\"[\\\"de2p883ERUaAS1ff_jD8_5:APA91bGOqasjvnyHS1Q3VpTgXQT3Joz2isHcc_31psgYaXYpQU5Qi7c2_Z7eFOhqIoB7Hl8wYmfvEf_1_KAHKetrfIG8mKorIUffPWDH0HT31zZ9ozIOcW4\\\"]\"}','2025-06-16 08:26:08',103,'user_updated'),(919,'App\\Models\\User',162,'{\"birthday\":null,\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\"}','2025-06-16 08:39:34',162,'user_updated'),(920,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"img\":null,\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\"}','2025-06-16 08:39:34',162,'user_updated'),(921,'App\\Models\\User',174,'{\"email\":\"sunilshetty@webschedio.in\",\"firstname\":\"sunilshetty@webschedio.in\",\"ip_address\":\"122.167.174.180\",\"uuid\":\"7a0ecac1-5a88-4225-a490-966a9d850192\",\"my_referral\":\"AFWSI8TV\",\"updated_at\":\"2025-06-16 08:44:30\",\"created_at\":\"2025-06-16 08:44:30\",\"id\":174}','2025-06-16 08:44:30',NULL,'user_created'),(922,'App\\Models\\User',174,'{\"uuid\":\"7a0ecac1-5a88-4225-a490-966a9d850192\"}','2025-06-16 08:44:30',NULL,'user_updated'),(923,'App\\Models\\User',162,'{\"firstname\":\"SUnil\",\"birthday\":\"2025-06-16\",\"ip_address\":null,\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\"}','2025-06-16 08:44:59',NULL,'user_updated'),(924,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"verify_token\":null,\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\"}','2025-06-16 08:44:59',NULL,'user_updated'),(925,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\"}','2025-06-16 08:48:29',162,'user_updated'),(926,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\"]\"}','2025-06-16 09:21:13',162,'user_updated'),(927,'App\\Models\\User',175,'{\"phone\":\"7259231760\",\"email\":null,\"referral\":null,\"active\":1,\"phone_verified_at\":\"2025-06-16T09:21:50.515658Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$mnyg9Y0si3i\\/1aQcICHmaOYt\\/3MXZA6ly0NeMLgfPggT9acg2Q8D2\",\"uuid\":\"9df50c4a-f0fb-42c8-b892-6876b4af7bb7\",\"my_referral\":\"EYLFAP6P\",\"updated_at\":\"2025-06-16 09:21:50\",\"created_at\":\"2025-06-16 09:21:50\",\"id\":175}','2025-06-16 09:21:50',NULL,'user_created'),(928,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"img\":\"https:\\/\\/backstore.premfashions.com\\/storage\\/images\\/users\\/162-17500631685553.webp\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\"}','2025-06-16 09:23:31',162,'user_updated'),(929,'App\\Models\\Order',1050,'{\"cart_id\":59,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 14:53\",\"address_id\":46,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1010,\"updated_at\":\"2025-06-16 09:23:52\",\"created_at\":\"2025-06-16 09:23:52\",\"id\":1050}','2025-06-16 09:23:52',175,'order_created'),(930,'App\\Models\\Product',5,'[]','2025-06-16 09:23:52',175,'product_updated'),(931,'App\\Models\\Order',1050,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 09:23:52',175,'order_updated'),(932,'App\\Models\\User',175,'{\"o_count\":0,\"o_sum\":0}','2025-06-16 09:23:52',175,'user_updated'),(933,'App\\Models\\Product',42,'{\"uuid\":\"4e5cef20-aef6-40dc-ae21-61e1f59790d9\"}','2025-06-16 09:40:10',103,'product_updated'),(934,'App\\Models\\Product',42,'{\"uuid\":\"4e5cef20-aef6-40dc-ae21-61e1f59790d9\"}','2025-06-16 09:40:10',103,'product_updated'),(935,'App\\Models\\Product',42,'{\"min_price\":0,\"max_price\":0}','2025-06-16 09:42:59',103,'product_updated'),(936,'App\\Models\\Product',42,'{\"status\":\"pending\",\"status_note\":null}','2025-06-16 09:46:02',103,'product_updated'),(937,'App\\Models\\Order',1051,'{\"cart_id\":60,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 15:18\",\"address_id\":46,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5367,\"updated_at\":\"2025-06-16 09:48:32\",\"created_at\":\"2025-06-16 09:48:32\",\"id\":1051}','2025-06-16 09:48:32',175,'order_created'),(938,'App\\Models\\Product',42,'[]','2025-06-16 09:48:32',175,'product_updated'),(939,'App\\Models\\Order',1051,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 09:48:33',175,'order_updated'),(940,'App\\Models\\User',175,'{\"o_count\":1,\"o_sum\":8012}','2025-06-16 09:48:33',175,'user_updated'),(941,'App\\Models\\User',175,'{\"o_count\":2,\"o_sum\":8524}','2025-06-16 09:50:54',103,'user_updated'),(942,'App\\Models\\Order',1050,'{\"type\":\"1\"}','2025-06-16 09:50:54',103,'order_deleted'),(943,'App\\Models\\Order',1051,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 09:51:46',175,'order_updated'),(944,'App\\Models\\Order',1052,'{\"cart_id\":61,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 15:23\",\"address_id\":46,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1496,\"updated_at\":\"2025-06-16 09:53:17\",\"created_at\":\"2025-06-16 09:53:17\",\"id\":1052}','2025-06-16 09:53:17',175,'order_created'),(945,'App\\Models\\Product',42,'[]','2025-06-16 09:53:17',175,'product_updated'),(946,'App\\Models\\Order',1052,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 09:53:17',175,'order_updated'),(947,'App\\Models\\User',175,'{\"o_count\":1,\"o_sum\":512}','2025-06-16 09:53:17',175,'user_updated'),(948,'App\\Models\\Order',1052,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 09:54:03',175,'order_updated'),(949,'App\\Models\\Order',1053,'{\"cart_id\":62,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 15:26\",\"address_id\":47,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2665,\"updated_at\":\"2025-06-16 09:56:54\",\"created_at\":\"2025-06-16 09:56:54\",\"id\":1053}','2025-06-16 09:56:54',175,'order_created'),(950,'App\\Models\\Product',42,'[]','2025-06-16 09:56:54',175,'product_updated'),(951,'App\\Models\\Order',1053,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 09:56:54',175,'order_updated'),(952,'App\\Models\\User',175,'{\"o_count\":2,\"o_sum\":5524}','2025-06-16 09:56:55',175,'user_updated'),(953,'App\\Models\\Order',1053,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 09:58:21',103,'order_updated'),(954,'App\\Models\\Order',1053,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-16 09:58:33',103,'order_updated'),(955,'App\\Models\\Order',1053,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-16 09:58:45',103,'order_updated'),(956,'App\\Models\\Order',1053,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-16 09:58:58',103,'order_updated'),(957,'App\\Models\\Product',43,'{\"uuid\":\"da5fdc67-08e3-40cd-9ecd-a84830dc729b\"}','2025-06-16 10:48:26',103,'product_updated'),(958,'App\\Models\\Product',43,'{\"uuid\":\"da5fdc67-08e3-40cd-9ecd-a84830dc729b\"}','2025-06-16 10:48:26',103,'product_updated'),(959,'App\\Models\\Product',43,'{\"min_price\":0,\"max_price\":0}','2025-06-16 10:51:00',103,'product_updated'),(960,'App\\Models\\Product',43,'{\"status\":\"pending\",\"status_note\":null}','2025-06-16 10:52:58',103,'product_updated'),(961,'App\\Models\\Product',44,'{\"uuid\":\"4e17d092-1a8e-498e-9f09-d92f6d2ad7ad\"}','2025-06-16 10:58:19',103,'product_updated'),(962,'App\\Models\\Product',44,'{\"uuid\":\"4e17d092-1a8e-498e-9f09-d92f6d2ad7ad\"}','2025-06-16 10:58:19',103,'product_updated'),(963,'App\\Models\\Product',44,'{\"min_price\":0,\"max_price\":0}','2025-06-16 10:59:28',103,'product_updated'),(964,'App\\Models\\Order',1054,'{\"cart_id\":58,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 16:34\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":7662,\"updated_at\":\"2025-06-16 11:04:15\",\"created_at\":\"2025-06-16 11:04:15\",\"id\":1054}','2025-06-16 11:04:15',162,'order_created'),(965,'App\\Models\\Product',42,'[]','2025-06-16 11:04:15',162,'product_updated'),(966,'App\\Models\\Order',1054,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 11:04:15',162,'order_updated'),(967,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":6,\"o_sum\":32638}','2025-06-16 11:04:15',162,'user_updated'),(968,'App\\Models\\Product',44,'{\"status\":\"pending\",\"status_note\":null}','2025-06-16 11:04:23',103,'product_updated'),(969,'App\\Models\\Order',1055,'{\"cart_id\":63,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 16:47\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1910,\"updated_at\":\"2025-06-16 11:17:15\",\"created_at\":\"2025-06-16 11:17:15\",\"id\":1055}','2025-06-16 11:17:15',175,'order_created'),(970,'App\\Models\\Product',44,'[]','2025-06-16 11:17:15',175,'product_updated'),(971,'App\\Models\\Order',1055,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 11:17:15',175,'order_updated'),(972,'App\\Models\\User',175,'{\"o_count\":3,\"o_sum\":6036}','2025-06-16 11:17:15',175,'user_updated'),(973,'App\\Models\\Order',1055,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 11:20:55',103,'order_updated'),(974,'App\\Models\\Order',1055,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-16 11:21:06',103,'order_updated'),(975,'App\\Models\\Order',1055,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-16 11:21:25',103,'order_updated'),(976,'App\\Models\\Product',45,'{\"uuid\":\"c5766fbf-d904-402a-b5b9-a6b85df93f90\"}','2025-06-16 11:25:02',103,'product_updated'),(977,'App\\Models\\Product',45,'{\"uuid\":\"c5766fbf-d904-402a-b5b9-a6b85df93f90\"}','2025-06-16 11:25:02',103,'product_updated'),(978,'App\\Models\\Product',45,'{\"min_price\":0,\"max_price\":0}','2025-06-16 11:25:25',103,'product_updated'),(979,'App\\Models\\Order',1056,'{\"cart_id\":64,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 17:02\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1567,\"updated_at\":\"2025-06-16 11:32:31\",\"created_at\":\"2025-06-16 11:32:31\",\"id\":1056}','2025-06-16 11:32:31',162,'order_created'),(980,'App\\Models\\Product',42,'[]','2025-06-16 11:32:31',162,'product_updated'),(981,'App\\Models\\Product',42,'{\"o_count\":4,\"od_count\":4}','2025-06-16 11:32:31',162,'product_updated'),(982,'App\\Models\\Order',1056,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 11:32:31',162,'order_updated'),(983,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":1,\"o_sum\":512}','2025-06-16 11:32:31',162,'user_updated'),(984,'App\\Models\\Order',1057,'{\"cart_id\":65,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 17:12\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5089,\"updated_at\":\"2025-06-16 11:42:29\",\"created_at\":\"2025-06-16 11:42:29\",\"id\":1057}','2025-06-16 11:42:29',175,'order_created'),(985,'App\\Models\\Product',43,'[]','2025-06-16 11:42:29',175,'product_updated'),(986,'App\\Models\\Order',1057,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 11:42:29',175,'order_updated'),(987,'App\\Models\\User',175,'{\"o_count\":1,\"o_sum\":12002}','2025-06-16 11:42:29',175,'user_updated'),(988,'App\\Models\\Order',1058,'{\"cart_id\":66,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 17:25\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":7379,\"updated_at\":\"2025-06-16 11:56:00\",\"created_at\":\"2025-06-16 11:56:00\",\"id\":1058}','2025-06-16 11:56:00',175,'order_created'),(989,'App\\Models\\Product',44,'[]','2025-06-16 11:56:00',175,'product_updated'),(990,'App\\Models\\Order',1058,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 11:56:00',175,'order_updated'),(991,'App\\Models\\User',175,'{\"o_count\":2,\"o_sum\":26504}','2025-06-16 11:56:00',175,'user_updated'),(992,'App\\Models\\Order',1056,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 11:58:04',103,'order_updated'),(993,'App\\Models\\Order',1056,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-16 11:58:36',103,'order_updated'),(994,'App\\Models\\Order',1056,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-16 11:59:42',103,'order_updated'),(995,'App\\Models\\Order',1056,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-16 12:01:09',103,'order_updated'),(996,'App\\Models\\Order',1059,'{\"cart_id\":67,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 17:35\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5887,\"updated_at\":\"2025-06-16 12:05:31\",\"created_at\":\"2025-06-16 12:05:31\",\"id\":1059}','2025-06-16 12:05:31',175,'order_created'),(997,'App\\Models\\Product',44,'[]','2025-06-16 12:05:31',175,'product_updated'),(998,'App\\Models\\Order',1059,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 12:05:31',175,'order_updated'),(999,'App\\Models\\User',175,'{\"o_count\":3,\"o_sum\":37506}','2025-06-16 12:05:31',175,'user_updated'),(1000,'App\\Models\\Order',1060,'{\"cart_id\":68,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 17:38\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9064,\"updated_at\":\"2025-06-16 12:08:43\",\"created_at\":\"2025-06-16 12:08:43\",\"id\":1060}','2025-06-16 12:08:43',162,'order_created'),(1001,'App\\Models\\Product',44,'[]','2025-06-16 12:08:43',162,'product_updated'),(1002,'App\\Models\\Order',1060,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 12:08:43',162,'order_updated'),(1003,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":2,\"o_sum\":1524}','2025-06-16 12:08:43',162,'user_updated'),(1004,'App\\Models\\Order',1060,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 12:09:47',103,'order_updated'),(1005,'App\\Models\\Order',1059,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 12:10:28',103,'order_updated'),(1006,'App\\Models\\Order',1060,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-16 12:11:06',103,'order_updated'),(1007,'App\\Models\\Order',1060,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-16 12:11:18',103,'order_updated'),(1008,'App\\Models\\Order',1060,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-16 12:11:36',103,'order_updated'),(1009,'App\\Models\\Order',1061,'{\"cart_id\":69,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 17:50\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":6767,\"updated_at\":\"2025-06-16 12:21:01\",\"created_at\":\"2025-06-16 12:21:01\",\"id\":1061}','2025-06-16 12:21:01',162,'order_created'),(1010,'App\\Models\\Product',42,'[]','2025-06-16 12:21:02',162,'product_updated'),(1011,'App\\Models\\Order',1061,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 12:21:02',162,'order_updated'),(1012,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":3,\"o_sum\":11536}','2025-06-16 12:21:02',162,'user_updated'),(1013,'App\\Models\\Order',1061,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-16 12:24:08',103,'order_updated'),(1014,'App\\Models\\Order',1061,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-16 12:24:44',103,'order_updated'),(1015,'App\\Models\\Order',1061,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-16 12:24:58',103,'order_updated'),(1016,'App\\Models\\Order',1061,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-16 12:25:13',103,'order_updated'),(1017,'App\\Models\\Order',1062,'{\"cart_id\":70,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 18:01\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2526,\"updated_at\":\"2025-06-16 12:31:42\",\"created_at\":\"2025-06-16 12:31:42\",\"id\":1062}','2025-06-16 12:31:42',175,'order_created'),(1018,'App\\Models\\Product',44,'[]','2025-06-16 12:31:43',175,'product_updated'),(1019,'App\\Models\\Order',1062,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 12:31:43',175,'order_updated'),(1020,'App\\Models\\User',175,'{\"o_count\":4,\"o_sum\":48508}','2025-06-16 12:31:43',175,'user_updated'),(1021,'App\\Models\\Product',46,'{\"uuid\":\"52d2af80-d127-4d15-8402-e8943e04ae05\"}','2025-06-16 13:04:09',103,'product_updated'),(1022,'App\\Models\\Product',46,'{\"uuid\":\"52d2af80-d127-4d15-8402-e8943e04ae05\"}','2025-06-16 13:04:09',103,'product_updated'),(1023,'App\\Models\\Order',1063,'{\"cart_id\":71,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:00\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9908,\"updated_at\":\"2025-06-16 13:30:51\",\"created_at\":\"2025-06-16 13:30:51\",\"id\":1063}','2025-06-16 13:30:51',162,'order_created'),(1024,'App\\Models\\Product',42,'[]','2025-06-16 13:30:51',162,'product_updated'),(1025,'App\\Models\\Order',1063,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 13:30:51',162,'order_updated'),(1026,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":4,\"o_sum\":21548}','2025-06-16 13:30:51',162,'user_updated'),(1027,'App\\Models\\Order',1064,'{\"cart_id\":73,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:02\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":7276,\"updated_at\":\"2025-06-16 13:32:09\",\"created_at\":\"2025-06-16 13:32:09\",\"id\":1064}','2025-06-16 13:32:09',162,'order_created'),(1028,'App\\Models\\Product',43,'[]','2025-06-16 13:32:09',162,'product_updated'),(1029,'App\\Models\\Product',42,'[]','2025-06-16 13:32:09',162,'product_updated'),(1030,'App\\Models\\Order',1064,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 13:32:09',162,'order_updated'),(1031,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":5,\"o_sum\":22060}','2025-06-16 13:32:09',162,'user_updated'),(1032,'App\\Models\\Order',1065,'{\"cart_id\":74,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:04\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2356,\"updated_at\":\"2025-06-16 13:34:28\",\"created_at\":\"2025-06-16 13:34:28\",\"id\":1065}','2025-06-16 13:34:28',162,'order_created'),(1033,'App\\Models\\Product',42,'[]','2025-06-16 13:34:28',162,'product_updated'),(1034,'App\\Models\\Order',1065,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 13:34:28',162,'order_updated'),(1035,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":6,\"o_sum\":38072}','2025-06-16 13:34:28',162,'user_updated'),(1036,'App\\Models\\Order',1066,'{\"cart_id\":75,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:06\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":6369,\"updated_at\":\"2025-06-16 13:36:04\",\"created_at\":\"2025-06-16 13:36:04\",\"id\":1066}','2025-06-16 13:36:05',162,'order_created'),(1037,'App\\Models\\Product',42,'[]','2025-06-16 13:36:05',162,'product_updated'),(1038,'App\\Models\\Product',42,'{\"o_count\":3,\"od_count\":3}','2025-06-16 13:36:05',162,'product_updated'),(1039,'App\\Models\\Order',1066,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 13:36:05',162,'order_updated'),(1040,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":7,\"o_sum\":39584}','2025-06-16 13:36:05',162,'user_updated'),(1041,'App\\Models\\Order',1067,'{\"cart_id\":76,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:07\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5639,\"updated_at\":\"2025-06-16 13:37:08\",\"created_at\":\"2025-06-16 13:37:08\",\"id\":1067}','2025-06-16 13:37:08',162,'order_created'),(1042,'App\\Models\\Product',42,'[]','2025-06-16 13:37:08',162,'product_updated'),(1043,'App\\Models\\Order',1067,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 13:37:09',162,'order_updated'),(1044,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":8,\"o_sum\":42596}','2025-06-16 13:37:09',162,'user_updated'),(1045,'App\\Models\\Order',1068,'{\"cart_id\":77,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:10\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5567,\"updated_at\":\"2025-06-16 13:40:50\",\"created_at\":\"2025-06-16 13:40:50\",\"id\":1068}','2025-06-16 13:40:50',162,'order_created'),(1046,'App\\Models\\Product',42,'[]','2025-06-16 13:40:50',162,'product_updated'),(1047,'App\\Models\\Order',1068,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 13:40:50',162,'order_updated'),(1048,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":9,\"o_sum\":47608}','2025-06-16 13:40:50',162,'user_updated'),(1049,'App\\Models\\Order',1069,'{\"cart_id\":78,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:11\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9381,\"updated_at\":\"2025-06-16 13:41:51\",\"created_at\":\"2025-06-16 13:41:51\",\"id\":1069}','2025-06-16 13:41:51',162,'order_created'),(1050,'App\\Models\\Product',42,'[]','2025-06-16 13:41:51',162,'product_updated'),(1051,'App\\Models\\Order',1069,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 13:41:51',162,'order_updated'),(1052,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":10,\"o_sum\":55120}','2025-06-16 13:41:51',162,'user_updated'),(1053,'App\\Models\\Order',1070,'{\"cart_id\":72,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 19:39\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9479,\"updated_at\":\"2025-06-16 14:09:22\",\"created_at\":\"2025-06-16 14:09:22\",\"id\":1070}','2025-06-16 14:09:22',175,'order_created'),(1054,'App\\Models\\Product',43,'[]','2025-06-16 14:09:22',175,'product_updated'),(1055,'App\\Models\\Order',1070,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 14:09:22',175,'order_updated'),(1056,'App\\Models\\User',175,'{\"o_count\":5,\"o_sum\":59510}','2025-06-16 14:09:22',175,'user_updated'),(1057,'App\\Models\\Order',1071,'{\"cart_id\":79,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 19:45\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2624,\"updated_at\":\"2025-06-16 14:15:16\",\"created_at\":\"2025-06-16 14:15:16\",\"id\":1071}','2025-06-16 14:15:16',175,'order_created'),(1058,'App\\Models\\Product',42,'[]','2025-06-16 14:15:16',175,'product_updated'),(1059,'App\\Models\\Product',44,'[]','2025-06-16 14:15:16',175,'product_updated'),(1060,'App\\Models\\Order',1071,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 14:15:16',175,'order_updated'),(1061,'App\\Models\\User',175,'{\"o_count\":6,\"o_sum\":62012}','2025-06-16 14:15:16',175,'user_updated'),(1062,'App\\Models\\Order',1072,'{\"cart_id\":80,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 19:51\",\"address_id\":57,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9834,\"updated_at\":\"2025-06-16 14:21:20\",\"created_at\":\"2025-06-16 14:21:20\",\"id\":1072}','2025-06-16 14:21:20',175,'order_created'),(1063,'App\\Models\\Product',42,'[]','2025-06-16 14:21:20',175,'product_updated'),(1064,'App\\Models\\Order',1072,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 14:21:20',175,'order_updated'),(1065,'App\\Models\\User',175,'{\"o_count\":7,\"o_sum\":72514}','2025-06-16 14:21:20',175,'user_updated'),(1066,'App\\Models\\Order',1073,'{\"cart_id\":81,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-16 19:55\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8761,\"updated_at\":\"2025-06-16 14:25:45\",\"created_at\":\"2025-06-16 14:25:45\",\"id\":1073}','2025-06-16 14:25:45',175,'order_created'),(1067,'App\\Models\\Product',42,'[]','2025-06-16 14:25:45',175,'product_updated'),(1068,'App\\Models\\Order',1073,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-16 14:25:45',175,'order_updated'),(1069,'App\\Models\\User',175,'{\"o_count\":8,\"o_sum\":73026}','2025-06-16 14:25:45',175,'user_updated'),(1070,'App\\Models\\Order',1064,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 04:58:38',103,'order_updated'),(1071,'App\\Models\\Order',1064,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 04:58:48',103,'order_updated'),(1072,'App\\Models\\Order',1074,'{\"cart_id\":82,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-17 10:29\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5750,\"updated_at\":\"2025-06-17 04:59:29\",\"created_at\":\"2025-06-17 04:59:29\",\"id\":1074}','2025-06-17 04:59:29',175,'order_created'),(1073,'App\\Models\\Product',42,'[]','2025-06-17 04:59:29',175,'product_updated'),(1074,'App\\Models\\Order',1074,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 04:59:29',175,'order_updated'),(1075,'App\\Models\\User',175,'{\"o_count\":9,\"o_sum\":74528}','2025-06-17 04:59:29',175,'user_updated'),(1076,'App\\Models\\Order',1064,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:04:24',103,'order_updated'),(1077,'App\\Models\\Order',1064,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:04:37',103,'order_updated'),(1078,'App\\Models\\Order',1067,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:05:44',103,'order_updated'),(1079,'App\\Models\\Order',1067,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:06:00',103,'order_updated'),(1080,'App\\Models\\Order',1067,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:06:10',103,'order_updated'),(1081,'App\\Models\\Order',1067,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:06:23',103,'order_updated'),(1082,'App\\Models\\Order',1075,'{\"cart_id\":83,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-17 10:37\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5747,\"updated_at\":\"2025-06-17 05:07:33\",\"created_at\":\"2025-06-17 05:07:33\",\"id\":1075}','2025-06-17 05:07:33',175,'order_created'),(1083,'App\\Models\\Product',42,'[]','2025-06-17 05:07:33',175,'product_updated'),(1084,'App\\Models\\Order',1075,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 05:07:33',175,'order_updated'),(1085,'App\\Models\\User',175,'{\"o_count\":10,\"o_sum\":76030}','2025-06-17 05:07:33',175,'user_updated'),(1086,'App\\Models\\Order',1066,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:07:48',103,'order_updated'),(1087,'App\\Models\\Order',1066,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:08:01',103,'order_updated'),(1088,'App\\Models\\Order',1066,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:08:12',103,'order_updated'),(1089,'App\\Models\\Order',1066,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:08:26',103,'order_updated'),(1090,'App\\Models\\Order',1063,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:09:23',103,'order_updated'),(1091,'App\\Models\\Order',1063,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:09:31',103,'order_updated'),(1092,'App\\Models\\Order',1063,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:09:44',103,'order_updated'),(1093,'App\\Models\\Order',1063,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:10:16',103,'order_updated'),(1094,'App\\Models\\Order',1072,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:12:32',103,'order_updated'),(1095,'App\\Models\\Order',1072,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:12:44',103,'order_updated'),(1096,'App\\Models\\Order',1072,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:12:52',103,'order_updated'),(1097,'App\\Models\\Order',1072,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:13:03',103,'order_updated'),(1098,'App\\Models\\Order',1073,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:15:59',103,'order_updated'),(1099,'App\\Models\\Order',1073,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:32:59',103,'order_updated'),(1100,'App\\Models\\Order',1073,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:33:14',103,'order_updated'),(1101,'App\\Models\\Order',1073,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:33:35',103,'order_updated'),(1102,'App\\Models\\Order',1075,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:34:43',103,'order_updated'),(1103,'App\\Models\\Order',1074,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:35:10',103,'order_updated'),(1104,'App\\Models\\Order',1076,'{\"cart_id\":84,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 11:05\",\"address_id\":57,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1711,\"updated_at\":\"2025-06-17 05:35:18\",\"created_at\":\"2025-06-17 05:35:18\",\"id\":1076}','2025-06-17 05:35:18',175,'order_created'),(1105,'App\\Models\\Product',42,'[]','2025-06-17 05:35:18',175,'product_updated'),(1106,'App\\Models\\Order',1076,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 05:35:18',175,'order_updated'),(1107,'App\\Models\\User',175,'{\"o_count\":11,\"o_sum\":77532}','2025-06-17 05:35:18',175,'user_updated'),(1108,'App\\Models\\Order',1074,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:35:20',103,'order_updated'),(1109,'App\\Models\\Order',1074,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:35:32',103,'order_updated'),(1110,'App\\Models\\Order',1074,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:36:03',103,'order_updated'),(1111,'App\\Models\\Order',1077,'{\"cart_id\":85,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 11:08\",\"address_id\":57,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8218,\"updated_at\":\"2025-06-17 05:38:04\",\"created_at\":\"2025-06-17 05:38:04\",\"id\":1077}','2025-06-17 05:38:04',175,'order_created'),(1112,'App\\Models\\Product',42,'[]','2025-06-17 05:38:04',175,'product_updated'),(1113,'App\\Models\\Order',1077,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 05:38:04',175,'order_updated'),(1114,'App\\Models\\User',175,'{\"o_count\":12,\"o_sum\":78044}','2025-06-17 05:38:04',175,'user_updated'),(1115,'App\\Models\\Order',1077,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:43:29',103,'order_updated'),(1116,'App\\Models\\Order',1076,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:43:39',103,'order_updated'),(1117,'App\\Models\\Order',1071,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:46:18',103,'order_updated'),(1118,'App\\Models\\Order',1071,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:46:25',103,'order_updated'),(1119,'App\\Models\\Order',1071,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:46:33',103,'order_updated'),(1120,'App\\Models\\Order',1071,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:46:41',103,'order_updated'),(1121,'App\\Models\\Order',1078,'{\"cart_id\":86,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 11:20\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5211,\"updated_at\":\"2025-06-17 05:50:34\",\"created_at\":\"2025-06-17 05:50:34\",\"id\":1078}','2025-06-17 05:50:34',162,'order_created'),(1122,'App\\Models\\Product',42,'[]','2025-06-17 05:50:34',162,'product_updated'),(1123,'App\\Models\\Order',1078,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 05:50:34',162,'order_updated'),(1124,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":11,\"o_sum\":65132}','2025-06-17 05:50:34',162,'user_updated'),(1125,'App\\Models\\Order',1078,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:51:16',103,'order_updated'),(1126,'App\\Models\\Order',1078,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 05:51:29',103,'order_updated'),(1127,'App\\Models\\Order',1078,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 05:51:40',103,'order_updated'),(1128,'App\\Models\\Order',1078,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 05:51:55',103,'order_updated'),(1129,'App\\Models\\Order',1069,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 05:56:26',103,'order_updated'),(1130,'App\\Models\\Order',1079,'{\"cart_id\":87,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 11:43\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":3615,\"updated_at\":\"2025-06-17 06:13:36\",\"created_at\":\"2025-06-17 06:13:36\",\"id\":1079}','2025-06-17 06:13:36',162,'order_created'),(1131,'App\\Models\\Product',42,'[]','2025-06-17 06:13:36',162,'product_updated'),(1132,'App\\Models\\Order',1079,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 06:13:36',162,'order_updated'),(1133,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":12,\"o_sum\":65644}','2025-06-17 06:13:36',162,'user_updated'),(1134,'App\\Models\\Order',1079,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 06:14:59',103,'order_updated'),(1135,'App\\Models\\Order',1079,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 06:15:21',103,'order_updated'),(1136,'App\\Models\\Order',1079,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 06:15:32',103,'order_updated'),(1137,'App\\Models\\Order',1079,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 06:15:43',103,'order_updated'),(1138,'App\\Models\\Order',1080,'{\"cart_id\":88,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 12:03\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5806,\"updated_at\":\"2025-06-17 06:33:56\",\"created_at\":\"2025-06-17 06:33:56\",\"id\":1080}','2025-06-17 06:33:56',162,'order_created'),(1139,'App\\Models\\Product',42,'[]','2025-06-17 06:33:56',162,'product_updated'),(1140,'App\\Models\\Order',1080,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 06:33:56',162,'order_updated'),(1141,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":13,\"o_sum\":66156}','2025-06-17 06:33:56',162,'user_updated'),(1142,'App\\Models\\Order',1080,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 06:34:24',103,'order_updated'),(1143,'App\\Models\\Order',1080,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 06:34:44',103,'order_updated'),(1144,'App\\Models\\Order',1080,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 06:34:55',103,'order_updated'),(1145,'App\\Models\\Order',1080,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 06:35:07',103,'order_updated'),(1146,'App\\Models\\Product',47,'{\"uuid\":\"f59bbf3f-4463-4793-a952-0d4195cee755\"}','2025-06-17 08:50:01',103,'product_updated'),(1147,'App\\Models\\Product',47,'{\"uuid\":\"f59bbf3f-4463-4793-a952-0d4195cee755\"}','2025-06-17 08:50:01',103,'product_updated'),(1148,'App\\Models\\Product',48,'{\"uuid\":\"b6941683-78b8-4eb4-9292-928f9adb5beb\"}','2025-06-17 08:54:09',103,'product_updated'),(1149,'App\\Models\\Product',48,'{\"uuid\":\"b6941683-78b8-4eb4-9292-928f9adb5beb\"}','2025-06-17 08:54:09',103,'product_updated'),(1150,'App\\Models\\Product',49,'{\"uuid\":\"71583573-42ef-4068-8a24-f14ab694bc9b\"}','2025-06-17 08:57:00',103,'product_updated'),(1151,'App\\Models\\Product',49,'{\"uuid\":\"71583573-42ef-4068-8a24-f14ab694bc9b\"}','2025-06-17 08:57:00',103,'product_updated'),(1152,'App\\Models\\Product',50,'{\"uuid\":\"5c5d6396-c1b9-4a28-b3c4-94c3ed20c8d9\"}','2025-06-17 08:59:31',103,'product_updated'),(1153,'App\\Models\\Product',50,'{\"uuid\":\"5c5d6396-c1b9-4a28-b3c4-94c3ed20c8d9\"}','2025-06-17 08:59:31',103,'product_updated'),(1154,'App\\Models\\Category',17,'{\"keywords\":\"shirt\",\"parent_id\":\"6\",\"type\":2,\"active\":\"1\",\"uuid\":\"7680e63a-568a-447f-839c-cd8491b379cb\",\"updated_at\":\"2025-06-17 09:56:25\",\"created_at\":\"2025-06-17 09:56:25\",\"id\":17}','2025-06-17 09:56:25',103,'category_created'),(1155,'App\\Models\\Category',17,'{\"active\":\"1\",\"uuid\":\"7680e63a-568a-447f-839c-cd8491b379cb\"}','2025-06-17 09:56:25',103,'category_updated'),(1156,'App\\Models\\Category',17,'{\"active\":\"1\",\"uuid\":\"7680e63a-568a-447f-839c-cd8491b379cb\"}','2025-06-17 09:56:25',103,'category_updated'),(1157,'App\\Models\\Category',17,'{\"status\":\"pending\"}','2025-06-17 09:56:55',103,'category_updated'),(1158,'App\\Models\\Product',51,'{\"uuid\":\"ea9d46de-c465-42a7-99d1-87ef5f5f5b0a\"}','2025-06-17 10:07:40',103,'product_updated'),(1159,'App\\Models\\Product',51,'{\"uuid\":\"ea9d46de-c465-42a7-99d1-87ef5f5f5b0a\"}','2025-06-17 10:07:40',103,'product_updated'),(1160,'App\\Models\\Category',17,'{\"keywords\":\"shirt\",\"input\":null}','2025-06-17 10:11:39',103,'category_updated'),(1161,'App\\Models\\Category',17,'{\"slug\":\"shirt-17\",\"input\":\"8\",\"active\":\"1\"}','2025-06-17 10:11:39',103,'category_updated'),(1162,'App\\Models\\Category',18,'{\"keywords\":\"cotton shirt\",\"parent_id\":\"6\",\"type\":2,\"active\":\"1\",\"uuid\":\"028ae404-1dd2-4f4a-b006-c556073a78c2\",\"updated_at\":\"2025-06-17 10:14:31\",\"created_at\":\"2025-06-17 10:14:31\",\"id\":18}','2025-06-17 10:14:31',103,'category_created'),(1163,'App\\Models\\Category',18,'{\"active\":\"1\",\"uuid\":\"028ae404-1dd2-4f4a-b006-c556073a78c2\"}','2025-06-17 10:14:31',103,'category_updated'),(1164,'App\\Models\\Category',18,'{\"active\":\"1\",\"uuid\":\"028ae404-1dd2-4f4a-b006-c556073a78c2\"}','2025-06-17 10:14:31',103,'category_updated'),(1165,'App\\Models\\Category',18,'{\"status\":\"pending\"}','2025-06-17 10:14:47',103,'category_updated'),(1166,'App\\Models\\Category',18,'{\"parent_id\":6,\"input\":null}','2025-06-17 10:15:36',103,'category_updated'),(1167,'App\\Models\\Category',17,'{\"slug\":\"super-combed-cotton-rich-elastane-stretch-relaxed-17\",\"input\":\"8\",\"active\":\"1\"}','2025-06-17 10:21:21',103,'category_updated'),(1168,'App\\Models\\Product',52,'{\"uuid\":\"b6aa215a-e480-4686-8720-18f23d55f78f\"}','2025-06-17 10:23:08',103,'product_updated'),(1169,'App\\Models\\Product',52,'{\"uuid\":\"b6aa215a-e480-4686-8720-18f23d55f78f\"}','2025-06-17 10:23:08',103,'product_updated'),(1170,'App\\Models\\Category',19,'{\"keywords\":\"waefarefaer\",\"type\":1,\"active\":\"1\",\"input\":\"11\",\"uuid\":\"2181e7be-14de-4a37-a82f-49354aea2851\",\"updated_at\":\"2025-06-17 10:43:41\",\"created_at\":\"2025-06-17 10:43:41\",\"id\":19}','2025-06-17 10:43:41',103,'category_created'),(1171,'App\\Models\\Category',19,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"2181e7be-14de-4a37-a82f-49354aea2851\"}','2025-06-17 10:43:41',103,'category_updated'),(1172,'App\\Models\\Category',19,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"2181e7be-14de-4a37-a82f-49354aea2851\"}','2025-06-17 10:43:41',103,'category_updated'),(1173,'App\\Models\\Category',20,'{\"keywords\":\"waefarefaer\",\"type\":1,\"active\":\"1\",\"input\":\"11\",\"uuid\":\"dfa4fe84-c32f-4c1e-b31a-6dd4353a56c3\",\"updated_at\":\"2025-06-17 10:44:42\",\"created_at\":\"2025-06-17 10:44:42\",\"id\":20}','2025-06-17 10:44:42',103,'category_created'),(1174,'App\\Models\\Category',20,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"dfa4fe84-c32f-4c1e-b31a-6dd4353a56c3\"}','2025-06-17 10:44:42',103,'category_updated'),(1175,'App\\Models\\Category',20,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"dfa4fe84-c32f-4c1e-b31a-6dd4353a56c3\"}','2025-06-17 10:44:42',103,'category_updated'),(1176,'App\\Models\\Category',20,'{\"status\":\"pending\"}','2025-06-17 10:44:53',103,'category_updated'),(1177,'App\\Models\\Category',19,'[]','2025-06-17 10:45:03',103,'category_deleted'),(1178,'App\\Models\\Category',21,'{\"keywords\":\"waefarefaer\",\"type\":1,\"active\":\"1\",\"input\":\"11\",\"uuid\":\"c5d5de82-6e97-4a54-8e8a-2df24cc39cd2\",\"updated_at\":\"2025-06-17 10:46:06\",\"created_at\":\"2025-06-17 10:46:06\",\"id\":21}','2025-06-17 10:46:06',103,'category_created'),(1179,'App\\Models\\Category',21,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"c5d5de82-6e97-4a54-8e8a-2df24cc39cd2\"}','2025-06-17 10:46:06',103,'category_updated'),(1180,'App\\Models\\Category',21,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"c5d5de82-6e97-4a54-8e8a-2df24cc39cd2\"}','2025-06-17 10:46:06',103,'category_updated'),(1181,'App\\Models\\Category',21,'{\"status\":\"pending\"}','2025-06-17 10:46:16',103,'category_updated'),(1182,'App\\Models\\Category',22,'{\"keywords\":\"waefarefaer\",\"type\":1,\"active\":\"1\",\"input\":\"11\",\"uuid\":\"b37d021b-3e21-41af-ae5e-67ee5f077ec5\",\"updated_at\":\"2025-06-17 10:47:31\",\"created_at\":\"2025-06-17 10:47:31\",\"id\":22}','2025-06-17 10:47:31',103,'category_created'),(1183,'App\\Models\\Category',22,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"b37d021b-3e21-41af-ae5e-67ee5f077ec5\"}','2025-06-17 10:47:31',103,'category_updated'),(1184,'App\\Models\\Category',22,'{\"active\":\"1\",\"input\":\"11\",\"uuid\":\"b37d021b-3e21-41af-ae5e-67ee5f077ec5\"}','2025-06-17 10:47:31',103,'category_updated'),(1185,'App\\Models\\Category',22,'{\"status\":\"pending\"}','2025-06-17 10:47:39',103,'category_updated'),(1186,'App\\Models\\Product',53,'{\"uuid\":\"77def5e1-0c38-4b76-a83a-35e9ecbc69cd\"}','2025-06-17 10:51:30',103,'product_updated'),(1187,'App\\Models\\Product',53,'{\"uuid\":\"77def5e1-0c38-4b76-a83a-35e9ecbc69cd\"}','2025-06-17 10:51:30',103,'product_updated'),(1188,'App\\Models\\Product',53,'{\"min_price\":0,\"max_price\":0}','2025-06-17 10:52:42',103,'product_updated'),(1189,'App\\Models\\Product',54,'{\"uuid\":\"8824262e-edcc-4cbe-b464-e10017b6a757\"}','2025-06-17 10:56:15',103,'product_updated'),(1190,'App\\Models\\Product',54,'{\"uuid\":\"8824262e-edcc-4cbe-b464-e10017b6a757\"}','2025-06-17 10:56:15',103,'product_updated'),(1191,'App\\Models\\Product',54,'{\"min_price\":0,\"max_price\":0}','2025-06-17 10:57:22',103,'product_updated'),(1192,'App\\Models\\Product',53,'{\"status\":\"pending\",\"status_note\":null}','2025-06-17 10:58:24',103,'product_updated'),(1193,'App\\Models\\Product',54,'{\"status\":\"pending\",\"status_note\":null}','2025-06-17 10:58:34',103,'product_updated'),(1194,'App\\Models\\Order',1081,'{\"cart_id\":89,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 16:30\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":3072,\"updated_at\":\"2025-06-17 11:00:13\",\"created_at\":\"2025-06-17 11:00:13\",\"id\":1081}','2025-06-17 11:00:13',162,'order_created'),(1195,'App\\Models\\Product',53,'[]','2025-06-17 11:00:13',162,'product_updated'),(1196,'App\\Models\\Order',1081,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 11:00:13',162,'order_updated'),(1197,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":14,\"o_sum\":66668}','2025-06-17 11:00:13',162,'user_updated'),(1198,'App\\Models\\Product',55,'{\"uuid\":\"65d410cf-2d4d-483a-a66e-e43ceb449414\"}','2025-06-17 11:00:56',103,'product_updated'),(1199,'App\\Models\\Product',55,'{\"uuid\":\"65d410cf-2d4d-483a-a66e-e43ceb449414\"}','2025-06-17 11:00:56',103,'product_updated'),(1200,'App\\Models\\Product',55,'{\"min_price\":0,\"max_price\":0}','2025-06-17 11:01:42',103,'product_updated'),(1201,'App\\Models\\Product',55,'{\"status\":\"pending\",\"status_note\":null}','2025-06-17 11:03:38',103,'product_updated'),(1202,'App\\Models\\Order',1082,'{\"cart_id\":90,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 16:34\",\"address_id\":55,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9068,\"updated_at\":\"2025-06-17 11:04:48\",\"created_at\":\"2025-06-17 11:04:48\",\"id\":1082}','2025-06-17 11:04:48',162,'order_created'),(1203,'App\\Models\\Product',53,'[]','2025-06-17 11:04:48',162,'product_updated'),(1204,'App\\Models\\Order',1082,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 11:04:48',162,'order_updated'),(1205,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":15,\"o_sum\":67180}','2025-06-17 11:04:48',162,'user_updated'),(1206,'App\\Models\\Product',56,'{\"uuid\":\"65ec1b6b-913c-47aa-bf90-d8baba0b7f47\"}','2025-06-17 11:04:52',103,'product_updated'),(1207,'App\\Models\\Product',56,'{\"uuid\":\"65ec1b6b-913c-47aa-bf90-d8baba0b7f47\"}','2025-06-17 11:04:52',103,'product_updated'),(1208,'App\\Models\\Order',1083,'{\"cart_id\":91,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-17 16:37\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2397,\"updated_at\":\"2025-06-17 11:07:41\",\"created_at\":\"2025-06-17 11:07:41\",\"id\":1083}','2025-06-17 11:07:41',162,'order_created'),(1209,'App\\Models\\Product',53,'[]','2025-06-17 11:07:41',162,'product_updated'),(1210,'App\\Models\\Order',1083,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 11:07:41',162,'order_updated'),(1211,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":16,\"o_sum\":67692}','2025-06-17 11:07:41',162,'user_updated'),(1212,'App\\Models\\Order',1084,'{\"cart_id\":92,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-17 16:38\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":1415,\"updated_at\":\"2025-06-17 11:08:44\",\"created_at\":\"2025-06-17 11:08:44\",\"id\":1084}','2025-06-17 11:08:44',162,'order_created'),(1213,'App\\Models\\Product',53,'[]','2025-06-17 11:08:44',162,'product_updated'),(1214,'App\\Models\\Order',1084,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 11:08:44',162,'order_updated'),(1215,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\",\"o_count\":17,\"o_sum\":69194}','2025-06-17 11:08:44',162,'user_updated'),(1216,'App\\Models\\Category',23,'{\"keywords\":\"tshirt\",\"parent_id\":\"20\",\"type\":2,\"active\":\"1\",\"uuid\":\"983ac7c5-91da-4b9a-9649-9b0b1f98899f\",\"updated_at\":\"2025-06-17 11:12:28\",\"created_at\":\"2025-06-17 11:12:28\",\"id\":23}','2025-06-17 11:12:28',103,'category_created'),(1217,'App\\Models\\Category',23,'{\"active\":\"1\",\"uuid\":\"983ac7c5-91da-4b9a-9649-9b0b1f98899f\"}','2025-06-17 11:12:28',103,'category_updated'),(1218,'App\\Models\\Category',23,'{\"active\":\"1\",\"uuid\":\"983ac7c5-91da-4b9a-9649-9b0b1f98899f\"}','2025-06-17 11:12:28',103,'category_updated'),(1219,'App\\Models\\Category',23,'{\"status\":\"pending\"}','2025-06-17 11:12:44',103,'category_updated'),(1220,'App\\Models\\Order',1084,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 11:12:56',103,'order_updated'),(1221,'App\\Models\\Category',24,'{\"keywords\":\"tshirt for girls\",\"parent_id\":\"21\",\"type\":2,\"active\":\"1\",\"uuid\":\"2d9b52dd-3c9d-4d1a-9b92-3d30661199ba\",\"updated_at\":\"2025-06-17 11:14:33\",\"created_at\":\"2025-06-17 11:14:33\",\"id\":24}','2025-06-17 11:14:33',103,'category_created'),(1222,'App\\Models\\Category',24,'{\"active\":\"1\",\"uuid\":\"2d9b52dd-3c9d-4d1a-9b92-3d30661199ba\"}','2025-06-17 11:14:34',103,'category_updated'),(1223,'App\\Models\\Category',24,'{\"active\":\"1\",\"uuid\":\"2d9b52dd-3c9d-4d1a-9b92-3d30661199ba\"}','2025-06-17 11:14:34',103,'category_updated'),(1224,'App\\Models\\Category',24,'{\"status\":\"pending\"}','2025-06-17 11:15:03',103,'category_updated'),(1225,'App\\Models\\Category',25,'{\"keywords\":\"pants for kids\",\"parent_id\":\"22\",\"type\":2,\"active\":\"1\",\"uuid\":\"81d6e484-dd17-4d20-9d89-29d42584f2c0\",\"updated_at\":\"2025-06-17 11:16:26\",\"created_at\":\"2025-06-17 11:16:26\",\"id\":25}','2025-06-17 11:16:26',103,'category_created'),(1226,'App\\Models\\Category',25,'{\"active\":\"1\",\"uuid\":\"81d6e484-dd17-4d20-9d89-29d42584f2c0\"}','2025-06-17 11:16:26',103,'category_updated'),(1227,'App\\Models\\Category',25,'{\"active\":\"1\",\"uuid\":\"81d6e484-dd17-4d20-9d89-29d42584f2c0\"}','2025-06-17 11:16:26',103,'category_updated'),(1228,'App\\Models\\Category',25,'{\"status\":\"pending\"}','2025-06-17 11:17:58',103,'category_updated'),(1229,'App\\Models\\Product',57,'{\"uuid\":\"bb9925df-7fbb-4e98-890e-2f9893edd1fe\"}','2025-06-17 11:40:03',103,'product_updated'),(1230,'App\\Models\\Product',57,'{\"uuid\":\"bb9925df-7fbb-4e98-890e-2f9893edd1fe\"}','2025-06-17 11:40:03',103,'product_updated'),(1231,'App\\Models\\Order',1083,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-17 11:42:38',103,'order_updated'),(1232,'App\\Models\\Order',1083,'{\"type\":\"1\",\"status\":\"accepted\"}','2025-06-17 11:42:58',103,'order_updated'),(1233,'App\\Models\\Order',1083,'{\"type\":\"1\",\"status\":\"ready\"}','2025-06-17 11:43:11',103,'order_updated'),(1234,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\"]\"}','2025-06-17 11:43:38',162,'user_updated'),(1235,'App\\Models\\Order',1083,'{\"type\":\"1\",\"status\":\"on_a_way\"}','2025-06-17 11:43:48',103,'order_updated'),(1236,'App\\Models\\Product',58,'{\"uuid\":\"99d37cde-ca7d-4550-a5b9-e8d046593b20\"}','2025-06-17 11:49:44',103,'product_updated'),(1237,'App\\Models\\Product',58,'{\"uuid\":\"99d37cde-ca7d-4550-a5b9-e8d046593b20\"}','2025-06-17 11:49:44',103,'product_updated'),(1238,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\"]\"}','2025-06-17 11:55:44',162,'user_updated'),(1239,'App\\Models\\Order',1085,'{\"cart_id\":93,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-17 17:39\",\"address_id\":58,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":2843,\"updated_at\":\"2025-06-17 12:09:06\",\"created_at\":\"2025-06-17 12:09:06\",\"id\":1085}','2025-06-17 12:09:06',162,'order_created'),(1240,'App\\Models\\Product',53,'[]','2025-06-17 12:09:06',162,'product_updated'),(1241,'App\\Models\\Product',53,'{\"o_count\":5,\"od_count\":5}','2025-06-17 12:09:06',162,'product_updated'),(1242,'App\\Models\\Order',1085,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-17 12:09:06',162,'order_updated'),(1243,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\",\"o_count\":18,\"o_sum\":70696}','2025-06-17 12:09:06',162,'user_updated'),(1244,'App\\Models\\Product',59,'{\"uuid\":\"0cc920aa-672d-4411-a7b0-edb91fd4e67f\"}','2025-06-17 12:43:11',103,'product_updated'),(1245,'App\\Models\\Product',59,'{\"uuid\":\"0cc920aa-672d-4411-a7b0-edb91fd4e67f\"}','2025-06-17 12:43:11',103,'product_updated'),(1246,'App\\Models\\Product',60,'{\"uuid\":\"0c0962cd-2eb1-49ef-97ad-3561be230f13\"}','2025-06-18 05:51:43',103,'product_updated'),(1247,'App\\Models\\Product',60,'{\"uuid\":\"0c0962cd-2eb1-49ef-97ad-3561be230f13\"}','2025-06-18 05:51:43',103,'product_updated'),(1248,'App\\Models\\Product',60,'{\"min_price\":0,\"max_price\":0}','2025-06-18 05:52:17',103,'product_updated'),(1249,'App\\Models\\Product',60,'{\"status\":\"pending\",\"status_note\":null}','2025-06-18 05:53:29',103,'product_updated'),(1250,'App\\Models\\Product',60,'{\"tax\":0,\"status_note\":\"\"}','2025-06-18 05:55:39',103,'product_updated'),(1251,'App\\Models\\Order',1085,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-18 06:03:43',162,'order_updated'),(1252,'App\\Models\\Order',1086,'{\"cart_id\":94,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-18 11:44\",\"address_id\":58,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":5806,\"updated_at\":\"2025-06-18 06:14:31\",\"created_at\":\"2025-06-18 06:14:31\",\"id\":1086}','2025-06-18 06:14:31',162,'order_created'),(1253,'App\\Models\\Product',60,'[]','2025-06-18 06:14:31',162,'product_updated'),(1254,'App\\Models\\Order',1086,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-18 06:14:31',162,'order_updated'),(1255,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\",\"o_count\":19,\"o_sum\":71708}','2025-06-18 06:14:31',162,'user_updated'),(1256,'App\\Models\\Order',1086,'{\"type\":\"1\",\"status\":\"new\"}','2025-06-18 06:15:07',162,'order_updated'),(1257,'App\\Models\\Order',1087,'{\"cart_id\":95,\"shop_id\":501,\"user_id\":162,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-18 11:53\",\"address_id\":58,\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8734,\"updated_at\":\"2025-06-18 06:23:32\",\"created_at\":\"2025-06-18 06:23:32\",\"id\":1087}','2025-06-18 06:23:32',162,'order_created'),(1258,'App\\Models\\Product',60,'[]','2025-06-18 06:23:32',162,'product_updated'),(1259,'App\\Models\\Order',1087,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-18 06:23:32',162,'order_updated'),(1260,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\",\"o_count\":20,\"o_sum\":71720}','2025-06-18 06:23:32',162,'user_updated'),(1261,'App\\Models\\Product',61,'{\"uuid\":\"27a712ef-f524-4425-b116-368a7337695f\"}','2025-06-18 06:27:12',103,'product_updated'),(1262,'App\\Models\\Product',61,'{\"uuid\":\"27a712ef-f524-4425-b116-368a7337695f\"}','2025-06-18 06:27:12',103,'product_updated'),(1263,'App\\Models\\Product',62,'{\"uuid\":\"3bada51d-e7df-4a3e-9351-9ae4144c3386\"}','2025-06-18 06:42:23',103,'product_updated'),(1264,'App\\Models\\Product',62,'{\"uuid\":\"3bada51d-e7df-4a3e-9351-9ae4144c3386\"}','2025-06-18 06:42:23',103,'product_updated'),(1265,'App\\Models\\Product',63,'{\"uuid\":\"648b034d-d9e0-4138-8fea-db5938e329f8\"}','2025-06-18 07:15:09',103,'product_updated'),(1266,'App\\Models\\Product',63,'{\"uuid\":\"648b034d-d9e0-4138-8fea-db5938e329f8\"}','2025-06-18 07:15:09',103,'product_updated'),(1267,'App\\Models\\Product',63,'{\"min_price\":0,\"max_price\":0}','2025-06-18 07:18:35',103,'product_updated'),(1268,'App\\Models\\Product',62,'{\"min_price\":0,\"max_price\":0}','2025-06-18 07:20:43',103,'product_updated'),(1269,'App\\Models\\Product',62,'{\"status\":\"pending\",\"status_note\":null}','2025-06-18 07:21:17',103,'product_updated'),(1270,'App\\Models\\Product',64,'{\"uuid\":\"d223143a-e729-4f63-8444-2026436a5669\"}','2025-06-18 07:36:23',103,'product_updated'),(1271,'App\\Models\\Product',64,'{\"uuid\":\"d223143a-e729-4f63-8444-2026436a5669\"}','2025-06-18 07:36:23',103,'product_updated'),(1272,'App\\Models\\Product',64,'{\"min_price\":0,\"max_price\":0}','2025-06-18 07:43:33',103,'product_updated'),(1273,'App\\Models\\Product',64,'{\"status\":\"pending\",\"status_note\":null}','2025-06-18 07:47:38',103,'product_updated'),(1274,'App\\Models\\Product',65,'{\"uuid\":\"2e92e837-4d9c-4def-8fcc-eaa3b59afc12\"}','2025-06-18 07:50:01',103,'product_updated'),(1275,'App\\Models\\Product',65,'{\"uuid\":\"2e92e837-4d9c-4def-8fcc-eaa3b59afc12\"}','2025-06-18 07:50:01',103,'product_updated'),(1276,'App\\Models\\Product',65,'{\"min_price\":0,\"max_price\":0}','2025-06-18 07:51:04',103,'product_updated'),(1277,'App\\Models\\Product',65,'{\"status\":\"pending\",\"status_note\":null}','2025-06-18 07:54:55',103,'product_updated'),(1278,'App\\Models\\Product',66,'{\"uuid\":\"a589394f-56c9-4cb8-a710-214646a87646\"}','2025-06-18 09:24:30',103,'product_updated'),(1279,'App\\Models\\Product',66,'{\"uuid\":\"a589394f-56c9-4cb8-a710-214646a87646\"}','2025-06-18 09:24:30',103,'product_updated'),(1280,'App\\Models\\User',162,'{\"firstname\":\"sunilshetty004@gmail.com\",\"lastname\":\"shetty\",\"birthday\":\"2025-06-16\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\"}','2025-06-18 09:33:25',162,'user_updated'),(1281,'App\\Models\\Product',67,'{\"uuid\":\"111a7a0d-049e-4bf2-9871-e8befb863218\"}','2025-06-18 09:35:59',103,'product_updated'),(1282,'App\\Models\\Product',67,'{\"uuid\":\"111a7a0d-049e-4bf2-9871-e8befb863218\"}','2025-06-18 09:35:59',103,'product_updated'),(1283,'App\\Models\\Product',68,'{\"uuid\":\"3d71eb2e-c7ce-4bc0-8040-28f5c613ef93\"}','2025-06-18 09:43:46',103,'product_updated'),(1284,'App\\Models\\Product',68,'{\"uuid\":\"3d71eb2e-c7ce-4bc0-8040-28f5c613ef93\"}','2025-06-18 09:43:46',103,'product_updated'),(1285,'App\\Models\\Product',69,'{\"uuid\":\"9ae2248e-357c-4573-84d3-f7178b841d10\"}','2025-06-18 09:45:21',103,'product_updated'),(1286,'App\\Models\\Product',69,'{\"uuid\":\"9ae2248e-357c-4573-84d3-f7178b841d10\"}','2025-06-18 09:45:21',103,'product_updated'),(1287,'App\\Models\\Product',69,'{\"min_price\":0,\"max_price\":0}','2025-06-18 10:42:05',103,'product_updated'),(1288,'App\\Models\\Product',69,'{\"status\":\"pending\",\"status_note\":null}','2025-06-18 11:04:34',103,'product_updated'),(1289,'App\\Models\\Product',70,'{\"uuid\":\"f63b9e89-1790-488d-8fbd-090e7afa83b6\"}','2025-06-18 11:29:00',103,'product_updated'),(1290,'App\\Models\\Product',70,'{\"uuid\":\"f63b9e89-1790-488d-8fbd-090e7afa83b6\"}','2025-06-18 11:29:00',103,'product_updated'),(1291,'App\\Models\\Product',70,'{\"min_price\":0,\"max_price\":0}','2025-06-18 11:30:04',103,'product_updated'),(1292,'App\\Models\\Product',71,'{\"uuid\":\"df5634ff-cd67-45d2-8b34-3fdf11fd91b9\"}','2025-06-18 11:36:46',103,'product_updated'),(1293,'App\\Models\\Product',71,'{\"uuid\":\"df5634ff-cd67-45d2-8b34-3fdf11fd91b9\"}','2025-06-18 11:36:46',103,'product_updated'),(1294,'App\\Models\\Product',71,'{\"min_price\":0,\"max_price\":0}','2025-06-18 11:37:26',103,'product_updated'),(1295,'App\\Models\\Product',72,'{\"uuid\":\"8228c2c6-93e7-4ea9-af1e-2d8394b71c4f\"}','2025-06-19 05:55:14',103,'product_updated'),(1296,'App\\Models\\Product',72,'{\"uuid\":\"8228c2c6-93e7-4ea9-af1e-2d8394b71c4f\"}','2025-06-19 05:55:14',103,'product_updated'),(1297,'App\\Models\\Product',72,'{\"min_price\":0,\"max_price\":0}','2025-06-19 18:23:15',103,'product_updated'),(1298,'App\\Models\\Product',73,'{\"uuid\":\"0c6a915f-a79e-4df2-88e9-a172658e015a\"}','2025-06-19 18:27:33',103,'product_updated'),(1299,'App\\Models\\Product',73,'{\"uuid\":\"0c6a915f-a79e-4df2-88e9-a172658e015a\"}','2025-06-19 18:27:33',103,'product_updated'),(1300,'App\\Models\\Product',73,'{\"min_price\":0,\"max_price\":0}','2025-06-19 18:28:51',103,'product_updated'),(1301,'App\\Models\\Product',73,'{\"status\":\"pending\",\"status_note\":null}','2025-06-19 18:29:46',103,'product_updated'),(1302,'App\\Models\\Product',73,'{\"tax\":0,\"status_note\":\"\"}','2025-06-20 06:10:43',103,'product_updated'),(1303,'App\\Models\\Product',74,'{\"uuid\":\"0bf4484e-190d-412c-a7b0-d84289680ec4\"}','2025-06-20 07:34:15',103,'product_updated'),(1304,'App\\Models\\Product',74,'{\"uuid\":\"0bf4484e-190d-412c-a7b0-d84289680ec4\"}','2025-06-20 07:34:15',103,'product_updated'),(1305,'App\\Models\\Product',74,'{\"min_price\":0,\"max_price\":0}','2025-06-23 04:49:12',103,'product_updated'),(1306,'App\\Models\\Product',74,'{\"min_price\":100,\"max_price\":100}','2025-06-23 04:51:16',103,'product_updated'),(1307,'App\\Models\\Product',74,'{\"min_price\":1000,\"max_price\":1000}','2025-06-23 05:26:09',103,'product_updated'),(1308,'App\\Models\\Product',74,'{\"min_price\":100,\"max_price\":100}','2025-06-23 05:34:49',103,'product_updated'),(1309,'App\\Models\\Order',1088,'{\"cart_id\":98,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-23 11:06\",\"address_id\":57,\"delivery_price_id\":4,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":8603,\"updated_at\":\"2025-06-23 05:36:21\",\"created_at\":\"2025-06-23 05:36:21\",\"id\":1088}','2025-06-23 05:36:21',175,'order_created'),(1310,'App\\Models\\Product',73,'[]','2025-06-23 05:36:21',175,'product_updated'),(1311,'App\\Models\\Order',1088,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-23 05:36:21',175,'order_updated'),(1312,'App\\Models\\User',175,'{\"o_count\":13,\"o_sum\":78556}','2025-06-23 05:36:21',175,'user_updated'),(1313,'App\\Models\\Product',74,'{\"min_price\":0,\"max_price\":0}','2025-06-23 05:39:57',103,'product_updated'),(1314,'App\\Models\\Product',74,'{\"min_price\":10,\"max_price\":10}','2025-06-23 05:47:44',103,'product_updated'),(1315,'App\\Models\\Product',74,'{\"status_note\":null}','2025-06-23 05:49:25',103,'product_updated'),(1316,'App\\Models\\Product',74,'{\"status\":\"pending\"}','2025-06-23 06:38:12',103,'product_updated'),(1317,'App\\Models\\Product',75,'{\"uuid\":\"72098b50-1927-4730-9e83-95db83f68f0b\"}','2025-06-23 06:52:43',103,'product_updated'),(1318,'App\\Models\\Product',75,'{\"uuid\":\"72098b50-1927-4730-9e83-95db83f68f0b\"}','2025-06-23 06:52:43',103,'product_updated'),(1319,'App\\Models\\Product',76,'{\"uuid\":\"9681b73b-cb57-48b4-91f2-a6a16fe5f7da\"}','2025-06-23 06:57:25',103,'product_updated'),(1320,'App\\Models\\Product',76,'{\"uuid\":\"9681b73b-cb57-48b4-91f2-a6a16fe5f7da\"}','2025-06-23 06:57:25',103,'product_updated'),(1321,'App\\Models\\Product',76,'{\"min_price\":0,\"max_price\":0}','2025-06-23 06:58:40',103,'product_updated'),(1322,'App\\Models\\Product',76,'{\"status\":\"pending\",\"status_note\":null}','2025-06-23 07:04:03',103,'product_updated'),(1323,'App\\Models\\Product',76,'{\"min_price\":100,\"max_price\":100}','2025-06-23 07:12:57',103,'product_updated'),(1324,'App\\Models\\Product',76,'{\"tax\":0,\"status_note\":\"\"}','2025-06-23 07:15:22',103,'product_updated'),(1325,'App\\Models\\Product',76,'{\"min_price\":22,\"max_price\":22}','2025-06-23 07:15:53',103,'product_updated'),(1326,'App\\Models\\Product',77,'{\"uuid\":\"7e1720c7-317e-435c-8f74-19a7d94947d1\"}','2025-06-23 07:18:06',103,'product_updated'),(1327,'App\\Models\\Product',77,'{\"uuid\":\"7e1720c7-317e-435c-8f74-19a7d94947d1\"}','2025-06-23 07:18:06',103,'product_updated'),(1328,'App\\Models\\Product',77,'{\"min_price\":0,\"max_price\":0}','2025-06-23 07:20:04',103,'product_updated'),(1329,'App\\Models\\Product',77,'{\"status\":\"pending\",\"status_note\":null}','2025-06-23 07:22:32',103,'product_updated'),(1330,'App\\Models\\Product',76,'{\"min_price\":0,\"max_price\":0}','2025-06-23 07:36:19',103,'product_updated'),(1331,'App\\Models\\Product',76,'{\"min_price\":122,\"max_price\":122}','2025-06-23 07:37:09',103,'product_updated'),(1332,'App\\Models\\Product',78,'{\"uuid\":\"702c05be-ac27-4db2-80c0-a55d77a0e5b5\"}','2025-06-23 07:56:01',103,'product_updated'),(1333,'App\\Models\\Product',78,'{\"uuid\":\"702c05be-ac27-4db2-80c0-a55d77a0e5b5\"}','2025-06-23 07:56:01',103,'product_updated'),(1334,'App\\Models\\Product',73,'{\"min_price\":223,\"max_price\":223}','2025-06-23 08:23:20',103,'product_updated'),(1335,'App\\Models\\Product',66,'{\"min_price\":0,\"max_price\":0}','2025-06-23 08:26:39',103,'product_updated'),(1336,'App\\Models\\Product',75,'{\"min_price\":0,\"max_price\":0}','2025-06-23 08:28:15',103,'product_updated'),(1337,'App\\Models\\Product',75,'{\"slug\":\"malnad-dhoti-75\"}','2025-06-23 08:30:17',103,'product_updated'),(1338,'App\\Models\\Product',75,'{\"status\":\"pending\",\"status_note\":null}','2025-06-23 08:30:35',103,'product_updated'),(1339,'App\\Models\\Product',77,'{\"category_id\":25,\"tax\":0,\"status_note\":\"\"}','2025-06-23 09:32:36',103,'product_updated'),(1340,'App\\Models\\Product',75,'{\"category_id\":25,\"tax\":0,\"status_note\":\"\"}','2025-06-23 09:35:26',103,'product_updated'),(1341,'App\\Models\\Product',79,'{\"uuid\":\"431c7f69-9f04-4182-9532-957420d19584\"}','2025-06-23 09:36:19',103,'product_updated'),(1342,'App\\Models\\Product',79,'{\"uuid\":\"431c7f69-9f04-4182-9532-957420d19584\"}','2025-06-23 09:36:19',103,'product_updated'),(1343,'App\\Models\\Product',80,'{\"uuid\":\"dec51ab4-7f43-4fa8-8a84-61c69009081f\"}','2025-06-23 09:46:34',103,'product_updated'),(1344,'App\\Models\\Product',80,'{\"uuid\":\"dec51ab4-7f43-4fa8-8a84-61c69009081f\"}','2025-06-23 09:46:34',103,'product_updated'),(1345,'App\\Models\\Product',80,'{\"min_price\":0,\"max_price\":0}','2025-06-23 09:47:31',103,'product_updated'),(1346,'App\\Models\\Product',80,'{\"min_price\":100,\"max_price\":100}','2025-06-23 09:49:15',103,'product_updated'),(1347,'App\\Models\\Product',81,'{\"uuid\":\"e7dda7e3-d34f-451b-82c4-99e447a43520\"}','2025-06-23 11:09:14',103,'product_updated'),(1348,'App\\Models\\Product',81,'{\"uuid\":\"e7dda7e3-d34f-451b-82c4-99e447a43520\"}','2025-06-23 11:09:14',103,'product_updated'),(1349,'App\\Models\\Product',82,'{\"uuid\":\"253d8bc8-d879-463d-91ee-898f7031a0eb\"}','2025-06-23 12:20:20',103,'product_updated'),(1350,'App\\Models\\Product',82,'{\"uuid\":\"253d8bc8-d879-463d-91ee-898f7031a0eb\"}','2025-06-23 12:20:20',103,'product_updated'),(1351,'App\\Models\\Product',83,'{\"uuid\":\"8c48ad17-7311-4028-962c-9bf7a504e600\"}','2025-06-23 12:26:24',103,'product_updated'),(1352,'App\\Models\\Product',83,'{\"uuid\":\"8c48ad17-7311-4028-962c-9bf7a504e600\"}','2025-06-23 12:26:24',103,'product_updated'),(1353,'App\\Models\\Product',84,'{\"uuid\":\"58078fb4-8b92-4e67-935f-bb89abd19907\"}','2025-06-23 12:29:50',103,'product_updated'),(1354,'App\\Models\\Product',84,'{\"uuid\":\"58078fb4-8b92-4e67-935f-bb89abd19907\"}','2025-06-23 12:29:50',103,'product_updated'),(1355,'App\\Models\\Product',84,'{\"min_price\":0,\"max_price\":0}','2025-06-23 12:31:04',103,'product_updated'),(1356,'App\\Models\\Product',85,'{\"uuid\":\"698ffd1a-1718-4736-a483-c5a59ccfcb6e\"}','2025-06-23 12:43:21',103,'product_updated'),(1357,'App\\Models\\Product',85,'{\"uuid\":\"698ffd1a-1718-4736-a483-c5a59ccfcb6e\"}','2025-06-23 12:43:21',103,'product_updated'),(1358,'App\\Models\\Product',85,'{\"min_price\":0,\"max_price\":0}','2025-06-24 04:48:35',103,'product_updated'),(1359,'App\\Models\\Product',86,'{\"uuid\":\"90539fcd-6af2-4b27-b1db-27e76ed06ce8\"}','2025-06-24 04:49:50',103,'product_updated'),(1360,'App\\Models\\Product',86,'{\"uuid\":\"90539fcd-6af2-4b27-b1db-27e76ed06ce8\"}','2025-06-24 04:49:50',103,'product_updated'),(1361,'App\\Models\\Product',87,'{\"uuid\":\"84b2c4f8-b3e0-447d-b52e-0244267679b1\"}','2025-06-24 04:53:06',103,'product_updated'),(1362,'App\\Models\\Product',87,'{\"uuid\":\"84b2c4f8-b3e0-447d-b52e-0244267679b1\"}','2025-06-24 04:53:06',103,'product_updated'),(1363,'App\\Models\\Product',87,'{\"min_price\":0,\"max_price\":0}','2025-06-24 04:59:05',103,'product_updated'),(1364,'App\\Models\\Product',87,'{\"status\":\"pending\",\"status_note\":null}','2025-06-24 05:00:35',103,'product_updated'),(1365,'App\\Models\\Product',88,'{\"uuid\":\"3991e55a-3853-4402-9a93-73f9079a4835\"}','2025-06-24 05:16:05',103,'product_updated'),(1366,'App\\Models\\Product',88,'{\"uuid\":\"3991e55a-3853-4402-9a93-73f9079a4835\"}','2025-06-24 05:16:05',103,'product_updated'),(1367,'App\\Models\\Product',88,'{\"min_price\":0,\"max_price\":0}','2025-06-24 05:37:04',103,'product_updated'),(1368,'App\\Models\\Product',89,'{\"uuid\":\"37b4bacf-2334-41bc-b43a-91dcc3a068a9\"}','2025-06-24 05:47:13',103,'product_updated'),(1369,'App\\Models\\Product',89,'{\"uuid\":\"37b4bacf-2334-41bc-b43a-91dcc3a068a9\"}','2025-06-24 05:47:13',103,'product_updated'),(1370,'App\\Models\\Product',89,'{\"min_price\":0,\"max_price\":0}','2025-06-24 05:47:45',103,'product_updated'),(1371,'App\\Models\\Product',89,'{\"min_price\":10,\"max_price\":10}','2025-06-24 05:50:21',103,'product_updated'),(1372,'App\\Models\\Product',89,'{\"min_price\":0,\"max_price\":0}','2025-06-24 06:01:17',103,'product_updated'),(1373,'App\\Models\\Product',89,'{\"min_price\":10,\"max_price\":10}','2025-06-24 06:02:24',103,'product_updated'),(1374,'App\\Models\\Product',89,'{\"min_price\":100,\"max_price\":100}','2025-06-24 06:10:27',103,'product_updated'),(1375,'App\\Models\\Product',89,'{\"min_price\":120,\"max_price\":120}','2025-06-24 06:14:39',103,'product_updated'),(1376,'App\\Models\\Product',89,'{\"min_price\":1,\"max_price\":1}','2025-06-24 06:18:13',103,'product_updated'),(1377,'App\\Models\\Product',89,'{\"status\":\"pending\",\"status_note\":null}','2025-06-24 06:21:13',103,'product_updated'),(1378,'App\\Models\\User',162,'{\"firstname\":\"sunilshetty004\",\"birthday\":\"2025-06-16\",\"ip_address\":\"122.167.174.180\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\"}','2025-06-24 10:08:36',NULL,'user_updated'),(1379,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"verify_token\":\"063499\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\"}','2025-06-24 10:08:36',NULL,'user_updated'),(1380,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"verify_token\":\"759716\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\"}','2025-06-24 10:10:03',NULL,'user_updated'),(1381,'App\\Models\\User',162,'{\"birthday\":\"2025-06-16\",\"verify_token\":\"759803\",\"firebase_token\":\"[\\\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\\\",\\\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\\\",\\\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\\\",\\\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\\\",\\\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\\\",\\\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\\\",\\\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\\\"]\"}','2025-06-24 10:36:15',NULL,'user_updated'),(1382,'App\\Models\\Product',90,'{\"uuid\":\"f91cdb36-55dc-41cf-94b8-b2b86138d16d\"}','2025-06-25 05:34:04',103,'product_updated'),(1383,'App\\Models\\Product',90,'{\"uuid\":\"f91cdb36-55dc-41cf-94b8-b2b86138d16d\"}','2025-06-25 05:34:04',103,'product_updated'),(1384,'App\\Models\\Product',90,'{\"min_price\":0,\"max_price\":0}','2025-06-25 05:36:29',103,'product_updated'),(1385,'App\\Models\\Product',90,'{\"status\":\"pending\",\"status_note\":null}','2025-06-25 05:37:39',103,'product_updated'),(1386,'App\\Models\\Product',91,'{\"uuid\":\"5937670e-394f-490f-b02a-19561bbda672\"}','2025-06-25 05:41:01',103,'product_updated'),(1387,'App\\Models\\Product',91,'{\"uuid\":\"5937670e-394f-490f-b02a-19561bbda672\"}','2025-06-25 05:41:01',103,'product_updated'),(1388,'App\\Models\\Product',90,'{\"tax\":0,\"status_note\":\"\"}','2025-06-25 05:47:34',103,'product_updated'),(1389,'App\\Models\\Product',92,'{\"uuid\":\"ce2315eb-80f2-490a-884e-a746a30ef3d5\"}','2025-06-25 05:51:56',103,'product_updated'),(1390,'App\\Models\\Product',92,'{\"uuid\":\"ce2315eb-80f2-490a-884e-a746a30ef3d5\"}','2025-06-25 05:51:56',103,'product_updated'),(1391,'App\\Models\\Product',93,'{\"uuid\":\"3061b79e-f0fd-4b91-a8d9-a93c44e8ea43\"}','2025-06-25 05:57:21',103,'product_updated'),(1392,'App\\Models\\Product',93,'{\"uuid\":\"3061b79e-f0fd-4b91-a8d9-a93c44e8ea43\"}','2025-06-25 05:57:21',103,'product_updated'),(1393,'App\\Models\\Product',93,'{\"min_price\":0,\"max_price\":0}','2025-06-25 05:58:32',103,'product_updated'),(1394,'App\\Models\\Product',93,'{\"status\":\"pending\",\"status_note\":null}','2025-06-25 06:02:02',103,'product_updated'),(1395,'App\\Models\\Product',92,'{\"min_price\":0,\"max_price\":0}','2025-06-25 06:04:25',103,'product_updated'),(1396,'App\\Models\\Product',94,'{\"uuid\":\"d7eb81ef-19d1-444c-bef4-778125bfe6cd\"}','2025-06-25 06:06:10',103,'product_updated'),(1397,'App\\Models\\Product',94,'{\"uuid\":\"d7eb81ef-19d1-444c-bef4-778125bfe6cd\"}','2025-06-25 06:06:10',103,'product_updated'),(1398,'App\\Models\\Product',94,'{\"min_price\":0,\"max_price\":0}','2025-06-25 06:07:36',103,'product_updated'),(1399,'App\\Models\\Product',95,'{\"uuid\":\"21ff4503-ef01-41e7-9105-054b9f1233d4\"}','2025-06-25 06:19:58',103,'product_updated'),(1400,'App\\Models\\Product',95,'{\"uuid\":\"21ff4503-ef01-41e7-9105-054b9f1233d4\"}','2025-06-25 06:19:58',103,'product_updated'),(1401,'App\\Models\\Product',96,'{\"uuid\":\"f94e0a17-9e98-40bf-92ff-3acb9380c4f4\"}','2025-06-25 06:37:06',103,'product_updated'),(1402,'App\\Models\\Product',96,'{\"uuid\":\"f94e0a17-9e98-40bf-92ff-3acb9380c4f4\"}','2025-06-25 06:37:06',103,'product_updated'),(1403,'App\\Models\\Order',1089,'{\"cart_id\":99,\"shop_id\":501,\"user_id\":175,\"currency_id\":2,\"rate\":1,\"delivery_type\":\"point\",\"delivery_date\":\"2025-06-25 12:30\",\"delivery_point_id\":2,\"type\":1,\"total_price\":0,\"commission_fee\":0,\"note\":null,\"otp\":9299,\"updated_at\":\"2025-06-25 07:00:43\",\"created_at\":\"2025-06-25 07:00:43\",\"id\":1089}','2025-06-25 07:00:43',175,'order_created'),(1404,'App\\Models\\Product',93,'[]','2025-06-25 07:00:43',175,'product_updated'),(1405,'App\\Models\\Order',1089,'{\"type\":\"1\",\"total_price\":0,\"commission_fee\":0,\"service_fee\":null,\"delivery_fee\":null,\"total_discount\":null,\"total_tax\":1}','2025-06-25 07:00:43',175,'order_updated'),(1406,'App\\Models\\User',175,'{\"o_count\":14,\"o_sum\":78790}','2025-06-25 07:00:43',175,'user_updated'),(1407,'App\\Models\\Product',96,'{\"min_price\":0,\"max_price\":0}','2025-06-25 07:13:54',103,'product_updated'),(1408,'App\\Models\\Product',96,'{\"min_price\":2,\"max_price\":2}','2025-06-25 07:14:47',103,'product_updated'),(1409,'App\\Models\\Product',97,'{\"uuid\":\"6e446bcf-5a06-43ee-8b02-f61cdc25def2\"}','2025-06-25 07:21:14',103,'product_updated'),(1410,'App\\Models\\Product',97,'{\"uuid\":\"6e446bcf-5a06-43ee-8b02-f61cdc25def2\"}','2025-06-25 07:21:14',103,'product_updated'),(1411,'App\\Models\\Product',97,'{\"min_price\":0,\"max_price\":0}','2025-06-25 07:22:20',103,'product_updated'),(1412,'App\\Models\\Product',97,'{\"status\":\"pending\",\"status_note\":null}','2025-06-25 07:23:40',103,'product_updated'),(1413,'App\\Models\\Product',98,'{\"uuid\":\"9c06c841-d7aa-43be-87b5-3fa5c19e1f6a\"}','2025-06-25 11:15:34',103,'product_updated'),(1414,'App\\Models\\Product',98,'{\"uuid\":\"9c06c841-d7aa-43be-87b5-3fa5c19e1f6a\"}','2025-06-25 11:15:34',103,'product_updated'),(1415,'App\\Models\\Product',98,'{\"min_price\":0,\"max_price\":0}','2025-06-25 11:16:20',103,'product_updated'),(1416,'App\\Models\\Product',98,'{\"status\":\"pending\",\"status_note\":null}','2025-06-25 11:18:07',103,'product_updated'),(1417,'App\\Models\\User',176,'{\"phone\":\"7259231760\",\"email\":null,\"referral\":null,\"active\":1,\"phone_verified_at\":\"2025-06-25T12:29:07.039222Z\",\"firstname\":\"Anup\",\"lastname\":\"p\",\"gender\":\"male\",\"password\":\"$2y$10$cAzMkY3IyA8q4BUEcuLHYORjVbY\\/.vKlmG7BAaVAQ47DIY2qqBZP2\",\"uuid\":\"2f133541-5dad-4f3a-aafe-813923ecda1b\",\"my_referral\":\"FAGOXRBJ\",\"updated_at\":\"2025-06-25 12:29:07\",\"created_at\":\"2025-06-25 12:29:07\",\"id\":176}','2025-06-25 12:29:07',NULL,'user_created');
/*!40000 ALTER TABLE `model_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `notification_user_notification_id_foreign` (`notification_id`),
  KEY `notification_user_user_id_foreign` (`user_id`),
  CONSTRAINT `notification_user_notification_id_foreign` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notification_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_user` WRITE;
/*!40000 ALTER TABLE `notification_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `notification_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('push') NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`payload`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `notifications_type_unique` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `price` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_coupons_order_id_foreign` (`order_id`),
  CONSTRAINT `order_coupons_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_coupons` WRITE;
/*!40000 ALTER TABLE `order_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_coupons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `stock_id` bigint(20) unsigned NOT NULL,
  `replace_stock_id` bigint(20) unsigned DEFAULT NULL,
  `replace_quantity` int(11) DEFAULT NULL,
  `replace_note` varchar(255) DEFAULT NULL,
  `origin_price` double NOT NULL DEFAULT 0,
  `total_price` double NOT NULL DEFAULT 0,
  `tax` double NOT NULL DEFAULT 0,
  `discount` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `bonus` tinyint(1) NOT NULL DEFAULT 0,
  `note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_details_order_id_foreign` (`order_id`),
  KEY `order_details_stock_id_foreign` (`stock_id`),
  KEY `order_details_replace_stock_id_foreign` (`replace_stock_id`),
  CONSTRAINT `order_details_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_details_replace_stock_id_foreign` FOREIGN KEY (`replace_stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_details_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_details` WRITE;
/*!40000 ALTER TABLE `order_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_refunds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_refunds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('pending','accepted','canceled') NOT NULL DEFAULT 'pending',
  `cause` text DEFAULT NULL,
  `answer` text DEFAULT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_refunds_order_id_foreign` (`order_id`),
  KEY `order_refunds_status_index` (`status`),
  CONSTRAINT `order_refunds_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_refunds` WRITE;
/*!40000 ALTER TABLE `order_refunds` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_refunds` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_status_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_status_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `status` varchar(255) NOT NULL,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`notes`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_status_notes_order_id_foreign` (`order_id`),
  CONSTRAINT `order_status_notes_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_status_notes` WRITE;
/*!40000 ALTER TABLE `order_status_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_status_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `sort` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_statuses` WRITE;
/*!40000 ALTER TABLE `order_statuses` DISABLE KEYS */;
INSERT INTO `order_statuses` VALUES (1,'new',1,1),(2,'accepted',1,2),(3,'ready',1,3),(4,'on_a_way',1,4),(5,'delivered',1,5),(6,'canceled',1,6);
/*!40000 ALTER TABLE `order_statuses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '1' COMMENT 'in_house, seller',
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `deliveryman_id` bigint(20) unsigned DEFAULT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `delivery_price_id` bigint(20) unsigned DEFAULT NULL,
  `delivery_point_id` bigint(20) unsigned DEFAULT NULL,
  `address_id` bigint(20) unsigned DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'new',
  `total_price` double NOT NULL COMMENT 'Сумма с учётом всех налогов и скидок',
  `commission_fee` double NOT NULL,
  `service_fee` double DEFAULT NULL,
  `delivery_fee` double DEFAULT NULL,
  `total_discount` double DEFAULT NULL,
  `total_tax` double NOT NULL DEFAULT 1,
  `rate` double(8,2) NOT NULL DEFAULT 1.00,
  `note` varchar(191) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `delivery_type` varchar(255) NOT NULL DEFAULT 'point',
  `img` varchar(255) DEFAULT NULL,
  `canceled_note` varchar(255) DEFAULT NULL,
  `track_name` varchar(255) DEFAULT NULL,
  `track_id` varchar(255) DEFAULT NULL,
  `track_url` varchar(255) DEFAULT NULL,
  `current` tinyint(1) NOT NULL DEFAULT 0,
  `coupon_price` double DEFAULT NULL,
  `cart_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `otp` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orders_user_id_foreign` (`user_id`),
  KEY `orders_shop_id_foreign` (`shop_id`),
  KEY `orders_parent_id_foreign` (`parent_id`),
  KEY `orders_deliveryman_id_foreign` (`deliveryman_id`),
  KEY `orders_currency_id_foreign` (`currency_id`),
  KEY `orders_delivery_price_id_foreign` (`delivery_price_id`),
  KEY `orders_delivery_point_id_foreign` (`delivery_point_id`),
  KEY `orders_address_id_foreign` (`address_id`),
  CONSTRAINT `orders_address_id_foreign` FOREIGN KEY (`address_id`) REFERENCES `user_addresses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `orders_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_delivery_price_id_foreign` FOREIGN KEY (`delivery_price_id`) REFERENCES `delivery_prices` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_deliveryman_id_foreign` FOREIGN KEY (`deliveryman_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1090 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `page_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `page_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_translations_page_id_locale_unique` (`page_id`,`locale`),
  KEY `page_translations_locale_index` (`locale`),
  CONSTRAINT `page_translations_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `pages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `page_translations` WRITE;
/*!40000 ALTER TABLE `page_translations` DISABLE KEYS */;
INSERT INTO `page_translations` VALUES (1,1,'en','Download Our Shopping App','<p>Experience seamless shopping on the go! Download our app for exclusive deals, faster checkout, and real-time order tracking.</p>');
/*!40000 ALTER TABLE `page_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT 'about',
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `bg_img` varchar(255) DEFAULT NULL,
  `buttons` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`buttons`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'delivery',1,'https://backstore.premfashions.com/storage/images/other/103-17388412067627.webp',NULL,NULL,'2025-02-06 05:57:18','2025-02-06 05:57:18');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_option_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `parcel_option_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parcel_option_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `parcel_option_translations_parcel_option_id_locale_unique` (`parcel_option_id`,`locale`),
  KEY `parcel_option_translations_locale_index` (`locale`),
  CONSTRAINT `parcel_option_translations_parcel_option_id_foreign` FOREIGN KEY (`parcel_option_id`) REFERENCES `parcel_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_option_translations` WRITE;
/*!40000 ALTER TABLE `parcel_option_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_option_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `parcel_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_options` WRITE;
/*!40000 ALTER TABLE `parcel_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_options` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_order_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `parcel_order_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `min_width` smallint(6) NOT NULL DEFAULT 0,
  `min_height` smallint(6) NOT NULL DEFAULT 0,
  `min_length` smallint(6) NOT NULL DEFAULT 0,
  `max_width` smallint(6) NOT NULL DEFAULT 0,
  `max_height` smallint(6) NOT NULL DEFAULT 0,
  `max_length` smallint(6) NOT NULL DEFAULT 0,
  `max_range` int(11) NOT NULL DEFAULT 0,
  `min_g` int(11) NOT NULL DEFAULT 100,
  `max_g` int(11) NOT NULL DEFAULT 100,
  `price` double NOT NULL DEFAULT 0,
  `price_per_km` double NOT NULL DEFAULT 0,
  `special` tinyint(1) NOT NULL DEFAULT 0,
  `special_price` double DEFAULT 0,
  `special_price_per_km` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_order_settings` WRITE;
/*!40000 ALTER TABLE `parcel_order_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_order_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `parcel_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `total_price` double DEFAULT 0 COMMENT 'Сумма с учётом всех налогов и скидок',
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `type_id` bigint(20) unsigned NOT NULL,
  `rate` double(8,2) DEFAULT 1.00,
  `note` varchar(191) DEFAULT NULL,
  `qr_value` varchar(255) DEFAULT NULL,
  `notify` tinyint(1) NOT NULL DEFAULT 0,
  `instruction` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `tax` double DEFAULT 1,
  `status` varchar(255) DEFAULT 'new',
  `address_from` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address_from`)),
  `phone_from` varchar(255) DEFAULT NULL,
  `username_from` varchar(255) DEFAULT NULL,
  `address_to` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address_to`)),
  `phone_to` varchar(255) DEFAULT NULL,
  `username_to` varchar(255) DEFAULT NULL,
  `delivery_fee` double DEFAULT 0,
  `km` double DEFAULT 0,
  `deliveryman_id` bigint(20) unsigned DEFAULT NULL,
  `current` tinyint(1) DEFAULT 0,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parcel_orders_currency_id_foreign` (`currency_id`),
  KEY `parcel_orders_type_id_foreign` (`type_id`),
  KEY `parcel_orders_deliveryman_id_foreign` (`deliveryman_id`),
  CONSTRAINT `parcel_orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `parcel_orders_deliveryman_id_foreign` FOREIGN KEY (`deliveryman_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `parcel_orders_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `parcel_order_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_orders` WRITE;
/*!40000 ALTER TABLE `parcel_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_setting_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `parcel_setting_options` (
  `parcel_option_id` bigint(20) unsigned NOT NULL,
  `parcel_order_setting_id` bigint(20) unsigned NOT NULL,
  KEY `parcel_setting_options_parcel_option_id_foreign` (`parcel_option_id`),
  KEY `parcel_setting_options_parcel_order_setting_id_foreign` (`parcel_order_setting_id`),
  CONSTRAINT `parcel_setting_options_parcel_option_id_foreign` FOREIGN KEY (`parcel_option_id`) REFERENCES `parcel_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `parcel_setting_options_parcel_order_setting_id_foreign` FOREIGN KEY (`parcel_order_setting_id`) REFERENCES `parcel_order_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_setting_options` WRITE;
/*!40000 ALTER TABLE `parcel_setting_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_setting_options` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_payloads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_payloads` (
  `payment_id` bigint(20) unsigned NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`payload`)),
  KEY `payment_payloads_payment_id_foreign` (`payment_id`),
  CONSTRAINT `payment_payloads_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_payloads` WRITE;
/*!40000 ALTER TABLE `payment_payloads` DISABLE KEYS */;
INSERT INTO `payment_payloads` VALUES (8,'{\"razorpay_key\":\"rzp_live_XBttNC8LyaeXsB\",\"razorpay_secret\":\"OYp4et3d3OVcMfCOJudglNs8\",\"currency\":\"INR\",\"sandbox\":0}');
/*!40000 ALTER TABLE `payment_payloads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_process`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_process` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`data`)),
  KEY `payment_process_user_id_foreign` (`user_id`),
  KEY `payment_process_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `payment_process_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_process` WRITE;
/*!40000 ALTER TABLE `payment_process` DISABLE KEYS */;
INSERT INTO `payment_process` VALUES ('plink_QB16C1l7YLKFbW',162,'App\\Models\\Cart',43,'{\"url\":\"https:\\/\\/rzp.io\\/rzp\\/abqqHtU\",\"payment_id\":8,\"model_type\":\"App\\\\Models\\\\Cart\",\"model_id\":43,\"total_price\":317350,\"currency\":\"INR\",\"cart_id\":43,\"user_id\":162,\"status\":\"new\",\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-03-25 17:34\",\"notes\":{\"order\":[]},\"address_id\":35,\"delivery_price_id\":4}'),('plink_QGXruXtdVu1Omz',NULL,'App\\Models\\Cart',44,'{\"url\":\"https:\\/\\/rzp.io\\/rzp\\/IPAppOvT\",\"payment_id\":8,\"model_type\":\"App\\\\Models\\\\Cart\",\"model_id\":44,\"total_price\":302200,\"currency\":\"INR\",\"cart_id\":44,\"user_id\":161,\"status\":\"new\",\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-04-08 16:52\",\"address_id\":33,\"delivery_price_id\":4}'),('plink_QHKC87MaKzPP0u',NULL,'App\\Models\\Wallet',35,'{\"url\":\"https:\\/\\/rzp.io\\/rzp\\/ZUFeYHr1\",\"payment_id\":8,\"model_type\":\"App\\\\Models\\\\Wallet\",\"model_id\":35,\"total_price\":10000,\"currency\":\"INR\"}'),('plink_QhokbhWI3Nmiq9',NULL,'App\\Models\\Cart',60,'{\"url\":\"https:\\/\\/rzp.io\\/rzp\\/HChA2fM\",\"payment_id\":8,\"model_type\":\"App\\\\Models\\\\Cart\",\"model_id\":60,\"total_price\":113411,\"currency\":\"INR\",\"cart_id\":60,\"user_id\":175,\"status\":\"new\",\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-16 14:56\",\"address_id\":46,\"delivery_price_id\":4}'),('plink_QhpLBNItQqjut1',NULL,'App\\Models\\Wallet',38,'{\"url\":\"https:\\/\\/rzp.io\\/rzp\\/NUrVQTU\",\"payment_id\":8,\"model_type\":\"App\\\\Models\\\\Wallet\",\"model_id\":38,\"total_price\":100,\"currency\":\"INR\"}'),('plink_QiHtIxwrmBd3Of',162,'App\\Models\\Wallet',39,'{\"url\":\"https:\\/\\/rzp.io\\/rzp\\/H6oUkKIj\",\"payment_id\":8,\"model_type\":\"App\\\\Models\\\\Wallet\",\"model_id\":39,\"total_price\":100,\"currency\":\"INR\"}'),('plink_QiYJymcmN8Mv4w',162,'App\\Models\\Cart',94,'{\"url\":\"https:\\/\\/rzp.io\\/rzp\\/fTlqBzoc\",\"payment_id\":8,\"model_type\":\"App\\\\Models\\\\Cart\",\"model_id\":94,\"total_price\":1200,\"currency\":\"INR\",\"cart_id\":94,\"user_id\":162,\"status\":\"new\",\"currency_id\":2,\"rate\":1,\"delivery_type\":\"delivery\",\"delivery_date\":\"2025-06-18 11:31\",\"notes\":{\"order\":[]},\"address_id\":58,\"delivery_price_id\":4}');
/*!40000 ALTER TABLE `payment_process` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_to_partners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_to_partners` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'seller',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_to_partners_user_id_foreign` (`user_id`),
  KEY `payment_to_partners_order_id_foreign` (`order_id`),
  CONSTRAINT `payment_to_partners_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payment_to_partners_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_to_partners` WRITE;
/*!40000 ALTER TABLE `payment_to_partners` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_to_partners` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) DEFAULT NULL,
  `input` tinyint(4) NOT NULL DEFAULT 2,
  `sandbox` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'cash',1,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(2,'wallet',2,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:56'),(3,'zain-cash',3,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:52'),(4,'paytabs',4,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:47'),(5,'flutter-wave',5,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:43'),(6,'paystack',6,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:38'),(7,'mercado-pago',7,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:34'),(8,'razorpay',8,0,1,'2024-12-30 00:58:25','2025-03-25 03:38:11'),(9,'stripe',9,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:25'),(10,'paypal',10,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:21'),(11,'moya-sar',11,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:18'),(12,'mollie',12,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:14'),(13,'iyzico',13,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:10'),(14,'maksekeskus',14,0,0,'2024-12-30 00:58:25','2025-02-17 06:17:05');
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payouts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('pending','accepted','canceled') NOT NULL DEFAULT 'pending',
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `approved_by` bigint(20) unsigned DEFAULT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `payment_id` bigint(20) unsigned DEFAULT NULL,
  `cause` varchar(255) DEFAULT NULL,
  `answer` varchar(255) DEFAULT NULL,
  `price` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payouts_created_by_foreign` (`created_by`),
  KEY `payouts_approved_by_foreign` (`approved_by`),
  KEY `payouts_currency_id_foreign` (`currency_id`),
  KEY `payouts_payment_id_foreign` (`payment_id`),
  CONSTRAINT `payouts_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payouts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payouts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payouts_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payouts` WRITE;
/*!40000 ALTER TABLE `payouts` DISABLE KEYS */;
INSERT INTO `payouts` VALUES (1,'pending',107,NULL,2,2,'Payment made to the seller for a purchase.','The seller receives ₹1000 as payment in the selected currency.',1000,'2025-02-05 05:04:37','2025-02-05 05:05:13');
/*!40000 ALTER TABLE `payouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  KEY `personal_access_tokens_tokenable_id_index` (`tokenable_id`),
  KEY `personal_access_tokens_tokenable_type_index` (`tokenable_type`)
) ENGINE=InnoDB AUTO_INCREMENT=425 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
INSERT INTO `personal_access_tokens` VALUES (1,'App\\Models\\User',103,'api_token','bbc58a0154ea0ab765d1c0c296cb38c9cbc00fb06f9c0e7ed1d84e5e07d3ff14','[\"*\"]','2025-01-03 00:48:35','2025-01-02 04:29:53','2025-01-03 00:48:35'),(2,'App\\Models\\User',103,'api_token','1ee505429fcbc33ec987108d41e6a1b6ca31c6861658f07d15654c677c8afe36','[\"*\"]','2025-01-03 00:56:36','2025-01-03 00:39:53','2025-01-03 00:56:36'),(3,'App\\Models\\User',103,'api_token','995c2fb4379ad4816f670383a8cea8cc45c8ce0e9dcae384babbac19fb0df5e7','[\"*\"]','2025-03-10 11:51:19','2025-01-03 00:41:03','2025-03-10 11:51:19'),(6,'App\\Models\\User',103,'api_token','c826e75316e4667d77b40d915d86da8fc15f74ae33136bec7e2c2e0085d10f6f','[\"*\"]','2025-01-22 23:37:58','2025-01-22 04:39:38','2025-01-22 23:37:58'),(7,'App\\Models\\User',102,'api_token','34bdb91ade8f52a8f38caf9e3fa08bfdc4942e3410246a70b15229c47d2bee1b','[\"*\"]','2025-01-28 06:35:03','2025-01-22 07:12:34','2025-01-28 06:35:03'),(8,'App\\Models\\User',103,'api_token','bc939504696be73796ba4fd6c0b8617d859117ed0f17da602cea1c14d7b70925','[\"*\"]','2025-01-27 02:44:13','2025-01-23 01:02:10','2025-01-27 02:44:13'),(9,'App\\Models\\User',103,'api_token','ef7c496b2978d9030bfe49097cdfaf12cb8c474389daf6fc1ddfc87a26176a42','[\"*\"]','2025-02-07 05:26:49','2025-01-28 01:52:30','2025-02-07 05:26:49'),(10,'App\\Models\\User',103,'api_token','0882fe3d1788ed0b4d2dc278923037e8b128e575ef5570b6fe4757e64f67135b','[\"*\"]','2025-02-03 03:07:55','2025-01-28 01:57:29','2025-02-03 03:07:55'),(11,'App\\Models\\User',103,'api_token','77ad40ef22a0f1a6d8f153424fb55ffa885d20aface666786530a57ffad9694b','[\"*\"]','2025-01-28 23:15:23','2025-01-28 02:39:42','2025-01-28 23:15:23'),(13,'App\\Models\\User',103,'api_token','e87053e11f22498d2913f4776bc58f47109311a2ff56319b7e5c7668c04b8f1c','[\"*\"]','2025-02-03 02:45:37','2025-02-03 02:43:55','2025-02-03 02:45:37'),(14,'App\\Models\\User',103,'api_token','1fab35cd5c0b60361b7aa4e95297b0caf1bb489844cda1ecd28e6cdffaa3dee3','[\"*\"]','2025-02-03 02:52:18','2025-02-03 02:51:40','2025-02-03 02:52:18'),(15,'App\\Models\\User',103,'api_token','29a0dd41971364cf57b3038e47baadd33adb74e434e148104e74bab9f79b5b30','[\"*\"]','2025-02-03 02:55:00','2025-02-03 02:53:09','2025-02-03 02:55:00'),(16,'App\\Models\\User',103,'api_token','8bab1e90bc01b31024f4fc4f2d59498754b5280d7584440fc4c906d5219c2525','[\"*\"]','2025-02-03 02:57:49','2025-02-03 02:56:19','2025-02-03 02:57:49'),(18,'App\\Models\\User',103,'api_token','d69ed1d18ab8b5f2ffa2b41d04f675d12dd57d4097fae8302051a3dd3cadd83d','[\"*\"]','2025-02-03 05:32:31','2025-02-03 04:04:21','2025-02-03 05:32:31'),(19,'App\\Models\\User',103,'api_token','2cd0992b092439a3b5ba6f022e9c985d44396f89abccfd081c133f0a7e985a00','[\"*\"]','2025-02-03 07:25:46','2025-02-03 05:33:42','2025-02-03 07:25:46'),(20,'App\\Models\\User',103,'api_token','f33dd60100fd613d39fa940ea7d9bda320f3c7fe2055530629e50ddb020108d8','[\"*\"]','2025-02-03 06:58:27','2025-02-03 05:58:49','2025-02-03 06:58:27'),(21,'App\\Models\\User',103,'api_token','c3dfc8ad7870a59230bb3a95dd21ea5be96baa83504c896bd82690360119e086','[\"*\"]','2025-02-03 06:59:50','2025-02-03 06:59:11','2025-02-03 06:59:50'),(22,'App\\Models\\User',103,'api_token','f16ea0c368c4cea578c42f6296f2ecb13f4706f7815654d680d089bd2b8f4f13','[\"*\"]','2025-02-11 23:31:37','2025-02-03 06:59:59','2025-02-11 23:31:37'),(23,'App\\Models\\User',103,'api_token','48b46bf7fcc97a0544086f07939f01081490dedb72ac0225f62949a02a7271b7','[\"*\"]','2025-02-04 04:17:06','2025-02-04 04:15:01','2025-02-04 04:17:06'),(24,'App\\Models\\User',103,'api_token','8d8462c6e684b3a1973a24032a8a0bd922b2ef99fb29a723b1d0e90b1568b872','[\"*\"]','2025-02-04 06:19:48','2025-02-04 06:19:40','2025-02-04 06:19:48'),(25,'App\\Models\\User',112,'api_token','657a29b90bd90bcba3336353cfa4dc190d68eaf9eebc2501287e2af02df2e01f','[\"*\"]',NULL,'2025-02-04 07:43:26','2025-02-04 07:43:26'),(26,'App\\Models\\User',112,'api_token','5c20fd036c09b6afc86a83c8847b59e36033f1e1f0686f2e0b3e88ff7b148a47','[\"*\"]','2025-02-04 07:45:23','2025-02-04 07:44:01','2025-02-04 07:45:23'),(27,'App\\Models\\User',114,'api_token','2eee9e67de7467ca74d6fe9c1c4ee3dbb954a496c9db621ee7a6ede882976edb','[\"*\"]',NULL,'2025-02-04 07:46:48','2025-02-04 07:46:48'),(28,'App\\Models\\User',114,'api_token','05fb9f5540a4aa919657fd1da4cd8ffa8b2d36c3f03fecb13cb46dfae7638833','[\"*\"]','2025-02-04 07:49:12','2025-02-04 07:47:29','2025-02-04 07:49:12'),(29,'App\\Models\\User',115,'api_token','387f8e4e74707bd806ae7d9beec0f6a431172be39749345ebe709606def3fe3c','[\"*\"]',NULL,'2025-02-04 07:51:08','2025-02-04 07:51:08'),(30,'App\\Models\\User',115,'api_token','495ba69a01c53de69477ce0fa827047af3b1f84b678b28965f620fb0e7853f83','[\"*\"]','2025-02-04 23:40:09','2025-02-04 07:51:44','2025-02-04 23:40:09'),(31,'App\\Models\\User',116,'api_token','9b26e7d598e88ad28e853f489ad5f7a21291626e35aaf23d9202f947f1dd58f9','[\"*\"]','2025-02-05 00:59:56','2025-02-04 23:30:18','2025-02-05 00:59:56'),(32,'App\\Models\\User',113,'api_token','9f4b4d9d3506075adad068b2e57424975a86706433c58db155ab1ba2a361fd41','[\"*\"]',NULL,'2025-02-04 23:58:51','2025-02-04 23:58:51'),(33,'App\\Models\\User',119,'api_token','4a926a5aeee2ee7d03a4cb14fa67f614146f3da9721691a14137f62ddb37e5db','[\"*\"]',NULL,'2025-02-05 00:43:49','2025-02-05 00:43:49'),(34,'App\\Models\\User',119,'api_token','11678a6fcfc153ffa388b1376b53d4c926ce13f246b26e103947ded42010d3f1','[\"*\"]','2025-02-05 01:02:28','2025-02-05 00:44:20','2025-02-05 01:02:28'),(35,'App\\Models\\User',112,'api_token','a530165ded3929eb3a684a04c6dc2b9169184355141faa5832db16ed7b100038','[\"*\"]','2025-02-05 02:18:42','2025-02-05 02:14:27','2025-02-05 02:18:42'),(41,'App\\Models\\User',121,'api_token','c14e4fd75c7881f91fe8af808f7cab0a4da19cbebf3532461a9e97efe5f8acf1','[\"*\"]','2025-02-05 06:52:27','2025-02-05 05:42:56','2025-02-05 06:52:27'),(42,'App\\Models\\User',119,'api_token','0244bf9828b578beedcd2dc33326ca628d50af5dc9d0d748bf864e46f2c85b13','[\"*\"]','2025-02-05 06:40:31','2025-02-05 06:26:57','2025-02-05 06:40:31'),(43,'App\\Models\\User',119,'api_token','b46036898d02d0ba8f40d5d411b7d5ccc4387a8865f526f824ea0b7aa9599abc','[\"*\"]','2025-02-06 00:04:12','2025-02-05 07:36:03','2025-02-06 00:04:12'),(44,'App\\Models\\User',103,'api_token','69330adbf65c6c0649b146042a522ba7d8583c5911eac1797737d0930ad6ee5f','[\"*\"]','2025-04-09 05:07:40','2025-02-05 07:44:14','2025-04-09 05:07:40'),(45,'App\\Models\\User',119,'api_token','dc4625f149ddb6825307fec6d1d3f070ee06dcb3fdfe6cdd81d6fcb6664260d0','[\"*\"]','2025-02-06 01:10:07','2025-02-06 00:05:52','2025-02-06 01:10:07'),(46,'App\\Models\\User',119,'api_token','2046ec56ec215d1f83b16e40f402f9322e11a1f7715a5d6e845b5f5f56e394bd','[\"*\"]','2025-02-07 01:45:08','2025-02-06 01:11:29','2025-02-07 01:45:08'),(47,'App\\Models\\User',115,'api_token','1ff891790e086d06f320d63532a2eded74361f1e34d6481fef66ba5d72d28a1f','[\"*\"]','2025-02-07 05:22:52','2025-02-06 05:38:05','2025-02-07 05:22:52'),(49,'App\\Models\\User',112,'api_token','46237474f95b6a0d9eb58fbb9ab965722c943023cdbabb6fcf253a2e80c82221','[\"*\"]','2025-02-07 00:49:28','2025-02-06 07:33:03','2025-02-07 00:49:28'),(50,'App\\Models\\User',119,'api_token','1ce82b6482ac545a256107c0ff45e577e01a3da01da6a19b991d49195e7f3ba9','[\"*\"]','2025-02-07 01:45:32','2025-02-07 01:45:19','2025-02-07 01:45:32'),(51,'App\\Models\\User',119,'api_token','2d5bb438a4d02e49e24f53a930a3a61c6f5253cf443f00e99775b156addcf2ac','[\"*\"]','2025-02-07 01:48:55','2025-02-07 01:46:50','2025-02-07 01:48:55'),(52,'App\\Models\\User',119,'api_token','19aab923e7cabfde021ad77a61c277a323c1df1588aa842b89985f17ac69c961','[\"*\"]','2025-02-07 01:50:24','2025-02-07 01:49:37','2025-02-07 01:50:24'),(53,'App\\Models\\User',119,'api_token','8f4e05a78a85d8493d1939dd56c8ccbdcb3fe696feb9423a5f6d56de2afacea0','[\"*\"]','2025-02-07 01:53:10','2025-02-07 01:50:46','2025-02-07 01:53:10'),(55,'App\\Models\\User',119,'api_token','79ae531407a16293d7a2be0f66cb00776c8aa25551be608c801e5749e19d720a','[\"*\"]','2025-02-07 01:54:52','2025-02-07 01:53:42','2025-02-07 01:54:52'),(56,'App\\Models\\User',119,'api_token','ac40ceb80ff13196a3f5620e30a976635aa762c3ae32fe2a4b6a2a92d380b49c','[\"*\"]','2025-02-07 01:59:47','2025-02-07 01:55:16','2025-02-07 01:59:47'),(57,'App\\Models\\User',119,'api_token','4cf08cc48ee6ce7c4b4929edfb6c3a644352c1e59fb28b69e4551fbf12443f06','[\"*\"]','2025-02-07 02:01:04','2025-02-07 01:59:59','2025-02-07 02:01:04'),(58,'App\\Models\\User',119,'api_token','52eb22b10fe7b2ff10fa3124831cffdf5a215d5d0cbe7a4a137f3c60bfb75c11','[\"*\"]','2025-02-07 02:02:10','2025-02-07 02:01:30','2025-02-07 02:02:10'),(59,'App\\Models\\User',119,'api_token','62eb3438dfa32c8b2160897626b1a599b7345dffe14711da62b6e5b0ac5ab93a','[\"*\"]','2025-02-07 02:13:49','2025-02-07 02:06:10','2025-02-07 02:13:49'),(60,'App\\Models\\User',119,'api_token','bf0c35c29503cf4eed4b2f37208026106ad40a142a832357ebb19c06b20e64f0','[\"*\"]','2025-02-07 02:23:48','2025-02-07 02:14:04','2025-02-07 02:23:48'),(61,'App\\Models\\User',112,'api_token','acde4f8f818d147ef056a2f4020f94dd5c27655152e68442022f46ed4d05283a','[\"*\"]','2025-02-07 05:29:52','2025-02-07 04:44:00','2025-02-07 05:29:52'),(62,'App\\Models\\User',112,'api_token','36004c431a09ef465166370c6a9abc16965ec3530e6fa57f3d84111debf1ecbf','[\"*\"]','2025-02-07 06:19:39','2025-02-07 05:37:50','2025-02-07 06:19:39'),(63,'App\\Models\\User',103,'api_token','d6343ef98304cbc8e5546324a7cb85e17be4326188134946358c111307743f9d','[\"*\"]','2025-02-09 23:14:45','2025-02-07 05:41:31','2025-02-09 23:14:45'),(65,'App\\Models\\User',103,'api_token','52c375b1a13c4c49cc4fa73a80b69bfcb8e1ca9912a2eccc6f489c5cac4221e4','[\"*\"]','2025-02-09 23:19:12','2025-02-09 23:15:05','2025-02-09 23:19:12'),(66,'App\\Models\\User',103,'api_token','3b3032fd1f1f6379887d436239e4cdd612348db30e175cbcf97a9d1521115fd2','[\"*\"]','2025-02-09 23:59:54','2025-02-09 23:19:30','2025-02-09 23:59:54'),(67,'App\\Models\\User',119,'api_token','ed624e6ef8f2f9ae276c08ff5052145cf4034eff55927e4d1b335d8fc3dd4460','[\"*\"]','2025-02-09 23:43:52','2025-02-09 23:43:45','2025-02-09 23:43:52'),(68,'App\\Models\\User',119,'api_token','97a62190314f4a86286f38d47fc96ab1c859d319e082ff58e70f268a0601a647','[\"*\"]','2025-02-10 00:12:23','2025-02-09 23:57:20','2025-02-10 00:12:23'),(69,'App\\Models\\User',103,'api_token','e526a13fb786657b59f69175facf874e474fc5a0f4b3b261388e05ba11d4777f','[\"*\"]','2025-02-10 00:02:08','2025-02-10 00:00:06','2025-02-10 00:02:08'),(70,'App\\Models\\User',103,'api_token','7af8b2866feab367cf9e3a4c24c08533452a9d3984f41e93513220c3c87eff8f','[\"*\"]','2025-02-14 02:20:39','2025-02-10 00:02:27','2025-02-14 02:20:39'),(71,'App\\Models\\User',119,'api_token','f8a0dcef0217cd7d35b32468c548c852b7462f8fb8c9234c9ba4298f5ee2c93b','[\"*\"]','2025-02-10 00:21:07','2025-02-10 00:14:40','2025-02-10 00:21:07'),(72,'App\\Models\\User',119,'api_token','73fbd52a694a7b2ab3ca27ccff44a7d5c457c18588ae56c99d8ffb6040e8d584','[\"*\"]','2025-02-10 01:17:37','2025-02-10 01:17:25','2025-02-10 01:17:37'),(73,'App\\Models\\User',119,'api_token','8bb475c00563ac43da743602582191bc8a8e1a55ccce6376081ff252887c1446','[\"*\"]','2025-02-10 01:35:29','2025-02-10 01:34:49','2025-02-10 01:35:29'),(74,'App\\Models\\User',119,'api_token','e26d0c63d4e839bd5f7626a50bf926f84e77d8e9e5f0e8d92be22eee9b1bbfd7','[\"*\"]','2025-02-10 03:41:49','2025-02-10 03:41:09','2025-02-10 03:41:49'),(75,'App\\Models\\User',124,'api_token','e0f547bf3dc53515cd7978fa59d6a169386ed0674206ef03ce777e361f080ede','[\"*\"]',NULL,'2025-02-10 03:46:39','2025-02-10 03:46:39'),(76,'App\\Models\\User',124,'api_token','f9742b6631740c3995e7157733922a91435ca2d7c709f1fe80d3c961296383dd','[\"*\"]','2025-02-10 04:02:09','2025-02-10 03:47:55','2025-02-10 04:02:09'),(77,'App\\Models\\User',119,'api_token','c9ea1f1b2e1b4c2f835655d80bfdb8b3259113010d1b3160849e2e11057d0422','[\"*\"]','2025-02-10 04:52:16','2025-02-10 04:46:49','2025-02-10 04:52:16'),(78,'App\\Models\\User',119,'api_token','ed91685aacc596b4cf402bede21d5a8b47fcdebabd3e1334df8a333029bdadd9','[\"*\"]','2025-02-10 04:54:21','2025-02-10 04:53:02','2025-02-10 04:54:21'),(79,'App\\Models\\User',119,'api_token','5776c2368af99252a5bdfc0fdd1ed36febb425ba356db80781fb94172a1eefb4','[\"*\"]','2025-02-10 05:01:55','2025-02-10 04:55:05','2025-02-10 05:01:55'),(80,'App\\Models\\User',112,'api_token','81a2fae7a030952b9e9e97874805846045381c77596047ed254a3217d4718819','[\"*\"]','2025-02-10 05:29:26','2025-02-10 05:08:54','2025-02-10 05:29:26'),(81,'App\\Models\\User',119,'api_token','b99de254caca9eb6600f13ec28fb1c145501ae5aa2d38ebdce6068e02a72f92d','[\"*\"]','2025-02-10 05:12:00','2025-02-10 05:09:59','2025-02-10 05:12:00'),(82,'App\\Models\\User',112,'api_token','5ae7a9b5d25db815c71ff00b23d32d8957784904f8183f33476f659b17b06875','[\"*\"]','2025-02-10 06:05:51','2025-02-10 05:32:57','2025-02-10 06:05:51'),(83,'App\\Models\\User',119,'api_token','39307a063fa9557c28fb2ea87f65b9557b6fc29ab7e0d81baacd2b74d7b750c0','[\"*\"]','2025-02-10 05:51:10','2025-02-10 05:49:28','2025-02-10 05:51:10'),(84,'App\\Models\\User',119,'api_token','21e4a5faf3b07fc7c07fc13ca0d93f408ff70a8de3338160892ba10699605459','[\"*\"]','2025-02-10 05:58:19','2025-02-10 05:51:24','2025-02-10 05:58:19'),(85,'App\\Models\\User',119,'api_token','3d9731bf9573f236c769503e2673097cb37c21349d2fb6627aa8ac6f0edd1d62','[\"*\"]','2025-02-10 06:32:00','2025-02-10 06:29:34','2025-02-10 06:32:00'),(86,'App\\Models\\User',119,'api_token','b8ad303e1c38131b43961ea80ba9880b6b6a74474f63012f4d6cd4d6896f7eab','[\"*\"]','2025-02-10 06:35:06','2025-02-10 06:32:09','2025-02-10 06:35:06'),(87,'App\\Models\\User',119,'api_token','cd2ee666b6902437433c607f6a428ba89e6772ef8f7a4e70bd3dde3d420cfc88','[\"*\"]','2025-02-10 06:47:22','2025-02-10 06:35:17','2025-02-10 06:47:22'),(88,'App\\Models\\User',119,'api_token','d838509f1b1f96e48a889f2850b0f2ba011afeb5bea4bff9cf49b8f9f0494225','[\"*\"]','2025-02-10 06:53:51','2025-02-10 06:47:39','2025-02-10 06:53:51'),(89,'App\\Models\\User',119,'api_token','14ff2ba60c643c74fe762ba846ed2714e3fedb1e524aceea1d599ed56759f4e8','[\"*\"]','2025-02-10 06:58:06','2025-02-10 06:55:15','2025-02-10 06:58:06'),(90,'App\\Models\\User',119,'api_token','07fa4bc6a867d7e6cb8376b8041af70387dfc5e96b2d74dfd350d77c94240381','[\"*\"]','2025-02-10 07:07:12','2025-02-10 06:58:26','2025-02-10 07:07:12'),(91,'App\\Models\\User',119,'api_token','c14124edd89bcd5df0cab9f881702d9351f7eebe45fc1c970ba75740cd1cd6e3','[\"*\"]','2025-02-10 07:11:42','2025-02-10 07:11:12','2025-02-10 07:11:42'),(92,'App\\Models\\User',119,'api_token','30d1bd20a98b2a7982ad0e4d4226b0e990f23de8709901f32e5399e596d92bbc','[\"*\"]','2025-02-10 07:13:21','2025-02-10 07:11:53','2025-02-10 07:13:21'),(93,'App\\Models\\User',119,'api_token','262abac6157734d7f984290996af079555533869cb19010694a8c290a740f2af','[\"*\"]','2025-02-10 07:16:35','2025-02-10 07:13:33','2025-02-10 07:16:35'),(94,'App\\Models\\User',119,'api_token','8d4b6d52f418d07ae6f29d05a2d1bf48719856d91d7817ea0c3273f7565c06c9','[\"*\"]','2025-02-10 07:18:29','2025-02-10 07:16:47','2025-02-10 07:18:29'),(95,'App\\Models\\User',119,'api_token','54ba1b9ce4d36a8f8f739b8f753be899e501993e5b19a9249d85215a0e7f9a74','[\"*\"]','2025-02-10 08:03:41','2025-02-10 07:18:47','2025-02-10 08:03:41'),(96,'App\\Models\\User',119,'api_token','821044e8fdaea2843910fc22c954667aba266158284bef8fe6aab13cff7097d9','[\"*\"]','2025-02-10 09:03:51','2025-02-10 08:54:58','2025-02-10 09:03:51'),(97,'App\\Models\\User',112,'api_token','3534ada044536c62d2b3d4f8da64f4dd87f5fab21ad96980b3856c9148a5ceac','[\"*\"]','2025-02-10 23:59:06','2025-02-10 23:55:04','2025-02-10 23:59:06'),(98,'App\\Models\\User',112,'api_token','7e4c598bb356c6a39144dadaf420a15ceb8da9a3cbd17b6a34de69f644f60fcd','[\"*\"]','2025-02-11 00:32:39','2025-02-11 00:02:50','2025-02-11 00:32:39'),(99,'App\\Models\\User',119,'api_token','e9ddbfaed04f782037a2589a36e59b37c715867c859948f343d5a561627ec848','[\"*\"]','2025-02-11 00:07:10','2025-02-11 00:06:08','2025-02-11 00:07:10'),(100,'App\\Models\\User',119,'api_token','e07b0eb6472ebc2aec7d5c1d9ada7d3fa0c38a8179e297c7b76e26d20a434b68','[\"*\"]','2025-02-11 00:10:17','2025-02-11 00:09:20','2025-02-11 00:10:17'),(101,'App\\Models\\User',119,'api_token','7d45661f903972930e325040599160017a3568e8f01ffd2bcbdc5fc74306e8c5','[\"*\"]','2025-02-11 00:17:31','2025-02-11 00:14:14','2025-02-11 00:17:31'),(102,'App\\Models\\User',119,'api_token','0e1b49c8e7aae197ec3e33d3641be262c5fdee7a8b2ccacf371503a09d114cef','[\"*\"]','2025-02-11 00:28:03','2025-02-11 00:17:47','2025-02-11 00:28:03'),(103,'App\\Models\\User',119,'api_token','89ba196c39da2fd86eda9870b331755fb506f4147e60f5577cbeaddf9c5a1fb0','[\"*\"]','2025-02-11 00:33:51','2025-02-11 00:33:29','2025-02-11 00:33:51'),(104,'App\\Models\\User',119,'api_token','d28c8aa27c4196809badd4122c5b7339ab9a546ec32c0803f879e7a2eaeb8060','[\"*\"]','2025-02-11 00:34:27','2025-02-11 00:34:02','2025-02-11 00:34:27'),(105,'App\\Models\\User',119,'api_token','a45c813235a253f1f854427551a9ad9a215b88fc1c153540306a42b127ba4683','[\"*\"]','2025-02-11 00:35:32','2025-02-11 00:34:45','2025-02-11 00:35:32'),(106,'App\\Models\\User',112,'api_token','de17eeb128a81cde5e060d03023d22ac6d52e4d39647ff43c9841cbd3ae56837','[\"*\"]','2025-02-11 00:47:36','2025-02-11 00:35:04','2025-02-11 00:47:36'),(107,'App\\Models\\User',119,'api_token','95b90bb56786ef1c25c2fb5af15e661826637ab110e38dbaab9118786a20e1fe','[\"*\"]','2025-02-11 00:43:18','2025-02-11 00:35:50','2025-02-11 00:43:18'),(108,'App\\Models\\User',112,'api_token','3a2dcb01d6be7190415b032551272891f99952915cbed65a64716f1a7ad3db60','[\"*\"]','2025-02-11 01:39:14','2025-02-11 00:49:57','2025-02-11 01:39:14'),(109,'App\\Models\\User',119,'api_token','8adc309fd925b137ff9e68394b73851e4d46a5377ef932754aadd14476af3a71','[\"*\"]','2025-02-11 00:53:35','2025-02-11 00:51:43','2025-02-11 00:53:35'),(110,'App\\Models\\User',119,'api_token','893543d41ef0466d27c286bc1f85d48a599b9be24e43bfd89ec3b12371988b81','[\"*\"]','2025-02-11 00:55:00','2025-02-11 00:53:45','2025-02-11 00:55:00'),(111,'App\\Models\\User',119,'api_token','cba9d399fbc4af2da16f6c09911fdc28791d9341fcb212137cc0bc2c7bdae4d5','[\"*\"]','2025-02-11 00:57:39','2025-02-11 00:56:10','2025-02-11 00:57:39'),(112,'App\\Models\\User',119,'api_token','18be34f5121e35ba6f404dd72da278feb5577973198284a6b56becd528c77ec5','[\"*\"]','2025-02-11 01:08:24','2025-02-11 01:07:32','2025-02-11 01:08:24'),(113,'App\\Models\\User',119,'api_token','67efc8f6a185d10d0d3732d134765ae8070f774fe6218fc49a930576f74d3759','[\"*\"]','2025-02-11 01:13:42','2025-02-11 01:13:20','2025-02-11 01:13:42'),(114,'App\\Models\\User',119,'api_token','3a877283c8cfeec7960e8050140c1a78c358c282694c7fd04e48b8aa883d7347','[\"*\"]','2025-02-11 01:15:06','2025-02-11 01:13:50','2025-02-11 01:15:06'),(115,'App\\Models\\User',119,'api_token','c6f26c30d121707cd72561766d1e916a2b7ea2f7eafdd372e135c985598ef00c','[\"*\"]','2025-02-11 01:17:58','2025-02-11 01:15:33','2025-02-11 01:17:58'),(116,'App\\Models\\User',119,'api_token','1bb8565b16a2caf8286509e66301ab6d8cc44be15d44c977017566eeb2e5de7a','[\"*\"]','2025-02-11 01:19:27','2025-02-11 01:18:34','2025-02-11 01:19:27'),(117,'App\\Models\\User',119,'api_token','77203a6fe978417b7cce124f338dd14ee80a809852909827ffb344502a6111b2','[\"*\"]','2025-02-11 01:19:47','2025-02-11 01:19:38','2025-02-11 01:19:47'),(118,'App\\Models\\User',119,'api_token','e561747352c2fd46ccdddadf2ce47be878cbe20968e47f87509210f32641f09d','[\"*\"]','2025-02-11 01:20:36','2025-02-11 01:20:15','2025-02-11 01:20:36'),(119,'App\\Models\\User',119,'api_token','49d16d86c9a44016bf86e0081c0ce9f7824d89d712e61f47f11f53929f39298c','[\"*\"]','2025-02-11 01:29:35','2025-02-11 01:20:49','2025-02-11 01:29:35'),(120,'App\\Models\\User',119,'api_token','e05470775268d4a3e1b52d4f372a3afe7bf92d9dcee219ffd430c979c5c98367','[\"*\"]','2025-02-11 01:29:58','2025-02-11 01:29:50','2025-02-11 01:29:58'),(121,'App\\Models\\User',119,'api_token','58bd6ec12afe4889101219773c33193c2212393d6aae20273ab52eb8aaba538b','[\"*\"]','2025-02-11 01:33:33','2025-02-11 01:30:14','2025-02-11 01:33:33'),(122,'App\\Models\\User',119,'api_token','9f71f90f31aec0e02c0d1a829a0dd6b0439142f03de4fc819b42fede7c0362da','[\"*\"]','2025-02-11 01:40:58','2025-02-11 01:35:22','2025-02-11 01:40:58'),(123,'App\\Models\\User',119,'api_token','ba08dd9fa5e3dbe9f7550608d404abc883c83b1dc94486ba38cb17c471c71c92','[\"*\"]','2025-02-11 01:54:55','2025-02-11 01:41:09','2025-02-11 01:54:55'),(124,'App\\Models\\User',112,'api_token','1663314eb8827569a8a4c8b1f1c8bed6815a3e2ff464deb57ebee355a25f87c0','[\"*\"]','2025-02-12 01:33:12','2025-02-11 01:42:54','2025-02-12 01:33:12'),(125,'App\\Models\\User',119,'api_token','edef2041a6d46577a826ae5fd1f4ebd053bb3dd8403ee23713161d802b49c105','[\"*\"]','2025-02-11 01:55:16','2025-02-11 01:55:13','2025-02-11 01:55:16'),(126,'App\\Models\\User',119,'api_token','231c6a0b65f5499a130ef35d04813949dfb954e6c5996820f5cce91953f9007d','[\"*\"]','2025-02-11 01:56:42','2025-02-11 01:56:06','2025-02-11 01:56:42'),(127,'App\\Models\\User',119,'api_token','1b1b7cf124a045db47390a2d5fdd492402a556cf2c678ea65a3805fffe0ff2fb','[\"*\"]','2025-02-11 04:05:36','2025-02-11 01:56:57','2025-02-11 04:05:36'),(128,'App\\Models\\User',119,'api_token','60e3d17994a82ae42db1512e5420368ea4d8db411a615e5ee3fdf85879be1a53','[\"*\"]','2025-02-11 04:06:05','2025-02-11 04:05:49','2025-02-11 04:06:05'),(129,'App\\Models\\User',119,'api_token','6c5bcf4498179959b41bb288ca9ca9354706563282d1b6637b4f7dabffd123ab','[\"*\"]','2025-02-11 07:05:58','2025-02-11 04:08:41','2025-02-11 07:05:58'),(130,'App\\Models\\User',115,'api_token','c5cb6f3ab7f1e8de479d7f82a7563052f6d0e1c1c58b91599d1705db5fd337bd','[\"*\"]','2025-02-11 06:31:38','2025-02-11 04:38:34','2025-02-11 06:31:38'),(131,'App\\Models\\User',119,'api_token','4ce7a1c06e3fda2173a49e4ab046b1cc903bd68ce5f9ce0b6ccbe9faba3c7602','[\"*\"]','2025-02-11 07:14:05','2025-02-11 07:06:14','2025-02-11 07:14:05'),(132,'App\\Models\\User',119,'api_token','4a528c3aa19d3b0d20c471685605f60a25848fbba56b8103d80525dfdcce0581','[\"*\"]','2025-02-11 07:39:54','2025-02-11 07:14:31','2025-02-11 07:39:54'),(133,'App\\Models\\User',119,'api_token','cc1ed7ab4e8f4979fc3ab1faf20f3f9f8fca48cb91e052aae845e3bc29b18a99','[\"*\"]','2025-02-11 07:40:50','2025-02-11 07:40:47','2025-02-11 07:40:50'),(134,'App\\Models\\User',119,'api_token','65264ee42147fbc853097901f60d107d38dfc6c52764ed42cb765c9a04700e5b','[\"*\"]','2025-02-11 07:41:12','2025-02-11 07:41:08','2025-02-11 07:41:12'),(135,'App\\Models\\User',119,'api_token','8807991648cccd3a2e5a64e46bbabd6c5ab97691bdcbee922c1655eeda7543cd','[\"*\"]','2025-02-11 07:47:08','2025-02-11 07:41:49','2025-02-11 07:47:08'),(136,'App\\Models\\User',119,'api_token','f27c879fc6fb511f68936c8f274055ebb4ccb1a321dc9fb2408718716d633e46','[\"*\"]','2025-02-11 23:28:55','2025-02-11 07:47:40','2025-02-11 23:28:55'),(137,'App\\Models\\User',119,'api_token','de4f72d6dd3e7248b99ca47b411a899399455640a4c5434e14dfc1308ac6b352','[\"*\"]','2025-02-11 23:50:06','2025-02-11 23:29:14','2025-02-11 23:50:06'),(138,'App\\Models\\User',103,'api_token','dfbe2c0a609bc8fb95cab201a7266be8102dfd3a84a195a1002b180f25fb8677','[\"*\"]','2025-02-12 23:34:47','2025-02-11 23:31:51','2025-02-12 23:34:47'),(139,'App\\Models\\User',119,'api_token','cfc8aa368bf5a6e586f35c37cb08d7bd18eaaae196bd3d9a3e22df38f87588fc','[\"*\"]','2025-02-11 23:51:05','2025-02-11 23:50:56','2025-02-11 23:51:05'),(140,'App\\Models\\User',124,'api_token','4f3501f41a02ab2b47fbc6b294ca4fa45726c4d9601fbc5ceee0420273a7a07d','[\"*\"]','2025-02-12 01:53:09','2025-02-11 23:52:01','2025-02-12 01:53:09'),(141,'App\\Models\\User',112,'api_token','24e96ef4b2d651e86f6add2bcb1734ad6e4b6fa45b699d6ff4a04ea6de26c173','[\"*\"]','2025-02-12 23:29:21','2025-02-12 00:10:26','2025-02-12 23:29:21'),(144,'App\\Models\\User',119,'api_token','c0f2a1e830300651714988ba9186563f646633b39987f782e370da372dd0b7b6','[\"*\"]','2025-02-12 01:53:35','2025-02-12 01:53:27','2025-02-12 01:53:35'),(145,'App\\Models\\User',119,'api_token','6566937a035790ea9f4e85db1e4d259630040ff9405e3659ded00b2790559a00','[\"*\"]','2025-02-12 01:59:07','2025-02-12 01:53:48','2025-02-12 01:59:07'),(146,'App\\Models\\User',119,'api_token','3ceb77e4ccac32ec8cd1443555fdc657e0bd98eed502d443fa2141136fa46d26','[\"*\"]','2025-02-12 02:16:13','2025-02-12 01:59:34','2025-02-12 02:16:13'),(148,'App\\Models\\User',119,'api_token','c8b67483b0a069a82c9f9df2e4c4c8c30f5afd957da0017c81a5dde96dcf6d91','[\"*\"]','2025-02-12 03:47:43','2025-02-12 02:24:22','2025-02-12 03:47:43'),(151,'App\\Models\\User',119,'api_token','5f73a9c7f1233414a1a519520c9eab61af0f33c1c5ddfb4934f0e6971d717b3d','[\"*\"]','2025-02-12 23:31:03','2025-02-12 03:48:07','2025-02-12 23:31:03'),(153,'App\\Models\\User',112,'api_token','11b48543cf9b257d7eaa4d96864d511ddfacc5d17a2d4aa0c7929537f636ad32','[\"*\"]','2025-02-13 00:08:58','2025-02-12 23:30:18','2025-02-13 00:08:58'),(154,'App\\Models\\User',119,'api_token','87080fd2692ded032bffc32b358b387e2ef220b0f91d128765223867b248d005','[\"*\"]','2025-02-12 23:41:01','2025-02-12 23:39:33','2025-02-12 23:41:01'),(155,'App\\Models\\User',119,'api_token','0dcf4e198f348cc09324017e7e7d2e177315e68168d9f794fa879ffb11d8dd59','[\"*\"]','2025-02-13 00:03:47','2025-02-13 00:02:34','2025-02-13 00:03:47'),(156,'App\\Models\\User',119,'api_token','f8901a22b5ee4a9ffcac92be05c5e54970eeca33982cb793ebb0f82df5d42537','[\"*\"]','2025-02-13 00:06:13','2025-02-13 00:06:08','2025-02-13 00:06:13'),(158,'App\\Models\\User',119,'api_token','b47c88259bd76b294fadb60bb7d2d382a4c015643aca604663d3a72e26fb59a8','[\"*\"]','2025-02-13 00:33:37','2025-02-13 00:09:05','2025-02-13 00:33:37'),(159,'App\\Models\\User',112,'api_token','c25071a05b63149051f7b9512cc6f8692cf093e6f420ef975807537183a60a0e','[\"*\"]','2025-02-13 01:14:22','2025-02-13 01:13:45','2025-02-13 01:14:22'),(160,'App\\Models\\User',112,'api_token','245b98ba670368c7a97506bea7b7d7733b794789336afa3ad41d6f985c4094f0','[\"*\"]','2025-02-13 06:55:34','2025-02-13 01:15:16','2025-02-13 06:55:34'),(163,'App\\Models\\User',119,'api_token','0efad187cc2dc38245b844b873fad944fb7c866ad38f4af59ebd094aca29c6a2','[\"*\"]','2025-02-13 04:09:35','2025-02-13 04:07:37','2025-02-13 04:09:35'),(164,'App\\Models\\User',119,'api_token','3a179e251dce17dad2862e818957ad7c064bf54fdcb025d39027b65dad172e2b','[\"*\"]','2025-02-13 04:41:30','2025-02-13 04:09:46','2025-02-13 04:41:30'),(165,'App\\Models\\User',119,'api_token','a11d4c45041ca4d529ac1d08dfdf4c5030aeb4ad816c3084ed12832e509bec1c','[\"*\"]','2025-02-13 04:42:33','2025-02-13 04:42:13','2025-02-13 04:42:33'),(166,'App\\Models\\User',119,'api_token','98441a2ac10bbfd8b6c5a41df7056eb2f01dde8d82977d1c0a1deb46e6761ef5','[\"*\"]','2025-02-13 23:43:35','2025-02-13 04:42:51','2025-02-13 23:43:35'),(167,'App\\Models\\User',119,'api_token','4511893449c0d5aa6b44f82ca7305bc69e5267f66570505cf5419fcc57a97986','[\"*\"]','2025-02-14 01:08:26','2025-02-14 01:08:07','2025-02-14 01:08:26'),(168,'App\\Models\\User',131,'api_token','8836396b719d27d436d77dc62acbf2f3bc5b6d8cb6985f93a4564d7a16c9d286','[\"*\"]',NULL,'2025-02-14 01:09:29','2025-02-14 01:09:29'),(169,'App\\Models\\User',131,'api_token','41c08ea70d8de87ce019a39fb24adb0bae1de47b3c83a15e22995ef2b2b86b7e','[\"*\"]','2025-02-14 01:13:38','2025-02-14 01:12:38','2025-02-14 01:13:38'),(170,'App\\Models\\User',119,'api_token','1b09010f13b502a2dc3efbac2c1df98e196e88270a13238384ba7901ecbab5ff','[\"*\"]','2025-02-16 23:41:16','2025-02-16 23:32:26','2025-02-16 23:41:16'),(171,'App\\Models\\User',119,'api_token','e502b030845769b0eaa4ba0bf05099fb16f3d8b36e9f97da346f8ced051666df','[\"*\"]','2025-02-17 00:56:29','2025-02-17 00:55:29','2025-02-17 00:56:29'),(172,'App\\Models\\User',119,'api_token','cee79493101eb7c99b2ec1e7fd51db17e22c57687b5ffeb402903345cd808fdf','[\"*\"]','2025-02-17 01:01:34','2025-02-17 00:56:56','2025-02-17 01:01:34'),(173,'App\\Models\\User',119,'api_token','49339c17b192430e45bd950771f05254c65064f26b39429e20eb85e582fbe42c','[\"*\"]','2025-02-17 01:19:51','2025-02-17 01:16:34','2025-02-17 01:19:51'),(175,'App\\Models\\User',107,'api_token','7eb315aecc9ddd94e539e377f00a112f11f1f8ca62efea0c26a43f83dfb61004','[\"*\"]','2025-02-18 01:33:48','2025-02-17 01:57:19','2025-02-18 01:33:48'),(176,'App\\Models\\User',107,'api_token','0daa4a48ed1d14ce313c36784b7240ab2d998a6e46cdf5eb2914f3af5b861ceb','[\"*\"]','2025-02-17 07:43:28','2025-02-17 02:00:40','2025-02-17 07:43:28'),(178,'App\\Models\\User',119,'api_token','b0d32385875554e204961b9b31916bf5869653f11134b491a8f2004f6c6bf07b','[\"*\"]','2025-02-17 05:01:52','2025-02-17 04:47:06','2025-02-17 05:01:52'),(180,'App\\Models\\User',103,'api_token','ece1cb0173ffaa0637f72617fad83ccef6ff6aab6ea31e43c828918d23035b40','[\"*\"]','2025-05-05 06:37:16','2025-02-17 05:25:47','2025-05-05 06:37:16'),(181,'App\\Models\\User',119,'api_token','e173190629ff49c27093a7957d8bcabdb2b283dfca59f6c3035311546ac46a3d','[\"*\"]','2025-02-17 05:44:57','2025-02-17 05:44:49','2025-02-17 05:44:57'),(182,'App\\Models\\User',119,'api_token','a0f053f3fa1bda3bb77597b03c905b2c6c0a7272350bea86477edb18849d5bcf','[\"*\"]','2025-02-17 05:49:31','2025-02-17 05:49:22','2025-02-17 05:49:31'),(183,'App\\Models\\User',119,'api_token','7047c2da87c4afb9ed3da8f6d982f96a230593020ccba8bcdff1d7ee4ac2bb4c','[\"*\"]','2025-02-17 05:53:23','2025-02-17 05:53:15','2025-02-17 05:53:23'),(184,'App\\Models\\User',119,'api_token','e36ff675e0a62e3c35d9504144423e32a4e589fc66fa992185053a87422d89ac','[\"*\"]','2025-02-17 06:11:47','2025-02-17 06:09:37','2025-02-17 06:11:47'),(185,'App\\Models\\User',103,'api_token','60bf3c9b7be18b2bd0316feadc0e00e7f99a03945da3ff7f5098d4f3e4ddf026','[\"*\"]','2025-05-05 06:26:33','2025-02-17 06:16:49','2025-05-05 06:26:33'),(186,'App\\Models\\User',119,'api_token','18bdd4fe39395f308d984a29e0f8aa015c300c64b3c8990615f1c03f38822744','[\"*\"]','2025-02-17 06:24:53','2025-02-17 06:24:44','2025-02-17 06:24:53'),(187,'App\\Models\\User',119,'api_token','8d33d3457d125ed680645c130425761a9b0711e5a360f447ae08533bfc90f1e0','[\"*\"]','2025-02-17 06:32:31','2025-02-17 06:32:24','2025-02-17 06:32:31'),(188,'App\\Models\\User',107,'api_token','b6d6e6e4999a0f7605140a9deb72ec716a6936ec558a900343307cc972c37747','[\"*\"]','2025-02-27 05:28:07','2025-02-17 07:47:38','2025-02-27 05:28:07'),(189,'App\\Models\\User',119,'api_token','9b70f2ae9fab3351ad3d5f80133854eaa1939fb689818a11b8d5938fbefe82d9','[\"*\"]','2025-02-17 23:46:43','2025-02-17 23:46:31','2025-02-17 23:46:43'),(190,'App\\Models\\User',103,'api_token','66264c8b8d7b409ed3371402d0ef6e697740a7f618b57b0176cd875d8e558e7f','[\"*\"]','2025-02-18 23:20:44','2025-02-18 01:27:27','2025-02-18 23:20:44'),(191,'App\\Models\\User',119,'api_token','8a3ab009fa25b7fe0755b5d574130ef750b044f93fa72fdc4bbe5edd230ecf44','[\"*\"]','2025-02-18 03:50:08','2025-02-18 03:49:54','2025-02-18 03:50:08'),(192,'App\\Models\\User',119,'api_token','edd352034fd9385374ef71430c3f0f36c96c3e384cde404d410a838231bf6f28','[\"*\"]','2025-02-18 05:53:09','2025-02-18 04:11:35','2025-02-18 05:53:09'),(194,'App\\Models\\User',119,'api_token','feba0035fac55bfef587162ec84ff26ef3595d38573c96e23ecf96e650ae8049','[\"*\"]','2025-02-18 05:54:45','2025-02-18 05:53:28','2025-02-18 05:54:45'),(195,'App\\Models\\User',119,'api_token','e73a4c711f89b2e23d168828ee330d2ad23dd7e8fb0a408e01f6252b4e903035','[\"*\"]','2025-02-18 05:58:23','2025-02-18 05:55:04','2025-02-18 05:58:23'),(196,'App\\Models\\User',131,'api_token','1aa54e6703f5036d3ab521d57bc106abddc0f5337d9a8bd3683ebf4cb595c3c4','[\"*\"]','2025-02-18 07:18:16','2025-02-18 06:01:08','2025-02-18 07:18:16'),(197,'App\\Models\\User',112,'api_token','e5b28f2f5375e99bfb4118327d7f7808e95f387b15308544b06dc01bee2cc7c3','[\"*\"]',NULL,'2025-02-27 05:28:38','2025-02-27 05:28:38'),(198,'App\\Models\\User',112,'api_token','4afde41b54444a546ba287d9a6c189cb6a4171e643c97b1169486bca275b6bd9','[\"*\"]',NULL,'2025-02-27 05:28:44','2025-02-27 05:28:44'),(199,'App\\Models\\User',112,'api_token','d6926f97ad2966c03c169fefc7ed68b2f80fd542b2a663c1ace93e972e77e766','[\"*\"]',NULL,'2025-02-27 05:29:17','2025-02-27 05:29:17'),(200,'App\\Models\\User',107,'api_token','37317d7af4e2684b7155f0b235a31bbaafd4a5031adf17f5563fc64b1435a87e','[\"*\"]','2025-02-27 05:30:12','2025-02-27 05:29:51','2025-02-27 05:30:12'),(201,'App\\Models\\User',138,'api_token','4285a4636ce15e852cd3fb77e0125ab3c7e53a6e9d6b306243d29eb8e356fb46','[\"*\"]',NULL,'2025-02-28 05:18:13','2025-02-28 05:18:13'),(207,'App\\Models\\User',119,'api_token','e85e59887cd1c9e1d6a45222e1eb12e43dbdaf484555479d8d32b01c6fa775e7','[\"*\"]','2025-03-03 08:27:07','2025-03-03 08:26:58','2025-03-03 08:27:07'),(208,'App\\Models\\User',119,'api_token','9f7f0e0f6f8dc86b2609ed8f5dbfff0b282020816a6330cf7924be0fdf1e5223','[\"*\"]','2025-03-03 23:59:56','2025-03-03 23:54:37','2025-03-03 23:59:56'),(209,'App\\Models\\User',119,'api_token','d709c843aa5d5b28bd57bd16d65bb7d44bccbdaae6ab9aff3874e8080f728e32','[\"*\"]',NULL,'2025-03-04 04:25:54','2025-03-04 04:25:54'),(210,'App\\Models\\User',119,'api_token','4f734061526d585db5b239a321af62f76527b2b28448fe6f955f9c5b3ab3be75','[\"*\"]',NULL,'2025-03-04 04:26:28','2025-03-04 04:26:28'),(211,'App\\Models\\User',143,'api_token','9c232f218f4e06ca118a9ce2621c12b010008ce163c31361927402197b5daf6d','[\"*\"]','2025-03-04 05:00:55','2025-03-04 05:00:34','2025-03-04 05:00:55'),(212,'App\\Models\\User',119,'api_token','aa00a6d188dd1d4bd55a62857786d4e14111cd09d95fd40445159e3f3f975653','[\"*\"]',NULL,'2025-03-04 05:32:30','2025-03-04 05:32:30'),(213,'App\\Models\\User',143,'api_token','8c3d5414793e4b731f2ef9169970a0ffb59aa3cc083b53ae0102d124c4226f29','[\"*\"]',NULL,'2025-03-04 05:38:21','2025-03-04 05:38:21'),(214,'App\\Models\\User',119,'api_token','cfc6ff05d636d8378862ccac95b4b492fea1a56497d01b71329bde5db6bf76c6','[\"*\"]','2025-03-04 05:41:31','2025-03-04 05:41:20','2025-03-04 05:41:31'),(215,'App\\Models\\User',143,'api_token','2d0b170f0a830097bfb6c54083e9fcb173c655e1857c8e8fdb53980af1f8cc1f','[\"*\"]','2025-03-04 05:45:05','2025-03-04 05:44:53','2025-03-04 05:45:05'),(216,'App\\Models\\User',119,'api_token','23110bffb154e8a992e451993d243cdced7192478f58d22322a9a1fad989c18a','[\"*\"]','2025-03-04 05:48:05','2025-03-04 05:45:24','2025-03-04 05:48:05'),(217,'App\\Models\\User',119,'api_token','1fc5390be59f7260e1f4a11674de0beaa706202587b7e583a13851d14800a142','[\"*\"]','2025-03-04 05:48:46','2025-03-04 05:48:30','2025-03-04 05:48:46'),(218,'App\\Models\\User',143,'api_token','aee086edc0050b65316117cf95fddd3b365edf4df7250e7952c6267e26f13a1b','[\"*\"]','2025-03-04 05:49:23','2025-03-04 05:49:18','2025-03-04 05:49:23'),(219,'App\\Models\\User',143,'api_token','b5e893b1082faa54967e1443f1a9e743a225e2ece4b8e41ad1bb4c662d3b5d3b','[\"*\"]','2025-03-04 05:50:44','2025-03-04 05:50:34','2025-03-04 05:50:44'),(220,'App\\Models\\User',119,'api_token','784b20eaec88cdcbec61f7fcf395fe0b935b3b5cbd57197f99b5734500bb11e3','[\"*\"]','2025-03-04 05:51:36','2025-03-04 05:51:27','2025-03-04 05:51:36'),(221,'App\\Models\\User',119,'api_token','82f13a947d19728db8cc84587d1b326614a40bc90cb99ebbe4cd08be15eeea35','[\"*\"]','2025-03-04 07:10:50','2025-03-04 07:10:39','2025-03-04 07:10:50'),(222,'App\\Models\\User',143,'api_token','9cac364ce0e2055e3f3429c302ca4f29da3873226378535c6a81e8617366cdd9','[\"*\"]','2025-03-04 07:12:45','2025-03-04 07:11:41','2025-03-04 07:12:45'),(223,'App\\Models\\User',143,'api_token','610b6991087cbef1434fd5e1a566ae00774de6cfd2ebaa54a9224605056f803e','[\"*\"]','2025-03-04 23:35:26','2025-03-04 07:23:13','2025-03-04 23:35:26'),(224,'App\\Models\\User',144,'api_token','affe4dd1fd0800d9310b99da3e745f55db0fa023c3361f4c9f575f4e3724850b','[\"*\"]','2025-03-05 04:24:13','2025-03-05 04:24:01','2025-03-05 04:24:13'),(225,'App\\Models\\User',145,'api_token','147979782b5e89d6e01f006e0ed3c27ce7870f41104f46e91ad254401063b5bb','[\"*\"]','2025-03-05 06:06:26','2025-03-05 06:06:11','2025-03-05 06:06:26'),(226,'App\\Models\\User',145,'api_token','ca8d106c06f7b3c4e532b9d92182e6238d0f3a7726b4dc26f76bdc463972426a','[\"*\"]','2025-03-05 06:07:15','2025-03-05 06:07:10','2025-03-05 06:07:15'),(227,'App\\Models\\User',119,'api_token','5dfca32b5897d80fb7e7470acef6f741b9d64146456c03bbb301f82962afe5e1','[\"*\"]','2025-03-05 08:41:20','2025-03-05 08:40:52','2025-03-05 08:41:20'),(228,'App\\Models\\User',146,'api_token','4be1c36f1931f4c4750f2341ef804f7b84888de6662dd50fc903d52ee6462bcf','[\"*\"]','2025-03-05 08:52:52','2025-03-05 08:52:33','2025-03-05 08:52:52'),(229,'App\\Models\\User',119,'api_token','ad637bf21287b98e72344be0161da671d28b3f38493a17fff2d4bc4e5e35a2ce','[\"*\"]','2025-03-05 09:23:33','2025-03-05 09:23:32','2025-03-05 09:23:33'),(230,'App\\Models\\User',119,'api_token','ba508b4ba0b822baa308ec7ca7a6ef1d9f1796eb6407e5f5242c7a600f4107f5','[\"*\"]','2025-03-05 09:27:57','2025-03-05 09:27:27','2025-03-05 09:27:57'),(231,'App\\Models\\User',142,'api_token','478e265cf0ae6057148f877f1c3364db7ee9611b466155ad1527dbe7a13a277f','[\"*\"]',NULL,'2025-03-05 12:57:48','2025-03-05 12:57:48'),(232,'App\\Models\\User',147,'api_token','d2c4ac89ad1e108126d4360aef6e8a58cb628c6359c619827241224fedb05d6c','[\"*\"]',NULL,'2025-03-05 13:19:14','2025-03-05 13:19:14'),(233,'App\\Models\\User',148,'api_token','09915846023d3e23784234a0218818364f4ee6ff3e33dd139865185ecd7a05c7','[\"*\"]','2025-03-05 13:27:02','2025-03-05 13:26:49','2025-03-05 13:27:02'),(234,'App\\Models\\User',148,'api_token','ba5965acc34a2df25644982cb3ffd1c4e1bc4cb103822c36c08f08123a51410f','[\"*\"]','2025-03-05 13:27:30','2025-03-05 13:27:26','2025-03-05 13:27:30'),(235,'App\\Models\\User',119,'api_token','a2a523f9e6d9050f4ee18d2516b675973736e26f2adb4cf783401e448e4ac44e','[\"*\"]','2025-03-05 13:29:40','2025-03-05 13:29:19','2025-03-05 13:29:40'),(236,'App\\Models\\User',150,'api_token','98c4dd6305a162e5db4919b4b2017054e5a55199510aaff1bd817b4fe72da490','[\"*\"]',NULL,'2025-03-05 14:25:22','2025-03-05 14:25:22'),(237,'App\\Models\\User',150,'api_token','5e08ee90f3d3354d47c98883061d1326f1e93afefdf187a2e95d31ce90e3e579','[\"*\"]','2025-03-05 14:28:18','2025-03-05 14:28:17','2025-03-05 14:28:18'),(238,'App\\Models\\User',151,'api_token','af9760ccd9fcf953b398fe9003f02f2b72a2dbb9b89cccfd8edc3bef535d8193','[\"*\"]',NULL,'2025-03-05 14:50:25','2025-03-05 14:50:25'),(239,'App\\Models\\User',151,'api_token','ef26546a2ad78287a6c4f342293315c5a516053587097cc35bfd152eb985c9dc','[\"*\"]','2025-03-06 01:00:22','2025-03-05 14:51:02','2025-03-06 01:00:22'),(240,'App\\Models\\User',119,'api_token','ed5cbd224e578df2daafb8b2237ad67b4fad34128e218b505c50afabd2f6fb1e','[\"*\"]','2025-03-05 23:33:50','2025-03-05 23:33:15','2025-03-05 23:33:50'),(241,'App\\Models\\User',119,'api_token','1e9b68ced955e49b0957dfa337163214ecff932608484053f322c9a3d176a14e','[\"*\"]','2025-03-05 23:52:26','2025-03-05 23:52:25','2025-03-05 23:52:26'),(242,'App\\Models\\User',119,'api_token','1e4b78f04f32912cd7f36349d699df9d37158a79f885249acbea2024a2e46050','[\"*\"]','2025-03-06 00:07:33','2025-03-06 00:07:32','2025-03-06 00:07:33'),(243,'App\\Models\\User',119,'api_token','b5a6faafa15a14c1d6658ad7473fb1aec8ff4e6733a8c6244df7b9e987993d0b','[\"*\"]','2025-03-06 00:14:17','2025-03-06 00:14:16','2025-03-06 00:14:17'),(244,'App\\Models\\User',119,'api_token','312fad17345c8728c6959c3c376bb01bc31a308a222d116613e7eb524d4c3590','[\"*\"]','2025-03-06 00:33:51','2025-03-06 00:23:52','2025-03-06 00:33:51'),(245,'App\\Models\\User',119,'api_token','d8b5885256e5802c1f8e7e017ea7e2d06c5acb65b6d10756322185b911141143','[\"*\"]','2025-03-06 00:34:50','2025-03-06 00:34:30','2025-03-06 00:34:50'),(246,'App\\Models\\User',119,'api_token','541bbaedbd8c5de48fd16911aa603d2e37502a6b8a8a8f915f33375e6f3136f0','[\"*\"]','2025-03-06 01:40:35','2025-03-06 01:40:34','2025-03-06 01:40:35'),(247,'App\\Models\\User',119,'api_token','77260277d670fd9469644db96ee069192d707daf831c027923f60bb7efca2ac7','[\"*\"]','2025-03-06 01:48:28','2025-03-06 01:48:27','2025-03-06 01:48:28'),(248,'App\\Models\\User',144,'api_token','2e506fb55b30bd6f08b411e9015085e9adbdee1f3a78952716df05c4ac1d117c','[\"*\"]',NULL,'2025-03-06 02:10:40','2025-03-06 02:10:40'),(249,'App\\Models\\User',119,'api_token','629bf5fb9dc26a376b5da2f14f38d31ba4ef4cef6325bbbd4fde3b8978c853bd','[\"*\"]','2025-03-06 02:25:03','2025-03-06 02:17:31','2025-03-06 02:25:03'),(250,'App\\Models\\User',119,'api_token','d8d0deb17d04a0c3a10610c04753e3e51d72d3fa0199920416393d6047ee04ea','[\"*\"]','2025-03-06 02:38:40','2025-03-06 02:38:03','2025-03-06 02:38:40'),(251,'App\\Models\\User',119,'api_token','ef3977de037def6cd15c62d6b8210f43e827d6131f7c1c6cd77134bf7bbc15b8','[\"*\"]','2025-03-06 03:50:47','2025-03-06 03:41:46','2025-03-06 03:50:47'),(252,'App\\Models\\User',119,'api_token','fc72c7e9276f2ae0497c634daa7103167676cc6de8db619b158d4b2a8c6aa386','[\"*\"]','2025-03-06 03:51:37','2025-03-06 03:51:18','2025-03-06 03:51:37'),(253,'App\\Models\\User',119,'api_token','9658c04eccbbb3c8e749e99e7b2c911c3169abd8a9a7160fa510817577ad5b9d','[\"*\"]','2025-03-06 06:18:42','2025-03-06 03:53:00','2025-03-06 06:18:42'),(254,'App\\Models\\User',143,'api_token','d2122e86f42a6663e8a951c747c587eb273e9d13c4b0c78dceca501884bf3785','[\"*\"]',NULL,'2025-03-06 06:18:15','2025-03-06 06:18:15'),(255,'App\\Models\\User',144,'api_token','a768a532c71df4a99b0a9abebbff89ef9d39d75c6f223d9d0a806ee130717f78','[\"*\"]',NULL,'2025-03-06 06:19:54','2025-03-06 06:19:54'),(256,'App\\Models\\User',144,'api_token','5202eeba344c91214813345e880ee2d8bed70fd56a9a7c801bb6e63401b8d207','[\"*\"]',NULL,'2025-03-06 06:20:59','2025-03-06 06:20:59'),(257,'App\\Models\\User',144,'api_token','2c8573cc3016a1da5818a8e8d39ea522ea926e3caa96d6aca445a4f9adb4d9a5','[\"*\"]','2025-03-06 06:22:49','2025-03-06 06:22:38','2025-03-06 06:22:49'),(258,'App\\Models\\User',119,'api_token','afe0f9fdf1203c4c329c12e297cae1a018d8276e3b27690b97f21e528ce4c19d','[\"*\"]','2025-03-06 06:38:51','2025-03-06 06:38:30','2025-03-06 06:38:51'),(259,'App\\Models\\User',153,'api_token','594e6fe8e0e0d3137d0a7cbc66c1ec366a23d9dc6440e11c00ab42a2245c2c4c','[\"*\"]','2025-03-06 23:53:03','2025-03-06 23:52:51','2025-03-06 23:53:03'),(260,'App\\Models\\User',152,'api_token','7adcce883bcd6663f6dcc7e633eb2fcba75b6ea688f36ae13c68a9cac35ed096','[\"*\"]',NULL,'2025-03-06 23:54:05','2025-03-06 23:54:05'),(261,'App\\Models\\User',154,'api_token','c5b01fdd8da1800cbf6e2ac876ea9e47d5fe1da7a50afcf651c6f6a2dc42f95d','[\"*\"]',NULL,'2025-03-07 00:09:20','2025-03-07 00:09:20'),(262,'App\\Models\\User',155,'api_token','0a6ceb5e7189dfe7b84e4405303a8971553d37c93198ecfb38e4168cffe4dc01','[\"*\"]','2025-03-07 00:14:10','2025-03-07 00:13:54','2025-03-07 00:14:10'),(263,'App\\Models\\User',155,'api_token','79e925697a563a850b16eceaa701633409312ff3aed8b581749e11242861c6ba','[\"*\"]','2025-03-07 00:15:16','2025-03-07 00:15:04','2025-03-07 00:15:16'),(264,'App\\Models\\User',156,'api_token','b3e2ac804698298c0163b5fe23fea15c57103e23b50329a2ee29d87c33806172','[\"*\"]',NULL,'2025-03-07 00:21:23','2025-03-07 00:21:23'),(265,'App\\Models\\User',119,'api_token','2a4fe4ce8cd1efeeb1f42693158232776706b96e707c12aa1d217176c96e42f2','[\"*\"]','2025-03-07 01:00:18','2025-03-07 00:59:56','2025-03-07 01:00:18'),(266,'App\\Models\\User',119,'api_token','2b6cedb01d16134e5b21f3f1818066c5ed0f54b8626b1331adbfff5104e97fc2','[\"*\"]','2025-03-24 23:38:36','2025-03-24 23:38:35','2025-03-24 23:38:36'),(267,'App\\Models\\User',155,'api_token','0e02ac4721c52ebee4f83f94cd7a1bb1f30de162737c3a141e38b89e4d38d199','[\"*\"]','2025-03-24 23:40:47','2025-03-24 23:40:27','2025-03-24 23:40:47'),(268,'App\\Models\\User',157,'api_token','6aa811e525f42df765c4f38f98e660dd491e8cbd517cb950600a23dd00e8fd7c','[\"*\"]','2025-03-24 23:43:07','2025-03-24 23:42:39','2025-03-24 23:43:07'),(269,'App\\Models\\User',157,'api_token','b1524b62414c1179318ec051b6354a47d89a3fe42cb972b3bb9ac76c3eeeda00','[\"*\"]','2025-03-24 23:43:36','2025-03-24 23:43:30','2025-03-24 23:43:36'),(270,'App\\Models\\User',157,'api_token','9c90f4e441856fa63f4ca947ec9dffdaaf98e868e4a26197ad2f040a66a19bf6','[\"*\"]',NULL,'2025-03-24 23:45:38','2025-03-24 23:45:38'),(271,'App\\Models\\User',157,'api_token','70598c0700d6c94ba21a72c2164ec6904b5be6a813ca9a564bc21f6ec6bd7149','[\"*\"]','2025-03-24 23:46:17','2025-03-24 23:46:13','2025-03-24 23:46:17'),(272,'App\\Models\\User',157,'api_token','a1c296c6ca37c95873f44a53355840ac5103f97ad8de7a0a4679ac1ad5e41aad','[\"*\"]','2025-03-25 02:18:01','2025-03-24 23:55:45','2025-03-25 02:18:01'),(273,'App\\Models\\User',159,'api_token','7435c7413aa3422fc9f94a5bc1328439bad33c51174ece3178f12da68564787d','[\"*\"]','2025-03-25 03:01:24','2025-03-25 03:00:10','2025-03-25 03:01:24'),(274,'App\\Models\\User',160,'api_token','f1e8cc35cbf03239ce0cd944e7925fe5431414755d7c87ac8bdd88f4b52283fd','[\"*\"]',NULL,'2025-03-25 03:02:06','2025-03-25 03:02:06'),(275,'App\\Models\\User',160,'api_token','e88fe2e3c8e772a8a3c009bbc493db6e182bb50a26f300e82e49d8410ec60c2f','[\"*\"]','2025-03-25 03:02:47','2025-03-25 03:02:39','2025-03-25 03:02:47'),(276,'App\\Models\\User',161,'api_token','116267be84259b7dff5289f462cb8da3e32eb2e8a0f718380dc3485ca9da7a83','[\"*\"]',NULL,'2025-03-25 03:04:10','2025-03-25 03:04:10'),(277,'App\\Models\\User',156,'api_token','41ec265609fea790239d48db706537f369b0e4b520ff4e7a9b1fb4b54e7c24d6','[\"*\"]',NULL,'2025-03-25 03:05:24','2025-03-25 03:05:24'),(278,'App\\Models\\User',161,'api_token','9212382e383691b7d6c2f3b75622aee7d5ecf89eb8fa560b92ec7a6809d41cc4','[\"*\"]','2025-03-26 23:02:15','2025-03-25 03:05:41','2025-03-26 23:02:15'),(279,'App\\Models\\User',162,'api_token','c7d7e3f870fd5dfd116b77251ec59c807900f12361cbd85fe7458688b2f0414a','[\"*\"]',NULL,'2025-03-25 03:41:28','2025-03-25 03:41:28'),(280,'App\\Models\\User',162,'api_token','9baf6b02f23d00a24395874163f3a794afdd6f3ac59f1468b9d0ef3d30120072','[\"*\"]','2025-03-26 23:30:48','2025-03-25 03:41:53','2025-03-26 23:30:48'),(281,'App\\Models\\User',164,'api_token','4d52d8ed2202d660923c1bbade7fa89df1a1662f156737e1c6613d03d5421bb8','[\"*\"]',NULL,'2025-03-25 04:04:09','2025-03-25 04:04:09'),(282,'App\\Models\\User',164,'api_token','bd6db65e47386ca103222034ff52d55514ebce0edab2b5caeba8c0ef07652eb9','[\"*\"]','2025-03-25 04:11:22','2025-03-25 04:04:41','2025-03-25 04:11:22'),(283,'App\\Models\\User',164,'api_token','ecb004691f47b7f1afb8b8d84a694d63ddf3a1844252eab6d01e3194bf6da01e','[\"*\"]',NULL,'2025-03-25 04:09:40','2025-03-25 04:09:40'),(284,'App\\Models\\User',165,'api_token','3bd0c73a9a3b90836634e9435c8bb35b390acfd7fe2f42ca95ef5609ef922a12','[\"*\"]',NULL,'2025-03-25 04:12:56','2025-03-25 04:12:56'),(285,'App\\Models\\User',165,'api_token','4379962b6cfd50da7b9048b04ebfd4966b88fbd15508cd34fe42a7b220794f72','[\"*\"]','2025-03-25 04:14:16','2025-03-25 04:13:54','2025-03-25 04:14:16'),(286,'App\\Models\\User',165,'api_token','2b684e7e7ed848610634ffdaa3b35eb5ac577ddbf24072335611856c5377ccfb','[\"*\"]','2025-03-25 05:43:29','2025-03-25 04:14:58','2025-03-25 05:43:29'),(287,'App\\Models\\User',165,'api_token','966159bc0ee555428fdd4f81c0febf43eba82e55686d864036d709b46304bc8f','[\"*\"]','2025-03-25 04:27:41','2025-03-25 04:22:53','2025-03-25 04:27:41'),(288,'App\\Models\\User',119,'api_token','10bc37da81748e9a9010a3e1ca127707e993c4f5585d7b012f92148dd24d196f','[\"*\"]','2025-03-25 23:04:57','2025-03-25 04:29:02','2025-03-25 23:04:57'),(290,'App\\Models\\User',103,'api_token','9b452bdc7eb18b38a692109c4c56678318a350cfb613e88f1e9d07b9340e3394','[\"*\"]','2025-03-25 06:01:37','2025-03-25 05:08:22','2025-03-25 06:01:37'),(291,'App\\Models\\User',103,'api_token','92044ec19fc9f607b52615094edfca59ce9b0e03ac92f1844b3b77181e0ed6c8','[\"*\"]','2025-03-25 06:01:53','2025-03-25 05:23:07','2025-03-25 06:01:53'),(292,'App\\Models\\User',103,'api_token','63643bed96a2a5396a2fac29544dd42e73df871c2d3e22fbe55a5682fd6de15c','[\"*\"]','2025-03-26 00:53:50','2025-03-26 00:53:00','2025-03-26 00:53:50'),(293,'App\\Models\\User',162,'api_token','feeaaeecb4fb1d20d473917a68403be5ea0a6e262056e206778531c92a69c3b3','[\"*\"]','2025-03-26 06:26:39','2025-03-26 01:22:09','2025-03-26 06:26:39'),(294,'App\\Models\\User',162,'api_token','2c53492667790e9c8d8d00a09c3a2f475258876adb5ad3a545872495d71b09f7','[\"*\"]',NULL,'2025-03-26 01:22:46','2025-03-26 01:22:46'),(295,'App\\Models\\User',103,'api_token','84c1c48f4b3c3b26b39f6dbe4eed73261207d92ac2830b6b04f3b461c4be7436','[\"*\"]','2025-04-08 05:50:49','2025-04-08 05:50:43','2025-04-08 05:50:49'),(296,'App\\Models\\User',161,'api_token','03f59433257f57689b9ec0fe954b830ac5677f704f1398d95e13ce1b86f05886','[\"*\"]','2025-04-09 23:40:12','2025-04-08 05:51:17','2025-04-09 23:40:12'),(297,'App\\Models\\User',161,'api_token','e9705d1366b3fd4d9f5bf7e4b4a20a161662ad68149ec1d1777783b4c35009b3','[\"*\"]','2025-04-10 05:35:17','2025-04-08 07:04:35','2025-04-10 05:35:17'),(298,'App\\Models\\User',155,'api_token','3b08cad1715ad26ee23f11a4c959b9e9a0f00d82afe34cf9625b406a3995b41e','[\"*\"]','2025-04-08 07:44:29','2025-04-08 07:44:15','2025-04-08 07:44:29'),(299,'App\\Models\\User',119,'api_token','2879896987bbe61a532d96e14d4f708fccb9155afbd4590c4ce2bdd7955ec1f5','[\"*\"]','2025-04-08 07:45:15','2025-04-08 07:45:04','2025-04-08 07:45:15'),(300,'App\\Models\\User',103,'api_token','32abf366ec9677a8422f9266b21432b069baa907de1dbe5e8ce9a13b373624de','[\"*\"]','2025-04-09 04:31:31','2025-04-09 04:31:19','2025-04-09 04:31:31'),(301,'App\\Models\\User',103,'api_token','ee975ebf9288609230778bb5157a1e7bcccabc5433b562be2fa545de8464b3f9','[\"*\"]','2025-04-09 04:33:26','2025-04-09 04:33:17','2025-04-09 04:33:26'),(302,'App\\Models\\User',157,'api_token','db09bb9a374271394886b20455384bff4ef3f6cb8ed6fd2a29bcc7d44bc8cde4','[\"*\"]',NULL,'2025-04-09 04:37:46','2025-04-09 04:37:46'),(303,'App\\Models\\User',157,'api_token','7e8ce5eee8114d6d492fb9b5fc078d42ea1f062769b753bf71489e3a5afc4bc7','[\"*\"]','2025-04-09 04:38:20','2025-04-09 04:38:15','2025-04-09 04:38:20'),(304,'App\\Models\\User',103,'api_token','9f67891a3f582be5622b765d530471b4d2a7af1e3b975b97049c127eb3ac1946','[\"*\"]','2025-04-09 06:39:31','2025-04-09 06:39:02','2025-04-09 06:39:31'),(305,'App\\Models\\User',155,'api_token','06ff254f70954e3cdee73be13c6cd3f5ea628d104e2efc5609a2cdaf8fd2594f','[\"*\"]','2025-04-09 06:39:55','2025-04-09 06:39:51','2025-04-09 06:39:55'),(306,'App\\Models\\User',155,'api_token','898c99a58ca0a7ccd3e4a7bbe7eafc0a7e73afe8e309b7b090c6c1bec11ca025','[\"*\"]','2025-04-09 06:42:42','2025-04-09 06:40:00','2025-04-09 06:42:42'),(307,'App\\Models\\User',157,'api_token','d5aeeccd8fd1be4c693075a43f9cb05f71c2de94dea55bb748fc4c1cf3abb348','[\"*\"]','2025-04-09 06:44:03','2025-04-09 06:41:18','2025-04-09 06:44:03'),(308,'App\\Models\\User',103,'api_token','3e88f33e1485a7dcac71fbc18221b7474babf98d25624572e3f1c0d255ad4502','[\"*\"]','2025-04-09 06:44:47','2025-04-09 06:44:13','2025-04-09 06:44:47'),(309,'App\\Models\\User',157,'api_token','16b8ab4791a53723da38ac9f0cf1f32b0a25948c04587ab667a8b3d600d2413c','[\"*\"]',NULL,'2025-04-09 23:34:53','2025-04-09 23:34:53'),(310,'App\\Models\\User',157,'api_token','c179774bda38a2e4c97ba27d88f80b7128526f60423acd7dc977f3c49aa76c37','[\"*\"]','2025-04-09 23:36:02','2025-04-09 23:35:21','2025-04-09 23:36:02'),(311,'App\\Models\\User',157,'api_token','74fe80f912924ee7e96f585c28941ecff947780b70d64731dd308b3090f1bd09','[\"*\"]',NULL,'2025-04-09 23:36:57','2025-04-09 23:36:57'),(312,'App\\Models\\User',157,'api_token','e272271ea4559accca5a3b8e81da222ae7726584b662201d9ac42ee6555d6c8c','[\"*\"]','2025-04-09 23:56:23','2025-04-09 23:37:20','2025-04-09 23:56:23'),(313,'App\\Models\\User',167,'api_token','71492a93500e796e942aa59a502742f2dbfff96fb882c84ef15b1fe3ed28ec96','[\"*\"]','2025-04-10 00:16:27','2025-04-10 00:16:00','2025-04-10 00:16:27'),(314,'App\\Models\\User',168,'api_token','2637756d7f8da112f786886c38a3a086995c9165e65fa96563101e9131e5fb44','[\"*\"]','2025-04-10 01:00:57','2025-04-10 01:00:42','2025-04-10 01:00:57'),(315,'App\\Models\\User',169,'api_token','619c1d5a92ae7d925f132e0512e82c04e352ad891b7bec10f5bfbb91ecd4cdeb','[\"*\"]','2025-04-10 01:16:59','2025-04-10 01:16:22','2025-04-10 01:16:59'),(316,'App\\Models\\User',157,'api_token','dc911e207356e87468af1c9eafa377695646cccbe17ea89ec30b9485e45b01b8','[\"*\"]',NULL,'2025-04-10 01:19:56','2025-04-10 01:19:56'),(317,'App\\Models\\User',169,'api_token','34bc01b27a5c01db255d7a05ab81792df2a377af5d3eed6152111ec7f3ceedf4','[\"*\"]',NULL,'2025-04-10 01:32:03','2025-04-10 01:32:03'),(318,'App\\Models\\User',169,'api_token','5adae92fe5afba7b26f8ce6446f3bc64ba8768d35e4230485a4d1034db281f7e','[\"*\"]','2025-04-10 01:33:38','2025-04-10 01:32:27','2025-04-10 01:33:38'),(319,'App\\Models\\User',170,'api_token','b5b3989df29e36685b45dfce214c9312d4312d8a8940f612131d1a0773a601a1','[\"*\"]','2025-04-10 02:20:51','2025-04-10 02:07:19','2025-04-10 02:20:51'),(320,'App\\Models\\User',171,'api_token','4aedbcb0b8673adb19b05331b881e72fd229c184410b69f0fb245a855cb947ad','[\"*\"]',NULL,'2025-04-10 04:52:35','2025-04-10 04:52:35'),(321,'App\\Models\\User',171,'api_token','4dce8ce6c130ce063ed7246a05dc899925db72a27e26fbd5d60a251bbb216394','[\"*\"]','2025-04-10 08:03:52','2025-04-10 04:53:07','2025-04-10 08:03:52'),(322,'App\\Models\\User',171,'api_token','5d8c7a6e503880043de5fba5f1a5fa8708fdecf89b6c175089c426c93fe2a304','[\"*\"]','2025-04-10 06:04:19','2025-04-10 04:57:48','2025-04-10 06:04:19'),(323,'App\\Models\\User',162,'api_token','84a1651cbb146a88aa87de3f420a6ab160342fffe15805fed5386434c8e33374','[\"*\"]','2025-04-10 07:28:17','2025-04-10 05:47:52','2025-04-10 07:28:17'),(324,'App\\Models\\User',157,'api_token','951dfeec8e7370e5f91ba4e35debf97069fec3291ffc1ccf2b34f07fb4334bcb','[\"*\"]',NULL,'2025-04-11 00:02:01','2025-04-11 00:02:01'),(325,'App\\Models\\User',157,'api_token','d188a6cd20f78354db552adec09918f03e2c547d9b2986703a27a671d75ddb1c','[\"*\"]','2025-04-11 04:10:31','2025-04-11 00:02:22','2025-04-11 04:10:31'),(326,'App\\Models\\User',162,'api_token','3c35b38a0a4cc4db7e61347e169b28ff4c25659f219f85166e1ae4676efe3610','[\"*\"]','2025-04-27 23:38:12','2025-04-21 04:08:46','2025-04-27 23:38:12'),(327,'App\\Models\\User',107,'api_token','ae07610eab8e63a9b300ed28267af3222afe846afba0261ad9550d81ba29ce00','[\"*\"]','2025-05-05 06:39:10','2025-05-05 06:31:17','2025-05-05 06:39:10'),(328,'App\\Models\\User',107,'api_token','9d987cb32fceb5b396048676500f9131e7ff8659729a0bdbc5527330b9b991a4','[\"*\"]','2025-05-05 06:41:32','2025-05-05 06:37:31','2025-05-05 06:41:32'),(329,'App\\Models\\User',103,'api_token','ce679b3f45f2644bb71b583871104e59934aa54631de319ca792a253b8254a1e','[\"*\"]','2025-05-09 02:08:30','2025-05-05 06:39:18','2025-05-09 02:08:30'),(330,'App\\Models\\User',103,'api_token','a11ae03f48f6f34d419a61910096444d8d78706bddd394c2418c704f741a8708','[\"*\"]','2025-05-05 06:43:25','2025-05-05 06:41:48','2025-05-05 06:43:25'),(331,'App\\Models\\User',107,'api_token','53042ecbad5ae2dcb7f45351ad34c6652480f83d025c600ac079f065cedd93f5','[\"*\"]','2025-05-09 01:26:57','2025-05-05 06:43:43','2025-05-09 01:26:57'),(332,'App\\Models\\User',103,'api_token','e9c6b9a3d32d3872755d3623e52ae342966d4d78409246639ad6aeab140801c3','[\"*\"]','2025-05-09 01:46:01','2025-05-09 01:27:12','2025-05-09 01:46:01'),(333,'App\\Models\\User',107,'api_token','8d42a5f57cf6fe5e4a6bc82f4d501bdba38a47fea8f1a5f98b7dfa30cb866571','[\"*\"]','2025-05-09 01:58:53','2025-05-09 01:46:07','2025-05-09 01:58:53'),(334,'App\\Models\\User',107,'api_token','c3b2811d2b0d7fd6dbcd18662aad5d60698d94d206e5e8645f6dcc947f252cef','[\"*\"]','2025-05-09 01:59:32','2025-05-09 01:59:02','2025-05-09 01:59:32'),(335,'App\\Models\\User',103,'api_token','b85a813c77c878bede4ea26bcc01ea879b947af99d25427ba0f287787d96d480','[\"*\"]','2025-05-12 05:35:29','2025-05-09 01:59:39','2025-05-12 05:35:29'),(336,'App\\Models\\User',162,'api_token','4a5471e71707d7c1e0888ff38f7eab3ac2336619ac4f876440f9095c0cd5220b','[\"*\"]','2025-05-09 02:05:18','2025-05-09 02:03:56','2025-05-09 02:05:18'),(337,'App\\Models\\User',162,'api_token','8194dc61237e34f454c4275fa2b81afaf8534ba216bf403cefc1f6d1fae0d6e7','[\"*\"]','2025-05-09 02:05:56','2025-05-09 02:05:55','2025-05-09 02:05:56'),(338,'App\\Models\\User',162,'api_token','0d95c685f97c739591736dcfb419b24bd889e7356c1d820eae60a206007ae414','[\"*\"]','2025-05-09 02:12:52','2025-05-09 02:06:01','2025-05-09 02:12:52'),(339,'App\\Models\\User',107,'api_token','da607975e5a9674742530dd3757df1314a960227562d9affc08672dcd01395e5','[\"*\"]','2025-05-12 07:49:54','2025-05-09 02:08:52','2025-05-12 07:49:54'),(340,'App\\Models\\User',172,'api_token','7043d56854630f877505010fa4c0999b1d5a984d3680c4027b4fee6efcee0849','[\"*\"]',NULL,'2025-05-09 02:14:50','2025-05-09 02:14:50'),(341,'App\\Models\\User',172,'api_token','18809e102de99bdd1e3dc17f6febfb8a9004914543afc4e942f6e348270d1436','[\"*\"]','2025-05-13 00:04:36','2025-05-09 02:15:12','2025-05-13 00:04:36'),(342,'App\\Models\\User',107,'api_token','b6c5ab0198cd8dbbe019443be8c2339da07f442e480abe456014dbd4ecd05fa8','[\"*\"]','2025-06-02 01:38:09','2025-06-02 01:36:48','2025-06-02 01:38:09'),(343,'App\\Models\\User',107,'api_token','ff4eab2906f0d1fd2bbb064dfad7ee54b27f89283c81c61ef6e4c8d128630d3c','[\"*\"]','2025-06-02 01:39:07','2025-06-02 01:39:06','2025-06-02 01:39:07'),(344,'App\\Models\\User',107,'api_token','d257829eab2bfede75ff5b5038670ccbb9e61c34a07bff963795cba946ea5870','[\"*\"]','2025-06-02 01:39:11','2025-06-02 01:39:10','2025-06-02 01:39:11'),(345,'App\\Models\\User',107,'api_token','ffac22055fba841582a7e57ae7d1165aa9ba1f295b0961abc28667495be5cc9d','[\"*\"]','2025-06-02 01:39:36','2025-06-02 01:39:15','2025-06-02 01:39:36'),(346,'App\\Models\\User',107,'api_token','7a37461372a7f0d9484be5edab714cb45a004ab524d605078571dc467aa6694e','[\"*\"]','2025-06-02 01:39:48','2025-06-02 01:39:47','2025-06-02 01:39:48'),(347,'App\\Models\\User',107,'api_token','01ea7be63ab7cc6fe6d614757e377a9dd05fc7da3138b409b158258561eaab7e','[\"*\"]','2025-06-02 02:16:24','2025-06-02 01:39:56','2025-06-02 02:16:24'),(348,'App\\Models\\User',103,'api_token','b1cbd88b5a1a3852ee1c4aa10075a0e15a9c19151a900cc195a3fc8a84cc0525','[\"*\"]','2025-06-05 03:40:08','2025-06-05 01:47:09','2025-06-05 03:40:08'),(349,'App\\Models\\User',103,'api_token','35d9b84fb7b8a69c1c0e5c0e9223cb599726fba80eeb0b91ac956c4d722a1d0c','[\"*\"]',NULL,'2025-06-06 12:00:20','2025-06-06 12:00:20'),(350,'App\\Models\\User',162,'api_token','78d573c7ed1f8f6d841a76662507c12ee98b3ffa8b676674652f3a7dd5e177d2','[\"*\"]',NULL,'2025-06-06 12:48:37','2025-06-06 12:48:37'),(351,'App\\Models\\User',162,'api_token','b8becaf034c24b45b5edf049d05374c5a31e6c5196c72d1e7070afe9c982e6fa','[\"*\"]',NULL,'2025-06-06 12:48:53','2025-06-06 12:48:53'),(352,'App\\Models\\User',162,'api_token','7a1aa84965f79479a27be96ac68cfdfa9ff57571579980afea88e17b4ebfd4eb','[\"*\"]',NULL,'2025-06-06 13:23:54','2025-06-06 13:23:54'),(353,'App\\Models\\User',162,'api_token','81503a0235f358f922e043fdb62de3b2986b283c65c0c87c51da1a7189b377bc','[\"*\"]',NULL,'2025-06-07 05:28:03','2025-06-07 05:28:03'),(354,'App\\Models\\User',162,'api_token','9e95ed7c4eeace7988fa8380d500fdfd83cb609867312a3f022b66605f75b55a','[\"*\"]',NULL,'2025-06-07 06:07:09','2025-06-07 06:07:09'),(355,'App\\Models\\User',162,'api_token','245097febcc0fe2eb7688456392246adffccb8c72dc03f47e4fcfb786c29ded7','[\"*\"]',NULL,'2025-06-09 04:44:33','2025-06-09 04:44:33'),(356,'App\\Models\\User',162,'api_token','8bdf94170f9445ccc3a8b185424b415a8cca2d150df14a99b0334d86b67a7f56','[\"*\"]',NULL,'2025-06-09 04:45:05','2025-06-09 04:45:05'),(357,'App\\Models\\User',162,'api_token','80fc845cd0e42e04cba19579d730ce628f38030bcd776fdb9f85f3f9d102e4db','[\"*\"]',NULL,'2025-06-09 04:49:45','2025-06-09 04:49:45'),(358,'App\\Models\\User',162,'api_token','e7bf5f4e0c4c34697a387a9813999d65080a20396b0232a0014f3ffddf46208f','[\"*\"]',NULL,'2025-06-09 06:12:55','2025-06-09 06:12:55'),(359,'App\\Models\\User',157,'api_token','4e31306d1df8415da0afa4bf1bc0a5df90d97b2b034da3deba26a7d3f74f3840','[\"*\"]',NULL,'2025-06-09 06:26:21','2025-06-09 06:26:21'),(360,'App\\Models\\User',157,'api_token','666c97fe553652ef2a9e76a1a2fd976a6ecb33ca49cc1046ca16c11b33c5a9a5','[\"*\"]',NULL,'2025-06-09 06:28:31','2025-06-09 06:28:31'),(361,'App\\Models\\User',162,'api_token','1cd80092abcbdb3c79909cb4dae539d1273118508bbf76946d065414d3a42881','[\"*\"]',NULL,'2025-06-09 06:57:40','2025-06-09 06:57:40'),(362,'App\\Models\\User',157,'api_token','e58c2f001ac6717779840dfe2324287fddc75f17382f5bc2bdd78b026802c8ff','[\"*\"]',NULL,'2025-06-09 07:06:17','2025-06-09 07:06:17'),(363,'App\\Models\\User',162,'api_token','2b34f838fe44c428e7efbd852020e3e41bc5c8a18ae5083f17c2618b4ae1b674','[\"*\"]',NULL,'2025-06-09 07:08:33','2025-06-09 07:08:33'),(364,'App\\Models\\User',157,'api_token','89243ef7bf3d17e71c8bbd57c63f1db357a245d58a43948abde89a1a7a60d3e7','[\"*\"]',NULL,'2025-06-09 07:24:40','2025-06-09 07:24:40'),(365,'App\\Models\\User',162,'api_token','2e8b913ac9cba46b2e21cafa4a5a51e066c788f66550f3571f0a71e30dc3bad1','[\"*\"]',NULL,'2025-06-09 09:33:33','2025-06-09 09:33:33'),(366,'App\\Models\\User',162,'api_token','b281e1dd3c7700d83553ca72a0b16af7f7795d359d077bfcc1065f6e2ec9b3f3','[\"*\"]',NULL,'2025-06-09 12:26:41','2025-06-09 12:26:41'),(367,'App\\Models\\User',173,'api_token','23f77bf51c1ed1ca0100d9114f6d3e8c51aa8d491572e3659cd895d5c83e6e43','[\"*\"]',NULL,'2025-06-09 14:12:37','2025-06-09 14:12:37'),(368,'App\\Models\\User',173,'api_token','d0ef67d26bb93144cb5a1d2ba64f86b287c4d4e0e8b24c940adca9e87c63751b','[\"*\"]',NULL,'2025-06-10 07:41:11','2025-06-10 07:41:11'),(369,'App\\Models\\User',162,'api_token','466c5c220a19af11a084f9ccedd1fac67e9fb61472c1e33f0fa6ce03e25143a8','[\"*\"]',NULL,'2025-06-10 09:01:04','2025-06-10 09:01:04'),(370,'App\\Models\\User',162,'api_token','755bc2a1002a6f438fb1afc01ae05740e7450ef91678104af51152502e61dcee','[\"*\"]',NULL,'2025-06-10 09:02:01','2025-06-10 09:02:01'),(371,'App\\Models\\User',162,'api_token','815d92cfb3a8b0a05ff1f2983885fff9bd955873236f63f4c8fd7035485c3013','[\"*\"]',NULL,'2025-06-10 09:03:25','2025-06-10 09:03:25'),(372,'App\\Models\\User',162,'api_token','5e2cb98ba1c9c3baccefdc50b8489be996243d5ac221b84a91bc4266489e045c','[\"*\"]',NULL,'2025-06-10 09:04:10','2025-06-10 09:04:10'),(373,'App\\Models\\User',161,'api_token','9d410036c8ac64a67d64a0eed1ebef4391cf667b66fd086aec16e53f3229f7e1','[\"*\"]',NULL,'2025-06-10 09:27:05','2025-06-10 09:27:05'),(374,'App\\Models\\User',162,'api_token','2a7f6f024e6c37104ac72c3ac1a07694eeeb377eeff2e0b83f77c99099ea9d63','[\"*\"]',NULL,'2025-06-10 10:32:42','2025-06-10 10:32:42'),(375,'App\\Models\\User',162,'api_token','2fab4b147dd05d6a11f167f410428e20193ef97bbd2eb41d8b8e15f9a727d3ec','[\"*\"]',NULL,'2025-06-10 10:34:36','2025-06-10 10:34:36'),(376,'App\\Models\\User',103,'api_token','cc1d992297e87c79f2e03810295b95492fdf64e8e9f8335b78f968ef63e32dd0','[\"*\"]',NULL,'2025-06-10 17:32:22','2025-06-10 17:32:22'),(377,'App\\Models\\User',103,'api_token','2aa50db1a884450f20e40f4fdaa551188ac9c28a9d5f1001c84d80ecc3d2406f','[\"*\"]',NULL,'2025-06-10 17:33:33','2025-06-10 17:33:33'),(378,'App\\Models\\User',103,'api_token','6ec9a69c32d80ef0923f871f1176c16daefa204e6ed8b3ce5625cbc23ee1ba04','[\"*\"]',NULL,'2025-06-10 17:35:18','2025-06-10 17:35:18'),(379,'App\\Models\\User',103,'api_token','121f4cbf5e10201be21e91dcaa8bd1489164771f6fd806b4f0aae7ae598eb2fa','[\"*\"]',NULL,'2025-06-10 17:35:54','2025-06-10 17:35:54'),(380,'App\\Models\\User',103,'api_token','d8f7731d0d26d3fd536b3ee51ad3d4b499758e121bbdae2c22a47dd28f57e8a8','[\"*\"]',NULL,'2025-06-10 18:22:37','2025-06-10 18:22:37'),(381,'App\\Models\\User',103,'api_token','8a7b269f9d86bd2f7e82aa931cb8d8fc55a1c5ffe566aeef9fa3078b6fabf1cd','[\"*\"]',NULL,'2025-06-10 18:39:57','2025-06-10 18:39:57'),(382,'App\\Models\\User',103,'api_token','4e6fd72dec4afe7e4269d8064427926f9191d1baf13c6ec19d2cb8ded993cb8b','[\"*\"]',NULL,'2025-06-10 18:41:58','2025-06-10 18:41:58'),(383,'App\\Models\\User',103,'api_token','efba02e271745577f727319cc6aeff95c84ed1c6009a85ebf784d1ceb136ed93','[\"*\"]',NULL,'2025-06-10 18:50:09','2025-06-10 18:50:09'),(384,'App\\Models\\User',103,'api_token','ebce099aff2dd362a4d5c7a25ca166f5d9f70048f5ea91255d7f90acf0dce711','[\"*\"]',NULL,'2025-06-10 19:04:09','2025-06-10 19:04:09'),(385,'App\\Models\\User',103,'api_token','a62e4cf3d294358c57685a62d9af413c1109bedf88ec807f4e0ad3ec85efc040','[\"*\"]',NULL,'2025-06-10 19:13:26','2025-06-10 19:13:26'),(386,'App\\Models\\User',103,'api_token','f28f2bfa694e260cfdb9306319b426ce83c1bc757fb03dd20a4ab21a669cae83','[\"*\"]',NULL,'2025-06-10 19:54:22','2025-06-10 19:54:22'),(387,'App\\Models\\User',103,'api_token','c8bbb90cfe4c51c771a08890355683db40b04fb1bb09d89df1554ccecc9045ff','[\"*\"]','2025-06-13 12:10:58','2025-06-13 09:18:14','2025-06-13 12:10:58'),(388,'App\\Models\\User',103,'api_token','5dda17213cbd3b0d13308d47be667298a0cbb1b0a0e24ed2fca773c70e0d7ea1','[\"*\"]','2025-06-13 11:56:09','2025-06-13 11:55:39','2025-06-13 11:56:09'),(390,'App\\Models\\User',103,'api_token','49bbdd151e856e4aae0931c58aa9216d409549b109a80e482636c9e0b649b3ad','[\"*\"]',NULL,'2025-06-13 12:35:28','2025-06-13 12:35:28'),(391,'App\\Models\\User',103,'api_token','ceab4e4884624d2af9799f81b8cae8e077582c6544097cdbe49fd58f4942df8d','[\"*\"]','2025-06-13 12:46:42','2025-06-13 12:39:41','2025-06-13 12:46:42'),(392,'App\\Models\\User',103,'api_token','91a2154e78da33a20cc0f4a517b02bc2a0821c20fbf7a5c91ff0e19e7237dad0','[\"*\"]',NULL,'2025-06-13 12:46:46','2025-06-13 12:46:46'),(393,'App\\Models\\User',162,'api_token','90872c5c33e36ca7de65f1b5be579cd5f58ce9b8c566dd1aff0c3fe1ebdd5af5','[\"*\"]','2025-06-14 15:31:19','2025-06-14 15:15:15','2025-06-14 15:31:19'),(395,'App\\Models\\User',103,'api_token','79f6cf09eab92b0e964078e63463c9ffeb557faf5bcea3d8987cc9fdd5946e25','[\"*\"]','2025-06-25 11:00:58','2025-06-16 06:14:49','2025-06-25 11:00:58'),(397,'App\\Models\\User',162,'api_token','0ed3a2efc03343103cf352ab8288546424ddcce948969ad242008f221d9b65b6','[\"*\"]','2025-06-16 08:43:58','2025-06-16 08:39:13','2025-06-16 08:43:58'),(398,'App\\Models\\User',162,'api_token','22da32841c93e83f445b1c6719556851d732ad73aedd01018d65bb0a6ac536a6','[\"*\"]','2025-06-23 09:52:39','2025-06-16 09:21:11','2025-06-23 09:52:39'),(399,'App\\Models\\User',162,'api_token','b6de2167a0df246c12d4d84daab839b74c05bd9c9ffdc7806af424c1004a7124','[\"*\"]','2025-06-18 09:21:36','2025-06-16 09:21:49','2025-06-18 09:21:36'),(400,'App\\Models\\User',175,'api_token','a5a846f7973689169eff22d3abea75b658569a65daf9d3113c1ab5a888ba19d9','[\"*\"]','2025-06-25 06:04:23','2025-06-16 09:21:50','2025-06-25 06:04:23'),(401,'App\\Models\\User',103,'api_token','0c0268589bae9080f188f159cee0173ead2e585487a23a1ff07fdeed34161013','[\"*\"]','2025-06-25 12:57:38','2025-06-16 09:30:21','2025-06-25 12:57:38'),(402,'App\\Models\\User',175,'api_token','c0bf1fa310d6d9e178644cf152c3c32660457f29ca0800f510a3449031090396','[\"*\"]','2025-06-18 06:40:21','2025-06-16 10:13:48','2025-06-18 06:40:21'),(404,'App\\Models\\User',103,'api_token','c8fba64d311488508a1803a6683f890a13075108749331575c7b1cc594d2b071','[\"*\"]','2025-06-19 06:24:07','2025-06-16 13:27:13','2025-06-19 06:24:07'),(405,'App\\Models\\User',162,'api_token','ed7f4abc501b3c7d1fe8d3d4d2f6e9511dcb73ac27642ca11614572ef4711a14','[\"*\"]','2025-06-17 11:50:04','2025-06-17 11:43:32','2025-06-17 11:50:04'),(406,'App\\Models\\User',162,'api_token','4acc4967454c9e2bbb2d125041e1b3105e33bbd17f39110e787ee3cb04c0a440','[\"*\"]','2025-06-20 11:53:06','2025-06-17 11:55:38','2025-06-20 11:53:06'),(408,'App\\Models\\User',175,'api_token','f1f36c6148f0845f48df6c79664e05d45e416c2e8f9da4f1b007aa1d58d8fbfc','[\"*\"]','2025-06-18 13:03:25','2025-06-18 06:44:09','2025-06-18 13:03:25'),(409,'App\\Models\\User',162,'api_token','38ed5381da123a2daf627e5c0dfe555047cb195c86ac651f06ca1c09d44b1be4','[\"*\"]','2025-06-18 09:31:43','2025-06-18 09:26:28','2025-06-18 09:31:43'),(410,'App\\Models\\User',162,'api_token','8e2ba27723d6cc91de33e61034b4ff28c95cb526e363df6cac9cd2f255968a51','[\"*\"]','2025-06-18 09:31:57','2025-06-18 09:31:56','2025-06-18 09:31:57'),(411,'App\\Models\\User',162,'api_token','48c5cb407ec4e6675a61a55e69500c67f015cfd3b55f2b59c37fbbb5452716f9','[\"*\"]','2025-06-18 09:32:21','2025-06-18 09:32:03','2025-06-18 09:32:21'),(412,'App\\Models\\User',162,'api_token','08bee97746722a35277d162703e9a116ca181763987dbdf2bee031d36a33d2aa','[\"*\"]','2025-06-19 18:30:32','2025-06-18 09:32:40','2025-06-19 18:30:32'),(413,'App\\Models\\User',103,'api_token','299c29785f104df6d140a635d6e510443a3e8d954a5fd34a31ecfc4977525091','[\"*\"]','2025-06-24 04:49:50','2025-06-20 06:05:09','2025-06-24 04:49:50'),(414,'App\\Models\\User',103,'api_token','ad8ef89b8db886ff85b7afec7139ee06b783ebd5ac318bb3e57acb312e23dd5a','[\"*\"]','2025-06-20 13:32:45','2025-06-20 10:57:52','2025-06-20 13:32:45'),(415,'App\\Models\\User',175,'api_token','2594ba0cd58f1ba174ab515df3149ce10f60a84a0de3df4c885ac8ac35367123','[\"*\"]','2025-06-24 15:28:34','2025-06-23 05:35:26','2025-06-24 15:28:34'),(416,'App\\Models\\User',103,'api_token','cfa51e64901c17f2340f2871787a1f7725c0f65681cd32ac4c6cce09e180dacd','[\"*\"]','2025-06-24 05:37:36','2025-06-24 04:51:29','2025-06-24 05:37:36'),(417,'App\\Models\\User',103,'api_token','60b1d47e5a1843ffa5237909343fee777fe86b76030637319b0eab10e7602b02','[\"*\"]','2025-06-26 05:21:14','2025-06-24 05:46:22','2025-06-26 05:21:14'),(418,'App\\Models\\User',175,'api_token','181a86ada64848f15f0420f4562aa0703aaa3b709b7b06f92346f897caaa4bf0','[\"*\"]','2025-06-25 07:35:53','2025-06-25 06:59:58','2025-06-25 07:35:53'),(419,'App\\Models\\User',103,'api_token','68b61199d15258e62051376895dc247cc14a69a9cd8b8ffb60e5a7efb095bc14','[\"*\"]','2025-06-25 13:02:31','2025-06-25 11:01:16','2025-06-25 13:02:31'),(421,'App\\Models\\User',103,'api_token','d57f9c91618a5984cd2c64fea62cc21e96eb0f8f0155add07416250bf27b2b24','[\"*\"]','2025-06-25 12:59:45','2025-06-25 11:59:51','2025-06-25 12:59:45'),(422,'App\\Models\\User',176,'api_token','efea83e35499823f392adbdfeea2f389411a97b753d13dffbefdcbe1abb1f9b6','[\"*\"]','2025-06-25 12:54:18','2025-06-25 12:29:07','2025-06-25 12:54:18'),(423,'App\\Models\\User',103,'api_token','b389172ef9126daab05af8f4c30bcabf454571cbc27101fbbcb528619c25b3ae','[\"*\"]','2025-06-26 05:22:10','2025-06-26 05:20:42','2025-06-26 05:22:10'),(424,'App\\Models\\User',103,'api_token','0be4cd50a8a36fc852a487018d70abb8e4ef2b075b02f6426e6ae820e1e2743f','[\"*\"]','2025-06-26 05:22:06','2025-06-26 05:21:24','2025-06-26 05:22:06');
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `point_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `point_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `price` double(20,2) NOT NULL DEFAULT 0.00,
  `note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `point_histories_user_id_foreign` (`user_id`),
  KEY `point_histories_order_id_foreign` (`order_id`),
  CONSTRAINT `point_histories_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`),
  CONSTRAINT `point_histories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `point_histories` WRITE;
/*!40000 ALTER TABLE `point_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `point_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `points` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'fix',
  `price` double NOT NULL DEFAULT 0,
  `value` int(11) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `points_shop_id_foreign` (`shop_id`),
  CONSTRAINT `points_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `points` WRITE;
/*!40000 ALTER TABLE `points` DISABLE KEYS */;
INSERT INTO `points` VALUES (1,501,'percent',10,1000,1,'2025-02-05 05:08:54','2025-02-05 05:08:54'),(2,501,'percent',5,1000,1,'2025-02-06 01:23:36','2025-02-06 01:24:18'),(3,501,'percent',10,100,1,'2025-02-07 01:22:29','2025-02-07 01:22:29');
/*!40000 ALTER TABLE `points` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `privacy_policies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `privacy_policies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `privacy_policies` WRITE;
/*!40000 ALTER TABLE `privacy_policies` DISABLE KEYS */;
INSERT INTO `privacy_policies` VALUES (3,'2025-06-17 09:53:27','2025-06-17 09:53:27');
/*!40000 ALTER TABLE `privacy_policies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `privacy_policy_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `privacy_policy_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `privacy_policy_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `locale` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `privacy_policy_translations_privacy_policy_id_locale_unique` (`privacy_policy_id`,`locale`),
  KEY `privacy_policy_translations_locale_index` (`locale`),
  CONSTRAINT `privacy_policy_translations_privacy_policy_id_foreign` FOREIGN KEY (`privacy_policy_id`) REFERENCES `privacy_policies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `privacy_policy_translations` WRITE;
/*!40000 ALTER TABLE `privacy_policy_translations` DISABLE KEYS */;
INSERT INTO `privacy_policy_translations` VALUES (3,3,'🔒 Privacy & Policy','<ul><li>We prioritize your privacy. Your personal information is securely stored and used only to enhance your shopping experience. We do not share your data with third parties without consent.</li></ul>','en',NULL,NULL);
/*!40000 ALTER TABLE `privacy_policy_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_properties` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `property_group_id` bigint(20) unsigned NOT NULL,
  `property_value_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_properties_product_id_foreign` (`product_id`),
  KEY `product_properties_property_group_id_foreign` (`property_group_id`),
  KEY `product_properties_property_value_id_foreign` (`property_value_id`),
  CONSTRAINT `product_properties_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_properties_property_group_id_foreign` FOREIGN KEY (`property_group_id`) REFERENCES `property_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_properties_property_value_id_foreign` FOREIGN KEY (`property_value_id`) REFERENCES `property_values` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_properties` WRITE;
/*!40000 ALTER TABLE `product_properties` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_properties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_translations_product_id_locale_unique` (`product_id`,`locale`),
  KEY `product_translations_locale_index` (`locale`),
  CONSTRAINT `product_translations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_translations` WRITE;
/*!40000 ALTER TABLE `product_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `brand_id` bigint(20) unsigned DEFAULT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `keywords` varchar(191) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `qr_code` varchar(255) DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('published','pending','unpublished') NOT NULL DEFAULT 'pending',
  `min_qty` int(11) NOT NULL DEFAULT 1,
  `max_qty` int(11) NOT NULL DEFAULT 2147483647,
  `digital` tinyint(1) NOT NULL DEFAULT 0,
  `age_limit` smallint(6) NOT NULL DEFAULT 0,
  `visibility` tinyint(1) NOT NULL DEFAULT 1,
  `interval` double NOT NULL DEFAULT 1,
  `status_note` varchar(255) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `o_count` double DEFAULT 0,
  `od_count` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `min_price` double DEFAULT 0,
  `max_price` int(11) DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_shop_id_foreign` (`shop_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_unit_id_foreign` (`unit_id`),
  KEY `products_uuid_index` (`uuid`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `property_group_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `property_group_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `property_group_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `property_group_translations_property_group_id_locale_unique` (`property_group_id`,`locale`),
  KEY `property_group_translations_locale_index` (`locale`),
  CONSTRAINT `property_group_translations_property_group_id_foreign` FOREIGN KEY (`property_group_id`) REFERENCES `property_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `property_group_translations` WRITE;
/*!40000 ALTER TABLE `property_group_translations` DISABLE KEYS */;
INSERT INTO `property_group_translations` VALUES (3,2,'en','Washing Instructions'),(4,1,'en','Manufacturing Details');
/*!40000 ALTER TABLE `property_group_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `property_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `property_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `property_groups_shop_id_foreign` (`shop_id`),
  CONSTRAINT `property_groups_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `property_groups` WRITE;
/*!40000 ALTER TABLE `property_groups` DISABLE KEYS */;
INSERT INTO `property_groups` VALUES (1,'text',1,NULL),(2,'text',1,501);
/*!40000 ALTER TABLE `property_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `property_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `property_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `property_group_id` bigint(20) unsigned NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `value` varchar(191) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `property_values_property_group_id_foreign` (`property_group_id`),
  CONSTRAINT `property_values_property_group_id_foreign` FOREIGN KEY (`property_group_id`) REFERENCES `property_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `property_values` WRITE;
/*!40000 ALTER TABLE `property_values` DISABLE KEYS */;
INSERT INTO `property_values` VALUES (1,1,NULL,'Page Industries Ltd., Cessna Park, Umiya Bay, T-1, 7th Flr, ORR, Bengaluru - 560103,',1),(2,2,NULL,'Gentle wash at 40* c, Do not bleach, Don not Iron, Do not dryclean',1);
/*!40000 ALTER TABLE `property_values` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `push_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `body` text DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `push_notifications_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `push_notifications_user_id_foreign` (`user_id`),
  CONSTRAINT `push_notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=332 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `push_notifications` WRITE;
/*!40000 ALTER TABLE `push_notifications` DISABLE KEYS */;
INSERT INTO `push_notifications` VALUES (1,'App\\Models\\Order',1000,'new_order','New order for you # 1000','New order for you # 1000','{\"id\":1000,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-05 02:17:25','2025-02-05 02:17:25'),(2,'App\\Models\\Order',1001,'new_order','New order for you # 1001','New order for you # 1001','{\"id\":1001,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-05 02:19:11','2025-02-05 02:19:11'),(3,'App\\Models\\Order',1002,'new_order','New order for you # 1002','New order for you # 1002','{\"id\":1002,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-06 01:17:22','2025-02-06 02:00:08'),(4,'App\\Models\\Order',1002,'new_order','New order for you # 1002','New order for you # 1002','{\"id\":1002,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-06 01:17:22','2025-02-06 01:17:22'),(5,'App\\Models\\Order',1003,'new_order','New order for you # 1003','New order for you # 1003','{\"id\":1003,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-06 07:25:13','2025-02-06 07:25:13'),(6,'App\\Models\\Order',1003,'new_order','New order for you # 1003','New order for you # 1003','{\"id\":1003,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-06 07:25:14','2025-02-06 07:25:14'),(7,'App\\Models\\Order',1004,'new_order','New order for you # 1004','New order for you # 1004','{\"id\":1004,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-07 02:06:00','2025-02-07 02:06:00'),(8,'App\\Models\\Order',1004,'new_order','New order for you # 1004','New order for you # 1004','{\"id\":1004,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-07 02:06:00','2025-02-07 02:06:00'),(9,'App\\Models\\Order',1006,'new_order','New order for you # 1006','New order for you # 1006','{\"id\":1006,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-07 05:25:27','2025-02-07 05:25:27'),(10,'App\\Models\\Order',1007,'new_order','New order for you # 1007','New order for you # 1007','{\"id\":1007,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-07 05:58:56','2025-02-07 05:58:56'),(11,'App\\Models\\Order',1007,'new_order','New order for you # 1007','New order for you # 1007','{\"id\":1007,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-07 05:58:56','2025-02-07 05:58:56'),(12,'App\\Models\\Order',1009,'new_order','New order for you # 1009','New order for you # 1009','{\"id\":1009,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-07 06:24:07','2025-02-07 06:24:07'),(13,'App\\Models\\Order',1011,'new_order','New order for you # 1011','New order for you # 1011','{\"id\":1011,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-07 06:29:53','2025-02-07 06:29:53'),(14,'App\\Models\\Order',1011,'status_changed','Your order #1011 status has been changed to Canceled','Your order #1011 status has been changed to Canceled','{\"id\":1011,\"status\":\"canceled\",\"type\":\"status_changed\"}',NULL,NULL,'2025-02-09 11:16:04','2025-02-09 11:16:04'),(15,'App\\Models\\Order',1011,'status_changed','Your order #1011 status has been changed to Canceled','Your order #1011 status has been changed to Canceled','{\"id\":1011,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-09 11:16:04','2025-02-09 11:16:04'),(16,'App\\Models\\Order',1007,'status_changed','Your order #1007 status has been changed to Canceled','Your order #1007 status has been changed to Canceled','{\"id\":1007,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-09 23:30:36','2025-02-09 23:30:36'),(17,'App\\Models\\Order',1012,'new_order','New order for you # 1012','New order for you # 1012','{\"id\":1012,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-10 00:46:31','2025-02-10 00:46:31'),(18,'App\\Models\\Order',1013,'new_order','New order for you # 1013','New order for you # 1013','{\"id\":1013,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-10 01:21:49','2025-02-10 01:21:49'),(19,'App\\Models\\Order',1014,'new_order','New order for you # 1014','New order for you # 1014','{\"id\":1014,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-11 00:16:20','2025-02-11 00:16:20'),(20,'App\\Models\\Order',1014,'new_order','New order for you # 1014','New order for you # 1014','{\"id\":1014,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-11 00:16:20','2025-02-11 00:16:20'),(21,'App\\Models\\Order',1015,'new_order','New order for you # 1015','New order for you # 1015','{\"id\":1015,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-11 06:55:55','2025-02-11 06:55:55'),(22,'App\\Models\\Order',1015,'new_order','New order for you # 1015','New order for you # 1015','{\"id\":1015,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-11 06:55:55','2025-02-11 06:55:55'),(23,'App\\Models\\Order',1016,'new_order','New order for you # 1016','New order for you # 1016','{\"id\":1016,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 00:01:52','2025-02-12 00:01:52'),(24,'App\\Models\\Order',1016,'new_order','New order for you # 1016','New order for you # 1016','{\"id\":1016,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 00:01:52','2025-02-12 00:01:52'),(25,'App\\Models\\Order',1017,'new_order','New order for you # 1017','New order for you # 1017','{\"id\":1017,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 00:19:14','2025-02-12 00:19:14'),(26,'App\\Models\\Order',1017,'new_order','New order for you # 1017','New order for you # 1017','{\"id\":1017,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 00:19:14','2025-02-12 00:19:14'),(27,'App\\Models\\Order',1017,'status_changed','Your order #1017 status has been changed to Accepted','Your order #1017 status has been changed to Accepted','{\"id\":1017,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,'2025-02-12 00:22:57','2025-02-12 00:21:20','2025-02-12 00:22:57'),(28,'App\\Models\\Order',1017,'status_changed','Your order #1017 status has been changed to Ready','Your order #1017 status has been changed to Ready','{\"id\":1017,\"status\":\"ready\",\"type\":\"status_changed\"}',NULL,NULL,'2025-02-12 00:23:26','2025-02-12 00:23:26'),(29,'App\\Models\\Order',1017,'status_changed','Your order #1017 status has been changed to On a way','Your order #1017 status has been changed to On a way','{\"id\":1017,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',NULL,NULL,'2025-02-12 00:23:51','2025-02-12 00:23:51'),(30,'App\\Models\\Order',1017,'status_changed','Your order #1017 status has been changed to On a way','Your order #1017 status has been changed to On a way','{\"id\":1017,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-12 00:23:51','2025-02-12 00:23:51'),(31,'App\\Models\\Order',1017,'add_cashback','Added cashback','Added cashback','{\"id\":1017,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',NULL,NULL,'2025-02-12 00:24:21','2025-02-12 00:24:21'),(32,'App\\Models\\Order',1017,'status_changed','Your order #1017 status has been changed to Delivered','Your order #1017 status has been changed to Delivered','{\"id\":1017,\"status\":\"delivered\",\"type\":\"status_changed\"}',NULL,NULL,'2025-02-12 00:24:21','2025-02-12 00:24:21'),(33,'App\\Models\\Order',1017,'status_changed','Your order #1017 status has been changed to Delivered','Your order #1017 status has been changed to Delivered','{\"id\":1017,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-12 00:24:21','2025-02-12 00:24:21'),(34,'App\\Models\\Order',1018,'new_order','New order for you # 1018','New order for you # 1018','{\"id\":1018,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 01:42:19','2025-02-12 01:42:19'),(35,'App\\Models\\Order',1018,'new_order','New order for you # 1018','New order for you # 1018','{\"id\":1018,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 01:42:19','2025-02-12 01:42:19'),(36,'App\\Models\\Order',1019,'new_order','New order for you # 1019','New order for you # 1019','{\"id\":1019,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 01:47:58','2025-02-12 01:47:58'),(37,'App\\Models\\Order',1019,'new_order','New order for you # 1019','New order for you # 1019','{\"id\":1019,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 01:47:58','2025-02-12 01:47:58'),(38,'App\\Models\\Order',1019,'status_changed','Your order #1019 status has been changed to On a way','Your order #1019 status has been changed to On a way','{\"id\":1019,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-12 01:50:57','2025-02-12 01:50:57'),(39,'App\\Models\\Order',1019,'status_changed','Your order #1019 status has been changed to Delivered','Your order #1019 status has been changed to Delivered','{\"id\":1019,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-12 01:51:19','2025-02-12 01:51:19'),(40,'App\\Models\\Order',1020,'new_order','New order for you # 1020','New order for you # 1020','{\"id\":1020,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 02:11:12','2025-02-12 02:11:12'),(41,'App\\Models\\Order',1020,'new_order','New order for you # 1020','New order for you # 1020','{\"id\":1020,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 02:11:12','2025-02-12 02:11:12'),(42,'App\\Models\\Order',1021,'new_order','New order for you # 1021','New order for you # 1021','{\"id\":1021,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 06:23:13','2025-02-12 06:23:13'),(43,'App\\Models\\Order',1021,'new_order','New order for you # 1021','New order for you # 1021','{\"id\":1021,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 06:23:13','2025-02-12 06:23:13'),(44,'App\\Models\\Order',1022,'new_order','New order for you # 1022','New order for you # 1022','{\"id\":1022,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 06:26:14','2025-02-13 00:01:17'),(45,'App\\Models\\Order',1022,'new_order','New order for you # 1022','New order for you # 1022','{\"id\":1022,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 06:26:14','2025-02-12 06:26:14'),(46,'App\\Models\\Order',1021,'status_changed','Your order #1021 status has been changed to On a way','Your order #1021 status has been changed to On a way','{\"id\":1021,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-12 06:31:43','2025-02-12 06:31:43'),(47,'App\\Models\\Order',1021,'status_changed','Your order #1021 status has been changed to Delivered','Your order #1021 status has been changed to Delivered','{\"id\":1021,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-12 06:31:59','2025-02-12 06:31:59'),(48,'App\\Models\\Order',1023,'new_order','New order for you # 1023','New order for you # 1023','{\"id\":1023,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 23:27:27','2025-02-12 23:32:23'),(49,'App\\Models\\Order',1023,'new_order','New order for you # 1023','New order for you # 1023','{\"id\":1023,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 23:27:28','2025-02-12 23:27:28'),(50,'App\\Models\\Order',1024,'new_order','New order for you # 1024','New order for you # 1024','{\"id\":1024,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 23:31:05','2025-02-12 23:32:13'),(51,'App\\Models\\Order',1024,'new_order','New order for you # 1024','New order for you # 1024','{\"id\":1024,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 23:31:06','2025-02-12 23:31:06'),(52,'App\\Models\\Order',1025,'new_order','New order for you # 1025','New order for you # 1025','{\"id\":1025,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-12 23:40:23','2025-02-13 00:03:50'),(53,'App\\Models\\Order',1025,'new_order','New order for you # 1025','New order for you # 1025','{\"id\":1025,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-12 23:40:23','2025-02-12 23:40:23'),(54,'App\\Models\\Order',1026,'new_order','New order for you # 1026','New order for you # 1026','{\"id\":1026,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-13 04:29:30','2025-02-13 04:29:30'),(55,'App\\Models\\Order',1026,'new_order','New order for you # 1026','New order for you # 1026','{\"id\":1026,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-13 04:29:31','2025-02-13 04:29:31'),(56,'App\\Models\\Order',1026,'status_changed','Your order #1026 status has been changed to Canceled','Your order #1026 status has been changed to Canceled','{\"id\":1026,\"status\":\"canceled\",\"type\":\"status_changed\"}',NULL,'2025-02-13 04:50:34','2025-02-13 04:30:26','2025-02-13 04:50:34'),(57,'App\\Models\\Order',1026,'status_changed','Your order #1026 status has been changed to Canceled','Your order #1026 status has been changed to Canceled','{\"id\":1026,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-02-13 04:30:26','2025-02-27 05:30:11'),(58,'App\\Models\\Order',1027,'new_order','New order for you # 1027','New order for you # 1027','{\"id\":1027,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-13 04:36:00','2025-02-13 07:49:43'),(59,'App\\Models\\Order',1027,'new_order','New order for you # 1027','New order for you # 1027','{\"id\":1027,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-13 04:36:01','2025-02-13 04:36:01'),(60,'App\\Models\\Order',1028,'new_order','New order for you # 1028','New order for you # 1028','{\"id\":1028,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-17 04:49:08','2025-02-17 04:49:08'),(61,'App\\Models\\Order',1028,'new_order','New order for you # 1028','New order for you # 1028','{\"id\":1028,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-17 04:49:08','2025-02-17 04:49:08'),(62,'App\\Models\\Order',1029,'new_order','New order for you # 1029','New order for you # 1029','{\"id\":1029,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-17 05:10:54','2025-02-17 05:10:54'),(63,'App\\Models\\Order',1029,'new_order','New order for you # 1029','New order for you # 1029','{\"id\":1029,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-17 05:10:55','2025-02-17 05:10:55'),(64,'App\\Models\\Order',1030,'new_order','New order for you # 1030','New order for you # 1030','{\"id\":1030,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-17 05:23:50','2025-02-17 05:23:50'),(65,'App\\Models\\Order',1030,'new_order','New order for you # 1030','New order for you # 1030','{\"id\":1030,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-17 05:23:50','2025-02-17 05:23:50'),(66,'App\\Models\\Order',1031,'new_order','New order for you # 1031','New order for you # 1031','{\"id\":1031,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-17 06:08:50','2025-02-17 06:08:50'),(67,'App\\Models\\Order',1031,'new_order','New order for you # 1031','New order for you # 1031','{\"id\":1031,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-17 06:08:50','2025-02-17 06:08:50'),(68,'App\\Models\\Order',1032,'new_order','New order for you # 1032','New order for you # 1032','{\"id\":1032,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-17 06:12:58','2025-02-18 06:16:34'),(69,'App\\Models\\Order',1032,'new_order','New order for you # 1032','New order for you # 1032','{\"id\":1032,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-17 06:12:59','2025-02-17 06:12:59'),(70,'App\\Models\\Order',1033,'new_order','New order for you # 1033','New order for you # 1033','{\"id\":1033,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-17 07:18:41','2025-02-18 06:06:15'),(71,'App\\Models\\Order',1033,'new_order','New order for you # 1033','New order for you # 1033','{\"id\":1033,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-17 07:18:41','2025-02-17 07:18:41'),(72,'App\\Models\\Order',1034,'new_order','New order for you # 1034','New order for you # 1034','{\"id\":1034,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-02-20 03:16:50','2025-02-20 03:16:50'),(73,'App\\Models\\Order',1034,'new_order','New order for you # 1034','New order for you # 1034','{\"id\":1034,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-02-20 03:16:50','2025-02-20 03:16:50'),(74,'App\\Models\\Order',1035,'new_order','New order for you # 1035','New order for you # 1035','{\"id\":1035,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-03-25 04:31:24','2025-03-25 04:31:24'),(75,'App\\Models\\Order',1035,'new_order','New order for you # 1035','New order for you # 1035','{\"id\":1035,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-03-25 04:31:24','2025-03-25 04:31:24'),(76,'App\\Models\\Order',1036,'new_order','New order for you # 1036','New order for you # 1036','{\"id\":1036,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-03-25 04:31:32','2025-03-25 04:31:32'),(77,'App\\Models\\Order',1036,'new_order','New order for you # 1036','New order for you # 1036','{\"id\":1036,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-03-25 04:31:32','2025-03-25 04:31:32'),(78,'App\\Models\\Order',1035,'status_changed','Your order #1035 status has been changed to Accepted','Your order #1035 status has been changed to Accepted','{\"id\":1035,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-03-25 04:33:23','2025-03-25 04:33:23'),(79,'App\\Models\\Order',1037,'new_order','New order for you # 1037','New order for you # 1037','{\"id\":1037,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-03-25 04:33:54','2025-03-25 04:33:54'),(80,'App\\Models\\Order',1037,'new_order','New order for you # 1037','New order for you # 1037','{\"id\":1037,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-03-25 04:33:54','2025-03-25 04:33:54'),(81,'App\\Models\\Order',1038,'new_order','New order for you # 1038','New order for you # 1038','{\"id\":1038,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-03-25 04:55:47','2025-03-25 04:55:47'),(82,'App\\Models\\Order',1038,'new_order','New order for you # 1038','New order for you # 1038','{\"id\":1038,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-03-25 04:55:47','2025-03-25 04:55:47'),(83,'App\\Models\\Order',1039,'new_order','New order for you # 1039','New order for you # 1039','{\"id\":1039,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-04-09 23:35:58','2025-04-09 23:35:58'),(84,'App\\Models\\Order',1039,'new_order','New order for you # 1039','New order for you # 1039','{\"id\":1039,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-04-09 23:35:58','2025-04-09 23:35:58'),(85,'App\\Models\\Order',1040,'new_order','New order for you # 1040','New order for you # 1040','{\"id\":1040,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-04-10 04:55:45','2025-04-10 04:55:45'),(86,'App\\Models\\Order',1040,'new_order','New order for you # 1040','New order for you # 1040','{\"id\":1040,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-04-10 04:55:45','2025-04-10 04:55:45'),(87,'App\\Models\\Order',1041,'new_order','New order for you # 1041','New order for you # 1041','{\"id\":1041,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-04-10 04:58:26','2025-04-10 04:58:26'),(88,'App\\Models\\Order',1041,'new_order','New order for you # 1041','New order for you # 1041','{\"id\":1041,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-04-10 04:58:26','2025-04-10 04:58:26'),(89,'App\\Models\\Order',1042,'new_order','New order for you # 1042','New order for you # 1042','{\"id\":1042,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-04-10 05:07:40','2025-04-10 05:07:40'),(90,'App\\Models\\Order',1042,'new_order','New order for you # 1042','New order for you # 1042','{\"id\":1042,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-04-10 05:07:40','2025-04-10 05:07:40'),(91,'App\\Models\\Order',1043,'new_order','New order for you # 1043','New order for you # 1043','{\"id\":1043,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-04-21 04:52:31','2025-04-21 04:52:31'),(92,'App\\Models\\Order',1043,'new_order','New order for you # 1043','New order for you # 1043','{\"id\":1043,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-04-21 04:52:31','2025-04-21 04:52:31'),(93,'App\\Models\\Order',1044,'new_order','New order for you # 1044','New order for you # 1044','{\"id\":1044,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-04-21 06:22:54','2025-04-21 06:22:54'),(94,'App\\Models\\Order',1044,'new_order','New order for you # 1044','New order for you # 1044','{\"id\":1044,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-04-21 06:22:54','2025-04-21 06:22:54'),(95,'App\\Models\\Order',1044,'status_changed','Your order #1044 status has been changed to Accepted','Your order #1044 status has been changed to Accepted','{\"id\":1044,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-04-22 01:37:02','2025-04-22 01:37:02'),(96,'App\\Models\\Order',1044,'status_changed','Your order #1044 status has been changed to Ready','Your order #1044 status has been changed to Ready','{\"id\":1044,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-04-22 01:38:14','2025-04-22 01:38:14'),(97,'App\\Models\\Order',1044,'status_changed','Your order #1044 status has been changed to On a way','Your order #1044 status has been changed to On a way','{\"id\":1044,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-05-09 01:27:57','2025-05-09 01:27:57'),(98,'App\\Models\\Order',1044,'status_changed','Your order #1044 status has been changed to On a way','Your order #1044 status has been changed to On a way','{\"id\":1044,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-05-09 01:27:57','2025-05-09 01:27:57'),(99,'App\\Models\\Order',1044,'add_cashback','Added cashback','Added cashback','{\"id\":1044,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-05-09 01:28:19','2025-05-09 01:28:19'),(100,'App\\Models\\Order',1044,'status_changed','Your order #1044 status has been changed to Delivered','Your order #1044 status has been changed to Delivered','{\"id\":1044,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-05-09 01:28:19','2025-05-09 01:28:19'),(101,'App\\Models\\Order',1044,'status_changed','Your order #1044 status has been changed to Delivered','Your order #1044 status has been changed to Delivered','{\"id\":1044,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-05-09 01:28:19','2025-05-09 01:28:19'),(102,'App\\Models\\Order',1043,'status_changed','Your order #1043 status has been changed to Accepted','Your order #1043 status has been changed to Accepted','{\"id\":1043,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-05-09 01:29:12','2025-05-09 01:29:12'),(103,'App\\Models\\Order',1045,'new_order','New order for you # 1045','New order for you # 1045','{\"id\":1045,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-05-09 02:05:14','2025-05-09 02:05:14'),(104,'App\\Models\\Order',1045,'new_order','New order for you # 1045','New order for you # 1045','{\"id\":1045,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-05-09 02:05:14','2025-05-09 02:05:14'),(105,'App\\Models\\Order',1045,'status_changed','Your order #1045 status has been changed to Accepted','Your order #1045 status has been changed to Accepted','{\"id\":1045,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-05-09 02:11:12','2025-05-09 02:11:12'),(106,'App\\Models\\Order',1046,'new_order','New order for you # 1046','New order for you # 1046','{\"id\":1046,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-05-12 04:26:25','2025-05-12 04:26:25'),(107,'App\\Models\\Order',1046,'new_order','New order for you # 1046','New order for you # 1046','{\"id\":1046,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-05-12 04:26:25','2025-05-12 04:26:25'),(108,'App\\Models\\Order',1045,'add_cashback','Added cashback','Added cashback','{\"id\":1045,\"status\":\"accepted\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-05-12 06:17:57','2025-05-12 06:17:57'),(109,'App\\Models\\Order',1045,'status_changed','Your order #1045 status has been changed to Delivered','Your order #1045 status has been changed to Delivered','{\"id\":1045,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-05-12 06:17:57','2025-05-12 06:17:57'),(110,'App\\Models\\Order',1045,'status_changed','Your order #1045 status has been changed to Delivered','Your order #1045 status has been changed to Delivered','{\"id\":1045,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-05-12 06:17:58','2025-05-12 06:17:58'),(111,'App\\Models\\Order',1047,'new_order','New order for you # 1047','New order for you # 1047','{\"id\":1047,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-02 01:38:04','2025-06-02 01:38:04'),(112,'App\\Models\\Order',1047,'new_order','New order for you # 1047','New order for you # 1047','{\"id\":1047,\"status\":\"new\",\"type\":\"new_order\"}',107,'2025-06-02 01:48:46','2025-06-02 01:38:05','2025-06-02 01:38:05'),(113,'App\\Models\\Order',1047,'status_changed','Your order #1047 status has been changed to Canceled','Your order #1047 status has been changed to Canceled','{\"id\":1047,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-06-02 01:41:43','2025-06-02 01:41:43'),(114,'App\\Models\\Order',1047,'status_changed','Your order #1047 status has been changed to Canceled','Your order #1047 status has been changed to Canceled','{\"id\":1047,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,'2025-06-02 01:48:46','2025-06-02 01:41:43','2025-06-02 01:41:43'),(115,'App\\Models\\Order',1048,'new_order','New order for you # 1048','New order for you # 1048','{\"id\":1048,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-14 15:23:11','2025-06-14 15:23:11'),(116,'App\\Models\\Order',1048,'new_order','New order for you # 1048','New order for you # 1048','{\"id\":1048,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-14 15:23:11','2025-06-14 15:23:11'),(117,'App\\Models\\Order',1048,'status_changed','Your order #1048 status has been changed to Accepted','Your order #1048 status has been changed to Accepted','{\"id\":1048,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-14 15:24:21','2025-06-14 15:24:21'),(118,'App\\Models\\Order',1049,'new_order','New order for you # 1049','New order for you # 1049','{\"id\":1049,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-14 16:11:12','2025-06-14 16:11:12'),(119,'App\\Models\\Order',1049,'new_order','New order for you # 1049','New order for you # 1049','{\"id\":1049,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-14 16:11:12','2025-06-14 16:11:12'),(122,'App\\Models\\Order',1051,'new_order','New order for you # 1051','New order for you # 1051','{\"id\":1051,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 09:48:33','2025-06-16 09:48:33'),(123,'App\\Models\\Order',1051,'new_order','New order for you # 1051','New order for you # 1051','{\"id\":1051,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 09:48:33','2025-06-16 09:48:33'),(124,'App\\Models\\Order',1051,'status_changed','Your order #1051 status has been changed to Canceled','Your order #1051 status has been changed to Canceled','{\"id\":1051,\"status\":\"canceled\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 09:51:46','2025-06-16 09:51:46'),(125,'App\\Models\\Order',1051,'status_changed','Your order #1051 status has been changed to Canceled','Your order #1051 status has been changed to Canceled','{\"id\":1051,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 09:51:46','2025-06-16 09:51:46'),(126,'App\\Models\\Order',1052,'new_order','New order for you # 1052','New order for you # 1052','{\"id\":1052,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 09:53:17','2025-06-16 09:53:17'),(127,'App\\Models\\Order',1052,'new_order','New order for you # 1052','New order for you # 1052','{\"id\":1052,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 09:53:18','2025-06-16 09:53:18'),(128,'App\\Models\\Order',1052,'status_changed','Your order #1052 status has been changed to Canceled','Your order #1052 status has been changed to Canceled','{\"id\":1052,\"status\":\"canceled\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 09:54:03','2025-06-16 09:54:03'),(129,'App\\Models\\Order',1052,'status_changed','Your order #1052 status has been changed to Canceled','Your order #1052 status has been changed to Canceled','{\"id\":1052,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 09:54:03','2025-06-16 09:54:03'),(130,'App\\Models\\Order',1053,'new_order','New order for you # 1053','New order for you # 1053','{\"id\":1053,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 09:56:55','2025-06-16 10:02:08'),(131,'App\\Models\\Order',1053,'new_order','New order for you # 1053','New order for you # 1053','{\"id\":1053,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 09:56:55','2025-06-16 09:56:55'),(132,'App\\Models\\Order',1053,'status_changed','Your order #1053 status has been changed to Accepted','Your order #1053 status has been changed to Accepted','{\"id\":1053,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 09:58:21','2025-06-16 09:58:21'),(133,'App\\Models\\Order',1053,'status_changed','Your order #1053 status has been changed to Ready','Your order #1053 status has been changed to Ready','{\"id\":1053,\"status\":\"ready\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 09:58:33','2025-06-16 09:58:33'),(134,'App\\Models\\Order',1053,'status_changed','Your order #1053 status has been changed to On a way','Your order #1053 status has been changed to On a way','{\"id\":1053,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 09:58:45','2025-06-16 09:58:45'),(135,'App\\Models\\Order',1053,'status_changed','Your order #1053 status has been changed to On a way','Your order #1053 status has been changed to On a way','{\"id\":1053,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 09:58:45','2025-06-16 09:58:45'),(136,'App\\Models\\Order',1053,'add_cashback','Added cashback','Added cashback','{\"id\":1053,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',NULL,NULL,'2025-06-16 09:58:58','2025-06-16 09:58:58'),(137,'App\\Models\\Order',1053,'status_changed','Your order #1053 status has been changed to Delivered','Your order #1053 status has been changed to Delivered','{\"id\":1053,\"status\":\"delivered\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 09:58:58','2025-06-16 09:58:58'),(138,'App\\Models\\Order',1053,'status_changed','Your order #1053 status has been changed to Delivered','Your order #1053 status has been changed to Delivered','{\"id\":1053,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 09:58:58','2025-06-16 09:58:58'),(139,'App\\Models\\Order',1054,'new_order','New order for you # 1054','New order for you # 1054','{\"id\":1054,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 11:04:15','2025-06-16 11:06:11'),(140,'App\\Models\\Order',1054,'new_order','New order for you # 1054','New order for you # 1054','{\"id\":1054,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 11:04:15','2025-06-16 11:04:15'),(141,'App\\Models\\Order',1055,'new_order','New order for you # 1055','New order for you # 1055','{\"id\":1055,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 11:17:15','2025-06-16 11:17:15'),(142,'App\\Models\\Order',1055,'new_order','New order for you # 1055','New order for you # 1055','{\"id\":1055,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 11:17:16','2025-06-16 11:17:16'),(143,'App\\Models\\Order',1055,'status_changed','Your order #1055 status has been changed to Accepted','Your order #1055 status has been changed to Accepted','{\"id\":1055,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 11:20:55','2025-06-16 11:20:55'),(144,'App\\Models\\Order',1055,'status_changed','Your order #1055 status has been changed to Ready','Your order #1055 status has been changed to Ready','{\"id\":1055,\"status\":\"ready\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 11:21:06','2025-06-16 11:21:06'),(145,'App\\Models\\Order',1055,'status_changed','Your order #1055 status has been changed to On a way','Your order #1055 status has been changed to On a way','{\"id\":1055,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 11:21:25','2025-06-16 11:21:25'),(146,'App\\Models\\Order',1055,'status_changed','Your order #1055 status has been changed to On a way','Your order #1055 status has been changed to On a way','{\"id\":1055,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 11:21:25','2025-06-16 11:21:25'),(147,'App\\Models\\Order',1056,'new_order','New order for you # 1056','New order for you # 1056','{\"id\":1056,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 11:32:31','2025-06-16 11:32:31'),(148,'App\\Models\\Order',1056,'new_order','New order for you # 1056','New order for you # 1056','{\"id\":1056,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 11:32:31','2025-06-16 11:32:31'),(149,'App\\Models\\Order',1057,'new_order','New order for you # 1057','New order for you # 1057','{\"id\":1057,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 11:42:29','2025-06-16 11:42:29'),(150,'App\\Models\\Order',1057,'new_order','New order for you # 1057','New order for you # 1057','{\"id\":1057,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 11:42:29','2025-06-16 11:42:29'),(151,'App\\Models\\Order',1058,'new_order','New order for you # 1058','New order for you # 1058','{\"id\":1058,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 11:56:00','2025-06-16 11:56:00'),(152,'App\\Models\\Order',1058,'new_order','New order for you # 1058','New order for you # 1058','{\"id\":1058,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 11:56:00','2025-06-16 11:56:00'),(153,'App\\Models\\Order',1056,'status_changed','Your order #1056 status has been changed to Accepted','Your order #1056 status has been changed to Accepted','{\"id\":1056,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 11:58:04','2025-06-16 11:58:04'),(154,'App\\Models\\Order',1056,'status_changed','Your order #1056 status has been changed to Ready','Your order #1056 status has been changed to Ready','{\"id\":1056,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 11:58:36','2025-06-16 11:58:36'),(155,'App\\Models\\Order',1056,'status_changed','Your order #1056 status has been changed to On a way','Your order #1056 status has been changed to On a way','{\"id\":1056,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 11:59:42','2025-06-16 11:59:42'),(156,'App\\Models\\Order',1056,'status_changed','Your order #1056 status has been changed to On a way','Your order #1056 status has been changed to On a way','{\"id\":1056,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 11:59:42','2025-06-16 11:59:42'),(157,'App\\Models\\Order',1056,'add_cashback','Added cashback','Added cashback','{\"id\":1056,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-16 12:01:09','2025-06-16 12:01:09'),(158,'App\\Models\\Order',1056,'status_changed','Your order #1056 status has been changed to Delivered','Your order #1056 status has been changed to Delivered','{\"id\":1056,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:01:09','2025-06-16 12:01:09'),(159,'App\\Models\\Order',1056,'status_changed','Your order #1056 status has been changed to Delivered','Your order #1056 status has been changed to Delivered','{\"id\":1056,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 12:01:09','2025-06-16 12:01:09'),(160,'App\\Models\\Order',1059,'new_order','New order for you # 1059','New order for you # 1059','{\"id\":1059,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 12:05:31','2025-06-16 12:05:31'),(161,'App\\Models\\Order',1059,'new_order','New order for you # 1059','New order for you # 1059','{\"id\":1059,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 12:05:32','2025-06-16 12:05:32'),(162,'App\\Models\\Order',1060,'new_order','New order for you # 1060','New order for you # 1060','{\"id\":1060,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 12:08:43','2025-06-16 12:08:43'),(163,'App\\Models\\Order',1060,'new_order','New order for you # 1060','New order for you # 1060','{\"id\":1060,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 12:08:44','2025-06-16 12:08:44'),(164,'App\\Models\\Order',1060,'status_changed','Your order #1060 status has been changed to Accepted','Your order #1060 status has been changed to Accepted','{\"id\":1060,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:09:47','2025-06-16 12:09:47'),(165,'App\\Models\\Order',1059,'status_changed','Your order #1059 status has been changed to Accepted','Your order #1059 status has been changed to Accepted','{\"id\":1059,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-16 12:10:29','2025-06-16 12:10:29'),(166,'App\\Models\\Order',1060,'status_changed','Your order #1060 status has been changed to Ready','Your order #1060 status has been changed to Ready','{\"id\":1060,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:11:06','2025-06-16 12:11:06'),(167,'App\\Models\\Order',1060,'status_changed','Your order #1060 status has been changed to On a way','Your order #1060 status has been changed to On a way','{\"id\":1060,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:11:18','2025-06-16 12:11:18'),(168,'App\\Models\\Order',1060,'status_changed','Your order #1060 status has been changed to On a way','Your order #1060 status has been changed to On a way','{\"id\":1060,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 12:11:18','2025-06-16 12:11:18'),(169,'App\\Models\\Order',1060,'add_cashback','Added cashback','Added cashback','{\"id\":1060,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-16 12:11:36','2025-06-16 12:11:36'),(170,'App\\Models\\Order',1060,'status_changed','Your order #1060 status has been changed to Delivered','Your order #1060 status has been changed to Delivered','{\"id\":1060,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:11:36','2025-06-16 12:11:36'),(171,'App\\Models\\Order',1060,'status_changed','Your order #1060 status has been changed to Delivered','Your order #1060 status has been changed to Delivered','{\"id\":1060,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 12:11:36','2025-06-16 12:11:36'),(172,'App\\Models\\Order',1061,'new_order','New order for you # 1061','New order for you # 1061','{\"id\":1061,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 12:21:02','2025-06-16 12:21:02'),(173,'App\\Models\\Order',1061,'new_order','New order for you # 1061','New order for you # 1061','{\"id\":1061,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 12:21:02','2025-06-16 12:21:02'),(174,'App\\Models\\Order',1061,'status_changed','Your order #1061 status has been changed to Accepted','Your order #1061 status has been changed to Accepted','{\"id\":1061,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:24:08','2025-06-16 12:24:08'),(175,'App\\Models\\Order',1061,'status_changed','Your order #1061 status has been changed to Ready','Your order #1061 status has been changed to Ready','{\"id\":1061,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:24:44','2025-06-16 12:24:44'),(176,'App\\Models\\Order',1061,'status_changed','Your order #1061 status has been changed to On a way','Your order #1061 status has been changed to On a way','{\"id\":1061,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:24:58','2025-06-16 12:24:58'),(177,'App\\Models\\Order',1061,'status_changed','Your order #1061 status has been changed to On a way','Your order #1061 status has been changed to On a way','{\"id\":1061,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 12:24:58','2025-06-16 12:24:58'),(178,'App\\Models\\Order',1061,'add_cashback','Added cashback','Added cashback','{\"id\":1061,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-16 12:25:13','2025-06-16 12:25:13'),(179,'App\\Models\\Order',1061,'status_changed','Your order #1061 status has been changed to Delivered','Your order #1061 status has been changed to Delivered','{\"id\":1061,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-16 12:25:13','2025-06-16 12:25:13'),(180,'App\\Models\\Order',1061,'status_changed','Your order #1061 status has been changed to Delivered','Your order #1061 status has been changed to Delivered','{\"id\":1061,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-16 12:25:13','2025-06-16 12:25:13'),(181,'App\\Models\\Order',1062,'new_order','New order for you # 1062','New order for you # 1062','{\"id\":1062,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 12:31:43','2025-06-16 12:31:43'),(182,'App\\Models\\Order',1062,'new_order','New order for you # 1062','New order for you # 1062','{\"id\":1062,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 12:31:43','2025-06-16 12:31:43'),(183,'App\\Models\\Order',1063,'new_order','New order for you # 1063','New order for you # 1063','{\"id\":1063,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 13:30:51','2025-06-16 13:30:51'),(184,'App\\Models\\Order',1063,'new_order','New order for you # 1063','New order for you # 1063','{\"id\":1063,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 13:30:51','2025-06-16 13:30:51'),(185,'App\\Models\\Order',1064,'new_order','New order for you # 1064','New order for you # 1064','{\"id\":1064,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 13:32:09','2025-06-16 13:32:09'),(186,'App\\Models\\Order',1064,'new_order','New order for you # 1064','New order for you # 1064','{\"id\":1064,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 13:32:09','2025-06-16 13:32:09'),(187,'App\\Models\\Order',1065,'new_order','New order for you # 1065','New order for you # 1065','{\"id\":1065,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 13:34:28','2025-06-16 13:34:28'),(188,'App\\Models\\Order',1065,'new_order','New order for you # 1065','New order for you # 1065','{\"id\":1065,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 13:34:28','2025-06-16 13:34:28'),(189,'App\\Models\\Order',1066,'new_order','New order for you # 1066','New order for you # 1066','{\"id\":1066,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 13:36:05','2025-06-16 13:36:05'),(190,'App\\Models\\Order',1066,'new_order','New order for you # 1066','New order for you # 1066','{\"id\":1066,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 13:36:05','2025-06-16 13:36:05'),(191,'App\\Models\\Order',1067,'new_order','New order for you # 1067','New order for you # 1067','{\"id\":1067,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 13:37:09','2025-06-16 13:37:09'),(192,'App\\Models\\Order',1067,'new_order','New order for you # 1067','New order for you # 1067','{\"id\":1067,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 13:37:09','2025-06-16 13:37:09'),(193,'App\\Models\\Order',1068,'new_order','New order for you # 1068','New order for you # 1068','{\"id\":1068,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 13:40:50','2025-06-16 13:40:50'),(194,'App\\Models\\Order',1068,'new_order','New order for you # 1068','New order for you # 1068','{\"id\":1068,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 13:40:50','2025-06-16 13:40:50'),(195,'App\\Models\\Order',1069,'new_order','New order for you # 1069','New order for you # 1069','{\"id\":1069,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 13:41:51','2025-06-16 13:41:51'),(196,'App\\Models\\Order',1069,'new_order','New order for you # 1069','New order for you # 1069','{\"id\":1069,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 13:41:52','2025-06-16 13:41:52'),(197,'App\\Models\\Order',1070,'new_order','New order for you # 1070','New order for you # 1070','{\"id\":1070,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 14:09:22','2025-06-16 14:09:22'),(198,'App\\Models\\Order',1070,'new_order','New order for you # 1070','New order for you # 1070','{\"id\":1070,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 14:09:22','2025-06-16 14:09:22'),(199,'App\\Models\\Order',1071,'new_order','New order for you # 1071','New order for you # 1071','{\"id\":1071,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 14:15:16','2025-06-16 14:15:16'),(200,'App\\Models\\Order',1071,'new_order','New order for you # 1071','New order for you # 1071','{\"id\":1071,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 14:15:16','2025-06-16 14:15:16'),(201,'App\\Models\\Order',1072,'new_order','New order for you # 1072','New order for you # 1072','{\"id\":1072,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 14:21:20','2025-06-16 14:21:20'),(202,'App\\Models\\Order',1072,'new_order','New order for you # 1072','New order for you # 1072','{\"id\":1072,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 14:21:20','2025-06-16 14:21:20'),(203,'App\\Models\\Order',1073,'new_order','New order for you # 1073','New order for you # 1073','{\"id\":1073,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-16 14:25:45','2025-06-16 14:25:45'),(204,'App\\Models\\Order',1073,'new_order','New order for you # 1073','New order for you # 1073','{\"id\":1073,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-16 14:25:45','2025-06-16 14:25:45'),(205,'App\\Models\\Order',1064,'status_changed','Your order #1064 status has been changed to Accepted','Your order #1064 status has been changed to Accepted','{\"id\":1064,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 04:58:38','2025-06-17 04:58:38'),(206,'App\\Models\\Order',1064,'status_changed','Your order #1064 status has been changed to Ready','Your order #1064 status has been changed to Ready','{\"id\":1064,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 04:58:48','2025-06-17 04:58:48'),(207,'App\\Models\\Order',1074,'new_order','New order for you # 1074','New order for you # 1074','{\"id\":1074,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 04:59:29','2025-06-17 04:59:29'),(208,'App\\Models\\Order',1074,'new_order','New order for you # 1074','New order for you # 1074','{\"id\":1074,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 04:59:29','2025-06-17 04:59:29'),(209,'App\\Models\\Order',1064,'status_changed','Your order #1064 status has been changed to On a way','Your order #1064 status has been changed to On a way','{\"id\":1064,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:04:24','2025-06-17 05:04:24'),(210,'App\\Models\\Order',1064,'status_changed','Your order #1064 status has been changed to On a way','Your order #1064 status has been changed to On a way','{\"id\":1064,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:04:24','2025-06-17 05:04:24'),(211,'App\\Models\\Order',1064,'add_cashback','Added cashback','Added cashback','{\"id\":1064,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 05:04:37','2025-06-17 05:04:37'),(212,'App\\Models\\Order',1064,'status_changed','Your order #1064 status has been changed to Delivered','Your order #1064 status has been changed to Delivered','{\"id\":1064,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:04:37','2025-06-17 05:04:37'),(213,'App\\Models\\Order',1064,'status_changed','Your order #1064 status has been changed to Delivered','Your order #1064 status has been changed to Delivered','{\"id\":1064,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:04:37','2025-06-17 05:04:37'),(214,'App\\Models\\Order',1067,'status_changed','Your order #1067 status has been changed to Accepted','Your order #1067 status has been changed to Accepted','{\"id\":1067,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:05:44','2025-06-17 05:05:44'),(215,'App\\Models\\Order',1067,'status_changed','Your order #1067 status has been changed to Ready','Your order #1067 status has been changed to Ready','{\"id\":1067,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:06:01','2025-06-17 05:06:01'),(216,'App\\Models\\Order',1067,'status_changed','Your order #1067 status has been changed to On a way','Your order #1067 status has been changed to On a way','{\"id\":1067,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:06:10','2025-06-17 05:06:10'),(217,'App\\Models\\Order',1067,'status_changed','Your order #1067 status has been changed to On a way','Your order #1067 status has been changed to On a way','{\"id\":1067,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:06:10','2025-06-17 05:06:10'),(218,'App\\Models\\Order',1067,'add_cashback','Added cashback','Added cashback','{\"id\":1067,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 05:06:22','2025-06-17 05:06:22'),(219,'App\\Models\\Order',1067,'status_changed','Your order #1067 status has been changed to Delivered','Your order #1067 status has been changed to Delivered','{\"id\":1067,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:06:23','2025-06-17 05:06:23'),(220,'App\\Models\\Order',1067,'status_changed','Your order #1067 status has been changed to Delivered','Your order #1067 status has been changed to Delivered','{\"id\":1067,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:06:23','2025-06-17 05:06:23'),(221,'App\\Models\\Order',1075,'new_order','New order for you # 1075','New order for you # 1075','{\"id\":1075,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 05:07:33','2025-06-17 05:07:33'),(222,'App\\Models\\Order',1075,'new_order','New order for you # 1075','New order for you # 1075','{\"id\":1075,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 05:07:33','2025-06-17 05:07:33'),(223,'App\\Models\\Order',1066,'status_changed','Your order #1066 status has been changed to Accepted','Your order #1066 status has been changed to Accepted','{\"id\":1066,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:07:48','2025-06-17 05:07:48'),(224,'App\\Models\\Order',1066,'status_changed','Your order #1066 status has been changed to Ready','Your order #1066 status has been changed to Ready','{\"id\":1066,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:08:01','2025-06-17 05:08:01'),(225,'App\\Models\\Order',1066,'status_changed','Your order #1066 status has been changed to On a way','Your order #1066 status has been changed to On a way','{\"id\":1066,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:08:12','2025-06-17 05:08:12'),(226,'App\\Models\\Order',1066,'status_changed','Your order #1066 status has been changed to On a way','Your order #1066 status has been changed to On a way','{\"id\":1066,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:08:12','2025-06-17 05:08:12'),(227,'App\\Models\\Order',1066,'add_cashback','Added cashback','Added cashback','{\"id\":1066,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 05:08:26','2025-06-17 05:08:26'),(228,'App\\Models\\Order',1066,'status_changed','Your order #1066 status has been changed to Delivered','Your order #1066 status has been changed to Delivered','{\"id\":1066,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:08:26','2025-06-17 05:08:26'),(229,'App\\Models\\Order',1066,'status_changed','Your order #1066 status has been changed to Delivered','Your order #1066 status has been changed to Delivered','{\"id\":1066,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:08:26','2025-06-17 05:08:26'),(230,'App\\Models\\Order',1063,'status_changed','Your order #1063 status has been changed to Accepted','Your order #1063 status has been changed to Accepted','{\"id\":1063,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:09:23','2025-06-17 05:09:23'),(231,'App\\Models\\Order',1063,'status_changed','Your order #1063 status has been changed to Ready','Your order #1063 status has been changed to Ready','{\"id\":1063,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:09:31','2025-06-17 05:09:31'),(232,'App\\Models\\Order',1063,'status_changed','Your order #1063 status has been changed to On a way','Your order #1063 status has been changed to On a way','{\"id\":1063,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:09:44','2025-06-17 05:09:44'),(233,'App\\Models\\Order',1063,'status_changed','Your order #1063 status has been changed to On a way','Your order #1063 status has been changed to On a way','{\"id\":1063,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:09:44','2025-06-17 05:09:44'),(234,'App\\Models\\Order',1063,'add_cashback','Added cashback','Added cashback','{\"id\":1063,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 05:10:15','2025-06-17 05:10:15'),(235,'App\\Models\\Order',1063,'status_changed','Your order #1063 status has been changed to Delivered','Your order #1063 status has been changed to Delivered','{\"id\":1063,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:10:16','2025-06-17 05:10:16'),(236,'App\\Models\\Order',1063,'status_changed','Your order #1063 status has been changed to Delivered','Your order #1063 status has been changed to Delivered','{\"id\":1063,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:10:16','2025-06-17 05:10:16'),(237,'App\\Models\\Order',1072,'status_changed','Your order #1072 status has been changed to Accepted','Your order #1072 status has been changed to Accepted','{\"id\":1072,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:12:32','2025-06-17 05:12:32'),(238,'App\\Models\\Order',1072,'status_changed','Your order #1072 status has been changed to Ready','Your order #1072 status has been changed to Ready','{\"id\":1072,\"status\":\"ready\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:12:44','2025-06-17 05:12:44'),(239,'App\\Models\\Order',1072,'status_changed','Your order #1072 status has been changed to On a way','Your order #1072 status has been changed to On a way','{\"id\":1072,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:12:52','2025-06-17 05:12:52'),(240,'App\\Models\\Order',1072,'status_changed','Your order #1072 status has been changed to On a way','Your order #1072 status has been changed to On a way','{\"id\":1072,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:12:52','2025-06-17 05:12:52'),(241,'App\\Models\\Order',1072,'add_cashback','Added cashback','Added cashback','{\"id\":1072,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',NULL,NULL,'2025-06-17 05:13:03','2025-06-17 05:13:03'),(242,'App\\Models\\Order',1072,'status_changed','Your order #1072 status has been changed to Delivered','Your order #1072 status has been changed to Delivered','{\"id\":1072,\"status\":\"delivered\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:13:03','2025-06-17 05:13:03'),(243,'App\\Models\\Order',1072,'status_changed','Your order #1072 status has been changed to Delivered','Your order #1072 status has been changed to Delivered','{\"id\":1072,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:13:03','2025-06-17 05:13:03'),(244,'App\\Models\\Order',1073,'status_changed','Your order #1073 status has been changed to Accepted','Your order #1073 status has been changed to Accepted','{\"id\":1073,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:15:59','2025-06-17 05:15:59'),(245,'App\\Models\\Order',1073,'status_changed','Your order #1073 status has been changed to Ready','Your order #1073 status has been changed to Ready','{\"id\":1073,\"status\":\"ready\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:32:59','2025-06-17 05:32:59'),(246,'App\\Models\\Order',1073,'status_changed','Your order #1073 status has been changed to On a way','Your order #1073 status has been changed to On a way','{\"id\":1073,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:33:14','2025-06-17 05:33:14'),(247,'App\\Models\\Order',1073,'status_changed','Your order #1073 status has been changed to On a way','Your order #1073 status has been changed to On a way','{\"id\":1073,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:33:14','2025-06-17 05:33:14'),(248,'App\\Models\\Order',1073,'add_cashback','Added cashback','Added cashback','{\"id\":1073,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',NULL,NULL,'2025-06-17 05:33:35','2025-06-17 05:33:35'),(249,'App\\Models\\Order',1073,'status_changed','Your order #1073 status has been changed to Delivered','Your order #1073 status has been changed to Delivered','{\"id\":1073,\"status\":\"delivered\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:33:35','2025-06-17 05:33:35'),(250,'App\\Models\\Order',1073,'status_changed','Your order #1073 status has been changed to Delivered','Your order #1073 status has been changed to Delivered','{\"id\":1073,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:33:35','2025-06-17 05:33:35'),(251,'App\\Models\\Order',1075,'status_changed','Your order #1075 status has been changed to Accepted','Your order #1075 status has been changed to Accepted','{\"id\":1075,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:34:43','2025-06-17 05:34:43'),(252,'App\\Models\\Order',1074,'status_changed','Your order #1074 status has been changed to Accepted','Your order #1074 status has been changed to Accepted','{\"id\":1074,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:35:10','2025-06-17 05:35:10'),(253,'App\\Models\\Order',1076,'new_order','New order for you # 1076','New order for you # 1076','{\"id\":1076,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 05:35:18','2025-06-17 05:35:18'),(254,'App\\Models\\Order',1076,'new_order','New order for you # 1076','New order for you # 1076','{\"id\":1076,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 05:35:19','2025-06-17 05:35:19'),(255,'App\\Models\\Order',1074,'status_changed','Your order #1074 status has been changed to Ready','Your order #1074 status has been changed to Ready','{\"id\":1074,\"status\":\"ready\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:35:20','2025-06-17 05:35:20'),(256,'App\\Models\\Order',1074,'status_changed','Your order #1074 status has been changed to On a way','Your order #1074 status has been changed to On a way','{\"id\":1074,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:35:32','2025-06-17 05:35:32'),(257,'App\\Models\\Order',1074,'status_changed','Your order #1074 status has been changed to On a way','Your order #1074 status has been changed to On a way','{\"id\":1074,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:35:32','2025-06-17 05:35:32'),(258,'App\\Models\\Order',1074,'add_cashback','Added cashback','Added cashback','{\"id\":1074,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',NULL,NULL,'2025-06-17 05:36:03','2025-06-17 05:36:03'),(259,'App\\Models\\Order',1074,'status_changed','Your order #1074 status has been changed to Delivered','Your order #1074 status has been changed to Delivered','{\"id\":1074,\"status\":\"delivered\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:36:03','2025-06-17 05:36:03'),(260,'App\\Models\\Order',1074,'status_changed','Your order #1074 status has been changed to Delivered','Your order #1074 status has been changed to Delivered','{\"id\":1074,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:36:03','2025-06-17 05:36:03'),(261,'App\\Models\\Order',1077,'new_order','New order for you # 1077','New order for you # 1077','{\"id\":1077,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 05:38:04','2025-06-17 05:38:04'),(262,'App\\Models\\Order',1077,'new_order','New order for you # 1077','New order for you # 1077','{\"id\":1077,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 05:38:04','2025-06-17 05:38:04'),(263,'App\\Models\\Order',1077,'status_changed','Your order #1077 status has been changed to Accepted','Your order #1077 status has been changed to Accepted','{\"id\":1077,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:43:29','2025-06-17 05:43:29'),(264,'App\\Models\\Order',1076,'status_changed','Your order #1076 status has been changed to Accepted','Your order #1076 status has been changed to Accepted','{\"id\":1076,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:43:39','2025-06-17 05:43:39'),(265,'App\\Models\\Order',1071,'status_changed','Your order #1071 status has been changed to Accepted','Your order #1071 status has been changed to Accepted','{\"id\":1071,\"status\":\"accepted\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:46:18','2025-06-17 05:46:18'),(266,'App\\Models\\Order',1071,'status_changed','Your order #1071 status has been changed to Ready','Your order #1071 status has been changed to Ready','{\"id\":1071,\"status\":\"ready\",\"type\":\"status_changed\"}',NULL,NULL,'2025-06-17 05:46:26','2025-06-17 05:46:26'),(267,'App\\Models\\Order',1071,'status_changed','Your order #1071 status has been changed to On a way','Your order #1071 status has been changed to On a way','{\"id\":1071,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',NULL,'2025-06-18 06:45:21','2025-06-17 05:46:33','2025-06-18 06:45:21'),(268,'App\\Models\\Order',1071,'status_changed','Your order #1071 status has been changed to On a way','Your order #1071 status has been changed to On a way','{\"id\":1071,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:46:34','2025-06-17 05:46:34'),(269,'App\\Models\\Order',1071,'add_cashback','Added cashback','Added cashback','{\"id\":1071,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',NULL,'2025-06-18 06:44:41','2025-06-17 05:46:41','2025-06-18 06:44:41'),(270,'App\\Models\\Order',1071,'status_changed','Your order #1071 status has been changed to Delivered','Your order #1071 status has been changed to Delivered','{\"id\":1071,\"status\":\"delivered\",\"type\":\"status_changed\"}',NULL,'2025-06-18 06:44:44','2025-06-17 05:46:41','2025-06-18 06:44:44'),(271,'App\\Models\\Order',1071,'status_changed','Your order #1071 status has been changed to Delivered','Your order #1071 status has been changed to Delivered','{\"id\":1071,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:46:41','2025-06-17 05:46:41'),(272,'App\\Models\\Order',1078,'new_order','New order for you # 1078','New order for you # 1078','{\"id\":1078,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 05:50:34','2025-06-17 05:50:34'),(273,'App\\Models\\Order',1078,'new_order','New order for you # 1078','New order for you # 1078','{\"id\":1078,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 05:50:34','2025-06-17 05:50:34'),(274,'App\\Models\\Order',1078,'status_changed','Your order #1078 status has been changed to Accepted','Your order #1078 status has been changed to Accepted','{\"id\":1078,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:51:16','2025-06-17 05:51:16'),(275,'App\\Models\\Order',1078,'status_changed','Your order #1078 status has been changed to Ready','Your order #1078 status has been changed to Ready','{\"id\":1078,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:51:29','2025-06-17 05:51:29'),(276,'App\\Models\\Order',1078,'status_changed','Your order #1078 status has been changed to On a way','Your order #1078 status has been changed to On a way','{\"id\":1078,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:51:40','2025-06-17 05:51:40'),(277,'App\\Models\\Order',1078,'status_changed','Your order #1078 status has been changed to On a way','Your order #1078 status has been changed to On a way','{\"id\":1078,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:51:40','2025-06-17 05:51:40'),(278,'App\\Models\\Order',1078,'add_cashback','Added cashback','Added cashback','{\"id\":1078,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 05:51:55','2025-06-17 05:51:55'),(279,'App\\Models\\Order',1078,'status_changed','Your order #1078 status has been changed to Delivered','Your order #1078 status has been changed to Delivered','{\"id\":1078,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:51:55','2025-06-17 05:51:55'),(280,'App\\Models\\Order',1078,'status_changed','Your order #1078 status has been changed to Delivered','Your order #1078 status has been changed to Delivered','{\"id\":1078,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 05:51:55','2025-06-17 05:51:55'),(281,'App\\Models\\Order',1069,'status_changed','Your order #1069 status has been changed to Accepted','Your order #1069 status has been changed to Accepted','{\"id\":1069,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 05:56:26','2025-06-17 05:56:26'),(282,'App\\Models\\Order',1079,'new_order','New order for you # 1079','New order for you # 1079','{\"id\":1079,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 06:13:36','2025-06-17 06:13:36'),(283,'App\\Models\\Order',1079,'new_order','New order for you # 1079','New order for you # 1079','{\"id\":1079,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 06:13:37','2025-06-17 06:13:37'),(284,'App\\Models\\Order',1079,'status_changed','Your order #1079 status has been changed to Accepted','Your order #1079 status has been changed to Accepted','{\"id\":1079,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:14:59','2025-06-17 06:14:59'),(285,'App\\Models\\Order',1079,'status_changed','Your order #1079 status has been changed to Ready','Your order #1079 status has been changed to Ready','{\"id\":1079,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:15:21','2025-06-17 06:15:21'),(286,'App\\Models\\Order',1079,'status_changed','Your order #1079 status has been changed to On a way','Your order #1079 status has been changed to On a way','{\"id\":1079,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:15:32','2025-06-17 06:15:32'),(287,'App\\Models\\Order',1079,'status_changed','Your order #1079 status has been changed to On a way','Your order #1079 status has been changed to On a way','{\"id\":1079,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 06:15:32','2025-06-17 06:15:32'),(288,'App\\Models\\Order',1079,'add_cashback','Added cashback','Added cashback','{\"id\":1079,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 06:15:42','2025-06-17 06:15:42'),(289,'App\\Models\\Order',1079,'status_changed','Your order #1079 status has been changed to Delivered','Your order #1079 status has been changed to Delivered','{\"id\":1079,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:15:43','2025-06-17 06:15:43'),(290,'App\\Models\\Order',1079,'status_changed','Your order #1079 status has been changed to Delivered','Your order #1079 status has been changed to Delivered','{\"id\":1079,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 06:15:43','2025-06-17 06:15:43'),(291,'App\\Models\\Order',1080,'new_order','New order for you # 1080','New order for you # 1080','{\"id\":1080,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 06:33:56','2025-06-17 06:33:56'),(292,'App\\Models\\Order',1080,'new_order','New order for you # 1080','New order for you # 1080','{\"id\":1080,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 06:33:56','2025-06-17 06:33:56'),(293,'App\\Models\\Order',1080,'status_changed','Your order #1080 status has been changed to Accepted','Your order #1080 status has been changed to Accepted','{\"id\":1080,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:34:24','2025-06-17 06:34:24'),(294,'App\\Models\\Order',1080,'status_changed','Your order #1080 status has been changed to Ready','Your order #1080 status has been changed to Ready','{\"id\":1080,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:34:44','2025-06-17 06:34:44'),(295,'App\\Models\\Order',1080,'status_changed','Your order #1080 status has been changed to On a way','Your order #1080 status has been changed to On a way','{\"id\":1080,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:34:55','2025-06-17 06:34:55'),(296,'App\\Models\\Order',1080,'status_changed','Your order #1080 status has been changed to On a way','Your order #1080 status has been changed to On a way','{\"id\":1080,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 06:34:55','2025-06-17 06:34:55'),(297,'App\\Models\\Order',1080,'add_cashback','Added cashback','Added cashback','{\"id\":1080,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 06:35:07','2025-06-17 06:35:07'),(298,'App\\Models\\Order',1080,'status_changed','Your order #1080 status has been changed to Delivered','Your order #1080 status has been changed to Delivered','{\"id\":1080,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 06:35:07','2025-06-17 06:35:07'),(299,'App\\Models\\Order',1080,'status_changed','Your order #1080 status has been changed to Delivered','Your order #1080 status has been changed to Delivered','{\"id\":1080,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 06:35:07','2025-06-17 06:35:07'),(300,'App\\Models\\Order',1081,'new_order','New order for you # 1081','New order for you # 1081','{\"id\":1081,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 11:00:14','2025-06-17 11:00:14'),(301,'App\\Models\\Order',1081,'new_order','New order for you # 1081','New order for you # 1081','{\"id\":1081,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 11:00:14','2025-06-17 11:00:14'),(302,'App\\Models\\Order',1082,'new_order','New order for you # 1082','New order for you # 1082','{\"id\":1082,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 11:04:48','2025-06-17 11:04:48'),(303,'App\\Models\\Order',1082,'new_order','New order for you # 1082','New order for you # 1082','{\"id\":1082,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 11:04:48','2025-06-17 11:04:48'),(304,'App\\Models\\Order',1083,'new_order','New order for you # 1083','New order for you # 1083','{\"id\":1083,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 11:07:41','2025-06-17 11:07:41'),(305,'App\\Models\\Order',1083,'new_order','New order for you # 1083','New order for you # 1083','{\"id\":1083,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 11:07:41','2025-06-17 11:07:41'),(306,'App\\Models\\Order',1084,'new_order','New order for you # 1084','New order for you # 1084','{\"id\":1084,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 11:08:44','2025-06-17 11:08:44'),(307,'App\\Models\\Order',1084,'new_order','New order for you # 1084','New order for you # 1084','{\"id\":1084,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 11:08:44','2025-06-17 11:08:44'),(308,'App\\Models\\Order',1084,'add_cashback','Added cashback','Added cashback','{\"id\":1084,\"status\":\"new\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 11:12:56','2025-06-17 11:12:56'),(309,'App\\Models\\Order',1084,'status_changed','Your order #1084 status has been changed to Delivered','Your order #1084 status has been changed to Delivered','{\"id\":1084,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 11:12:56','2025-06-17 11:12:56'),(310,'App\\Models\\Order',1084,'status_changed','Your order #1084 status has been changed to Delivered','Your order #1084 status has been changed to Delivered','{\"id\":1084,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 11:12:56','2025-06-17 11:12:56'),(311,'App\\Models\\Order',1083,'status_changed','Your order #1083 status has been changed to Accepted','Your order #1083 status has been changed to Accepted','{\"id\":1083,\"status\":\"accepted\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 11:42:39','2025-06-17 11:42:39'),(312,'App\\Models\\Order',1083,'status_changed','Your order #1083 status has been changed to Ready','Your order #1083 status has been changed to Ready','{\"id\":1083,\"status\":\"ready\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 11:42:58','2025-06-17 11:42:58'),(313,'App\\Models\\Order',1083,'status_changed','Your order #1083 status has been changed to On a way','Your order #1083 status has been changed to On a way','{\"id\":1083,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 11:43:12','2025-06-17 11:43:12'),(314,'App\\Models\\Order',1083,'status_changed','Your order #1083 status has been changed to On a way','Your order #1083 status has been changed to On a way','{\"id\":1083,\"status\":\"on_a_way\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 11:43:12','2025-06-17 11:43:12'),(315,'App\\Models\\Order',1083,'add_cashback','Added cashback','Added cashback','{\"id\":1083,\"status\":\"on_a_way\",\"type\":\"add_cashback\"}',162,'2025-06-18 06:26:20','2025-06-17 11:43:47','2025-06-17 11:43:47'),(316,'App\\Models\\Order',1083,'status_changed','Your order #1083 status has been changed to Delivered','Your order #1083 status has been changed to Delivered','{\"id\":1083,\"status\":\"delivered\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-17 11:43:48','2025-06-17 11:43:48'),(317,'App\\Models\\Order',1083,'status_changed','Your order #1083 status has been changed to Delivered','Your order #1083 status has been changed to Delivered','{\"id\":1083,\"status\":\"delivered\",\"type\":\"status_changed\"}',107,NULL,'2025-06-17 11:43:48','2025-06-17 11:43:48'),(318,'App\\Models\\Order',1085,'new_order','New order for you # 1085','New order for you # 1085','{\"id\":1085,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-17 12:09:06','2025-06-17 12:09:06'),(319,'App\\Models\\Order',1085,'new_order','New order for you # 1085','New order for you # 1085','{\"id\":1085,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-17 12:09:07','2025-06-17 12:09:07'),(320,'App\\Models\\Order',1085,'status_changed','Your order #1085 status has been changed to Canceled','Your order #1085 status has been changed to Canceled','{\"id\":1085,\"status\":\"canceled\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-18 06:03:43','2025-06-18 06:03:43'),(321,'App\\Models\\Order',1085,'status_changed','Your order #1085 status has been changed to Canceled','Your order #1085 status has been changed to Canceled','{\"id\":1085,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,NULL,'2025-06-18 06:03:43','2025-06-18 06:03:43'),(322,'App\\Models\\Order',1086,'new_order','New order for you # 1086','New order for you # 1086','{\"id\":1086,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-18 06:14:31','2025-06-18 06:14:31'),(323,'App\\Models\\Order',1086,'new_order','New order for you # 1086','New order for you # 1086','{\"id\":1086,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-18 06:14:31','2025-06-18 06:14:31'),(324,'App\\Models\\Order',1086,'status_changed','Your order #1086 status has been changed to Canceled','Your order #1086 status has been changed to Canceled','{\"id\":1086,\"status\":\"canceled\",\"type\":\"status_changed\"}',162,'2025-06-18 06:26:20','2025-06-18 06:15:08','2025-06-18 06:15:08'),(325,'App\\Models\\Order',1086,'status_changed','Your order #1086 status has been changed to Canceled','Your order #1086 status has been changed to Canceled','{\"id\":1086,\"status\":\"canceled\",\"type\":\"status_changed\"}',107,NULL,'2025-06-18 06:15:08','2025-06-18 06:15:08'),(326,'App\\Models\\Order',1087,'new_order','New order for you # 1087','New order for you # 1087','{\"id\":1087,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-18 06:23:32','2025-06-18 06:23:32'),(327,'App\\Models\\Order',1087,'new_order','New order for you # 1087','New order for you # 1087','{\"id\":1087,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-18 06:23:33','2025-06-18 06:23:33'),(328,'App\\Models\\Order',1088,'new_order','New order for you # 1088','New order for you # 1088','{\"id\":1088,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:23','2025-06-23 05:36:21','2025-06-23 05:36:21'),(329,'App\\Models\\Order',1088,'new_order','New order for you # 1088','New order for you # 1088','{\"id\":1088,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-23 05:36:21','2025-06-23 05:36:21'),(330,'App\\Models\\Order',1089,'new_order','New order for you # 1089','New order for you # 1089','{\"id\":1089,\"status\":\"new\",\"type\":\"new_order\"}',103,'2025-06-25 11:56:47','2025-06-25 07:00:43','2025-06-25 11:56:47'),(331,'App\\Models\\Order',1089,'new_order','New order for you # 1089','New order for you # 1089','{\"id\":1089,\"status\":\"new\",\"type\":\"new_order\"}',107,NULL,'2025-06-25 07:00:43','2025-06-25 07:00:43');
/*!40000 ALTER TABLE `push_notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `referral_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `referral_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `referral_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `locale` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `faq` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `referral_translations_referral_id_locale_unique` (`referral_id`,`locale`),
  KEY `referral_translations_locale_index` (`locale`),
  CONSTRAINT `referral_translations_referral_id_foreign` FOREIGN KEY (`referral_id`) REFERENCES `referrals` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `referral_translations` WRITE;
/*!40000 ALTER TABLE `referral_translations` DISABLE KEYS */;
INSERT INTO `referral_translations` VALUES (3,1,'Invite & Earn – Exclusive Referral Program','en','Refer your friends and earn exciting rewards! Both you and your friend get special discounts on your next purchase.','Referral reward applies after the referred friend makes a successful purchase. No limit on referrals. Rewards are non-transferable and cannot be exchanged for cash.','2025-06-18 06:18:36','2025-06-18 06:18:36');
/*!40000 ALTER TABLE `referral_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `referrals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `price_from` double DEFAULT NULL,
  `price_to` double DEFAULT NULL,
  `expired_at` datetime DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `referrals` WRITE;
/*!40000 ALTER TABLE `referrals` DISABLE KEYS */;
INSERT INTO `referrals` VALUES (1,200,100,'2025-02-07 23:59:59','https://backstore.premfashions.com/storage/images/referral/103-17502274924806.webp','2025-02-06 01:33:03','2025-06-18 06:18:36');
/*!40000 ALTER TABLE `referrals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `region_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `region_translations_region_id_locale_unique` (`region_id`,`locale`),
  KEY `region_translations_locale_index` (`locale`),
  CONSTRAINT `region_translations_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `region_translations` WRITE;
/*!40000 ALTER TABLE `region_translations` DISABLE KEYS */;
INSERT INTO `region_translations` VALUES (1,1,'en','Asia');
/*!40000 ALTER TABLE `region_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `regions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `regions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `regions` WRITE;
/*!40000 ALTER TABLE `regions` DISABLE KEYS */;
INSERT INTO `regions` VALUES (1,1);
/*!40000 ALTER TABLE `regions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `request_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_models` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) DEFAULT NULL,
  `model_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `status_note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `request_models_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `request_models_created_by_foreign` (`created_by`),
  CONSTRAINT `request_models_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `request_models` WRITE;
/*!40000 ALTER TABLE `request_models` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reviews` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `reviewable_type` varchar(255) NOT NULL,
  `reviewable_id` bigint(20) unsigned NOT NULL,
  `assignable_type` varchar(255) DEFAULT NULL,
  `assignable_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `rating` double NOT NULL DEFAULT 5,
  `comment` text DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reviews_reviewable_type_reviewable_id_index` (`reviewable_type`,`reviewable_id`),
  KEY `reviews_assignable_type_assignable_id_index` (`assignable_type`,`assignable_id`),
  KEY `reviews_reviewable_id_index` (`reviewable_id`),
  KEY `reviews_reviewable_type_index` (`reviewable_type`),
  KEY `reviews_user_id_foreign` (`user_id`),
  CONSTRAINT `reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reviews` WRITE;
/*!40000 ALTER TABLE `reviews` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviews` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'user','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(11,'seller','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(12,'moderator','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(13,'deliveryman','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(21,'manager','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(99,'admin','web','2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'before_order_phone_required','0','2025-02-05 05:20:26','2025-02-05 05:21:08'),(2,'phone','9986809661','2025-02-05 05:23:22','2025-02-12 00:27:34'),(3,'address','C/o C D Rao Compound, R M R Road, Tilak Nagar, Durgigudi, Shivamogga, Karnataka 577201, India','2025-02-05 05:23:22','2025-02-17 06:31:30'),(4,'footer_text','Prem Fashion','2025-02-05 05:23:22','2025-02-12 00:49:19'),(5,'cart_ui_type','1','2025-02-05 06:46:05','2025-02-18 05:29:11'),(6,'product_ui_type','2','2025-02-05 06:46:17','2025-02-05 06:46:17'),(7,'instagram','https://webschedio.com/','2025-02-06 01:17:13','2025-02-06 01:17:13'),(8,'facebook','https://webschedio.com/','2025-02-06 01:17:13','2025-02-06 01:17:13'),(9,'twitter','https://webschedio.com/','2025-02-06 01:17:13','2025-02-06 01:17:13'),(10,'referral_active','1','2025-02-06 01:30:12','2025-02-06 01:30:12'),(11,'title','Prem Fashion','2025-02-06 04:55:04','2025-02-06 04:55:04'),(12,'deliveryman_order_acceptance_time','5','2025-02-06 04:55:04','2025-06-18 05:56:48'),(13,'service_fee','1','2025-02-06 04:55:04','2025-06-18 05:56:59'),(14,'min_amount','1','2025-02-06 04:55:04','2025-06-18 05:56:38'),(15,'favicon','https://backstore.premfashions.com/storage/images/languages/103-17500610837038.webp','2025-02-06 04:55:04','2025-06-16 08:04:59'),(16,'logo','https://backstore.premfashions.com/storage/images/languages/103-17500610931911.webp','2025-02-06 04:55:04','2025-06-16 08:04:59'),(17,'ui_type','1','2025-02-17 05:27:35','2025-02-18 05:31:26'),(18,'google_map_key','AIzaSyAu48sLYaUmz74zO6SLD8OUfYluU-2nbb4','2025-02-17 06:27:41','2025-02-18 05:43:38'),(19,'location','13.937686075585827, 75.57042021852385','2025-02-17 06:27:41','2025-02-17 06:31:30');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_ads_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_ads_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL DEFAULT 'new',
  `ads_package_id` bigint(20) unsigned NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `position_page` smallint(6) NOT NULL DEFAULT 1 COMMENT 'На какой странице будет выходить',
  PRIMARY KEY (`id`),
  KEY `shop_ads_packages_ads_package_id_foreign` (`ads_package_id`),
  KEY `shop_ads_packages_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_ads_packages_ads_package_id_foreign` FOREIGN KEY (`ads_package_id`) REFERENCES `ads_packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_ads_packages_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_ads_packages` WRITE;
/*!40000 ALTER TABLE `shop_ads_packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_ads_packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_ads_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_ads_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_ads_package_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `position_page` smallint(6) NOT NULL DEFAULT 1 COMMENT 'На какой странице будет выходить',
  PRIMARY KEY (`id`),
  KEY `shop_ads_products_shop_ads_package_id_foreign` (`shop_ads_package_id`),
  KEY `shop_ads_products_product_id_foreign` (`product_id`),
  CONSTRAINT `shop_ads_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_ads_products_shop_ads_package_id_foreign` FOREIGN KEY (`shop_ads_package_id`) REFERENCES `shop_ads_packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_ads_products` WRITE;
/*!40000 ALTER TABLE `shop_ads_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_ads_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_closed_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_closed_dates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_closed_dates_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_closed_dates_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_closed_dates` WRITE;
/*!40000 ALTER TABLE `shop_closed_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_closed_dates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_deliveryman_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_deliveryman_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `type` enum('fix','percent') NOT NULL,
  `value` int(11) NOT NULL,
  `period` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_deliveryman_settings_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_deliveryman_settings_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_deliveryman_settings` WRITE;
/*!40000 ALTER TABLE `shop_deliveryman_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_deliveryman_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_galleries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_galleries` WRITE;
/*!40000 ALTER TABLE `shop_galleries` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_galleries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_locations_shop_id_foreign` (`shop_id`),
  KEY `shop_locations_region_id_foreign` (`region_id`),
  KEY `shop_locations_country_id_foreign` (`country_id`),
  KEY `shop_locations_city_id_foreign` (`city_id`),
  KEY `shop_locations_area_id_foreign` (`area_id`),
  CONSTRAINT `shop_locations_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_locations` WRITE;
/*!40000 ALTER TABLE `shop_locations` DISABLE KEYS */;
INSERT INTO `shop_locations` VALUES (1,501,1,1,1,NULL,'2025-02-17 05:18:45','2025-02-17 05:18:45');
/*!40000 ALTER TABLE `shop_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) unsigned NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `client_id` varchar(191) DEFAULT NULL,
  `secret_id` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_payments_payment_id_foreign` (`payment_id`),
  KEY `shop_payments_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_payments_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_payments_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_payments` WRITE;
/*!40000 ALTER TABLE `shop_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_socials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_socials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `content` varchar(255) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_socials_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_socials_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_socials` WRITE;
/*!40000 ALTER TABLE `shop_socials` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_socials` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `subscription_id` bigint(20) unsigned NOT NULL,
  `expired_at` date DEFAULT NULL,
  `price` double DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_subscriptions_shop_id_foreign` (`shop_id`),
  KEY `shop_subscriptions_subscription_id_foreign` (`subscription_id`),
  CONSTRAINT `shop_subscriptions_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_subscriptions_subscription_id_foreign` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_subscriptions` WRITE;
/*!40000 ALTER TABLE `shop_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_tag_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_tag_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_tag_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `locale` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shop_tag_translations_shop_tag_id_locale_unique` (`shop_tag_id`,`locale`),
  KEY `shop_tag_translations_locale_index` (`locale`),
  CONSTRAINT `shop_tag_translations_shop_tag_id_foreign` FOREIGN KEY (`shop_tag_id`) REFERENCES `shop_tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_tag_translations` WRITE;
/*!40000 ALTER TABLE `shop_tag_translations` DISABLE KEYS */;
INSERT INTO `shop_tag_translations` VALUES (2,2,'new','en');
/*!40000 ALTER TABLE `shop_tag_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_tags` WRITE;
/*!40000 ALTER TABLE `shop_tags` DISABLE KEYS */;
INSERT INTO `shop_tags` VALUES (2,'https://premfashion.webschedio.in/storage/images/products/103-17464475797320.webp','2025-05-05 06:49:48','2025-05-05 06:49:48');
/*!40000 ALTER TABLE `shop_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shop_translations_shop_id_locale_unique` (`shop_id`,`locale`),
  KEY `shop_translations_locale_index` (`locale`),
  CONSTRAINT `shop_translations_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_translations` WRITE;
/*!40000 ALTER TABLE `shop_translations` DISABLE KEYS */;
INSERT INTO `shop_translations` VALUES (15,501,'en','Prem Fashion','branch desc','Shivamogga, Karnataka, India');
/*!40000 ALTER TABLE `shop_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_working_days`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shop_working_days` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') NOT NULL,
  `from` varchar(5) NOT NULL DEFAULT '9:00',
  `to` varchar(5) NOT NULL DEFAULT '21:00',
  `disabled` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_working_days_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_working_days_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_working_days` WRITE;
/*!40000 ALTER TABLE `shop_working_days` DISABLE KEYS */;
INSERT INTO `shop_working_days` VALUES (71,501,'monday','01:00','23:00',0,'2025-05-09 01:54:19','2025-05-09 01:54:19'),(72,501,'tuesday','01:00','23:00',0,'2025-05-09 01:54:19','2025-05-09 01:54:19'),(73,501,'wednesday','01:00','23:00',0,'2025-05-09 01:54:19','2025-05-09 01:54:19'),(74,501,'thursday','01:00','23:00',0,'2025-05-09 01:54:19','2025-05-09 01:54:19'),(75,501,'friday','01:00','23:00',0,'2025-05-09 01:54:19','2025-05-09 01:54:19'),(76,501,'saturday','01:00','23:00',0,'2025-05-09 01:54:19','2025-05-09 01:54:19'),(77,501,'sunday','01:00','23:00',0,'2025-05-09 01:54:19','2025-05-09 01:54:19');
/*!40000 ALTER TABLE `shop_working_days` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shops` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `tax` double(22,2) NOT NULL DEFAULT 0.00,
  `percentage` double NOT NULL DEFAULT 0,
  `lat_long` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`lat_long`)),
  `phone` varchar(255) DEFAULT NULL,
  `open` tinyint(1) NOT NULL DEFAULT 1,
  `visibility` tinyint(1) NOT NULL DEFAULT 1,
  `background_img` varchar(191) DEFAULT NULL,
  `logo_img` varchar(191) DEFAULT NULL,
  `min_amount` double NOT NULL DEFAULT 0.1,
  `status` enum('new','edited','approved','rejected','inactive') NOT NULL DEFAULT 'new',
  `status_note` text DEFAULT NULL,
  `delivery_time` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`delivery_time`)),
  `type` tinyint(4) NOT NULL,
  `verify` tinyint(1) NOT NULL DEFAULT 0,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `o_count` double DEFAULT 0,
  `od_count` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `delivery_type` tinyint(4) NOT NULL DEFAULT 1,
  `email_statuses` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shops_user_id_foreign` (`user_id`),
  KEY `shops_uuid_index` (`uuid`),
  CONSTRAINT `shops_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=502 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shops` WRITE;
/*!40000 ALTER TABLE `shops` DISABLE KEYS */;
INSERT INTO `shops` VALUES (501,'prem-fashion-501','7ccbbec5-d239-4897-a0e0-9d0c25609060',107,0.00,0,'{\"latitude\":-69.3453324,\"longitude\":69.3453324}','9741374744',1,0,'https://backstore.premfashions.com/storage/images/shops/background/103-17464477289724.webp','https://backstore.premfashions.com/storage/images/shops/logo/103-17375288179187.webp',0.1,'approved','approved','{\"from\":\"10\",\"to\":\"90\",\"type\":\"minute\"}',1,1,0,0,0,0,0,'2024-12-30 00:58:41','2025-05-09 02:09:17',1,NULL);
/*!40000 ALTER TABLE `shops` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_gateways`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_gateways` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `from` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `secret_key` varchar(255) DEFAULT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `text` varchar(191) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_gateways` WRITE;
/*!40000 ALTER TABLE `sms_gateways` DISABLE KEYS */;
INSERT INTO `sms_gateways` VALUES (1,'Nexmo','go-shop','nexmo',NULL,NULL,NULL,'Your verify code: #OTP#. Valid for 5 minutes',0,'2024-12-30 00:58:40','2024-12-30 00:58:40'),(2,'Twilio','','twilio',NULL,NULL,NULL,'Your verify code: #OTP#. Valid for 5 minutes',0,'2024-12-30 00:58:40','2024-12-30 00:58:40');
/*!40000 ALTER TABLE `sms_gateways` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_payloads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_payloads` (
  `type` varchar(255) NOT NULL DEFAULT 'firebase',
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`payload`)),
  `default` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_payloads` WRITE;
/*!40000 ALTER TABLE `sms_payloads` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_payloads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `social_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_providers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `provider` varchar(255) NOT NULL,
  `provider_id` text DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `social_providers_user_id_foreign` (`user_id`),
  CONSTRAINT `social_providers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `social_providers` WRITE;
/*!40000 ALTER TABLE `social_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_providers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_extras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_extras` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` bigint(20) unsigned NOT NULL,
  `extra_group_id` bigint(20) unsigned NOT NULL,
  `extra_value_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_extras_stock_id_foreign` (`stock_id`),
  KEY `stock_extras_extra_group_id_foreign` (`extra_group_id`),
  KEY `stock_extras_extra_value_id_foreign` (`extra_value_id`),
  CONSTRAINT `stock_extras_extra_group_id_foreign` FOREIGN KEY (`extra_group_id`) REFERENCES `extra_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stock_extras_extra_value_id_foreign` FOREIGN KEY (`extra_value_id`) REFERENCES `extra_values` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stock_extras_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=481 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_extras` WRITE;
/*!40000 ALTER TABLE `stock_extras` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_extras` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stocks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `price` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `bonus_expired_at` datetime DEFAULT NULL,
  `discount_expired_at` datetime DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `discount_id` bigint(20) unsigned DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `o_count` double DEFAULT 0,
  `od_count` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stocks_product_id_foreign` (`product_id`),
  KEY `stocks_discount_id_foreign` (`discount_id`),
  CONSTRAINT `stocks_discount_id_foreign` FOREIGN KEY (`discount_id`) REFERENCES `discounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `stocks_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stocks` WRITE;
/*!40000 ALTER TABLE `stocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `stocks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `file_urls` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`file_urls`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stories_shop_id_foreign` (`shop_id`),
  KEY `stories_product_id_foreign` (`product_id`),
  CONSTRAINT `stories_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stories_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stories` WRITE;
/*!40000 ALTER TABLE `stories` DISABLE KEYS */;
/*!40000 ALTER TABLE `stories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT 'order',
  `price` double NOT NULL,
  `month` tinyint(4) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `title` varchar(255) NOT NULL,
  `product_limit` int(11) NOT NULL,
  `order_limit` int(11) NOT NULL,
  `with_report` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (97,'orders',100,1,1,'title1',1000,1000,0,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(98,'orders',250,3,1,'title3',3000,3000,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(99,'orders',450,6,1,'title6',6000,6000,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(100,'orders',800,12,1,'title12',12000,12000,1,'2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tag_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tag_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag_translations_tag_id_locale_unique` (`tag_id`,`locale`),
  KEY `tag_translations_locale_index` (`locale`),
  CONSTRAINT `tag_translations_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tag_translations` WRITE;
/*!40000 ALTER TABLE `tag_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tag_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `product_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tags_product_id_foreign` (`product_id`),
  CONSTRAINT `tags_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `term_condition_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `term_condition_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_condition_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `locale` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `term_condition_translations_term_condition_id_locale_unique` (`term_condition_id`,`locale`),
  KEY `term_condition_translations_locale_index` (`locale`),
  CONSTRAINT `term_condition_translations_term_condition_id_foreign` FOREIGN KEY (`term_condition_id`) REFERENCES `term_conditions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `term_condition_translations` WRITE;
/*!40000 ALTER TABLE `term_condition_translations` DISABLE KEYS */;
INSERT INTO `term_condition_translations` VALUES (8,1,'Terms & Conditions','en',NULL,NULL,'<p>By using our platform, you agree to comply with our policies regarding purchases, returns, and privacy. Please review all terms carefully before making a transaction</p>');
/*!40000 ALTER TABLE `term_condition_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `term_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `term_conditions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `term_conditions` WRITE;
/*!40000 ALTER TABLE `term_conditions` DISABLE KEYS */;
INSERT INTO `term_conditions` VALUES (1,'2025-02-06 05:25:52','2025-02-06 05:25:52');
/*!40000 ALTER TABLE `term_conditions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tickets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `type` varchar(255) NOT NULL DEFAULT 'question',
  `subject` varchar(191) NOT NULL,
  `content` text NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'open',
  `read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tickets_created_by_foreign` (`created_by`),
  KEY `tickets_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `tickets_uuid_index` (`uuid`),
  CONSTRAINT `tickets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tickets` WRITE;
/*!40000 ALTER TABLE `tickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `tickets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payable_type` varchar(255) NOT NULL,
  `payable_id` bigint(20) unsigned NOT NULL,
  `price` double NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `payment_sys_id` bigint(20) unsigned DEFAULT NULL,
  `payment_trx_id` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `perform_time` timestamp NULL DEFAULT NULL,
  `refund_time` timestamp NULL DEFAULT NULL,
  `status` enum('progress','paid','canceled','rejected','refund') NOT NULL DEFAULT 'progress',
  `status_description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_payable_type_payable_id_index` (`payable_type`,`payable_id`),
  KEY `transactions_payable_id_index` (`payable_id`),
  KEY `transactions_payable_type_index` (`payable_type`),
  KEY `transactions_user_id_index` (`user_id`),
  KEY `transactions_status_index` (`status`),
  CONSTRAINT `transactions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL DEFAULT 1,
  `locale` varchar(255) NOT NULL,
  `group` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `translations_group_key_locale_unique` (`group`,`key`,`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2382 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `translations` WRITE;
/*!40000 ALTER TABLE `translations` DISABLE KEYS */;
INSERT INTO `translations` VALUES (1,1,'en','web','add.storeis','Add storeis','2024-12-30 00:58:25','2024-12-30 00:58:25'),(2,1,'ru','web','add.storeis','Добавить магазины','2024-12-30 00:58:25','2024-12-30 00:58:25'),(3,1,'en','web','storeis','Storeis','2024-12-30 00:58:25','2024-12-30 00:58:25'),(4,1,'ru','web','storeis','Cклад','2024-12-30 00:58:25','2024-12-30 00:58:25'),(5,1,'en','web','add.story','Add story','2024-12-30 00:58:25','2024-12-30 00:58:25'),(6,1,'ru','web','add.story','Добавить историю','2024-12-30 00:58:25','2024-12-30 00:58:25'),(7,1,'en','web','agree_location','Do you agree to receive the default location ?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(8,1,'ru','web','agree_location','Согласны ли вы получить местоположение по умолчанию?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(9,1,'en','web','no_shop','No shop','2024-12-30 00:58:25','2024-12-30 00:58:25'),(10,1,'ru','web','no_shop','No shop','2024-12-30 00:58:25','2024-12-30 00:58:25'),(11,1,'en','web','rating_courier','Rating courier','2024-12-30 00:58:25','2024-12-30 00:58:25'),(12,1,'ru','web','rating_courier','Rating courier','2024-12-30 00:58:25','2024-12-30 00:58:25'),(13,1,'en','web','send_message','Send message','2024-12-30 00:58:25','2024-12-30 00:58:25'),(14,1,'ru','web','send_message','Отправить сообщение','2024-12-30 00:58:25','2024-12-30 00:58:25'),(15,1,'en','web','call_the_driver','Call the driver','2024-12-30 00:58:25','2024-12-30 00:58:25'),(16,1,'ru','web','call_the_driver','Позвонить водителю','2024-12-30 00:58:25','2024-12-30 00:58:25'),(17,1,'en','web','call_center_restaurant','Call Center Restaurant','2024-12-30 00:58:25','2024-12-30 00:58:25'),(18,1,'ru','web','call_center_restaurant','Колл-центр Ресторан','2024-12-30 00:58:25','2024-12-30 00:58:25'),(19,1,'en','web','promo_code','Promo code','2024-12-30 00:58:25','2024-12-30 00:58:25'),(20,1,'ru','web','promo_code','Промо-код','2024-12-30 00:58:25','2024-12-30 00:58:25'),(21,1,'en','web','add_promocode','Add Promocode','2024-12-30 00:58:25','2024-12-30 00:58:25'),(22,1,'ru','web','add_promocode','Добавить промокод','2024-12-30 00:58:25','2024-12-30 00:58:25'),(23,1,'en','web','your_card_below','Your card below','2024-12-30 00:58:25','2024-12-30 00:58:25'),(24,1,'ru','web','your_card_below','Ваша карта ниже','2024-12-30 00:58:25','2024-12-30 00:58:25'),(25,1,'en','mobile','do_you_want_to_delete_it?','Do you want to delete it?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(27,1,'en','web','full_name','Full name','2024-12-30 00:58:25','2024-12-30 00:58:25'),(28,1,'ru','web','full_name','ФИО','2024-12-30 00:58:25','2024-12-30 00:58:25'),(29,1,'en','web','alternative_number','alternative number','2024-12-30 00:58:25','2024-12-30 00:58:25'),(30,1,'ru','web','alternative_number','альтернативный номер','2024-12-30 00:58:25','2024-12-30 00:58:25'),(31,1,'en','web','enter_OTP_code','Enter OTP code','2024-12-30 00:58:25','2024-12-30 00:58:25'),(32,1,'ru','web','enter_OTP_code','Введите OTP-код','2024-12-30 00:58:25','2024-12-30 00:58:25'),(33,1,'en','web','country','country','2024-12-30 00:58:25','2024-12-30 00:58:25'),(34,1,'ru','web','country','страна','2024-12-30 00:58:25','2024-12-30 00:58:25'),(35,1,'en','web','skip','Skip','2024-12-30 00:58:25','2024-12-30 00:58:25'),(36,1,'ru','web','skip','Пропускать','2024-12-30 00:58:25','2024-12-30 00:58:25'),(37,1,'en','web','logout','Logout','2024-12-30 00:58:25','2024-12-30 00:58:25'),(38,1,'ru','web','logout','Выйти','2024-12-30 00:58:25','2024-12-30 00:58:25'),(39,1,'en','web','apply','Apply','2024-12-30 00:58:25','2024-12-30 00:58:25'),(40,1,'ru','web','apply','Подать заявление','2024-12-30 00:58:25','2024-12-30 00:58:25'),(41,1,'en','web','delivery_time','Delivery time','2024-12-30 00:58:25','2024-12-30 00:58:25'),(42,1,'ru','web','delivery_time','Срок поставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(43,1,'en','web','select_delivery_time','Select delivery time','2024-12-30 00:58:25','2024-12-30 00:58:25'),(44,1,'ru','web','select_delivery_time','Выберите время доставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(45,1,'en','errors','ERROR_507','Can`t delete record that has products.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(46,1,'ru','errors','ERROR_507','Невозможно удалить запись с продуктами.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(47,1,'en','web','password_should_contain_minimum_8_characters','Password should contain minimum 8 characters','2024-12-30 00:58:25','2024-12-30 00:58:25'),(48,1,'ru','web','password_should_contain_minimum_8_characters','Пароль должен содержать минимум 8 символов','2024-12-30 00:58:25','2024-12-30 00:58:25'),(49,1,'en','web','still_have_questions','Still have questions?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(50,1,'ru','web','still_have_questions','Остались вопросы?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(51,1,'en','web','cant_find_the_answer','Can’t find the answer you’re looking or? Please chat to our friendly team.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(52,1,'ru','web','cant_find_the_answer','Не можете найти ответ, который вы ищете или? Пожалуйста, пообщайтесь с нашей дружной командой.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(53,1,'en','web','call_to_support','Call to support','2024-12-30 00:58:25','2024-12-30 00:58:25'),(54,1,'ru','web','call_to_support','Звонок в поддержку','2024-12-30 00:58:25','2024-12-30 00:58:25'),(55,1,'en','web','delivery_address','Delivery address','2024-12-30 00:58:25','2024-12-30 00:58:25'),(56,1,'ru','web','delivery_address','Адресс доставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(57,1,'en','web','time_delivery','Time delivery','2024-12-30 00:58:25','2024-12-30 00:58:25'),(58,1,'ru','web','time_delivery','Время доставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(59,1,'en','web','today','Today','2024-12-30 00:58:25','2024-12-30 00:58:25'),(60,1,'ru','web','today','Сегодня','2024-12-30 00:58:26','2024-12-30 00:58:26'),(61,1,'en','web','cash','Cash','2024-12-30 00:58:26','2024-12-30 00:58:26'),(62,1,'ru','web','cash','Наличе','2024-12-30 00:58:26','2024-12-30 00:58:26'),(65,1,'en','web','delivery.range','{{times}} min','2024-12-30 00:58:26','2024-12-30 00:58:26'),(66,1,'ru','web','delivery.range','{{times}} мин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(67,1,'en','web','number.of.foods','{{count}} foods','2024-12-30 00:58:26','2024-12-30 00:58:26'),(68,1,'ru','web','number.of.foods','{{count}} продуктов','2024-12-30 00:58:26','2024-12-30 00:58:26'),(69,1,'en','web','active_orders','Active Orders','2024-12-30 00:58:26','2024-12-30 00:58:26'),(70,1,'ru','web','active_orders','Активные заказы','2024-12-30 00:58:26','2024-12-30 00:58:26'),(71,1,'en','web','tomorrow','Tomorrow','2024-12-30 00:58:26','2024-12-30 00:58:26'),(72,1,'ru','web','tomorrow','Завтра','2024-12-30 00:58:26','2024-12-30 00:58:26'),(73,1,'en','web','other','Other','2024-12-30 00:58:26','2024-12-30 00:58:26'),(74,1,'ru','web','other','Другой','2024-12-30 00:58:26','2024-12-30 00:58:26'),(75,1,'en','web','min','min','2024-12-30 00:58:26','2024-12-30 00:58:26'),(76,1,'ru','web','min','мин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(77,1,'en','web','shop_tax','Shop tax','2024-12-30 00:58:26','2024-12-30 00:58:26'),(78,1,'ru','web','shop_tax','Налог на магазин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(79,1,'en','web','total_discount','Total discount','2024-12-30 00:58:26','2024-12-30 00:58:26'),(80,1,'ru','web','total_discount','Общая скидка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(81,1,'en','web','discount','Discount','2024-12-30 00:58:26','2024-12-30 00:58:26'),(82,1,'ru','web','discount','Скидка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(83,1,'en','web','500','Server error','2024-12-30 00:58:26','2024-12-30 00:58:26'),(84,1,'ru','web','500','Ошибка сервера','2024-12-30 00:58:26','2024-12-30 00:58:26'),(85,1,'en','web','400','Validation error','2024-12-30 00:58:26','2024-12-30 00:58:26'),(86,1,'ru','web','400','Ошибка валидации','2024-12-30 00:58:26','2024-12-30 00:58:26'),(87,1,'en','web','422','Validation error','2024-12-30 00:58:26','2024-12-30 00:58:26'),(88,1,'ru','web','422','Oшибка валидации','2024-12-30 00:58:26','2024-12-30 00:58:26'),(89,1,'en','web','not_work_today_and_tomorrow','The delivery service will not work today and tomorrow','2024-12-30 00:58:26','2024-12-30 00:58:26'),(90,1,'ru','web','not_work_today_and_tomorrow','Служба доставки не будет работать сегодня и завтра','2024-12-30 00:58:26','2024-12-30 00:58:26'),(91,1,'en','web','not_work_today','Delivery service is not available today','2024-12-30 00:58:26','2024-12-30 00:58:26'),(92,1,'ru','web','not_work_today','Служба доставки сегодня не работает','2024-12-30 00:58:26','2024-12-30 00:58:26'),(93,1,'en','web','not_work_tomorrow','Tomorrow`s delivery service will not work','2024-12-30 00:58:26','2024-12-30 00:58:26'),(94,1,'ru','web','not_work_tomorrow','Завтра служба доставки не работает','2024-12-30 00:58:26','2024-12-30 00:58:26'),(95,1,'en','web','not_work_today_time','Delivery service is not available at this time today','2024-12-30 00:58:26','2024-12-30 00:58:26'),(96,1,'ru','web','not_work_today_time','Служба доставки сегодня не работает в это время','2024-12-30 00:58:26','2024-12-30 00:58:26'),(97,1,'en','web','you_have_promo_code','You have promo code','2024-12-30 00:58:26','2024-12-30 00:58:26'),(98,1,'ru','web','you_have_promo_code','У вас есть промокод','2024-12-30 00:58:26','2024-12-30 00:58:26'),(99,1,'en','web','new','New','2024-12-30 00:58:26','2024-12-30 00:58:26'),(100,1,'ru','web','new','Новый','2024-12-30 00:58:26','2024-12-30 00:58:26'),(101,1,'en','web','accepted','Accepted','2024-12-30 00:58:26','2024-12-30 00:58:26'),(102,1,'ru','web','accepted','Принято','2024-12-30 00:58:26','2024-12-30 00:58:26'),(103,1,'en','web','driver','Driver','2024-12-30 00:58:26','2024-12-30 00:58:26'),(104,1,'ru','web','driver','Водитель','2024-12-30 00:58:26','2024-12-30 00:58:26'),(105,1,'en','web','no_driver','No driver is assigned to this order','2024-12-30 00:58:26','2024-12-30 00:58:26'),(106,1,'ru','web','no_driver','Водитель не назначен этому заказу','2024-12-30 00:58:26','2024-12-30 00:58:26'),(107,1,'en','web','shop','Shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(108,1,'ru','web','shop','Магазин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(109,1,'en','web','under','Under','2024-12-30 00:58:26','2024-12-30 00:58:26'),(110,1,'ru','web','under','Под','2024-12-30 00:58:26','2024-12-30 00:58:26'),(111,1,'en','web','show','Show','2024-12-30 00:58:26','2024-12-30 00:58:26'),(112,1,'ru','web','show','Показать','2024-12-30 00:58:26','2024-12-30 00:58:26'),(113,1,'en','web','from','From','2024-12-30 00:58:26','2024-12-30 00:58:26'),(114,1,'ru','web','from','От','2024-12-30 00:58:26','2024-12-30 00:58:26'),(115,1,'en','web','price_range','Price range','2024-12-30 00:58:26','2024-12-30 00:58:26'),(116,1,'ru','web','price_range','Ценовой диапазон','2024-12-30 00:58:26','2024-12-30 00:58:26'),(117,1,'en','web','rating','Rating','2024-12-30 00:58:26','2024-12-30 00:58:26'),(118,1,'ru','web','rating','Рейтинг','2024-12-30 00:58:26','2024-12-30 00:58:26'),(119,1,'en','web','special_offers','Special offers','2024-12-30 00:58:26','2024-12-30 00:58:26'),(120,1,'ru','web','special_offers','Специальные предложения','2024-12-30 00:58:26','2024-12-30 00:58:26'),(121,1,'en','web','sort_by','Sort by','2024-12-30 00:58:26','2024-12-30 00:58:26'),(122,1,'ru','web','sort_by','Сортировать по','2024-12-30 00:58:26','2024-12-30 00:58:26'),(123,1,'en','web','free_delivery','Free delivery','2024-12-30 00:58:26','2024-12-30 00:58:26'),(124,1,'ru','web','free_delivery','Бесплатная доставка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(125,1,'en','web','this_time_is_not_available','This time is not available','2024-12-30 00:58:26','2024-12-30 00:58:26'),(126,1,'ru','web','this_time_is_not_available','Это время недоступно','2024-12-30 00:58:26','2024-12-30 00:58:26'),(127,1,'en','errors','ERROR_109','Insufficient wallet balance.','2024-12-30 00:58:26','2024-12-30 00:58:26'),(128,1,'ru','errors','ERROR_109','Недостаточный баланс кошелька.','2024-12-30 00:58:26','2024-12-30 00:58:26'),(129,1,'en','web','product.title','Product title','2024-12-30 00:58:26','2024-12-30 00:58:26'),(130,1,'ru','web','product.title','Название продукта','2024-12-30 00:58:26','2024-12-30 00:58:26'),(131,1,'en','web','item.sold','Item sold','2024-12-30 00:58:26','2024-12-30 00:58:26'),(132,1,'ru','web','item.sold','Товар продан','2024-12-30 00:58:26','2024-12-30 00:58:26'),(133,1,'en','web','net.sales','Net sales','2024-12-30 00:58:26','2024-12-30 00:58:26'),(134,1,'ru','web','net.sales','Чистые продажи','2024-12-30 00:58:26','2024-12-30 00:58:26'),(135,1,'en','web','variations','Variations','2024-12-30 00:58:26','2024-12-30 00:58:26'),(136,1,'ru','web','variations','Вариации','2024-12-30 00:58:26','2024-12-30 00:58:26'),(137,1,'en','web','report.products','Report products','2024-12-30 00:58:26','2024-12-30 00:58:26'),(138,1,'ru','web','report.products','Сообщить о продуктах','2024-12-30 00:58:26','2024-12-30 00:58:26'),(139,1,'en','web','report.orders','Report orders','2024-12-30 00:58:26','2024-12-30 00:58:26'),(140,1,'ru','web','report.orders','Сообщить о заказах','2024-12-30 00:58:26','2024-12-30 00:58:26'),(141,1,'en','web','report.stock','Report stock','2024-12-30 00:58:26','2024-12-30 00:58:26'),(142,1,'ru','web','report.stock','Сообщить о наличии','2024-12-30 00:58:26','2024-12-30 00:58:26'),(143,1,'en','web','report.categories','Report categories','2024-12-30 00:58:26','2024-12-30 00:58:26'),(144,1,'ru','web','report.categories','Категории отчетов','2024-12-30 00:58:26','2024-12-30 00:58:26'),(145,1,'en','web','report.overview','Report overview','2024-12-30 00:58:26','2024-12-30 00:58:26'),(146,1,'ru','web','report.overview','Обзор отчета','2024-12-30 00:58:26','2024-12-30 00:58:26'),(147,1,'en','web','report.revenue','Report revenue','2024-12-30 00:58:26','2024-12-30 00:58:26'),(148,1,'ru','web','report.revenue','Сообщить о доходах','2024-12-30 00:58:26','2024-12-30 00:58:26'),(149,1,'en','web','report.variation','Report variation','2024-12-30 00:58:26','2024-12-30 00:58:26'),(150,1,'ru','web','report.variation','Вариант отчета','2024-12-30 00:58:26','2024-12-30 00:58:26'),(151,1,'en','web','refound','Refund','2024-12-30 00:58:26','2024-12-30 00:58:26'),(152,1,'ru','web','refound','Возвращать деньги','2024-12-30 00:58:26','2024-12-30 00:58:26'),(153,1,'en','web','loading','Loading','2024-12-30 00:58:26','2024-12-30 00:58:26'),(154,1,'ru','web','loading','Загрузка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(155,1,'en','errors','ERROR_206','User already has Shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(156,1,'ru','errors','ERROR_206','User already has Shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(157,1,'en','web','ERROR_506','Already exists','2024-12-30 00:58:26','2024-12-30 00:58:26'),(158,1,'ru','web','ERROR_506','Уже существует','2024-12-30 00:58:26','2024-12-30 00:58:26'),(159,1,'en','web','button.text','Button text','2024-12-30 00:58:26','2024-12-30 00:58:26'),(160,1,'ru','web','button.text','Текст кнопки','2024-12-30 00:58:26','2024-12-30 00:58:26'),(161,1,'en','web','clickable','Clickable','2024-12-30 00:58:26','2024-12-30 00:58:26'),(162,1,'ru','web','clickable','Кликабельно','2024-12-30 00:58:26','2024-12-30 00:58:26'),(163,1,'en','web','no_payment_type','No payment type','2024-12-30 00:58:26','2024-12-30 00:58:26'),(164,1,'ru','web','no_payment_type','Нет типа оплаты','2024-12-30 00:58:26','2024-12-30 00:58:26'),(165,1,'en','web','you_cant_create_order','You can`t create an order because there is no payment type','2024-12-30 00:58:26','2024-12-30 00:58:26'),(166,1,'ru','web','you_cant_create_order','Вы не можете создать заказ, потому что нет типа оплаты','2024-12-30 00:58:26','2024-12-30 00:58:26'),(167,1,'en','web','payment_type_is_not_added','Payment type is not added in this restaurant or shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(168,1,'ru','web','payment_type_is_not_added','Тип оплаты не добавлен в этот ресторан или магазин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(169,1,'en','web','gift_buy','is a gift if you buy under','2024-12-30 00:58:26','2024-12-30 00:58:26'),(170,1,'ru','web','gift_buy','это подарок, если вы покупаете под','2024-12-30 00:58:26','2024-12-30 00:58:26'),(171,1,'en','web','count','Count','2024-12-30 00:58:26','2024-12-30 00:58:26'),(172,1,'ru','web','count','Считать','2024-12-30 00:58:26','2024-12-30 00:58:26'),(173,1,'en','web','want_it','I want it','2024-12-30 00:58:26','2024-12-30 00:58:26'),(174,1,'ru','web','want_it','Я хочу это','2024-12-30 00:58:26','2024-12-30 00:58:26'),(175,1,'en','web','select.all','Select all','2024-12-30 00:58:26','2024-12-30 00:58:26'),(176,1,'ru','web','select.all','Select all','2024-12-30 00:58:26','2024-12-30 00:58:26'),(177,1,'en','web','why_do_you_want','Why do you want to refund?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(178,1,'ru','web','why_do_you_want','Почему вы хотите вернуть деньги?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(179,1,'en','web','successfully','Successfully','2024-12-30 00:58:26','2024-12-30 00:58:26'),(180,1,'ru','web','successfully','Успешно','2024-12-30 00:58:26','2024-12-30 00:58:26'),(181,1,'en','web','cause','Cause','2024-12-30 00:58:26','2024-12-30 00:58:26'),(182,1,'ru','web','cause','Причина','2024-12-30 00:58:26','2024-12-30 00:58:26'),(183,1,'en','web','empty.description','Data Not Found','2024-12-30 00:58:26','2024-12-30 00:58:26'),(184,1,'ru','web','empty.description','Данные не найдены','2024-12-30 00:58:26','2024-12-30 00:58:26'),(185,1,'en','web','answer','Answer','2024-12-30 00:58:26','2024-12-30 00:58:26'),(186,1,'ru','web','answer','Отвечать','2024-12-30 00:58:26','2024-12-30 00:58:26'),(187,1,'en','web','are_you_sure','Are you sure ?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(188,1,'ru','web','are_you_sure','Уверены ли вы ?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(189,1,'en','web','delete_account','Delete account','2024-12-30 00:58:26','2024-12-30 00:58:26'),(190,1,'ru','web','delete_account','Удалить аккаунт','2024-12-30 00:58:26','2024-12-30 00:58:26'),(191,1,'en','web','schedulet.at','Schedulet at','2024-12-30 00:58:26','2024-12-30 00:58:26'),(192,1,'ru','web','schedulet.at','Расписание в','2024-12-30 00:58:26','2024-12-30 00:58:26'),(193,1,'en','web','order.type','Order type','2024-12-30 00:58:26','2024-12-30 00:58:26'),(194,1,'ru','web','order.type','Тип заказа','2024-12-30 00:58:26','2024-12-30 00:58:26'),(195,1,'en','web','download.pdf','Download pdf','2024-12-30 00:58:26','2024-12-30 00:58:26'),(196,1,'ru','web','download.pdf','Download pdf','2024-12-30 00:58:26','2024-12-30 00:58:26'),(197,1,'en','web','download.check','Download check','2024-12-30 00:58:26','2024-12-30 00:58:26'),(198,1,'ru','web','download.check','Download check','2024-12-30 00:58:27','2024-12-30 00:58:27'),(199,1,'en','web','BILL.TO','BILL TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(200,1,'ru','web','BILL.TO','BILL.TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(201,1,'en','web','all.rights.reserved','All rights reserved.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(202,1,'ru','web','all.rights.reserved','All rights reserved.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(203,1,'en','web','shop/restaurant','Shop/Restaurant','2024-12-30 00:58:27','2024-12-30 00:58:27'),(204,1,'ru','web','shop/restaurant','Shop/Restaurant','2024-12-30 00:58:27','2024-12-30 00:58:27'),(205,1,'en','web','data.between','DATE BETWEEN','2024-12-30 00:58:27','2024-12-30 00:58:27'),(206,1,'ru','web','data.between','DATE BETWEEN','2024-12-30 00:58:27','2024-12-30 00:58:27'),(207,1,'en','web','to','TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(208,1,'ru','web','to','TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(209,1,'en','web','data.start','Data start','2024-12-30 00:58:27','2024-12-30 00:58:27'),(210,1,'ru','web','data.start','Data start','2024-12-30 00:58:27','2024-12-30 00:58:27'),(211,1,'en','web','data.end','Data end','2024-12-30 00:58:27','2024-12-30 00:58:27'),(212,1,'ru','web','data.end','Data end','2024-12-30 00:58:27','2024-12-30 00:58:27'),(213,1,'en','web','Your.existing.vacations','Your existing vacations','2024-12-30 00:58:27','2024-12-30 00:58:27'),(214,1,'ru','web','Your.existing.vacations','Your existing vacations','2024-12-30 00:58:27','2024-12-30 00:58:27'),(215,1,'en','web','trust_you','Trust you','2024-12-30 00:58:27','2024-12-30 00:58:27'),(216,1,'ru','web','trust_you','Доверять тебе','2024-12-30 00:58:27','2024-12-30 00:58:27'),(217,1,'en','web','best_sale','Best sale','2024-12-30 00:58:27','2024-12-30 00:58:27'),(218,1,'ru','web','best_sale','Лучшая продажа','2024-12-30 00:58:27','2024-12-30 00:58:27'),(219,1,'en','web','highly_rated','Highly rated','2024-12-30 00:58:27','2024-12-30 00:58:27'),(220,1,'ru','web','highly_rated','Высокий рейтинг','2024-12-30 00:58:27','2024-12-30 00:58:27'),(221,1,'en','web','low_sale','Low sale','2024-12-30 00:58:27','2024-12-30 00:58:27'),(222,1,'ru','web','low_sale','Низкая распродажа','2024-12-30 00:58:27','2024-12-30 00:58:27'),(223,1,'en','web','low_rating','Low rating','2024-12-30 00:58:27','2024-12-30 00:58:27'),(224,1,'ru','web','low_rating','Низкий рейтинг','2024-12-30 00:58:27','2024-12-30 00:58:27'),(225,1,'en','web','please.days','Please pick one or more days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(226,1,'ru','web','please.days','Please pick one or more days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(227,1,'en','web','notification','Notification','2024-12-30 00:58:27','2024-12-30 00:58:27'),(228,1,'ru','web','notification','Уведомление','2024-12-30 00:58:27','2024-12-30 00:58:27'),(229,1,'en','web','closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(230,1,'ru','web','closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates  here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(231,1,'en','web','Shop.closed.days','Shop closed.days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(232,1,'ru','web','Shop.closed.days','Shop closed.days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(233,1,'en','web','accepted.orders.count','Accepted orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(234,1,'ru','web','accepted.orders.count','Accepted orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(235,1,'en','web','cancel.orders.count','Cancel orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(236,1,'ru','web','cancel.orders.count','Cancel orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(237,1,'en','web','delivered.orders.count','Delivered orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(238,1,'ru','web','delivered.orders.count','Delivered orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(239,1,'en','web','new.orders.count','New orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(240,1,'ru','web','new.orders.count','New orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(241,1,'en','web','on_a_way_orders_count','On a way orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(242,1,'ru','web','on_a_way_orders_count','On a way orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(243,1,'en','web','progress_orders_count','Progress orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(244,1,'ru','web','progress_orders_count','Progress orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(245,1,'en','web','ready_orders_count','Ready orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(246,1,'ru','web','ready_orders_count','Ready orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(247,1,'en','web','orders.count','Orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(248,1,'ru','web','orders.count','Orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(249,1,'en','web','type_here','Type here','2024-12-30 00:58:27','2024-12-30 00:58:27'),(250,1,'ru','web','type_here','Введите сюда','2024-12-30 00:58:27','2024-12-30 00:58:27'),(251,1,'en','web','deliveries','Deliveries','2024-12-30 00:58:27','2024-12-30 00:58:27'),(252,1,'ru','web','deliveries','Deliveries','2024-12-30 00:58:27','2024-12-30 00:58:27'),(253,1,'en','web','total.orders','Total orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(254,1,'ru','web','total.orders','Total orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(255,1,'en','web','total.earning','Total earning','2024-12-30 00:58:27','2024-12-30 00:58:27'),(256,1,'ru','web','total.earning','Total earning','2024-12-30 00:58:27','2024-12-30 00:58:27'),(257,1,'en','web','payment_method_failed','Payment method failed','2024-12-30 00:58:27','2024-12-30 00:58:27'),(258,1,'ru','web','payment_method_failed','Способ оплаты не выполнен','2024-12-30 00:58:27','2024-12-30 00:58:27'),(259,1,'en','web','repeat_order','Repeat order','2024-12-30 00:58:27','2024-12-30 00:58:27'),(260,1,'ru','web','repeat_order','Повторите заказ','2024-12-30 00:58:27','2024-12-30 00:58:27'),(261,1,'en','web','delivery.zone.text','Click this icon to start pin points in the map and connect them to draw a zone . Minimum 3 points required','2024-12-30 00:58:27','2024-12-30 00:58:27'),(262,1,'ru','web','delivery.zone.text','Click this icon to start pin points in the map and connect them to draw a zone . Minimum 3 points required','2024-12-30 00:58:27','2024-12-30 00:58:27'),(263,1,'en','web','place.selected.map','Please draw the delivery zone first','2024-12-30 00:58:27','2024-12-30 00:58:27'),(264,1,'ru','web','place.selected.map','Please draw the delivery zone first','2024-12-30 00:58:27','2024-12-30 00:58:27'),(265,1,'en','web','products','Products','2024-12-30 00:58:27','2024-12-30 00:58:27'),(266,1,'ru','web','products','Продукты','2024-12-30 00:58:27','2024-12-30 00:58:27'),(267,1,'en','web','add_address_information','Add address information','2024-12-30 00:58:27','2024-12-30 00:58:27'),(268,1,'ru','web','add_address_information','Добавить адресную информацию','2024-12-30 00:58:27','2024-12-30 00:58:27'),(269,1,'en','web','info','Info','2024-12-30 00:58:27','2024-12-30 00:58:27'),(270,1,'ru','web','info','Info','2024-12-30 00:58:27','2024-12-30 00:58:27'),(271,1,'en','web','import.text_1','Download the skeleton file and fill it with proper data.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(272,1,'ru','web','import.text_1','Download the skeleton file and fill it with proper data.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(273,1,'en','web','import.text_2','You can download the example file to understand how the data must be filled.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(274,1,'ru','web','import.text_2','You can download the example file to understand how the data must be filled.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(275,1,'en','web','import.text_3','Once you have downloaded and filled the skeleton file, upload it in the form below and submit.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(276,1,'ru','web','import.text_3','Once you have downloaded and filled the skeleton file, upload it in the form below and submit.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(277,1,'en','web','import.text_4','After uploading products you need to edit them and set product`s images and choices.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(278,1,'ru','web','import.text_4','After uploading products you need to edit them and set product`s images and choices.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(279,1,'en','web','restaurant.closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(280,1,'ru','web','restaurant.closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(281,1,'en','web','add.user','Add user','2024-12-30 00:58:27','2024-12-30 00:58:27'),(282,1,'ru','web','add.user','Add user','2024-12-30 00:58:27','2024-12-30 00:58:27'),(283,1,'en','web','is.not.valid.file','is not valid file','2024-12-30 00:58:27','2024-12-30 00:58:27'),(284,1,'ru','web','is.not.valid.file','is not valid file','2024-12-30 00:58:27','2024-12-30 00:58:27'),(285,1,'en','web','upload-drag','Click or drag file to this area to upload','2024-12-30 00:58:27','2024-12-30 00:58:27'),(286,1,'ru','web','upload-drag','Click or drag file to this area to upload','2024-12-30 00:58:27','2024-12-30 00:58:27'),(287,1,'en','web','upload-text','Using this file, it is possible to create a database of new products. You need to click the button above to update','2024-12-30 00:58:27','2024-12-30 00:58:27'),(288,1,'ru','web','upload-text','Using this file, it is possible to create a database of new products. You need to click the button above to update','2024-12-30 00:58:27','2024-12-30 00:58:27'),(289,1,'en','web','you_fully_manage','You fully manage the order and confirm the address. Team members can add a product from a location of your choice.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(290,1,'ru','web','you_fully_manage','Вы полностью управляете заказом и подтверждаете адрес. Члены команды могут добавить продукт из любого места по вашему выбору.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(291,1,'en','web','he_is_choosing','He is choosing','2024-12-30 00:58:27','2024-12-30 00:58:27'),(292,1,'ru','web','he_is_choosing','он выбирает','2024-12-30 00:58:27','2024-12-30 00:58:27'),(293,1,'en','web','done','Done','2024-12-30 00:58:27','2024-12-30 00:58:27'),(294,1,'ru','web','done','Сделанный','2024-12-30 00:58:27','2024-12-30 00:58:27'),(295,1,'en','web','delete_user','Delete user','2024-12-30 00:58:27','2024-12-30 00:58:27'),(296,1,'ru','web','delete_user','Удалить пользователя','2024-12-30 00:58:27','2024-12-30 00:58:27'),(297,1,'en','web','group_order_progress','In the group order, the users order is in progress, can you continue even then?','2024-12-30 00:58:27','2024-12-30 00:58:27'),(298,1,'ru','web','group_order_progress','Обработка оптового заказа пользователя, продолжить?','2024-12-30 00:58:27','2024-12-30 00:58:27'),(299,1,'en','web','owner','Owner','2024-12-30 00:58:27','2024-12-30 00:58:27'),(300,1,'ru','web','owner','Владелец','2024-12-30 00:58:27','2024-12-30 00:58:27'),(301,1,'en','web','car.model','Car model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(302,1,'ru','web','car.model','Car model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(303,1,'en','web','online.time','Online.time','2024-12-30 00:58:27','2024-12-30 00:58:27'),(304,1,'ru','web','online.time','Online time','2024-12-30 00:58:27','2024-12-30 00:58:27'),(305,1,'en','web','add.delivery.setting','Create delivery setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(306,1,'ru','web','add.delivery.setting','Create delivery setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(307,1,'en','web','type.of.technique','Type of technique','2024-12-30 00:58:27','2024-12-30 00:58:27'),(308,1,'ru','web','type.of.technique','Type of technique','2024-12-30 00:58:27','2024-12-30 00:58:27'),(309,1,'en','web','car.number','Car number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(310,1,'ru','web','car.number','Car number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(311,1,'en','web','car.color','Car color','2024-12-30 00:58:27','2024-12-30 00:58:27'),(312,1,'ru','web','car.color','Car color','2024-12-30 00:58:27','2024-12-30 00:58:27'),(313,1,'en','web','deliveryman.attached','Deliveryman attached','2024-12-30 00:58:27','2024-12-30 00:58:27'),(314,1,'ru','web','deliveryman.attached','Deliveryman attached','2024-12-30 00:58:27','2024-12-30 00:58:27'),(315,1,'en','web','Go.to.installation','Go to installation','2024-12-30 00:58:27','2024-12-30 00:58:27'),(316,1,'ru','web','Go.to.installation','Go to installation','2024-12-30 00:58:27','2024-12-30 00:58:27'),(317,1,'en','web','isset-deliveryman','11','2024-12-30 00:58:27','2024-12-30 00:58:27'),(318,1,'ru','web','isset-deliveryman','1','2024-12-30 00:58:27','2024-12-30 00:58:27'),(319,1,'ru','mobile2','successfully_updated12','Successfully updated12','2024-12-30 00:58:27','2024-12-30 00:58:27'),(320,1,'en','mobile2','successfully_updated12','Успешо обновлен123','2024-12-30 00:58:27','2024-12-30 00:58:27'),(321,1,'en','web','delivery.man.setting','Deliveryman setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(322,1,'ru','web','delivery.man.setting','Deliveryman setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(323,1,'en','web','add.settings','Add settings','2024-12-30 00:58:27','2024-12-30 00:58:27'),(324,1,'ru','web','add.settings','Add settings','2024-12-30 00:58:27','2024-12-30 00:58:27'),(325,1,'en','web','number','Number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(326,1,'ru','web','number','Number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(327,1,'en','web','model','Model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(328,1,'ru','web','model','Model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(329,1,'en','web','ingredients','Ingredients','2024-12-30 00:58:27','2024-12-30 00:58:27'),(330,1,'ru','web','ingredients','Ингредиенты','2024-12-30 00:58:27','2024-12-30 00:58:27'),(331,1,'en','web','canceled.orders','Canceled orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(332,1,'ru','web','canceled.orders','Canceled orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(333,1,'en','web','completed.orders','Completed orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(334,1,'ru','web','completed.orders','Completed orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(335,1,'en','web','benzine','Benzine','2024-12-30 00:58:27','2024-12-30 00:58:27'),(336,1,'ru','web','benzine','Бензин','2024-12-30 00:58:28','2024-12-30 00:58:28'),(337,1,'en','web','diesel','Diesel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(338,1,'ru','web','diesel','Дизель','2024-12-30 00:58:28','2024-12-30 00:58:28'),(339,1,'en','web','gas','Gas','2024-12-30 00:58:28','2024-12-30 00:58:28'),(340,1,'ru','web','gas','Газ','2024-12-30 00:58:28','2024-12-30 00:58:28'),(341,1,'en','web','motorbike','Motorbike','2024-12-30 00:58:28','2024-12-30 00:58:28'),(342,1,'ru','web','motorbike','мотоцикл','2024-12-30 00:58:28','2024-12-30 00:58:28'),(343,1,'en','web','bike','Bike','2024-12-30 00:58:28','2024-12-30 00:58:28'),(344,1,'ru','web','bike','Велосипед','2024-12-30 00:58:28','2024-12-30 00:58:28'),(345,1,'en','web','foot','Foot','2024-12-30 00:58:28','2024-12-30 00:58:28'),(346,1,'ru','web','foot','Нога','2024-12-30 00:58:28','2024-12-30 00:58:28'),(347,1,'en','web','available_orders','Available orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(348,1,'ru','web','available_orders','Доступные заказы','2024-12-30 00:58:28','2024-12-30 00:58:28'),(349,1,'en','web','show.orders','Show orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(350,1,'ru','web','show.orders','Show orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(351,1,'en','web','deliveryman.orders','Deliveryman orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(352,1,'ru','web','deliveryman.orders','Deliveryman orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(353,1,'ru','web','ready.orders.count','Ready orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(354,1,'en','web','ready.orders.count','Ready orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(355,1,'ru','web','progress.orders.count','progress orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(356,1,'en','web','progress.orders.count','progress orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(357,1,'ru','web','payment_date','Payment Date','2024-12-30 00:58:28','2024-12-30 00:58:28'),(358,1,'en','web','payment_date','Дата платежа','2024-12-30 00:58:28','2024-12-30 00:58:28'),(359,1,'ru','web','sender','Отправитель','2024-12-30 00:58:28','2024-12-30 00:58:28'),(360,1,'en','web','sender','Sender','2024-12-30 00:58:28','2024-12-30 00:58:28'),(361,1,'ru','web','deposit_withdrawl','Депозит/Вывод средств','2024-12-30 00:58:28','2024-12-30 00:58:28'),(362,1,'en','web','deposit_withdrawl','Deposit/Withdrawl','2024-12-30 00:58:28','2024-12-30 00:58:28'),(363,1,'ru','web','there_are','There are','2024-12-30 00:58:28','2024-12-30 00:58:28'),(364,1,'en','web','there_are','Есть','2024-12-30 00:58:28','2024-12-30 00:58:28'),(365,1,'ru','web','note_about_the_client','Примечание о клиенте','2024-12-30 00:58:28','2024-12-30 00:58:28'),(366,1,'en','web','note_about_the_client','A note about the client','2024-12-30 00:58:28','2024-12-30 00:58:28'),(367,1,'ru','web','rate_the_customer','Оценить клиента','2024-12-30 00:58:28','2024-12-30 00:58:28'),(368,1,'en','web','rate_the_customer','Rate the customer','2024-12-30 00:58:28','2024-12-30 00:58:28'),(369,1,'ru','web','your_feedback_will_help_us_improve_our_delivery_service','Ваш отзыв поможет нам улучшить нашу службу доставки','2024-12-30 00:58:28','2024-12-30 00:58:28'),(370,1,'en','web','your_feedback_will_help_us_improve_our_delivery_service','Your feedback will help us improve our delivery service','2024-12-30 00:58:28','2024-12-30 00:58:28'),(371,1,'ru','web','evaluation','Оценка','2024-12-30 00:58:28','2024-12-30 00:58:28'),(372,1,'en','web','evaluation','Evaluation','2024-12-30 00:58:28','2024-12-30 00:58:28'),(373,1,'ru','web','delivered_the_order','Я доставил заказ','2024-12-30 00:58:28','2024-12-30 00:58:28'),(374,1,'en','web','delivered_the_order','I delivered the order','2024-12-30 00:58:28','2024-12-30 00:58:28'),(375,1,'ru','web','approve','Утвердить','2024-12-30 00:58:28','2024-12-30 00:58:28'),(376,1,'en','web','approve','Approve','2024-12-30 00:58:28','2024-12-30 00:58:28'),(377,1,'ru','web','the_order_do_you_confirm?','заказ вы подтверждаете?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(378,1,'en','web','the_order_do_you_confirm?','the order do you confirm?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(379,1,'ru','web','that_you_have_indeed','Что у вас действительно','2024-12-30 00:58:28','2024-12-30 00:58:28'),(380,1,'en','web','that_you_have_indeed','That you have indeed','2024-12-30 00:58:28','2024-12-30 00:58:28'),(381,1,'ru','web','received','Полученный','2024-12-30 00:58:28','2024-12-30 00:58:28'),(382,1,'en','web','received','Received','2024-12-30 00:58:28','2024-12-30 00:58:28'),(383,1,'ru','web','order_information','Запросить информацию','2024-12-30 00:58:28','2024-12-30 00:58:28'),(384,1,'en','web','order_information','Order information','2024-12-30 00:58:28','2024-12-30 00:58:28'),(385,1,'ru','web','accept','Принимать','2024-12-30 00:58:28','2024-12-30 00:58:28'),(386,1,'en','web','accept','Accept','2024-12-30 00:58:28','2024-12-30 00:58:28'),(387,1,'ru','web','car_picture','Картинка автомобиля','2024-12-30 00:58:28','2024-12-30 00:58:28'),(388,1,'en','web','car_picture','Car picture','2024-12-30 00:58:28','2024-12-30 00:58:28'),(389,1,'ru','web','color','Цвет','2024-12-30 00:58:28','2024-12-30 00:58:28'),(390,1,'en','web','color','Color','2024-12-30 00:58:28','2024-12-30 00:58:28'),(391,1,'ru','web','state_number','Государственный номер','2024-12-30 00:58:28','2024-12-30 00:58:28'),(392,1,'en','web','state_number','State number','2024-12-30 00:58:28','2024-12-30 00:58:28'),(393,1,'ru','web','car_models','Автомобильные модели','2024-12-30 00:58:28','2024-12-30 00:58:28'),(394,1,'en','web','car_models','Car models','2024-12-30 00:58:28','2024-12-30 00:58:28'),(395,1,'ru','web','car_brand','Марка машины','2024-12-30 00:58:28','2024-12-30 00:58:28'),(396,1,'en','web','car_brand','Car brand','2024-12-30 00:58:28','2024-12-30 00:58:28'),(397,1,'ru','web','type_of_technique','Тип техники','2024-12-30 00:58:28','2024-12-30 00:58:28'),(398,1,'en','web','type_of_technique','Type of technique','2024-12-30 00:58:28','2024-12-30 00:58:28'),(399,1,'ru','web','delivery_vehicle','Транспортное средство доставки','2024-12-30 00:58:28','2024-12-30 00:58:28'),(400,1,'en','web','delivery_vehicle','Delivery vehicle','2024-12-30 00:58:28','2024-12-30 00:58:28'),(401,1,'ru','web','your_name','Твое имя','2024-12-30 00:58:28','2024-12-30 00:58:28'),(402,1,'en','web','your_name','Your name','2024-12-30 00:58:28','2024-12-30 00:58:28'),(403,1,'ru','web','apart','Кроме.','2024-12-30 00:58:28','2024-12-30 00:58:28'),(404,1,'en','web','apart','Apart.','2024-12-30 00:58:28','2024-12-30 00:58:28'),(405,1,'ru','web','entr','Вход','2024-12-30 00:58:28','2024-12-30 00:58:28'),(406,1,'en','web','entr','Entr.','2024-12-30 00:58:28','2024-12-30 00:58:28'),(407,1,'ru','web','home','Дом','2024-12-30 00:58:28','2024-12-30 00:58:28'),(408,1,'en','web','home','Home','2024-12-30 00:58:28','2024-12-30 00:58:28'),(409,1,'ru','web','restauran_home','Ресторан — Главная','2024-12-30 00:58:28','2024-12-30 00:58:28'),(410,1,'en','web','restauran_home','Restaurant — Home','2024-12-30 00:58:28','2024-12-30 00:58:28'),(411,1,'ru','web','login_credentials_are_not_valid','Учетные данные для входа недействительны','2024-12-30 00:58:28','2024-12-30 00:58:28'),(412,1,'en','web','login_credentials_are_not_valid','Login credentials are not valid','2024-12-30 00:58:28','2024-12-30 00:58:28'),(413,1,'ru','web','user.password.change','User password change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(414,1,'en','web','user.password.change','User password change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(415,1,'ru','web','active.time','Active time','2024-12-30 00:58:28','2024-12-30 00:58:28'),(416,1,'en','web','active.time','Active time','2024-12-30 00:58:28','2024-12-30 00:58:28'),(417,1,'ru','web','filter','Фильтр','2024-12-30 00:58:28','2024-12-30 00:58:28'),(418,1,'en','web','filter','Filter','2024-12-30 00:58:28','2024-12-30 00:58:28'),(419,1,'ru','web','top.rating','Top rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(420,1,'en','web','top.rating','Top rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(421,1,'ru','web','lowest.rating','Lowest rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(422,1,'en','web','lowest.rating','Lowest rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(423,1,'ru','web','top.orders','Top orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(424,1,'en','web','top.orders','Top orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(425,1,'ru','web','lowest.orders','Lowest orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(426,1,'en','web','lowest.orders','Lowest orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(427,1,'ru','web','top.earner','Top earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(428,1,'en','web','top.earner','Top earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(429,1,'ru','web','lowest.earner','Lowest earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(430,1,'en','web','lowest.earner','Lowest earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(431,1,'ru','web','default','Default','2024-12-30 00:58:28','2024-12-30 00:58:28'),(432,1,'en','web','default','Default','2024-12-30 00:58:28','2024-12-30 00:58:28'),(433,1,'ru','web','delivery_time_type','Тип времени доставки','2024-12-30 00:58:28','2024-12-30 00:58:28'),(434,1,'en','web','delivery_time_type','Delivery time type','2024-12-30 00:58:28','2024-12-30 00:58:28'),(435,1,'ru','web','delivery_time_from','Срок доставки от','2024-12-30 00:58:28','2024-12-30 00:58:28'),(436,1,'en','web','delivery_time_from','Delivery time from','2024-12-30 00:58:28','2024-12-30 00:58:28'),(437,1,'ru','web','delivery_time_to','Срок доставки до','2024-12-30 00:58:28','2024-12-30 00:58:28'),(438,1,'en','web','delivery_time_to','Delivery time to','2024-12-30 00:58:28','2024-12-30 00:58:28'),(439,1,'ru','web','start_price','Стартовая цена','2024-12-30 00:58:28','2024-12-30 00:58:28'),(440,1,'en','web','start_price','Start price','2024-12-30 00:58:28','2024-12-30 00:58:28'),(441,1,'ru','web','price_per_km','Цена за км','2024-12-30 00:58:28','2024-12-30 00:58:28'),(442,1,'en','web','price_per_km','Price per km','2024-12-30 00:58:28','2024-12-30 00:58:28'),(443,1,'ru','web','address','Адрес','2024-12-30 00:58:28','2024-12-30 00:58:28'),(444,1,'en','web','address','Address','2024-12-30 00:58:28','2024-12-30 00:58:28'),(445,1,'ar','web','restore.all','Restore all','2024-12-30 00:58:28','2024-12-30 00:58:28'),(446,1,'ru','web','restore.all','Restore all','2024-12-30 00:58:28','2024-12-30 00:58:28'),(447,1,'en','web','restore.all','Restore all','2024-12-30 00:58:28','2024-12-30 00:58:28'),(448,1,'ar','web','restore.modal.text','Are you sure you want to restore deleted products?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(449,1,'ru','web','restore.modal.text','Are you sure you want to restore deleted products?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(450,1,'en','web','restore.modal.text','Are you sure you want to restore deleted products?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(451,1,'el','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(452,1,'ar','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(453,1,'ru','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(454,1,'en','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(455,1,'el','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(456,1,'ar','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(457,1,'ru','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(458,1,'en','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(459,1,'el','web','your_request_is_being_processed','Ваш запрос обрабатывается','2024-12-30 00:58:28','2024-12-30 00:58:28'),(460,1,'ar','web','your_request_is_being_processed','Ваш запрос обрабатывается','2024-12-30 00:58:28','2024-12-30 00:58:28'),(461,1,'ru','web','your_request_is_being_processed','Ваш запрос обрабатывается','2024-12-30 00:58:28','2024-12-30 00:58:28'),(462,1,'en','web','your_request_is_being_processed','Your request is being processed','2024-12-30 00:58:28','2024-12-30 00:58:28'),(463,1,'el','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(464,1,'ar','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(465,1,'ru','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(466,1,'en','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(467,1,'uzbek','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(468,1,'el','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(469,1,'ar','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(470,1,'ru','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(471,1,'en','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(472,1,'uzbek','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(473,1,'el','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(474,1,'ar','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(475,1,'ru','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(476,1,'en','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(477,1,'el','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(478,1,'ar','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(479,1,'ru','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(480,1,'en','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(481,1,'el','web','delivery.information','Delivery Information','2024-12-30 00:58:28','2024-12-30 00:58:28'),(482,1,'ar','web','delivery.information','Delivery Information','2024-12-30 00:58:28','2024-12-30 00:58:28'),(483,1,'ru','web','delivery.information','Delivery Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(484,1,'en','web','delivery.information','Delivery Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(485,1,'el','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(486,1,'ar','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(487,1,'ru','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(488,1,'en','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(489,1,'el','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(490,1,'ar','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(491,1,'ru','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(492,1,'en','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(493,1,'el','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(494,1,'ar','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(495,1,'ru','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(496,1,'en','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(497,1,'el','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(498,1,'ar','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(499,1,'ru','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(500,1,'en','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(501,1,'el','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(502,1,'ar','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(503,1,'ru','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(504,1,'en','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(505,1,'el','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(506,1,'ar','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(507,1,'ru','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(508,1,'en','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(509,1,'el','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(510,1,'ar','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(511,1,'ru','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(512,1,'en','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(513,1,'el','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(514,1,'ar','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(515,1,'ru','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(516,1,'en','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(517,1,'el','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(518,1,'ar','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(519,1,'ru','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(520,1,'en','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(521,1,'el','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(522,1,'ar','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(523,1,'ru','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(524,1,'en','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(525,1,'el','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(526,1,'ar','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(527,1,'ru','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(528,1,'en','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(529,1,'el','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(530,1,'ar','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(531,1,'ru','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(532,1,'en','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(533,1,'el','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(534,1,'ar','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(535,1,'ru','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(536,1,'en','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(537,1,'el','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(538,1,'ar','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(539,1,'ru','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(540,1,'en','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(541,1,'el','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(542,1,'ar','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(543,1,'ru','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(544,1,'en','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(545,1,'el','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(546,1,'ar','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(547,1,'ru','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(548,1,'en','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(549,1,'el','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(550,1,'ar','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(551,1,'ru','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(552,1,'en','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(553,1,'el','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(554,1,'ar','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(555,1,'ru','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(556,1,'en','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(557,1,'el','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(558,1,'ar','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(559,1,'ru','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(560,1,'en','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(561,1,'el','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(562,1,'ar','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(563,1,'ru','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(564,1,'en','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(565,1,'el','web','about','About','2024-12-30 00:58:29','2024-12-30 00:58:29'),(566,1,'ar','web','about','About','2024-12-30 00:58:29','2024-12-30 00:58:29'),(567,1,'en','web','about','About','2024-12-30 00:58:29','2024-12-30 00:58:29'),(568,1,'el','web','careers','Careers','2024-12-30 00:58:29','2024-12-30 00:58:29'),(569,1,'ar','web','careers','Careers','2024-12-30 00:58:29','2024-12-30 00:58:29'),(570,1,'en','web','careers','Careers','2024-12-30 00:58:29','2024-12-30 00:58:29'),(571,1,'el','web','privacy_policy','Privacy Policy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(572,1,'ar','web','privacy_policy','Privacy Policy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(573,1,'en','web','privacy_policy','Privacy Policy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(574,1,'el','web','sign_up_to_deliver','Sign up to deliver','2024-12-30 00:58:29','2024-12-30 00:58:29'),(575,1,'ar','web','sign_up_to_deliver','Sign up to deliver','2024-12-30 00:58:29','2024-12-30 00:58:29'),(576,1,'en','web','sign_up_to_deliver','Sign up to deliver','2024-12-30 00:58:29','2024-12-30 00:58:29'),(577,1,'av','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(578,1,'el','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(579,1,'ar','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(580,1,'en','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(581,1,'av','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(582,1,'el','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(583,1,'ar','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(584,1,'en','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(585,1,'av','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(586,1,'el','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(587,1,'ar','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(588,1,'en','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(589,1,'av','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(590,1,'el','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(591,1,'ar','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(592,1,'en','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(593,1,'el','web','otp.expire.time','Otp expire time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(594,1,'en','web','otp.expire.time','Otp expire time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(595,1,'el','web','blog.active','Blog active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(596,1,'en','web','blog.active','Blog active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(597,1,'el','web','prompt.email.modal','Prompt email modal','2024-12-30 00:58:29','2024-12-30 00:58:29'),(598,1,'en','web','prompt.email.modal','Prompt email modal','2024-12-30 00:58:29','2024-12-30 00:58:29'),(599,1,'el','web','no.active.referral','To change the referral, turn it on in the settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(600,1,'en','web','no.active.referral','To change the referral, turn it on in the settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(601,1,'el','web','aws.active','Aws active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(602,1,'en','web','aws.active','Aws active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(603,1,'el','web','max_qty','You can`t add more than','2024-12-30 00:58:29','2024-12-30 00:58:29'),(604,1,'en','web','max_qty','You can`t add more than','2024-12-30 00:58:29','2024-12-30 00:58:29'),(605,1,'el','web','add.tag','Add tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(606,1,'en','web','add.tag','Add tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(607,1,'el','web','add.shop.tag','Add shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(608,1,'en','web','add.shop.tag','Add shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(609,1,'el','web','shop.tags','Shop tags','2024-12-30 00:58:29','2024-12-30 00:58:29'),(610,1,'en','web','shop.tags','Shop tags','2024-12-30 00:58:29','2024-12-30 00:58:29'),(611,1,'el','web','distribution.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(612,1,'en','web','distribution.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(613,1,'el','web','edit.shop.tag','Edit shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(614,1,'en','web','edit.shop.tag','Edit shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(615,1,'el','web','referral.active','Referral active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(616,1,'en','web','referral.active','Referral active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(617,1,'el','web','your_order_status_has_been_changed','Your order status has been changed','2024-12-30 00:58:29','2024-12-30 00:58:29'),(618,1,'ar','web','your_order_status_has_been_changed','Your order status has been changed','2024-12-30 00:58:29','2024-12-30 00:58:29'),(619,1,'en','web','your_order_status_has_been_changed','Your order status has been changed','2024-12-30 00:58:29','2024-12-30 00:58:29'),(620,1,'ar','web','locale','Locale','2024-12-30 00:58:29','2024-12-30 00:58:29'),(621,1,'en','web','locale','Locale','2024-12-30 00:58:29','2024-12-30 00:58:29'),(622,1,'ar','web','open.time','Open time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(623,1,'en','web','open.time','Open time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(624,1,'ar','web','results','نتائج','2024-12-30 00:58:29','2024-12-30 00:58:29'),(625,1,'en','web','results','Results','2024-12-30 00:58:29','2024-12-30 00:58:29'),(626,1,'ar','web','found','وجد','2024-12-30 00:58:29','2024-12-30 00:58:29'),(627,1,'en','web','found','Found','2024-12-30 00:58:29','2024-12-30 00:58:29'),(629,1,'en','mobile','payment_methods','Payment methods','2024-12-30 00:58:29','2024-12-30 00:58:29'),(632,1,'ar','web','house','منزل','2024-12-30 00:58:29','2024-12-30 00:58:29'),(633,1,'en','web','house','House','2024-12-30 00:58:29','2024-12-30 00:58:29'),(634,1,'ar','web','Office','مكتب','2024-12-30 00:58:29','2024-12-30 00:58:29'),(635,1,'en','web','Office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(636,1,'ar','web','add','يضيف','2024-12-30 00:58:29','2024-12-30 00:58:29'),(637,1,'en','web','add','Add','2024-12-30 00:58:30','2024-12-30 00:58:30'),(638,1,'ar','web','clear','واضح','2024-12-30 00:58:30','2024-12-30 00:58:30'),(639,1,'en','web','clear','Clear','2024-12-30 00:58:30','2024-12-30 00:58:30'),(641,1,'en','mobile','delivery_price','Delivery price','2024-12-30 00:58:30','2024-12-30 00:58:30'),(642,1,'ar','web','total','المجموع','2024-12-30 00:58:30','2024-12-30 00:58:30'),(643,1,'en','web','total','Total','2024-12-30 00:58:30','2024-12-30 00:58:30'),(645,1,'en','web','popular','Popular','2024-12-30 00:58:30','2024-12-30 00:58:30'),(646,1,'ar','web','recommended','مُستَحسَن','2024-12-30 00:58:30','2024-12-30 00:58:30'),(647,1,'en','web','recommended','Recommended','2024-12-30 00:58:30','2024-12-30 00:58:30'),(649,1,'en','web','send','Send','2024-12-30 00:58:30','2024-12-30 00:58:30'),(653,1,'en','mobile','select_language','Select language','2024-12-30 00:58:30','2024-12-30 00:58:30'),(654,1,'ar','web','next','التالي','2024-12-30 00:58:30','2024-12-30 00:58:30'),(655,1,'en','web','next','Next','2024-12-30 00:58:30','2024-12-30 00:58:30'),(656,1,'ar','web','email','بريد إلكتروني','2024-12-30 00:58:30','2024-12-30 00:58:30'),(657,1,'en','web','email','Email','2024-12-30 00:58:30','2024-12-30 00:58:30'),(658,1,'ar','web','register','اشتراك','2024-12-30 00:58:30','2024-12-30 00:58:30'),(659,1,'en','web','register','Sign up','2024-12-30 00:58:30','2024-12-30 00:58:30'),(660,1,'ar','web','see_all','اظهار الكل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(661,1,'en','web','see_all','See all','2024-12-30 00:58:30','2024-12-30 00:58:30'),(662,1,'ar','web','profile_settings','إعدادات الملف الشخصي','2024-12-30 00:58:30','2024-12-30 00:58:30'),(663,1,'en','web','profile_settings','Profile settings','2024-12-30 00:58:30','2024-12-30 00:58:30'),(665,1,'en','web','cancel','Cancel','2024-12-30 00:58:30','2024-12-30 00:58:30'),(666,1,'ar','web','yes','نعم','2024-12-30 00:58:30','2024-12-30 00:58:30'),(667,1,'en','web','yes','Yes','2024-12-30 00:58:30','2024-12-30 00:58:30'),(668,1,'ar','web','cart_is_empty','البطاقه خاليه','2024-12-30 00:58:30','2024-12-30 00:58:30'),(669,1,'en','web','cart_is_empty','Cart is empty','2024-12-30 00:58:30','2024-12-30 00:58:30'),(670,1,'ar','web','delivery','توصيل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(671,1,'en','web','delivery','Delivery','2024-12-30 00:58:30','2024-12-30 00:58:30'),(672,1,'ar','web','pickup','يلتقط','2024-12-30 00:58:30','2024-12-30 00:58:30'),(673,1,'en','web','pickup','Pickup','2024-12-30 00:58:30','2024-12-30 00:58:30'),(674,1,'ar','web','delivery.address','عنوان التسليم','2024-12-30 00:58:30','2024-12-30 00:58:30'),(675,1,'en','web','delivery.address','Delivery address','2024-12-30 00:58:30','2024-12-30 00:58:30'),(676,1,'ar','web','subtotal','المجموع الفرعي','2024-12-30 00:58:30','2024-12-30 00:58:30'),(677,1,'en','web','subtotal','Subtotal','2024-12-30 00:58:30','2024-12-30 00:58:30'),(678,1,'ar','web','total_tax','مجموع الضريبة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(679,1,'en','web','total_tax','Total tax','2024-12-30 00:58:30','2024-12-30 00:58:30'),(680,1,'ar','web','404','غير معثور عليه','2024-12-30 00:58:30','2024-12-30 00:58:30'),(681,1,'en','web','404','Not found','2024-12-30 00:58:30','2024-12-30 00:58:30'),(682,1,'ar','web','ready','مستعد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(683,1,'en','web','ready','Ready','2024-12-30 00:58:30','2024-12-30 00:58:30'),(684,1,'ar','web','delivered','تم التوصيل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(685,1,'en','web','delivered','Delivered','2024-12-30 00:58:30','2024-12-30 00:58:30'),(686,1,'ar','web','canceled','ألغيت','2024-12-30 00:58:30','2024-12-30 00:58:30'),(687,1,'en','web','canceled','Canceled','2024-12-30 00:58:30','2024-12-30 00:58:30'),(688,1,'ar','web','cancel_order','الغاء الطلب','2024-12-30 00:58:30','2024-12-30 00:58:30'),(689,1,'en','web','cancel_order','Cancel order','2024-12-30 00:58:30','2024-12-30 00:58:30'),(690,1,'ar','web','qr.code','الباركود','2024-12-30 00:58:30','2024-12-30 00:58:30'),(691,1,'en','web','qr.code','Barcode','2024-12-30 00:58:30','2024-12-30 00:58:30'),(692,1,'ar','web','all','الجميع','2024-12-30 00:58:30','2024-12-30 00:58:30'),(693,1,'en','web','all','All','2024-12-30 00:58:30','2024-12-30 00:58:30'),(694,1,'ar','web','working_hours','ساعات العمل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(695,1,'en','web','working_hours','Working hours','2024-12-30 00:58:30','2024-12-30 00:58:30'),(697,1,'en','web','language','Language','2024-12-30 00:58:30','2024-12-30 00:58:30'),(699,1,'en','web','save','Save','2024-12-30 00:58:30','2024-12-30 00:58:30'),(701,1,'en','web','orders','Orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(703,1,'en','mobile','income','Income','2024-12-30 00:58:30','2024-12-30 00:58:30'),(704,1,'ar','web','order_history','تاريخ الطلب','2024-12-30 00:58:30','2024-12-30 00:58:30'),(705,1,'en','web','order_history','Order history','2024-12-30 00:58:30','2024-12-30 00:58:30'),(707,1,'en','mobile','successfully_completed','Successfully completed','2024-12-30 00:58:30','2024-12-30 00:58:30'),(709,1,'en','mobile','info_message','Info message','2024-12-30 00:58:30','2024-12-30 00:58:30'),(715,1,'en','mobile','access_denied','Access denied','2024-12-30 00:58:30','2024-12-30 00:58:30'),(717,1,'en','mobile','ready_orders','Ready orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(719,1,'en','mobile','on_a_way_orders','On a way orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(721,1,'en','mobile','accepted_orders','Accepted orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(722,1,'ar','web','payment.method','طريقة الدفع او السداد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(723,1,'en','web','payment.method','Payment method','2024-12-30 00:58:30','2024-12-30 00:58:30'),(724,1,'ar','web','not_found','غير معثور عليه','2024-12-30 00:58:30','2024-12-30 00:58:30'),(725,1,'en','web','not_found','Not found','2024-12-30 00:58:30','2024-12-30 00:58:30'),(726,1,'ar','web','new.user','مستخدم جديد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(727,1,'en','web','new.user','New user','2024-12-30 00:58:30','2024-12-30 00:58:30'),(728,1,'ar','web','monday','الاثنين','2024-12-30 00:58:30','2024-12-30 00:58:30'),(729,1,'en','web','monday','Monday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(730,1,'ar','web','tuesday','يوم الثلاثاء','2024-12-30 00:58:30','2024-12-30 00:58:30'),(731,1,'en','web','tuesday','Tuesday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(732,1,'ar','web','wednesday','الأربعاء','2024-12-30 00:58:30','2024-12-30 00:58:30'),(733,1,'en','web','wednesday','Wednesday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(734,1,'ar','web','thursday','يوم الخميس','2024-12-30 00:58:30','2024-12-30 00:58:30'),(735,1,'en','web','thursday','Thursday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(736,1,'ar','web','friday','جمعة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(737,1,'en','web','friday','Friday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(738,1,'ar','web','saturday','السبت','2024-12-30 00:58:30','2024-12-30 00:58:30'),(739,1,'en','web','saturday','Saturday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(740,1,'ar','web','sunday','الأحد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(741,1,'en','web','sunday','Sunday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(742,1,'ar','web','order.statistic','ترتيب الإحصاء','2024-12-30 00:58:30','2024-12-30 00:58:30'),(743,1,'en','web','order.statistic','Order statistic','2024-12-30 00:58:30','2024-12-30 00:58:30'),(745,1,'en','web','description','Description','2024-12-30 00:58:30','2024-12-30 00:58:30'),(747,1,'en','mobile','phone_number','Phone number','2024-12-30 00:58:30','2024-12-30 00:58:30'),(749,1,'en','mobile','add_product','Add product','2024-12-30 00:58:30','2024-12-30 00:58:30'),(751,1,'en','mobile','product_category','Product category','2024-12-30 00:58:30','2024-12-30 00:58:30'),(753,1,'en','mobile','add_new_category','Add new category','2024-12-30 00:58:30','2024-12-30 00:58:30'),(755,1,'en','mobile','show_the_product_to_the_customer','Show the product to the customer','2024-12-30 00:58:30','2024-12-30 00:58:30'),(757,1,'en','mobile','edit_product','Edit product','2024-12-30 00:58:30','2024-12-30 00:58:30'),(759,1,'en','mobile','cannot_be_empty','Cannot be empty','2024-12-30 00:58:30','2024-12-30 00:58:30'),(761,1,'en','mobile','update_failed','Update failed','2024-12-30 00:58:30','2024-12-30 00:58:30'),(763,1,'en','web','stocks','Stocks','2024-12-30 00:58:30','2024-12-30 00:58:30'),(765,1,'en','mobile','order_price','Order price','2024-12-30 00:58:30','2024-12-30 00:58:30'),(767,1,'en','web','quantity','Quantity','2024-12-30 00:58:30','2024-12-30 00:58:30'),(769,1,'en','mobile','close','Close','2024-12-30 00:58:30','2024-12-30 00:58:30'),(771,1,'en','mobile','max_quantity','Max quantity','2024-12-30 00:58:30','2024-12-30 00:58:30'),(773,1,'en','mobile','min_quantity','Min quantity','2024-12-30 00:58:30','2024-12-30 00:58:30'),(775,1,'en','web','tax','Tax','2024-12-30 00:58:30','2024-12-30 00:58:30'),(777,1,'en','mobile','delivery_zone','Delivery zone','2024-12-30 00:58:30','2024-12-30 00:58:30'),(779,1,'en','mobile','no_transaction','No transaction','2024-12-30 00:58:30','2024-12-30 00:58:30'),(781,1,'en','mobile','try_searching_again','Try searching again, we believe you will find something','2024-12-30 00:58:30','2024-12-30 00:58:30'),(783,1,'en','mobile','order_now','Order now','2024-12-30 00:58:30','2024-12-30 00:58:30'),(785,1,'en','web','help','Help','2024-12-30 00:58:30','2024-12-30 00:58:30'),(787,1,'en','mobile','mobile_number','Mobile number','2024-12-30 00:58:31','2024-12-30 00:58:31'),(789,1,'en','web','login','Login','2024-12-30 00:58:31','2024-12-30 00:58:31'),(791,1,'en','mobile','no_restaurant','No Restaurant','2024-12-30 00:58:31','2024-12-30 00:58:31'),(793,1,'en','mobile','nothing_found','Nothing found','2024-12-30 00:58:31','2024-12-30 00:58:31'),(795,1,'en','mobile','enter_a_delivery_address','Enter a delivery address','2024-12-30 00:58:31','2024-12-30 00:58:31'),(797,1,'en','mobile','clear_all','Clear all','2024-12-30 00:58:31','2024-12-30 00:58:31'),(799,1,'en','mobile','do_you_really_want_to_logout','Do you really want to logout','2024-12-30 00:58:31','2024-12-30 00:58:31'),(801,1,'en','mobile','no_orders','No orders available at this time. As soon as customers place an order we will show you','2024-12-30 00:58:31','2024-12-30 00:58:31'),(803,1,'en','mobile','enter_the_restaurant_opening_hours','Enter the restaurant opening hours','2024-12-30 00:58:31','2024-12-30 00:58:31'),(805,1,'en','mobile','set_as_a_business_day','Set as a business day','2024-12-30 00:58:31','2024-12-30 00:58:31'),(807,1,'en','mobile','product_picture','Product picture','2024-12-30 00:58:31','2024-12-30 00:58:31'),(809,1,'en','mobile','confirm_location','Confirm location','2024-12-30 00:58:31','2024-12-30 00:58:31'),(811,1,'en','mobile','search_location','Search location','2024-12-30 00:58:31','2024-12-30 00:58:31'),(813,1,'en','mobile','select_delivery_date','Select delivery date','2024-12-30 00:58:31','2024-12-30 00:58:31'),(815,1,'en','mobile','out_of_stock','Out of stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(817,1,'en','mobile','please_select_a_user','Please select a user','2024-12-30 00:58:31','2024-12-30 00:58:31'),(819,1,'en','mobile','swipe_to_accept','Swipe to accept','2024-12-30 00:58:31','2024-12-30 00:58:31'),(821,1,'en','mobile','successfully_updated','Successfully completed','2024-12-30 00:58:31','2024-12-30 00:58:31'),(822,1,'ar','web','deals','صفقات','2024-12-30 00:58:31','2024-12-30 00:58:31'),(823,1,'en','web','deals','Deals','2024-12-30 00:58:31','2024-12-30 00:58:31'),(824,1,'ar','web','open_shop','فتح فقط','2024-12-30 00:58:31','2024-12-30 00:58:31'),(825,1,'en','web','open_shop','Only opened','2024-12-30 00:58:31','2024-12-30 00:58:31'),(826,1,'ar','web','ratings','التقييمات','2024-12-30 00:58:31','2024-12-30 00:58:31'),(827,1,'en','web','ratings','Ratings','2024-12-30 00:58:31','2024-12-30 00:58:31'),(828,1,'ar','web','open_until','مفتوحة حتى','2024-12-30 00:58:31','2024-12-30 00:58:31'),(829,1,'en','web','open_until','Open until','2024-12-30 00:58:31','2024-12-30 00:58:31'),(830,1,'ar','web','not_enough_money','ليس هناك ما يكفي من المال في محفظتك','2024-12-30 00:58:31','2024-12-30 00:58:31'),(831,1,'en','web','not_enough_money','There is not enough money in your wallet','2024-12-30 00:58:31','2024-12-30 00:58:31'),(832,1,'ar','web','add.email.provider','أضف مزود البريد الإلكتروني','2024-12-30 00:58:31','2024-12-30 00:58:31'),(833,1,'en','web','add.email.provider','Add email provider','2024-12-30 00:58:31','2024-12-30 00:58:31'),(834,1,'ar','web','username','اسم المستخدم','2024-12-30 00:58:31','2024-12-30 00:58:31'),(835,1,'en','web','username','Username','2024-12-30 00:58:31','2024-12-30 00:58:31'),(836,1,'ar','web','smtp_auth','مصادقة SMTP','2024-12-30 00:58:31','2024-12-30 00:58:31'),(837,1,'en','web','smtp_auth','Smtp auth','2024-12-30 00:58:31','2024-12-30 00:58:31'),(838,1,'ar','web','smtp_debug','تصحيح أخطاء SMTP','2024-12-30 00:58:31','2024-12-30 00:58:31'),(839,1,'en','web','smtp_debug','Smtp debug','2024-12-30 00:58:31','2024-12-30 00:58:31'),(840,1,'ar','web','host','يستضيف','2024-12-30 00:58:31','2024-12-30 00:58:31'),(841,1,'en','web','host','Host','2024-12-30 00:58:31','2024-12-30 00:58:31'),(842,1,'ar','web','port','ميناء','2024-12-30 00:58:31','2024-12-30 00:58:31'),(843,1,'en','web','port','Port','2024-12-30 00:58:31','2024-12-30 00:58:31'),(844,1,'ar','web','required.email','الإدخال ليس بريدًا إلكترونيًا صالحًا!','2024-12-30 00:58:31','2024-12-30 00:58:31'),(845,1,'en','web','required.email','The input is not valid E-mail!','2024-12-30 00:58:31','2024-12-30 00:58:31'),(847,1,'en','web','password','Password','2024-12-30 00:58:31','2024-12-30 00:58:31'),(849,1,'en','mobile','keep_me_logged_in','Keep me logged in','2024-12-30 00:58:31','2024-12-30 00:58:31'),(851,1,'en','mobile','forgot_password','Forgot password','2024-12-30 00:58:31','2024-12-30 00:58:31'),(853,1,'en','mobile','demo_login_password','Demo login password','2024-12-30 00:58:31','2024-12-30 00:58:31'),(855,1,'en','mobile','email_is_not_valid','Email is not valid','2024-12-30 00:58:31','2024-12-30 00:58:31'),(857,1,'en','mobile','password_should_contain_minimum_6_characters','Password should contain minimum 6 characters','2024-12-30 00:58:31','2024-12-30 00:58:31'),(858,1,'ar','web','no_driver_zone','Sorry, we`re not available here','2024-12-30 00:58:31','2024-12-30 00:58:31'),(859,1,'en','web','no_driver_zone','Sorry, we`re not available here','2024-12-30 00:58:31','2024-12-30 00:58:31'),(861,1,'en','web','search','Search','2024-12-30 00:58:31','2024-12-30 00:58:31'),(863,1,'en','mobile','news_of_the_week','News of the week','2024-12-30 00:58:31','2024-12-30 00:58:31'),(864,1,'ar','web','clone.banner','Clone banner','2024-12-30 00:58:31','2024-12-30 00:58:31'),(865,1,'en','web','clone.banner','Clone banner','2024-12-30 00:58:31','2024-12-30 00:58:31'),(868,1,'ar','web','referral_faq','Referral terms','2024-12-30 00:58:31','2024-12-30 00:58:31'),(869,1,'en','web','referral_faq','Referral terms','2024-12-30 00:58:31','2024-12-30 00:58:31'),(870,1,'ar','web','copied','Copied to clipboard','2024-12-30 00:58:31','2024-12-30 00:58:31'),(871,1,'en','web','copied','Copied to clipboard!','2024-12-30 00:58:31','2024-12-30 00:58:31'),(872,1,'ar','web','more_info','More info','2024-12-30 00:58:31','2024-12-30 00:58:31'),(873,1,'en','web','more_info','More info','2024-12-30 00:58:31','2024-12-30 00:58:31'),(874,1,'ar','web','no_internet_connection','There is some problem with your internet connection, please check and try again','2024-12-30 00:58:31','2024-12-30 00:58:31'),(875,1,'en','web','no_internet_connection','There is some problem with your internet connection, please check and try again','2024-12-30 00:58:31','2024-12-30 00:58:31'),(876,1,'ar','web','successfully.cleared','Successfully cleared','2024-12-30 00:58:31','2024-12-30 00:58:31'),(877,1,'en','web','successfully.cleared','Successfully cleared','2024-12-30 00:58:31','2024-12-30 00:58:31'),(878,1,'ar','web','order_status_ready','Please make the order status ready and then contact the deliveryman','2024-12-30 00:58:31','2024-12-30 00:58:31'),(879,1,'en','web','order_status_ready','Please make the order status ready and then contact the deliveryman','2024-12-30 00:58:31','2024-12-30 00:58:31'),(880,1,'ar','errors','ERROR_430','Stock quantity 0','2024-12-30 00:58:31','2024-12-30 00:58:31'),(881,1,'en','errors','ERROR_430','Stock quantity 0','2024-12-30 00:58:31','2024-12-30 00:58:31'),(882,1,'ar','web','ANALYTICS.ADN.REPORTS','Analytics and reporting','2024-12-30 00:58:31','2024-12-30 00:58:31'),(883,1,'en','web','ANALYTICS.ADN.REPORTS','Analytics and reporting','2024-12-30 00:58:31','2024-12-30 00:58:31'),(884,1,'ar','web','swipe_to_ready','Swipe to ready','2024-12-30 00:58:31','2024-12-30 00:58:31'),(885,1,'en','web','swipe_to_ready','Swipe to ready','2024-12-30 00:58:31','2024-12-30 00:58:31'),(886,1,'ar','web','swipe_to_way','Swipe to on a way','2024-12-30 00:58:31','2024-12-30 00:58:31'),(887,1,'en','web','swipe_to_way','Swipe to on a way','2024-12-30 00:58:31','2024-12-30 00:58:31'),(888,1,'ar','web','swipe_to_delivered','Swipe to delivered','2024-12-30 00:58:31','2024-12-30 00:58:31'),(889,1,'en','web','swipe_to_delivered','Swipe to delivered','2024-12-30 00:58:31','2024-12-30 00:58:31'),(890,1,'ar','web','in_active','Inactive','2024-12-30 00:58:31','2024-12-30 00:58:31'),(891,1,'en','web','in_active','Inactive','2024-12-30 00:58:31','2024-12-30 00:58:31'),(892,1,'el','web','qty','Qty','2024-12-30 00:58:31','2024-12-30 00:58:31'),(893,1,'ar','web','qty','Qty','2024-12-30 00:58:31','2024-12-30 00:58:31'),(894,1,'en','web','qty','Qty','2024-12-30 00:58:31','2024-12-30 00:58:31'),(895,1,'el','web','add.subscription','Add subscription','2024-12-30 00:58:31','2024-12-30 00:58:31'),(896,1,'ar','web','add.subscription','Add subscription','2024-12-30 00:58:31','2024-12-30 00:58:31'),(897,1,'en','web','add.subscription','Add subscription','2024-12-30 00:58:31','2024-12-30 00:58:31'),(898,1,'el','web','high_rating','High rating','2024-12-30 00:58:31','2024-12-30 00:58:31'),(899,1,'ar','web','high_rating','High rating','2024-12-30 00:58:31','2024-12-30 00:58:31'),(900,1,'en','web','high_rating','High rating','2024-12-30 00:58:31','2024-12-30 00:58:31'),(901,1,'el','web','bonus.stock','Bonus stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(902,1,'ar','web','bonus.stock','Bonus stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(903,1,'en','web','bonus.stock','Bonus stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(904,1,'el','web','time_schedule','Schedule delivery','2024-12-30 00:58:31','2024-12-30 00:58:31'),(905,1,'ar','web','time_schedule','Schedule delivery','2024-12-30 00:58:31','2024-12-30 00:58:31'),(906,1,'en','web','time_schedule','Schedule delivery','2024-12-30 00:58:31','2024-12-30 00:58:31'),(907,1,'ar','web','not_work','Delivery service is not available on','2024-12-30 00:58:31','2024-12-30 00:58:31'),(908,1,'en','web','not_work','Delivery service is not available on','2024-12-30 00:58:31','2024-12-30 00:58:31'),(909,1,'el','web','ERROR_212','Not your shop check your other account','2024-12-30 00:58:31','2024-12-30 00:58:31'),(910,1,'ar','web','ERROR_212','Not your shop check your other account','2024-12-30 00:58:31','2024-12-30 00:58:31'),(911,1,'en','web','ERROR_212','Not your shop check your other account','2024-12-30 00:58:31','2024-12-30 00:58:31'),(912,1,'el','errors','ERROR_213','Your subscription is expired at','2024-12-30 00:58:31','2024-12-30 00:58:31'),(913,1,'ar','errors','ERROR_213','Your subscription is expired at','2024-12-30 00:58:31','2024-12-30 00:58:31'),(914,1,'en','errors','ERROR_213','Your subscription is expired at','2024-12-30 00:58:31','2024-12-30 00:58:31'),(915,1,'el','errors','ERROR_214','Your subscription product limit has expired','2024-12-30 00:58:31','2024-12-30 00:58:31'),(916,1,'ar','errors','ERROR_214','Your subscription product limit has expired','2024-12-30 00:58:31','2024-12-30 00:58:31'),(917,1,'en','errors','ERROR_214','Your subscription product limit has expired','2024-12-30 00:58:31','2024-12-30 00:58:31'),(918,1,'el','web','ERROR_431','Active default currency not found','2024-12-30 00:58:32','2024-12-30 00:58:32'),(919,1,'ar','web','ERROR_431','Active default currency not found','2024-12-30 00:58:32','2024-12-30 00:58:32'),(920,1,'en','web','ERROR_431','Active default currency not found','2024-12-30 00:58:32','2024-12-30 00:58:32'),(921,1,'el','web','cancel_orders','Canceled orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(922,1,'ar','web','cancel_orders','Canceled orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(923,1,'en','web','cancel_orders','Canceled orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(924,1,'el','web','new_orders','New orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(925,1,'ar','web','new_orders','New orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(926,1,'en','web','new_orders','New orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(927,1,'el','web','business','Business','2024-12-30 00:58:32','2024-12-30 00:58:32'),(928,1,'ar','web','business','Business','2024-12-30 00:58:32','2024-12-30 00:58:32'),(929,1,'en','web','business','Business','2024-12-30 00:58:32','2024-12-30 00:58:32'),(930,1,'en','web','not.published','Not published','2024-12-30 00:58:32','2024-12-30 00:58:32'),(931,1,'en','web','published.date','Published date','2024-12-30 00:58:32','2024-12-30 00:58:32'),(932,1,'en','web','delete.chat','Delete chat','2024-12-30 00:58:32','2024-12-30 00:58:32'),(933,1,'en','web','edit.subscription','Edit subscription','2024-12-30 00:58:32','2024-12-30 00:58:32'),(934,1,'en','web','with_report','With report','2024-12-30 00:58:32','2024-12-30 00:58:32'),(935,1,'en','web','period','Period (month)','2024-12-30 00:58:32','2024-12-30 00:58:32'),(936,1,'en','web','order_limit','Order limit','2024-12-30 00:58:32','2024-12-30 00:58:32'),(937,1,'en','web','product_limit','Product limit','2024-12-30 00:58:32','2024-12-30 00:58:32'),(939,1,'en','mobile','floor','Floor','2024-12-30 00:58:32','2024-12-30 00:58:32'),(941,1,'en','mobile','the_restaurant_is_closed_today','The restaurant is closed today','2024-12-30 00:58:32','2024-12-30 00:58:32'),(943,1,'en','mobile','restaurant_name','Restaurant name','2024-12-30 00:58:32','2024-12-30 00:58:32'),(945,1,'en','mobile','restaurant_settings','Restaurant settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(946,1,'en','web','shop_and_restaurants','Shop and Restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(947,1,'en','web','liked_restaurants','Liked restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(948,1,'en','web','restaurants','Restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(950,1,'en','mobile','liked_restaurant','Liked restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(951,1,'en','web','all.restaurants','All restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(952,1,'en','web','zona','Zona','2024-12-30 00:58:32','2024-12-30 00:58:32'),(953,1,'en','web','Nutrition off','Nutrition off','2024-12-30 00:58:32','2024-12-30 00:58:32'),(954,1,'en','web','nutrition.on','Nutrition on','2024-12-30 00:58:32','2024-12-30 00:58:32'),(955,1,'en','web','basic.info','Basic Info','2024-12-30 00:58:32','2024-12-30 00:58:32'),(956,1,'en','web','pricing','Pricing','2024-12-30 00:58:32','2024-12-30 00:58:32'),(957,1,'en','web','additions','Additions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(958,1,'en','web','nutritional.value.of.food','Nutritional value of food','2024-12-30 00:58:32','2024-12-30 00:58:32'),(959,1,'en','web','organization','Organization','2024-12-30 00:58:32','2024-12-30 00:58:32'),(960,1,'en','web','media','Media','2024-12-30 00:58:32','2024-12-30 00:58:32'),(961,1,'en','web','nutrition.off','Nutrition off','2024-12-30 00:58:32','2024-12-30 00:58:32'),(962,1,'en','web','add.sms.geteways','Add sms geteways','2024-12-30 00:58:32','2024-12-30 00:58:32'),(963,1,'en','web','add.career.category','Add career category','2024-12-30 00:58:32','2024-12-30 00:58:32'),(964,1,'en','web','edit.career.category','Edit career category','2024-12-30 00:58:32','2024-12-30 00:58:32'),(965,1,'en','web','add.career','Add Career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(966,1,'en','web','edit.career','Edit Career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(967,1,'en','web','clone.career','Clone career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(968,1,'en','web','add.pages','Add page','2024-12-30 00:58:32','2024-12-30 00:58:32'),(969,1,'en','web','edit.page','Edit page','2024-12-30 00:58:32','2024-12-30 00:58:32'),(970,1,'en','web','recomention.time','Recomention time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(971,1,'en','web','chair.count','Chair count','2024-12-30 00:58:32','2024-12-30 00:58:32'),(972,1,'en','web','name','Name','2024-12-30 00:58:32','2024-12-30 00:58:32'),(973,1,'en','web','max.time','Max time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(974,1,'en','web','start.time','Start time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(975,1,'en','web','end.time','End time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(976,1,'en','web','pos.system','POS System','2024-12-30 00:58:32','2024-12-30 00:58:32'),(977,1,'en','web','delivery.orders','Delivery Orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(978,1,'en','web','reviews','Reviews','2024-12-30 00:58:32','2024-12-30 00:58:32'),(979,1,'en','web','refunds','Refunds','2024-12-30 00:58:32','2024-12-30 00:58:32'),(980,1,'en','web','order.status','Order status','2024-12-30 00:58:32','2024-12-30 00:58:32'),(981,1,'en','web','deliveryman','Deliveryman','2024-12-30 00:58:32','2024-12-30 00:58:32'),(982,1,'en','web','deliveries.list','Deliveries List','2024-12-30 00:58:32','2024-12-30 00:58:32'),(983,1,'en','web','deliveries.map','Deliveries map','2024-12-30 00:58:32','2024-12-30 00:58:32'),(984,1,'en','web','delivery.statistics','Delivery Statistics','2024-12-30 00:58:32','2024-12-30 00:58:32'),(985,1,'en','web','deliveryboy.reviews','Deliveryman reviews','2024-12-30 00:58:32','2024-12-30 00:58:32'),(986,1,'en','web','restaurant','Restaurant','2024-12-30 00:58:32','2024-12-30 00:58:32'),(987,1,'en','web','shops','Shops','2024-12-30 00:58:32','2024-12-30 00:58:32'),(988,1,'en','web','shop.tag','Shop/Restaurant tags','2024-12-30 00:58:32','2024-12-30 00:58:32'),(989,1,'en','web','extras','Extras','2024-12-30 00:58:32','2024-12-30 00:58:32'),(990,1,'en','web','extra.group','Extra group','2024-12-30 00:58:32','2024-12-30 00:58:32'),(991,1,'en','web','extra.value','Extra value','2024-12-30 00:58:32','2024-12-30 00:58:32'),(992,1,'en','web','categories','Categories','2024-12-30 00:58:32','2024-12-30 00:58:32'),(994,1,'en','web','content','Content','2024-12-30 00:58:32','2024-12-30 00:58:32'),(995,1,'en','web','brands','Brands','2024-12-30 00:58:32','2024-12-30 00:58:32'),(996,1,'en','web','career','Career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(997,1,'en','web','career.categories','Career Categories','2024-12-30 00:58:32','2024-12-30 00:58:32'),(998,1,'en','web','units','Units','2024-12-30 00:58:32','2024-12-30 00:58:32'),(999,1,'en','web','banners','Banners','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1000,1,'en','web','blogs','Blogs','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1001,1,'en','web','stories','Stories','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1002,1,'en','web','gallery','Gallery','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1003,1,'en','web','notifications','Notifications','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1004,1,'en','web','customer','Customer','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1005,1,'en','web','wallets','Wallets','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1007,1,'en','web','user','User','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1008,1,'en','web','clients','Clients','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1009,1,'en','web','roles','Roles','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1010,1,'en','web','email.subscriber','Email subscriber','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1011,1,'en','web','subscriber','Subscriber','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1012,1,'en','web','message.subscriber','Message subscriber','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1013,1,'en','web','transaction','Transaction','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1014,1,'en','web','transactions','Transactions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1015,1,'en','web','payout.requests','Payout requests','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1016,1,'en','web','payouts','Payouts','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1017,1,'en','web','subscriptions','Subscriptions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1018,1,'en','web','marketing','Marketing','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1019,1,'en','web','cashback','Cashback','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1020,1,'en','web','referral','Referral','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1021,1,'en','web','bonus','Bonus','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1022,1,'en','web','analytics.and.reports','Analytics and reports','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1023,1,'en','web','food','Food','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1024,1,'en','web','foods','Foods','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1025,1,'en','web','order','Order','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1026,1,'en','web','stock','Stock','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1027,1,'en','web','category','Category','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1028,1,'en','web','variation','Variation','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1029,1,'en','web','business.settings','Business settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1030,1,'en','web','settings','Settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1031,1,'en','web','currencies','Currencies','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1032,1,'en','web','wallet','Wallet','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1033,1,'en','web','payload','Payload','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1034,1,'en','web','message','Message','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1035,1,'en','web','payments','Payments','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1036,1,'en','web','sms-gateways','Sms gateways','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1037,1,'en','web','email.provider','Email provider','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1038,1,'en','web','notification.settings','Notification settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1039,1,'en','web','social.settings','Social settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1040,1,'en','web','app.settings','App Settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1041,1,'en','web','page.setup','Page setup','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1042,1,'en','web','faq','Frequently asked questions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1043,1,'en','web','terms','Terms','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1044,1,'en','web','policy','Privacy & Policy','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1045,1,'en','web','pages','Pages','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1046,1,'en','web','system.settings','System settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1047,1,'en','web','languages','Languages','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1048,1,'en','web','translations','Translations','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1049,1,'en','web','system.information','System information','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1050,1,'en','web','hello','Hello','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1051,1,'en','web','hello.text','Let\'s check your stats today!','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1052,1,'en','web','top.products','Top products','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1053,1,'en','web','all.orders','All orders','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1054,1,'en','web','pickup.orders','Pickup orders','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1055,1,'en','web','change.columns','Change columns','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1056,1,'en','web','todo.list','Todo list','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1057,1,'en','web','archive','Archive','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1058,1,'en','web','todo.placeholder','What needs to be done?','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1059,1,'en','web','todo.empty','There\'s nothing to do =>(','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1060,1,'en','web','todo.add','Add todo','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1061,1,'en','web','scheduled.orders','Scheduled orders','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1062,1,'en','web','payment.payloads','Payment payloads','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1063,1,'en','web','edit.payment.payloads','Edit payment payload','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1064,1,'en','web','add.payment.payloads','Add payment payload','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1065,1,'en','web','payment.id','Payment id','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1066,1,'en','web','paypal.mode','Paypal mode','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1067,1,'en','web','discount.type','Discount type','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1068,1,'en','web','discount.price','Discount price','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1069,1,'en','web','add.stock','Add stock','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1070,1,'en','web','recipe.categories','Recipe categories','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1071,1,'en','web','recepes','Recipes','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1072,1,'en','web','add.recepe','Add recipe','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1073,1,'en','web','edit.recepe','Edit recipe','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1074,1,'en','web','total.time','Total time','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1075,1,'en','web','calories','Calories','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1076,1,'en','web','servings','Servings','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1077,1,'en','web','instructions','Instructions','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1078,1,'en','web','weight','Weight','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1079,1,'en','web','percentage','Percentage','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1080,1,'en','web','recepts','Recipes','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1081,1,'en','web','recipe.category','Recipe category','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1082,1,'en','web','recipe','Recipe','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1083,1,'en','web','nutritions','Nutritions','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1084,1,'en','web','paystack.sk','Paystack secret key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1085,1,'en','web','paystack.pk','Paystack public key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1086,1,'en','web','from.order','from','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1087,1,'en','web','change.status','Change status','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1088,1,'en','web','documents','Documents','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1089,1,'en','web','date','Date','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1090,1,'en','web','document','Document','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1091,1,'en','web','delivery.reciept','Delivery reciept','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1092,1,'en','web','registration.date','Registration date','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1093,1,'en','web','messages','Messages','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1094,1,'en','web','created.date.&.time','Created date & time','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1095,1,'en','web','overview','Overview','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1096,1,'en','web','catalog','Catalog','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1097,1,'en','web','tickets','Tickets','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1098,1,'en','web','settings.general','General settings','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1099,1,'en','web','backup','Backup','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1100,1,'en','web','branch','Branch','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1101,1,'en','web','stores','Stores','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1102,1,'en','web','invites','Invites','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1103,1,'en','web','faqs','FAQs','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1104,1,'en','web','paid','Paid','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1105,1,'en','web','product.review','Product review','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1106,1,'en','web','order.review','Order review','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1107,1,'en','web','order.reviews','Order reviews','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1108,1,'en','web','order.id','Order ID','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1109,1,'en','web','comment','Comment','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1110,1,'en','web','product.id','Product ID','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1111,1,'en','web','update','Update','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1112,1,'en','web','update.database','Update database','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1113,1,'en','web','my.shop','My shop','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1114,1,'en','web','coupons','Coupons','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1115,1,'en','web','discounts','Discounts','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1116,1,'en','web','shop.users','Shop users','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1117,1,'en','web','delete.restaurant','Delete restaurant','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1118,1,'en','web','add.restaurant','Add restaurant','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1119,1,'en','web','edit.restaurant','Edit restaurant','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1120,1,'en','web','shop.categories','Shop/Restaurant categories','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1121,1,'en','web','equal','Equal','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1122,1,'en','web','recomention','Recomention','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1123,1,'en','web','recomention.zone','Recomention zone','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1124,1,'en','web','recomention.tables','Recomention tables','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1125,1,'en','web','order.management','Order management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1126,1,'en','web','restaurant.management','Restaurant management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1127,1,'en','web','report.management','Report management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1128,1,'en','web','food.management','Food management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1129,1,'en','web','customer.management','Customer management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1130,1,'en','web','deliveryman.management','Deliveryman management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1131,1,'en','web','content.management','Content management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1132,1,'en','web','transaction.management','Transaction management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1133,1,'en','web','food.report','Food report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1134,1,'en','web','order.report','Order report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1135,1,'en','web','stock.report','Stock report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1136,1,'en','web','category.report','Category report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1137,1,'en','web','add.food','Add food','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1138,1,'en','web','delete.food','Are you sure to delete this food?','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1139,1,'en','web','set.active.food','Are you sure to set active this food?','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1140,1,'en','web','edit.food','Edit food','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1141,1,'en','web','food.extras','Food extras','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1142,1,'en','web','categorys','Categorys','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1143,1,'en','web','brand','Brand','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1144,1,'en','web','product','Product','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1145,1,'en','web','extra','Extra','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1146,1,'en','web','title','Title','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1147,1,'en','web','type','Type','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1148,1,'en','web','extra.groups','Extra groups','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1149,1,'en','web','text','Text','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1150,1,'en','web','image','Image','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1151,1,'en','web','value','Value','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1152,1,'en','web','reject','Reject','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1153,1,'en','web','question','Question','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1154,1,'en','web','en','English','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1155,1,'en','web','de','Deutsch','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1156,1,'en','web','ru','Русский','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1157,1,'en','web','month','Month','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1158,1,'en','web','minute','Minute','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1159,1,'en','web','day','Day','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1160,1,'en','web','result','Result','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1161,1,'en','web','select','Select','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1162,1,'en','web','project.settings','Project settings','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1163,1,'en','web','commission','Commission','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1164,1,'en','web','favicon','Favicon','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1165,1,'en','web','map','Map','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1166,1,'en','web','config','Config','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1167,1,'en','web','google.map.key','Google map key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1168,1,'en','web','google.firebase.key','Google firebase key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1169,1,'en','web','multi.seller','Multi seller','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1170,1,'en','web','multi.shop','Multi shop','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1171,1,'en','web','single.seller','Single seller','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1172,1,'en','web','status','Status','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1173,1,'en','web','edited','Edited','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1174,1,'en','web','approved','Approved','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1175,1,'en','web','rejected','Rejected','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1176,1,'en','web','open','Open','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1177,1,'en','web','completed','Completed','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1178,1,'en','web','progress','Progress','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1179,1,'en','web','standard','Standard','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1180,1,'en','web','express','Express','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1181,1,'en','web','free','Free','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1182,1,'en','web','processed','Processed','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1183,1,'en','web','admin','Admin','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1184,1,'en','web','seller','Seller','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1185,1,'en','web','manager','Manager','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1186,1,'en','web','moderator','Moderator','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1187,1,'en','web','deliverymans','Deliverymans','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1188,1,'en','web','user.id','User ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1189,1,'en','web','client','Client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1190,1,'en','web','client.add','Add new client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1191,1,'en','web','firstname','First name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1192,1,'en','web','lastname','Last name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1193,1,'en','web','role','Role','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1194,1,'en','web','options','Options','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1195,1,'en','web','gender','Gender','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1196,1,'en','web','birthday','Birthday','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1197,1,'en','web','phone','Phone','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1198,1,'en','web','currency','Currency','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1199,1,'en','web','client.title','Client title','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1200,1,'en','web','secret.title','Secret title','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1201,1,'en','web','client.id','Client ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1202,1,'en','web','secret.id','Secret ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1203,1,'en','web','fullname','Full name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1204,1,'en','web','topup.wallet','Topup wallet','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1205,1,'en','web','user.settings','User settings','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1206,1,'en','web','created.by','Created by','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1207,1,'en','web','shop.id','Shop ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1208,1,'en','web','shop.name','Shop name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1209,1,'en','web','shop.logo','Shop logo','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1210,1,'en','web','shop.phone','Shop phone','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1211,1,'en','web','shop.open_close.time','Shop open & close time','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1212,1,'en','web','shop.tax','Shop tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1213,1,'en','web','open_close.time','Open & close time','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1214,1,'en','web','logo','Logo','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1215,1,'en','web','background','Background','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1216,1,'en','web','payment.type','Payment type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1217,1,'en','web','terminal','Terminal','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1218,1,'en','web','amount','Amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1219,1,'en','web','created.at','Created at','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1220,1,'en','web','number.of.products','Number of products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1221,1,'en','web','customer.details','Customer details','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1223,1,'en','web','sub.total','Sub total','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1224,1,'en','web','total.amount','Total amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1225,1,'en','web','place.order','Place order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1226,1,'en','web','bag','Bag','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1227,1,'en','web','shipping.info','Shipping information','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1228,1,'en','web','payment.status','Payment status','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1229,1,'en','web','coupon','Coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1230,1,'en','web','check.coupon','Check coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1231,1,'en','web','new.order','New order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1232,1,'en','web','order.details','Order details','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1233,1,'en','web','order.tax','Order tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1234,1,'en','web','product.tax','Product tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1235,1,'en','web','view.order','View order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1236,1,'en','web','cancelled.orders','Cancelled orders','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1237,1,'en','web','delivered.orders','Delivered orders','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1238,1,'en','web','out.of.stock.products','Out of stock products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1239,1,'en','web','total.products','Total products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1240,1,'en','web','total.earned','Total earned','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1241,1,'en','web','delivery.earning','Delivery earning','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1242,1,'en','web','total.order.tax','Total order tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1243,1,'en','web','total.comission','Total comission','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1244,1,'en','web','last.30.days','Last 30 days','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1245,1,'en','web','this.month','This month','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1246,1,'en','web','this.week','This week','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1247,1,'en','web','this.year','This year','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1248,1,'en','web','total.orders.count','Total orders count','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1249,1,'en','web','top.customers','Top customers','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1250,1,'en','web','top.selled.products','Top selled products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1251,1,'en','web','sales','Sales','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1252,1,'en','web','total.sales.amount','Total sales amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1253,1,'en','web','delivery.date','Delivery date','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1254,1,'en','web','delivery.time','Delivery time','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1255,1,'en','web','delivery.type','Delivery type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1256,1,'en','web','delivery.fee','Delivery fee','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1257,1,'en','web','transaction.id','Transaction ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1258,1,'en','web','price','Price','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1259,1,'en','web','status.description','Status description','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1260,1,'en','web','note','Note','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1261,1,'en','web','up.to','up to','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1262,1,'en','web','edit.subscriber','Edit Subscriber','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1263,1,'en','web','newsletter.content','Newsletter content','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1264,1,'en','web','clone.notification','Clone Notification','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1265,1,'en','web','edit.email.provider','Edit email provider','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1266,1,'en','web','app_store_button_link','App store button link','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1267,1,'en','web','google_play_button_link','Google play button link','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1268,1,'en','web','from_site','From Site','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1269,1,'en','web','from.to','From to','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1270,1,'en','web','twilio_account_id','Twilio account id','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1271,1,'en','web','twilio_auth_token','Twilio auth token','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1272,1,'en','web','twilio_number','Twilio number','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1273,1,'en','web','add.sms.gateway','Add sms gateway','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1274,1,'en','web','error','Error','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1275,1,'en','web','by.subscription','By Subscription','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1276,1,'en','web','bar.code','Barcode','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1277,1,'en','web','edit.cashback','Edit Cashback','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1278,1,'en','web','delete.selected','Delete selected','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1279,1,'en','web','change.user.role','Change user role','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1280,1,'en','web','change.language','Change language','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1281,1,'en','web','order.amount','Order amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1282,1,'en','web','add.extra.group','Add extra group','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1283,1,'en','web','add.extra','Add extra','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1284,1,'en','web','add.shop','Add shop','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1285,1,'en','web','add.order','Add order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1286,1,'en','web','add.faq','Add FAQ','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1287,1,'en','web','add.delivery','Add delivery','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1288,1,'en','web','add.deliveryman','Add deliveryman','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1289,1,'en','web','add.product','Add product','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1290,1,'en','web','add.category','Add category','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1291,1,'en','web','add.brand','Add brand','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1292,1,'en','web','add.unit','Add unit','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1293,1,'en','web','add.banner','Add banner','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1294,1,'en','web','add.ticket','Add ticket','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1295,1,'en','web','add.notification','Add notification','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1296,1,'en','web','add.client','Add client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1297,1,'en','web','add.address','Add address','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1298,1,'en','web','add.blog','Add blog','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1299,1,'en','web','add.language','Add language','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1300,1,'en','web','add.currency','Add currency','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1301,1,'en','web','add.translation','Add translation','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1302,1,'en','web','add.coupon','Add coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1303,1,'en','web','add.discount','Add discount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1304,1,'en','web','edit','Edit','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1305,1,'en','web','edit.extra.group','Edit extra group','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1306,1,'en','web','edit.extra','Edit extra','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1307,1,'en','web','edit.payment','Edit payment','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1308,1,'en','web','edit.faq','Edit FAQ','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1309,1,'en','web','edit.user','Edit user','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1310,1,'en','web','edit.order','Edit order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1311,1,'en','web','edit.delivery','Edit delivery','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1312,1,'en','web','edit.deliveryman','Edit deliveryman','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1313,1,'en','web','edit.shop','Edit shop','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1315,1,'en','web','edit.category','Edit category','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1316,1,'en','web','edit.brand','Edit brand','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1317,1,'en','web','edit.unit','Edit unit','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1318,1,'en','web','edit.banner','Edit banner','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1319,1,'en','web','edit.ticket','Edit ticket','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1320,1,'en','web','edit.notification','Edit notification','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1321,1,'en','web','edit.client','Edit client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1322,1,'en','web','edit.blog','Edit blog','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1323,1,'en','web','edit.language','Edit language','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1324,1,'en','web','edit.currency','Edit currency','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1325,1,'en','web','edit.translation','Edit translation','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1326,1,'en','web','edit.coupon','Edit coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1327,1,'en','web','edit.discount','Edit discount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1328,1,'en','web','please.select.client','Please, select client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1329,1,'en','web','please.select.client.address','Please, select client address','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1330,1,'en','web','please.select.payment.type','Please, select payment type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1331,1,'en','web','select.extra.type','Select extra type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1332,1,'en','web','select.extra.group','Select extra group','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1333,1,'en','web','select.payment.type','Select payment type','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1334,1,'en','web','select.address','Select address','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1335,1,'en','web','select.currency','Select currency','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1336,1,'en','web','select.client','Select client','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1337,1,'en','web','select.shop','Select shop','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1338,1,'en','web','select.category','Select category','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1339,1,'en','web','select.brand','Select brand','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1340,1,'en','web','select.group','Select group','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1341,1,'en','web','select.role','Select role','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1342,1,'en','web','deliveryman.order.acceptance.time','Deliveryman order acceptance time','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1343,1,'en','web','do.you.really.want.to.clear.the.cash?','Do you really want to clear the cache?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1344,1,'en','web','clear.cash','Clear cache','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1345,1,'en','web','backup.loading','Please wait a little while it takes time','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1346,1,'en','web','delivery.boy','Delivery boy','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1347,1,'en','web','customer.info','Customer info','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1348,1,'en','web','Welcome.to.Dashboard!','Welcome to Dashboard!','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1349,1,'en','web','edit.branch','Edit branch','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1350,1,'en','web','add.branch','Add branch','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1351,1,'en','web','show.locations','Show locations on Map','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1352,1,'en','web','not.equal','Not equal','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1353,1,'en','web','report','Report','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1354,1,'en','web','my.restaurant','My restaurant','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1355,1,'en','web','delivery.zone','Delivery zone','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1356,1,'en','web','in.progress.orders','In progress orders','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1357,1,'en','web','refund.details','Refund details','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1358,1,'en','web','welcome.manager','welcome manager','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1359,1,'en','web','get.started','Get started','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1360,1,'en','web','restaurant.closed.days','Restaurant closed days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1361,1,'en','web','restaurant.working.days','Restaurant working days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1362,1,'en','web','shop.closed.days','Shop closed days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1363,1,'en','web','shop.working.days','Shop working days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1364,1,'en','web','order.created.successfully','Order was successfully created','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1365,1,'en','web','restaurant.edit','Restaurants edit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1366,1,'en','web','please.select.delivery','Place select delivery','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1367,1,'en','web','please.select.address','Please, select address','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1368,1,'en','web','please.select.currency','Place select currency','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1369,1,'en','web','shop.closed','Shop is closed','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1370,1,'en','web','edit.bonus','Edit bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1371,1,'en','web','edit.story','Edit story','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1372,1,'en','web','shop.edit','Shop edit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1373,1,'en','web','edit.profile','Edit profile','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1374,1,'en','web','add.brands','Add brands','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1375,1,'en','web','min.price','Min price of delivery','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1376,1,'en','web','price.per.km','Price per km','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1377,1,'en','web','add.payment','Add payment','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1378,1,'en','web','payment','Payment','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1379,1,'en','web','set.active.delivery','Are you sure to set active this delivery?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1380,1,'en','web','email.setting.id','Email settings id','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1381,1,'en','web','unpublished','Unpublished','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1382,1,'en','web','pending','Pending','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1383,1,'en','web','published','Published','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1384,1,'en','web','page.not.found','Page not found','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1385,1,'en','web','go.back','Go back','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1386,1,'en','web','send.to','Send to','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1387,1,'en','web','body','Body','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1388,1,'en','web','alt.body','Alt body','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1389,1,'en','web','verify','Verify','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1390,1,'en','web','subscribe','Subscribe','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1391,1,'en','web','email.settings','Email settings','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1392,1,'en','web','add.cashback','Add cashback','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1393,1,'en','web','all.delete','Are you sure you want to delete all products?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1394,1,'en','web','select.the.product','Select the product you want to delete','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1395,1,'en','web','extra.group.value','Extra group value','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1396,1,'en','web','not.subscriber','Not subscriber','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1397,1,'en','web','add.subciribed','Add subciribed','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1398,1,'en','web','filter.result','Filter result','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1399,1,'en','web','add.subscriber','Add subscriber','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1400,1,'en','web','delete.all','Delete all','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1401,1,'en','web','bonus.stock.quantity','Bonus product quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1402,1,'en','web','products.stock','Products stock','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1403,1,'en','web','shop.bonus','Shop bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1404,1,'en','web','product.bonus','Product bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1405,1,'en','web','add.bonus','Add bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1406,1,'en','web','product.quantity','Product quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1407,1,'en','web','enter.extra.value','Enter extra value','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1408,1,'en','web','logo.image','Logo image','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1409,1,'en','web','background.image','Background image','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1410,1,'en','web','status.note','Status note','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1411,1,'en','web','visibility','Visibility','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1412,1,'en','web','general','General','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1413,1,'en','web','shop.working.hours','Shop working hours','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1414,1,'en','web','open.hours','Open hours','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1415,1,'en','web','close.hours','Close hours','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1416,1,'en','web','order.info','Order info','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1417,1,'en','web','min.amount','Min amount','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1418,1,'en','web','admin.comission','Admin comission','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1419,1,'en','web','withdraw','Withdraw','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1420,1,'en','web','withdraw.request','Withdraw request','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1421,1,'en','web','submit','Submit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1422,1,'en','web','payout.status','Payout status','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1423,1,'en','web','pay.to.seller','Pay to seller','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1424,1,'en','web','requested.amount','Requested amount','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1425,1,'en','web','pay','Pay','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1426,1,'en','web','upload','Upload','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1427,1,'en','web','export','Export','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1428,1,'en','web','product.extras','Product extras','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1429,1,'en','web','product.property','Product property','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1430,1,'en','web','food.property','Food property','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1431,1,'en','web','finish','Finish','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1432,1,'en','web','unit','Unit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1433,1,'en','web','min.qty','Min qty','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1434,1,'en','web','max.qty','Max qty','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1435,1,'en','web','images','Images','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1436,1,'en','web','prev','Prev','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1437,1,'en','web','key','Key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1438,1,'en','web','min.quantity','Min quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1439,1,'en','web','max.quantity','Max quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1440,1,'en','web','product.info','Product info','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1441,1,'en','web','child.categories','Child categories','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1442,1,'en','web','keywords','Keywords','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1443,1,'en','web','parent.category','Parent category','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1444,1,'en','web','position','Position','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1445,1,'en','web','delivery.date.&.time','Delivery date & time','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1446,1,'en','web','product.total','Product total','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1447,1,'en','web','order.total','Order total','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1448,1,'en','web','url','Url','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1449,1,'en','web','ask.for.question','Ask for question','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1450,1,'en','web','subject','Subject','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1451,1,'en','web','update.status','Update status','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1452,1,'en','web','ticket','Ticket','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1453,1,'en','web','answered','Answered','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1454,1,'en','web','closed','Closed','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1455,1,'en','web','published.at','Published at','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1456,1,'en','web','publish','Publish','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1457,1,'en','web','avatar','Avatar','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1458,1,'en','web','password.confirmation','Password confirmation','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1459,1,'en','web','short.description','Short description','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1460,1,'en','web','symbol','Symbol','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1461,1,'en','web','rate','Rate','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1462,1,'en','web','group','Group','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1463,1,'en','web','web','Web','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1464,1,'en','web','mobile','Mobile','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1465,1,'en','web','errors','Errors','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1466,1,'en','web','do.you.care.about.your.data','Do you care about your data?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1467,1,'en','web','here.you.can.take.backup.from.database','Here you can take backup from database.','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1468,1,'en','web','download.backup','Download backup','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1469,1,'en','web','sms.gateway','Sms gateway','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1470,1,'en','web','firebase.config','Firebase config','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1471,1,'en','web','api.key','API key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1472,1,'en','web','server.key','Server key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1473,1,'en','web','vapid.key','VAPID key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1474,1,'en','web','auth.domain','Auth domain','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1475,1,'en','web','project.id','Project ID','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1476,1,'en','web','storage.bucket','Storage bucket','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1477,1,'en','web','messaging.sender.id','Messaging sender ID','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1478,1,'en','web','app.id','App ID','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1479,1,'en','web','measurement.id','Measurement ID','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1480,1,'en','web','leave.site','Do you really want to leave the site?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1481,1,'en','web','translation','Translation','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1482,1,'en','web','you.cannot.order.more.than','You cannot order more than','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1483,1,'en','web','selected','Selected','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1484,1,'en','web','successfully.closed','Successfully closed','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1485,1,'en','web','required','Required','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1486,1,'en','web','required.field','Required field','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1487,1,'en','web','back','Back','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1488,1,'en','web','print','Print','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1489,1,'en','web','invoice','Invoice','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1490,1,'en','web','sub-total.amount','Sub - total amount','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1491,1,'en','web','delivery.price','Delivery price','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1492,1,'en','web','grand.total','Grand total','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1493,1,'en','web','copied.to.clipboard','Copied to clipboard','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1494,1,'en','web','shop.address','Shop address','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1495,1,'en','web','open.close.time','Open & close time','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1496,1,'en','web','invitation.link','Invitation link','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1497,1,'en','web','copy.invitation.link','Copy invitation link','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1498,1,'en','web','product.name','Product name','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1499,1,'en','web','total.price','Total price','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1500,1,'en','web','expired.at','Expired at','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1501,1,'en','web','fix','Fix','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1502,1,'en','web','percent','Percent','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1503,1,'en','web','start.date','Start date','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1504,1,'en','web','end.date','End date','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1505,1,'en','web','accept.invite','Accept invite','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1506,1,'en','web','from.day','From day','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1507,1,'en','web','to.day','To day','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1508,1,'en','web','password.do.not.match','The passwords do not match!','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1509,1,'en','web','male','Male','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1510,1,'en','web','female','Female','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1511,1,'en','web','footer.text','Footer text','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1512,1,'en','web','cannot.work.demo','You cannot use it in demo mode!','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1513,1,'en','web','purchase.subscription','Purchase subscription','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1514,1,'en','web','purchase','Purchase','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1515,1,'en','web','your.current.subscription','Your current subscription','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1516,1,'en','web','will.expire.at','will expire at','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1517,1,'en','web','subscription','Subscription','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1518,1,'en','web','insufficient.balance','Insufficient balance','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1519,1,'en','web','footer','Footer','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1520,1,'en','web','hours.ago','hours ago','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1521,1,'en','web','minutes.ago','minutes ago','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1522,1,'en','web','last.activity','Last activity','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1523,1,'en','web','active.orders','Active orders','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1524,1,'en','web','distance','Distance','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1525,1,'en','web','driver.information','Driver information','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1526,1,'en','web','vehicle','Vehicle','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1527,1,'en','web','fuel','Fuel','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1528,1,'en','web','customer.information','Customer information','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1529,1,'en','web','successfully.created','Successfully created','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1530,1,'en','web','successfully.updated','Successfully updated','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1531,1,'en','web','successfully.published','Successfully published','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1532,1,'en','web','successfully.deleted','Successfully deleted','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1533,1,'en','web','successfully.purchased','Successfully purchased','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1534,1,'en','web','successfully.added','Successfully added','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1535,1,'en','web','publish.notification','Publish notification','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1536,1,'en','web','publish.blog','Publish blog','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1537,1,'en','web','change.default.language','Change default language','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1538,1,'en','web','choose.discount.date','Choose discount date','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1539,1,'en','web','reject.invite','Are you sure to reject this invite?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1540,1,'en','web','set.active.product','Are you sure to set active this product?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1541,1,'en','web','set.active.unit','Are you sure to set active this unit?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1542,1,'en','web','set.active.banner','Are you sure to set active this banner?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1543,1,'en','web','set.active.notification','Are you sure to set active this notification?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1544,1,'en','web','set.active.blog','Are you sure to set active this blog?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1545,1,'en','web','set.active.payment','Are you sure to set active this payment?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1546,1,'en','web','set.active.sms.gateway','Are you sure to set active this sms gateway?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1547,1,'en','web','set.active.faq','Are you sure to set active this FAQ?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1548,1,'en','web','set.active.discount','Are you sure to set active this discount?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1549,1,'en','web','set.active.order.status','Are you sure to set active this order status?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1550,1,'en','web','set.active.email.provider','Are you sure to set active this email provider?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1551,1,'en','web','set.active.cashback','Are you sure to set active this cashback?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1552,1,'en','web','order_amount','Order amount','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1553,1,'en','web','clone.product','Product clone','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1554,1,'en','web','category.clone','Category clone','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1555,1,'en','web','recipe.category.clone','Recipe category clone','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1556,1,'en','web','delete.shop','Are you sure to delete this shop?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1557,1,'en','web','delete.product','Are you sure to delete this product?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1558,1,'en','web','delete.extra.group','Are you sure to delete this extra group?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1559,1,'en','web','delete.extra','Are you sure to delete this extra?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1560,1,'en','web','delete.category','Are you sure to delete this category?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1561,1,'en','web','delete.brand','Are you sure to delete this brand?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1562,1,'en','web','delete.banner','Are you sure to delete this banner?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1563,1,'en','web','delete.review','Are you sure to delete this review?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1564,1,'en','web','delete.notification','Are you sure to delete this notification?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1565,1,'en','web','delete.blog','Are you sure to delete this blog?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1566,1,'en','web','delete.language','Are you sure to delete this language?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1567,1,'en','web','delete.currency','Are you sure to delete this currency?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1568,1,'en','web','delete.faq','Are you sure to delete this FAQ?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1569,1,'en','web','delete.coupon','Are you sure to delete this coupon?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1570,1,'en','web','delete.discount','Are you sure to delete this discount?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1571,1,'en','web','spent.since.registration','Spent since registration','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1572,1,'en','web','user.info','User information','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1573,1,'en','web','ordered.products','Ordered products','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1574,1,'en','web','successfull.orders','Successfull orders','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1575,1,'en','web','order.refunds','Order refunds','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1576,1,'en','web','create.payout','Create payout','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1577,1,'en','web','select.seller','Select seller','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1578,1,'en','web','paypal.sandbox.client.id','Paypal sandbox client id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1579,1,'en','web','paypal.sandbox.client.secret','Paypal sandbox client secret','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1580,1,'en','web','paypal.sandbox.app.id','Paypal sandbox app id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1581,1,'en','web','paypal.live.client.id','Paypal live client id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1582,1,'en','web','paypal.live.client.secret','Paypal live client secret','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1583,1,'en','web','paypal.live.app.id','Paypal live app id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1584,1,'en','web','paypal.payment.action','Paypal payment action','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1585,1,'en','web','paypal.currency','Paypal currency','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1586,1,'en','web','paypal.locale','Paypal locale','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1587,1,'en','web','paypal.validate.ssl','Paypal validate ssl','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1588,1,'en','web','stripe.pk','Stripe public key','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1589,1,'en','web','stripe.sk','Stripe secret key','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1590,1,'en','web','razorpay.key','Razorpay key','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1591,1,'en','web','razorpay.secret','Razorpay secret','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1592,1,'en','web','boxes','Boxes','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1593,1,'en','web','add.box','Add box','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1594,1,'en','web','edit.box','Edit box','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1595,1,'en','web','add.nutrition','Add nutrition','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1596,1,'en','web','group.order','Group order','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1597,1,'de','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1598,1,'es','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1599,1,'fa','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1600,1,'en','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1601,1,'de','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1602,1,'es','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1603,1,'fa','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1604,1,'en','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1605,1,'de','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1606,1,'es','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1607,1,'fa','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1608,1,'en','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1609,1,'de','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1610,1,'es','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1611,1,'fa','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1612,1,'en','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1613,1,'de','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1614,1,'es','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1615,1,'fa','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1616,1,'en','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1617,1,'de','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1618,1,'es','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1619,1,'fa','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1620,1,'en','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1621,1,'de','web','home_page','Home page','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1622,1,'es','web','home_page','Home page','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1623,1,'fa','web','home_page','Home page','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1624,1,'en','web','home_page','Home page','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1625,1,'de','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1626,1,'es','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1627,1,'fa','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1628,1,'en','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1629,1,'hu','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1630,1,'de','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1631,1,'es','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1632,1,'fa','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1633,1,'en','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1634,1,'hu','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1635,1,'de','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1636,1,'es','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1637,1,'fa','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1638,1,'en','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1639,1,'hu','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1640,1,'de','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1641,1,'es','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1642,1,'fa','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1643,1,'en','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1644,1,'hu','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1645,1,'de','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1646,1,'es','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1647,1,'fa','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1648,1,'en','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1649,1,'hu','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1650,1,'de','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1651,1,'es','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1652,1,'fa','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1653,1,'en','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1654,1,'hu','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1655,1,'de','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1656,1,'es','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1657,1,'fa','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1658,1,'en','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1659,1,'hu','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1660,1,'de','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1661,1,'es','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1662,1,'fa','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1663,1,'en','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1664,1,'de','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1665,1,'es','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1666,1,'fa','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1667,1,'en','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1668,1,'hu','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1669,1,'de','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1670,1,'es','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1671,1,'fa','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1672,1,'en','web','refund','Refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1673,1,'hu','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1674,1,'de','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1675,1,'es','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1676,1,'fa','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1677,1,'ar','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1678,1,'en','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1679,1,'hu','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1680,1,'de','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1681,1,'es','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1682,1,'fa','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1683,1,'ar','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1684,1,'en','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1685,1,'hu','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1686,1,'de','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1687,1,'es','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1688,1,'fa','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1689,1,'ar','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1690,1,'en','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1691,1,'hu','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1692,1,'de','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1693,1,'es','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1694,1,'fa','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1695,1,'ar','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1696,1,'en','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1697,1,'hu','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1698,1,'de','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1699,1,'es','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1700,1,'fa','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1701,1,'ar','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1702,1,'en','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1703,1,'hu','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1704,1,'de','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1705,1,'es','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1706,1,'fa','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1707,1,'ar','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1708,1,'en','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1709,1,'hu','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1710,1,'de','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1711,1,'es','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1712,1,'fa','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1713,1,'ar','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1714,1,'en','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1715,1,'hu','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1716,1,'de','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1717,1,'es','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1718,1,'fa','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1719,1,'ar','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1720,1,'en','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1721,1,'hu','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1722,1,'de','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1723,1,'es','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1724,1,'fa','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1725,1,'ar','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1726,1,'en','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1727,1,'hu','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1728,1,'de','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1729,1,'es','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1730,1,'fa','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1731,1,'ar','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1732,1,'en','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1733,1,'hu','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1734,1,'de','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1735,1,'es','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1736,1,'fa','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1737,1,'ar','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1738,1,'en','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1739,1,'hu','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1740,1,'de','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1741,1,'es','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1742,1,'fa','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1743,1,'ar','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1744,1,'en','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1745,1,'hu','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1746,1,'de','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1747,1,'es','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1748,1,'fa','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1749,1,'ar','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1750,1,'en','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1751,1,'hu','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1752,1,'de','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1753,1,'es','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1754,1,'fa','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1755,1,'ar','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1756,1,'en','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1757,1,'en','mobile','عربي','AR','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1761,1,'en','mobile','all_previously_added','All previously added products will be removed from the cart. Do you continue ?','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1763,1,'en','mobile','continue','Continue','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1767,1,'en','mobile','send_new','Send new','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1769,1,'en','mobile','reset_password_text','Please provide your email address and we`ll send you code on how to change your password.','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1773,1,'en','mobile','start_group_order','Start group order','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1775,1,'en','web','start','Start','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1777,1,'en','mobile','manage_order','Manage order','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1779,1,'en','mobile','group_member','Group member','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1781,1,'en','mobile','add_new_card','Add new card','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1783,1,'en','mobile','card_number','Card number','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1785,1,'en','mobile','expired_date','Expired date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1787,1,'en','mobile','CVC','CVC','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1789,1,'en','mobile','do_you_want_to_delete_it','Do you want to delete it?','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1791,1,'en','mobile','Comment','Comment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1793,1,'en','mobile','continue_to_payment','Continue to payment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1796,1,'ar','web','ok','حسنا','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1797,1,'en','web','ok','Ok','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1798,1,'ar','web','payable_amount','المبلغ المستحق','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1799,1,'en','web','payable_amount','Payable Amount','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1800,1,'ar','web','confirm_order','تاكيد الاوردر','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1801,1,'en','web','confirm_order','Confirm Payment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1802,1,'ar','web','total_item','جميع المنتجات','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1803,1,'en','web','total_item','Total item','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1804,1,'ar','web','recent_customers','العملاء الجدد','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1805,1,'en','web','recent_customers','Recent Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1806,1,'ar','web','add_customer','اضافه عميل','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1807,1,'en','web','add_customer','Add Customer','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1808,1,'ar','web','customers','العملاء','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1809,1,'en','web','customers','Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1810,1,'ar','web','remove','مسح','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1811,1,'en','web','remove','Remove','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1812,1,'ar','web','are_you_sure_change1','هل انت متاكد من التغيير','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1813,1,'en','web','are_you_sure_change1','Are you sure you want to change the status of the order to','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1814,1,'ar','web','select_payment','اختار الدفع','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1815,1,'en','web','select_payment','Select payment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1816,1,'ar','web','select_currency','اختار العمله','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1817,1,'en','web','select_currency','Select currency','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1818,1,'ar','web','select_address','العنوان','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1819,1,'en','web','select_address','Address','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1820,1,'ar','web','select_user','حدد العميل','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1821,1,'en','web','select_user','Select client','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1822,1,'ar','web','there_are_no_items_in_the','لا توجد عناصر في','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1823,1,'en','web','there_are_no_items_in_the','There are no items in the','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1824,1,'ar','web','thank_you','شكرا لك!','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1825,1,'en','web','thank_you','Thank you!','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1826,1,'ar','web','shop_name','اسم المتجر','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1827,1,'en','web','shop_name','Shop name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1828,1,'ar','web','order_summary','ملخص الطلب','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1829,1,'en','web','order_summary','Order summary','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1830,1,'ar','web','no_search_results','لا نتائج في البحث','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1831,1,'en','web','no_search_results','No search results','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1832,1,'ar','web','select_deliveryman','اختار الدلييفري','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1833,1,'en','web','select_deliveryman','Select deliveryman','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1834,1,'ar','web','on_a_way','علي الطريق','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1835,1,'en','web','on_a_way','On a way','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1836,1,'en','web','enter_new_pin_code','Enter your new pincode','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1837,1,'de','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1838,1,'es','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1839,1,'fa','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1840,1,'en','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1841,1,'de','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1842,1,'es','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1843,1,'fa','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1844,1,'en','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1845,1,'en','web','payment_status','Payment status','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1846,1,'en','web','search_product','Search product','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1847,1,'en','web','delivery_date','Delivery date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1848,1,'en','web','locations','Locations','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1849,1,'en','web','edit_order','Edit order','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1850,1,'en','web','download','Download','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1851,1,'en','web','delete','Delete','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1852,1,'en','web','select_client','Select client','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1853,1,'en','web','search_user','Search user','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1854,1,'en','web','view_more','View more','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1855,1,'en','web','thank_you_for_order','Thank you for order!','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1856,1,'ar','web','show_location_on_map','Show location on map','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1857,1,'en','web','show_location_on_map','Show location on map','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1858,1,'ar','web','schedulet_at','Schedulet at','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1859,1,'en','web','schedulet_at','Schedulet at','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1860,1,'ar','web','order_type','Order Type','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1861,1,'en','web','order_type','Order Type','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1862,1,'ar','web','customer_added','Customer Added Successfully','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1863,1,'en','web','customer_added','Customer Added Successfully','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1864,1,'en','web','recommended_size','jpg,png – recommended size is 10MB','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1865,1,'en','web','id','ID','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1866,1,'en','web','search_restaurant_and_products','Search restaurant and products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1867,1,'ar','web','add_comment','Add comment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1868,1,'en','web','add_comment','Add comment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1869,1,'ar','web','sale_history','Sale History','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1870,1,'en','web','sale_history','Sale History','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1871,1,'ar','web','cash_drawer','Cash Drawer','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1872,1,'en','web','cash_drawer','Cash Drawer','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1873,1,'ar','web','today_sale','Today’s Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1874,1,'en','web','today_sale','Today’s Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1875,1,'ar','web','enter_name','Enter your name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1876,1,'en','web','enter_name','Enter your name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1877,1,'ar','web','enter_last_name','Enter your Last name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1878,1,'en','web','enter_last_name','Enter your Last name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1879,1,'ar','web','enter_email','Enter your email','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1880,1,'en','web','enter_email','Enter your email','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1881,1,'ar','web','enter_phone','Enter your phone','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1882,1,'en','web','enter_phone','Enter your phone','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1883,1,'ar','web','opening_drawer_amount','Opening Drawer Amount','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1884,1,'en','web','opening_drawer_amount','Opening Drawer Amount','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1885,1,'ar','web','cash_payment_sale','Cash Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1886,1,'en','web','cash_payment_sale','Cash Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1887,1,'ar','web','other_payment_sale','Other Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1888,1,'en','web','other_payment_sale','Other Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1889,1,'ar','web','start_end','Start Date — End Date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1890,1,'en','web','start_end','Start Date — End Date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1891,1,'ar','web','revenue','Revenue','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1892,1,'en','web','revenue','Revenue','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1893,1,'ar','web','average','Average','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1894,1,'en','web','average','Average','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1895,1,'ar','web','sale_chart','Sales chart','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1896,1,'en','web','sale_chart','Sales chart','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1897,1,'ar','web','statistics','Statistics','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1898,1,'en','web','statistics','Statistics','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1899,1,'ar','web','active','Active','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1900,1,'en','web','active','Active','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1901,1,'ar','web','ended','Ended','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1902,1,'en','web','ended','Ended','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1903,1,'ar','web','every_large','Every large design company whether it’s a multi-national branding corporation or a regular down at heel tatty magazine publisher needs to fill holes in the workforce.','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1904,1,'en','web','every_large','Every large design company whether it’s a multi-national branding corporation or a regular down at heel tatty magazine publisher needs to fill holes in the workforce.','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1905,1,'ar','web','select_the_desired_order_history_range','Select the desired order history range','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1906,1,'en','web','select_the_desired_order_history_range','Select the desired order history range','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1907,1,'ar','web','list','List','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1908,1,'en','web','list','List','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1909,1,'ar','web','board','Board','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1910,1,'en','web','board','Board','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1911,1,'ar','web','birth','Date of Birth','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1912,1,'en','web','birth','Date of Birth','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1913,1,'ar','web','id_code','ID Code','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1914,1,'en','web','id_code','ID Code','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1915,1,'ar','web','invoice_download','Invoice download','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1916,1,'en','web','invoice_download','Invoice download','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1917,1,'ar','web','mark_all_as_read','Mark all as read','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1918,1,'en','web','mark_all_as_read','Mark all as read','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1919,1,'ar','web','see_all_notifications','See All Notifications','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1920,1,'en','web','see_all_notifications','See All Notifications','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1921,1,'ar','web','need_select_product','Need select product','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1922,1,'en','web','need_select_product','Need select product','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1923,1,'ar','web','na','N/A','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1924,1,'en','web','na','NA','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1925,1,'ar','web','need_order','There was no orders during this period','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1926,1,'en','web','need_order','There was no orders during this period','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1927,1,'ar','web','search_orders','Search Orders','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1928,1,'en','web','search_orders','Search Orders','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1929,1,'ar','web','tables','Tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1930,1,'en','web','tables','Tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1931,1,'ar','web','all_tables','All tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1932,1,'en','web','all_tables','All tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1933,1,'ar','web','add_new_table','Add new table','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1934,1,'en','web','add_new_table','Add new table','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1935,1,'ar','web','available','Available','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1936,1,'en','web','available','Available','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1937,1,'ar','web','booked','Booked','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1938,1,'en','web','booked','Booked','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1939,1,'ar','web','occupied','Occupied','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1940,1,'en','web','occupied','Occupied','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1941,1,'ar','web','check_in','Check-in','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1942,1,'en','web','check_in','Check-in','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1943,1,'ar','web','add_address','Add address','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1944,1,'en','web','add_address','Add address','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1945,1,'ar','web','need_write','this field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1946,1,'en','web','need_write','this field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1947,1,'ar','web','two_floor','2nd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1948,1,'en','web','two_floor','2nd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1949,1,'ar','web','one_floor','1st Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1950,1,'en','web','one_floor','1st Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1951,1,'ar','web','three_floor','3rd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1952,1,'en','web','three_floor','3rd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1953,1,'ar','web','four_floor','4th Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1954,1,'en','web','four_floor','4th Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1955,1,'ar','web','field_required','This field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1956,1,'en','web','field_required','This field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1957,1,'ar','web','create','Create','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1958,1,'en','web','create','Create','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1959,1,'ar','web','no_products','At the same time, restaurant products are available it\'s not. But a product for a restaurant you can add','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1960,1,'en','web','no_products','At the same time, restaurant products are available it\'s not. But a product for a restaurant you can add','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1961,1,'ar','web','withdraw_money','Withdraw money','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1962,1,'en','web','withdraw_money','Withdraw money','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1963,1,'ar','web','person_count','Person count','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1964,1,'en','web','person_count','Person count','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1965,1,'ar','web','table_name','Table name','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1966,1,'en','web','table_name','Table name','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1967,1,'ar','web','deleted','Deleted Successfully','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1968,1,'en','web','deleted','Deleted Successfully','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1969,1,'ar','web','do_you_want_to_delete_order','Do you want to delete this order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1970,1,'en','web','do_you_want_to_delete_order','Do you want to delete this order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1971,1,'ar','web','no','No','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1972,1,'en','web','no','No','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1973,1,'en','web','search.restaurants.products','Search restaurants and products','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1974,1,'en','web','search.products.in','Search products in {{shop}}','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1975,1,'en','web','sorted.by','Sorted by','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1976,1,'en','web','news.week','News of the week','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1977,1,'en','web','liked','Liked','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1978,1,'en','web','your.orders','Your orders','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1979,1,'en','web','cart.empty','Cart is empty','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1980,1,'en','web','type.here','Type here','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1981,1,'en','web','promo.code','Promo code','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1982,1,'en','web','enter','Enter','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1983,1,'en','web','service.fee','Service fee','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1984,1,'en','web','continue.payment','Continue payment','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1985,1,'en','web','more','More','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1986,1,'en','web','working.time','Working time','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1987,1,'en','web','start.group.order','Start group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1988,1,'en','web','clear.bag','Clear bag','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1989,1,'en','web','add.promocode','Add promo code','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1991,1,'en','web','app.text','There\'s more to love in the app.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1992,1,'en','web','dont.have.account','Don\'t have an account?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1993,1,'en','web','keep.logged','Keep me logged in','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1995,1,'en','web','access.quickly','or access quickly','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1996,1,'en','web','have.account','Already have an account?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1997,1,'en','web','reset.password','Reset password','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1998,1,'en','web','reset.password.text','Please provide email address and we\'ll send you code which you can change your password.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1999,1,'en','web','enter.otp.code','Enter OTP code','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2000,1,'en','web','enter.code.text','We are send OTP code to {{phone}}','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2001,1,'en','web','send.new','Send new','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2002,1,'en','web','found.number.results','Found {{count}} results','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2003,1,'en','web','enter.delivery.address','Enter delivery address','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2004,1,'en','web','view.profile','View profile','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2005,1,'en','web','log.out','Log out','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2006,1,'en','web','profile','Profile','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2007,1,'en','web','date.of.birth','Date of birth','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2008,1,'en','web','update.password','Update password','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2009,1,'en','web','old.password','Old password','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2010,1,'en','web','choose.here','Choose here','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2011,1,'en','web','push.notifications','Push notifications','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2012,1,'en','web','on','On','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2013,1,'en','web','off','Off','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2014,1,'en','web','send.news.email','Send news email','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2015,1,'en','web','discount.notifications','Discount notifications','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2016,1,'en','web','order.verify','Order verify','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2017,1,'en','web','order.history','Order history','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2018,1,'en','web','cancelled','Cancelled','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2019,1,'en','web','support','Support','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2020,1,'en','web','repeat.order','Repeat order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2021,1,'en','web','liked.restaurants','Liked restaurants','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2022,1,'en','web','have.questions','Still have questions?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2023,1,'en','web','questions.text','Can’t find the answer you’re looking or? Please chat to our friendly team.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2024,1,'en','web','call.support','Call to support','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2025,1,'en','web','group.order.text','You fully manage the order and confirm the address. Team members can add a product from a location of your choice.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2026,1,'en','web','group.members','Group members','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2027,1,'en','web','choosing','Choosing','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2028,1,'en','web','clear.cart','Are you sure to clear the cart?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2029,1,'en','web','special.offers','Special offers','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2030,1,'en','web','free.delivery','Free delivery','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2031,1,'en','web','order.for.address','Order for this address?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2032,1,'en','web','replace.cart.prompt','You can only add items from one restaurant to your shopping cart.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2033,1,'en','web','saved','Saved','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2034,1,'en','web','passwords.dont.match','Passwords don\'t match','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2035,1,'en','web','password.should.contain','Password should contain at least 6 characters','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2036,1,'en','web','vat.tax','VAT tax','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2037,1,'en','web','cancel.order','Cancel order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2038,1,'en','web','are.you.sure.cancel.order','Are you sure to cancel this order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2039,1,'en','web','order.cancelled','Order cancelled','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2040,1,'en','web','choose.payment.method','Please, choose payment method','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2041,1,'en','web','leave.feedback','Leave feedback','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2042,1,'en','web','thanks.for.feedback','Thank you for your feedback!','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2044,1,'en','web','why.refund','Why do you want to refund?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2045,1,'en','web','request.sent','Request sent successfully!','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2046,1,'en','web','request.not.sent','You request didn\'t send!','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2047,1,'en','web','your.comment','Your comment','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2048,1,'en','web','go.to.order','Go to order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2049,1,'en','web','manage.group.order','Manage group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2050,1,'en','web','manage.order','Manage order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2051,1,'en','web','join.group.order','Join group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2052,1,'en','web','join.group.text','You can only select products from the restaurant chosen by the creator of the group','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2053,1,'en','web','join','Join','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2054,1,'en','web','leave.group','Leave group','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2055,1,'en','web','are.you.sure.leave.group','Are you sure to leave group order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2056,1,'en','web','you.kicked.from.group','You have been kicked from group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2057,1,'en','web','group.order.permission','Some group members haven\'t finished making order. Are you sure to continue?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2059,1,'en','web','all.shops','All shops','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2060,1,'en','web','wallet.history','Wallet history','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2061,1,'en','web','your.order','Your order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2062,1,'en','web','your.order.status.updated.text','Your order status has been updated! Click \'Show\' to see order details.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2063,1,'en','web','help.center','Help center','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2064,1,'en','web','login.first','Please, login first','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2065,1,'en','web','add.to.bag','Add to bag','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2066,1,'en','web','be.seller','Become seller','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2067,1,'en','web','delivery.info','Delivery info','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2068,1,'en','web','seller.request.under.review','Your request to become seller is currently under review.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2069,1,'en','web','seller.request.accepted','Your request to become seller is accepted.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2070,1,'en','web','start.price','Start price','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2071,1,'en','web','no.zone.title','We don\'t deliver here yet :(','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2072,1,'en','web','no.zone.text','But we add dozens of new places every week. Maybe we\'ll be here soon! If you enter your email, we\'ll tell you as soon as we\'re available. We promise not to spam!','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2073,1,'en','web','verify.email','Email verification','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2074,1,'en','web','verify.text','Please, enter the verification code we’ve sent you to','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2075,1,'en','web','verify.didntRecieveCode','Didn’t receive the code?','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2076,1,'en','web','resend','Send again','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2077,1,'en','web','should.match','Passwords should match','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2078,1,'en','web','verify.send','Verification code send successfully','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2079,1,'en','web','email.inuse','The email has already been taken.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2080,1,'en','web','verify.error','Wrong verification code','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2081,1,'en','web','become.affiliate','Become an Affiliate','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2082,1,'en','web','blog','Blog','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2083,1,'en','web','get.helps','Get helps','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2084,1,'en','web','add.your.restaurant','Add your restaurant','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2085,1,'en','web','sign.up.to.deliver','Sign up to deliver','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2086,1,'en','web','privacy.policy','Privacy Policy','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2087,1,'en','web','tags','Tags','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2088,1,'en','web','near_you','Near you','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2089,1,'en','web','open_now','Open now','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2090,1,'en','web','copy.code','Copy code','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2091,1,'en','web','balance','Balance','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2092,1,'en','web','referrals','Referrals','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2093,1,'en','web','referral.title','{{price_from}} for you, {{price_to}} for a friend','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2094,1,'en','web','referral.text','Friends can get up to {{price_to}} off — you’ll get {{price_from}} when they place their first order.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2095,1,'en','web','no.items','No items','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2096,1,'en','web','referral.terms','Referral terms','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2097,1,'en','web','login.or.create.account','Login or create account','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2098,1,'en','web','sign.in.be.seller','Sign in to be seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2099,1,'en','web','error.400','Error occured. Please, try again later','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2100,1,'en','web','more.info','More info','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2101,1,'en','web','open.until','Open until','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2102,1,'en','web','no.orders.found','You don\'t have any orders yet','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2103,1,'en','web','no.refunds.found','You don\'t have any order refunds yet. You can create a refund request from delivered orders.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2104,1,'en','web','no.active.orders.found','No active orders','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2105,1,'en','web','no.wallet.found','You don\'t have any wallet transactions yet','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2106,1,'en','web','recent.searches','Recent searches','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2107,1,'en','web','no.liked.restaurants','You don\'t have any liked restaurants yet','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2108,1,'en','web','try.again','Try again','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2109,1,'en','web','unauthorized','Unauthorized','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2110,1,'en','web','you.cannot.join','You cannot join. Invalid group order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2111,1,'en','web','delivery.zone.not.available','Sorry, we’re not available here','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2112,1,'en','web','leave.group.prompt','You have joined in group order. In order to add product, leave group first!','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2113,1,'en','web','become.delivery','Become a delivery driver','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2114,1,'en','web','become.delivery.text','Instead of traditional food delivery jobs where the hours aren’t flexible, try being your own boss with Foodyman. Get paid to deliver on your schedule using the food delivery app most downloaded by customers.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2115,1,'en','web','only.opened','Only opened','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2116,1,'en','web','schedule','Schedule','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2117,1,'en','web','shop.closed.choose.other.day','Shop is closed in this day. Please, select another day.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2118,1,'en','web','edit.schedule','Edit schedule','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2119,1,'en','web','pickup.address','Pickup address','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2120,1,'en','web','pickup.time','Pickup time','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2121,1,'en','web','branches','Branches','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2122,1,'en','web','branches.not.found','Branches not found','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2123,1,'en','web','out.of.stock','Out of stock','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2124,1,'en','web','hour','Hour','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2125,1,'en','web','h','hour','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2126,1,'en','web','no.restaurants','Restaurants not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2127,1,'en','web','no.shops','Shops not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2128,1,'en','web','sms.not.sent','Sms not sent!','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2129,1,'en','web','email.or.phone','Email or phone','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2130,1,'en','web','login.invalid','Login or password is invalid','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2131,1,'en','web','verify.phone','Phone verification','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2132,1,'en','web','recipes','Recipes','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2133,1,'en','web','recipes.title','Recipes','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2134,1,'en','web','recipes.description','Choose your favorite food recipe and buy as you wish','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2135,1,'en','web','no.recipes','Recipes not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2136,1,'en','web','add.items.to.cart','Add {{number}} items to cart','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2137,1,'en','web','recipe.discount.condition','If you buy all ingredients you can get discount by','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2138,1,'en','web','go.to.recipe.order','Ingredients added to cart successfully.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2139,1,'en','web','recipe.discount.definition','You got recipe discount','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2140,1,'en','web','insufficient.wallet.balance','Insufficient wallet balance','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2141,1,'en','web','go.to.admin.panel','Go to admin panel','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2142,1,'en','web','have.not.password','You have not set password yet. Please, make sure you have a password in system before you create a request for become seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2143,1,'en','web','edit.phone','Edit phone','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2144,1,'en','web','verified','Verified','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2145,1,'en','web','something.went.wrong','Something went wrong','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2146,1,'en','web','phone.required','Phone number is required','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2147,1,'en','web','no.careers.found','Careers not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2148,1,'en','web','welcome.title','Get your favorite foods delivered','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2149,1,'en','web','welcome.description','Choose your address and start ordering','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2150,1,'en','web','do.you.have.restaurant','Do you have a restaurant?','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2151,1,'en','web','deliver.title','Looking for delivery driver jobs?','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2152,1,'en','web','welcome.features.title','Other options for you','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2153,1,'en','web','start.ordering','Start ordering','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2154,1,'en','web','why.choose.us','Why choose us','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2155,1,'en','web','why.choose.us.first.title','Choose what you want','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2156,1,'en','web','why.choose.us.first.text','Choose what you text','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2157,1,'en','web','why.choose.us.second.title','See real-time updates','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2158,1,'en','web','why.choose.us.second.text','Personal shoppers pick items with care','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2159,1,'en','web','why.choose.us.third.title','Get your items same-day','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2160,1,'en','web','why.choose.us.third.text','Enjoy Foodyman\'s 100% quality guarantee on every order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2161,1,'en','web','choose.recomended.address','Choose recomended address','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2162,1,'en','web','place.for.ad','Place for your advertisement here','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2163,1,'en','web','people.trust.us','People trust us','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2164,1,'en','web','delivery.was.successfull','Delivery was successfull','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2165,1,'en','web','view.our.insta','View our Instagram','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2166,1,'en','web','latest.blog','Latest blog','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2167,1,'en','web','ads','Ads','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2168,1,'ar','web','there_are_no_orders','There are no orders','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2169,1,'en','web','there_are_no_orders','There are no orders','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2170,1,'ar','web','no_notification','No notifications','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2171,1,'en','web','no_notification','No notifications','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2172,1,'ar','web','order_status_changed','This order status changed','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2173,1,'en','web','order_status_changed','This order status changed','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2174,1,'ar','web','new_order','New Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2175,1,'en','web','new_order','New Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2176,1,'ar','web','confirm','Confirm','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2177,1,'en','web','confirm','Confirm','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2178,1,'ar','web','place_order','Place Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2179,1,'en','web','place_order','Place Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2180,1,'ar','web','seller_login','Seller login','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2181,1,'en','web','seller_login','Seller login','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2182,1,'ar','web','delivery_free','Delivery free','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2183,1,'en','web','delivery_free','Delivery free','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2184,1,'ar','web','all_galleries','All Galleries','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2185,1,'en','web','all_galleries','All Galleries','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2186,1,'ar','web','add_new_section','Add new section','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2187,1,'en','web','add_new_section','Add new section','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2188,1,'ar','web','section_name','Section name','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2189,1,'en','web','section_name','Section name','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2190,1,'ar','web','area','Area','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2191,1,'en','web','area','Area','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2192,1,'ar','web','select_other_day','Please select other day, because this day is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2193,1,'en','web','select_other_day','Please select other day, because this day is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2194,1,'ar','web','select_other_time','Please select other time, because this time is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2195,1,'en','web','select_other_time','Please select other time, because this time is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2197,1,'en','web','dashboard','Dashboard','2025-01-02 05:56:29','2025-01-02 05:56:29'),(2200,1,'en','web','become_seller','Become seller','2025-01-28 05:17:32','2025-01-28 05:17:32'),(2201,1,'en','web','clear.all','Clear All','2025-01-28 05:18:11','2025-01-28 05:18:11'),(2204,1,'en','web','akshay','hi akshay helloo','2025-02-03 04:32:40','2025-02-03 04:32:40'),(2205,1,'en','web','product.reviews','Product review','2025-02-03 06:54:38','2025-02-03 06:54:38'),(2206,1,'en','web','delivery point','Delivery point','2025-02-03 06:56:23','2025-02-03 06:56:23'),(2207,1,'en','web','delivery.point','Delivery point','2025-02-03 07:00:32','2025-02-03 07:00:32'),(2210,1,'en','web','shop.ads','Shop ads','2025-02-03 07:16:43','2025-02-03 07:16:43'),(2211,1,'en','web','shop.reviews','Shop reviews','2025-02-03 07:18:19','2025-02-03 07:18:19'),(2212,1,'en','web','warehouse.orders','Warehouse orders','2025-02-03 07:19:24','2025-02-03 07:19:24'),(2213,1,'en','web','seller.orders','Seller orders','2025-02-03 07:20:57','2025-02-03 07:20:57'),(2214,1,'en','web','deliveryman.request','Deliveryman request','2025-02-03 07:23:15','2025-02-03 07:23:15'),(2216,1,'en','web','payment.to.sellers','Payment to sellers','2025-02-03 07:25:39','2025-02-03 07:25:39'),(2217,1,'en','web','payment.to.deliverymans','Payment to deliverymans','2025-02-03 07:26:53','2025-02-03 07:26:53'),(2218,1,'en','web','last.30.days.statistics','Last 30 Days Statistics','2025-02-03 07:27:57','2025-02-03 07:27:57'),(2219,1,'en','web','parcel.mode','Parcel mode','2025-02-03 07:28:57','2025-02-03 07:28:57'),(2220,1,'en','web','support.team','Support team','2025-02-03 07:30:37','2025-02-03 07:30:37'),(2221,1,'en','web','delivery.points','Delivery points','2025-02-03 07:33:38','2025-02-03 07:33:38'),(2222,1,'en','web','add.delivery.price','add delivery price','2025-02-03 07:36:51','2025-02-03 07:36:51'),(2223,1,'en','web','select.region','Select region','2025-02-03 07:38:27','2025-02-03 07:38:27'),(2226,1,'en','web','deliveryman.address','Deliveryman address','2025-02-03 07:42:45','2025-02-03 07:42:45'),(2227,1,'en','web','digital.file','Digital file','2025-02-03 07:44:29','2025-02-03 07:44:29'),(2228,1,'en','web','age.limit','Age limit','2025-02-03 07:45:59','2025-02-03 07:45:59'),(2229,1,'en','web','interval.unit','Interval unit','2025-02-03 07:46:53','2025-02-03 07:46:53'),(2234,1,'en','web','add.look','add look','2025-02-04 00:11:39','2025-02-04 00:11:39'),(2235,1,'en','web','add.looks','Add looks','2025-02-04 00:12:58','2025-02-04 00:12:58'),(2236,1,'en','web','property.group','Property group','2025-02-04 00:17:41','2025-02-04 00:17:41'),(2237,1,'en','web','properties.group','Properties group','2025-02-04 00:18:44','2025-02-04 00:18:44'),(2238,1,'en','web','property.value','Property value','2025-02-04 00:19:24','2025-02-04 00:19:24'),(2239,1,'en','web','add.property','Add property','2025-02-04 00:20:18','2025-02-04 00:20:18'),(2240,1,'en','web','add.property.group','Add property group','2025-02-04 00:21:57','2025-02-04 00:21:57'),(2241,1,'en','web','properties.value','Properties value','2025-02-04 00:22:58','2025-02-04 00:22:58'),(2242,1,'en','web','add.advert','Add advert','2025-02-04 00:28:04','2025-02-04 00:28:04'),(2243,1,'en','web','add.ad','Add ad','2025-02-04 00:28:43','2025-02-04 00:28:43'),(2244,1,'en','web','commission.fee','Commission fee','2025-02-04 00:32:15','2025-02-04 00:32:15'),(2245,1,'en','web','point.history','Point history','2025-02-04 00:32:52','2025-02-04 00:32:52'),(2247,1,'en','web','order.total_price','Order total price','2025-02-04 00:36:23','2025-02-04 00:36:23'),(2248,1,'en','web','coupon.price','Coupon price','2025-02-04 00:37:12','2025-02-04 00:37:12'),(2249,1,'en','web','total.cashback','Total cashback','2025-02-04 00:38:03','2025-02-04 00:38:03'),(2250,1,'en','web','seller.fee','Seller fee','2025-02-04 00:38:36','2025-02-04 00:38:36'),(2251,1,'en','web','completed.payments','Completed payments','2025-02-04 00:39:38','2025-02-04 00:39:38'),(2252,1,'en','web','order.count','Order count','2025-02-04 00:47:40','2025-02-04 00:47:40'),(2253,1,'en','web','ui.type','Ui type','2025-02-04 00:49:19','2025-02-04 00:49:19'),(2254,1,'en','web','sms.payload','Sms payload','2025-02-04 00:51:51','2025-02-04 00:51:51'),(2255,1,'en','web','add.sms.payload','Add sms payload','2025-02-04 00:53:42','2025-02-04 00:53:42'),(2256,1,'en','web','select.type','Select type','2025-02-04 00:54:41','2025-02-04 00:54:41'),(2257,1,'en','web','landing.page','Landing page','2025-02-04 00:57:55','2025-02-04 00:57:55'),(2258,1,'en','web','no.digital','No digital','2025-02-04 04:02:42','2025-02-04 04:02:42'),(2259,1,'en','web','load.more','Load more','2025-02-04 04:09:15','2025-02-04 04:09:15'),(2260,1,'en','web','read.all','Read all','2025-02-04 04:09:48','2025-02-04 04:09:48'),(2261,1,'en','web','add.point','Add point','2025-02-04 04:13:57','2025-02-04 04:13:57'),(2262,1,'en','web','warehouse','Warehouse','2025-02-04 07:14:22','2025-02-04 07:14:22'),(2263,1,'en','web','looks','Looks','2025-02-04 07:15:18','2025-02-04 07:15:18'),(2264,1,'en','web','deliverypoint.working.days','Deliverypoint working days','2025-02-04 23:58:45','2025-02-04 23:58:45'),(2265,1,'en','web','deliverypoint.closed.days','Deliverypoint closed days','2025-02-04 23:59:22','2025-02-04 23:59:22'),(2266,1,'en','web','deliverypoint.closed.days.text','Delivery point closed days text','2025-02-05 00:00:35','2025-02-05 00:00:35'),(2267,1,'en','web','warehouse.working.days','Warehouse working days','2025-02-05 00:25:52','2025-02-05 00:25:52'),(2268,1,'en','web','warehouse.closed.days','Warehouse closed days','2025-02-05 00:26:14','2025-02-05 00:26:14'),(2269,1,'en','web','warehouse.closed.days.text','Warehouse closed days text','2025-02-05 00:26:41','2025-02-05 00:26:41'),(2270,1,'en','web','warehouse.closed','Warehouse closed','2025-02-05 00:34:31','2025-02-05 00:34:31'),(2271,1,'en','web','add.new.extra','Add new extra','2025-02-05 01:08:29','2025-02-05 01:08:29'),(2272,1,'en','web','add.media.file','Add media file','2025-02-05 01:11:41','2025-02-05 01:11:41'),(2273,1,'en','web','select.value','Select value','2025-02-05 01:14:54','2025-02-05 01:14:54'),(2274,1,'en','web','edit.product','product','2025-02-05 01:31:18','2025-02-05 01:31:18'),(2275,1,'en','web','deliveryman.settings','Deliveryman settings','2025-02-05 02:38:09','2025-02-05 02:38:09'),(2276,1,'en','web','select.technique','Select technique','2025-02-05 02:38:57','2025-02-05 02:38:57'),(2277,1,'en','web','select.area','Select area','2025-02-05 02:46:09','2025-02-05 02:46:09'),(2278,1,'en','web','time.and.price','Time and price','2025-02-05 04:30:38','2025-02-05 04:30:38'),(2279,1,'en','web','You.decide.whether.the.project.has.a.refund.system.or.not','You decide whether the project has a refund system or not','2025-02-05 06:26:05','2025-02-05 06:26:05'),(2280,1,'en','web','When.you.create.the.status.of.the.order.you.choose.the.approved.status','When you create the status of the order you choose the approved status','2025-02-05 06:28:49','2025-02-05 06:28:49'),(2281,1,'en','web','When.you.create.parcel.order.it.creates.with.status.approved','When you create parcel order it creates with status approved','2025-02-05 06:29:36','2025-02-05 06:29:36'),(2282,1,'en','web','You.decide.whether.to.show.the.refund.system.disable.button','You decide whether to show the refund system disable button','2025-02-05 06:30:32','2025-02-05 06:30:32'),(2283,1,'en','web','You.choose.the.deliveryman.yourself.when.you.create.the.order','You choose the deliveryman yourself when you create the order','2025-02-05 06:31:40','2025-02-05 06:31:40'),(2284,1,'en','web','You.choose.to.display.the.blog.page.yourself','You choose to display the blog page yourself','2025-02-05 06:32:12','2025-02-05 06:32:12'),(2285,1,'en','web','Send.sms.to.email.subscribers','Send sms to email subscribers','2025-02-05 06:32:38','2025-02-05 06:32:38'),(2286,1,'en','web','You.choose.whether.the.referral.will.work.or.not','You choose whether the referral will work or not','2025-02-05 06:33:16','2025-02-05 06:33:16'),(2287,1,'en','web','You.choose.whether.the.aws.will.work.or.not','You choose whether the aws will work or not','2025-02-05 06:33:54','2025-02-05 06:33:54'),(2288,1,'en','web','You.choose.whether.the.by.subscription.will.work.or.not','You choose whether the by subscription will work or not','2025-02-05 06:34:36','2025-02-05 06:34:36'),(2289,1,'en','web','You.choose.whether.enable.group.order.or.not','You choose whether enable group order or not','2025-02-05 06:35:16','2025-02-05 06:35:16'),(2290,1,'en','web','You.choose.whether.enable.is.demo.or.not','You choose whether enable is demo or not','2025-02-05 06:35:45','2025-02-05 06:35:45'),(2291,1,'en','web','You.choose.whether.enable.parcel.or.not','You choose whether enable parcel or not','2025-02-05 06:36:16','2025-02-05 06:36:16'),(2292,1,'en','web','You.choose.whether.auto.approve.products.or.not','You choose whether auto approve products or not','2025-02-05 06:36:48','2025-02-05 06:36:48'),(2293,1,'en','web','You.choose.whether.auto.approve.categories.or.not','You choose whether auto approve categories or not','2025-02-05 06:37:18','2025-02-05 06:37:18'),(2294,1,'en','web','You.choose.whether.require.phone.number.or.not.for.create.order','You choose whether require phone number or not for create order','2025-02-05 06:37:58','2025-02-05 06:37:58'),(2295,1,'en','web','You.choose.whether.enable.or.disable.subscription','You choose whether enable or disable subscription','2025-02-05 06:38:27','2025-02-05 06:38:27'),(2296,1,'en','web','you.can.enable.or.disable.auto.refresh.order','you can enable or disable auto refresh order','2025-02-05 06:38:54','2025-02-05 06:38:54'),(2297,1,'en','web','parcel.order.auto.approved','Parcel order auto approved','2025-02-05 06:40:05','2025-02-05 06:40:05'),(2298,1,'en','web','order.auto.deliveryMan','Order auto deliveryMan','2025-02-05 06:40:25','2025-02-05 06:40:25'),(2299,1,'en','web','activate.parcel.mode','Activate parcel mode','2025-02-05 06:40:49','2025-02-05 06:40:49'),(2300,1,'en','web','auto.approve.products','Auto approve products','2025-02-05 06:41:10','2025-02-05 06:41:10'),(2301,1,'en','web','auto.approve.categories','Auto approve categories','2025-02-05 06:41:31','2025-02-05 06:41:31'),(2302,1,'en','web','require.phone.for.create.order','Require phone for create order','2025-02-05 06:41:58','2025-02-05 06:41:58'),(2303,1,'en','web','enable.auto.refresh.order','Enable auto refresh order','2025-02-05 06:42:18','2025-02-05 06:42:18'),(2304,1,'en','web','save.address','Save address','2025-02-05 07:04:07','2025-02-05 07:04:07'),(2305,1,'en','web','select.country','Select country','2025-02-05 07:04:47','2025-02-05 07:04:47'),(2306,1,'en','web','select.city','Select city','2025-02-05 07:08:46','2025-02-05 07:08:46'),(2308,1,'en','web','search.products','Search products','2025-02-05 07:09:27','2025-02-05 07:09:27'),(2311,1,'en','web','see.all','See all','2025-02-05 07:10:42','2025-02-05 07:10:42'),(2312,1,'en','web','most.sold.products','Most sold products','2025-02-05 07:11:32','2025-02-05 07:11:32'),(2313,1,'en','web','new.products','New products','2025-02-05 07:11:56','2025-02-05 07:11:56'),(2314,1,'en','web','in.stock','In stock','2025-02-05 07:12:18','2025-02-05 07:12:18'),(2315,1,'en','web','on.sale','On sale','2025-02-05 07:12:49','2025-02-05 07:12:49'),(2316,1,'en','web','complete.auth','Complete auth','2025-02-05 07:13:13','2025-02-05 07:13:13'),(2317,1,'en','web','invite.a.friend.and.get.money.in.to.your.wallet','invite a friend and get money in to your wallet','2025-02-05 07:14:30','2025-02-05 07:14:30'),(2318,1,'en','web','sign.up','Sign Up','2025-02-05 07:15:28','2025-02-05 07:15:28'),(2319,1,'en','web','sign.in','Sign in','2025-02-05 07:16:08','2025-02-05 07:16:08'),(2320,1,'en','web','forgot.password','Forgot password','2025-02-05 07:16:36','2025-02-05 07:16:36'),(2322,1,'en','web','liked.products','Liked Products','2025-02-05 07:18:30','2025-02-05 07:18:30'),(2323,1,'en','web','no.liked.products','No liked products','2025-02-05 07:19:10','2025-02-05 07:19:10'),(2324,1,'en','web','most.sold','Most sold','2025-02-05 07:19:50','2025-02-05 07:19:50'),(2325,1,'en','web','go.to.checkout','Go to checkout','2025-02-05 07:20:24','2025-02-05 07:20:24'),(2326,1,'en','web','more.items.to.explore','More items to explore','2025-02-05 07:21:05','2025-02-05 07:21:05'),(2327,1,'en','web','mark.as.read','Mark as read','2025-02-05 07:22:06','2025-02-05 07:22:06'),(2328,1,'en','web','order.histroy','Order histroy','2025-02-05 07:22:32','2025-02-05 07:22:32'),(2329,1,'en','web','order.refund','Order refund','2025-02-05 07:22:58','2025-02-05 07:22:58'),(2332,1,'en','errors','my.orders','My orders','2025-02-06 00:04:05','2025-02-06 00:04:05'),(2334,1,'en','web','empty.cart','Empty cart','2025-02-06 00:07:13','2025-02-06 00:07:13'),(2335,1,'en','web','empty','Empty','2025-02-06 00:11:59','2025-02-06 00:11:59'),(2336,1,'en','web','no.product.to.compare','No product to compare','2025-02-06 00:49:52','2025-02-06 00:49:52'),(2337,1,'en','web','select.user','Select user','2025-02-06 00:56:42','2025-02-06 00:56:42'),(2338,1,'en','web','add.landing.page','Add landing page','2025-02-06 06:20:11','2025-02-06 06:20:11'),(2339,1,'en','mobile','there.are.no.your.delivery','There are no delivery address present','2025-02-07 03:11:35','2025-02-07 03:11:35'),(2340,1,'en','web','transaction.details','Transaction details','2025-02-07 04:46:53','2025-02-07 04:46:53'),(2341,1,'en','web','shop.details','Shop details','2025-02-11 02:27:34','2025-02-11 02:27:34'),(2342,1,'en','web','add.to.cart','Add To Cart','2025-02-12 02:00:39','2025-02-12 02:00:39'),(2343,1,'en','web','go.to.cart','Go To Cart','2025-02-12 02:01:28','2025-02-12 02:01:28'),(2344,1,'en','web','create.new.address','Create New Address','2025-02-12 02:02:25','2025-02-12 02:02:25'),(2345,1,'en','web','first.name','First Name','2025-02-12 02:07:42','2025-02-12 02:07:42'),(2346,1,'en','web','last.name','Last Name','2025-02-12 02:07:57','2025-02-12 02:07:57'),(2347,1,'en','web','zip.code','Zip Code','2025-02-12 02:08:27','2025-02-12 02:08:27'),(2348,1,'en','web','home.number','Home Number','2025-02-12 02:08:51','2025-02-12 02:08:51'),(2349,1,'en','web','details','Details','2025-02-12 02:09:19','2025-02-12 02:09:19'),(2350,1,'en','web','shop.notes','Shop Notes','2025-02-12 02:10:40','2025-02-12 02:10:40'),(2351,1,'en','web','no.order.refunds','No Order Refunds','2025-02-12 02:11:59','2025-02-12 02:11:59'),(2352,1,'en','web','change.password','Change Password','2025-02-12 02:13:33','2025-02-12 02:13:33'),(2353,1,'en','web','go.to.shop.page','Go To Shop Page','2025-02-12 02:17:27','2025-02-12 02:17:27'),(2354,1,'en','web','similar.products','Similar Products','2025-02-12 02:18:03','2025-02-12 02:18:03'),(2355,1,'en','web','viewed.products','Viewed Products','2025-02-12 02:18:24','2025-02-12 02:18:24'),(2356,1,'en','web','see.reviews','See Reviews','2025-02-12 02:19:33','2025-02-12 02:19:33'),(2357,1,'en','web','shop.info','Shop Info','2025-02-12 02:19:59','2025-02-12 02:19:59'),(2358,1,'en','web','working.days','Workings Days','2025-02-12 02:20:22','2025-02-12 02:20:22'),(2359,1,'en','web','nothing.here','Nothing here','2025-02-12 02:21:40','2025-02-12 02:21:40'),(2360,1,'en','web','all.stores','All Stores','2025-02-12 02:22:19','2025-02-12 02:22:19'),(2361,1,'en','web','view.in.map','View In Map','2025-02-12 02:22:46','2025-02-12 02:22:46'),(2362,1,'en','web','no.comments','No Comments','2025-02-12 03:53:05','2025-02-12 03:53:05'),(2363,1,'en','web','be.the.first.to.leave.a.review','Be The First To Leave a Review','2025-02-12 03:53:52','2025-02-12 03:53:52'),(2364,1,'en','web','SIGN_UP','SIGN UP','2025-02-12 23:34:24','2025-02-12 23:34:24'),(2367,1,'en','mobile','this.phone.already.exist','This phone number already exists',NULL,NULL),(2368,1,'en','mobile','this.phone.already.no.exist','This phone number not exists',NULL,NULL),(2369,1,'en','web','point.orders','Store Pickup Order','2025-06-16 13:41:27','2025-06-16 13:41:27'),(2371,1,'en','web','users','customer','2025-06-16 13:47:06','2025-06-16 13:47:06'),(2372,1,'en','web','product.details','Product Details','2025-06-25 11:53:55','2025-06-25 11:53:55'),(2373,1,'en','web','add.delivery.point','Add Delivery Point','2025-06-25 11:57:40','2025-06-25 11:57:40'),(2374,1,'en','web','product.list','Product List','2025-06-25 12:24:59','2025-06-25 12:24:59'),(2375,1,'en','web','requests','Requests','2025-06-25 12:26:35','2025-06-25 12:26:35'),(2376,1,'en','web','category.list','Category List','2025-06-25 12:28:28','2025-06-25 12:28:28'),(2377,1,'en','web','there.is.no.orders.here.yet','There is no orders here yet','2025-06-25 12:30:05','2025-06-25 12:30:05'),(2378,1,'en','web','i.agree.with terms.and.conditions','I Agree With Terms And Conditions','2025-06-25 12:30:56','2025-06-25 12:30:56'),(2379,1,'en','web','time.type','Time Type','2025-06-25 12:35:56','2025-06-25 12:35:56'),(2380,1,'en','web','upload.video','Upload Video','2025-06-25 12:37:21','2025-06-25 12:37:21'),(2381,1,'en','web','bonuses.list','Bonuses List','2025-06-25 12:41:38','2025-06-25 12:41:38');
/*!40000 ALTER TABLE `translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `unit_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `unit_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `unit_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unit_translations_unit_id_locale_unique` (`unit_id`,`locale`),
  KEY `unit_translations_locale_index` (`locale`),
  CONSTRAINT `unit_translations_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `unit_translations` WRITE;
/*!40000 ALTER TABLE `unit_translations` DISABLE KEYS */;
INSERT INTO `unit_translations` VALUES (1,1,'en','PCS');
/*!40000 ALTER TABLE `unit_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `units` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `position` enum('before','after') NOT NULL DEFAULT 'after',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'after','2024-12-30 00:58:40','2024-12-30 00:58:40');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_activities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL COMMENT 'click,read,listen and etc',
  `value` varchar(255) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  `agent` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`agent`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_activities_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `user_activities_user_id_foreign` (`user_id`),
  CONSTRAINT `user_activities_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_activities` WRITE;
/*!40000 ALTER TABLE `user_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_activities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_addresses` (
  `title` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address`)),
  `location` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`location`)),
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `zipcode` varchar(255) DEFAULT NULL,
  `street_house_number` varchar(255) DEFAULT NULL,
  `additional_details` varchar(191) DEFAULT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_addresses_user_id_foreign` (`user_id`),
  KEY `user_addresses_region_id_foreign` (`region_id`),
  KEY `user_addresses_country_id_foreign` (`country_id`),
  KEY `user_addresses_city_id_foreign` (`city_id`),
  KEY `user_addresses_area_id_foreign` (`area_id`),
  CONSTRAINT `user_addresses_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_addresses` WRITE;
/*!40000 ALTER TABLE `user_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_addresses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_carts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cart_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `name` varchar(255) DEFAULT NULL,
  `uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_carts_cart_id_foreign` (`cart_id`),
  KEY `user_carts_user_id_foreign` (`user_id`),
  CONSTRAINT `user_carts_cart_id_foreign` FOREIGN KEY (`cart_id`) REFERENCES `carts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_carts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_carts` WRITE;
/*!40000 ALTER TABLE `user_carts` DISABLE KEYS */;
INSERT INTO `user_carts` VALUES (97,96,162,1,'sunilshetty004@gmail.com shetty','c19c7a65-1492-4a81-b489-f2f86694d5b2','2025-06-18 06:24:23','2025-06-18 06:24:23');
/*!40000 ALTER TABLE `user_carts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_digital_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_digital_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `digital_file_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `downloaded` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_digital_files_digital_file_id_foreign` (`digital_file_id`),
  KEY `user_digital_files_user_id_foreign` (`user_id`),
  CONSTRAINT `user_digital_files_digital_file_id_foreign` FOREIGN KEY (`digital_file_id`) REFERENCES `digital_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_digital_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_digital_files` WRITE;
/*!40000 ALTER TABLE `user_digital_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_digital_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_points` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `price` double(20,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `user_points_user_id_foreign` (`user_id`),
  CONSTRAINT `user_points_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_points` WRITE;
/*!40000 ALTER TABLE `user_points` DISABLE KEYS */;
INSERT INTO `user_points` VALUES (1,176,0.00);
/*!40000 ALTER TABLE `user_points` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `firstname` varchar(255) NOT NULL DEFAULT 'firstname',
  `lastname` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `gender` enum('male','female') NOT NULL DEFAULT 'male',
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `phone_verified_at` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `verify_token` varchar(255) DEFAULT NULL,
  `my_referral` varchar(255) DEFAULT 'xoB3nzSD',
  `referral` varchar(255) DEFAULT NULL,
  `firebase_token` longtext DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `o_count` double DEFAULT 0,
  `o_sum` double DEFAULT 0,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_phone_unique` (`phone`),
  KEY `users_uuid_index` (`uuid`),
  KEY `users_currency_id_foreign` (`currency_id`),
  CONSTRAINT `users_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (102,'927f4e5b-dfe0-4162-8577-905485165a93','User','User','user@githubit.com','998911902595','1993-12-30','male','2024-12-30 00:58:40',NULL,NULL,1,NULL,'$2y$10$O9ejE4dh5GcsnVnwE/Enyu8N8BQ8/PdzdKkYbnWbGFxY58v6IB/HW',NULL,'7N102ATP',NULL,'[null,\"d6C8E9MySmydegF-ycoLjE:APA91bGAMk09S8DMbXHsTpJZiNlGy3ReAie2AoVA-MD5_JXEHD6gdPgw5ueF40xNpa9DmYgieYnOgILPBYS-pZ1FMm4R0iymzzl8Nk7Qz9dFPqTwmbaUEQA\"]',NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2025-01-22 07:12:39',NULL,NULL),(103,'22ab0041-ab87-4fcf-920a-14a05876dff6','Prem','Fashions','fashionprem85@gmail.com','9900831978','1990-12-31','male','2024-12-30 00:58:41',NULL,NULL,1,'https://backstore.premfashions.com/storage/images/users/103-17500622547770.webp','$2y$10$nwqiFQJQdXyyrnqHb2Q1Petm.KR6zvR76QNmOU3J4JCB0Spd3TrSW',NULL,'OI103HPI',NULL,'[\"de2p883ERUaAS1ff_jD8_5:APA91bGOqasjvnyHS1Q3VpTgXQT3Joz2isHcc_31psgYaXYpQU5Qi7c2_Z7eFOhqIoB7Hl8wYmfvEf_1_KAHKetrfIG8mKorIUffPWDH0HT31zZ9ozIOcW4\"]',NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2025-06-16 08:26:08',NULL,NULL),(104,'4040fad0-5d08-4c6f-8f3d-cecef65eaff6','Manager','Manager','manager@githubit.com','998911902616','1990-12-31','male','2024-12-30 00:58:41',NULL,NULL,1,NULL,'$2y$10$O9ejE4dh5GcsnVnwE/Enyu8N8BQ8/PdzdKkYbnWbGFx...',NULL,'MK104LRZ',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2024-12-30 00:58:41',NULL,NULL),(105,'5d10d939-2bdf-4f70-a6eb-148bdca3a946','Moderator','Moderator','moderator@githubit.com','998911902116','1990-12-31','male','2024-12-30 00:58:41',NULL,NULL,1,NULL,'$2y$10$6prJ49UbLks5N8EWi6A37ORfFdRomyJI87xmOFXRQ6ROkR8FbrIey',NULL,'SL105CIZ',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2024-12-30 00:58:41',NULL,NULL),(107,'baa92065-258b-47c1-8c42-e5ef15051ba2','Prem','Fashion','fashionpremshop85@gmail.com','9739647447','1990-12-31','male','2025-05-05 06:53:03','2025-05-05 06:53:03',NULL,1,NULL,'$2y$10$Fmf/H/JNaHGhfwY2.L70gOulVksX3bdrvj.Zp0O46gPZYYP7uHU7.',NULL,'GG107RVQ',NULL,'[]',NULL,0,0,0,1,1153.5,NULL,'2024-12-30 00:58:41','2025-06-02 01:38:04',NULL,NULL),(162,'b05519fa-7252-4ee1-9783-e249390b6b23','sunilshetty004@gmail.com','shetty1','sunilshetty004@gmail.com','9741374744','2025-06-16','male',NULL,'2025-03-25 03:41:28','171.61.184.174',1,'https://backstore.premfashions.com/storage/images/users/162-17500657924546.webp','$2y$10$0SKD.4NJtnh15vzUL2zc6usgtSGHVdrST81fBxs33CHahvNqN6BZ.','761375','LCNAHCQY',NULL,'[\"eWH1xcmqQEum7pgbLOJG8R:APA91bHBhR0dSFWkxiLF8SGZlx-MRyLrtqbbstTnp2ieW-qgt3uknaeM-NgcktTA1MVP90qFq3__py0c59z7TRB140SxldLrmMGRlEq18sc0LPaQTgP8yCY\",\"feqoNUfRQ3qJPbwwOVRWcX:APA91bHfs8FMG2jYQKGBURW-bFWO_4cY0sjHbqMEFiadhvqgSl81II-TVRzWRIoD_zTa253qQauFtVCkViJ46iqimwo9N-LFOY3txduESKnQ8SCbqIHlLvE\",\"d1C6B00eSRCss2bYVNiOQn:APA91bHGnX1IHgRY14_dwIGbnxUJa9Xpr75K-XoemjSeedr30I-S94vdbnWy6HmAZ2NqHxw_5joOpEZfESfgmvn442xskfUAwMbD9CCghMHcV7OjvTAOdzQ\",\"fLYSCSG3TSOyNLd3o02pzz:APA91bHNEI6HbOQa3tN-TmKdRKjxJDHdZzBVojvPDTqLnSN0ObNoB9hrdfJS_GD6KA1_7gOtY7fDLgKaSeuooEWTynUdsfNFxobscN5mEFOr8vu-riGg74s\",\"cG0kTXNQSuGVsGE4FfPVjB:APA91bGWaaBHtaoOVEW__LHCEVXgBfEXG-0M_-OUA2UvVhWwc3H10Xm7rixJjVXxdKBvtMmFDD7E9nKz92DcOuZ5iNXzH_tZx4PrOe_91EEE8KfR0fMlUVk\",\"dFq5-GjeSZW7uSYGFOUDPz:APA91bG6rj1I388O-n6Il6J1p-XEtN_IU6uWWv1E9S383iVnuMPiuvKgZx2ghriLUPKCgFeVPb0KdDkj62AJdQxxMH8dpWzMwnrLxmABKP0q-0bNDRIfq-A\",\"dJ11aREKQJCO4oHuAMHBQw:APA91bEW7X79lRHlMb7bCQwpF4KgtCAJCoiZuwj4v-WqFeDDx_24hQ2T04t9V6TP0JPp0VEgYqkCcTaxQ_ClIsssdRS1BOdhAzUeHHLM9UvxgAlClU2wyKg\"]',NULL,0,0,0,21,72722,NULL,'2025-03-25 03:41:28','2025-06-24 10:36:15',NULL,NULL),(176,'2f133541-5dad-4f3a-aafe-813923ecda1b','Anup','p',NULL,'7259231760',NULL,'male',NULL,'2025-06-25 12:29:07',NULL,1,NULL,'$2y$10$cAzMkY3IyA8q4BUEcuLHYORjVbY/.vKlmG7BAaVAQ47DIY2qqBZP2',NULL,'FAGOXRBJ',NULL,NULL,NULL,0,0,0,0,0,NULL,'2025-06-25 12:29:07','2025-06-25 12:29:07',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `wallet_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wallet_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `wallet_uuid` char(36) NOT NULL,
  `transaction_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'topup',
  `price` double NOT NULL DEFAULT 0,
  `note` varchar(255) DEFAULT NULL,
  `status` enum('processed','paid','rejected','canceled') NOT NULL DEFAULT 'processed',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wallet_histories_uuid_unique` (`uuid`),
  KEY `wallet_histories_transaction_id_foreign` (`transaction_id`),
  KEY `wallet_histories_created_by_foreign` (`created_by`),
  KEY `wallet_histories_type_index` (`type`),
  CONSTRAINT `wallet_histories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `wallet_histories_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `wallet_histories` WRITE;
/*!40000 ALTER TABLE `wallet_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `wallet_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `wallets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wallets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `currency_id` bigint(20) unsigned NOT NULL,
  `price` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wallets_uuid_user_id_unique` (`uuid`,`user_id`),
  KEY `wallets_user_id_foreign` (`user_id`),
  KEY `wallets_uuid_index` (`uuid`),
  CONSTRAINT `wallets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `wallets` WRITE;
/*!40000 ALTER TABLE `wallets` DISABLE KEYS */;
INSERT INTO `wallets` VALUES (1,'39494632-2150-417b-ac01-4899c5b4d5fd',176,2,0,'2025-06-25 12:29:07','2025-06-25 12:29:07');
/*!40000 ALTER TABLE `wallets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouse_closed_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `warehouse_closed_dates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_closed_dates_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `warehouse_closed_dates_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouse_closed_dates` WRITE;
/*!40000 ALTER TABLE `warehouse_closed_dates` DISABLE KEYS */;
INSERT INTO `warehouse_closed_dates` VALUES (6,1,'2025-02-09','2025-02-05 00:34:55','2025-02-05 00:34:55'),(7,2,'2025-02-09','2025-02-05 00:38:51','2025-02-05 00:38:51');
/*!40000 ALTER TABLE `warehouse_closed_dates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouse_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `warehouse_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `warehouse_translations_warehouse_id_locale_unique` (`warehouse_id`,`locale`),
  KEY `warehouse_translations_locale_index` (`locale`),
  CONSTRAINT `warehouse_translations_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouse_translations` WRITE;
/*!40000 ALTER TABLE `warehouse_translations` DISABLE KEYS */;
INSERT INTO `warehouse_translations` VALUES (8,1,'en','warehouse',NULL),(9,2,'en','warehouse',NULL);
/*!40000 ALTER TABLE `warehouse_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouse_working_days`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `warehouse_working_days` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') NOT NULL,
  `from` varchar(5) NOT NULL DEFAULT '9:00',
  `to` varchar(5) NOT NULL DEFAULT '21:00',
  `disabled` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_working_days_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `warehouse_working_days_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouse_working_days` WRITE;
/*!40000 ALTER TABLE `warehouse_working_days` DISABLE KEYS */;
INSERT INTO `warehouse_working_days` VALUES (57,1,'monday','01:00','23:00',1,'2025-02-05 00:34:55','2025-02-05 00:34:55'),(58,1,'tuesday','01:00','23:00',1,'2025-02-05 00:34:55','2025-02-05 00:34:55'),(59,1,'wednesday','01:00','23:00',1,'2025-02-05 00:34:55','2025-02-05 00:34:55'),(60,1,'thursday','01:00','23:00',1,'2025-02-05 00:34:55','2025-02-05 00:34:55'),(61,1,'friday','01:00','23:00',0,'2025-02-05 00:34:55','2025-02-05 00:34:55'),(62,1,'saturday','01:00','23:00',0,'2025-02-05 00:34:55','2025-02-05 00:34:55'),(63,1,'sunday','01:00','23:00',0,'2025-02-05 00:34:55','2025-02-05 00:34:55'),(71,2,'monday','01:00','23:00',0,'2025-02-05 00:38:51','2025-02-05 00:38:51'),(72,2,'tuesday','01:00','23:00',0,'2025-02-05 00:38:51','2025-02-05 00:38:51'),(73,2,'wednesday','01:00','23:00',0,'2025-02-05 00:38:51','2025-02-05 00:38:51'),(74,2,'thursday','01:00','23:00',0,'2025-02-05 00:38:51','2025-02-05 00:38:51'),(75,2,'friday','01:00','23:00',0,'2025-02-05 00:38:51','2025-02-05 00:38:51'),(76,2,'saturday','01:00','23:00',0,'2025-02-05 00:38:51','2025-02-05 00:38:51'),(77,2,'sunday','01:00','23:00',0,'2025-02-05 00:38:51','2025-02-05 00:38:51');
/*!40000 ALTER TABLE `warehouse_working_days` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `warehouses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned NOT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`address`)),
  `location` varchar(255) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouses_region_id_foreign` (`region_id`),
  KEY `warehouses_country_id_foreign` (`country_id`),
  KEY `warehouses_city_id_foreign` (`city_id`),
  KEY `warehouses_area_id_foreign` (`area_id`),
  CONSTRAINT `warehouses_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `warehouses_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `warehouses_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `warehouses_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouses` WRITE;
/*!40000 ALTER TABLE `warehouses` DISABLE KEYS */;
INSERT INTO `warehouses` VALUES (1,1,1,1,1,1,'{\"en\":\"3rd Building, 1st Main Road, Vikas Nagar Main Rd, opp. Muniswara Temple, Nagasandra, Bengaluru, Karnataka 560073, India\"}','{\"latitude\":13.0464424049714562414692409220151603221893310546875,\"longitude\":77.4974848756576051300726248882710933685302734375}','https://backstore.premfashions.com/storage/images/products/103-17387342047551.webp','2025-02-05 00:14:20','2025-02-05 00:14:20'),(2,1,1,1,1,1,'{\"en\":\"3rd Building, 1st Main Road, Vikas Nagar Main Rd, opp. Muniswara Temple, Nagasandra, Bengaluru, Karnataka 560073, India\"}','{\"latitude\":12.9716000000000004632738637155853211879730224609375,\"longitude\":77.5945999999999997953636921010911464691162109375}',NULL,'2025-02-05 00:38:31','2025-02-05 00:38:31');
/*!40000 ALTER TABLE `warehouses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `whole_sale_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whole_sale_prices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` bigint(20) unsigned NOT NULL,
  `min_quantity` int(11) NOT NULL DEFAULT 0,
  `max_quantity` int(11) NOT NULL DEFAULT 2147483647,
  `price` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `whole_sale_prices_stock_id_foreign` (`stock_id`),
  CONSTRAINT `whole_sale_prices_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `whole_sale_prices` WRITE;
/*!40000 ALTER TABLE `whole_sale_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `whole_sale_prices` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

