/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `ads_package_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ads_package_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ads_package_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `button_text` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_package_translations_ads_package_id_locale_unique` (`ads_package_id`,`locale`),
  KEY `ads_package_translations_locale_index` (`locale`),
  CONSTRAINT `ads_package_translations_ads_package_id_foreign` FOREIGN KEY (`ads_package_id`) REFERENCES `ads_packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ads_package_translations` WRITE;
/*!40000 ALTER TABLE `ads_package_translations` DISABLE KEYS */;
INSERT INTO `ads_package_translations` VALUES (1,1,'en','Game','Game APP',NULL);
/*!40000 ALTER TABLE `ads_package_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ads_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ads_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Активный',
  `type` varchar(255) NOT NULL DEFAULT 'main' COMMENT 'Где будет выходить',
  `time_type` varchar(255) NOT NULL DEFAULT 'day' COMMENT 'Тип времени рекламы: минут,час,день,недель,месяц,год',
  `time` smallint(6) NOT NULL COMMENT 'Время',
  `price` double NOT NULL DEFAULT 0,
  `product_limit` smallint(6) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `position_page` smallint(6) NOT NULL DEFAULT 1 COMMENT 'На какой странице будет выходить',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ads_packages` WRITE;
/*!40000 ALTER TABLE `ads_packages` DISABLE KEYS */;
INSERT INTO `ads_packages` VALUES (1,1,'main_left_banner','minute',1,122,NULL,'2025-01-22 02:17:05','2025-01-22 02:17:05',1);
/*!40000 ALTER TABLE `ads_packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `area_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `area_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `area_translations_area_id_locale_unique` (`area_id`,`locale`),
  KEY `area_translations_locale_index` (`locale`),
  CONSTRAINT `area_translations_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `area_translations` WRITE;
/*!40000 ALTER TABLE `area_translations` DISABLE KEYS */;
INSERT INTO `area_translations` VALUES (1,1,'en','Vinobnagara');
/*!40000 ALTER TABLE `area_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `areas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `areas_region_id_foreign` (`region_id`),
  KEY `areas_country_id_foreign` (`country_id`),
  KEY `areas_city_id_foreign` (`city_id`),
  CONSTRAINT `areas_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `areas_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `areas_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `areas` WRITE;
/*!40000 ALTER TABLE `areas` DISABLE KEYS */;
INSERT INTO `areas` VALUES (1,1,1,1,1);
/*!40000 ALTER TABLE `areas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assign_shop_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assign_shop_tags` (
  `shop_tag_id` bigint(20) unsigned NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  KEY `assign_shop_tags_shop_tag_id_foreign` (`shop_tag_id`),
  KEY `assign_shop_tags_shop_id_foreign` (`shop_id`),
  CONSTRAINT `assign_shop_tags_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `assign_shop_tags_shop_tag_id_foreign` FOREIGN KEY (`shop_tag_id`) REFERENCES `shop_tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assign_shop_tags` WRITE;
/*!40000 ALTER TABLE `assign_shop_tags` DISABLE KEYS */;
INSERT INTO `assign_shop_tags` VALUES (1,501);
/*!40000 ALTER TABLE `assign_shop_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `backup_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `path` varchar(191) DEFAULT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backup_histories_created_by_foreign` (`created_by`),
  CONSTRAINT `backup_histories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `backup_histories` WRITE;
/*!40000 ALTER TABLE `backup_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banner_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banner_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `banner_id` bigint(20) unsigned NOT NULL,
  `interval` double NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `banner_products_product_id_foreign` (`product_id`),
  KEY `banner_products_banner_id_foreign` (`banner_id`),
  CONSTRAINT `banner_products_banner_id_foreign` FOREIGN KEY (`banner_id`) REFERENCES `banners` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `banner_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banner_products` WRITE;
/*!40000 ALTER TABLE `banner_products` DISABLE KEYS */;
INSERT INTO `banner_products` VALUES (1,1,1,1,NULL,NULL),(2,1,2,1,NULL,NULL);
/*!40000 ALTER TABLE `banner_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banner_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banner_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `banner_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `button_text` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `banner_translations_banner_id_locale_unique` (`banner_id`,`locale`),
  KEY `banner_translations_locale_index` (`locale`),
  CONSTRAINT `banner_translations_banner_id_foreign` FOREIGN KEY (`banner_id`) REFERENCES `banners` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banner_translations` WRITE;
/*!40000 ALTER TABLE `banner_translations` DISABLE KEYS */;
INSERT INTO `banner_translations` VALUES (1,1,'en','Men new look','new men look',NULL,'https://premfashion.webschedio.in/storage/images/products/103-17375315164636.webp'),(2,2,'en','Puma',NULL,NULL,'https://premfashion.webschedio.in/storage/images/banners/103-17375345667732.webp');
/*!40000 ALTER TABLE `banner_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banners` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(191) DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'banner',
  `img` varchar(191) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `clickable` tinyint(1) NOT NULL DEFAULT 1,
  `input` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `banners_type_index` (`type`),
  KEY `banners_shop_id_foreign` (`shop_id`),
  CONSTRAINT `banners_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banners` WRITE;
/*!40000 ALTER TABLE `banners` DISABLE KEYS */;
INSERT INTO `banners` VALUES (1,NULL,'look',NULL,1,1,NULL,'2025-01-22 02:09:31','2025-01-22 02:09:31',501),(2,NULL,'banner',NULL,1,1,NULL,'2025-01-22 02:59:42','2025-01-22 02:59:42',NULL);
/*!40000 ALTER TABLE `banners` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `blog_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blog_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `short_desc` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `blog_translations_blog_id_locale_unique` (`blog_id`,`locale`),
  KEY `blog_translations_locale_index` (`locale`),
  CONSTRAINT `blog_translations_blog_id_foreign` FOREIGN KEY (`blog_id`) REFERENCES `blogs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `blog_translations` WRITE;
/*!40000 ALTER TABLE `blog_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `blog_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT 1,
  `published_at` date DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(191) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_user_id_foreign` (`user_id`),
  KEY `blogs_uuid_index` (`uuid`),
  KEY `blogs_type_index` (`type`),
  CONSTRAINT `blogs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bonuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bonuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `stock_id` bigint(20) unsigned DEFAULT NULL,
  `bonus_quantity` int(11) NOT NULL,
  `bonus_stock_id` bigint(20) unsigned DEFAULT NULL,
  `value` int(11) NOT NULL,
  `type` enum('count','sum') NOT NULL,
  `expired_at` datetime NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bonuses_shop_id_foreign` (`shop_id`),
  KEY `bonuses_stock_id_foreign` (`stock_id`),
  KEY `bonuses_bonus_stock_id_foreign` (`bonus_stock_id`),
  CONSTRAINT `bonuses_bonus_stock_id_foreign` FOREIGN KEY (`bonus_stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bonuses_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bonuses_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bonuses` WRITE;
/*!40000 ALTER TABLE `bonuses` DISABLE KEYS */;
/*!40000 ALTER TABLE `bonuses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `title` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_shop_id_foreign` (`shop_id`),
  KEY `brands_uuid_index` (`uuid`),
  CONSTRAINT `brands_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `career_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `career_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `career_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address`)),
  PRIMARY KEY (`id`),
  UNIQUE KEY `career_translations_career_id_locale_unique` (`career_id`,`locale`),
  KEY `career_translations_locale_index` (`locale`),
  CONSTRAINT `career_translations_career_id_foreign` FOREIGN KEY (`career_id`) REFERENCES `careers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `career_translations` WRITE;
/*!40000 ALTER TABLE `career_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `career_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `careers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `careers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `location` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`location`)),
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `careers_category_id_foreign` (`category_id`),
  CONSTRAINT `careers_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `careers` WRITE;
/*!40000 ALTER TABLE `careers` DISABLE KEYS */;
/*!40000 ALTER TABLE `careers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cart_detail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cart_detail_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cart_detail_id` bigint(20) unsigned NOT NULL,
  `stock_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `price` double DEFAULT NULL,
  `bonus` tinyint(1) NOT NULL DEFAULT 0,
  `discount` double NOT NULL DEFAULT 0,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_detail_products_cart_detail_id_foreign` (`cart_detail_id`),
  KEY `cart_detail_products_stock_id_foreign` (`stock_id`),
  KEY `cart_detail_products_parent_id_foreign` (`parent_id`),
  CONSTRAINT `cart_detail_products_cart_detail_id_foreign` FOREIGN KEY (`cart_detail_id`) REFERENCES `cart_details` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_detail_products_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `cart_details` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_detail_products_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cart_detail_products` WRITE;
/*!40000 ALTER TABLE `cart_detail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `cart_detail_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cart_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cart_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `user_cart_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `shop_tax` double DEFAULT NULL,
  `total_price` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_details_shop_id_foreign` (`shop_id`),
  KEY `cart_details_user_cart_id_foreign` (`user_cart_id`),
  KEY `cart_details_discount_index` (`discount`),
  KEY `cart_details_shop_tax_index` (`shop_tax`),
  KEY `cart_details_total_price_index` (`total_price`),
  CONSTRAINT `cart_details_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cart_details_user_cart_id_foreign` FOREIGN KEY (`user_cart_id`) REFERENCES `user_carts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cart_details` WRITE;
/*!40000 ALTER TABLE `cart_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cart_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `carts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` bigint(20) unsigned NOT NULL,
  `total_price` double DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `rate` double NOT NULL DEFAULT 1,
  `group` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `carts_owner_id_foreign` (`owner_id`),
  KEY `carts_currency_id_foreign` (`currency_id`),
  KEY `carts_region_id_foreign` (`region_id`),
  KEY `carts_country_id_foreign` (`country_id`),
  KEY `carts_city_id_foreign` (`city_id`),
  KEY `carts_area_id_foreign` (`area_id`),
  CONSTRAINT `carts_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `carts_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `carts_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `carts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `carts_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `carts_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `carts` WRITE;
/*!40000 ALTER TABLE `carts` DISABLE KEYS */;
/*!40000 ALTER TABLE `carts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `keywords` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `type` tinyint(4) NOT NULL DEFAULT 1,
  `input` int(11) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `age_limit` smallint(6) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_shop_id_foreign` (`shop_id`),
  KEY `categories_uuid_index` (`uuid`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,NULL,'623e0098-b1f8-4edd-bbdc-5288e541504b','main',0,1,NULL,NULL,1,0,'pending',NULL,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(2,NULL,'6accfd58-b88a-4c7c-be31-dce72ff8a807','sub_main',1,2,NULL,NULL,1,0,'pending',NULL,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(3,NULL,'433f8bfa-dc8e-4f4b-b160-b081fe752e63','child',1,3,NULL,NULL,1,0,'pending',NULL,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(4,NULL,'1d00777f-725c-4366-9495-18efd6c7d6ef','career',0,10,NULL,NULL,1,0,'pending',NULL,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(5,'men-5','873403ab-d5ed-4d2b-a954-94fb1f9c6365','men',0,1,123,'https://premfashion.webschedio.in/storage/images/categories/103-17375291643927.webp',1,0,'published',NULL,'2025-01-22 01:29:30','2025-01-22 01:29:59'),(6,'women-6','a1990c1a-c78c-43e1-b3a6-434e9ce98ed3','women',0,1,12,'https://premfashion.webschedio.in/storage/images/categories/103-17375409325630.webp',1,0,'published',NULL,'2025-01-22 04:45:38','2025-01-22 04:47:46');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `category_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `category_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_translations_category_id_locale_unique` (`category_id`,`locale`),
  KEY `category_translations_locale_index` (`locale`),
  CONSTRAINT `category_translations_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `category_translations` WRITE;
/*!40000 ALTER TABLE `category_translations` DISABLE KEYS */;
INSERT INTO `category_translations` VALUES (1,1,'en','main',NULL),(2,2,'en','sub_main',NULL),(3,3,'en','child',NULL),(4,4,'en','career',NULL),(5,5,'en','Men','Men cat'),(6,6,'en','Women','Women fashions');
/*!40000 ALTER TABLE `category_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cities_region_id_foreign` (`region_id`),
  KEY `cities_country_id_foreign` (`country_id`),
  CONSTRAINT `cities_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `cities_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,1,1,1);
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `city_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `city_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `city_translations_city_id_locale_unique` (`city_id`,`locale`),
  KEY `city_translations_locale_index` (`locale`),
  CONSTRAINT `city_translations_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `city_translations` WRITE;
/*!40000 ALTER TABLE `city_translations` DISABLE KEYS */;
INSERT INTO `city_translations` VALUES (1,1,'en','Shivamogga');
/*!40000 ALTER TABLE `city_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `countries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `img` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL COMMENT 'iso2',
  PRIMARY KEY (`id`),
  KEY `countries_region_id_foreign` (`region_id`),
  CONSTRAINT `countries_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,1,1,'https://flagcdn.com/224x168/in.png','ind');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `country_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_translations_country_id_locale_unique` (`country_id`,`locale`),
  KEY `country_translations_locale_index` (`locale`),
  CONSTRAINT `country_translations_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `country_translations` WRITE;
/*!40000 ALTER TABLE `country_translations` DISABLE KEYS */;
INSERT INTO `country_translations` VALUES (1,1,'en','INDIA');
/*!40000 ALTER TABLE `country_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `coupon_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coupon_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coupon_translations_coupon_id_locale_unique` (`coupon_id`,`locale`),
  KEY `coupon_translations_locale_index` (`locale`),
  CONSTRAINT `coupon_translations_coupon_id_foreign` FOREIGN KEY (`coupon_id`) REFERENCES `coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `coupon_translations` WRITE;
/*!40000 ALTER TABLE `coupon_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `coupon_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('fix','percent') NOT NULL DEFAULT 'fix',
  `qty` int(11) NOT NULL DEFAULT 0,
  `price` double NOT NULL DEFAULT 0,
  `expired_at` datetime NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `for` varchar(255) NOT NULL DEFAULT 'total_price',
  `shop_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coupons_name_shop_id_unique` (`name`,`shop_id`),
  KEY `coupons_shop_id_foreign` (`shop_id`),
  KEY `coupons_name_index` (`name`),
  CONSTRAINT `coupons_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `coupons` WRITE;
/*!40000 ALTER TABLE `coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `coupons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `symbol` varchar(255) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `rate` double(9,2) NOT NULL DEFAULT 1.00,
  `position` enum('before','after') NOT NULL DEFAULT 'after',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (2,'$','USD',1.00,'after',1,1,'2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_point_closed_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `delivery_point_closed_dates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_point_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_point_closed_dates_delivery_point_id_foreign` (`delivery_point_id`),
  CONSTRAINT `delivery_point_closed_dates_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_point_closed_dates` WRITE;
/*!40000 ALTER TABLE `delivery_point_closed_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_point_closed_dates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_point_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `delivery_point_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_point_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `delivery_point_translations_delivery_point_id_locale_unique` (`delivery_point_id`,`locale`),
  KEY `delivery_point_translations_locale_index` (`locale`),
  CONSTRAINT `delivery_point_translations_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_point_translations` WRITE;
/*!40000 ALTER TABLE `delivery_point_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_point_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_point_working_days`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `delivery_point_working_days` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_point_id` bigint(20) unsigned NOT NULL,
  `day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') NOT NULL,
  `from` varchar(5) NOT NULL DEFAULT '9:00',
  `to` varchar(5) NOT NULL DEFAULT '21:00',
  `disabled` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_point_working_days_delivery_point_id_foreign` (`delivery_point_id`),
  CONSTRAINT `delivery_point_working_days_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_point_working_days` WRITE;
/*!40000 ALTER TABLE `delivery_point_working_days` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_point_working_days` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `delivery_points` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned NOT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `price` double NOT NULL DEFAULT 0,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`address`)),
  `location` varchar(255) NOT NULL,
  `fitting_rooms` int(11) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_points_region_id_foreign` (`region_id`),
  KEY `delivery_points_country_id_foreign` (`country_id`),
  KEY `delivery_points_city_id_foreign` (`city_id`),
  KEY `delivery_points_area_id_foreign` (`area_id`),
  CONSTRAINT `delivery_points_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_points_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_points_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `delivery_points_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_points` WRITE;
/*!40000 ALTER TABLE `delivery_points` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_points` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_price_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `delivery_price_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_price_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `delivery_price_translations_delivery_price_id_locale_unique` (`delivery_price_id`,`locale`),
  KEY `delivery_price_translations_locale_index` (`locale`),
  CONSTRAINT `delivery_price_translations_delivery_price_id_foreign` FOREIGN KEY (`delivery_price_id`) REFERENCES `delivery_prices` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_price_translations` WRITE;
/*!40000 ALTER TABLE `delivery_price_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_price_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `delivery_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `delivery_prices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `price` double NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_prices_region_id_foreign` (`region_id`),
  KEY `delivery_prices_country_id_foreign` (`country_id`),
  KEY `delivery_prices_city_id_foreign` (`city_id`),
  KEY `delivery_prices_area_id_foreign` (`area_id`),
  KEY `delivery_prices_shop_id_foreign` (`shop_id`),
  CONSTRAINT `delivery_prices_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `delivery_prices_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `delivery_prices` WRITE;
/*!40000 ALTER TABLE `delivery_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `delivery_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `deliveryman_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deliveryman_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned NOT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `type_of_technique` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `online` tinyint(1) NOT NULL DEFAULT 0,
  `location` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`location`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `deliveryman_settings_user_id_unique` (`user_id`),
  KEY `deliveryman_settings_region_id_foreign` (`region_id`),
  KEY `deliveryman_settings_country_id_foreign` (`country_id`),
  KEY `deliveryman_settings_city_id_foreign` (`city_id`),
  KEY `deliveryman_settings_area_id_foreign` (`area_id`),
  CONSTRAINT `deliveryman_settings_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `deliveryman_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `deliveryman_settings` WRITE;
/*!40000 ALTER TABLE `deliveryman_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `deliveryman_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `digital_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `digital_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `digital_files_product_id_foreign` (`product_id`),
  CONSTRAINT `digital_files_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `digital_files` WRITE;
/*!40000 ALTER TABLE `digital_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `digital_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `type` enum('fix','percent') NOT NULL,
  `price` double NOT NULL,
  `start` date NOT NULL DEFAULT '2024-12-30',
  `end` date DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_shop_id_foreign` (`shop_id`),
  CONSTRAINT `discounts_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `smtp_auth` tinyint(1) NOT NULL DEFAULT 1,
  `smtp_debug` tinyint(1) NOT NULL DEFAULT 0,
  `host` varchar(92) NOT NULL,
  `port` int(11) NOT NULL DEFAULT 465,
  `password` varchar(255) DEFAULT NULL,
  `from_to` varchar(255) DEFAULT NULL,
  `from_site` varchar(255) DEFAULT NULL,
  `ssl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`ssl`)),
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_settings` WRITE;
/*!40000 ALTER TABLE `email_settings` DISABLE KEYS */;
INSERT INTO `email_settings` VALUES (1,1,0,'ssl://smtp.gmail.com',465,'password','gmail@gmail.com','foodyman.vercel.app','{\"ssl\":{\"verify_peer\":false,\"verify_peer_name\":false,\"allow_self_signed\":true}}',0,'2024-12-30 00:58:40','2024-12-30 00:58:40'),(2,1,0,'ssl://smtp.yandex.ru',465,'password','yandex@yandex.ru','foodyman.vercel.app','{\"ssl\":{\"verify_peer\":false,\"verify_peer_name\":false,\"allow_self_signed\":true}}',0,'2024-12-30 00:58:40','2024-12-30 00:58:40');
/*!40000 ALTER TABLE `email_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_subscriptions_user_id_foreign` (`user_id`),
  CONSTRAINT `email_subscriptions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_subscriptions` WRITE;
/*!40000 ALTER TABLE `email_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_setting_id` bigint(20) unsigned NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `alt_body` text NOT NULL,
  `status` tinyint(4) NOT NULL,
  `send_to` datetime NOT NULL,
  `type` varchar(50) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_templates_email_setting_id_foreign` (`email_setting_id`),
  CONSTRAINT `email_templates_email_setting_id_foreign` FOREIGN KEY (`email_setting_id`) REFERENCES `email_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_templates` WRITE;
/*!40000 ALTER TABLE `email_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `extra_group_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `extra_group_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extra_group_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `extra_group_translations_extra_group_id_locale_unique` (`extra_group_id`,`locale`),
  KEY `extra_group_translations_locale_index` (`locale`),
  CONSTRAINT `extra_group_translations_extra_group_id_foreign` FOREIGN KEY (`extra_group_id`) REFERENCES `extra_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `extra_group_translations` WRITE;
/*!40000 ALTER TABLE `extra_group_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `extra_group_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `extra_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `extra_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `extra_groups_shop_id_foreign` (`shop_id`),
  CONSTRAINT `extra_groups_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `extra_groups` WRITE;
/*!40000 ALTER TABLE `extra_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `extra_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `extra_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `extra_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extra_group_id` bigint(20) unsigned NOT NULL,
  `value` varchar(191) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `extra_values_extra_group_id_foreign` (`extra_group_id`),
  CONSTRAINT `extra_values_extra_group_id_foreign` FOREIGN KEY (`extra_group_id`) REFERENCES `extra_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `extra_values` WRITE;
/*!40000 ALTER TABLE `extra_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `extra_values` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `faq_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `faq_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `question` text NOT NULL,
  `answer` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `faq_translations_faq_id_locale_unique` (`faq_id`,`locale`),
  KEY `faq_translations_locale_index` (`locale`),
  CONSTRAINT `faq_translations_faq_id_foreign` FOREIGN KEY (`faq_id`) REFERENCES `faqs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `faq_translations` WRITE;
/*!40000 ALTER TABLE `faq_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faqs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `faqs_uuid_index` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `galleries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `loadable_type` varchar(255) NOT NULL,
  `loadable_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `mime` varchar(255) DEFAULT NULL,
  `size` varchar(255) DEFAULT NULL,
  `preview` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_loadable_type_loadable_id_index` (`loadable_type`,`loadable_id`),
  KEY `galleries_loadable_id_index` (`loadable_id`),
  KEY `galleries_loadable_type_index` (`loadable_type`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (3,'images/shops/logo/103-17375288179187.webp','App\\Models\\Shop',501,'shops','https://premfashion.webschedio.in/storage/images/shops/logo/103-17375288179187.webp',NULL,NULL,NULL),(4,'images/shops/background/103-17375288284147.webp','App\\Models\\Shop',501,'shops','https://premfashion.webschedio.in/storage/images/shops/background/103-17375288284147.webp',NULL,NULL,NULL),(5,'images/categories/103-17375291643927.webp','App\\Models\\Category',5,'categories','https://premfashion.webschedio.in/storage/images/categories/103-17375291643927.webp',NULL,NULL,NULL),(8,'images/products/103-17375292816924.webp','App\\Models\\Product',1,'products','https://premfashion.webschedio.in/storage/images/products/103-17375292816924.webp',NULL,NULL,NULL),(9,'images/products/103-17375292906262.webp','App\\Models\\Product',1,'products','https://premfashion.webschedio.in/storage/images/products/103-17375292906262.webp',NULL,NULL,NULL),(11,'images/products/103-17375313729071.webp','App\\Models\\Product',2,'products','https://premfashion.webschedio.in/storage/images/products/103-17375313729071.webp',NULL,NULL,NULL),(12,'images/other/103-17375320209243.webp','App\\Models\\AdsPackage',1,'other','https://premfashion.webschedio.in/storage/images/other/103-17375320209243.webp',NULL,NULL,NULL),(13,'images/categories/103-17375409325630.webp','App\\Models\\Category',6,'categories','https://premfashion.webschedio.in/storage/images/categories/103-17375409325630.webp',NULL,NULL,NULL);
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invitations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invitations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `role` varchar(255) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invitations_shop_id_foreign` (`shop_id`),
  KEY `invitations_user_id_foreign` (`user_id`),
  CONSTRAINT `invitations_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invitations_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invitations` WRITE;
/*!40000 ALTER TABLE `invitations` DISABLE KEYS */;
/*!40000 ALTER TABLE `invitations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `landing_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `landing_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`data`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `landing_pages` WRITE;
/*!40000 ALTER TABLE `landing_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `landing_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `backward` tinyint(1) NOT NULL DEFAULT 0,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `languages_locale_unique` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en',0,1,1,NULL);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `likes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `likes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `likable_type` varchar(255) NOT NULL,
  `likable_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `likes_likable_type_likable_id_index` (`likable_type`,`likable_id`),
  KEY `likes_likable_id_index` (`likable_id`),
  KEY `likes_likable_type_index` (`likable_type`),
  KEY `likes_user_id_foreign` (`user_id`),
  CONSTRAINT `likes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `likes` WRITE;
/*!40000 ALTER TABLE `likes` DISABLE KEYS */;
/*!40000 ALTER TABLE `likes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `meta_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `meta_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) DEFAULT NULL,
  `model_id` int(11) DEFAULT NULL,
  `model_type` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `h1` varchar(255) DEFAULT NULL,
  `seo_text` text DEFAULT NULL,
  `canonical` varchar(255) DEFAULT NULL,
  `robots` varchar(255) DEFAULT NULL,
  `change_freq` varchar(10) DEFAULT NULL,
  `priority` varchar(10) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `meta_tags` WRITE;
/*!40000 ALTER TABLE `meta_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `meta_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_04_02_193005_create_translations_table',1),(2,'2014_10_12_000000_create_users_table',1),(3,'2014_10_12_100000_create_password_resets_table',1),(4,'2019_08_19_000000_create_failed_jobs_table',1),(5,'2019_12_14_000001_create_personal_access_tokens_table',1),(6,'2022_02_22_171401_create_regions_table',1),(7,'2022_02_22_185642_create_languages_table',1),(8,'2022_02_22_185742_create_currencies_table',1),(9,'2022_02_22_192557_create_shops_table',1),(10,'2022_02_22_193407_create_categories_table',1),(11,'2022_02_22_193424_create_category_translations_table',1),(12,'2022_02_22_201116_create_permission_tables',1),(13,'2022_02_24_184818_create_galleries_table',1),(14,'2022_03_28_231708_create_sessions_table',1),(15,'2022_03_29_163004_create_meta_tags_table',1),(16,'2022_04_06_181958_create_brands_table',1),(17,'2022_04_15_020426_create_invitations_table',1),(18,'2022_05_26_183627_create_discounts_table',1),(19,'2022_05_26_191654_create_units_table',1),(20,'2022_05_26_192700_create_unit_translations_table',1),(21,'2022_05_27_164617_create_products_table',1),(22,'2022_05_30_171811_create_product_translations_table',1),(23,'2022_05_30_172012_create_product_properties_table',1),(24,'2022_05_31_200710_create_settings_table',1),(25,'2022_06_08_170500_create_extra_groups_table',1),(26,'2022_06_08_170501_create_extra_group_translations_table',1),(27,'2022_06_08_170502_create_extra_values_table',1),(28,'2022_06_17_203506_create_jobs_table',1),(29,'2022_07_16_170220_create_reviews_table',1),(30,'2022_07_16_171208_create_banners_table',1),(31,'2022_07_16_171223_create_banner_translations_table',1),(32,'2022_07_16_171350_create_backup_histories_table',1),(33,'2022_08_03_160502_create_blogs_table',1),(34,'2022_08_03_162247_create_faqs_table',1),(35,'2022_08_06_190654_create_transactions_table',1),(36,'2022_08_06_193757_create_wallets_table',1),(37,'2022_08_06_193823_create_wallet_histories_table',1),(38,'2022_08_06_213956_create_payments_table',1),(39,'2022_08_16_182348_create_term_conditions_table',1),(40,'2022_08_16_212847_create_sms_gateways_table',1),(41,'2022_08_19_190851_create_social_providers_table',1),(42,'2022_09_22_184827_create_likes_table',1),(43,'2022_09_24_072905_create_points_table',1),(44,'2022_09_24_072925_create_user_points_table',1),(45,'2022_10_22_063552_create_delivery_prices_table',1),(46,'2022_10_22_103545_create_delivery_points_table',1),(47,'2022_10_22_150040_create_delivery_point_translations_table',1),(48,'2022_11_10_085115_create_privacy_policies_table',1),(49,'2022_11_10_085352_create_privacy_policy_translations_table',1),(50,'2022_11_16_150240_create_stocks_table',1),(51,'2022_11_17_085547_create_carts_table',1),(52,'2022_11_17_090130_create_user_carts_table',1),(53,'2022_11_17_124705_create_cart_details_table',1),(54,'2022_11_25_113042_create_bonuses_table',1),(55,'2022_12_04_074133_create_stories_table',1),(56,'2022_12_04_122819_create_order_statuses_table',1),(57,'2022_12_05_064109_create_tags_table',1),(58,'2022_12_08_073731_create_email_settings_table',1),(59,'2022_12_09_072831_create_email_subscriptions_table',1),(60,'2022_12_13_053448_create_email_templates_table',1),(61,'2022_12_15_132244_create_shop_payments_table',1),(62,'2022_12_17_110940_create_shop_working_days',1),(63,'2022_12_19_061554_create_shop_closed_dates_table',1),(64,'2023_01_06_061829_create_deliveryman_settings_table',1),(65,'2023_01_12_064505_create_notifications_table',1),(66,'2023_01_12_065959_create_notification_user_table',1),(67,'2023_01_16_112952_create_payouts_table',1),(68,'2023_02_03_083653_create_banner_products_table',1),(69,'2023_02_05_072041_create_referrals_table',1),(70,'2023_02_05_072121_create_referral_translations_table',1),(71,'2023_02_10_101432_create_shop_tags_table',1),(72,'2023_02_10_101440_create_shop_tag_translations_table',1),(73,'2023_02_10_101633_create_assign_shop_tags_table',1),(74,'2023_02_22_110323_create_payment_process_table',1),(75,'2023_03_02_051806_create_payment_payloads_table',1),(76,'2023_03_02_084934_create_sms_payloads_table',1),(77,'2023_03_16_095644_create_shop_galleries_table',1),(78,'2023_03_24_110631_create_shop_deliveryman_settings',1),(79,'2023_04_03_115648_create_user_activities_table',1),(80,'2023_04_10_111219_create_careers_table',1),(81,'2023_04_10_131050_create_pages_table',1),(82,'2023_04_10_181845_create_model_logs_table',1),(83,'2023_04_27_095435_create_landing_pages_table',1),(84,'2023_05_02_064049_create_push_notifications_table',1),(85,'2023_06_16_101732_create_digital_files',1),(86,'2023_06_16_111315_create_user_digital_files',1),(87,'2023_06_19_071130_create_ads_packages_table',1),(88,'2023_06_20_065025_create_shop_socials_table',1),(89,'2023_08_10_064800_create_request_models_table',1),(90,'2023_08_18_134022_create_parcel_order_settings_table',1),(91,'2023_08_20_030743_create_parcel_options_table',1),(92,'2023_08_20_044222_create_parcel_orders_table',1),(93,'2023_08_23_143728_create_subscriptions_table',1),(94,'2023_08_24_031349_create_shop_subscriptions_table',1),(95,'2023_08_30_130611_create_shop_locations_table',1),(96,'2023_09_30_041936_create_warehouses_table',1),(97,'2023_09_30_042251_create_warehouse_translations_table',1),(98,'2023_10_11_091541_add_slug_in_products_table_categories_table_shops_table_brands_table',1),(99,'2023_10_14_101126_add_column_in_ads_package_translations_table',1),(100,'2023_10_16_085931_change_product_id_in_stories_table',1),(101,'2023_10_19_135405_add_preview_column_in_galleries_table',1),(102,'2023_10_21_090641_add_shop_id_in_banners_table',1),(103,'2023_11_06_053856_add_columns_to_users_table',1),(104,'2023_11_07_112025_add_position_page_in_ads_packages_table',1),(105,'2023_11_09_102909_add_deleted_at_in_products_table',1),(106,'2023_11_20_111156_add_desc_column_in_term_condition_translations',1),(107,'2023_11_27_094054_create_user_address_table',1),(108,'2023_11_28_031337_change_delivery_date_in_parcel_orders_table',1),(109,'2023_12_04_085626_add_delivery_type_column_in_shops_table',1),(110,'2023_12_05_052704_create_delivery_price_translations_table',1),(111,'2023_12_07_064250_remigrate_orders_table',1),(112,'2023_12_25_071344_change_column_in_term_condition_translations',1),(113,'2024_01_03_121707_create_order_status_notes_table',1),(114,'2024_01_04_091028_create_wholesale_prices_table',1),(115,'2024_01_30_102545_change_my_referral_column_in_users_table',1),(116,'2024_02_07_095342_set_null_in_orders_table',1),(117,'2024_07_18_104243_add_email_send_status_in_shops_table',1),(118,'2024_07_25_081222_add_otp_column_in_orders_table',1),(119,'2024_09_25_121420_add_img_column_in_banner_translations_table',1),(120,'2024_09_28_095958_add_discount_column_in_cart_details_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\Models\\User',102),(1,'App\\Models\\User',108),(1,'App\\Models\\User',109),(11,'App\\Models\\User',107),(12,'App\\Models\\User',105),(13,'App\\Models\\User',106),(21,'App\\Models\\User',104),(99,'App\\Models\\User',103);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'log',
  PRIMARY KEY (`id`),
  KEY `model_logs_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_logs` WRITE;
/*!40000 ALTER TABLE `model_logs` DISABLE KEYS */;
INSERT INTO `model_logs` VALUES (1,'App\\Models\\Category',1,'{\"keywords\":\"main\",\"type\":1,\"uuid\":\"623e0098-b1f8-4edd-bbdc-5288e541504b\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":1}','2024-12-30 00:58:25',NULL,'category_created'),(2,'App\\Models\\Category',2,'{\"keywords\":\"sub_main\",\"type\":2,\"uuid\":\"6accfd58-b88a-4c7c-be31-dce72ff8a807\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":2}','2024-12-30 00:58:25',NULL,'category_created'),(3,'App\\Models\\Category',3,'{\"keywords\":\"child\",\"type\":3,\"uuid\":\"433f8bfa-dc8e-4f4b-b160-b081fe752e63\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":3}','2024-12-30 00:58:25',NULL,'category_created'),(4,'App\\Models\\Category',4,'{\"keywords\":\"career\",\"type\":10,\"uuid\":\"1d00777f-725c-4366-9495-18efd6c7d6ef\",\"updated_at\":\"2024-12-30 06:28:25\",\"created_at\":\"2024-12-30 06:28:25\",\"id\":4}','2024-12-30 00:58:25',NULL,'category_created'),(5,'App\\Models\\User',102,'{\"id\":102,\"uuid\":\"927f4e5b-dfe0-4162-8577-905485165a93\",\"firstname\":\"User\",\"lastname\":\"User\",\"email\":\"user@githubit.com\",\"phone\":\"998911902595\",\"birthday\":\"1993-12-30\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:40.927986Z\",\"password\":\"$2y$10$8Awe1ckoG.grG9B2zTkhoeq6mUylikbpJsPlApX1EwOlz2ymDjshC\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"7N102ATP\"}','2024-12-30 00:58:41',NULL,'user_created'),(6,'App\\Models\\User',103,'{\"id\":103,\"uuid\":\"22ab0041-ab87-4fcf-920a-14a05876dff6\",\"firstname\":\"Owner\",\"lastname\":\"Owner\",\"email\":\"owner@githubit.com\",\"phone\":\"998911902696\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.002267Z\",\"password\":\"$2y$10$O9ejE4dh5GcsnVnwE\\/Enyu8N8BQ8\\/PdzdKkYbnWbGFxY58v6IB\\/HW\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"OI103HPI\"}','2024-12-30 00:58:41',NULL,'user_created'),(7,'App\\Models\\User',104,'{\"id\":104,\"uuid\":\"4040fad0-5d08-4c6f-8f3d-cecef65eaff6\",\"firstname\":\"Manager\",\"lastname\":\"Manager\",\"email\":\"manager@githubit.com\",\"phone\":\"998911902616\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.065125Z\",\"password\":\"$2y$10$hpC\\/OjlT1OrZ8eQxpfW.jumb3NZ1dH2AiVXaqTsLn72W1f.XNnsJy\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"MK104LRZ\"}','2024-12-30 00:58:41',NULL,'user_created'),(8,'App\\Models\\User',105,'{\"id\":105,\"uuid\":\"5d10d939-2bdf-4f70-a6eb-148bdca3a946\",\"firstname\":\"Moderator\",\"lastname\":\"Moderator\",\"email\":\"moderator@githubit.com\",\"phone\":\"998911902116\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.127977Z\",\"password\":\"$2y$10$6prJ49UbLks5N8EWi6A37ORfFdRomyJI87xmOFXRQ6ROkR8FbrIey\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"SL105CIZ\"}','2024-12-30 00:58:41',NULL,'user_created'),(9,'App\\Models\\User',106,'{\"id\":106,\"uuid\":\"cf526659-9e7a-4311-80f1-61ad3737bd44\",\"firstname\":\"Delivery\",\"lastname\":\"Delivery\",\"email\":\"delivery@githubit.com\",\"phone\":\"998911912116\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.190907Z\",\"password\":\"$2y$10$p44L30ngdt.gQY8DEV5vgOlGOccCmiOXPIlkj7P9.yn80nTEWLwYi\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"EU106MFJ\"}','2024-12-30 00:58:41',NULL,'user_created'),(10,'App\\Models\\User',107,'{\"id\":107,\"uuid\":\"baa92065-258b-47c1-8c42-e5ef15051ba2\",\"firstname\":\"sellers\",\"lastname\":\"sellers\",\"email\":\"sellers@githubit.com\",\"phone\":\"998911902691\",\"birthday\":\"1990-12-31\",\"gender\":\"male\",\"email_verified_at\":\"2024-12-30T06:28:41.253762Z\",\"password\":\"$2y$10$pmk0UKRnNe\\/2Q6MdOMDIv.WZ1xtk.ozsiobWKa4NhomDIwj5PJ5V.\",\"created_at\":\"2024-12-30 06:28:41\",\"updated_at\":\"2024-12-30 06:28:41\",\"my_referral\":\"GG107RVQ\"}','2024-12-30 00:58:41',NULL,'user_created'),(11,'App\\Models\\Shop',501,'{\"user_id\":107,\"uuid\":\"7ccbbec5-d239-4897-a0e0-9d0c25609060\",\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"phone\":\"+1234566\",\"open\":1,\"background_img\":\"url.webp\",\"logo_img\":\"url.webp\",\"status\":\"approved\",\"status_note\":\"approved\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"type\":1,\"updated_at\":\"2024-12-30 06:28:41\",\"created_at\":\"2024-12-30 06:28:41\",\"id\":501}','2024-12-30 00:58:41',NULL,'shop_created'),(12,'App\\Models\\User',108,'{\"email\":\"sunilshetty004@gmail.com\",\"firstname\":\"sunilshetty004@gmail.com\",\"ip_address\":\"127.0.0.1\",\"uuid\":\"d92c4f37-51e2-4d9c-9b2a-ec82b830e529\",\"my_referral\":\"VIF9YBWF\",\"updated_at\":\"2024-12-30 07:10:10\",\"created_at\":\"2024-12-30 07:10:10\",\"id\":108}','2024-12-30 01:40:11',NULL,'user_created'),(13,'App\\Models\\User',108,'{\"uuid\":\"d92c4f37-51e2-4d9c-9b2a-ec82b830e529\"}','2024-12-30 01:40:11',NULL,'user_updated'),(14,'App\\Models\\User',109,'{\"email\":\"sunilshetty@gmail.com\",\"firstname\":\"sunilshetty@gmail.com\",\"ip_address\":\"122.162.169.180\",\"uuid\":\"8135ea64-2d77-48de-bf72-889775c2a05e\",\"my_referral\":\"TSKCDQQ9\",\"updated_at\":\"2025-01-03 06:40:48\",\"created_at\":\"2025-01-03 06:40:48\",\"id\":109}','2025-01-03 01:10:48',NULL,'user_created'),(15,'App\\Models\\User',109,'{\"uuid\":\"8135ea64-2d77-48de-bf72-889775c2a05e\"}','2025-01-03 01:10:48',NULL,'user_updated'),(16,'App\\Models\\User',108,'{\"ip_address\":\"127.0.0.1\"}','2025-01-03 01:11:31',NULL,'user_updated'),(17,'App\\Models\\User',108,'{\"verify_token\":\"542611\"}','2025-01-03 01:11:31',NULL,'user_updated'),(18,'App\\Models\\User',108,'{\"verify_token\":\"886491\"}','2025-01-03 01:14:49',NULL,'user_updated'),(19,'App\\Models\\User',108,'{\"verify_token\":\"886689\"}','2025-01-03 01:17:14',NULL,'user_updated'),(20,'App\\Models\\User',108,'{\"verify_token\":\"886834\"}','2025-01-03 01:38:50',NULL,'user_updated'),(21,'App\\Models\\User',108,'{\"verify_token\":\"888130\"}','2025-01-03 01:44:01',NULL,'user_updated'),(22,'App\\Models\\Shop',501,'{\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"verify\":0}','2025-01-22 01:23:14',103,'shop_updated'),(23,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"phone\":\"+1234566\",\"visibility\":1,\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\"}','2025-01-22 01:24:00',103,'shop_updated'),(24,'App\\Models\\Shop',501,'{\"slug\":null,\"lat_long\":\"{\\\"latitude\\\":-69.3453324000000037585778045468032360076904296875,\\\"longitude\\\":69.3453324000000037585778045468032360076904296875}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":\"1\"}','2025-01-22 01:24:00',103,'shop_updated'),(25,'App\\Models\\Shop',501,'{\"lat_long\":\"{\\\"latitude\\\":-69.3453324000000037585778045468032360076904296875,\\\"longitude\\\":69.3453324000000037585778045468032360076904296875}\",\"background_img\":\"url.webp\",\"logo_img\":\"url.webp\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":\"1\"}','2025-01-22 01:24:00',103,'shop_updated'),(26,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2024-12-30 06:28:41\",\"phone_verified_at\":null}','2025-01-22 01:24:17',103,'user_updated'),(27,'App\\Models\\Shop',501,'{\"tax\":0,\"percentage\":0,\"lat_long\":\"{\\\"latitude\\\":-69.3453324,\\\"longitude\\\":69.3453324}\",\"phone\":\"1234566\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":1}','2025-01-22 01:25:15',103,'shop_updated'),(28,'App\\Models\\Shop',501,'{\"slug\":\"branch-title-501\",\"lat_long\":\"{\\\"latitude\\\":-69.3453324000000037585778045468032360076904296875,\\\"longitude\\\":69.3453324000000037585778045468032360076904296875}\",\"delivery_time\":\"{\\\"from\\\":\\\"10\\\",\\\"to\\\":\\\"90\\\",\\\"type\\\":\\\"minute\\\"}\",\"delivery_type\":\"2\"}','2025-01-22 01:25:15',103,'shop_updated'),(29,'App\\Models\\User',107,'{\"birthday\":\"1990-12-31\",\"email_verified_at\":\"2025-01-22 06:54:17\",\"phone_verified_at\":\"2025-01-22 06:54:17\"}','2025-01-22 01:25:33',103,'user_updated'),(30,'App\\Models\\Category',5,'{\"keywords\":\"men\",\"type\":1,\"active\":\"1\",\"input\":\"123\",\"uuid\":\"873403ab-d5ed-4d2b-a954-94fb1f9c6365\",\"updated_at\":\"2025-01-22 06:59:30\",\"created_at\":\"2025-01-22 06:59:30\",\"id\":5}','2025-01-22 01:29:30',103,'category_created'),(31,'App\\Models\\Category',5,'{\"active\":\"1\",\"input\":\"123\",\"uuid\":\"873403ab-d5ed-4d2b-a954-94fb1f9c6365\"}','2025-01-22 01:29:30',103,'category_updated'),(32,'App\\Models\\Category',5,'{\"active\":\"1\",\"input\":\"123\",\"uuid\":\"873403ab-d5ed-4d2b-a954-94fb1f9c6365\"}','2025-01-22 01:29:30',103,'category_updated'),(33,'App\\Models\\Category',5,'{\"status\":\"pending\"}','2025-01-22 01:29:59',103,'category_updated'),(34,'App\\Models\\Product',1,'{\"uuid\":\"6bc6a184-5ff9-4c0f-84da-bba42a55697a\"}','2025-01-22 01:32:01',103,'product_updated'),(35,'App\\Models\\Product',1,'{\"uuid\":\"6bc6a184-5ff9-4c0f-84da-bba42a55697a\"}','2025-01-22 01:32:01',103,'product_updated'),(36,'App\\Models\\Product',1,'{\"min_price\":0,\"max_price\":0}','2025-01-22 01:32:31',103,'product_updated'),(37,'App\\Models\\Product',1,'{\"status\":\"pending\",\"status_note\":null}','2025-01-22 01:32:57',103,'product_updated'),(38,'App\\Models\\User',103,'{\"birthday\":\"1990-12-31\",\"firebase_token\":null}','2025-01-22 01:53:20',103,'user_updated'),(39,'App\\Models\\Product',2,'{\"uuid\":\"411ab7e8-8a2e-481f-a495-7d1ea3259599\"}','2025-01-22 02:06:42',103,'product_updated'),(40,'App\\Models\\Product',2,'{\"uuid\":\"411ab7e8-8a2e-481f-a495-7d1ea3259599\"}','2025-01-22 02:06:42',103,'product_updated'),(41,'App\\Models\\Product',2,'{\"min_price\":0,\"max_price\":0}','2025-01-22 02:07:18',103,'product_updated'),(42,'App\\Models\\Product',2,'{\"status\":\"pending\",\"status_note\":null}','2025-01-22 04:17:14',103,'product_updated'),(43,'App\\Models\\Category',6,'{\"keywords\":\"women\",\"type\":1,\"active\":\"1\",\"input\":\"12\",\"uuid\":\"a1990c1a-c78c-43e1-b3a6-434e9ce98ed3\",\"updated_at\":\"2025-01-22 10:15:38\",\"created_at\":\"2025-01-22 10:15:38\",\"id\":6}','2025-01-22 04:45:38',103,'category_created'),(44,'App\\Models\\Category',6,'{\"active\":\"1\",\"input\":\"12\",\"uuid\":\"a1990c1a-c78c-43e1-b3a6-434e9ce98ed3\"}','2025-01-22 04:45:38',103,'category_updated'),(45,'App\\Models\\Category',6,'{\"active\":\"1\",\"input\":\"12\",\"uuid\":\"a1990c1a-c78c-43e1-b3a6-434e9ce98ed3\"}','2025-01-22 04:45:38',103,'category_updated'),(46,'App\\Models\\Category',6,'{\"status\":\"pending\"}','2025-01-22 04:47:46',103,'category_updated');
/*!40000 ALTER TABLE `model_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `notification_user_notification_id_foreign` (`notification_id`),
  KEY `notification_user_user_id_foreign` (`user_id`),
  CONSTRAINT `notification_user_notification_id_foreign` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notification_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_user` WRITE;
/*!40000 ALTER TABLE `notification_user` DISABLE KEYS */;
INSERT INTO `notification_user` VALUES (1,1,102,1),(2,1,103,1),(3,1,104,1),(4,1,105,1),(5,1,106,1),(6,1,107,1);
/*!40000 ALTER TABLE `notification_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('push') NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`payload`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `notifications_type_unique` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` VALUES (1,'push',NULL,'2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `price` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_coupons_order_id_foreign` (`order_id`),
  CONSTRAINT `order_coupons_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_coupons` WRITE;
/*!40000 ALTER TABLE `order_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_coupons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `stock_id` bigint(20) unsigned NOT NULL,
  `replace_stock_id` bigint(20) unsigned DEFAULT NULL,
  `replace_quantity` int(11) DEFAULT NULL,
  `replace_note` varchar(255) DEFAULT NULL,
  `origin_price` double NOT NULL DEFAULT 0,
  `total_price` double NOT NULL DEFAULT 0,
  `tax` double NOT NULL DEFAULT 0,
  `discount` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `bonus` tinyint(1) NOT NULL DEFAULT 0,
  `note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_details_order_id_foreign` (`order_id`),
  KEY `order_details_stock_id_foreign` (`stock_id`),
  KEY `order_details_replace_stock_id_foreign` (`replace_stock_id`),
  CONSTRAINT `order_details_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_details_replace_stock_id_foreign` FOREIGN KEY (`replace_stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_details_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=500 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_details` WRITE;
/*!40000 ALTER TABLE `order_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_refunds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_refunds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('pending','accepted','canceled') NOT NULL DEFAULT 'pending',
  `cause` text DEFAULT NULL,
  `answer` text DEFAULT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_refunds_order_id_foreign` (`order_id`),
  KEY `order_refunds_status_index` (`status`),
  CONSTRAINT `order_refunds_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_refunds` WRITE;
/*!40000 ALTER TABLE `order_refunds` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_refunds` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_status_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_status_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `status` varchar(255) NOT NULL,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`notes`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_status_notes_order_id_foreign` (`order_id`),
  CONSTRAINT `order_status_notes_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_status_notes` WRITE;
/*!40000 ALTER TABLE `order_status_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_status_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `sort` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_statuses` WRITE;
/*!40000 ALTER TABLE `order_statuses` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_statuses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '1' COMMENT 'in_house, seller',
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `deliveryman_id` bigint(20) unsigned DEFAULT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `delivery_price_id` bigint(20) unsigned DEFAULT NULL,
  `delivery_point_id` bigint(20) unsigned DEFAULT NULL,
  `address_id` bigint(20) unsigned DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'new',
  `total_price` double NOT NULL COMMENT 'Сумма с учётом всех налогов и скидок',
  `commission_fee` double NOT NULL,
  `service_fee` double DEFAULT NULL,
  `delivery_fee` double DEFAULT NULL,
  `total_discount` double DEFAULT NULL,
  `total_tax` double NOT NULL DEFAULT 1,
  `rate` double(8,2) NOT NULL DEFAULT 1.00,
  `note` varchar(191) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `delivery_type` varchar(255) NOT NULL DEFAULT 'point',
  `img` varchar(255) DEFAULT NULL,
  `canceled_note` varchar(255) DEFAULT NULL,
  `track_name` varchar(255) DEFAULT NULL,
  `track_id` varchar(255) DEFAULT NULL,
  `track_url` varchar(255) DEFAULT NULL,
  `current` tinyint(1) NOT NULL DEFAULT 0,
  `coupon_price` double DEFAULT NULL,
  `cart_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `otp` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orders_user_id_foreign` (`user_id`),
  KEY `orders_shop_id_foreign` (`shop_id`),
  KEY `orders_parent_id_foreign` (`parent_id`),
  KEY `orders_deliveryman_id_foreign` (`deliveryman_id`),
  KEY `orders_currency_id_foreign` (`currency_id`),
  KEY `orders_delivery_price_id_foreign` (`delivery_price_id`),
  KEY `orders_delivery_point_id_foreign` (`delivery_point_id`),
  KEY `orders_address_id_foreign` (`address_id`),
  CONSTRAINT `orders_address_id_foreign` FOREIGN KEY (`address_id`) REFERENCES `user_addresses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `orders_delivery_point_id_foreign` FOREIGN KEY (`delivery_point_id`) REFERENCES `delivery_points` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_delivery_price_id_foreign` FOREIGN KEY (`delivery_price_id`) REFERENCES `delivery_prices` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_deliveryman_id_foreign` FOREIGN KEY (`deliveryman_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `page_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `page_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_translations_page_id_locale_unique` (`page_id`,`locale`),
  KEY `page_translations_locale_index` (`locale`),
  CONSTRAINT `page_translations_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `pages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `page_translations` WRITE;
/*!40000 ALTER TABLE `page_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `page_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT 'about',
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `bg_img` varchar(255) DEFAULT NULL,
  `buttons` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`buttons`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_option_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parcel_option_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parcel_option_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `parcel_option_translations_parcel_option_id_locale_unique` (`parcel_option_id`,`locale`),
  KEY `parcel_option_translations_locale_index` (`locale`),
  CONSTRAINT `parcel_option_translations_parcel_option_id_foreign` FOREIGN KEY (`parcel_option_id`) REFERENCES `parcel_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_option_translations` WRITE;
/*!40000 ALTER TABLE `parcel_option_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_option_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parcel_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_options` WRITE;
/*!40000 ALTER TABLE `parcel_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_options` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_order_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parcel_order_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `min_width` smallint(6) NOT NULL DEFAULT 0,
  `min_height` smallint(6) NOT NULL DEFAULT 0,
  `min_length` smallint(6) NOT NULL DEFAULT 0,
  `max_width` smallint(6) NOT NULL DEFAULT 0,
  `max_height` smallint(6) NOT NULL DEFAULT 0,
  `max_length` smallint(6) NOT NULL DEFAULT 0,
  `max_range` int(11) NOT NULL DEFAULT 0,
  `min_g` int(11) NOT NULL DEFAULT 100,
  `max_g` int(11) NOT NULL DEFAULT 100,
  `price` double NOT NULL DEFAULT 0,
  `price_per_km` double NOT NULL DEFAULT 0,
  `special` tinyint(1) NOT NULL DEFAULT 0,
  `special_price` double DEFAULT 0,
  `special_price_per_km` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_order_settings` WRITE;
/*!40000 ALTER TABLE `parcel_order_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_order_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parcel_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `total_price` double DEFAULT 0 COMMENT 'Сумма с учётом всех налогов и скидок',
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `type_id` bigint(20) unsigned NOT NULL,
  `rate` double(8,2) DEFAULT 1.00,
  `note` varchar(191) DEFAULT NULL,
  `qr_value` varchar(255) DEFAULT NULL,
  `notify` tinyint(1) NOT NULL DEFAULT 0,
  `instruction` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `tax` double DEFAULT 1,
  `status` varchar(255) DEFAULT 'new',
  `address_from` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address_from`)),
  `phone_from` varchar(255) DEFAULT NULL,
  `username_from` varchar(255) DEFAULT NULL,
  `address_to` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address_to`)),
  `phone_to` varchar(255) DEFAULT NULL,
  `username_to` varchar(255) DEFAULT NULL,
  `delivery_fee` double DEFAULT 0,
  `km` double DEFAULT 0,
  `deliveryman_id` bigint(20) unsigned DEFAULT NULL,
  `current` tinyint(1) DEFAULT 0,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parcel_orders_currency_id_foreign` (`currency_id`),
  KEY `parcel_orders_type_id_foreign` (`type_id`),
  KEY `parcel_orders_deliveryman_id_foreign` (`deliveryman_id`),
  CONSTRAINT `parcel_orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL,
  CONSTRAINT `parcel_orders_deliveryman_id_foreign` FOREIGN KEY (`deliveryman_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `parcel_orders_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `parcel_order_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_orders` WRITE;
/*!40000 ALTER TABLE `parcel_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `parcel_setting_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parcel_setting_options` (
  `parcel_option_id` bigint(20) unsigned NOT NULL,
  `parcel_order_setting_id` bigint(20) unsigned NOT NULL,
  KEY `parcel_setting_options_parcel_option_id_foreign` (`parcel_option_id`),
  KEY `parcel_setting_options_parcel_order_setting_id_foreign` (`parcel_order_setting_id`),
  CONSTRAINT `parcel_setting_options_parcel_option_id_foreign` FOREIGN KEY (`parcel_option_id`) REFERENCES `parcel_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `parcel_setting_options_parcel_order_setting_id_foreign` FOREIGN KEY (`parcel_order_setting_id`) REFERENCES `parcel_order_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `parcel_setting_options` WRITE;
/*!40000 ALTER TABLE `parcel_setting_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `parcel_setting_options` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_payloads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_payloads` (
  `payment_id` bigint(20) unsigned NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`payload`)),
  KEY `payment_payloads_payment_id_foreign` (`payment_id`),
  CONSTRAINT `payment_payloads_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_payloads` WRITE;
/*!40000 ALTER TABLE `payment_payloads` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_payloads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_process`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_process` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`data`)),
  KEY `payment_process_user_id_foreign` (`user_id`),
  KEY `payment_process_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `payment_process_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_process` WRITE;
/*!40000 ALTER TABLE `payment_process` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_process` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_to_partners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_to_partners` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'seller',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_to_partners_user_id_foreign` (`user_id`),
  KEY `payment_to_partners_order_id_foreign` (`order_id`),
  CONSTRAINT `payment_to_partners_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payment_to_partners_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_to_partners` WRITE;
/*!40000 ALTER TABLE `payment_to_partners` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_to_partners` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) DEFAULT NULL,
  `input` tinyint(4) NOT NULL DEFAULT 2,
  `sandbox` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'cash',1,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(2,'wallet',2,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(3,'zain-cash',3,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(4,'paytabs',4,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(5,'flutter-wave',5,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(6,'paystack',6,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(7,'mercado-pago',7,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(8,'razorpay',8,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(9,'stripe',9,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(10,'paypal',10,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(11,'moya-sar',11,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(12,'mollie',12,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(13,'iyzico',13,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(14,'maksekeskus',14,0,1,'2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payouts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('pending','accepted','canceled') NOT NULL DEFAULT 'pending',
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `approved_by` bigint(20) unsigned DEFAULT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `payment_id` bigint(20) unsigned DEFAULT NULL,
  `cause` varchar(255) DEFAULT NULL,
  `answer` varchar(255) DEFAULT NULL,
  `price` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payouts_created_by_foreign` (`created_by`),
  KEY `payouts_approved_by_foreign` (`approved_by`),
  KEY `payouts_currency_id_foreign` (`currency_id`),
  KEY `payouts_payment_id_foreign` (`payment_id`),
  CONSTRAINT `payouts_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payouts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payouts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payouts_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payouts` WRITE;
/*!40000 ALTER TABLE `payouts` DISABLE KEYS */;
/*!40000 ALTER TABLE `payouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  KEY `personal_access_tokens_tokenable_id_index` (`tokenable_id`),
  KEY `personal_access_tokens_tokenable_type_index` (`tokenable_type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
INSERT INTO `personal_access_tokens` VALUES (1,'App\\Models\\User',103,'api_token','bbc58a0154ea0ab765d1c0c296cb38c9cbc00fb06f9c0e7ed1d84e5e07d3ff14','[\"*\"]','2025-01-03 00:48:35','2025-01-02 04:29:53','2025-01-03 00:48:35'),(2,'App\\Models\\User',103,'api_token','1ee505429fcbc33ec987108d41e6a1b6ca31c6861658f07d15654c677c8afe36','[\"*\"]','2025-01-03 00:56:36','2025-01-03 00:39:53','2025-01-03 00:56:36'),(3,'App\\Models\\User',103,'api_token','995c2fb4379ad4816f670383a8cea8cc45c8ce0e9dcae384babbac19fb0df5e7','[\"*\"]','2025-01-03 01:27:18','2025-01-03 00:41:03','2025-01-03 01:27:18'),(5,'App\\Models\\User',103,'api_token','5b9b77e78a4ec9eb7b0d558794d602d4abf7409c58aeafa9b5ace9cee06cd169','[\"*\"]','2025-01-22 04:53:55','2025-01-22 01:55:53','2025-01-22 04:53:55'),(6,'App\\Models\\User',103,'api_token','c826e75316e4667d77b40d915d86da8fc15f74ae33136bec7e2c2e0085d10f6f','[\"*\"]','2025-01-22 04:53:56','2025-01-22 04:39:38','2025-01-22 04:53:56');
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `point_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `point_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `price` double(20,2) NOT NULL DEFAULT 0.00,
  `note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `point_histories_user_id_foreign` (`user_id`),
  KEY `point_histories_order_id_foreign` (`order_id`),
  CONSTRAINT `point_histories_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`),
  CONSTRAINT `point_histories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `point_histories` WRITE;
/*!40000 ALTER TABLE `point_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `point_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `points` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'fix',
  `price` double NOT NULL DEFAULT 0,
  `value` int(11) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `points_shop_id_foreign` (`shop_id`),
  CONSTRAINT `points_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `points` WRITE;
/*!40000 ALTER TABLE `points` DISABLE KEYS */;
/*!40000 ALTER TABLE `points` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `privacy_policies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `privacy_policies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `privacy_policies` WRITE;
/*!40000 ALTER TABLE `privacy_policies` DISABLE KEYS */;
/*!40000 ALTER TABLE `privacy_policies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `privacy_policy_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `privacy_policy_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `privacy_policy_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `locale` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `privacy_policy_translations_privacy_policy_id_locale_unique` (`privacy_policy_id`,`locale`),
  KEY `privacy_policy_translations_locale_index` (`locale`),
  CONSTRAINT `privacy_policy_translations_privacy_policy_id_foreign` FOREIGN KEY (`privacy_policy_id`) REFERENCES `privacy_policies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `privacy_policy_translations` WRITE;
/*!40000 ALTER TABLE `privacy_policy_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `privacy_policy_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_properties` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `property_group_id` bigint(20) unsigned NOT NULL,
  `property_value_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_properties_product_id_foreign` (`product_id`),
  KEY `product_properties_property_group_id_foreign` (`property_group_id`),
  KEY `product_properties_property_value_id_foreign` (`property_value_id`),
  CONSTRAINT `product_properties_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_properties_property_group_id_foreign` FOREIGN KEY (`property_group_id`) REFERENCES `property_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_properties_property_value_id_foreign` FOREIGN KEY (`property_value_id`) REFERENCES `property_values` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_properties` WRITE;
/*!40000 ALTER TABLE `product_properties` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_properties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_translations_product_id_locale_unique` (`product_id`,`locale`),
  KEY `product_translations_locale_index` (`locale`),
  CONSTRAINT `product_translations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_translations` WRITE;
/*!40000 ALTER TABLE `product_translations` DISABLE KEYS */;
INSERT INTO `product_translations` VALUES (2,1,'en','Baggy pant','<p>Baggy pant for men</p>'),(4,2,'en','Shirt','<p>Shirt for men12</p>');
/*!40000 ALTER TABLE `product_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `brand_id` bigint(20) unsigned DEFAULT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `keywords` varchar(191) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `qr_code` varchar(255) DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('published','pending','unpublished') NOT NULL DEFAULT 'pending',
  `min_qty` int(11) NOT NULL DEFAULT 1,
  `max_qty` int(11) NOT NULL DEFAULT 2147483647,
  `digital` tinyint(1) NOT NULL DEFAULT 0,
  `age_limit` smallint(6) NOT NULL DEFAULT 0,
  `visibility` tinyint(1) NOT NULL DEFAULT 1,
  `interval` double NOT NULL DEFAULT 1,
  `status_note` varchar(255) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `o_count` double DEFAULT 0,
  `od_count` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `min_price` double DEFAULT 0,
  `max_price` int(11) DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_shop_id_foreign` (`shop_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_unit_id_foreign` (`unit_id`),
  KEY `products_uuid_index` (`uuid`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'baggy-pant-1','6bc6a184-5ff9-4c0f-84da-bba42a55697a',501,5,NULL,1,NULL,'https://premfashion.webschedio.in/storage/images/products/103-17375292816924.webp',NULL,1,1,'published',1,1,0,12,1,1,'',0,0,0,0,0,'2025-01-22 01:32:01','2025-01-22 01:32:57',2000,2000,NULL),(2,'shirt-2','411ab7e8-8a2e-481f-a495-7d1ea3259599',501,5,NULL,1,NULL,'https://premfashion.webschedio.in/storage/images/products/103-17375313729071.webp',NULL,1,1,'published',1,1,0,66,1,1,'',0,0,0,0,0,'2025-01-22 02:06:42','2025-01-22 04:17:14',1111,1111,NULL);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `property_group_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `property_group_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `property_group_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `property_group_translations_property_group_id_locale_unique` (`property_group_id`,`locale`),
  KEY `property_group_translations_locale_index` (`locale`),
  CONSTRAINT `property_group_translations_property_group_id_foreign` FOREIGN KEY (`property_group_id`) REFERENCES `property_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `property_group_translations` WRITE;
/*!40000 ALTER TABLE `property_group_translations` DISABLE KEYS */;
INSERT INTO `property_group_translations` VALUES (1,1,'en','Length');
/*!40000 ALTER TABLE `property_group_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `property_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `property_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `property_groups_shop_id_foreign` (`shop_id`),
  CONSTRAINT `property_groups_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `property_groups` WRITE;
/*!40000 ALTER TABLE `property_groups` DISABLE KEYS */;
INSERT INTO `property_groups` VALUES (1,'text',1,NULL);
/*!40000 ALTER TABLE `property_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `property_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `property_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `property_group_id` bigint(20) unsigned NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `value` varchar(191) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `property_values_property_group_id_foreign` (`property_group_id`),
  CONSTRAINT `property_values_property_group_id_foreign` FOREIGN KEY (`property_group_id`) REFERENCES `property_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `property_values` WRITE;
/*!40000 ALTER TABLE `property_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `property_values` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `push_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `push_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `body` text DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `push_notifications_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `push_notifications_user_id_foreign` (`user_id`),
  CONSTRAINT `push_notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `push_notifications` WRITE;
/*!40000 ALTER TABLE `push_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `referral_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `referral_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `referral_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `locale` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `faq` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `referral_translations_referral_id_locale_unique` (`referral_id`,`locale`),
  KEY `referral_translations_locale_index` (`locale`),
  CONSTRAINT `referral_translations_referral_id_foreign` FOREIGN KEY (`referral_id`) REFERENCES `referrals` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `referral_translations` WRITE;
/*!40000 ALTER TABLE `referral_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `referral_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `referrals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `price_from` double DEFAULT NULL,
  `price_to` double DEFAULT NULL,
  `expired_at` datetime DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `referrals` WRITE;
/*!40000 ALTER TABLE `referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `referrals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `region_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `region_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `region_id` bigint(20) unsigned DEFAULT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `region_translations_region_id_locale_unique` (`region_id`,`locale`),
  KEY `region_translations_locale_index` (`locale`),
  CONSTRAINT `region_translations_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `region_translations` WRITE;
/*!40000 ALTER TABLE `region_translations` DISABLE KEYS */;
INSERT INTO `region_translations` VALUES (1,1,'en','Asia');
/*!40000 ALTER TABLE `region_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `regions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `regions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `regions` WRITE;
/*!40000 ALTER TABLE `regions` DISABLE KEYS */;
INSERT INTO `regions` VALUES (1,1);
/*!40000 ALTER TABLE `regions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `request_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `request_models` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) DEFAULT NULL,
  `model_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `status_note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `request_models_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `request_models_created_by_foreign` (`created_by`),
  CONSTRAINT `request_models_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `request_models` WRITE;
/*!40000 ALTER TABLE `request_models` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviews` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `reviewable_type` varchar(255) NOT NULL,
  `reviewable_id` bigint(20) unsigned NOT NULL,
  `assignable_type` varchar(255) DEFAULT NULL,
  `assignable_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `rating` double NOT NULL DEFAULT 5,
  `comment` text DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reviews_reviewable_type_reviewable_id_index` (`reviewable_type`,`reviewable_id`),
  KEY `reviews_assignable_type_assignable_id_index` (`assignable_type`,`assignable_id`),
  KEY `reviews_reviewable_id_index` (`reviewable_id`),
  KEY `reviews_reviewable_type_index` (`reviewable_type`),
  KEY `reviews_user_id_foreign` (`user_id`),
  CONSTRAINT `reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reviews` WRITE;
/*!40000 ALTER TABLE `reviews` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviews` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'user','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(11,'seller','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(12,'moderator','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(13,'deliveryman','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(21,'manager','web','2024-12-30 00:58:25','2024-12-30 00:58:25'),(99,'admin','web','2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_ads_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_ads_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL DEFAULT 'new',
  `ads_package_id` bigint(20) unsigned NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `position_page` smallint(6) NOT NULL DEFAULT 1 COMMENT 'На какой странице будет выходить',
  PRIMARY KEY (`id`),
  KEY `shop_ads_packages_ads_package_id_foreign` (`ads_package_id`),
  KEY `shop_ads_packages_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_ads_packages_ads_package_id_foreign` FOREIGN KEY (`ads_package_id`) REFERENCES `ads_packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_ads_packages_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_ads_packages` WRITE;
/*!40000 ALTER TABLE `shop_ads_packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_ads_packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_ads_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_ads_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_ads_package_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `position_page` smallint(6) NOT NULL DEFAULT 1 COMMENT 'На какой странице будет выходить',
  PRIMARY KEY (`id`),
  KEY `shop_ads_products_shop_ads_package_id_foreign` (`shop_ads_package_id`),
  KEY `shop_ads_products_product_id_foreign` (`product_id`),
  CONSTRAINT `shop_ads_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_ads_products_shop_ads_package_id_foreign` FOREIGN KEY (`shop_ads_package_id`) REFERENCES `shop_ads_packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_ads_products` WRITE;
/*!40000 ALTER TABLE `shop_ads_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_ads_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_closed_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_closed_dates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_closed_dates_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_closed_dates_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_closed_dates` WRITE;
/*!40000 ALTER TABLE `shop_closed_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_closed_dates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_deliveryman_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_deliveryman_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `type` enum('fix','percent') NOT NULL,
  `value` int(11) NOT NULL,
  `period` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_deliveryman_settings_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_deliveryman_settings_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_deliveryman_settings` WRITE;
/*!40000 ALTER TABLE `shop_deliveryman_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_deliveryman_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_galleries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_galleries` WRITE;
/*!40000 ALTER TABLE `shop_galleries` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_galleries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_locations_shop_id_foreign` (`shop_id`),
  KEY `shop_locations_region_id_foreign` (`region_id`),
  KEY `shop_locations_country_id_foreign` (`country_id`),
  KEY `shop_locations_city_id_foreign` (`city_id`),
  KEY `shop_locations_area_id_foreign` (`area_id`),
  CONSTRAINT `shop_locations_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_locations_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_locations` WRITE;
/*!40000 ALTER TABLE `shop_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) unsigned NOT NULL,
  `shop_id` bigint(20) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `client_id` varchar(191) DEFAULT NULL,
  `secret_id` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_payments_payment_id_foreign` (`payment_id`),
  KEY `shop_payments_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_payments_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_payments_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_payments` WRITE;
/*!40000 ALTER TABLE `shop_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_socials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_socials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `content` varchar(255) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_socials_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_socials_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_socials` WRITE;
/*!40000 ALTER TABLE `shop_socials` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_socials` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `subscription_id` bigint(20) unsigned NOT NULL,
  `expired_at` date DEFAULT NULL,
  `price` double DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_subscriptions_shop_id_foreign` (`shop_id`),
  KEY `shop_subscriptions_subscription_id_foreign` (`subscription_id`),
  CONSTRAINT `shop_subscriptions_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_subscriptions_subscription_id_foreign` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_subscriptions` WRITE;
/*!40000 ALTER TABLE `shop_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `shop_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_tag_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_tag_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_tag_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `locale` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shop_tag_translations_shop_tag_id_locale_unique` (`shop_tag_id`,`locale`),
  KEY `shop_tag_translations_locale_index` (`locale`),
  CONSTRAINT `shop_tag_translations_shop_tag_id_foreign` FOREIGN KEY (`shop_tag_id`) REFERENCES `shop_tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_tag_translations` WRITE;
/*!40000 ALTER TABLE `shop_tag_translations` DISABLE KEYS */;
INSERT INTO `shop_tag_translations` VALUES (1,1,'Halal','en');
/*!40000 ALTER TABLE `shop_tag_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_tags` WRITE;
/*!40000 ALTER TABLE `shop_tags` DISABLE KEYS */;
INSERT INTO `shop_tags` VALUES (1,NULL,'2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `shop_tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shop_translations_shop_id_locale_unique` (`shop_id`,`locale`),
  KEY `shop_translations_locale_index` (`locale`),
  CONSTRAINT `shop_translations_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_translations` WRITE;
/*!40000 ALTER TABLE `shop_translations` DISABLE KEYS */;
INSERT INTO `shop_translations` VALUES (3,501,'en','Prem Fashion','branch desc','address');
/*!40000 ALTER TABLE `shop_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shop_working_days`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shop_working_days` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') NOT NULL,
  `from` varchar(5) NOT NULL DEFAULT '9:00',
  `to` varchar(5) NOT NULL DEFAULT '21:00',
  `disabled` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_working_days_shop_id_foreign` (`shop_id`),
  CONSTRAINT `shop_working_days_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shop_working_days` WRITE;
/*!40000 ALTER TABLE `shop_working_days` DISABLE KEYS */;
INSERT INTO `shop_working_days` VALUES (8,501,'monday','01:00','23:00',0,'2025-01-22 01:25:28','2025-01-22 01:25:28'),(9,501,'tuesday','01:00','23:00',0,'2025-01-22 01:25:28','2025-01-22 01:25:28'),(10,501,'wednesday','01:00','23:00',0,'2025-01-22 01:25:28','2025-01-22 01:25:28'),(11,501,'thursday','01:00','23:00',0,'2025-01-22 01:25:28','2025-01-22 01:25:28'),(12,501,'friday','01:00','23:00',0,'2025-01-22 01:25:28','2025-01-22 01:25:28'),(13,501,'saturday','01:00','23:00',0,'2025-01-22 01:25:28','2025-01-22 01:25:28'),(14,501,'sunday','01:00','23:00',0,'2025-01-22 01:25:28','2025-01-22 01:25:28');
/*!40000 ALTER TABLE `shop_working_days` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `shops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shops` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `uuid` char(36) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `tax` double(22,2) NOT NULL DEFAULT 0.00,
  `percentage` double NOT NULL DEFAULT 0,
  `lat_long` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`lat_long`)),
  `phone` varchar(255) DEFAULT NULL,
  `open` tinyint(1) NOT NULL DEFAULT 1,
  `visibility` tinyint(1) NOT NULL DEFAULT 1,
  `background_img` varchar(191) DEFAULT NULL,
  `logo_img` varchar(191) DEFAULT NULL,
  `min_amount` double NOT NULL DEFAULT 0.1,
  `status` enum('new','edited','approved','rejected','inactive') NOT NULL DEFAULT 'new',
  `status_note` text DEFAULT NULL,
  `delivery_time` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`delivery_time`)),
  `type` tinyint(4) NOT NULL,
  `verify` tinyint(1) NOT NULL DEFAULT 0,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `o_count` double DEFAULT 0,
  `od_count` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `delivery_type` tinyint(4) NOT NULL DEFAULT 1,
  `email_statuses` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shops_user_id_foreign` (`user_id`),
  KEY `shops_uuid_index` (`uuid`),
  CONSTRAINT `shops_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=502 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `shops` WRITE;
/*!40000 ALTER TABLE `shops` DISABLE KEYS */;
INSERT INTO `shops` VALUES (501,'prem-fashion-501','7ccbbec5-d239-4897-a0e0-9d0c25609060',107,0.00,0,'{\"latitude\":-69.3453324,\"longitude\":69.3453324}','9741374744',1,0,'https://premfashion.webschedio.in/storage/images/shops/background/103-17375288284147.webp','https://premfashion.webschedio.in/storage/images/shops/logo/103-17375288179187.webp',0.1,'approved','approved','{\"from\":\"10\",\"to\":\"90\",\"type\":\"minute\"}',1,1,0,0,0,0,0,'2024-12-30 00:58:41','2025-01-22 01:25:15',2,NULL);
/*!40000 ALTER TABLE `shops` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_gateways`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_gateways` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `from` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `secret_key` varchar(255) DEFAULT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `text` varchar(191) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_gateways` WRITE;
/*!40000 ALTER TABLE `sms_gateways` DISABLE KEYS */;
INSERT INTO `sms_gateways` VALUES (1,'Nexmo','go-shop','nexmo',NULL,NULL,NULL,'Your verify code: #OTP#. Valid for 5 minutes',0,'2024-12-30 00:58:40','2024-12-30 00:58:40'),(2,'Twilio','','twilio',NULL,NULL,NULL,'Your verify code: #OTP#. Valid for 5 minutes',0,'2024-12-30 00:58:40','2024-12-30 00:58:40');
/*!40000 ALTER TABLE `sms_gateways` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_payloads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_payloads` (
  `type` varchar(255) NOT NULL DEFAULT 'firebase',
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`payload`)),
  `default` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_payloads` WRITE;
/*!40000 ALTER TABLE `sms_payloads` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_payloads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `social_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `social_providers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `provider` varchar(255) NOT NULL,
  `provider_id` text DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `social_providers_user_id_foreign` (`user_id`),
  CONSTRAINT `social_providers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `social_providers` WRITE;
/*!40000 ALTER TABLE `social_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_providers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_extras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_extras` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` bigint(20) unsigned NOT NULL,
  `extra_group_id` bigint(20) unsigned NOT NULL,
  `extra_value_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_extras_stock_id_foreign` (`stock_id`),
  KEY `stock_extras_extra_group_id_foreign` (`extra_group_id`),
  KEY `stock_extras_extra_value_id_foreign` (`extra_value_id`),
  CONSTRAINT `stock_extras_extra_group_id_foreign` FOREIGN KEY (`extra_group_id`) REFERENCES `extra_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stock_extras_extra_value_id_foreign` FOREIGN KEY (`extra_value_id`) REFERENCES `extra_values` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stock_extras_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_extras` WRITE;
/*!40000 ALTER TABLE `stock_extras` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_extras` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stocks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `price` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `bonus_expired_at` datetime DEFAULT NULL,
  `discount_expired_at` datetime DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `discount_id` bigint(20) unsigned DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `o_count` double DEFAULT 0,
  `od_count` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stocks_product_id_foreign` (`product_id`),
  KEY `stocks_discount_id_foreign` (`discount_id`),
  CONSTRAINT `stocks_discount_id_foreign` FOREIGN KEY (`discount_id`) REFERENCES `discounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `stocks_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stocks` WRITE;
/*!40000 ALTER TABLE `stocks` DISABLE KEYS */;
INSERT INTO `stocks` VALUES (1,1,2000,200,NULL,NULL,'100',NULL,NULL,NULL,0,0,NULL,NULL,NULL),(2,2,1111,155,NULL,NULL,'122',NULL,NULL,NULL,0,0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `stocks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `file_urls` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`file_urls`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stories_shop_id_foreign` (`shop_id`),
  KEY `stories_product_id_foreign` (`product_id`),
  CONSTRAINT `stories_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stories_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stories` WRITE;
/*!40000 ALTER TABLE `stories` DISABLE KEYS */;
/*!40000 ALTER TABLE `stories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT 'order',
  `price` double NOT NULL,
  `month` tinyint(4) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `title` varchar(255) NOT NULL,
  `product_limit` int(11) NOT NULL,
  `order_limit` int(11) NOT NULL,
  `with_report` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (97,'orders',100,1,1,'title1',1000,1000,0,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(98,'orders',250,3,1,'title3',3000,3000,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(99,'orders',450,6,1,'title6',6000,6000,1,'2024-12-30 00:58:25','2024-12-30 00:58:25'),(100,'orders',800,12,1,'title12',12000,12000,1,'2024-12-30 00:58:25','2024-12-30 00:58:25');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tag_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tag_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag_translations_tag_id_locale_unique` (`tag_id`,`locale`),
  KEY `tag_translations_locale_index` (`locale`),
  CONSTRAINT `tag_translations_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tag_translations` WRITE;
/*!40000 ALTER TABLE `tag_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tag_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `product_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tags_product_id_foreign` (`product_id`),
  CONSTRAINT `tags_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `term_condition_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `term_condition_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_condition_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `locale` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `term_condition_translations_term_condition_id_locale_unique` (`term_condition_id`,`locale`),
  KEY `term_condition_translations_locale_index` (`locale`),
  CONSTRAINT `term_condition_translations_term_condition_id_foreign` FOREIGN KEY (`term_condition_id`) REFERENCES `term_conditions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `term_condition_translations` WRITE;
/*!40000 ALTER TABLE `term_condition_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `term_condition_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `term_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `term_conditions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `term_conditions` WRITE;
/*!40000 ALTER TABLE `term_conditions` DISABLE KEYS */;
/*!40000 ALTER TABLE `term_conditions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tickets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `type` varchar(255) NOT NULL DEFAULT 'question',
  `subject` varchar(191) NOT NULL,
  `content` text NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'open',
  `read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tickets_created_by_foreign` (`created_by`),
  KEY `tickets_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `tickets_uuid_index` (`uuid`),
  CONSTRAINT `tickets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tickets` WRITE;
/*!40000 ALTER TABLE `tickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `tickets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payable_type` varchar(255) NOT NULL,
  `payable_id` bigint(20) unsigned NOT NULL,
  `price` double NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `payment_sys_id` bigint(20) unsigned DEFAULT NULL,
  `payment_trx_id` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `perform_time` timestamp NULL DEFAULT NULL,
  `refund_time` timestamp NULL DEFAULT NULL,
  `status` enum('progress','paid','canceled','rejected','refund') NOT NULL DEFAULT 'progress',
  `status_description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_payable_type_payable_id_index` (`payable_type`,`payable_id`),
  KEY `transactions_payable_id_index` (`payable_id`),
  KEY `transactions_payable_type_index` (`payable_type`),
  KEY `transactions_user_id_index` (`user_id`),
  KEY `transactions_status_index` (`status`),
  CONSTRAINT `transactions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1500 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL DEFAULT 1,
  `locale` varchar(255) NOT NULL,
  `group` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `translations_group_key_locale_unique` (`group`,`key`,`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `translations` WRITE;
/*!40000 ALTER TABLE `translations` DISABLE KEYS */;
INSERT INTO `translations` VALUES (1,1,'en','web','add.storeis','Add storeis','2024-12-30 00:58:25','2024-12-30 00:58:25'),(2,1,'ru','web','add.storeis','Добавить магазины','2024-12-30 00:58:25','2024-12-30 00:58:25'),(3,1,'en','web','storeis','Storeis','2024-12-30 00:58:25','2024-12-30 00:58:25'),(4,1,'ru','web','storeis','Cклад','2024-12-30 00:58:25','2024-12-30 00:58:25'),(5,1,'en','web','add.story','Add story','2024-12-30 00:58:25','2024-12-30 00:58:25'),(6,1,'ru','web','add.story','Добавить историю','2024-12-30 00:58:25','2024-12-30 00:58:25'),(7,1,'en','web','agree_location','Do you agree to receive the default location ?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(8,1,'ru','web','agree_location','Согласны ли вы получить местоположение по умолчанию?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(9,1,'en','web','no_shop','No shop','2024-12-30 00:58:25','2024-12-30 00:58:25'),(10,1,'ru','web','no_shop','No shop','2024-12-30 00:58:25','2024-12-30 00:58:25'),(11,1,'en','web','rating_courier','Rating courier','2024-12-30 00:58:25','2024-12-30 00:58:25'),(12,1,'ru','web','rating_courier','Rating courier','2024-12-30 00:58:25','2024-12-30 00:58:25'),(13,1,'en','web','send_message','Send message','2024-12-30 00:58:25','2024-12-30 00:58:25'),(14,1,'ru','web','send_message','Отправить сообщение','2024-12-30 00:58:25','2024-12-30 00:58:25'),(15,1,'en','web','call_the_driver','Call the driver','2024-12-30 00:58:25','2024-12-30 00:58:25'),(16,1,'ru','web','call_the_driver','Позвонить водителю','2024-12-30 00:58:25','2024-12-30 00:58:25'),(17,1,'en','web','call_center_restaurant','Call Center Restaurant','2024-12-30 00:58:25','2024-12-30 00:58:25'),(18,1,'ru','web','call_center_restaurant','Колл-центр Ресторан','2024-12-30 00:58:25','2024-12-30 00:58:25'),(19,1,'en','web','promo_code','Promo code','2024-12-30 00:58:25','2024-12-30 00:58:25'),(20,1,'ru','web','promo_code','Промо-код','2024-12-30 00:58:25','2024-12-30 00:58:25'),(21,1,'en','web','add_promocode','Add Promocode','2024-12-30 00:58:25','2024-12-30 00:58:25'),(22,1,'ru','web','add_promocode','Добавить промокод','2024-12-30 00:58:25','2024-12-30 00:58:25'),(23,1,'en','web','your_card_below','Your card below','2024-12-30 00:58:25','2024-12-30 00:58:25'),(24,1,'ru','web','your_card_below','Ваша карта ниже','2024-12-30 00:58:25','2024-12-30 00:58:25'),(25,1,'en','mobile','do_you_want_to_delete_it?','Do you want to delete it?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(26,1,'ru','mobile','do_you_want_to_delete_it?','Удалить?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(27,1,'en','web','full_name','Full name','2024-12-30 00:58:25','2024-12-30 00:58:25'),(28,1,'ru','web','full_name','ФИО','2024-12-30 00:58:25','2024-12-30 00:58:25'),(29,1,'en','web','alternative_number','alternative number','2024-12-30 00:58:25','2024-12-30 00:58:25'),(30,1,'ru','web','alternative_number','альтернативный номер','2024-12-30 00:58:25','2024-12-30 00:58:25'),(31,1,'en','web','enter_OTP_code','Enter OTP code','2024-12-30 00:58:25','2024-12-30 00:58:25'),(32,1,'ru','web','enter_OTP_code','Введите OTP-код','2024-12-30 00:58:25','2024-12-30 00:58:25'),(33,1,'en','web','country','country','2024-12-30 00:58:25','2024-12-30 00:58:25'),(34,1,'ru','web','country','страна','2024-12-30 00:58:25','2024-12-30 00:58:25'),(35,1,'en','web','skip','Skip','2024-12-30 00:58:25','2024-12-30 00:58:25'),(36,1,'ru','web','skip','Пропускать','2024-12-30 00:58:25','2024-12-30 00:58:25'),(37,1,'en','web','logout','Logout','2024-12-30 00:58:25','2024-12-30 00:58:25'),(38,1,'ru','web','logout','Выйти','2024-12-30 00:58:25','2024-12-30 00:58:25'),(39,1,'en','web','apply','Apply','2024-12-30 00:58:25','2024-12-30 00:58:25'),(40,1,'ru','web','apply','Подать заявление','2024-12-30 00:58:25','2024-12-30 00:58:25'),(41,1,'en','web','delivery_time','Delivery time','2024-12-30 00:58:25','2024-12-30 00:58:25'),(42,1,'ru','web','delivery_time','Срок поставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(43,1,'en','web','select_delivery_time','Select delivery time','2024-12-30 00:58:25','2024-12-30 00:58:25'),(44,1,'ru','web','select_delivery_time','Выберите время доставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(45,1,'en','errors','ERROR_507','Can`t delete record that has products.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(46,1,'ru','errors','ERROR_507','Невозможно удалить запись с продуктами.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(47,1,'en','web','password_should_contain_minimum_8_characters','Password should contain minimum 8 characters','2024-12-30 00:58:25','2024-12-30 00:58:25'),(48,1,'ru','web','password_should_contain_minimum_8_characters','Пароль должен содержать минимум 8 символов','2024-12-30 00:58:25','2024-12-30 00:58:25'),(49,1,'en','web','still_have_questions','Still have questions?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(50,1,'ru','web','still_have_questions','Остались вопросы?','2024-12-30 00:58:25','2024-12-30 00:58:25'),(51,1,'en','web','cant_find_the_answer','Can’t find the answer you’re looking or? Please chat to our friendly team.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(52,1,'ru','web','cant_find_the_answer','Не можете найти ответ, который вы ищете или? Пожалуйста, пообщайтесь с нашей дружной командой.','2024-12-30 00:58:25','2024-12-30 00:58:25'),(53,1,'en','web','call_to_support','Call to support','2024-12-30 00:58:25','2024-12-30 00:58:25'),(54,1,'ru','web','call_to_support','Звонок в поддержку','2024-12-30 00:58:25','2024-12-30 00:58:25'),(55,1,'en','web','delivery_address','Delivery address','2024-12-30 00:58:25','2024-12-30 00:58:25'),(56,1,'ru','web','delivery_address','Адресс доставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(57,1,'en','web','time_delivery','Time delivery','2024-12-30 00:58:25','2024-12-30 00:58:25'),(58,1,'ru','web','time_delivery','Время доставки','2024-12-30 00:58:25','2024-12-30 00:58:25'),(59,1,'en','web','today','Today','2024-12-30 00:58:25','2024-12-30 00:58:25'),(60,1,'ru','web','today','Сегодня','2024-12-30 00:58:26','2024-12-30 00:58:26'),(61,1,'en','web','cash','Cash','2024-12-30 00:58:26','2024-12-30 00:58:26'),(62,1,'ru','web','cash','Наличе','2024-12-30 00:58:26','2024-12-30 00:58:26'),(63,1,'en','web','search.products','Search products','2024-12-30 00:58:26','2024-12-30 00:58:26'),(64,1,'ru','web','search.products','Поиск продуктов','2024-12-30 00:58:26','2024-12-30 00:58:26'),(65,1,'en','web','delivery.range','{{times}} min','2024-12-30 00:58:26','2024-12-30 00:58:26'),(66,1,'ru','web','delivery.range','{{times}} мин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(67,1,'en','web','number.of.foods','{{count}} foods','2024-12-30 00:58:26','2024-12-30 00:58:26'),(68,1,'ru','web','number.of.foods','{{count}} продуктов','2024-12-30 00:58:26','2024-12-30 00:58:26'),(69,1,'en','web','active_orders','Active Orders','2024-12-30 00:58:26','2024-12-30 00:58:26'),(70,1,'ru','web','active_orders','Активные заказы','2024-12-30 00:58:26','2024-12-30 00:58:26'),(71,1,'en','web','tomorrow','Tomorrow','2024-12-30 00:58:26','2024-12-30 00:58:26'),(72,1,'ru','web','tomorrow','Завтра','2024-12-30 00:58:26','2024-12-30 00:58:26'),(73,1,'en','web','other','Other','2024-12-30 00:58:26','2024-12-30 00:58:26'),(74,1,'ru','web','other','Другой','2024-12-30 00:58:26','2024-12-30 00:58:26'),(75,1,'en','web','min','min','2024-12-30 00:58:26','2024-12-30 00:58:26'),(76,1,'ru','web','min','мин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(77,1,'en','web','shop_tax','Shop tax','2024-12-30 00:58:26','2024-12-30 00:58:26'),(78,1,'ru','web','shop_tax','Налог на магазин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(79,1,'en','web','total_discount','Total discount','2024-12-30 00:58:26','2024-12-30 00:58:26'),(80,1,'ru','web','total_discount','Общая скидка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(81,1,'en','web','discount','Discount','2024-12-30 00:58:26','2024-12-30 00:58:26'),(82,1,'ru','web','discount','Скидка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(83,1,'en','web','500','Server error','2024-12-30 00:58:26','2024-12-30 00:58:26'),(84,1,'ru','web','500','Ошибка сервера','2024-12-30 00:58:26','2024-12-30 00:58:26'),(85,1,'en','web','400','Validation error','2024-12-30 00:58:26','2024-12-30 00:58:26'),(86,1,'ru','web','400','Ошибка валидации','2024-12-30 00:58:26','2024-12-30 00:58:26'),(87,1,'en','web','422','Validation error','2024-12-30 00:58:26','2024-12-30 00:58:26'),(88,1,'ru','web','422','Oшибка валидации','2024-12-30 00:58:26','2024-12-30 00:58:26'),(89,1,'en','web','not_work_today_and_tomorrow','The delivery service will not work today and tomorrow','2024-12-30 00:58:26','2024-12-30 00:58:26'),(90,1,'ru','web','not_work_today_and_tomorrow','Служба доставки не будет работать сегодня и завтра','2024-12-30 00:58:26','2024-12-30 00:58:26'),(91,1,'en','web','not_work_today','Delivery service is not available today','2024-12-30 00:58:26','2024-12-30 00:58:26'),(92,1,'ru','web','not_work_today','Служба доставки сегодня не работает','2024-12-30 00:58:26','2024-12-30 00:58:26'),(93,1,'en','web','not_work_tomorrow','Tomorrow`s delivery service will not work','2024-12-30 00:58:26','2024-12-30 00:58:26'),(94,1,'ru','web','not_work_tomorrow','Завтра служба доставки не работает','2024-12-30 00:58:26','2024-12-30 00:58:26'),(95,1,'en','web','not_work_today_time','Delivery service is not available at this time today','2024-12-30 00:58:26','2024-12-30 00:58:26'),(96,1,'ru','web','not_work_today_time','Служба доставки сегодня не работает в это время','2024-12-30 00:58:26','2024-12-30 00:58:26'),(97,1,'en','web','you_have_promo_code','You have promo code','2024-12-30 00:58:26','2024-12-30 00:58:26'),(98,1,'ru','web','you_have_promo_code','У вас есть промокод','2024-12-30 00:58:26','2024-12-30 00:58:26'),(99,1,'en','web','new','New','2024-12-30 00:58:26','2024-12-30 00:58:26'),(100,1,'ru','web','new','Новый','2024-12-30 00:58:26','2024-12-30 00:58:26'),(101,1,'en','web','accepted','Accepted','2024-12-30 00:58:26','2024-12-30 00:58:26'),(102,1,'ru','web','accepted','Принято','2024-12-30 00:58:26','2024-12-30 00:58:26'),(103,1,'en','web','driver','Driver','2024-12-30 00:58:26','2024-12-30 00:58:26'),(104,1,'ru','web','driver','Водитель','2024-12-30 00:58:26','2024-12-30 00:58:26'),(105,1,'en','web','no_driver','No driver is assigned to this order','2024-12-30 00:58:26','2024-12-30 00:58:26'),(106,1,'ru','web','no_driver','Водитель не назначен этому заказу','2024-12-30 00:58:26','2024-12-30 00:58:26'),(107,1,'en','web','shop','Shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(108,1,'ru','web','shop','Магазин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(109,1,'en','web','under','Under','2024-12-30 00:58:26','2024-12-30 00:58:26'),(110,1,'ru','web','under','Под','2024-12-30 00:58:26','2024-12-30 00:58:26'),(111,1,'en','web','show','Show','2024-12-30 00:58:26','2024-12-30 00:58:26'),(112,1,'ru','web','show','Показать','2024-12-30 00:58:26','2024-12-30 00:58:26'),(113,1,'en','web','from','From','2024-12-30 00:58:26','2024-12-30 00:58:26'),(114,1,'ru','web','from','От','2024-12-30 00:58:26','2024-12-30 00:58:26'),(115,1,'en','web','price_range','Price range','2024-12-30 00:58:26','2024-12-30 00:58:26'),(116,1,'ru','web','price_range','Ценовой диапазон','2024-12-30 00:58:26','2024-12-30 00:58:26'),(117,1,'en','web','rating','Rating','2024-12-30 00:58:26','2024-12-30 00:58:26'),(118,1,'ru','web','rating','Рейтинг','2024-12-30 00:58:26','2024-12-30 00:58:26'),(119,1,'en','web','special_offers','Special offers','2024-12-30 00:58:26','2024-12-30 00:58:26'),(120,1,'ru','web','special_offers','Специальные предложения','2024-12-30 00:58:26','2024-12-30 00:58:26'),(121,1,'en','web','sort_by','Sort by','2024-12-30 00:58:26','2024-12-30 00:58:26'),(122,1,'ru','web','sort_by','Сортировать по','2024-12-30 00:58:26','2024-12-30 00:58:26'),(123,1,'en','web','free_delivery','Free delivery','2024-12-30 00:58:26','2024-12-30 00:58:26'),(124,1,'ru','web','free_delivery','Бесплатная доставка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(125,1,'en','web','this_time_is_not_available','This time is not available','2024-12-30 00:58:26','2024-12-30 00:58:26'),(126,1,'ru','web','this_time_is_not_available','Это время недоступно','2024-12-30 00:58:26','2024-12-30 00:58:26'),(127,1,'en','errors','ERROR_109','Insufficient wallet balance.','2024-12-30 00:58:26','2024-12-30 00:58:26'),(128,1,'ru','errors','ERROR_109','Недостаточный баланс кошелька.','2024-12-30 00:58:26','2024-12-30 00:58:26'),(129,1,'en','web','product.title','Product title','2024-12-30 00:58:26','2024-12-30 00:58:26'),(130,1,'ru','web','product.title','Название продукта','2024-12-30 00:58:26','2024-12-30 00:58:26'),(131,1,'en','web','item.sold','Item sold','2024-12-30 00:58:26','2024-12-30 00:58:26'),(132,1,'ru','web','item.sold','Товар продан','2024-12-30 00:58:26','2024-12-30 00:58:26'),(133,1,'en','web','net.sales','Net sales','2024-12-30 00:58:26','2024-12-30 00:58:26'),(134,1,'ru','web','net.sales','Чистые продажи','2024-12-30 00:58:26','2024-12-30 00:58:26'),(135,1,'en','web','variations','Variations','2024-12-30 00:58:26','2024-12-30 00:58:26'),(136,1,'ru','web','variations','Вариации','2024-12-30 00:58:26','2024-12-30 00:58:26'),(137,1,'en','web','report.products','Report products','2024-12-30 00:58:26','2024-12-30 00:58:26'),(138,1,'ru','web','report.products','Сообщить о продуктах','2024-12-30 00:58:26','2024-12-30 00:58:26'),(139,1,'en','web','report.orders','Report orders','2024-12-30 00:58:26','2024-12-30 00:58:26'),(140,1,'ru','web','report.orders','Сообщить о заказах','2024-12-30 00:58:26','2024-12-30 00:58:26'),(141,1,'en','web','report.stock','Report stock','2024-12-30 00:58:26','2024-12-30 00:58:26'),(142,1,'ru','web','report.stock','Сообщить о наличии','2024-12-30 00:58:26','2024-12-30 00:58:26'),(143,1,'en','web','report.categories','Report categories','2024-12-30 00:58:26','2024-12-30 00:58:26'),(144,1,'ru','web','report.categories','Категории отчетов','2024-12-30 00:58:26','2024-12-30 00:58:26'),(145,1,'en','web','report.overview','Report overview','2024-12-30 00:58:26','2024-12-30 00:58:26'),(146,1,'ru','web','report.overview','Обзор отчета','2024-12-30 00:58:26','2024-12-30 00:58:26'),(147,1,'en','web','report.revenue','Report revenue','2024-12-30 00:58:26','2024-12-30 00:58:26'),(148,1,'ru','web','report.revenue','Сообщить о доходах','2024-12-30 00:58:26','2024-12-30 00:58:26'),(149,1,'en','web','report.variation','Report variation','2024-12-30 00:58:26','2024-12-30 00:58:26'),(150,1,'ru','web','report.variation','Вариант отчета','2024-12-30 00:58:26','2024-12-30 00:58:26'),(151,1,'en','web','refound','Refund','2024-12-30 00:58:26','2024-12-30 00:58:26'),(152,1,'ru','web','refound','Возвращать деньги','2024-12-30 00:58:26','2024-12-30 00:58:26'),(153,1,'en','web','loading','Loading','2024-12-30 00:58:26','2024-12-30 00:58:26'),(154,1,'ru','web','loading','Загрузка','2024-12-30 00:58:26','2024-12-30 00:58:26'),(155,1,'en','errors','ERROR_206','User already has Shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(156,1,'ru','errors','ERROR_206','User already has Shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(157,1,'en','web','ERROR_506','Already exists','2024-12-30 00:58:26','2024-12-30 00:58:26'),(158,1,'ru','web','ERROR_506','Уже существует','2024-12-30 00:58:26','2024-12-30 00:58:26'),(159,1,'en','web','button.text','Button text','2024-12-30 00:58:26','2024-12-30 00:58:26'),(160,1,'ru','web','button.text','Текст кнопки','2024-12-30 00:58:26','2024-12-30 00:58:26'),(161,1,'en','web','clickable','Clickable','2024-12-30 00:58:26','2024-12-30 00:58:26'),(162,1,'ru','web','clickable','Кликабельно','2024-12-30 00:58:26','2024-12-30 00:58:26'),(163,1,'en','web','no_payment_type','No payment type','2024-12-30 00:58:26','2024-12-30 00:58:26'),(164,1,'ru','web','no_payment_type','Нет типа оплаты','2024-12-30 00:58:26','2024-12-30 00:58:26'),(165,1,'en','web','you_cant_create_order','You can`t create an order because there is no payment type','2024-12-30 00:58:26','2024-12-30 00:58:26'),(166,1,'ru','web','you_cant_create_order','Вы не можете создать заказ, потому что нет типа оплаты','2024-12-30 00:58:26','2024-12-30 00:58:26'),(167,1,'en','web','payment_type_is_not_added','Payment type is not added in this restaurant or shop','2024-12-30 00:58:26','2024-12-30 00:58:26'),(168,1,'ru','web','payment_type_is_not_added','Тип оплаты не добавлен в этот ресторан или магазин','2024-12-30 00:58:26','2024-12-30 00:58:26'),(169,1,'en','web','gift_buy','is a gift if you buy under','2024-12-30 00:58:26','2024-12-30 00:58:26'),(170,1,'ru','web','gift_buy','это подарок, если вы покупаете под','2024-12-30 00:58:26','2024-12-30 00:58:26'),(171,1,'en','web','count','Count','2024-12-30 00:58:26','2024-12-30 00:58:26'),(172,1,'ru','web','count','Считать','2024-12-30 00:58:26','2024-12-30 00:58:26'),(173,1,'en','web','want_it','I want it','2024-12-30 00:58:26','2024-12-30 00:58:26'),(174,1,'ru','web','want_it','Я хочу это','2024-12-30 00:58:26','2024-12-30 00:58:26'),(175,1,'en','web','select.all','Select all','2024-12-30 00:58:26','2024-12-30 00:58:26'),(176,1,'ru','web','select.all','Select all','2024-12-30 00:58:26','2024-12-30 00:58:26'),(177,1,'en','web','why_do_you_want','Why do you want to refund?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(178,1,'ru','web','why_do_you_want','Почему вы хотите вернуть деньги?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(179,1,'en','web','successfully','Successfully','2024-12-30 00:58:26','2024-12-30 00:58:26'),(180,1,'ru','web','successfully','Успешно','2024-12-30 00:58:26','2024-12-30 00:58:26'),(181,1,'en','web','cause','Cause','2024-12-30 00:58:26','2024-12-30 00:58:26'),(182,1,'ru','web','cause','Причина','2024-12-30 00:58:26','2024-12-30 00:58:26'),(183,1,'en','web','empty.description','Data Not Found','2024-12-30 00:58:26','2024-12-30 00:58:26'),(184,1,'ru','web','empty.description','Данные не найдены','2024-12-30 00:58:26','2024-12-30 00:58:26'),(185,1,'en','web','answer','Answer','2024-12-30 00:58:26','2024-12-30 00:58:26'),(186,1,'ru','web','answer','Отвечать','2024-12-30 00:58:26','2024-12-30 00:58:26'),(187,1,'en','web','are_you_sure','Are you sure ?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(188,1,'ru','web','are_you_sure','Уверены ли вы ?','2024-12-30 00:58:26','2024-12-30 00:58:26'),(189,1,'en','web','delete_account','Delete account','2024-12-30 00:58:26','2024-12-30 00:58:26'),(190,1,'ru','web','delete_account','Удалить аккаунт','2024-12-30 00:58:26','2024-12-30 00:58:26'),(191,1,'en','web','schedulet.at','Schedulet at','2024-12-30 00:58:26','2024-12-30 00:58:26'),(192,1,'ru','web','schedulet.at','Расписание в','2024-12-30 00:58:26','2024-12-30 00:58:26'),(193,1,'en','web','order.type','Order type','2024-12-30 00:58:26','2024-12-30 00:58:26'),(194,1,'ru','web','order.type','Тип заказа','2024-12-30 00:58:26','2024-12-30 00:58:26'),(195,1,'en','web','download.pdf','Download pdf','2024-12-30 00:58:26','2024-12-30 00:58:26'),(196,1,'ru','web','download.pdf','Download pdf','2024-12-30 00:58:26','2024-12-30 00:58:26'),(197,1,'en','web','download.check','Download check','2024-12-30 00:58:26','2024-12-30 00:58:26'),(198,1,'ru','web','download.check','Download check','2024-12-30 00:58:27','2024-12-30 00:58:27'),(199,1,'en','web','BILL.TO','BILL TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(200,1,'ru','web','BILL.TO','BILL.TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(201,1,'en','web','all.rights.reserved','All rights reserved.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(202,1,'ru','web','all.rights.reserved','All rights reserved.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(203,1,'en','web','shop/restaurant','Shop/Restaurant','2024-12-30 00:58:27','2024-12-30 00:58:27'),(204,1,'ru','web','shop/restaurant','Shop/Restaurant','2024-12-30 00:58:27','2024-12-30 00:58:27'),(205,1,'en','web','data.between','DATE BETWEEN','2024-12-30 00:58:27','2024-12-30 00:58:27'),(206,1,'ru','web','data.between','DATE BETWEEN','2024-12-30 00:58:27','2024-12-30 00:58:27'),(207,1,'en','web','to','TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(208,1,'ru','web','to','TO','2024-12-30 00:58:27','2024-12-30 00:58:27'),(209,1,'en','web','data.start','Data start','2024-12-30 00:58:27','2024-12-30 00:58:27'),(210,1,'ru','web','data.start','Data start','2024-12-30 00:58:27','2024-12-30 00:58:27'),(211,1,'en','web','data.end','Data end','2024-12-30 00:58:27','2024-12-30 00:58:27'),(212,1,'ru','web','data.end','Data end','2024-12-30 00:58:27','2024-12-30 00:58:27'),(213,1,'en','web','Your.existing.vacations','Your existing vacations','2024-12-30 00:58:27','2024-12-30 00:58:27'),(214,1,'ru','web','Your.existing.vacations','Your existing vacations','2024-12-30 00:58:27','2024-12-30 00:58:27'),(215,1,'en','web','trust_you','Trust you','2024-12-30 00:58:27','2024-12-30 00:58:27'),(216,1,'ru','web','trust_you','Доверять тебе','2024-12-30 00:58:27','2024-12-30 00:58:27'),(217,1,'en','web','best_sale','Best sale','2024-12-30 00:58:27','2024-12-30 00:58:27'),(218,1,'ru','web','best_sale','Лучшая продажа','2024-12-30 00:58:27','2024-12-30 00:58:27'),(219,1,'en','web','highly_rated','Highly rated','2024-12-30 00:58:27','2024-12-30 00:58:27'),(220,1,'ru','web','highly_rated','Высокий рейтинг','2024-12-30 00:58:27','2024-12-30 00:58:27'),(221,1,'en','web','low_sale','Low sale','2024-12-30 00:58:27','2024-12-30 00:58:27'),(222,1,'ru','web','low_sale','Низкая распродажа','2024-12-30 00:58:27','2024-12-30 00:58:27'),(223,1,'en','web','low_rating','Low rating','2024-12-30 00:58:27','2024-12-30 00:58:27'),(224,1,'ru','web','low_rating','Низкий рейтинг','2024-12-30 00:58:27','2024-12-30 00:58:27'),(225,1,'en','web','please.days','Please pick one or more days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(226,1,'ru','web','please.days','Please pick one or more days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(227,1,'en','web','notification','Notification','2024-12-30 00:58:27','2024-12-30 00:58:27'),(228,1,'ru','web','notification','Уведомление','2024-12-30 00:58:27','2024-12-30 00:58:27'),(229,1,'en','web','closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(230,1,'ru','web','closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates  here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(231,1,'en','web','Shop.closed.days','Shop closed.days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(232,1,'ru','web','Shop.closed.days','Shop closed.days','2024-12-30 00:58:27','2024-12-30 00:58:27'),(233,1,'en','web','accepted.orders.count','Accepted orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(234,1,'ru','web','accepted.orders.count','Accepted orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(235,1,'en','web','cancel.orders.count','Cancel orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(236,1,'ru','web','cancel.orders.count','Cancel orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(237,1,'en','web','delivered.orders.count','Delivered orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(238,1,'ru','web','delivered.orders.count','Delivered orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(239,1,'en','web','new.orders.count','New orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(240,1,'ru','web','new.orders.count','New orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(241,1,'en','web','on_a_way_orders_count','On a way orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(242,1,'ru','web','on_a_way_orders_count','On a way orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(243,1,'en','web','progress_orders_count','Progress orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(244,1,'ru','web','progress_orders_count','Progress orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(245,1,'en','web','ready_orders_count','Ready orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(246,1,'ru','web','ready_orders_count','Ready orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(247,1,'en','web','orders.count','Orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(248,1,'ru','web','orders.count','Orders count','2024-12-30 00:58:27','2024-12-30 00:58:27'),(249,1,'en','web','type_here','Type here','2024-12-30 00:58:27','2024-12-30 00:58:27'),(250,1,'ru','web','type_here','Введите сюда','2024-12-30 00:58:27','2024-12-30 00:58:27'),(251,1,'en','web','deliveries','Deliveries','2024-12-30 00:58:27','2024-12-30 00:58:27'),(252,1,'ru','web','deliveries','Deliveries','2024-12-30 00:58:27','2024-12-30 00:58:27'),(253,1,'en','web','total.orders','Total orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(254,1,'ru','web','total.orders','Total orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(255,1,'en','web','total.earning','Total earning','2024-12-30 00:58:27','2024-12-30 00:58:27'),(256,1,'ru','web','total.earning','Total earning','2024-12-30 00:58:27','2024-12-30 00:58:27'),(257,1,'en','web','payment_method_failed','Payment method failed','2024-12-30 00:58:27','2024-12-30 00:58:27'),(258,1,'ru','web','payment_method_failed','Способ оплаты не выполнен','2024-12-30 00:58:27','2024-12-30 00:58:27'),(259,1,'en','web','repeat_order','Repeat order','2024-12-30 00:58:27','2024-12-30 00:58:27'),(260,1,'ru','web','repeat_order','Повторите заказ','2024-12-30 00:58:27','2024-12-30 00:58:27'),(261,1,'en','web','delivery.zone.text','Click this icon to start pin points in the map and connect them to draw a zone . Minimum 3 points required','2024-12-30 00:58:27','2024-12-30 00:58:27'),(262,1,'ru','web','delivery.zone.text','Click this icon to start pin points in the map and connect them to draw a zone . Minimum 3 points required','2024-12-30 00:58:27','2024-12-30 00:58:27'),(263,1,'en','web','place.selected.map','Please draw the delivery zone first','2024-12-30 00:58:27','2024-12-30 00:58:27'),(264,1,'ru','web','place.selected.map','Please draw the delivery zone first','2024-12-30 00:58:27','2024-12-30 00:58:27'),(265,1,'en','web','products','Products','2024-12-30 00:58:27','2024-12-30 00:58:27'),(266,1,'ru','web','products','Продукты','2024-12-30 00:58:27','2024-12-30 00:58:27'),(267,1,'en','web','add_address_information','Add address information','2024-12-30 00:58:27','2024-12-30 00:58:27'),(268,1,'ru','web','add_address_information','Добавить адресную информацию','2024-12-30 00:58:27','2024-12-30 00:58:27'),(269,1,'en','web','info','Info','2024-12-30 00:58:27','2024-12-30 00:58:27'),(270,1,'ru','web','info','Info','2024-12-30 00:58:27','2024-12-30 00:58:27'),(271,1,'en','web','import.text_1','Download the skeleton file and fill it with proper data.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(272,1,'ru','web','import.text_1','Download the skeleton file and fill it with proper data.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(273,1,'en','web','import.text_2','You can download the example file to understand how the data must be filled.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(274,1,'ru','web','import.text_2','You can download the example file to understand how the data must be filled.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(275,1,'en','web','import.text_3','Once you have downloaded and filled the skeleton file, upload it in the form below and submit.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(276,1,'ru','web','import.text_3','Once you have downloaded and filled the skeleton file, upload it in the form below and submit.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(277,1,'en','web','import.text_4','After uploading products you need to edit them and set product`s images and choices.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(278,1,'ru','web','import.text_4','After uploading products you need to edit them and set product`s images and choices.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(279,1,'en','web','restaurant.closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(280,1,'ru','web','restaurant.closed.days.text','If you can`t answer the buyer`s questions in time and want to                   share this information with your buyers, you can add the dates here.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(281,1,'en','web','add.user','Add user','2024-12-30 00:58:27','2024-12-30 00:58:27'),(282,1,'ru','web','add.user','Add user','2024-12-30 00:58:27','2024-12-30 00:58:27'),(283,1,'en','web','is.not.valid.file','is not valid file','2024-12-30 00:58:27','2024-12-30 00:58:27'),(284,1,'ru','web','is.not.valid.file','is not valid file','2024-12-30 00:58:27','2024-12-30 00:58:27'),(285,1,'en','web','upload-drag','Click or drag file to this area to upload','2024-12-30 00:58:27','2024-12-30 00:58:27'),(286,1,'ru','web','upload-drag','Click or drag file to this area to upload','2024-12-30 00:58:27','2024-12-30 00:58:27'),(287,1,'en','web','upload-text','Using this file, it is possible to create a database of new products. You need to click the button above to update','2024-12-30 00:58:27','2024-12-30 00:58:27'),(288,1,'ru','web','upload-text','Using this file, it is possible to create a database of new products. You need to click the button above to update','2024-12-30 00:58:27','2024-12-30 00:58:27'),(289,1,'en','web','you_fully_manage','You fully manage the order and confirm the address. Team members can add a product from a location of your choice.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(290,1,'ru','web','you_fully_manage','Вы полностью управляете заказом и подтверждаете адрес. Члены команды могут добавить продукт из любого места по вашему выбору.','2024-12-30 00:58:27','2024-12-30 00:58:27'),(291,1,'en','web','he_is_choosing','He is choosing','2024-12-30 00:58:27','2024-12-30 00:58:27'),(292,1,'ru','web','he_is_choosing','он выбирает','2024-12-30 00:58:27','2024-12-30 00:58:27'),(293,1,'en','web','done','Done','2024-12-30 00:58:27','2024-12-30 00:58:27'),(294,1,'ru','web','done','Сделанный','2024-12-30 00:58:27','2024-12-30 00:58:27'),(295,1,'en','web','delete_user','Delete user','2024-12-30 00:58:27','2024-12-30 00:58:27'),(296,1,'ru','web','delete_user','Удалить пользователя','2024-12-30 00:58:27','2024-12-30 00:58:27'),(297,1,'en','web','group_order_progress','In the group order, the users order is in progress, can you continue even then?','2024-12-30 00:58:27','2024-12-30 00:58:27'),(298,1,'ru','web','group_order_progress','Обработка оптового заказа пользователя, продолжить?','2024-12-30 00:58:27','2024-12-30 00:58:27'),(299,1,'en','web','owner','Owner','2024-12-30 00:58:27','2024-12-30 00:58:27'),(300,1,'ru','web','owner','Владелец','2024-12-30 00:58:27','2024-12-30 00:58:27'),(301,1,'en','web','car.model','Car model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(302,1,'ru','web','car.model','Car model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(303,1,'en','web','online.time','Online.time','2024-12-30 00:58:27','2024-12-30 00:58:27'),(304,1,'ru','web','online.time','Online time','2024-12-30 00:58:27','2024-12-30 00:58:27'),(305,1,'en','web','add.delivery.setting','Create delivery setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(306,1,'ru','web','add.delivery.setting','Create delivery setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(307,1,'en','web','type.of.technique','Type of technique','2024-12-30 00:58:27','2024-12-30 00:58:27'),(308,1,'ru','web','type.of.technique','Type of technique','2024-12-30 00:58:27','2024-12-30 00:58:27'),(309,1,'en','web','car.number','Car number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(310,1,'ru','web','car.number','Car number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(311,1,'en','web','car.color','Car color','2024-12-30 00:58:27','2024-12-30 00:58:27'),(312,1,'ru','web','car.color','Car color','2024-12-30 00:58:27','2024-12-30 00:58:27'),(313,1,'en','web','deliveryman.attached','Deliveryman attached','2024-12-30 00:58:27','2024-12-30 00:58:27'),(314,1,'ru','web','deliveryman.attached','Deliveryman attached','2024-12-30 00:58:27','2024-12-30 00:58:27'),(315,1,'en','web','Go.to.installation','Go to installation','2024-12-30 00:58:27','2024-12-30 00:58:27'),(316,1,'ru','web','Go.to.installation','Go to installation','2024-12-30 00:58:27','2024-12-30 00:58:27'),(317,1,'en','web','isset-deliveryman','11','2024-12-30 00:58:27','2024-12-30 00:58:27'),(318,1,'ru','web','isset-deliveryman','1','2024-12-30 00:58:27','2024-12-30 00:58:27'),(319,1,'ru','mobile2','successfully_updated12','Successfully updated12','2024-12-30 00:58:27','2024-12-30 00:58:27'),(320,1,'en','mobile2','successfully_updated12','Успешо обновлен123','2024-12-30 00:58:27','2024-12-30 00:58:27'),(321,1,'en','web','delivery.man.setting','Deliveryman setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(322,1,'ru','web','delivery.man.setting','Deliveryman setting','2024-12-30 00:58:27','2024-12-30 00:58:27'),(323,1,'en','web','add.settings','Add settings','2024-12-30 00:58:27','2024-12-30 00:58:27'),(324,1,'ru','web','add.settings','Add settings','2024-12-30 00:58:27','2024-12-30 00:58:27'),(325,1,'en','web','number','Number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(326,1,'ru','web','number','Number','2024-12-30 00:58:27','2024-12-30 00:58:27'),(327,1,'en','web','model','Model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(328,1,'ru','web','model','Model','2024-12-30 00:58:27','2024-12-30 00:58:27'),(329,1,'en','web','ingredients','Ingredients','2024-12-30 00:58:27','2024-12-30 00:58:27'),(330,1,'ru','web','ingredients','Ингредиенты','2024-12-30 00:58:27','2024-12-30 00:58:27'),(331,1,'en','web','canceled.orders','Canceled orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(332,1,'ru','web','canceled.orders','Canceled orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(333,1,'en','web','completed.orders','Completed orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(334,1,'ru','web','completed.orders','Completed orders','2024-12-30 00:58:27','2024-12-30 00:58:27'),(335,1,'en','web','benzine','Benzine','2024-12-30 00:58:27','2024-12-30 00:58:27'),(336,1,'ru','web','benzine','Бензин','2024-12-30 00:58:28','2024-12-30 00:58:28'),(337,1,'en','web','diesel','Diesel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(338,1,'ru','web','diesel','Дизель','2024-12-30 00:58:28','2024-12-30 00:58:28'),(339,1,'en','web','gas','Gas','2024-12-30 00:58:28','2024-12-30 00:58:28'),(340,1,'ru','web','gas','Газ','2024-12-30 00:58:28','2024-12-30 00:58:28'),(341,1,'en','web','motorbike','Motorbike','2024-12-30 00:58:28','2024-12-30 00:58:28'),(342,1,'ru','web','motorbike','мотоцикл','2024-12-30 00:58:28','2024-12-30 00:58:28'),(343,1,'en','web','bike','Bike','2024-12-30 00:58:28','2024-12-30 00:58:28'),(344,1,'ru','web','bike','Велосипед','2024-12-30 00:58:28','2024-12-30 00:58:28'),(345,1,'en','web','foot','Foot','2024-12-30 00:58:28','2024-12-30 00:58:28'),(346,1,'ru','web','foot','Нога','2024-12-30 00:58:28','2024-12-30 00:58:28'),(347,1,'en','web','available_orders','Available orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(348,1,'ru','web','available_orders','Доступные заказы','2024-12-30 00:58:28','2024-12-30 00:58:28'),(349,1,'en','web','show.orders','Show orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(350,1,'ru','web','show.orders','Show orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(351,1,'en','web','deliveryman.orders','Deliveryman orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(352,1,'ru','web','deliveryman.orders','Deliveryman orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(353,1,'ru','web','ready.orders.count','Ready orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(354,1,'en','web','ready.orders.count','Ready orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(355,1,'ru','web','progress.orders.count','progress orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(356,1,'en','web','progress.orders.count','progress orders count','2024-12-30 00:58:28','2024-12-30 00:58:28'),(357,1,'ru','web','payment_date','Payment Date','2024-12-30 00:58:28','2024-12-30 00:58:28'),(358,1,'en','web','payment_date','Дата платежа','2024-12-30 00:58:28','2024-12-30 00:58:28'),(359,1,'ru','web','sender','Отправитель','2024-12-30 00:58:28','2024-12-30 00:58:28'),(360,1,'en','web','sender','Sender','2024-12-30 00:58:28','2024-12-30 00:58:28'),(361,1,'ru','web','deposit_withdrawl','Депозит/Вывод средств','2024-12-30 00:58:28','2024-12-30 00:58:28'),(362,1,'en','web','deposit_withdrawl','Deposit/Withdrawl','2024-12-30 00:58:28','2024-12-30 00:58:28'),(363,1,'ru','web','there_are','There are','2024-12-30 00:58:28','2024-12-30 00:58:28'),(364,1,'en','web','there_are','Есть','2024-12-30 00:58:28','2024-12-30 00:58:28'),(365,1,'ru','web','note_about_the_client','Примечание о клиенте','2024-12-30 00:58:28','2024-12-30 00:58:28'),(366,1,'en','web','note_about_the_client','A note about the client','2024-12-30 00:58:28','2024-12-30 00:58:28'),(367,1,'ru','web','rate_the_customer','Оценить клиента','2024-12-30 00:58:28','2024-12-30 00:58:28'),(368,1,'en','web','rate_the_customer','Rate the customer','2024-12-30 00:58:28','2024-12-30 00:58:28'),(369,1,'ru','web','your_feedback_will_help_us_improve_our_delivery_service','Ваш отзыв поможет нам улучшить нашу службу доставки','2024-12-30 00:58:28','2024-12-30 00:58:28'),(370,1,'en','web','your_feedback_will_help_us_improve_our_delivery_service','Your feedback will help us improve our delivery service','2024-12-30 00:58:28','2024-12-30 00:58:28'),(371,1,'ru','web','evaluation','Оценка','2024-12-30 00:58:28','2024-12-30 00:58:28'),(372,1,'en','web','evaluation','Evaluation','2024-12-30 00:58:28','2024-12-30 00:58:28'),(373,1,'ru','web','delivered_the_order','Я доставил заказ','2024-12-30 00:58:28','2024-12-30 00:58:28'),(374,1,'en','web','delivered_the_order','I delivered the order','2024-12-30 00:58:28','2024-12-30 00:58:28'),(375,1,'ru','web','approve','Утвердить','2024-12-30 00:58:28','2024-12-30 00:58:28'),(376,1,'en','web','approve','Approve','2024-12-30 00:58:28','2024-12-30 00:58:28'),(377,1,'ru','web','the_order_do_you_confirm?','заказ вы подтверждаете?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(378,1,'en','web','the_order_do_you_confirm?','the order do you confirm?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(379,1,'ru','web','that_you_have_indeed','Что у вас действительно','2024-12-30 00:58:28','2024-12-30 00:58:28'),(380,1,'en','web','that_you_have_indeed','That you have indeed','2024-12-30 00:58:28','2024-12-30 00:58:28'),(381,1,'ru','web','received','Полученный','2024-12-30 00:58:28','2024-12-30 00:58:28'),(382,1,'en','web','received','Received','2024-12-30 00:58:28','2024-12-30 00:58:28'),(383,1,'ru','web','order_information','Запросить информацию','2024-12-30 00:58:28','2024-12-30 00:58:28'),(384,1,'en','web','order_information','Order information','2024-12-30 00:58:28','2024-12-30 00:58:28'),(385,1,'ru','web','accept','Принимать','2024-12-30 00:58:28','2024-12-30 00:58:28'),(386,1,'en','web','accept','Accept','2024-12-30 00:58:28','2024-12-30 00:58:28'),(387,1,'ru','web','car_picture','Картинка автомобиля','2024-12-30 00:58:28','2024-12-30 00:58:28'),(388,1,'en','web','car_picture','Car picture','2024-12-30 00:58:28','2024-12-30 00:58:28'),(389,1,'ru','web','color','Цвет','2024-12-30 00:58:28','2024-12-30 00:58:28'),(390,1,'en','web','color','Color','2024-12-30 00:58:28','2024-12-30 00:58:28'),(391,1,'ru','web','state_number','Государственный номер','2024-12-30 00:58:28','2024-12-30 00:58:28'),(392,1,'en','web','state_number','State number','2024-12-30 00:58:28','2024-12-30 00:58:28'),(393,1,'ru','web','car_models','Автомобильные модели','2024-12-30 00:58:28','2024-12-30 00:58:28'),(394,1,'en','web','car_models','Car models','2024-12-30 00:58:28','2024-12-30 00:58:28'),(395,1,'ru','web','car_brand','Марка машины','2024-12-30 00:58:28','2024-12-30 00:58:28'),(396,1,'en','web','car_brand','Car brand','2024-12-30 00:58:28','2024-12-30 00:58:28'),(397,1,'ru','web','type_of_technique','Тип техники','2024-12-30 00:58:28','2024-12-30 00:58:28'),(398,1,'en','web','type_of_technique','Type of technique','2024-12-30 00:58:28','2024-12-30 00:58:28'),(399,1,'ru','web','delivery_vehicle','Транспортное средство доставки','2024-12-30 00:58:28','2024-12-30 00:58:28'),(400,1,'en','web','delivery_vehicle','Delivery vehicle','2024-12-30 00:58:28','2024-12-30 00:58:28'),(401,1,'ru','web','your_name','Твое имя','2024-12-30 00:58:28','2024-12-30 00:58:28'),(402,1,'en','web','your_name','Your name','2024-12-30 00:58:28','2024-12-30 00:58:28'),(403,1,'ru','web','apart','Кроме.','2024-12-30 00:58:28','2024-12-30 00:58:28'),(404,1,'en','web','apart','Apart.','2024-12-30 00:58:28','2024-12-30 00:58:28'),(405,1,'ru','web','entr','Вход','2024-12-30 00:58:28','2024-12-30 00:58:28'),(406,1,'en','web','entr','Entr.','2024-12-30 00:58:28','2024-12-30 00:58:28'),(407,1,'ru','web','home','Дом','2024-12-30 00:58:28','2024-12-30 00:58:28'),(408,1,'en','web','home','Home','2024-12-30 00:58:28','2024-12-30 00:58:28'),(409,1,'ru','web','restauran_home','Ресторан — Главная','2024-12-30 00:58:28','2024-12-30 00:58:28'),(410,1,'en','web','restauran_home','Restaurant — Home','2024-12-30 00:58:28','2024-12-30 00:58:28'),(411,1,'ru','web','login_credentials_are_not_valid','Учетные данные для входа недействительны','2024-12-30 00:58:28','2024-12-30 00:58:28'),(412,1,'en','web','login_credentials_are_not_valid','Login credentials are not valid','2024-12-30 00:58:28','2024-12-30 00:58:28'),(413,1,'ru','web','user.password.change','User password change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(414,1,'en','web','user.password.change','User password change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(415,1,'ru','web','active.time','Active time','2024-12-30 00:58:28','2024-12-30 00:58:28'),(416,1,'en','web','active.time','Active time','2024-12-30 00:58:28','2024-12-30 00:58:28'),(417,1,'ru','web','filter','Фильтр','2024-12-30 00:58:28','2024-12-30 00:58:28'),(418,1,'en','web','filter','Filter','2024-12-30 00:58:28','2024-12-30 00:58:28'),(419,1,'ru','web','top.rating','Top rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(420,1,'en','web','top.rating','Top rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(421,1,'ru','web','lowest.rating','Lowest rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(422,1,'en','web','lowest.rating','Lowest rating','2024-12-30 00:58:28','2024-12-30 00:58:28'),(423,1,'ru','web','top.orders','Top orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(424,1,'en','web','top.orders','Top orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(425,1,'ru','web','lowest.orders','Lowest orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(426,1,'en','web','lowest.orders','Lowest orders','2024-12-30 00:58:28','2024-12-30 00:58:28'),(427,1,'ru','web','top.earner','Top earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(428,1,'en','web','top.earner','Top earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(429,1,'ru','web','lowest.earner','Lowest earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(430,1,'en','web','lowest.earner','Lowest earner','2024-12-30 00:58:28','2024-12-30 00:58:28'),(431,1,'ru','web','default','Default','2024-12-30 00:58:28','2024-12-30 00:58:28'),(432,1,'en','web','default','Default','2024-12-30 00:58:28','2024-12-30 00:58:28'),(433,1,'ru','web','delivery_time_type','Тип времени доставки','2024-12-30 00:58:28','2024-12-30 00:58:28'),(434,1,'en','web','delivery_time_type','Delivery time type','2024-12-30 00:58:28','2024-12-30 00:58:28'),(435,1,'ru','web','delivery_time_from','Срок доставки от','2024-12-30 00:58:28','2024-12-30 00:58:28'),(436,1,'en','web','delivery_time_from','Delivery time from','2024-12-30 00:58:28','2024-12-30 00:58:28'),(437,1,'ru','web','delivery_time_to','Срок доставки до','2024-12-30 00:58:28','2024-12-30 00:58:28'),(438,1,'en','web','delivery_time_to','Delivery time to','2024-12-30 00:58:28','2024-12-30 00:58:28'),(439,1,'ru','web','start_price','Стартовая цена','2024-12-30 00:58:28','2024-12-30 00:58:28'),(440,1,'en','web','start_price','Start price','2024-12-30 00:58:28','2024-12-30 00:58:28'),(441,1,'ru','web','price_per_km','Цена за км','2024-12-30 00:58:28','2024-12-30 00:58:28'),(442,1,'en','web','price_per_km','Price per km','2024-12-30 00:58:28','2024-12-30 00:58:28'),(443,1,'ru','web','address','Адрес','2024-12-30 00:58:28','2024-12-30 00:58:28'),(444,1,'en','web','address','Address','2024-12-30 00:58:28','2024-12-30 00:58:28'),(445,1,'ar','web','restore.all','Restore all','2024-12-30 00:58:28','2024-12-30 00:58:28'),(446,1,'ru','web','restore.all','Restore all','2024-12-30 00:58:28','2024-12-30 00:58:28'),(447,1,'en','web','restore.all','Restore all','2024-12-30 00:58:28','2024-12-30 00:58:28'),(448,1,'ar','web','restore.modal.text','Are you sure you want to restore deleted products?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(449,1,'ru','web','restore.modal.text','Are you sure you want to restore deleted products?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(450,1,'en','web','restore.modal.text','Are you sure you want to restore deleted products?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(451,1,'el','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(452,1,'ar','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(453,1,'ru','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(454,1,'en','web','confirm.deletion','All products will be deleted, their corresponding barcode and pictures will also be deleted. Confirm deletion?','2024-12-30 00:58:28','2024-12-30 00:58:28'),(455,1,'el','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(456,1,'ar','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(457,1,'ru','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(458,1,'en','web','read.carefully','Read carefully','2024-12-30 00:58:28','2024-12-30 00:58:28'),(459,1,'el','web','your_request_is_being_processed','Ваш запрос обрабатывается','2024-12-30 00:58:28','2024-12-30 00:58:28'),(460,1,'ar','web','your_request_is_being_processed','Ваш запрос обрабатывается','2024-12-30 00:58:28','2024-12-30 00:58:28'),(461,1,'ru','web','your_request_is_being_processed','Ваш запрос обрабатывается','2024-12-30 00:58:28','2024-12-30 00:58:28'),(462,1,'en','web','your_request_is_being_processed','Your request is being processed','2024-12-30 00:58:28','2024-12-30 00:58:28'),(463,1,'el','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(464,1,'ar','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(465,1,'ru','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(466,1,'en','web','go_to_admin_panel','go to admin panel','2024-12-30 00:58:28','2024-12-30 00:58:28'),(467,1,'uzbek','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(468,1,'el','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(469,1,'ar','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(470,1,'ru','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(471,1,'en','web','addition','Addition','2024-12-30 00:58:28','2024-12-30 00:58:28'),(472,1,'uzbek','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(473,1,'el','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(474,1,'ar','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(475,1,'ru','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(476,1,'en','web','short.code','Short code','2024-12-30 00:58:28','2024-12-30 00:58:28'),(477,1,'el','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(478,1,'ar','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(479,1,'ru','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(480,1,'en','web','change','Change','2024-12-30 00:58:28','2024-12-30 00:58:28'),(481,1,'el','web','delivery.information','Delivery Information','2024-12-30 00:58:28','2024-12-30 00:58:28'),(482,1,'ar','web','delivery.information','Delivery Information','2024-12-30 00:58:28','2024-12-30 00:58:28'),(483,1,'ru','web','delivery.information','Delivery Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(484,1,'en','web','delivery.information','Delivery Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(485,1,'el','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(486,1,'ar','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(487,1,'ru','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(488,1,'en','web','office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(489,1,'el','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(490,1,'ar','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(491,1,'ru','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(492,1,'en','web','store.information','Shop/Restaurant Information','2024-12-30 00:58:29','2024-12-30 00:58:29'),(493,1,'el','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(494,1,'ar','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(495,1,'ru','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(496,1,'en','web','location','Location','2024-12-30 00:58:29','2024-12-30 00:58:29'),(497,1,'el','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(498,1,'ar','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(499,1,'ru','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(500,1,'en','web','permission','Permission','2024-12-30 00:58:29','2024-12-30 00:58:29'),(501,1,'el','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(502,1,'ar','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(503,1,'ru','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(504,1,'en','web','lorem100','“Lorem ipsum” dummy text is used by many web-developers to test how their HTML templates will look with real data. Often, developers use third-party services to generate “Lorem ipsum” text, but now you can do that right in your editor. Just expand lorem or lipsum abbreviations to get the following snippet:','2024-12-30 00:58:29','2024-12-30 00:58:29'),(505,1,'el','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(506,1,'ar','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(507,1,'ru','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(508,1,'en','web','system.refund','System Refund','2024-12-30 00:58:29','2024-12-30 00:58:29'),(509,1,'el','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(510,1,'ar','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(511,1,'ru','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(512,1,'en','web','order.auto.approved','Order auto approved','2024-12-30 00:58:29','2024-12-30 00:58:29'),(513,1,'el','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(514,1,'ar','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(515,1,'ru','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(516,1,'en','web','order.auto.deliveryman','Order auto deliveryman','2024-12-30 00:58:29','2024-12-30 00:58:29'),(517,1,'el','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(518,1,'ar','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(519,1,'ru','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(520,1,'en','web','refund.delete','Refund delete','2024-12-30 00:58:29','2024-12-30 00:58:29'),(521,1,'el','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(522,1,'ar','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(523,1,'ru','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(524,1,'en','web','referral.settings','Referral settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(525,1,'el','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(526,1,'ar','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(527,1,'ru','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(528,1,'en','web','active.referral','Active Referral','2024-12-30 00:58:29','2024-12-30 00:58:29'),(529,1,'el','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(530,1,'ar','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(531,1,'ru','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(532,1,'en','web','sender.price','Sender price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(533,1,'el','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(534,1,'ar','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(535,1,'ru','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(536,1,'en','web','receiver.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(537,1,'el','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(538,1,'ar','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(539,1,'ru','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(540,1,'en','web','Privacy','Privacy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(541,1,'el','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(542,1,'ar','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(543,1,'ru','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(544,1,'en','web','email_already_exists','This email already exists','2024-12-30 00:58:29','2024-12-30 00:58:29'),(545,1,'el','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(546,1,'ar','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(547,1,'ru','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(548,1,'en','web','reset_password','Reset password','2024-12-30 00:58:29','2024-12-30 00:58:29'),(549,1,'el','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(550,1,'ar','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(551,1,'ru','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(552,1,'en','web','referral_incorrect','This  referral code is incorrect','2024-12-30 00:58:29','2024-12-30 00:58:29'),(553,1,'el','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(554,1,'ar','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(555,1,'ru','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(556,1,'en','web','invite_friend','Invite friend, earn money','2024-12-30 00:58:29','2024-12-30 00:58:29'),(557,1,'el','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(558,1,'ar','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(559,1,'ru','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(560,1,'en','web','share','Share','2024-12-30 00:58:29','2024-12-30 00:58:29'),(561,1,'el','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(562,1,'ar','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(563,1,'ru','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(564,1,'en','web','copy_code','Copy code','2024-12-30 00:58:29','2024-12-30 00:58:29'),(565,1,'el','web','about','About','2024-12-30 00:58:29','2024-12-30 00:58:29'),(566,1,'ar','web','about','About','2024-12-30 00:58:29','2024-12-30 00:58:29'),(567,1,'en','web','about','About','2024-12-30 00:58:29','2024-12-30 00:58:29'),(568,1,'el','web','careers','Careers','2024-12-30 00:58:29','2024-12-30 00:58:29'),(569,1,'ar','web','careers','Careers','2024-12-30 00:58:29','2024-12-30 00:58:29'),(570,1,'en','web','careers','Careers','2024-12-30 00:58:29','2024-12-30 00:58:29'),(571,1,'el','web','privacy_policy','Privacy Policy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(572,1,'ar','web','privacy_policy','Privacy Policy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(573,1,'en','web','privacy_policy','Privacy Policy','2024-12-30 00:58:29','2024-12-30 00:58:29'),(574,1,'el','web','sign_up_to_deliver','Sign up to deliver','2024-12-30 00:58:29','2024-12-30 00:58:29'),(575,1,'ar','web','sign_up_to_deliver','Sign up to deliver','2024-12-30 00:58:29','2024-12-30 00:58:29'),(576,1,'en','web','sign_up_to_deliver','Sign up to deliver','2024-12-30 00:58:29','2024-12-30 00:58:29'),(577,1,'av','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(578,1,'el','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(579,1,'ar','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(580,1,'en','web','set.active','Are you sure to set active this product ?','2024-12-30 00:58:29','2024-12-30 00:58:29'),(581,1,'av','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(582,1,'el','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(583,1,'ar','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(584,1,'en','web','clone.blog','Clone blog','2024-12-30 00:58:29','2024-12-30 00:58:29'),(585,1,'av','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(586,1,'el','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(587,1,'ar','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(588,1,'en','web','auth','Auth','2024-12-30 00:58:29','2024-12-30 00:58:29'),(589,1,'av','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(590,1,'el','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(591,1,'ar','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(592,1,'en','web','auth.settings','Auth settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(593,1,'el','web','otp.expire.time','Otp expire time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(594,1,'en','web','otp.expire.time','Otp expire time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(595,1,'el','web','blog.active','Blog active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(596,1,'en','web','blog.active','Blog active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(597,1,'el','web','prompt.email.modal','Prompt email modal','2024-12-30 00:58:29','2024-12-30 00:58:29'),(598,1,'en','web','prompt.email.modal','Prompt email modal','2024-12-30 00:58:29','2024-12-30 00:58:29'),(599,1,'el','web','no.active.referral','To change the referral, turn it on in the settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(600,1,'en','web','no.active.referral','To change the referral, turn it on in the settings','2024-12-30 00:58:29','2024-12-30 00:58:29'),(601,1,'el','web','aws.active','Aws active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(602,1,'en','web','aws.active','Aws active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(603,1,'el','web','max_qty','You can`t add more than','2024-12-30 00:58:29','2024-12-30 00:58:29'),(604,1,'en','web','max_qty','You can`t add more than','2024-12-30 00:58:29','2024-12-30 00:58:29'),(605,1,'el','web','add.tag','Add tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(606,1,'en','web','add.tag','Add tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(607,1,'el','web','add.shop.tag','Add shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(608,1,'en','web','add.shop.tag','Add shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(609,1,'el','web','shop.tags','Shop tags','2024-12-30 00:58:29','2024-12-30 00:58:29'),(610,1,'en','web','shop.tags','Shop tags','2024-12-30 00:58:29','2024-12-30 00:58:29'),(611,1,'el','web','distribution.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(612,1,'en','web','distribution.price','Receiver price','2024-12-30 00:58:29','2024-12-30 00:58:29'),(613,1,'el','web','edit.shop.tag','Edit shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(614,1,'en','web','edit.shop.tag','Edit shop tag','2024-12-30 00:58:29','2024-12-30 00:58:29'),(615,1,'el','web','referral.active','Referral active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(616,1,'en','web','referral.active','Referral active','2024-12-30 00:58:29','2024-12-30 00:58:29'),(617,1,'el','web','your_order_status_has_been_changed','Your order status has been changed','2024-12-30 00:58:29','2024-12-30 00:58:29'),(618,1,'ar','web','your_order_status_has_been_changed','Your order status has been changed','2024-12-30 00:58:29','2024-12-30 00:58:29'),(619,1,'en','web','your_order_status_has_been_changed','Your order status has been changed','2024-12-30 00:58:29','2024-12-30 00:58:29'),(620,1,'ar','web','locale','Locale','2024-12-30 00:58:29','2024-12-30 00:58:29'),(621,1,'en','web','locale','Locale','2024-12-30 00:58:29','2024-12-30 00:58:29'),(622,1,'ar','web','open.time','Open time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(623,1,'en','web','open.time','Open time','2024-12-30 00:58:29','2024-12-30 00:58:29'),(624,1,'ar','web','results','نتائج','2024-12-30 00:58:29','2024-12-30 00:58:29'),(625,1,'en','web','results','Results','2024-12-30 00:58:29','2024-12-30 00:58:29'),(626,1,'ar','web','found','وجد','2024-12-30 00:58:29','2024-12-30 00:58:29'),(627,1,'en','web','found','Found','2024-12-30 00:58:29','2024-12-30 00:58:29'),(628,1,'ar','mobile','payment_methods','طرق الدفع','2024-12-30 00:58:29','2024-12-30 00:58:29'),(629,1,'en','mobile','payment_methods','Payment methods','2024-12-30 00:58:29','2024-12-30 00:58:29'),(630,1,'ar','mobile','your_orders','طلباتك','2024-12-30 00:58:29','2024-12-30 00:58:29'),(631,1,'en','mobile','your_orders','Your orders','2024-12-30 00:58:29','2024-12-30 00:58:29'),(632,1,'ar','web','house','منزل','2024-12-30 00:58:29','2024-12-30 00:58:29'),(633,1,'en','web','house','House','2024-12-30 00:58:29','2024-12-30 00:58:29'),(634,1,'ar','web','Office','مكتب','2024-12-30 00:58:29','2024-12-30 00:58:29'),(635,1,'en','web','Office','Office','2024-12-30 00:58:29','2024-12-30 00:58:29'),(636,1,'ar','web','add','يضيف','2024-12-30 00:58:29','2024-12-30 00:58:29'),(637,1,'en','web','add','Add','2024-12-30 00:58:30','2024-12-30 00:58:30'),(638,1,'ar','web','clear','واضح','2024-12-30 00:58:30','2024-12-30 00:58:30'),(639,1,'en','web','clear','Clear','2024-12-30 00:58:30','2024-12-30 00:58:30'),(640,1,'ar','mobile','delivery_price','سعر تسليم','2024-12-30 00:58:30','2024-12-30 00:58:30'),(641,1,'en','mobile','delivery_price','Delivery price','2024-12-30 00:58:30','2024-12-30 00:58:30'),(642,1,'ar','web','total','المجموع','2024-12-30 00:58:30','2024-12-30 00:58:30'),(643,1,'en','web','total','Total','2024-12-30 00:58:30','2024-12-30 00:58:30'),(644,1,'ar','mobile','popular','شائع','2024-12-30 00:58:30','2024-12-30 00:58:30'),(645,1,'en','web','popular','Popular','2024-12-30 00:58:30','2024-12-30 00:58:30'),(646,1,'ar','web','recommended','مُستَحسَن','2024-12-30 00:58:30','2024-12-30 00:58:30'),(647,1,'en','web','recommended','Recommended','2024-12-30 00:58:30','2024-12-30 00:58:30'),(648,1,'ar','mobile','send','يرسل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(649,1,'en','web','send','Send','2024-12-30 00:58:30','2024-12-30 00:58:30'),(650,1,'ar','mobile','or_access_quickly','أو الوصول بسرعة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(651,1,'en','mobile','or_access_quickly','or access quickly','2024-12-30 00:58:30','2024-12-30 00:58:30'),(652,1,'ar','mobile','select_language','اختار اللغة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(653,1,'en','mobile','select_language','Select language','2024-12-30 00:58:30','2024-12-30 00:58:30'),(654,1,'ar','web','next','التالي','2024-12-30 00:58:30','2024-12-30 00:58:30'),(655,1,'en','web','next','Next','2024-12-30 00:58:30','2024-12-30 00:58:30'),(656,1,'ar','web','email','بريد إلكتروني','2024-12-30 00:58:30','2024-12-30 00:58:30'),(657,1,'en','web','email','Email','2024-12-30 00:58:30','2024-12-30 00:58:30'),(658,1,'ar','web','register','اشتراك','2024-12-30 00:58:30','2024-12-30 00:58:30'),(659,1,'en','web','register','Sign up','2024-12-30 00:58:30','2024-12-30 00:58:30'),(660,1,'ar','web','see_all','اظهار الكل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(661,1,'en','web','see_all','See all','2024-12-30 00:58:30','2024-12-30 00:58:30'),(662,1,'ar','web','profile_settings','إعدادات الملف الشخصي','2024-12-30 00:58:30','2024-12-30 00:58:30'),(663,1,'en','web','profile_settings','Profile settings','2024-12-30 00:58:30','2024-12-30 00:58:30'),(664,1,'ar','mobile','cancel','يلغي','2024-12-30 00:58:30','2024-12-30 00:58:30'),(665,1,'en','web','cancel','Cancel','2024-12-30 00:58:30','2024-12-30 00:58:30'),(666,1,'ar','web','yes','نعم','2024-12-30 00:58:30','2024-12-30 00:58:30'),(667,1,'en','web','yes','Yes','2024-12-30 00:58:30','2024-12-30 00:58:30'),(668,1,'ar','web','cart_is_empty','البطاقه خاليه','2024-12-30 00:58:30','2024-12-30 00:58:30'),(669,1,'en','web','cart_is_empty','Cart is empty','2024-12-30 00:58:30','2024-12-30 00:58:30'),(670,1,'ar','web','delivery','توصيل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(671,1,'en','web','delivery','Delivery','2024-12-30 00:58:30','2024-12-30 00:58:30'),(672,1,'ar','web','pickup','يلتقط','2024-12-30 00:58:30','2024-12-30 00:58:30'),(673,1,'en','web','pickup','Pickup','2024-12-30 00:58:30','2024-12-30 00:58:30'),(674,1,'ar','web','delivery.address','عنوان التسليم','2024-12-30 00:58:30','2024-12-30 00:58:30'),(675,1,'en','web','delivery.address','Delivery address','2024-12-30 00:58:30','2024-12-30 00:58:30'),(676,1,'ar','web','subtotal','المجموع الفرعي','2024-12-30 00:58:30','2024-12-30 00:58:30'),(677,1,'en','web','subtotal','Subtotal','2024-12-30 00:58:30','2024-12-30 00:58:30'),(678,1,'ar','web','total_tax','مجموع الضريبة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(679,1,'en','web','total_tax','Total tax','2024-12-30 00:58:30','2024-12-30 00:58:30'),(680,1,'ar','web','404','غير معثور عليه','2024-12-30 00:58:30','2024-12-30 00:58:30'),(681,1,'en','web','404','Not found','2024-12-30 00:58:30','2024-12-30 00:58:30'),(682,1,'ar','web','ready','مستعد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(683,1,'en','web','ready','Ready','2024-12-30 00:58:30','2024-12-30 00:58:30'),(684,1,'ar','web','delivered','تم التوصيل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(685,1,'en','web','delivered','Delivered','2024-12-30 00:58:30','2024-12-30 00:58:30'),(686,1,'ar','web','canceled','ألغيت','2024-12-30 00:58:30','2024-12-30 00:58:30'),(687,1,'en','web','canceled','Canceled','2024-12-30 00:58:30','2024-12-30 00:58:30'),(688,1,'ar','web','cancel_order','الغاء الطلب','2024-12-30 00:58:30','2024-12-30 00:58:30'),(689,1,'en','web','cancel_order','Cancel order','2024-12-30 00:58:30','2024-12-30 00:58:30'),(690,1,'ar','web','qr.code','الباركود','2024-12-30 00:58:30','2024-12-30 00:58:30'),(691,1,'en','web','qr.code','Barcode','2024-12-30 00:58:30','2024-12-30 00:58:30'),(692,1,'ar','web','all','الجميع','2024-12-30 00:58:30','2024-12-30 00:58:30'),(693,1,'en','web','all','All','2024-12-30 00:58:30','2024-12-30 00:58:30'),(694,1,'ar','web','working_hours','ساعات العمل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(695,1,'en','web','working_hours','Working hours','2024-12-30 00:58:30','2024-12-30 00:58:30'),(696,1,'ar','mobile','language','لغة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(697,1,'en','web','language','Language','2024-12-30 00:58:30','2024-12-30 00:58:30'),(698,1,'ar','mobile','save','يحفظ','2024-12-30 00:58:30','2024-12-30 00:58:30'),(699,1,'en','web','save','Save','2024-12-30 00:58:30','2024-12-30 00:58:30'),(700,1,'ar','mobile','orders','طلبات','2024-12-30 00:58:30','2024-12-30 00:58:30'),(701,1,'en','web','orders','Orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(702,1,'ar','mobile','income','دخل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(703,1,'en','mobile','income','Income','2024-12-30 00:58:30','2024-12-30 00:58:30'),(704,1,'ar','web','order_history','تاريخ الطلب','2024-12-30 00:58:30','2024-12-30 00:58:30'),(705,1,'en','web','order_history','Order history','2024-12-30 00:58:30','2024-12-30 00:58:30'),(706,1,'ar','mobile','successfully_completed','مكتملة بنجاح','2024-12-30 00:58:30','2024-12-30 00:58:30'),(707,1,'en','mobile','successfully_completed','Successfully completed','2024-12-30 00:58:30','2024-12-30 00:58:30'),(708,1,'ar','mobile','info_message','رسالة معلومات','2024-12-30 00:58:30','2024-12-30 00:58:30'),(709,1,'en','mobile','info_message','Info message','2024-12-30 00:58:30','2024-12-30 00:58:30'),(710,1,'ar','mobile','you_are_a_seller','انت بائع','2024-12-30 00:58:30','2024-12-30 00:58:30'),(711,1,'en','mobile','you_are_a_seller','You are a seller','2024-12-30 00:58:30','2024-12-30 00:58:30'),(712,1,'ar','mobile','you_are_an_admin','أنت مسؤول','2024-12-30 00:58:30','2024-12-30 00:58:30'),(713,1,'en','mobile','you_are_an_admin','You are an admin','2024-12-30 00:58:30','2024-12-30 00:58:30'),(714,1,'ar','mobile','access_denied','تم الرفض','2024-12-30 00:58:30','2024-12-30 00:58:30'),(715,1,'en','mobile','access_denied','Access denied','2024-12-30 00:58:30','2024-12-30 00:58:30'),(716,1,'ar','mobile','ready_orders','أوامر جاهزة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(717,1,'en','mobile','ready_orders','Ready orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(718,1,'ar','mobile','on_a_way_orders','على طريقة أوامر','2024-12-30 00:58:30','2024-12-30 00:58:30'),(719,1,'en','mobile','on_a_way_orders','On a way orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(720,1,'ar','mobile','accepted_orders','الطلبات المقبولة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(721,1,'en','mobile','accepted_orders','Accepted orders','2024-12-30 00:58:30','2024-12-30 00:58:30'),(722,1,'ar','web','payment.method','طريقة الدفع او السداد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(723,1,'en','web','payment.method','Payment method','2024-12-30 00:58:30','2024-12-30 00:58:30'),(724,1,'ar','web','not_found','غير معثور عليه','2024-12-30 00:58:30','2024-12-30 00:58:30'),(725,1,'en','web','not_found','Not found','2024-12-30 00:58:30','2024-12-30 00:58:30'),(726,1,'ar','web','new.user','مستخدم جديد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(727,1,'en','web','new.user','New user','2024-12-30 00:58:30','2024-12-30 00:58:30'),(728,1,'ar','web','monday','الاثنين','2024-12-30 00:58:30','2024-12-30 00:58:30'),(729,1,'en','web','monday','Monday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(730,1,'ar','web','tuesday','يوم الثلاثاء','2024-12-30 00:58:30','2024-12-30 00:58:30'),(731,1,'en','web','tuesday','Tuesday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(732,1,'ar','web','wednesday','الأربعاء','2024-12-30 00:58:30','2024-12-30 00:58:30'),(733,1,'en','web','wednesday','Wednesday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(734,1,'ar','web','thursday','يوم الخميس','2024-12-30 00:58:30','2024-12-30 00:58:30'),(735,1,'en','web','thursday','Thursday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(736,1,'ar','web','friday','جمعة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(737,1,'en','web','friday','Friday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(738,1,'ar','web','saturday','السبت','2024-12-30 00:58:30','2024-12-30 00:58:30'),(739,1,'en','web','saturday','Saturday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(740,1,'ar','web','sunday','الأحد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(741,1,'en','web','sunday','Sunday','2024-12-30 00:58:30','2024-12-30 00:58:30'),(742,1,'ar','web','order.statistic','ترتيب الإحصاء','2024-12-30 00:58:30','2024-12-30 00:58:30'),(743,1,'en','web','order.statistic','Order statistic','2024-12-30 00:58:30','2024-12-30 00:58:30'),(744,1,'ar','mobile','description','وصف','2024-12-30 00:58:30','2024-12-30 00:58:30'),(745,1,'en','web','description','Description','2024-12-30 00:58:30','2024-12-30 00:58:30'),(746,1,'ar','mobile','phone_number','رقم التليفون','2024-12-30 00:58:30','2024-12-30 00:58:30'),(747,1,'en','mobile','phone_number','Phone number','2024-12-30 00:58:30','2024-12-30 00:58:30'),(748,1,'ar','mobile','add_product','أضف منتج','2024-12-30 00:58:30','2024-12-30 00:58:30'),(749,1,'en','mobile','add_product','Add product','2024-12-30 00:58:30','2024-12-30 00:58:30'),(750,1,'ar','mobile','product_category','فئة المنتج','2024-12-30 00:58:30','2024-12-30 00:58:30'),(751,1,'en','mobile','product_category','Product category','2024-12-30 00:58:30','2024-12-30 00:58:30'),(752,1,'ar','mobile','add_new_category','إضافة فئة جديدة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(753,1,'en','mobile','add_new_category','Add new category','2024-12-30 00:58:30','2024-12-30 00:58:30'),(754,1,'ar','mobile','show_the_product_to_the_customer','اعرض المنتج للعميل','2024-12-30 00:58:30','2024-12-30 00:58:30'),(755,1,'en','mobile','show_the_product_to_the_customer','Show the product to the customer','2024-12-30 00:58:30','2024-12-30 00:58:30'),(756,1,'ar','mobile','edit_product','تحرير المنتج','2024-12-30 00:58:30','2024-12-30 00:58:30'),(757,1,'en','mobile','edit_product','Edit product','2024-12-30 00:58:30','2024-12-30 00:58:30'),(758,1,'ar','mobile','cannot_be_empty','لايمكن ان يكون فارغا','2024-12-30 00:58:30','2024-12-30 00:58:30'),(759,1,'en','mobile','cannot_be_empty','Cannot be empty','2024-12-30 00:58:30','2024-12-30 00:58:30'),(760,1,'ar','mobile','update_failed','فشل التحديث','2024-12-30 00:58:30','2024-12-30 00:58:30'),(761,1,'en','mobile','update_failed','Update failed','2024-12-30 00:58:30','2024-12-30 00:58:30'),(762,1,'ar','mobile','stocks','مخازن','2024-12-30 00:58:30','2024-12-30 00:58:30'),(763,1,'en','web','stocks','Stocks','2024-12-30 00:58:30','2024-12-30 00:58:30'),(764,1,'ar','mobile','order_price','سعر الطلب','2024-12-30 00:58:30','2024-12-30 00:58:30'),(765,1,'en','mobile','order_price','Order price','2024-12-30 00:58:30','2024-12-30 00:58:30'),(766,1,'ar','mobile','quantity','كمية','2024-12-30 00:58:30','2024-12-30 00:58:30'),(767,1,'en','web','quantity','Quantity','2024-12-30 00:58:30','2024-12-30 00:58:30'),(768,1,'ar','mobile','close','يغلق','2024-12-30 00:58:30','2024-12-30 00:58:30'),(769,1,'en','mobile','close','Close','2024-12-30 00:58:30','2024-12-30 00:58:30'),(770,1,'ar','mobile','max_quantity','الكمية القصوى','2024-12-30 00:58:30','2024-12-30 00:58:30'),(771,1,'en','mobile','max_quantity','Max quantity','2024-12-30 00:58:30','2024-12-30 00:58:30'),(772,1,'ar','mobile','min_quantity','كمية دقيقة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(773,1,'en','mobile','min_quantity','Min quantity','2024-12-30 00:58:30','2024-12-30 00:58:30'),(774,1,'ar','mobile','tax','ضريبة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(775,1,'en','web','tax','Tax','2024-12-30 00:58:30','2024-12-30 00:58:30'),(776,1,'ar','mobile','delivery_zone','منطقة التسليم','2024-12-30 00:58:30','2024-12-30 00:58:30'),(777,1,'en','mobile','delivery_zone','Delivery zone','2024-12-30 00:58:30','2024-12-30 00:58:30'),(778,1,'ar','mobile','no_transaction','لا توجد معاملة','2024-12-30 00:58:30','2024-12-30 00:58:30'),(779,1,'en','mobile','no_transaction','No transaction','2024-12-30 00:58:30','2024-12-30 00:58:30'),(780,1,'ar','mobile','try_searching_again','حاول البحث مرة أخرى ، نعتقد أنك ستجد شيئًا ما','2024-12-30 00:58:30','2024-12-30 00:58:30'),(781,1,'en','mobile','try_searching_again','Try searching again, we believe you will find something','2024-12-30 00:58:30','2024-12-30 00:58:30'),(782,1,'ar','mobile','order_now','اطلب الان','2024-12-30 00:58:30','2024-12-30 00:58:30'),(783,1,'en','mobile','order_now','Order now','2024-12-30 00:58:30','2024-12-30 00:58:30'),(784,1,'ar','mobile','help','يساعد','2024-12-30 00:58:30','2024-12-30 00:58:30'),(785,1,'en','web','help','Help','2024-12-30 00:58:30','2024-12-30 00:58:30'),(786,1,'ar','mobile','mobile_number','رقم الهاتف المحمول','2024-12-30 00:58:31','2024-12-30 00:58:31'),(787,1,'en','mobile','mobile_number','Mobile number','2024-12-30 00:58:31','2024-12-30 00:58:31'),(788,1,'ar','mobile','login','تسجيل الدخول','2024-12-30 00:58:31','2024-12-30 00:58:31'),(789,1,'en','web','login','Login','2024-12-30 00:58:31','2024-12-30 00:58:31'),(790,1,'ar','mobile','no_restaurant','لم يتم العثور على شيء','2024-12-30 00:58:31','2024-12-30 00:58:31'),(791,1,'en','mobile','no_restaurant','No Restaurant','2024-12-30 00:58:31','2024-12-30 00:58:31'),(792,1,'ar','mobile','nothing_found','لم يتم العثور على شيء','2024-12-30 00:58:31','2024-12-30 00:58:31'),(793,1,'en','mobile','nothing_found','Nothing found','2024-12-30 00:58:31','2024-12-30 00:58:31'),(794,1,'ar','mobile','enter_a_delivery_address','أدخل عنوان التسليم','2024-12-30 00:58:31','2024-12-30 00:58:31'),(795,1,'en','mobile','enter_a_delivery_address','Enter a delivery address','2024-12-30 00:58:31','2024-12-30 00:58:31'),(796,1,'ar','mobile','clear_all','امسح الكل','2024-12-30 00:58:31','2024-12-30 00:58:31'),(797,1,'en','mobile','clear_all','Clear all','2024-12-30 00:58:31','2024-12-30 00:58:31'),(798,1,'ar','mobile','do_you_really_want_to_logout','هل تريد حقا الخروج','2024-12-30 00:58:31','2024-12-30 00:58:31'),(799,1,'en','mobile','do_you_really_want_to_logout','Do you really want to logout','2024-12-30 00:58:31','2024-12-30 00:58:31'),(800,1,'ar','mobile','no_orders','لا توجد أوامر متاحة في هذا الوقت. بمجرد أن يضع العملاء طلبًا ، سنعرض لك','2024-12-30 00:58:31','2024-12-30 00:58:31'),(801,1,'en','mobile','no_orders','No orders available at this time. As soon as customers place an order we will show you','2024-12-30 00:58:31','2024-12-30 00:58:31'),(802,1,'ar','mobile','enter_the_restaurant_opening_hours','أدخل ساعات عمل المطعم','2024-12-30 00:58:31','2024-12-30 00:58:31'),(803,1,'en','mobile','enter_the_restaurant_opening_hours','Enter the restaurant opening hours','2024-12-30 00:58:31','2024-12-30 00:58:31'),(804,1,'ar','mobile','set_as_a_business_day','تعيين كيوم عمل','2024-12-30 00:58:31','2024-12-30 00:58:31'),(805,1,'en','mobile','set_as_a_business_day','Set as a business day','2024-12-30 00:58:31','2024-12-30 00:58:31'),(806,1,'ar','mobile','product_picture','صورة المنتج','2024-12-30 00:58:31','2024-12-30 00:58:31'),(807,1,'en','mobile','product_picture','Product picture','2024-12-30 00:58:31','2024-12-30 00:58:31'),(808,1,'ar','mobile','confirm_location','تأكيد الموقع','2024-12-30 00:58:31','2024-12-30 00:58:31'),(809,1,'en','mobile','confirm_location','Confirm location','2024-12-30 00:58:31','2024-12-30 00:58:31'),(810,1,'ar','mobile','search_location','موقع البحث','2024-12-30 00:58:31','2024-12-30 00:58:31'),(811,1,'en','mobile','search_location','Search location','2024-12-30 00:58:31','2024-12-30 00:58:31'),(812,1,'ar','mobile','select_delivery_date','حدد تاريخ التسليم','2024-12-30 00:58:31','2024-12-30 00:58:31'),(813,1,'en','mobile','select_delivery_date','Select delivery date','2024-12-30 00:58:31','2024-12-30 00:58:31'),(814,1,'ar','mobile','out_of_stock','إنتهى من المخزن','2024-12-30 00:58:31','2024-12-30 00:58:31'),(815,1,'en','mobile','out_of_stock','Out of stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(816,1,'ar','mobile','please_select_a_user','الرجاء تحديد مستخدم','2024-12-30 00:58:31','2024-12-30 00:58:31'),(817,1,'en','mobile','please_select_a_user','Please select a user','2024-12-30 00:58:31','2024-12-30 00:58:31'),(818,1,'ar','mobile','swipe_to_accept','انتقد لقبول','2024-12-30 00:58:31','2024-12-30 00:58:31'),(819,1,'en','mobile','swipe_to_accept','Swipe to accept','2024-12-30 00:58:31','2024-12-30 00:58:31'),(820,1,'ar','mobile','successfully_updated','مكتملة بنجاح','2024-12-30 00:58:31','2024-12-30 00:58:31'),(821,1,'en','mobile','successfully_updated','Successfully completed','2024-12-30 00:58:31','2024-12-30 00:58:31'),(822,1,'ar','web','deals','صفقات','2024-12-30 00:58:31','2024-12-30 00:58:31'),(823,1,'en','web','deals','Deals','2024-12-30 00:58:31','2024-12-30 00:58:31'),(824,1,'ar','web','open_shop','فتح فقط','2024-12-30 00:58:31','2024-12-30 00:58:31'),(825,1,'en','web','open_shop','Only opened','2024-12-30 00:58:31','2024-12-30 00:58:31'),(826,1,'ar','web','ratings','التقييمات','2024-12-30 00:58:31','2024-12-30 00:58:31'),(827,1,'en','web','ratings','Ratings','2024-12-30 00:58:31','2024-12-30 00:58:31'),(828,1,'ar','web','open_until','مفتوحة حتى','2024-12-30 00:58:31','2024-12-30 00:58:31'),(829,1,'en','web','open_until','Open until','2024-12-30 00:58:31','2024-12-30 00:58:31'),(830,1,'ar','web','not_enough_money','ليس هناك ما يكفي من المال في محفظتك','2024-12-30 00:58:31','2024-12-30 00:58:31'),(831,1,'en','web','not_enough_money','There is not enough money in your wallet','2024-12-30 00:58:31','2024-12-30 00:58:31'),(832,1,'ar','web','add.email.provider','أضف مزود البريد الإلكتروني','2024-12-30 00:58:31','2024-12-30 00:58:31'),(833,1,'en','web','add.email.provider','Add email provider','2024-12-30 00:58:31','2024-12-30 00:58:31'),(834,1,'ar','web','username','اسم المستخدم','2024-12-30 00:58:31','2024-12-30 00:58:31'),(835,1,'en','web','username','Username','2024-12-30 00:58:31','2024-12-30 00:58:31'),(836,1,'ar','web','smtp_auth','مصادقة SMTP','2024-12-30 00:58:31','2024-12-30 00:58:31'),(837,1,'en','web','smtp_auth','Smtp auth','2024-12-30 00:58:31','2024-12-30 00:58:31'),(838,1,'ar','web','smtp_debug','تصحيح أخطاء SMTP','2024-12-30 00:58:31','2024-12-30 00:58:31'),(839,1,'en','web','smtp_debug','Smtp debug','2024-12-30 00:58:31','2024-12-30 00:58:31'),(840,1,'ar','web','host','يستضيف','2024-12-30 00:58:31','2024-12-30 00:58:31'),(841,1,'en','web','host','Host','2024-12-30 00:58:31','2024-12-30 00:58:31'),(842,1,'ar','web','port','ميناء','2024-12-30 00:58:31','2024-12-30 00:58:31'),(843,1,'en','web','port','Port','2024-12-30 00:58:31','2024-12-30 00:58:31'),(844,1,'ar','web','required.email','الإدخال ليس بريدًا إلكترونيًا صالحًا!','2024-12-30 00:58:31','2024-12-30 00:58:31'),(845,1,'en','web','required.email','The input is not valid E-mail!','2024-12-30 00:58:31','2024-12-30 00:58:31'),(846,1,'ar','mobile','password','كلمة المرور','2024-12-30 00:58:31','2024-12-30 00:58:31'),(847,1,'en','web','password','Password','2024-12-30 00:58:31','2024-12-30 00:58:31'),(848,1,'ar','mobile','keep_me_logged_in','أبق تسجيل دخولي','2024-12-30 00:58:31','2024-12-30 00:58:31'),(849,1,'en','mobile','keep_me_logged_in','Keep me logged in','2024-12-30 00:58:31','2024-12-30 00:58:31'),(850,1,'ar','mobile','forgot_password','هل نسيت كلمة السر','2024-12-30 00:58:31','2024-12-30 00:58:31'),(851,1,'en','mobile','forgot_password','Forgot password','2024-12-30 00:58:31','2024-12-30 00:58:31'),(852,1,'ar','mobile','demo_login_password','تجريبي كلمة مرور تسجيل الدخول','2024-12-30 00:58:31','2024-12-30 00:58:31'),(853,1,'en','mobile','demo_login_password','Demo login password','2024-12-30 00:58:31','2024-12-30 00:58:31'),(854,1,'ar','mobile','email_is_not_valid','البريد الإلكتروني غير صالح','2024-12-30 00:58:31','2024-12-30 00:58:31'),(855,1,'en','mobile','email_is_not_valid','Email is not valid','2024-12-30 00:58:31','2024-12-30 00:58:31'),(856,1,'ar','mobile','password_should_contain_minimum_6_characters','يجب أن تحتوي كلمة المرور على 6 أحرف على الأقل','2024-12-30 00:58:31','2024-12-30 00:58:31'),(857,1,'en','mobile','password_should_contain_minimum_6_characters','Password should contain minimum 6 characters','2024-12-30 00:58:31','2024-12-30 00:58:31'),(858,1,'ar','web','no_driver_zone','Sorry, we`re not available here','2024-12-30 00:58:31','2024-12-30 00:58:31'),(859,1,'en','web','no_driver_zone','Sorry, we`re not available here','2024-12-30 00:58:31','2024-12-30 00:58:31'),(860,1,'ar','mobile','search','يبحث','2024-12-30 00:58:31','2024-12-30 00:58:31'),(861,1,'en','web','search','Search','2024-12-30 00:58:31','2024-12-30 00:58:31'),(862,1,'ar','mobile','news_of_the_week','أخبار الأسبوع','2024-12-30 00:58:31','2024-12-30 00:58:31'),(863,1,'en','mobile','news_of_the_week','News of the week','2024-12-30 00:58:31','2024-12-30 00:58:31'),(864,1,'ar','web','clone.banner','Clone banner','2024-12-30 00:58:31','2024-12-30 00:58:31'),(865,1,'en','web','clone.banner','Clone banner','2024-12-30 00:58:31','2024-12-30 00:58:31'),(866,1,'ar','web','become_seller','كن بائعًا','2024-12-30 00:58:31','2024-12-30 00:58:31'),(867,1,'en','web','become_seller','Become seller','2024-12-30 00:58:31','2024-12-30 00:58:31'),(868,1,'ar','web','referral_faq','Referral terms','2024-12-30 00:58:31','2024-12-30 00:58:31'),(869,1,'en','web','referral_faq','Referral terms','2024-12-30 00:58:31','2024-12-30 00:58:31'),(870,1,'ar','web','copied','Copied to clipboard','2024-12-30 00:58:31','2024-12-30 00:58:31'),(871,1,'en','web','copied','Copied to clipboard!','2024-12-30 00:58:31','2024-12-30 00:58:31'),(872,1,'ar','web','more_info','More info','2024-12-30 00:58:31','2024-12-30 00:58:31'),(873,1,'en','web','more_info','More info','2024-12-30 00:58:31','2024-12-30 00:58:31'),(874,1,'ar','web','no_internet_connection','There is some problem with your internet connection, please check and try again','2024-12-30 00:58:31','2024-12-30 00:58:31'),(875,1,'en','web','no_internet_connection','There is some problem with your internet connection, please check and try again','2024-12-30 00:58:31','2024-12-30 00:58:31'),(876,1,'ar','web','successfully.cleared','Successfully cleared','2024-12-30 00:58:31','2024-12-30 00:58:31'),(877,1,'en','web','successfully.cleared','Successfully cleared','2024-12-30 00:58:31','2024-12-30 00:58:31'),(878,1,'ar','web','order_status_ready','Please make the order status ready and then contact the deliveryman','2024-12-30 00:58:31','2024-12-30 00:58:31'),(879,1,'en','web','order_status_ready','Please make the order status ready and then contact the deliveryman','2024-12-30 00:58:31','2024-12-30 00:58:31'),(880,1,'ar','errors','ERROR_430','Stock quantity 0','2024-12-30 00:58:31','2024-12-30 00:58:31'),(881,1,'en','errors','ERROR_430','Stock quantity 0','2024-12-30 00:58:31','2024-12-30 00:58:31'),(882,1,'ar','web','ANALYTICS.ADN.REPORTS','Analytics and reporting','2024-12-30 00:58:31','2024-12-30 00:58:31'),(883,1,'en','web','ANALYTICS.ADN.REPORTS','Analytics and reporting','2024-12-30 00:58:31','2024-12-30 00:58:31'),(884,1,'ar','web','swipe_to_ready','Swipe to ready','2024-12-30 00:58:31','2024-12-30 00:58:31'),(885,1,'en','web','swipe_to_ready','Swipe to ready','2024-12-30 00:58:31','2024-12-30 00:58:31'),(886,1,'ar','web','swipe_to_way','Swipe to on a way','2024-12-30 00:58:31','2024-12-30 00:58:31'),(887,1,'en','web','swipe_to_way','Swipe to on a way','2024-12-30 00:58:31','2024-12-30 00:58:31'),(888,1,'ar','web','swipe_to_delivered','Swipe to delivered','2024-12-30 00:58:31','2024-12-30 00:58:31'),(889,1,'en','web','swipe_to_delivered','Swipe to delivered','2024-12-30 00:58:31','2024-12-30 00:58:31'),(890,1,'ar','web','in_active','Inactive','2024-12-30 00:58:31','2024-12-30 00:58:31'),(891,1,'en','web','in_active','Inactive','2024-12-30 00:58:31','2024-12-30 00:58:31'),(892,1,'el','web','qty','Qty','2024-12-30 00:58:31','2024-12-30 00:58:31'),(893,1,'ar','web','qty','Qty','2024-12-30 00:58:31','2024-12-30 00:58:31'),(894,1,'en','web','qty','Qty','2024-12-30 00:58:31','2024-12-30 00:58:31'),(895,1,'el','web','add.subscription','Add subscription','2024-12-30 00:58:31','2024-12-30 00:58:31'),(896,1,'ar','web','add.subscription','Add subscription','2024-12-30 00:58:31','2024-12-30 00:58:31'),(897,1,'en','web','add.subscription','Add subscription','2024-12-30 00:58:31','2024-12-30 00:58:31'),(898,1,'el','web','high_rating','High rating','2024-12-30 00:58:31','2024-12-30 00:58:31'),(899,1,'ar','web','high_rating','High rating','2024-12-30 00:58:31','2024-12-30 00:58:31'),(900,1,'en','web','high_rating','High rating','2024-12-30 00:58:31','2024-12-30 00:58:31'),(901,1,'el','web','bonus.stock','Bonus stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(902,1,'ar','web','bonus.stock','Bonus stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(903,1,'en','web','bonus.stock','Bonus stock','2024-12-30 00:58:31','2024-12-30 00:58:31'),(904,1,'el','web','time_schedule','Schedule delivery','2024-12-30 00:58:31','2024-12-30 00:58:31'),(905,1,'ar','web','time_schedule','Schedule delivery','2024-12-30 00:58:31','2024-12-30 00:58:31'),(906,1,'en','web','time_schedule','Schedule delivery','2024-12-30 00:58:31','2024-12-30 00:58:31'),(907,1,'ar','web','not_work','Delivery service is not available on','2024-12-30 00:58:31','2024-12-30 00:58:31'),(908,1,'en','web','not_work','Delivery service is not available on','2024-12-30 00:58:31','2024-12-30 00:58:31'),(909,1,'el','web','ERROR_212','Not your shop check your other account','2024-12-30 00:58:31','2024-12-30 00:58:31'),(910,1,'ar','web','ERROR_212','Not your shop check your other account','2024-12-30 00:58:31','2024-12-30 00:58:31'),(911,1,'en','web','ERROR_212','Not your shop check your other account','2024-12-30 00:58:31','2024-12-30 00:58:31'),(912,1,'el','errors','ERROR_213','Your subscription is expired at','2024-12-30 00:58:31','2024-12-30 00:58:31'),(913,1,'ar','errors','ERROR_213','Your subscription is expired at','2024-12-30 00:58:31','2024-12-30 00:58:31'),(914,1,'en','errors','ERROR_213','Your subscription is expired at','2024-12-30 00:58:31','2024-12-30 00:58:31'),(915,1,'el','errors','ERROR_214','Your subscription product limit has expired','2024-12-30 00:58:31','2024-12-30 00:58:31'),(916,1,'ar','errors','ERROR_214','Your subscription product limit has expired','2024-12-30 00:58:31','2024-12-30 00:58:31'),(917,1,'en','errors','ERROR_214','Your subscription product limit has expired','2024-12-30 00:58:31','2024-12-30 00:58:31'),(918,1,'el','web','ERROR_431','Active default currency not found','2024-12-30 00:58:32','2024-12-30 00:58:32'),(919,1,'ar','web','ERROR_431','Active default currency not found','2024-12-30 00:58:32','2024-12-30 00:58:32'),(920,1,'en','web','ERROR_431','Active default currency not found','2024-12-30 00:58:32','2024-12-30 00:58:32'),(921,1,'el','web','cancel_orders','Canceled orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(922,1,'ar','web','cancel_orders','Canceled orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(923,1,'en','web','cancel_orders','Canceled orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(924,1,'el','web','new_orders','New orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(925,1,'ar','web','new_orders','New orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(926,1,'en','web','new_orders','New orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(927,1,'el','web','business','Business','2024-12-30 00:58:32','2024-12-30 00:58:32'),(928,1,'ar','web','business','Business','2024-12-30 00:58:32','2024-12-30 00:58:32'),(929,1,'en','web','business','Business','2024-12-30 00:58:32','2024-12-30 00:58:32'),(930,1,'en','web','not.published','Not published','2024-12-30 00:58:32','2024-12-30 00:58:32'),(931,1,'en','web','published.date','Published date','2024-12-30 00:58:32','2024-12-30 00:58:32'),(932,1,'en','web','delete.chat','Delete chat','2024-12-30 00:58:32','2024-12-30 00:58:32'),(933,1,'en','web','edit.subscription','Edit subscription','2024-12-30 00:58:32','2024-12-30 00:58:32'),(934,1,'en','web','with_report','With report','2024-12-30 00:58:32','2024-12-30 00:58:32'),(935,1,'en','web','period','Period (month)','2024-12-30 00:58:32','2024-12-30 00:58:32'),(936,1,'en','web','order_limit','Order limit','2024-12-30 00:58:32','2024-12-30 00:58:32'),(937,1,'en','web','product_limit','Product limit','2024-12-30 00:58:32','2024-12-30 00:58:32'),(938,1,'ar','mobile','floor','أرضية','2024-12-30 00:58:32','2024-12-30 00:58:32'),(939,1,'en','mobile','floor','Floor','2024-12-30 00:58:32','2024-12-30 00:58:32'),(940,1,'ar','mobile','the_restaurant_is_closed_today','المطعم مغلق اليوم','2024-12-30 00:58:32','2024-12-30 00:58:32'),(941,1,'en','mobile','the_restaurant_is_closed_today','The restaurant is closed today','2024-12-30 00:58:32','2024-12-30 00:58:32'),(942,1,'ar','mobile','restaurant_name','اسم المطعم','2024-12-30 00:58:32','2024-12-30 00:58:32'),(943,1,'en','mobile','restaurant_name','Restaurant name','2024-12-30 00:58:32','2024-12-30 00:58:32'),(944,1,'ar','mobile','restaurant_settings','إعدادات المطعم','2024-12-30 00:58:32','2024-12-30 00:58:32'),(945,1,'en','mobile','restaurant_settings','Restaurant settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(946,1,'en','web','shop_and_restaurants','Shop and Restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(947,1,'en','web','liked_restaurants','Liked restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(948,1,'en','web','restaurants','Restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(949,1,'ar','mobile','liked_restaurant','مطاعم يحبها','2024-12-30 00:58:32','2024-12-30 00:58:32'),(950,1,'en','mobile','liked_restaurant','Liked restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(951,1,'en','web','all.restaurants','All restaurants','2024-12-30 00:58:32','2024-12-30 00:58:32'),(952,1,'en','web','zona','Zona','2024-12-30 00:58:32','2024-12-30 00:58:32'),(953,1,'en','web','Nutrition off','Nutrition off','2024-12-30 00:58:32','2024-12-30 00:58:32'),(954,1,'en','web','nutrition.on','Nutrition on','2024-12-30 00:58:32','2024-12-30 00:58:32'),(955,1,'en','web','basic.info','Basic Info','2024-12-30 00:58:32','2024-12-30 00:58:32'),(956,1,'en','web','pricing','Pricing','2024-12-30 00:58:32','2024-12-30 00:58:32'),(957,1,'en','web','additions','Additions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(958,1,'en','web','nutritional.value.of.food','Nutritional value of food','2024-12-30 00:58:32','2024-12-30 00:58:32'),(959,1,'en','web','organization','Organization','2024-12-30 00:58:32','2024-12-30 00:58:32'),(960,1,'en','web','media','Media','2024-12-30 00:58:32','2024-12-30 00:58:32'),(961,1,'en','web','nutrition.off','Nutrition off','2024-12-30 00:58:32','2024-12-30 00:58:32'),(962,1,'en','web','add.sms.geteways','Add sms geteways','2024-12-30 00:58:32','2024-12-30 00:58:32'),(963,1,'en','web','add.career.category','Add career category','2024-12-30 00:58:32','2024-12-30 00:58:32'),(964,1,'en','web','edit.career.category','Edit career category','2024-12-30 00:58:32','2024-12-30 00:58:32'),(965,1,'en','web','add.career','Add Career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(966,1,'en','web','edit.career','Edit Career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(967,1,'en','web','clone.career','Clone career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(968,1,'en','web','add.pages','Add page','2024-12-30 00:58:32','2024-12-30 00:58:32'),(969,1,'en','web','edit.page','Edit page','2024-12-30 00:58:32','2024-12-30 00:58:32'),(970,1,'en','web','recomention.time','Recomention time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(971,1,'en','web','chair.count','Chair count','2024-12-30 00:58:32','2024-12-30 00:58:32'),(972,1,'en','web','name','Name','2024-12-30 00:58:32','2024-12-30 00:58:32'),(973,1,'en','web','max.time','Max time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(974,1,'en','web','start.time','Start time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(975,1,'en','web','end.time','End time','2024-12-30 00:58:32','2024-12-30 00:58:32'),(976,1,'en','web','pos.system','POS System','2024-12-30 00:58:32','2024-12-30 00:58:32'),(977,1,'en','web','delivery.orders','Delivery Orders','2024-12-30 00:58:32','2024-12-30 00:58:32'),(978,1,'en','web','reviews','Reviews','2024-12-30 00:58:32','2024-12-30 00:58:32'),(979,1,'en','web','refunds','Refunds','2024-12-30 00:58:32','2024-12-30 00:58:32'),(980,1,'en','web','order.status','Order status','2024-12-30 00:58:32','2024-12-30 00:58:32'),(981,1,'en','web','deliveryman','Deliveryman','2024-12-30 00:58:32','2024-12-30 00:58:32'),(982,1,'en','web','deliveries.list','Deliveries List','2024-12-30 00:58:32','2024-12-30 00:58:32'),(983,1,'en','web','deliveries.map','Deliveries map','2024-12-30 00:58:32','2024-12-30 00:58:32'),(984,1,'en','web','delivery.statistics','Delivery Statistics','2024-12-30 00:58:32','2024-12-30 00:58:32'),(985,1,'en','web','deliveryboy.reviews','Deliveryman reviews','2024-12-30 00:58:32','2024-12-30 00:58:32'),(986,1,'en','web','restaurant','Restaurant','2024-12-30 00:58:32','2024-12-30 00:58:32'),(987,1,'en','web','shops','Shops','2024-12-30 00:58:32','2024-12-30 00:58:32'),(988,1,'en','web','shop.tag','Shop/Restaurant tags','2024-12-30 00:58:32','2024-12-30 00:58:32'),(989,1,'en','web','extras','Extras','2024-12-30 00:58:32','2024-12-30 00:58:32'),(990,1,'en','web','extra.group','Extra group','2024-12-30 00:58:32','2024-12-30 00:58:32'),(991,1,'en','web','extra.value','Extra value','2024-12-30 00:58:32','2024-12-30 00:58:32'),(992,1,'en','web','categories','Categories','2024-12-30 00:58:32','2024-12-30 00:58:32'),(993,1,'en','web','product.reviews','Product reviews','2024-12-30 00:58:32','2024-12-30 00:58:32'),(994,1,'en','web','content','Content','2024-12-30 00:58:32','2024-12-30 00:58:32'),(995,1,'en','web','brands','Brands','2024-12-30 00:58:32','2024-12-30 00:58:32'),(996,1,'en','web','career','Career','2024-12-30 00:58:32','2024-12-30 00:58:32'),(997,1,'en','web','career.categories','Career Categories','2024-12-30 00:58:32','2024-12-30 00:58:32'),(998,1,'en','web','units','Units','2024-12-30 00:58:32','2024-12-30 00:58:32'),(999,1,'en','web','banners','Banners','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1000,1,'en','web','blogs','Blogs','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1001,1,'en','web','stories','Stories','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1002,1,'en','web','gallery','Gallery','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1003,1,'en','web','notifications','Notifications','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1004,1,'en','web','customer','Customer','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1005,1,'en','web','wallets','Wallets','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1006,1,'en','web','users','Users','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1007,1,'en','web','user','User','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1008,1,'en','web','clients','Clients','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1009,1,'en','web','roles','Roles','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1010,1,'en','web','email.subscriber','Email subscriber','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1011,1,'en','web','subscriber','Subscriber','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1012,1,'en','web','message.subscriber','Message subscriber','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1013,1,'en','web','transaction','Transaction','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1014,1,'en','web','transactions','Transactions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1015,1,'en','web','payout.requests','Payout requests','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1016,1,'en','web','payouts','Payouts','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1017,1,'en','web','subscriptions','Subscriptions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1018,1,'en','web','marketing','Marketing','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1019,1,'en','web','cashback','Cashback','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1020,1,'en','web','referral','Referral','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1021,1,'en','web','bonus','Bonus','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1022,1,'en','web','analytics.and.reports','Analytics and reports','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1023,1,'en','web','food','Food','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1024,1,'en','web','foods','Foods','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1025,1,'en','web','order','Order','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1026,1,'en','web','stock','Stock','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1027,1,'en','web','category','Category','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1028,1,'en','web','variation','Variation','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1029,1,'en','web','business.settings','Business settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1030,1,'en','web','settings','Settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1031,1,'en','web','currencies','Currencies','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1032,1,'en','web','wallet','Wallet','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1033,1,'en','web','payload','Payload','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1034,1,'en','web','message','Message','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1035,1,'en','web','payments','Payments','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1036,1,'en','web','sms-gateways','Sms gateways','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1037,1,'en','web','email.provider','Email provider','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1038,1,'en','web','notification.settings','Notification settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1039,1,'en','web','social.settings','Social settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1040,1,'en','web','app.settings','App Settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1041,1,'en','web','page.setup','Page setup','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1042,1,'en','web','faq','Frequently asked questions','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1043,1,'en','web','terms','Terms','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1044,1,'en','web','policy','Privacy & Policy','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1045,1,'en','web','pages','Pages','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1046,1,'en','web','system.settings','System settings','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1047,1,'en','web','languages','Languages','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1048,1,'en','web','translations','Translations','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1049,1,'en','web','system.information','System information','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1050,1,'en','web','hello','Hello','2024-12-30 00:58:32','2024-12-30 00:58:32'),(1051,1,'en','web','hello.text','Let\'s check your stats today!','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1052,1,'en','web','top.products','Top products','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1053,1,'en','web','all.orders','All orders','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1054,1,'en','web','pickup.orders','Pickup orders','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1055,1,'en','web','change.columns','Change columns','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1056,1,'en','web','todo.list','Todo list','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1057,1,'en','web','archive','Archive','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1058,1,'en','web','todo.placeholder','What needs to be done?','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1059,1,'en','web','todo.empty','There\'s nothing to do =>(','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1060,1,'en','web','todo.add','Add todo','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1061,1,'en','web','scheduled.orders','Scheduled orders','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1062,1,'en','web','payment.payloads','Payment payloads','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1063,1,'en','web','edit.payment.payloads','Edit payment payload','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1064,1,'en','web','add.payment.payloads','Add payment payload','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1065,1,'en','web','payment.id','Payment id','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1066,1,'en','web','paypal.mode','Paypal mode','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1067,1,'en','web','discount.type','Discount type','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1068,1,'en','web','discount.price','Discount price','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1069,1,'en','web','add.stock','Add stock','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1070,1,'en','web','recipe.categories','Recipe categories','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1071,1,'en','web','recepes','Recipes','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1072,1,'en','web','add.recepe','Add recipe','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1073,1,'en','web','edit.recepe','Edit recipe','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1074,1,'en','web','total.time','Total time','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1075,1,'en','web','calories','Calories','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1076,1,'en','web','servings','Servings','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1077,1,'en','web','instructions','Instructions','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1078,1,'en','web','weight','Weight','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1079,1,'en','web','percentage','Percentage','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1080,1,'en','web','recepts','Recipes','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1081,1,'en','web','recipe.category','Recipe category','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1082,1,'en','web','recipe','Recipe','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1083,1,'en','web','nutritions','Nutritions','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1084,1,'en','web','paystack.sk','Paystack secret key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1085,1,'en','web','paystack.pk','Paystack public key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1086,1,'en','web','from.order','from','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1087,1,'en','web','change.status','Change status','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1088,1,'en','web','documents','Documents','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1089,1,'en','web','date','Date','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1090,1,'en','web','document','Document','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1091,1,'en','web','delivery.reciept','Delivery reciept','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1092,1,'en','web','registration.date','Registration date','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1093,1,'en','web','messages','Messages','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1094,1,'en','web','created.date.&.time','Created date & time','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1095,1,'en','web','overview','Overview','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1096,1,'en','web','catalog','Catalog','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1097,1,'en','web','tickets','Tickets','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1098,1,'en','web','settings.general','General settings','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1099,1,'en','web','backup','Backup','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1100,1,'en','web','branch','Branch','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1101,1,'en','web','stores','Stores','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1102,1,'en','web','invites','Invites','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1103,1,'en','web','faqs','FAQs','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1104,1,'en','web','paid','Paid','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1105,1,'en','web','product.review','Product review','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1106,1,'en','web','order.review','Order review','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1107,1,'en','web','order.reviews','Order reviews','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1108,1,'en','web','order.id','Order ID','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1109,1,'en','web','comment','Comment','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1110,1,'en','web','product.id','Product ID','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1111,1,'en','web','update','Update','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1112,1,'en','web','update.database','Update database','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1113,1,'en','web','my.shop','My shop','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1114,1,'en','web','coupons','Coupons','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1115,1,'en','web','discounts','Discounts','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1116,1,'en','web','shop.users','Shop users','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1117,1,'en','web','delete.restaurant','Delete restaurant','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1118,1,'en','web','add.restaurant','Add restaurant','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1119,1,'en','web','edit.restaurant','Edit restaurant','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1120,1,'en','web','shop.categories','Shop/Restaurant categories','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1121,1,'en','web','equal','Equal','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1122,1,'en','web','recomention','Recomention','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1123,1,'en','web','recomention.zone','Recomention zone','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1124,1,'en','web','recomention.tables','Recomention tables','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1125,1,'en','web','order.management','Order management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1126,1,'en','web','restaurant.management','Restaurant management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1127,1,'en','web','report.management','Report management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1128,1,'en','web','food.management','Food management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1129,1,'en','web','customer.management','Customer management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1130,1,'en','web','deliveryman.management','Deliveryman management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1131,1,'en','web','content.management','Content management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1132,1,'en','web','transaction.management','Transaction management','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1133,1,'en','web','food.report','Food report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1134,1,'en','web','order.report','Order report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1135,1,'en','web','stock.report','Stock report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1136,1,'en','web','category.report','Category report','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1137,1,'en','web','add.food','Add food','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1138,1,'en','web','delete.food','Are you sure to delete this food?','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1139,1,'en','web','set.active.food','Are you sure to set active this food?','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1140,1,'en','web','edit.food','Edit food','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1141,1,'en','web','food.extras','Food extras','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1142,1,'en','web','categorys','Categorys','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1143,1,'en','web','brand','Brand','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1144,1,'en','web','product','Product','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1145,1,'en','web','extra','Extra','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1146,1,'en','web','title','Title','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1147,1,'en','web','type','Type','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1148,1,'en','web','extra.groups','Extra groups','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1149,1,'en','web','text','Text','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1150,1,'en','web','image','Image','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1151,1,'en','web','value','Value','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1152,1,'en','web','reject','Reject','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1153,1,'en','web','question','Question','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1154,1,'en','web','en','English','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1155,1,'en','web','de','Deutsch','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1156,1,'en','web','ru','Русский','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1157,1,'en','web','month','Month','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1158,1,'en','web','minute','Minute','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1159,1,'en','web','day','Day','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1160,1,'en','web','result','Result','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1161,1,'en','web','select','Select','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1162,1,'en','web','project.settings','Project settings','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1163,1,'en','web','commission','Commission','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1164,1,'en','web','favicon','Favicon','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1165,1,'en','web','map','Map','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1166,1,'en','web','config','Config','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1167,1,'en','web','google.map.key','Google map key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1168,1,'en','web','google.firebase.key','Google firebase key','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1169,1,'en','web','multi.seller','Multi seller','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1170,1,'en','web','multi.shop','Multi shop','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1171,1,'en','web','single.seller','Single seller','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1172,1,'en','web','status','Status','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1173,1,'en','web','edited','Edited','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1174,1,'en','web','approved','Approved','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1175,1,'en','web','rejected','Rejected','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1176,1,'en','web','open','Open','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1177,1,'en','web','completed','Completed','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1178,1,'en','web','progress','Progress','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1179,1,'en','web','standard','Standard','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1180,1,'en','web','express','Express','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1181,1,'en','web','free','Free','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1182,1,'en','web','processed','Processed','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1183,1,'en','web','admin','Admin','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1184,1,'en','web','seller','Seller','2024-12-30 00:58:33','2024-12-30 00:58:33'),(1185,1,'en','web','manager','Manager','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1186,1,'en','web','moderator','Moderator','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1187,1,'en','web','deliverymans','Deliverymans','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1188,1,'en','web','user.id','User ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1189,1,'en','web','client','Client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1190,1,'en','web','client.add','Add new client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1191,1,'en','web','firstname','First name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1192,1,'en','web','lastname','Last name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1193,1,'en','web','role','Role','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1194,1,'en','web','options','Options','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1195,1,'en','web','gender','Gender','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1196,1,'en','web','birthday','Birthday','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1197,1,'en','web','phone','Phone','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1198,1,'en','web','currency','Currency','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1199,1,'en','web','client.title','Client title','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1200,1,'en','web','secret.title','Secret title','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1201,1,'en','web','client.id','Client ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1202,1,'en','web','secret.id','Secret ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1203,1,'en','web','fullname','Full name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1204,1,'en','web','topup.wallet','Topup wallet','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1205,1,'en','web','user.settings','User settings','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1206,1,'en','web','created.by','Created by','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1207,1,'en','web','shop.id','Shop ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1208,1,'en','web','shop.name','Shop name','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1209,1,'en','web','shop.logo','Shop logo','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1210,1,'en','web','shop.phone','Shop phone','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1211,1,'en','web','shop.open_close.time','Shop open & close time','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1212,1,'en','web','shop.tax','Shop tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1213,1,'en','web','open_close.time','Open & close time','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1214,1,'en','web','logo','Logo','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1215,1,'en','web','background','Background','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1216,1,'en','web','payment.type','Payment type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1217,1,'en','web','terminal','Terminal','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1218,1,'en','web','amount','Amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1219,1,'en','web','created.at','Created at','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1220,1,'en','web','number.of.products','Number of products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1221,1,'en','web','customer.details','Customer details','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1222,1,'en','web','clear.all','Clear all','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1223,1,'en','web','sub.total','Sub total','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1224,1,'en','web','total.amount','Total amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1225,1,'en','web','place.order','Place order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1226,1,'en','web','bag','Bag','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1227,1,'en','web','shipping.info','Shipping information','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1228,1,'en','web','payment.status','Payment status','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1229,1,'en','web','coupon','Coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1230,1,'en','web','check.coupon','Check coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1231,1,'en','web','new.order','New order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1232,1,'en','web','order.details','Order details','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1233,1,'en','web','order.tax','Order tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1234,1,'en','web','product.tax','Product tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1235,1,'en','web','view.order','View order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1236,1,'en','web','cancelled.orders','Cancelled orders','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1237,1,'en','web','delivered.orders','Delivered orders','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1238,1,'en','web','out.of.stock.products','Out of stock products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1239,1,'en','web','total.products','Total products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1240,1,'en','web','total.earned','Total earned','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1241,1,'en','web','delivery.earning','Delivery earning','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1242,1,'en','web','total.order.tax','Total order tax','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1243,1,'en','web','total.comission','Total comission','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1244,1,'en','web','last.30.days','Last 30 days','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1245,1,'en','web','this.month','This month','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1246,1,'en','web','this.week','This week','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1247,1,'en','web','this.year','This year','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1248,1,'en','web','total.orders.count','Total orders count','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1249,1,'en','web','top.customers','Top customers','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1250,1,'en','web','top.selled.products','Top selled products','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1251,1,'en','web','sales','Sales','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1252,1,'en','web','total.sales.amount','Total sales amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1253,1,'en','web','delivery.date','Delivery date','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1254,1,'en','web','delivery.time','Delivery time','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1255,1,'en','web','delivery.type','Delivery type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1256,1,'en','web','delivery.fee','Delivery fee','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1257,1,'en','web','transaction.id','Transaction ID','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1258,1,'en','web','price','Price','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1259,1,'en','web','status.description','Status description','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1260,1,'en','web','note','Note','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1261,1,'en','web','up.to','up to','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1262,1,'en','web','edit.subscriber','Edit Subscriber','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1263,1,'en','web','newsletter.content','Newsletter content','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1264,1,'en','web','clone.notification','Clone Notification','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1265,1,'en','web','edit.email.provider','Edit email provider','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1266,1,'en','web','app_store_button_link','App store button link','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1267,1,'en','web','google_play_button_link','Google play button link','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1268,1,'en','web','from_site','From Site','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1269,1,'en','web','from.to','From to','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1270,1,'en','web','twilio_account_id','Twilio account id','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1271,1,'en','web','twilio_auth_token','Twilio auth token','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1272,1,'en','web','twilio_number','Twilio number','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1273,1,'en','web','add.sms.gateway','Add sms gateway','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1274,1,'en','web','error','Error','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1275,1,'en','web','by.subscription','By Subscription','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1276,1,'en','web','bar.code','Barcode','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1277,1,'en','web','edit.cashback','Edit Cashback','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1278,1,'en','web','delete.selected','Delete selected','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1279,1,'en','web','change.user.role','Change user role','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1280,1,'en','web','change.language','Change language','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1281,1,'en','web','order.amount','Order amount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1282,1,'en','web','add.extra.group','Add extra group','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1283,1,'en','web','add.extra','Add extra','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1284,1,'en','web','add.shop','Add shop','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1285,1,'en','web','add.order','Add order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1286,1,'en','web','add.faq','Add FAQ','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1287,1,'en','web','add.delivery','Add delivery','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1288,1,'en','web','add.deliveryman','Add deliveryman','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1289,1,'en','web','add.product','Add product','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1290,1,'en','web','add.category','Add category','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1291,1,'en','web','add.brand','Add brand','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1292,1,'en','web','add.unit','Add unit','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1293,1,'en','web','add.banner','Add banner','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1294,1,'en','web','add.ticket','Add ticket','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1295,1,'en','web','add.notification','Add notification','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1296,1,'en','web','add.client','Add client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1297,1,'en','web','add.address','Add address','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1298,1,'en','web','add.blog','Add blog','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1299,1,'en','web','add.language','Add language','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1300,1,'en','web','add.currency','Add currency','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1301,1,'en','web','add.translation','Add translation','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1302,1,'en','web','add.coupon','Add coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1303,1,'en','web','add.discount','Add discount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1304,1,'en','web','edit','Edit','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1305,1,'en','web','edit.extra.group','Edit extra group','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1306,1,'en','web','edit.extra','Edit extra','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1307,1,'en','web','edit.payment','Edit payment','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1308,1,'en','web','edit.faq','Edit FAQ','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1309,1,'en','web','edit.user','Edit user','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1310,1,'en','web','edit.order','Edit order','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1311,1,'en','web','edit.delivery','Edit delivery','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1312,1,'en','web','edit.deliveryman','Edit deliveryman','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1313,1,'en','web','edit.shop','Edit shop','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1314,1,'en','web','edit.product','Edit product','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1315,1,'en','web','edit.category','Edit category','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1316,1,'en','web','edit.brand','Edit brand','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1317,1,'en','web','edit.unit','Edit unit','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1318,1,'en','web','edit.banner','Edit banner','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1319,1,'en','web','edit.ticket','Edit ticket','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1320,1,'en','web','edit.notification','Edit notification','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1321,1,'en','web','edit.client','Edit client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1322,1,'en','web','edit.blog','Edit blog','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1323,1,'en','web','edit.language','Edit language','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1324,1,'en','web','edit.currency','Edit currency','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1325,1,'en','web','edit.translation','Edit translation','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1326,1,'en','web','edit.coupon','Edit coupon','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1327,1,'en','web','edit.discount','Edit discount','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1328,1,'en','web','please.select.client','Please, select client','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1329,1,'en','web','please.select.client.address','Please, select client address','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1330,1,'en','web','please.select.payment.type','Please, select payment type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1331,1,'en','web','select.extra.type','Select extra type','2024-12-30 00:58:34','2024-12-30 00:58:34'),(1332,1,'en','web','select.extra.group','Select extra group','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1333,1,'en','web','select.payment.type','Select payment type','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1334,1,'en','web','select.address','Select address','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1335,1,'en','web','select.currency','Select currency','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1336,1,'en','web','select.client','Select client','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1337,1,'en','web','select.shop','Select shop','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1338,1,'en','web','select.category','Select category','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1339,1,'en','web','select.brand','Select brand','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1340,1,'en','web','select.group','Select group','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1341,1,'en','web','select.role','Select role','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1342,1,'en','web','deliveryman.order.acceptance.time','Deliveryman order acceptance time','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1343,1,'en','web','do.you.really.want.to.clear.the.cash?','Do you really want to clear the cache?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1344,1,'en','web','clear.cash','Clear cache','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1345,1,'en','web','backup.loading','Please wait a little while it takes time','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1346,1,'en','web','delivery.boy','Delivery boy','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1347,1,'en','web','customer.info','Customer info','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1348,1,'en','web','Welcome.to.Dashboard!','Welcome to Dashboard!','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1349,1,'en','web','edit.branch','Edit branch','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1350,1,'en','web','add.branch','Add branch','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1351,1,'en','web','show.locations','Show locations on Map','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1352,1,'en','web','not.equal','Not equal','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1353,1,'en','web','report','Report','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1354,1,'en','web','my.restaurant','My restaurant','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1355,1,'en','web','delivery.zone','Delivery zone','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1356,1,'en','web','in.progress.orders','In progress orders','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1357,1,'en','web','refund.details','Refund details','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1358,1,'en','web','welcome.manager','welcome manager','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1359,1,'en','web','get.started','Get started','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1360,1,'en','web','restaurant.closed.days','Restaurant closed days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1361,1,'en','web','restaurant.working.days','Restaurant working days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1362,1,'en','web','shop.closed.days','Shop closed days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1363,1,'en','web','shop.working.days','Shop working days','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1364,1,'en','web','order.created.successfully','Order was successfully created','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1365,1,'en','web','restaurant.edit','Restaurants edit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1366,1,'en','web','please.select.delivery','Place select delivery','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1367,1,'en','web','please.select.address','Please, select address','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1368,1,'en','web','please.select.currency','Place select currency','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1369,1,'en','web','shop.closed','Shop is closed','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1370,1,'en','web','edit.bonus','Edit bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1371,1,'en','web','edit.story','Edit story','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1372,1,'en','web','shop.edit','Shop edit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1373,1,'en','web','edit.profile','Edit profile','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1374,1,'en','web','add.brands','Add brands','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1375,1,'en','web','min.price','Min price of delivery','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1376,1,'en','web','price.per.km','Price per km','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1377,1,'en','web','add.payment','Add payment','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1378,1,'en','web','payment','Payment','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1379,1,'en','web','set.active.delivery','Are you sure to set active this delivery?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1380,1,'en','web','email.setting.id','Email settings id','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1381,1,'en','web','unpublished','Unpublished','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1382,1,'en','web','pending','Pending','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1383,1,'en','web','published','Published','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1384,1,'en','web','page.not.found','Page not found','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1385,1,'en','web','go.back','Go back','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1386,1,'en','web','send.to','Send to','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1387,1,'en','web','body','Body','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1388,1,'en','web','alt.body','Alt body','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1389,1,'en','web','verify','Verify','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1390,1,'en','web','subscribe','Subscribe','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1391,1,'en','web','email.settings','Email settings','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1392,1,'en','web','add.cashback','Add cashback','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1393,1,'en','web','all.delete','Are you sure you want to delete all products?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1394,1,'en','web','select.the.product','Select the product you want to delete','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1395,1,'en','web','extra.group.value','Extra group value','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1396,1,'en','web','not.subscriber','Not subscriber','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1397,1,'en','web','add.subciribed','Add subciribed','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1398,1,'en','web','filter.result','Filter result','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1399,1,'en','web','add.subscriber','Add subscriber','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1400,1,'en','web','delete.all','Delete all','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1401,1,'en','web','bonus.stock.quantity','Bonus product quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1402,1,'en','web','products.stock','Products stock','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1403,1,'en','web','shop.bonus','Shop bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1404,1,'en','web','product.bonus','Product bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1405,1,'en','web','add.bonus','Add bonus','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1406,1,'en','web','product.quantity','Product quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1407,1,'en','web','enter.extra.value','Enter extra value','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1408,1,'en','web','logo.image','Logo image','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1409,1,'en','web','background.image','Background image','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1410,1,'en','web','status.note','Status note','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1411,1,'en','web','visibility','Visibility','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1412,1,'en','web','general','General','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1413,1,'en','web','shop.working.hours','Shop working hours','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1414,1,'en','web','open.hours','Open hours','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1415,1,'en','web','close.hours','Close hours','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1416,1,'en','web','order.info','Order info','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1417,1,'en','web','min.amount','Min amount','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1418,1,'en','web','admin.comission','Admin comission','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1419,1,'en','web','withdraw','Withdraw','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1420,1,'en','web','withdraw.request','Withdraw request','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1421,1,'en','web','submit','Submit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1422,1,'en','web','payout.status','Payout status','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1423,1,'en','web','pay.to.seller','Pay to seller','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1424,1,'en','web','requested.amount','Requested amount','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1425,1,'en','web','pay','Pay','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1426,1,'en','web','upload','Upload','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1427,1,'en','web','export','Export','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1428,1,'en','web','product.extras','Product extras','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1429,1,'en','web','product.property','Product property','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1430,1,'en','web','food.property','Food property','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1431,1,'en','web','finish','Finish','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1432,1,'en','web','unit','Unit','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1433,1,'en','web','min.qty','Min qty','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1434,1,'en','web','max.qty','Max qty','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1435,1,'en','web','images','Images','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1436,1,'en','web','prev','Prev','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1437,1,'en','web','key','Key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1438,1,'en','web','min.quantity','Min quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1439,1,'en','web','max.quantity','Max quantity','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1440,1,'en','web','product.info','Product info','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1441,1,'en','web','child.categories','Child categories','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1442,1,'en','web','keywords','Keywords','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1443,1,'en','web','parent.category','Parent category','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1444,1,'en','web','position','Position','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1445,1,'en','web','delivery.date.&.time','Delivery date & time','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1446,1,'en','web','product.total','Product total','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1447,1,'en','web','order.total','Order total','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1448,1,'en','web','url','Url','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1449,1,'en','web','ask.for.question','Ask for question','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1450,1,'en','web','subject','Subject','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1451,1,'en','web','update.status','Update status','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1452,1,'en','web','ticket','Ticket','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1453,1,'en','web','answered','Answered','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1454,1,'en','web','closed','Closed','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1455,1,'en','web','published.at','Published at','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1456,1,'en','web','publish','Publish','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1457,1,'en','web','avatar','Avatar','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1458,1,'en','web','password.confirmation','Password confirmation','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1459,1,'en','web','short.description','Short description','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1460,1,'en','web','symbol','Symbol','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1461,1,'en','web','rate','Rate','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1462,1,'en','web','group','Group','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1463,1,'en','web','web','Web','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1464,1,'en','web','mobile','Mobile','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1465,1,'en','web','errors','Errors','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1466,1,'en','web','do.you.care.about.your.data','Do you care about your data?','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1467,1,'en','web','here.you.can.take.backup.from.database','Here you can take backup from database.','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1468,1,'en','web','download.backup','Download backup','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1469,1,'en','web','sms.gateway','Sms gateway','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1470,1,'en','web','firebase.config','Firebase config','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1471,1,'en','web','api.key','API key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1472,1,'en','web','server.key','Server key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1473,1,'en','web','vapid.key','VAPID key','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1474,1,'en','web','auth.domain','Auth domain','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1475,1,'en','web','project.id','Project ID','2024-12-30 00:58:35','2024-12-30 00:58:35'),(1476,1,'en','web','storage.bucket','Storage bucket','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1477,1,'en','web','messaging.sender.id','Messaging sender ID','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1478,1,'en','web','app.id','App ID','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1479,1,'en','web','measurement.id','Measurement ID','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1480,1,'en','web','leave.site','Do you really want to leave the site?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1481,1,'en','web','translation','Translation','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1482,1,'en','web','you.cannot.order.more.than','You cannot order more than','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1483,1,'en','web','selected','Selected','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1484,1,'en','web','successfully.closed','Successfully closed','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1485,1,'en','web','required','Required','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1486,1,'en','web','required.field','Required field','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1487,1,'en','web','back','Back','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1488,1,'en','web','print','Print','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1489,1,'en','web','invoice','Invoice','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1490,1,'en','web','sub-total.amount','Sub - total amount','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1491,1,'en','web','delivery.price','Delivery price','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1492,1,'en','web','grand.total','Grand total','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1493,1,'en','web','copied.to.clipboard','Copied to clipboard','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1494,1,'en','web','shop.address','Shop address','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1495,1,'en','web','open.close.time','Open & close time','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1496,1,'en','web','invitation.link','Invitation link','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1497,1,'en','web','copy.invitation.link','Copy invitation link','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1498,1,'en','web','product.name','Product name','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1499,1,'en','web','total.price','Total price','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1500,1,'en','web','expired.at','Expired at','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1501,1,'en','web','fix','Fix','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1502,1,'en','web','percent','Percent','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1503,1,'en','web','start.date','Start date','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1504,1,'en','web','end.date','End date','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1505,1,'en','web','accept.invite','Accept invite','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1506,1,'en','web','from.day','From day','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1507,1,'en','web','to.day','To day','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1508,1,'en','web','password.do.not.match','The passwords do not match!','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1509,1,'en','web','male','Male','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1510,1,'en','web','female','Female','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1511,1,'en','web','footer.text','Footer text','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1512,1,'en','web','cannot.work.demo','You cannot use it in demo mode!','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1513,1,'en','web','purchase.subscription','Purchase subscription','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1514,1,'en','web','purchase','Purchase','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1515,1,'en','web','your.current.subscription','Your current subscription','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1516,1,'en','web','will.expire.at','will expire at','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1517,1,'en','web','subscription','Subscription','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1518,1,'en','web','insufficient.balance','Insufficient balance','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1519,1,'en','web','footer','Footer','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1520,1,'en','web','hours.ago','hours ago','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1521,1,'en','web','minutes.ago','minutes ago','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1522,1,'en','web','last.activity','Last activity','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1523,1,'en','web','active.orders','Active orders','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1524,1,'en','web','distance','Distance','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1525,1,'en','web','driver.information','Driver information','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1526,1,'en','web','vehicle','Vehicle','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1527,1,'en','web','fuel','Fuel','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1528,1,'en','web','customer.information','Customer information','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1529,1,'en','web','successfully.created','Successfully created','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1530,1,'en','web','successfully.updated','Successfully updated','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1531,1,'en','web','successfully.published','Successfully published','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1532,1,'en','web','successfully.deleted','Successfully deleted','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1533,1,'en','web','successfully.purchased','Successfully purchased','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1534,1,'en','web','successfully.added','Successfully added','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1535,1,'en','web','publish.notification','Publish notification','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1536,1,'en','web','publish.blog','Publish blog','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1537,1,'en','web','change.default.language','Change default language','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1538,1,'en','web','choose.discount.date','Choose discount date','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1539,1,'en','web','reject.invite','Are you sure to reject this invite?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1540,1,'en','web','set.active.product','Are you sure to set active this product?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1541,1,'en','web','set.active.unit','Are you sure to set active this unit?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1542,1,'en','web','set.active.banner','Are you sure to set active this banner?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1543,1,'en','web','set.active.notification','Are you sure to set active this notification?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1544,1,'en','web','set.active.blog','Are you sure to set active this blog?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1545,1,'en','web','set.active.payment','Are you sure to set active this payment?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1546,1,'en','web','set.active.sms.gateway','Are you sure to set active this sms gateway?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1547,1,'en','web','set.active.faq','Are you sure to set active this FAQ?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1548,1,'en','web','set.active.discount','Are you sure to set active this discount?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1549,1,'en','web','set.active.order.status','Are you sure to set active this order status?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1550,1,'en','web','set.active.email.provider','Are you sure to set active this email provider?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1551,1,'en','web','set.active.cashback','Are you sure to set active this cashback?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1552,1,'en','web','order_amount','Order amount','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1553,1,'en','web','clone.product','Product clone','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1554,1,'en','web','category.clone','Category clone','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1555,1,'en','web','recipe.category.clone','Recipe category clone','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1556,1,'en','web','delete.shop','Are you sure to delete this shop?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1557,1,'en','web','delete.product','Are you sure to delete this product?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1558,1,'en','web','delete.extra.group','Are you sure to delete this extra group?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1559,1,'en','web','delete.extra','Are you sure to delete this extra?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1560,1,'en','web','delete.category','Are you sure to delete this category?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1561,1,'en','web','delete.brand','Are you sure to delete this brand?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1562,1,'en','web','delete.banner','Are you sure to delete this banner?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1563,1,'en','web','delete.review','Are you sure to delete this review?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1564,1,'en','web','delete.notification','Are you sure to delete this notification?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1565,1,'en','web','delete.blog','Are you sure to delete this blog?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1566,1,'en','web','delete.language','Are you sure to delete this language?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1567,1,'en','web','delete.currency','Are you sure to delete this currency?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1568,1,'en','web','delete.faq','Are you sure to delete this FAQ?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1569,1,'en','web','delete.coupon','Are you sure to delete this coupon?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1570,1,'en','web','delete.discount','Are you sure to delete this discount?','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1571,1,'en','web','spent.since.registration','Spent since registration','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1572,1,'en','web','user.info','User information','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1573,1,'en','web','ordered.products','Ordered products','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1574,1,'en','web','successfull.orders','Successfull orders','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1575,1,'en','web','order.refunds','Order refunds','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1576,1,'en','web','create.payout','Create payout','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1577,1,'en','web','select.seller','Select seller','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1578,1,'en','web','paypal.sandbox.client.id','Paypal sandbox client id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1579,1,'en','web','paypal.sandbox.client.secret','Paypal sandbox client secret','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1580,1,'en','web','paypal.sandbox.app.id','Paypal sandbox app id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1581,1,'en','web','paypal.live.client.id','Paypal live client id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1582,1,'en','web','paypal.live.client.secret','Paypal live client secret','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1583,1,'en','web','paypal.live.app.id','Paypal live app id','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1584,1,'en','web','paypal.payment.action','Paypal payment action','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1585,1,'en','web','paypal.currency','Paypal currency','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1586,1,'en','web','paypal.locale','Paypal locale','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1587,1,'en','web','paypal.validate.ssl','Paypal validate ssl','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1588,1,'en','web','stripe.pk','Stripe public key','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1589,1,'en','web','stripe.sk','Stripe secret key','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1590,1,'en','web','razorpay.key','Razorpay key','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1591,1,'en','web','razorpay.secret','Razorpay secret','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1592,1,'en','web','boxes','Boxes','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1593,1,'en','web','add.box','Add box','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1594,1,'en','web','edit.box','Edit box','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1595,1,'en','web','add.nutrition','Add nutrition','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1596,1,'en','web','group.order','Group order','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1597,1,'de','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1598,1,'es','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1599,1,'fa','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1600,1,'en','web','old_password','Old Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1601,1,'de','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1602,1,'es','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1603,1,'fa','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1604,1,'en','web','personal_pincode','Personal Pincode','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1605,1,'de','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1606,1,'es','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1607,1,'fa','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1608,1,'en','web','new_password','New Password','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1609,1,'de','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1610,1,'es','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1611,1,'fa','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1612,1,'en','web','type_something','Type Something','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1613,1,'de','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1614,1,'es','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1615,1,'fa','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1616,1,'en','web','date_of_birth','Date of Birth','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1617,1,'de','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1618,1,'es','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1619,1,'fa','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1620,1,'en','web','go_to_home','Click to go back homepage','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1621,1,'de','web','home_page','Home page','2024-12-30 00:58:36','2024-12-30 00:58:36'),(1622,1,'es','web','home_page','Home page','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1623,1,'fa','web','home_page','Home page','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1624,1,'en','web','home_page','Home page','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1625,1,'de','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1626,1,'es','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1627,1,'fa','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1628,1,'en','web','succesfully_edited_profile','You have edited your profile!','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1629,1,'hu','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1630,1,'de','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1631,1,'es','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1632,1,'fa','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1633,1,'en','web','enter_pin_code','Enter your personal pincode','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1634,1,'hu','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1635,1,'de','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1636,1,'es','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1637,1,'fa','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1638,1,'en','web','enter_pin_code_error','Personal pincode is incorrect','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1639,1,'hu','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1640,1,'de','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1641,1,'es','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1642,1,'fa','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1643,1,'en','web','pin_code_desc','POS Improve your business by enhance your guest experience and restaurant business operations','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1644,1,'hu','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1645,1,'de','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1646,1,'es','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1647,1,'fa','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1648,1,'en','web','empty_orders','Empty orders','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1649,1,'hu','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1650,1,'de','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1651,1,'es','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1652,1,'fa','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1653,1,'en','web','payment_type','Payment','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1654,1,'hu','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1655,1,'de','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1656,1,'es','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1657,1,'fa','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1658,1,'en','web','product_count','Count','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1659,1,'hu','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1660,1,'de','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1661,1,'es','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1662,1,'fa','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1663,1,'en','web','order_time','Order Time','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1664,1,'de','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1665,1,'es','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1666,1,'fa','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1667,1,'en','web','confirm_new_password','Confirm new password','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1668,1,'hu','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1669,1,'de','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1670,1,'es','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1671,1,'fa','web','refund','refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1672,1,'en','web','refund','Refund','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1673,1,'hu','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1674,1,'de','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1675,1,'es','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1676,1,'fa','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1677,1,'ar','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1678,1,'en','web','shipping_information','Shipping information','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1679,1,'hu','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1680,1,'de','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1681,1,'es','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1682,1,'fa','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1683,1,'ar','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1684,1,'en','web','take_away','Take away','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1685,1,'hu','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1686,1,'de','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1687,1,'es','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1688,1,'fa','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1689,1,'ar','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1690,1,'en','web','dine','Dine-In','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1691,1,'hu','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1692,1,'de','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1693,1,'es','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1694,1,'fa','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1695,1,'ar','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1696,1,'en','web','composition_order','Composition order','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1697,1,'hu','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1698,1,'de','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1699,1,'es','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1700,1,'fa','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1701,1,'ar','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1702,1,'en','web','product_name','Product name','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1703,1,'hu','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1704,1,'de','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1705,1,'es','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1706,1,'fa','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1707,1,'ar','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1708,1,'en','web','total_price','Total price','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1709,1,'hu','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1710,1,'de','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1711,1,'es','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1712,1,'fa','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1713,1,'ar','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1714,1,'en','web','status_ready','You can attach the driver when the order status is ready','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1715,1,'hu','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1716,1,'de','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1717,1,'es','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1718,1,'fa','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1719,1,'ar','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1720,1,'en','web','type_pickup','Because it is an order type pickup, it is not possible to attach a driver','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1721,1,'hu','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1722,1,'de','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1723,1,'es','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1724,1,'fa','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1725,1,'ar','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1726,1,'en','web','not_assigned','There is no driver attached to this order yet','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1727,1,'hu','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1728,1,'de','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1729,1,'es','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1730,1,'fa','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1731,1,'ar','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1732,1,'en','web','in_stock','In stock','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1733,1,'hu','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1734,1,'de','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1735,1,'es','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1736,1,'fa','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1737,1,'ar','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1738,1,'en','web','pin_code_desc_error','You entered the pin code incorrectly, please try again','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1739,1,'hu','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1740,1,'de','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1741,1,'es','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1742,1,'fa','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1743,1,'ar','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1744,1,'en','web','change_status','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1745,1,'hu','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1746,1,'de','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1747,1,'es','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1748,1,'fa','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1749,1,'ar','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1750,1,'en','web','status_changed','Change Status','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1751,1,'hu','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1752,1,'de','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1753,1,'es','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1754,1,'fa','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1755,1,'ar','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1756,1,'en','web','are_you_sure_change','Are you sure you want to change the status of the order to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1757,1,'en','mobile','عربي','AR','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1758,1,'ar','mobile','all_restaurants','كل المطاعم','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1759,1,'en','mobile','all_restaurants','كل المطاعم','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1760,1,'ar','mobile','all_previously_added','الكل_السابق_الإضافات','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1761,1,'en','mobile','all_previously_added','All previously added products will be removed from the cart. Do you continue ?','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1762,1,'ar','mobile','continue','اكمل','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1763,1,'en','mobile','continue','Continue','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1764,1,'ar','mobile','we_are_send_OTP_code_to','نحن سوف نرسل لك كود الي رقم','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1765,1,'en','mobile','we_are_send_OTP_code_to','We are send OTP code to','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1766,1,'ar','mobile','send_new','ارسال جديد','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1767,1,'en','mobile','send_new','Send new','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1768,1,'ar','mobile','reset_password_text','استعاده كلمه السر','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1769,1,'en','mobile','reset_password_text','Please provide your email address and we`ll send you code on how to change your password.','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1770,1,'ar','mobile','you_really_want_to_clear_the_card','هل تريد فعلا مسح السله؟','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1771,1,'en','mobile','you_really_want_to_clear_the_card','You really want to clear the Card','2024-12-30 00:58:37','2024-12-30 00:58:37'),(1772,1,'ar','mobile','start_group_order','ابدا مجموع الاوردر','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1773,1,'en','mobile','start_group_order','Start group order','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1774,1,'ar','mobile','start','أبدا','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1775,1,'en','web','start','Start','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1776,1,'ar','mobile','manage_order','إدارة_الطلب','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1777,1,'en','mobile','manage_order','Manage order','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1778,1,'ar','mobile','group_member','عضو الجروب','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1779,1,'en','mobile','group_member','Group member','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1780,1,'ar','mobile','add_new_card','اضافه كارت جديد','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1781,1,'en','mobile','add_new_card','Add new card','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1782,1,'ar','mobile','card_number','رقم الكارت','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1783,1,'en','mobile','card_number','Card number','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1784,1,'ar','mobile','expired_date','تاريخ الانتهاء','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1785,1,'en','mobile','expired_date','Expired date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1786,1,'ar','mobile','CVC','الرمز الخلفي','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1787,1,'en','mobile','CVC','CVC','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1788,1,'ar','mobile','do_you_want_to_delete_it','هل تريد مسح هذا ؟','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1789,1,'en','mobile','do_you_want_to_delete_it','Do you want to delete it?','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1790,1,'ar','mobile','Comment','تعليق','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1791,1,'en','mobile','Comment','Comment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1792,1,'ar','mobile','continue_to_payment','المتابعه الي الدفع','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1793,1,'en','mobile','continue_to_payment','Continue to payment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1794,1,'ar','mobile','successfully_updated1','تم التحديث بنجاح','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1795,1,'en','mobile','successfully_updated1','Успешо обновлен1','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1796,1,'ar','web','ok','حسنا','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1797,1,'en','web','ok','Ok','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1798,1,'ar','web','payable_amount','المبلغ المستحق','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1799,1,'en','web','payable_amount','Payable Amount','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1800,1,'ar','web','confirm_order','تاكيد الاوردر','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1801,1,'en','web','confirm_order','Confirm Payment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1802,1,'ar','web','total_item','جميع المنتجات','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1803,1,'en','web','total_item','Total item','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1804,1,'ar','web','recent_customers','العملاء الجدد','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1805,1,'en','web','recent_customers','Recent Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1806,1,'ar','web','add_customer','اضافه عميل','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1807,1,'en','web','add_customer','Add Customer','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1808,1,'ar','web','customers','العملاء','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1809,1,'en','web','customers','Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1810,1,'ar','web','remove','مسح','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1811,1,'en','web','remove','Remove','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1812,1,'ar','web','are_you_sure_change1','هل انت متاكد من التغيير','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1813,1,'en','web','are_you_sure_change1','Are you sure you want to change the status of the order to','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1814,1,'ar','web','select_payment','اختار الدفع','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1815,1,'en','web','select_payment','Select payment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1816,1,'ar','web','select_currency','اختار العمله','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1817,1,'en','web','select_currency','Select currency','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1818,1,'ar','web','select_address','العنوان','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1819,1,'en','web','select_address','Address','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1820,1,'ar','web','select_user','حدد العميل','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1821,1,'en','web','select_user','Select client','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1822,1,'ar','web','there_are_no_items_in_the','لا توجد عناصر في','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1823,1,'en','web','there_are_no_items_in_the','There are no items in the','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1824,1,'ar','web','thank_you','شكرا لك!','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1825,1,'en','web','thank_you','Thank you!','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1826,1,'ar','web','shop_name','اسم المتجر','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1827,1,'en','web','shop_name','Shop name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1828,1,'ar','web','order_summary','ملخص الطلب','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1829,1,'en','web','order_summary','Order summary','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1830,1,'ar','web','no_search_results','لا نتائج في البحث','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1831,1,'en','web','no_search_results','No search results','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1832,1,'ar','web','select_deliveryman','اختار الدلييفري','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1833,1,'en','web','select_deliveryman','Select deliveryman','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1834,1,'ar','web','on_a_way','علي الطريق','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1835,1,'en','web','on_a_way','On a way','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1836,1,'en','web','enter_new_pin_code','Enter your new pincode','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1837,1,'de','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1838,1,'es','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1839,1,'fa','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1840,1,'en','web','search_customers','Search Customers','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1841,1,'de','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1842,1,'es','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1843,1,'fa','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1844,1,'en','web','search_products','Search products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1845,1,'en','web','payment_status','Payment status','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1846,1,'en','web','search_product','Search product','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1847,1,'en','web','delivery_date','Delivery date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1848,1,'en','web','locations','Locations','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1849,1,'en','web','edit_order','Edit order','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1850,1,'en','web','download','Download','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1851,1,'en','web','delete','Delete','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1852,1,'en','web','select_client','Select client','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1853,1,'en','web','search_user','Search user','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1854,1,'en','web','view_more','View more','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1855,1,'en','web','thank_you_for_order','Thank you for order!','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1856,1,'ar','web','show_location_on_map','Show location on map','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1857,1,'en','web','show_location_on_map','Show location on map','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1858,1,'ar','web','schedulet_at','Schedulet at','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1859,1,'en','web','schedulet_at','Schedulet at','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1860,1,'ar','web','order_type','Order Type','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1861,1,'en','web','order_type','Order Type','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1862,1,'ar','web','customer_added','Customer Added Successfully','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1863,1,'en','web','customer_added','Customer Added Successfully','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1864,1,'en','web','recommended_size','jpg,png – recommended size is 10MB','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1865,1,'en','web','id','ID','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1866,1,'en','web','search_restaurant_and_products','Search restaurant and products','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1867,1,'ar','web','add_comment','Add comment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1868,1,'en','web','add_comment','Add comment','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1869,1,'ar','web','sale_history','Sale History','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1870,1,'en','web','sale_history','Sale History','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1871,1,'ar','web','cash_drawer','Cash Drawer','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1872,1,'en','web','cash_drawer','Cash Drawer','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1873,1,'ar','web','today_sale','Today’s Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1874,1,'en','web','today_sale','Today’s Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1875,1,'ar','web','enter_name','Enter your name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1876,1,'en','web','enter_name','Enter your name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1877,1,'ar','web','enter_last_name','Enter your Last name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1878,1,'en','web','enter_last_name','Enter your Last name','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1879,1,'ar','web','enter_email','Enter your email','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1880,1,'en','web','enter_email','Enter your email','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1881,1,'ar','web','enter_phone','Enter your phone','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1882,1,'en','web','enter_phone','Enter your phone','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1883,1,'ar','web','opening_drawer_amount','Opening Drawer Amount','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1884,1,'en','web','opening_drawer_amount','Opening Drawer Amount','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1885,1,'ar','web','cash_payment_sale','Cash Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1886,1,'en','web','cash_payment_sale','Cash Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1887,1,'ar','web','other_payment_sale','Other Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1888,1,'en','web','other_payment_sale','Other Payment Sale','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1889,1,'ar','web','start_end','Start Date — End Date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1890,1,'en','web','start_end','Start Date — End Date','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1891,1,'ar','web','revenue','Revenue','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1892,1,'en','web','revenue','Revenue','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1893,1,'ar','web','average','Average','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1894,1,'en','web','average','Average','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1895,1,'ar','web','sale_chart','Sales chart','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1896,1,'en','web','sale_chart','Sales chart','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1897,1,'ar','web','statistics','Statistics','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1898,1,'en','web','statistics','Statistics','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1899,1,'ar','web','active','Active','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1900,1,'en','web','active','Active','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1901,1,'ar','web','ended','Ended','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1902,1,'en','web','ended','Ended','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1903,1,'ar','web','every_large','Every large design company whether it’s a multi-national branding corporation or a regular down at heel tatty magazine publisher needs to fill holes in the workforce.','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1904,1,'en','web','every_large','Every large design company whether it’s a multi-national branding corporation or a regular down at heel tatty magazine publisher needs to fill holes in the workforce.','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1905,1,'ar','web','select_the_desired_order_history_range','Select the desired order history range','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1906,1,'en','web','select_the_desired_order_history_range','Select the desired order history range','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1907,1,'ar','web','list','List','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1908,1,'en','web','list','List','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1909,1,'ar','web','board','Board','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1910,1,'en','web','board','Board','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1911,1,'ar','web','birth','Date of Birth','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1912,1,'en','web','birth','Date of Birth','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1913,1,'ar','web','id_code','ID Code','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1914,1,'en','web','id_code','ID Code','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1915,1,'ar','web','invoice_download','Invoice download','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1916,1,'en','web','invoice_download','Invoice download','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1917,1,'ar','web','mark_all_as_read','Mark all as read','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1918,1,'en','web','mark_all_as_read','Mark all as read','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1919,1,'ar','web','see_all_notifications','See All Notifications','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1920,1,'en','web','see_all_notifications','See All Notifications','2024-12-30 00:58:38','2024-12-30 00:58:38'),(1921,1,'ar','web','need_select_product','Need select product','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1922,1,'en','web','need_select_product','Need select product','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1923,1,'ar','web','na','N/A','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1924,1,'en','web','na','NA','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1925,1,'ar','web','need_order','There was no orders during this period','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1926,1,'en','web','need_order','There was no orders during this period','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1927,1,'ar','web','search_orders','Search Orders','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1928,1,'en','web','search_orders','Search Orders','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1929,1,'ar','web','tables','Tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1930,1,'en','web','tables','Tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1931,1,'ar','web','all_tables','All tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1932,1,'en','web','all_tables','All tables','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1933,1,'ar','web','add_new_table','Add new table','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1934,1,'en','web','add_new_table','Add new table','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1935,1,'ar','web','available','Available','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1936,1,'en','web','available','Available','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1937,1,'ar','web','booked','Booked','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1938,1,'en','web','booked','Booked','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1939,1,'ar','web','occupied','Occupied','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1940,1,'en','web','occupied','Occupied','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1941,1,'ar','web','check_in','Check-in','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1942,1,'en','web','check_in','Check-in','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1943,1,'ar','web','add_address','Add address','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1944,1,'en','web','add_address','Add address','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1945,1,'ar','web','need_write','this field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1946,1,'en','web','need_write','this field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1947,1,'ar','web','two_floor','2nd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1948,1,'en','web','two_floor','2nd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1949,1,'ar','web','one_floor','1st Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1950,1,'en','web','one_floor','1st Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1951,1,'ar','web','three_floor','3rd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1952,1,'en','web','three_floor','3rd Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1953,1,'ar','web','four_floor','4th Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1954,1,'en','web','four_floor','4th Floor','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1955,1,'ar','web','field_required','This field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1956,1,'en','web','field_required','This field is required','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1957,1,'ar','web','create','Create','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1958,1,'en','web','create','Create','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1959,1,'ar','web','no_products','At the same time, restaurant products are available it\'s not. But a product for a restaurant you can add','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1960,1,'en','web','no_products','At the same time, restaurant products are available it\'s not. But a product for a restaurant you can add','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1961,1,'ar','web','withdraw_money','Withdraw money','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1962,1,'en','web','withdraw_money','Withdraw money','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1963,1,'ar','web','person_count','Person count','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1964,1,'en','web','person_count','Person count','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1965,1,'ar','web','table_name','Table name','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1966,1,'en','web','table_name','Table name','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1967,1,'ar','web','deleted','Deleted Successfully','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1968,1,'en','web','deleted','Deleted Successfully','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1969,1,'ar','web','do_you_want_to_delete_order','Do you want to delete this order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1970,1,'en','web','do_you_want_to_delete_order','Do you want to delete this order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1971,1,'ar','web','no','No','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1972,1,'en','web','no','No','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1973,1,'en','web','search.restaurants.products','Search restaurants and products','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1974,1,'en','web','search.products.in','Search products in {{shop}}','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1975,1,'en','web','sorted.by','Sorted by','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1976,1,'en','web','news.week','News of the week','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1977,1,'en','web','liked','Liked','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1978,1,'en','web','your.orders','Your orders','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1979,1,'en','web','cart.empty','Cart is empty','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1980,1,'en','web','type.here','Type here','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1981,1,'en','web','promo.code','Promo code','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1982,1,'en','web','enter','Enter','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1983,1,'en','web','service.fee','Service fee','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1984,1,'en','web','continue.payment','Continue payment','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1985,1,'en','web','more','More','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1986,1,'en','web','working.time','Working time','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1987,1,'en','web','start.group.order','Start group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1988,1,'en','web','clear.bag','Clear bag','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1989,1,'en','web','add.promocode','Add promo code','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1990,1,'en','web','sign.up','Sign up','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1991,1,'en','web','app.text','There\'s more to love in the app.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1992,1,'en','web','dont.have.account','Don\'t have an account?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1993,1,'en','web','keep.logged','Keep me logged in','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1994,1,'en','web','forgot.password','Forgot password','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1995,1,'en','web','access.quickly','or access quickly','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1996,1,'en','web','have.account','Already have an account?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1997,1,'en','web','reset.password','Reset password','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1998,1,'en','web','reset.password.text','Please provide email address and we\'ll send you code which you can change your password.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(1999,1,'en','web','enter.otp.code','Enter OTP code','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2000,1,'en','web','enter.code.text','We are send OTP code to {{phone}}','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2001,1,'en','web','send.new','Send new','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2002,1,'en','web','found.number.results','Found {{count}} results','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2003,1,'en','web','enter.delivery.address','Enter delivery address','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2004,1,'en','web','view.profile','View profile','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2005,1,'en','web','log.out','Log out','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2006,1,'en','web','profile','Profile','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2007,1,'en','web','date.of.birth','Date of birth','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2008,1,'en','web','update.password','Update password','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2009,1,'en','web','old.password','Old password','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2010,1,'en','web','choose.here','Choose here','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2011,1,'en','web','push.notifications','Push notifications','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2012,1,'en','web','on','On','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2013,1,'en','web','off','Off','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2014,1,'en','web','send.news.email','Send news email','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2015,1,'en','web','discount.notifications','Discount notifications','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2016,1,'en','web','order.verify','Order verify','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2017,1,'en','web','order.history','Order history','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2018,1,'en','web','cancelled','Cancelled','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2019,1,'en','web','support','Support','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2020,1,'en','web','repeat.order','Repeat order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2021,1,'en','web','liked.restaurants','Liked restaurants','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2022,1,'en','web','have.questions','Still have questions?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2023,1,'en','web','questions.text','Can’t find the answer you’re looking or? Please chat to our friendly team.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2024,1,'en','web','call.support','Call to support','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2025,1,'en','web','group.order.text','You fully manage the order and confirm the address. Team members can add a product from a location of your choice.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2026,1,'en','web','group.members','Group members','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2027,1,'en','web','choosing','Choosing','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2028,1,'en','web','clear.cart','Are you sure to clear the cart?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2029,1,'en','web','special.offers','Special offers','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2030,1,'en','web','free.delivery','Free delivery','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2031,1,'en','web','order.for.address','Order for this address?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2032,1,'en','web','replace.cart.prompt','You can only add items from one restaurant to your shopping cart.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2033,1,'en','web','saved','Saved','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2034,1,'en','web','passwords.dont.match','Passwords don\'t match','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2035,1,'en','web','password.should.contain','Password should contain at least 6 characters','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2036,1,'en','web','vat.tax','VAT tax','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2037,1,'en','web','cancel.order','Cancel order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2038,1,'en','web','are.you.sure.cancel.order','Are you sure to cancel this order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2039,1,'en','web','order.cancelled','Order cancelled','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2040,1,'en','web','choose.payment.method','Please, choose payment method','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2041,1,'en','web','leave.feedback','Leave feedback','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2042,1,'en','web','thanks.for.feedback','Thank you for your feedback!','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2043,1,'en','web','order.refund','Order refund','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2044,1,'en','web','why.refund','Why do you want to refund?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2045,1,'en','web','request.sent','Request sent successfully!','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2046,1,'en','web','request.not.sent','You request didn\'t send!','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2047,1,'en','web','your.comment','Your comment','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2048,1,'en','web','go.to.order','Go to order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2049,1,'en','web','manage.group.order','Manage group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2050,1,'en','web','manage.order','Manage order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2051,1,'en','web','join.group.order','Join group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2052,1,'en','web','join.group.text','You can only select products from the restaurant chosen by the creator of the group','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2053,1,'en','web','join','Join','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2054,1,'en','web','leave.group','Leave group','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2055,1,'en','web','are.you.sure.leave.group','Are you sure to leave group order?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2056,1,'en','web','you.kicked.from.group','You have been kicked from group order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2057,1,'en','web','group.order.permission','Some group members haven\'t finished making order. Are you sure to continue?','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2058,1,'en','web','see.all','See all','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2059,1,'en','web','all.shops','All shops','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2060,1,'en','web','wallet.history','Wallet history','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2061,1,'en','web','your.order','Your order','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2062,1,'en','web','your.order.status.updated.text','Your order status has been updated! Click \'Show\' to see order details.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2063,1,'en','web','help.center','Help center','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2064,1,'en','web','login.first','Please, login first','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2065,1,'en','web','add.to.bag','Add to bag','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2066,1,'en','web','be.seller','Become seller','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2067,1,'en','web','delivery.info','Delivery info','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2068,1,'en','web','seller.request.under.review','Your request to become seller is currently under review.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2069,1,'en','web','seller.request.accepted','Your request to become seller is accepted.','2024-12-30 00:58:39','2024-12-30 00:58:39'),(2070,1,'en','web','start.price','Start price','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2071,1,'en','web','no.zone.title','We don\'t deliver here yet :(','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2072,1,'en','web','no.zone.text','But we add dozens of new places every week. Maybe we\'ll be here soon! If you enter your email, we\'ll tell you as soon as we\'re available. We promise not to spam!','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2073,1,'en','web','verify.email','Email verification','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2074,1,'en','web','verify.text','Please, enter the verification code we’ve sent you to','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2075,1,'en','web','verify.didntRecieveCode','Didn’t receive the code?','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2076,1,'en','web','resend','Send again','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2077,1,'en','web','should.match','Passwords should match','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2078,1,'en','web','verify.send','Verification code send successfully','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2079,1,'en','web','email.inuse','The email has already been taken.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2080,1,'en','web','verify.error','Wrong verification code','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2081,1,'en','web','become.affiliate','Become an Affiliate','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2082,1,'en','web','blog','Blog','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2083,1,'en','web','get.helps','Get helps','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2084,1,'en','web','add.your.restaurant','Add your restaurant','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2085,1,'en','web','sign.up.to.deliver','Sign up to deliver','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2086,1,'en','web','privacy.policy','Privacy Policy','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2087,1,'en','web','tags','Tags','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2088,1,'en','web','near_you','Near you','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2089,1,'en','web','open_now','Open now','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2090,1,'en','web','copy.code','Copy code','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2091,1,'en','web','balance','Balance','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2092,1,'en','web','referrals','Referrals','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2093,1,'en','web','referral.title','{{price_from}} for you, {{price_to}} for a friend','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2094,1,'en','web','referral.text','Friends can get up to {{price_to}} off — you’ll get {{price_from}} when they place their first order.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2095,1,'en','web','no.items','No items','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2096,1,'en','web','referral.terms','Referral terms','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2097,1,'en','web','login.or.create.account','Login or create account','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2098,1,'en','web','sign.in.be.seller','Sign in to be seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2099,1,'en','web','error.400','Error occured. Please, try again later','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2100,1,'en','web','more.info','More info','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2101,1,'en','web','open.until','Open until','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2102,1,'en','web','no.orders.found','You don\'t have any orders yet','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2103,1,'en','web','no.refunds.found','You don\'t have any order refunds yet. You can create a refund request from delivered orders.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2104,1,'en','web','no.active.orders.found','No active orders','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2105,1,'en','web','no.wallet.found','You don\'t have any wallet transactions yet','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2106,1,'en','web','recent.searches','Recent searches','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2107,1,'en','web','no.liked.restaurants','You don\'t have any liked restaurants yet','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2108,1,'en','web','try.again','Try again','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2109,1,'en','web','unauthorized','Unauthorized','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2110,1,'en','web','you.cannot.join','You cannot join. Invalid group order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2111,1,'en','web','delivery.zone.not.available','Sorry, we’re not available here','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2112,1,'en','web','leave.group.prompt','You have joined in group order. In order to add product, leave group first!','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2113,1,'en','web','become.delivery','Become a delivery driver','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2114,1,'en','web','become.delivery.text','Instead of traditional food delivery jobs where the hours aren’t flexible, try being your own boss with Foodyman. Get paid to deliver on your schedule using the food delivery app most downloaded by customers.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2115,1,'en','web','only.opened','Only opened','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2116,1,'en','web','schedule','Schedule','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2117,1,'en','web','shop.closed.choose.other.day','Shop is closed in this day. Please, select another day.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2118,1,'en','web','edit.schedule','Edit schedule','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2119,1,'en','web','pickup.address','Pickup address','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2120,1,'en','web','pickup.time','Pickup time','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2121,1,'en','web','branches','Branches','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2122,1,'en','web','branches.not.found','Branches not found','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2123,1,'en','web','out.of.stock','Out of stock','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2124,1,'en','web','hour','Hour','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2125,1,'en','web','h','hour','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2126,1,'en','web','no.restaurants','Restaurants not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2127,1,'en','web','no.shops','Shops not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2128,1,'en','web','sms.not.sent','Sms not sent!','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2129,1,'en','web','email.or.phone','Email or phone','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2130,1,'en','web','login.invalid','Login or password is invalid','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2131,1,'en','web','verify.phone','Phone verification','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2132,1,'en','web','recipes','Recipes','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2133,1,'en','web','recipes.title','Recipes','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2134,1,'en','web','recipes.description','Choose your favorite food recipe and buy as you wish','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2135,1,'en','web','no.recipes','Recipes not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2136,1,'en','web','add.items.to.cart','Add {{number}} items to cart','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2137,1,'en','web','recipe.discount.condition','If you buy all ingredients you can get discount by','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2138,1,'en','web','go.to.recipe.order','Ingredients added to cart successfully.','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2139,1,'en','web','recipe.discount.definition','You got recipe discount','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2140,1,'en','web','insufficient.wallet.balance','Insufficient wallet balance','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2141,1,'en','web','go.to.admin.panel','Go to admin panel','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2142,1,'en','web','have.not.password','You have not set password yet. Please, make sure you have a password in system before you create a request for become seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2143,1,'en','web','edit.phone','Edit phone','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2144,1,'en','web','verified','Verified','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2145,1,'en','web','something.went.wrong','Something went wrong','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2146,1,'en','web','phone.required','Phone number is required','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2147,1,'en','web','no.careers.found','Careers not found according to your request','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2148,1,'en','web','welcome.title','Get your favorite foods delivered','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2149,1,'en','web','welcome.description','Choose your address and start ordering','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2150,1,'en','web','do.you.have.restaurant','Do you have a restaurant?','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2151,1,'en','web','deliver.title','Looking for delivery driver jobs?','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2152,1,'en','web','welcome.features.title','Other options for you','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2153,1,'en','web','start.ordering','Start ordering','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2154,1,'en','web','why.choose.us','Why choose us','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2155,1,'en','web','why.choose.us.first.title','Choose what you want','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2156,1,'en','web','why.choose.us.first.text','Choose what you text','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2157,1,'en','web','why.choose.us.second.title','See real-time updates','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2158,1,'en','web','why.choose.us.second.text','Personal shoppers pick items with care','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2159,1,'en','web','why.choose.us.third.title','Get your items same-day','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2160,1,'en','web','why.choose.us.third.text','Enjoy Foodyman\'s 100% quality guarantee on every order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2161,1,'en','web','choose.recomended.address','Choose recomended address','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2162,1,'en','web','place.for.ad','Place for your advertisement here','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2163,1,'en','web','people.trust.us','People trust us','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2164,1,'en','web','delivery.was.successfull','Delivery was successfull','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2165,1,'en','web','view.our.insta','View our Instagram','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2166,1,'en','web','latest.blog','Latest blog','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2167,1,'en','web','ads','Ads','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2168,1,'ar','web','there_are_no_orders','There are no orders','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2169,1,'en','web','there_are_no_orders','There are no orders','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2170,1,'ar','web','no_notification','No notifications','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2171,1,'en','web','no_notification','No notifications','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2172,1,'ar','web','order_status_changed','This order status changed','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2173,1,'en','web','order_status_changed','This order status changed','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2174,1,'ar','web','new_order','New Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2175,1,'en','web','new_order','New Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2176,1,'ar','web','confirm','Confirm','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2177,1,'en','web','confirm','Confirm','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2178,1,'ar','web','place_order','Place Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2179,1,'en','web','place_order','Place Order','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2180,1,'ar','web','seller_login','Seller login','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2181,1,'en','web','seller_login','Seller login','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2182,1,'ar','web','delivery_free','Delivery free','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2183,1,'en','web','delivery_free','Delivery free','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2184,1,'ar','web','all_galleries','All Galleries','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2185,1,'en','web','all_galleries','All Galleries','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2186,1,'ar','web','add_new_section','Add new section','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2187,1,'en','web','add_new_section','Add new section','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2188,1,'ar','web','section_name','Section name','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2189,1,'en','web','section_name','Section name','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2190,1,'ar','web','area','Area','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2191,1,'en','web','area','Area','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2192,1,'ar','web','select_other_day','Please select other day, because this day is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2193,1,'en','web','select_other_day','Please select other day, because this day is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2194,1,'ar','web','select_other_time','Please select other time, because this time is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2195,1,'en','web','select_other_time','Please select other time, because this time is closed by seller','2024-12-30 00:58:40','2024-12-30 00:58:40'),(2197,1,'en','web','dashboard','Dashboard','2025-01-02 05:56:29','2025-01-02 05:56:29');
/*!40000 ALTER TABLE `translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `unit_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `unit_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `unit_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unit_translations_unit_id_locale_unique` (`unit_id`,`locale`),
  KEY `unit_translations_locale_index` (`locale`),
  CONSTRAINT `unit_translations_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `unit_translations` WRITE;
/*!40000 ALTER TABLE `unit_translations` DISABLE KEYS */;
INSERT INTO `unit_translations` VALUES (1,1,'en','PCS');
/*!40000 ALTER TABLE `unit_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `position` enum('before','after') NOT NULL DEFAULT 'after',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'after','2024-12-30 00:58:40','2024-12-30 00:58:40');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_activities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL COMMENT 'click,read,listen and etc',
  `value` varchar(255) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `device` varchar(255) DEFAULT NULL,
  `agent` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`agent`)),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_activities_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `user_activities_user_id_foreign` (`user_id`),
  CONSTRAINT `user_activities_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_activities` WRITE;
/*!40000 ALTER TABLE `user_activities` DISABLE KEYS */;
INSERT INTO `user_activities` VALUES (1,'App\\Models\\Product',1,NULL,'click','2','122.167.255.240','WebKit','{\"device\":\"WebKit\",\"platform\":\"Windows\",\"browser\":\"Chrome\",\"robot\":false,\"deviceType\":\"desktop\",\"languages\":[\"en-us\",\"en\",\"pa\"],\"getUserAgent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/131.0.0.0 Safari\\/537.36\",\"ip\":\"122.167.255.240\"}','2025-01-22 07:34:41');
/*!40000 ALTER TABLE `user_activities` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_addresses` (
  `title` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address`)),
  `location` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`location`)),
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `firstname` varchar(255) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `zipcode` varchar(255) DEFAULT NULL,
  `street_house_number` varchar(255) DEFAULT NULL,
  `additional_details` varchar(191) DEFAULT NULL,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned DEFAULT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_addresses_user_id_foreign` (`user_id`),
  KEY `user_addresses_region_id_foreign` (`region_id`),
  KEY `user_addresses_country_id_foreign` (`country_id`),
  KEY `user_addresses_city_id_foreign` (`city_id`),
  KEY `user_addresses_area_id_foreign` (`area_id`),
  CONSTRAINT `user_addresses_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_addresses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_addresses` WRITE;
/*!40000 ALTER TABLE `user_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_addresses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_carts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cart_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `name` varchar(255) DEFAULT NULL,
  `uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_carts_cart_id_foreign` (`cart_id`),
  KEY `user_carts_user_id_foreign` (`user_id`),
  CONSTRAINT `user_carts_cart_id_foreign` FOREIGN KEY (`cart_id`) REFERENCES `carts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_carts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_carts` WRITE;
/*!40000 ALTER TABLE `user_carts` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_carts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_digital_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_digital_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `digital_file_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `downloaded` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_digital_files_digital_file_id_foreign` (`digital_file_id`),
  KEY `user_digital_files_user_id_foreign` (`user_id`),
  CONSTRAINT `user_digital_files_digital_file_id_foreign` FOREIGN KEY (`digital_file_id`) REFERENCES `digital_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_digital_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_digital_files` WRITE;
/*!40000 ALTER TABLE `user_digital_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_digital_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_points` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `price` double(20,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `user_points_user_id_foreign` (`user_id`),
  CONSTRAINT `user_points_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_points` WRITE;
/*!40000 ALTER TABLE `user_points` DISABLE KEYS */;
INSERT INTO `user_points` VALUES (1,102,0.00),(2,103,0.00),(3,104,0.00),(4,105,0.00),(5,106,0.00),(6,107,0.00),(7,108,0.00),(8,109,0.00);
/*!40000 ALTER TABLE `user_points` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `firstname` varchar(255) NOT NULL DEFAULT 'firstname',
  `lastname` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `gender` enum('male','female') NOT NULL DEFAULT 'male',
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `phone_verified_at` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `img` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `verify_token` varchar(255) DEFAULT NULL,
  `my_referral` varchar(255) DEFAULT 'xoB3nzSD',
  `referral` varchar(255) DEFAULT NULL,
  `firebase_token` longtext DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `r_count` double DEFAULT 0,
  `r_avg` double DEFAULT 0,
  `r_sum` double DEFAULT 0,
  `o_count` double DEFAULT 0,
  `o_sum` double DEFAULT 0,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_id` bigint(20) unsigned DEFAULT NULL,
  `lang` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_phone_unique` (`phone`),
  KEY `users_uuid_index` (`uuid`),
  KEY `users_currency_id_foreign` (`currency_id`),
  CONSTRAINT `users_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (102,'927f4e5b-dfe0-4162-8577-905485165a93','User','User','user@githubit.com','998911902595','1993-12-30','male','2024-12-30 00:58:40',NULL,NULL,1,NULL,'$2y$10$8Awe1ckoG.grG9B2zTkhoeq6mUylikbpJsPlApX1EwOlz2ymDjshC',NULL,'7N102ATP',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2024-12-30 00:58:41',NULL,NULL),(103,'22ab0041-ab87-4fcf-920a-14a05876dff6','Owner','Owner','owner@githubit.com','998911902696','1990-12-31','male','2024-12-30 00:58:41',NULL,NULL,1,NULL,'$2y$10$O9ejE4dh5GcsnVnwE/Enyu8N8BQ8/PdzdKkYbnWbGFxY58v6IB/HW',NULL,'OI103HPI',NULL,'[]',NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2025-01-22 01:53:20',NULL,NULL),(104,'4040fad0-5d08-4c6f-8f3d-cecef65eaff6','Manager','Manager','manager@githubit.com','998911902616','1990-12-31','male','2024-12-30 00:58:41',NULL,NULL,1,NULL,'$2y$10$hpC/OjlT1OrZ8eQxpfW.jumb3NZ1dH2AiVXaqTsLn72W1f.XNnsJy',NULL,'MK104LRZ',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2024-12-30 00:58:41',NULL,NULL),(105,'5d10d939-2bdf-4f70-a6eb-148bdca3a946','Moderator','Moderator','moderator@githubit.com','998911902116','1990-12-31','male','2024-12-30 00:58:41',NULL,NULL,1,NULL,'$2y$10$6prJ49UbLks5N8EWi6A37ORfFdRomyJI87xmOFXRQ6ROkR8FbrIey',NULL,'SL105CIZ',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2024-12-30 00:58:41',NULL,NULL),(106,'cf526659-9e7a-4311-80f1-61ad3737bd44','Delivery','Delivery','delivery@githubit.com','998911912116','1990-12-31','male','2024-12-30 00:58:41',NULL,NULL,1,NULL,'$2y$10$p44L30ngdt.gQY8DEV5vgOlGOccCmiOXPIlkj7P9.yn80nTEWLwYi',NULL,'EU106MFJ',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2024-12-30 00:58:41',NULL,NULL),(107,'baa92065-258b-47c1-8c42-e5ef15051ba2','sellers','sellers','sellers@githubit.com','998911902691','1990-12-31','male','2025-01-22 01:25:33','2025-01-22 01:25:33',NULL,1,NULL,'$2y$10$pmk0UKRnNe/2Q6MdOMDIv.WZ1xtk.ozsiobWKa4NhomDIwj5PJ5V.',NULL,'GG107RVQ',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 00:58:41','2025-01-22 01:25:33',NULL,NULL),(108,'d92c4f37-51e2-4d9c-9b2a-ec82b830e529','sunilshetty004@gmail.com',NULL,'sunilshetty004@gmail.com',NULL,NULL,'male',NULL,NULL,'122.162.169.180',1,NULL,NULL,'888441','VIF9YBWF',NULL,NULL,NULL,0,0,0,0,0,NULL,'2024-12-30 01:40:10','2025-01-03 01:44:01',NULL,NULL),(109,'8135ea64-2d77-48de-bf72-889775c2a05e','sunilshetty@gmail.com',NULL,'sunilshetty@gmail.com',NULL,NULL,'male',NULL,NULL,'122.162.169.180',1,NULL,NULL,'886448','TSKCDQQ9',NULL,NULL,NULL,0,0,0,0,0,NULL,'2025-01-03 01:10:48','2025-01-03 01:10:48',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `wallet_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wallet_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `wallet_uuid` char(36) NOT NULL,
  `transaction_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'topup',
  `price` double NOT NULL DEFAULT 0,
  `note` varchar(255) DEFAULT NULL,
  `status` enum('processed','paid','rejected','canceled') NOT NULL DEFAULT 'processed',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wallet_histories_uuid_unique` (`uuid`),
  KEY `wallet_histories_transaction_id_foreign` (`transaction_id`),
  KEY `wallet_histories_created_by_foreign` (`created_by`),
  KEY `wallet_histories_type_index` (`type`),
  CONSTRAINT `wallet_histories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `wallet_histories_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `wallet_histories` WRITE;
/*!40000 ALTER TABLE `wallet_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `wallet_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `wallets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wallets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `currency_id` bigint(20) unsigned NOT NULL,
  `price` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wallets_uuid_user_id_unique` (`uuid`,`user_id`),
  KEY `wallets_user_id_foreign` (`user_id`),
  KEY `wallets_uuid_index` (`uuid`),
  CONSTRAINT `wallets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `wallets` WRITE;
/*!40000 ALTER TABLE `wallets` DISABLE KEYS */;
INSERT INTO `wallets` VALUES (1,'251bd98e-034f-432c-aa99-53411eb2b2f1',102,2,0,'2024-12-30 00:58:41','2024-12-30 00:58:41'),(2,'e0c27220-ef07-4c89-94fb-f97759387a9d',103,2,0,'2024-12-30 00:58:41','2024-12-30 00:58:41'),(3,'fb02f0fd-d308-4507-b948-67026a5caa41',104,2,0,'2024-12-30 00:58:41','2024-12-30 00:58:41'),(4,'fa46309b-4467-4664-96ab-3979a075a5ac',105,2,0,'2024-12-30 00:58:41','2024-12-30 00:58:41'),(5,'a43d7a24-0999-402f-bf84-7b869784fc5e',106,2,0,'2024-12-30 00:58:41','2024-12-30 00:58:41'),(6,'90eabf7f-e5c7-459e-a87a-637ba6a735c3',107,2,0,'2024-12-30 00:58:41','2024-12-30 00:58:41');
/*!40000 ALTER TABLE `wallets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouse_closed_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_closed_dates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_closed_dates_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `warehouse_closed_dates_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouse_closed_dates` WRITE;
/*!40000 ALTER TABLE `warehouse_closed_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `warehouse_closed_dates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouse_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(255) NOT NULL,
  `title` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `warehouse_translations_warehouse_id_locale_unique` (`warehouse_id`,`locale`),
  KEY `warehouse_translations_locale_index` (`locale`),
  CONSTRAINT `warehouse_translations_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouse_translations` WRITE;
/*!40000 ALTER TABLE `warehouse_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `warehouse_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouse_working_days`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_working_days` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') NOT NULL,
  `from` varchar(5) NOT NULL DEFAULT '9:00',
  `to` varchar(5) NOT NULL DEFAULT '21:00',
  `disabled` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_working_days_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `warehouse_working_days_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouse_working_days` WRITE;
/*!40000 ALTER TABLE `warehouse_working_days` DISABLE KEYS */;
/*!40000 ALTER TABLE `warehouse_working_days` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warehouses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `region_id` bigint(20) unsigned NOT NULL,
  `country_id` bigint(20) unsigned NOT NULL,
  `city_id` bigint(20) unsigned DEFAULT NULL,
  `area_id` bigint(20) unsigned DEFAULT NULL,
  `address` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`address`)),
  `location` varchar(255) NOT NULL,
  `img` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouses_region_id_foreign` (`region_id`),
  KEY `warehouses_country_id_foreign` (`country_id`),
  KEY `warehouses_city_id_foreign` (`city_id`),
  KEY `warehouses_area_id_foreign` (`area_id`),
  CONSTRAINT `warehouses_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `warehouses_city_id_foreign` FOREIGN KEY (`city_id`) REFERENCES `cities` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `warehouses_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `warehouses_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warehouses` WRITE;
/*!40000 ALTER TABLE `warehouses` DISABLE KEYS */;
/*!40000 ALTER TABLE `warehouses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `whole_sale_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `whole_sale_prices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` bigint(20) unsigned NOT NULL,
  `min_quantity` int(11) NOT NULL DEFAULT 0,
  `max_quantity` int(11) NOT NULL DEFAULT 2147483647,
  `price` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `whole_sale_prices_stock_id_foreign` (`stock_id`),
  CONSTRAINT `whole_sale_prices_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `whole_sale_prices` WRITE;
/*!40000 ALTER TABLE `whole_sale_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `whole_sale_prices` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

